---
lang-ref: ch.01-2
lecturer: Yann LeCun
title: Sự phát triển, sử dụng CNN và Tại sao là học sâu?
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
translator: Huynh Nguyen
lang: vi
translator-date: 15 Oct 2020
---


## [Sự phát triển của CNNs](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

Trong bộ não động vật, tế bào thần kinh phản ứng lại với các cạnh có định hướng cụ thể. Các nhóm tế bào thần kinh phản ứng lại với các định hướng giống nhau được sao chép trên toàn bộ trường thị giác.

Fukushima (1982) đã xây dựng một mạng lưới thần kinh (NN) hoạt động theo cách giống như bộ não, dựa trên 02 khái niệm. Đầu tiên, các tế bào thần kinh được tái tạo trên toàn bộ trường thị giác. Thức hai, có những ô phức tạp tập hợp thông tin từ các ô đơn giản (đơn vị chọn lọc định hướng). Kết quả là, sự dịch chuyển của bức tranh sẽ thay đổi sự hoạt hóa của các ô đơn giản, nhưng sẽ không ảnh hưởng đến sự kích hoạt tích hợp của ô phức tạp (tích hợp chập).

LeCun (1990) đã sử dụng Backprop để huấn luyện CNN nhận dạng các chữ số viết tay. Có một bản thử nghiệm từ năm 1992, trong đó thuật toán nhận dạng các chữ số viết tay của bất kỳ kiểu nào. Thực hiện nhận dạng ký tự/ mẫu bằng cách sử dụng một mô hình được đào tạo từ đầu đến cuối là điều mới mẻ vào thời điểm đó. Trước đây, mọi người đã sử dụng trình trích xuất đặc trưng với mô hình được giám sát ở trên cùng.

Các hệ thống CNN mới này có thể nhận dạng nhiều ký tự trong ảnh cùng một lúc. Để làm điều đó, mọi người đã sử dụng một cửa sổ nhập liệu nhỏ cho CNN và trượt nó qua toàn bộ hình ảnh. Nếu nó được kích hoạt, nó có nghĩa là có một nhân vật cụ thể hiện diện.

Sau đó, ý tưởng này đã được áp dụng để phát hiện khuôn mặt người và phân đoạn ngữ nghĩa (phân loại theo pixel). Ví dụ bao gồm Hadsell (2009) và Farabet (2012). Điều này cuối cùng đã trở nên phổ biến trong công nghiệp, được sử dụng trong các ứng dụng Xe tự lái như theo dõi làn đường.

Các loại phần cứng đặc biệt để đào tạo CNN là một chủ đề nóng trong những năm 1980, sau đó sự quan tâm giảm xuống và bây giờ nó đã trở nên phổ biến trở lại.

Cuộc cách mạng học sâu (mặc dù thuật ngữ này chưa được sử dụng vào thời điểm đó) bắt đầu phổ biến vào năm 2010 - 2013. Các nhà nghiên cứu tập trung vào việc phát minh ra các thuật toán có thể giúp đào tạo các CNN lớn nhanh hơn. Krizhevsky (2012) đã đưa ra AlexNet, một CNN lớn hơn nhiều so với các CNN được sử dụng trước đây và đào tạo nó trên ImageNet (1,3 triệu mẫu) bằng cách sử dụng GPU. Sau khi chạy trong vài tuần, AlexNet đã đánh bại hiệu suất của các hệ thống cạnh tranh tốt nhất bằng một biên độ lớn - tỷ lệ lỗi top-5 là 25,8% so với 16,4%.

Sau khi chứng kiến ​​thành công của AlexNet, cộng đồng thị giác máy tính (CV) đã tin rằng CNN có tác dụng. Trong khi tất cả các bài báo từ năm 2011 - 2012 có đề cập đến CNN đều đã bị từ chối, kể từ năm 2016, hầu hết các bài báo CV được chấp nhận đều sử dụng CNN.

Trong những năm qua, số lượng các lớp được sử dụng ngày càng tăng: LeNet - 7, AlexNet - 12, VGG - 19, ResNet - 50. Tuy nhiên, có một sự cân bằng giữa số lượng hoạt động cần thiết để tính toán đầu ra, kích thước của mô hình và độ chính xác của nó. Vì vậy, một chủ đề phổ biến hiện nay là làm thế nào để nén mạng làm cho việc tính toán nhanh hơn.

## [Học sâu và trích xuất đặc trưng](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

Mạng đa lớp thành công vì chúng khai thác cấu trúc tổng hợp của dữ liệu tự nhiên. Trong cấu trúc phân cấp thành phần, sự kết hợp của các đối tượng tại một lớp trong cấu trúc phân cấp tạo thành các đối tượng ở lớp tiếp theo. Nếu chúng ta bắt chước hệ thống phân cấp này thành nhiều lớp và để mạng tìm hiểu sự kết hợp thích hợp của các đặc trưng, chúng ta sẽ có được cái gọi là kiến ​​trúc Học sâu. Do đó, mạng Học sâu có bản chất là thứ bậc.

Kiến trúc học sâu đã dẫn đến một tiến bộ đáng kinh ngạc trong các nhiệm vụ thị giác máy tính, từ xác định và tạo mặt nạ (mask) chính xác xung quanh các đối tượng đến xác định các thuộc tính không gian của một đối tượng. Kiến trúc Mask-RCNN và RetinaNet chủ yếu dẫn đến cải tiến này.

Các Mask-RCNN đã tìm thấy công dụng của chúng trong việc phân đoạn các đối tượng riêng lẻ, tức là tạo mặt nạ (mask) cho từng đối tượng trong một hình ảnh. Đầu vào và đầu ra đều là hình ảnh. Kiến trúc cũng có thể được sử dụng để phân đoạn cá thể, tức là xác định các đối tượng khác nhau của cùng một kiểu trong một hình ảnh. Detectron, một hệ thống phần mềm Nghiên cứu AI của Facebook (FAIR), thực hiện tất cả các thuật toán phát hiện đối tượng hiện đại này và là mã nguồn mở.

Một số ứng dụng thực tế của CNN là hỗ trợ Xe tự lái và phân tích hình ảnh y tế.

Mặc dù khoa học và toán học đằng sau việc học sâu đã được hiểu khá rõ ràng, nhưng vẫn còn một số câu hỏi thú vị cần được nghiên cứu thêm. Những câu hỏi này bao gồm: Tại sao các kiến ​​trúc có nhiều lớp hoạt động tốt hơn, với điều kiện là chúng ta có thể tính gần đúng bất kỳ hàm nào có hai lớp? Tại sao CNN hoạt động tốt với dữ liệu tự nhiên như giọng nói, hình ảnh và văn bản? Làm thế nào chúng ta có thể tối ưu hóa các hàm không lồi tốt như vậy? Tại sao kiến ​​trúc được tham số quá nhiều lại hoạt động?

Khai thác đối tượng bao gồm việc mở rộng kích thước biểu diễn sao cho các đối tượng được mở rộng có nhiều khả năng phân tách tuyến tính hơn; các điểm dữ liệu trong không gian có chiều cao hơn có nhiều khả năng bị phân tách tuyến tính hơn do số lượng mặt phẳng phân tách có thể tăng lên.

Những người thực hành máy học trước đây dựa vào chất lượng cao, được làm thủ công và các tính năng cụ thể của nhiệm vụ để xây dựng các mô hình trí tuệ nhân tạo, nhưng với sự ra đời của Học sâu, các mô hình có thể tự động trích xuất các tính năng chung. Dưới đây là một số cách tiếp cận phổ biến được sử dụng trong các thuật toán trích xuất đối tượng địa lý:

- Lát không gian
- Phép chiếu ngẫu nhiên
- Bộ phân loại đa thức (đặc trưng của các sản phẩm chéo)
- Các hàm cơ sở xuyên tâm
- Máy Kernel

Do tính chất tổng hợp của dữ liệu, các đối tượng địa lý đã học có một hệ thống phân cấp các biểu diễn với mức độ trừu tượng ngày càng tăng. Ví dụ:

-  Hình ảnh - Ở cấp độ chi tiết nhất, hình ảnh có thể được coi là pixel. Sự kết hợp của các pixel tạo thành các cạnh mà khi kết hợp sẽ tạo thành các văn bản (hình dạng nhiều cạnh). Các họa tiết tạo thành các họa tiết và các họa tiết tạo thành các phần của hình ảnh. Bằng cách kết hợp các phần này với nhau, chúng ta sẽ có được hình ảnh cuối cùng.
-  Văn bản - Tương tự, có một hệ thống phân cấp cố hữu trong dữ liệu văn bản. Các ký tự tạo thành từ, khi chúng ta kết hợp các từ với nhau, chúng ta sẽ có các nhóm từ, sau đó là các mệnh đề, sau đó bằng cách kết hợp các mệnh đề chúng ta sẽ có câu. Các câu cuối cùng cho chúng ta biết câu chuyện đang được truyền tải.
-  Giọng nói - Trong bài phát biểu, các mẫu soạn ra các dải, trong đó tạo âm, soạn âm, rồi âm vị, rồi cả từ, rồi đến câu, do đó thể hiện thứ bậc rõ ràng trong biểu diễn.

## [Học đại diện](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

Có những người bác bỏ học sâu: nếu chúng ta có thể tính gần đúng bất kỳ hàm nào có 2 lớp, tại sao lại có nhiều hơn?

Ví dụ: SVM tìm thấy một siêu phẳng phân tách "trong khoảng dữ liệu", có nghĩa là các dự đoán dựa trên so sánh với các ví dụ đào tạo. SVM về cơ bản là một mạng nơ-ron 2 lớp rất đơn giản, trong đó lớp đầu tiên xác định "mẫu" và lớp thứ hai là bộ phân loại tuyến tính. Vấn đề với ngụy biện 2 lớp là độ phức tạp và kích thước của lớp giữa là theo cấp số nhân $ N $ (để làm tốt một nhiệm vụ khó, cần RẤT NHIỀU mẫu). Nhưng nếu bạn mở rộng số lớp thành $ \ log (N) $, các lớp sẽ trở thành tuyến tính trong $ N $. Có sự đánh đổi giữa thời gian và không gian.

Một phép tương tự là thiết kế một mạch để tính toán một hàm boolean với không quá hai lớp cổng - chúng ta có thể tính bất kỳ hàm boolean nào theo cách này! Tuy nhiên, độ phức tạp và tài nguyên của lớp đầu tiên (số cổng) nhanh chóng trở nên kém khả thi đối với các chức năng phức tạp.

"Sâu" là gì?

- SVM không sâu vì nó chỉ có hai lớp
- Cây phân loại không sâu vì mọi lớp đều phân tích các tính năng (thô) giống nhau
- Một mạng sâu có nhiều lớp và sử dụng chúng để xây dựng **hệ thống phân cấp các tính năng ngày càng phức tạp**

Làm thế nào các mô hình có thể học các cách biểu diễn (các đặc trưng tốt)?

Giả thuyết đa dạng: dữ liệu tự nhiên sống trong một đa tạp chiều thấp. Tập hợp các hình ảnh có thể về cơ bản là vô hạn, tập hợp các hình ảnh "tự nhiên" là một tập hợp con nhỏ. Ví dụ: đối với hình ảnh của một người, tập hợp các hình ảnh có thể có theo thứ tự độ lớn của số lượng cơ mặt mà họ có thể di chuyển (bậc tự do) ~ 50. Một bộ trích xuất đối tượng lý tưởng (và không thực tế) đại diện cho tất cả các yếu tố của sự thay đổi (từng cơ, ánh sáng, v.v. ).

Hỏi và đáp từ cuối bài giảng:

- Đối với ví dụ về khuôn mặt, một số kỹ thuật giảm kích thước khác ( tức là PCA) có thể trích xuất các đặc trưng này không?
  - Trả lời: sẽ chỉ hoạt động nếu nhiều bề mặt là một siêu phẳng,
