---
lang-ref: ch.14-2
lang: tr
lecturer: Yann LeCun
title: Grafiksel Enerji-Bazlı Modeller
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
translation-date: 22 Aug 2020
translator: emirceyani
---

## Kayıp Fonksiyonlarının Karşılaştırılması

<!--
## Comparing Losses
<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center>
In the figure above, incorrect paths have -1.
Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small.
In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category.
Q: How is the segmentor implemented in the model above?
A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition.
-->

<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Ağ Mimarisi
</center>

Yukarıdaki figürde yanlış yollar -1 değerine sahiptir.

Profesör LeCun ilk olarak yukarıdaki Çizge Dönüştürücü Modelinde kullanılan algılayıcı *(perceptron)* kaybı ile başlıyor. Burada hedef, yanış cevapların enerjilerini büyütmek ve doğru cevapların enerjilerini küçültmektir.

Kodlarken, her bir oku bir vektör olarak düşünmelisiniz. Her bir kategori için ayrı bir oktan ziyade, tek bir vektör hem kategorileri hem de herbirk ategori için uygun skoru tutabilir.

Soru: Yukarıdaki modelde bölütleyici *(segmenter)* nasıl implement edilmiştir?

Cevap: Bölütleyici  önceden tanımlanmıştır. Model bölütleyicinin bu tanımına rağmen uçtan uca eğitilebilir hale getirilebilir. Bu el yapımı yaklaşımın yerini, karakter tanıma için kayan pencere yaklaşımı almıştır.

## Kayıp Fonksiyonlarına Genel bir Bakış
<!--## Overview of Losses
<center>
Table 1: Various Loss Equations
</center>
| Loss Equation | Formula  | Margin |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |
The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing.
* Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large.
Q: How may hinge be better than NLL loss?
A: Hinge is better than NLL becuase hinge will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m). 
-->

<center>
Tablo 1: Çeşitli Kayıp Fonksiyonları 
</center>

| Kayıp denklemi | Formül  | Marjin |
| :---- | :----: | ---:|
| Enerji kaybı | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Algılayıcı | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| menteşe  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |

Algılayıcı hatasının marjini sıfırdır, ve bu da fonksiyonun çökme riskinin olduğunu göstermektedir.
* Menteşe kaybı da ien istenmeyen cevap ile doğru cevabın enerjileri arasındaki farkı hesaplar. Mantıken, m marjini ile menteşe kaybı, doğru cevabın enerjisi en rahatsız edici cevabın enerjisinden _en az_ m daha düşük olduğundan 0 değerine ulaşacaktır.
* MCE kayıbı konuşma tanımada kullanılmakta olup, sigmoid e benzemektedir.
* NLL kaybı ise doğru cevabın enerjisini küçültürken, denklemi logaritmalı kısmının enerjisini de büyütmeye çalışır.

### TANIM:
Bir çözücü *(decoder)* seslerin veya görüntülerin skorları/enerjileri ifade eden vektörler dizisini girdi olarak alır, ve olabilecek en iyi çıktıyı seçer.
Soru: Çözücü kullanan problemlere örnek hangi problemler verilebilir ? 
Cevap: Dil modellemesi, makine tercümesi, ve dizi etiketleme.
<!--
### DEFINITION:
A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output.
Q: What are some examples of problems that can use decoders? 
A: Language modelling, machine translation, and sequence tagging. 
-->

## Çizge dönüştürücü ağlarında ileri algoritma

### Çizge Bileşimi

çizge bileşimi, iki çizgeyi birleştirmemizi sağlar. Bu örnekte bir dil modeli sözlüğü, $trie$ (bir çizge) ve bir sinir ağı ile üretilen bir tanımlama çizgesi ile ifade edilmektedir.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Şekil 2</b>: Çizge Bileşimi  
</center>

Tanımlama çizgesi, belli bir adımdaki karakterin ne kadar olası olduğunu fakrlı enerji değerleri ile ifade eder. 

Bu örnek için, çizge bileşim işlemiyle cevaplamaya çalıştığımız soru, algılama çizgesinde sözlüğümüzle bağdaşan en iyi yol nedir?

Algılama çizgesi ile gramer arasında, birinci adımdan ikinci adıma giderkenki ortak sıçrama, $c$ karakteri e bu karakterin enerjisi 0.4.  Bu yüzden, yorumlama çizgemiz, iki adım arasında $c$ karakterini temsil eden 1 tane ok bulundurur. Benzer bir biçimde, algılama çizgesinde 2. ve 3. adımlar arasındaki olası karakterler $x$, $u$ ve $a$. Gramer çizgesinde $c$ karakterini takip eden dallanmalar $u$ ve $a$'yı içerir. Yani çizge bileşimi, yorumlama çizgesinde $u$ ve $a$ nın bulunduğu okları seçer. Ayrıca tanıma grafiğinden kopyaladığı yayı enerji değerleri ile ilişkilendirir.

Eğer gramer oklara ait enerji değerlerini de içerseydi, çizge bileşimi bu enerji değerlerini eklerdi ve başka bir işlem aracılığıyla birleştirirdi.

Benzer bir biçimde, çizge bileşimi sinir ağlarıyla ifade edilen iki bilgi kaynağını da birleştirmemizi  desağlayabilir. Yukarıdaki örnekte, gramer aslında sonraki karakteri tahmin etmekte kullanılan bir sinir ağı gibi düşünülebilir. Sinir ağının softmax çıktısı bize verilen bir noktadan diğer karaktere geçiş olasılıklarını vericektir.

Yan not olarak, bu örnekteki dil modeli bir yapay sinir ağıdır, ve yapısı üzerinden geri yayılım gerççekleştirebiliriz. Bu da  döngüler , koşullar, özyinelemeler içeren programlar üzerinden geri yayılım yaapbildiğimiz türevlenebilen programlara bir örnektir.

<!-- ## Forward algorithm in Graph Transformer Networks
### Graph Composition
Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2</b>: Graph Composition
</center>
The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step.
Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon?
The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values. 
If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator.
In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node.
As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc.-->

### 90'ların ortasından kalma bir okuyucu <!--
The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Check reader
</center>
This recognition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations.
The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation.
Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches.
-->

Bir okuyucunun 90'ların ortasından kalma mimarisi oldukça karmaşıki fakat bizi ilgilendiren kısım, algılama çizgesini oluşturan karakter algılayıcıdan başlayan kısım.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Okuyucu 
</center>

Algılama çizgesi iki ayrı birleştirme işleminden geçer: biri doğru yorumlama( veya gerçek doğruluk) ile ve ikincisi ise tüm olası yorumlamaların çizgesini oluşturan gramer ile. 

Tüm sistem, negative log-olabilirlik kayıp fonksiyonuyla eğitildi. Negatif log-olabilirlik, yorumlama çizgesindeki her bir yol aslında olası bir yorumlama olup o yoldaki enerjilerin toplamı açıklamanın enerjisini verir.

Viterbi algoritmasının yerine ileri algoritmayı kullanacağız. Sonraki ksıımlar, bu iki yöntemin farkını anlatmakta.

#### Viterbi algoritması

<!--
#### Viterbi algorithm
Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph.
$$F (x, y) = \min_{z} \; E(x, y, z)$$ -->

Viterbi algoritması, verilen bir çizgede en olası yolu(veya minimum emerjiye sahip yolu) bulmak için kullanlan bir dinamik programlama algoritmasıdır. Enerjiyi çizgede aldığımız yolu ifade eden saklı değişken z'ye göre minimize eder.
$$F (x, y) = \min_{z} \; E(x, y, z)$$  


#### İleri algoritma *(The forward algorithm)*

<!--
#### The forward algorithm
The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below:
$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$
This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way.
The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph.
The working of the forward algorithm can be shown using the following example defined on an interpretation graph.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center>
The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example.
For the red node, the value of energy at the node is given by:
$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$
-->

İleri algoritma, tüm yollardaki negatif enerjilerin log-toplam-exponansiyeli aşağıdaki gibi hesaplar:  
$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

Diğer bir değişle, saklı değişken z üzerinden marjinalleştirme gerçekleştiriyor, bu işlem de algılama çizgesindeki yolları tanımlamamızı sağlıyor. Bu yöntem ile belli bir noktaya giden tüm yolların log-toplam-exponansiyelini hesaplar. Bu tüm olası yolların bedellerini narin bir şekilde toplamak gibi.

İleri algoritmanın implementasyonu basit ve viterbi algoritmasından daha verimlidir. Ayırca, çizgedeki ileri algoritmanın düğümü üzerinden geri yayılım gerçekleştirebiliriz.

İleri algoritmanın çalışmasını aşağıda tanımlanmış olan yorumlama çizgesinde görebiliriz.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Şekil 4</b>: Yorumlama çizgesi
</center>

Girdi noktasından kırmızı gölgeli noktaya olan hasar, kırmızı noktaya varan tüm yollar üzerinden marjinalleştirerek hesaplanır. Kırmızı noktaya giren tüm oklar, örneğimizdeki tüm olası yolları ifade eder.

Kırmızı nokta için enerji aşaıdaki gibidir:
$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$


#### İleri algoritmanın Sinir Ağı Benzetmesi

Yapının altında yatan çizge zincir yapısına sahip ise, ileri algoritma aslında inanç yayılım *(belief propagation)* algoritmasının özel durumudur. Bu algoritma aslında ileri beslemeli sinir ağı gibi düşünülebilir: her bir noktada log-toplam-exponansiyel ve bir toplama işlemi var.

Yorumlama çizgesindeki her bir düğüm için bir $\alpha$ değişkeni tutuyoruz:

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

burada $e_{ki}$  $k$  noktasından $i$ noktasına giden okun enerjisidir.. 

$\alpha_i$, sinir ağındaki $i$ düğümünün aktivasyonunu oluştururken $e_{ki}$ ise $k$ ve $i$ düğümleri arasındaki ağırlığı ifade eder. Bu formülasyon cebirsel olarak sinir ağlarındaki ağırlıklı toplamaya denktir, ama logaritmik uzayda. 

İleri algoritmayı uyguladığımız dinamik yorumlama ağı (örnekle değişmekte) üzerinden geriyayılım gerçekleştirebiliriz. $F(x,y)$'nin çizgenin son noktasından hesaplanan ve  $e_{ki}$ ağrılıklarına göre gradyanlarını hesaplayabiliriz.

<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Şekil 5</b>: Okuyucu
</center>

Okuyucu örneğinde ileri algoritmayı iki çizgenin bileşimini uygular ve son noktanın enerjisini log-toplam-exponansiyel işlemi uygulayarak ile elde edebiliriz. Enerji değerlerinin arasındaki fark bize negatif log-olabilirlik kaybını verir. 

Çizge bileşimine uygulanan ileri algortima sonucu elde ettiğimiz değer, doğru cevabın log-toplam-exponansiyelidir. Hatta, çizge algılama çizgesi ile gramerin bileşiminin son noktasının log-toplamexponansiyeli aslında tüm olası yorumlamalar üzerinde marjinalize edilmiştir.

<!--#### Neural network analogy of forward algorithm
The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term. 
For each node in the interpretation graph, we maintain a variable $\alpha$.
$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$
where $e_{ki}$ is the energy of the link from node $k$ to node $i$. 
$\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain.
We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph.
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center>
Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss.
The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations. -->

# Geri yayılımın Lagrangian formülasyonu

Girdi $x# ve hedef çıktı $y$ için ağımızı fonksiyonların kolleksiyonu $f_k$ ve ağırlıklar $w_k$ ile ifade edebilir ve ağın çıktısı $z_k$'yı  ardışık adımlar ile $z_{k+1} = f_k(z_k, w_k)$ modelleyebiliriz. Denetimli öğrenmede ağın amacı $C(z_n, y)$2i minimize etmek yani n'inci çıktının gerçek doğruya göre bedelini küçültmek. Bu problem, $C(z_n, y)$'yi sınırlamalarımız $z_{k+1} = f_k(z_k, w_k)$  ve  $z_0 = x$'ye göre minimize etmeye denktir. 

Lagrangian aşağıdaki gibi yazılabilir:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$

burada $ \lambda $ Lagrange çarpanlarını ifade etmekte  (Hatırlama amaçlı [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) yardımcı olacaktır).

$\mathcal{L}$'yi minimize etmek için,  $\mathcal{L}$'nin her bir argümanına göre olan kısmi türevlerini sıfıra eşitleyip çözmeliyiz.
- Lagrange çarpanı $\lambda$ için, sınırlamayı elde ederiz: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- $z_k$ için, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, bu da bildiğmiiz geri yayılımın formülüdür.

Bu yöntem, klasik mekanikte Lagrange ve Hamilton tarafından bulunmuştur ve bu alanda sistemin enerjisini minimize etmeye çalışırken $\lambda$ terimleri sistemin fiziksel sınırlarını ifade etmek için (örneğin iki topun metal bir çubukla tutturulması nedeniyle birbirinden sabit bir mesafede kalmaya zorlanması) kullanılmakta. 
Eğer her bir zaman adaımında  kaybımız $C$'yi minimize etmemiz gerekirse yeni Lagrangian'ımız aşağıdaki gibidir:
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$. -->t

<!--# Lagrangian formulation of Backpropagation
For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$.
The Lagrangian can be written:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago).
To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve.
- For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula.
This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example.
In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$. -->

# Neural Diferansiyal Denklemler 

Geri yayılımın bu formülasyonu ile, yeni bir model üzerine konuşabiliriz. Neural Diferansiyel denklemler *(Neural ODE)*'ler, yinelemeli sinir ağları olup, durumu $z$'nin $t$ zamanındaki 
$z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, burada $ W$ bazı sabit parametreleri temsil etmekte. Bu yapı, diferansiyel denklemler ile ifade edilebilir (parçalı türev yok ): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

Böyle bir ağı Lagrangian formülasyonu ile eğitmek oldukça kolay. Eğer hedefimiz $y$ varsa ve sistemin $T$ sürede hedefimize ulaştığı durumu istiyorsak yapmamız gereken tek şey $z_T$ ve $y$ arasındaki mesafeyi bedel fonksiyonu olarak tanımlamaktır. Bu ağların başşka bir amacı da ssitemin kararlı *(stable)* bir durumunu bulmak, yani belli bir noktadan sonra değişmeyen durumlar. Matematiksel olarak bu özelliğin sağlanması için $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$ koşulu sağanmalı. Denklemin çözümü $y$yi bulmak zaman üzerinden geriye yayılım yapmaktan çok daha kolaydır çünkü ağın tüm diziye göre gradyanı hatırlama ihtiyacı yokrı  ve sadece $f$'i veya  $\lvert f \rvert^2$'yi minimize etmemiz yeterli olucaktır. Neural ODE'lerin eğitimi için  [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf) yararlı bir kaynak.
<!--# Neural Ordinary Differential Equation
Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.
Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, *i.e.* one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf). -->

# Enerjiler Üzerinden Değişimsel Çıkarım

## Giriş  

<!--
# Variational Inference in terms of Energy
## Introduction
For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute
$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$
If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.
We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.
--> 

Enerji fonksiyonu $E(x,y,z)$ için, eğer sadece $x$ ve $y$ üzerinden bir kayba yani z değişkeni üzerinden marjinalize etmemiz gerekiyorsa, hesaplamamız gereken fonksiyon

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

Sonra $\frac{q(z)}{q(z)}$ ile çarparsak, $L(x,y)$ aşağıdaki gibi yeniden yazılabilir.
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

Eğer $q(z)$ z üzerinde bir olasılık dağılımı ise, yeniden yazdığımı hata fonksiyonu integralini  $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$ dağılımına göre ortalama bir değer gibi görebiliriz.

Bu yaklaşımı, Jensen eşitsizliğini ve örnekleme bazlı yaklaşımları, hata fonksiyonumuzu dolaylı bir şekilde optimize etmek için kullanacağız.

<!--
# Variational Inference in terms of Energy
## Introduction
For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute
$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$
If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$.
We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function.
--> 
## Jensen Eşitsizliği

<!--
## Jensen's Inequality
Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive:
<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>
Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$,
$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$
Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,  
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$
If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that
$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$
Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$
$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$
$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$
$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$
Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$.
-->

Jensen Eşitsizliği geometrik bir gözlem olup şu söylemi ifade eder: Eğer konveks bir fonksiyonumuz varsa, o fonksiyonun  bir bölgedeki ortalamada daldığı değer  fonksiyonun aynı bölgedeki averajından küçük olacaktır. Geometrik olarak düşünürsek:

<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen Eşitsizliği ( [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality)'dan alınmıştır)
</center>

Aynı şekilde, eğer $F$ sabit bit olaslılık dağılımı olan $q$ 'ya göre konveks ise , $z$'nin aralığı için Jensen'in Eşitsizliğ'nden:
$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$
Şimdi, $\frac{q(z)}{q(z)}$ ile çarğtıktan sonra marjinalleştirilmiş $L(x,y)$'yi inceleyelim:  

$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

Eğer $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$ ise, Jensen eşitsizliğinden
$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$
Şimdi, örnek olarak, konveks bir kayıp fonksiyonu $F(x) = -\log(x)$  ile çalışalım:
$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$
$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$
$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

Güzel! Artık elimizde hata fonksiyonumuz $L(x,y)$ için bir üst sınıra sahibiz ve bu sınır bildiğimiz iki terimden oluşmakta. İlk terim $\int_z q(z)E(x,y,z)$ *ortalama* enerjidir. İkinici terim $\frac{1}{\beta}\int_z\log(q(z))$ ise sadece faktör($-\frac{1}{\beta}$) ile dağılım $q$'nun *entropi*sinin çarpımıdır.


## Amaç?

<!--## What's the point?
We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice!
To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s.
The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$.
Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$. -->

Şimdi, karmaşık integrallerden kaçınabileceğimiz ve bunun yerine kendi seçtiğimiz bir dağılımdan ($q(z)$) örnekleyerek integralleri yaklaşık olarak tahmin edebileceğimiz bir şekilde bir üst sınır bulduk!

Üst sınır fonksiyonunun ilk teriminin değeri için, önce o dağılımdan örnek alıyor sonra bu örnek ile $L$'nin ortalama değerini hesaplıyoruç

İkinci terim (entropi faktörü) ise seçtiğimiz dağılım sonucu ortaya çıkmıştır, ve $q$'dan rastgele örnekler çekerek yakınsayabiliriz.

Son olarak, $L$'yi parametrelerine göre minimize etmek için  $L$ yi yukarıdan sınırlayan fonksiyonu minimize etmemiz yeterli olucaktır. Bu işlem için iki değişkenimizi güncelliyporuz: (1) $q$'nun entropisi ve (2) model parametreleri $W$.

## Özet

<!--
##Summary
This is the “energy view” of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about.
-->

Burada değişimsel çıkarımın *(variational inferece)* "enerji" açısından ele aldık. Eğer exponensiyallerin toplamının logiatmasını hesaplamanız gerekiyorsa, foksiyonun ortalaması ile entropy terimini dikakte almamız yeterlidir. Bu bize bir üst sınır vericektir. Sonra, bu üst sınırı minimize ederek aslında istediğimiz fonksiyonu da minimize etmiş oluyoruz.
