---
lang-ref: ch.14-1
lang: tr
lecturer: Yann LeCun
title: Yapılandırılmış Kestirim için Derin Öğrenme
authors: Junrong Zha, Muge Chen, Rishabh Yadav, Zhuocheng Xu
date: 4 May 2020
translation-date: 22 Aug 2020
translator: emirceyani
---

## Yapılandırılmış Kestirim *(Structured Prediction)*

Burada problemimiz, skaler, ayrık veya gerçek değerler yerine karşılıklı bağımlı ve sınırlandırılmış belirli bir x girdisi verildiğinde çıktı y'yi elde etmektir. Çıktı değişkeni tek bir kategoriye ait olmayıp üstel veya sonsuz sayıda olası değere sahiptir.
Örnek olarak, konuşma/el yazısı tanımada veya doğal dil işlemede, çıktının gramer bakımından doğru olması gerekiyor ve çıktı olasılıklarının sayısını sınırlamamız mümkün değil. Modelin görevi, problemdeki sıralı, uzaysal veya kombinasyonel yapıyı öğrenebilmektir.

<!--
## Structured Prediction
It is the problem of predicting variable y for a given input x which is mutually dependent and constrained rather than scalar discrete or real values. The output variable does not belong to a single category but can have exponential or infinite possible values.
For eg: In case of speech/handwriting recognition or natural language translation, the output needs to be grammatically correct and it is not possible to limit the number of output possibilities. The task of the model is to capture the sequential, spatial, or combinatorial structure in the problem domain.
-->

### Yapılandırılmış kestirim üzerine ilk çalışmalar

<!--
### Early works on structured prediction
This vector is fed to a TDNN which gives a feature vector which in case of model systems can be compared to softmax that represents a category. One problem that arises in the case of recognizing the word that was pronounced is different people can pronounce the same word in different ways and speed. To solve this Dynamic Time Warping is used.
The idea is to provide the system with a set of pre-recorded templates that correspond to sequence or feature vectors that were recorded by someone. The neural network is trained at the same time as the template so that the system learns to recognize the word for different pronunciations. The latent variable allows us to timewarp the feature vector so as to match the length of the templates.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Figure 1.
</center>
This can be visualized as a matrix by arrranging the feature vectors from TDNN horizontally and the word templates vertically. Each entry in the matrix corresponds to the distance between the feature vector. This can be visualized as a graph problem where the aim is to start from the bottom left-hand corner and reach the top right corner by traversing the path that minimizes the distance.
To train this latent variable model we need to make the energy for the correct answers as small as possible and larger for every incorrect answer. To do this we use an objective function that takes in templates for wrong words and pushes them away from the current sequence of features and backpropagates the gradients.
-->

Girdiyi ifade eden vektörümüzü Zaman Kayması Sinir Ağı'na *(Time Delay Neural Network, TDNN)* gönderip bir öznitelik vektörü elde ederiz ki bu vektörü sonra  bir kategoriyi temsil eden softmax ile karşılaştırabilelim. Söylenen bir kelimeyi tanımlarken karşımıza çıkabilecek bir sorun ise aynı kelimeyi farklı kişilerin farklı şekillerde ve hızlarda söyleyebilmesidir. Bu sorunu çözmek için Dinamik Zaman Yamultması *(Dynamic Time Warping)* kullanılmıştır.

Buradaki ana fikir, sisteme, biri tarafından kaydedilmiş dizi veya öznitelik vektörlerine karşılık gelen önceden kaydedilmiş kalıpları vermek. Sinir ağı, kalıpla aynı anda eğitiliyor ki sistem kelimenin değişik telaffuzlarını öğrensin. Saklı değişken, öznitelik vektörünü, kalıpların uzunluğuyla eşleştirebilelim diye öznitelik vektörünün zamanını büzmemize *(timewarp)* olanak sağlar.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig1.png" style="background-color:#DCDCDC;" /><br>
Şekil 1
</center>

Bu durumu, TDNN yapısından elde ettiğimiz öznitelik vektörlerini yatay olarak ve kelime kalıplarını dikey olarak yerleştirdiğimiz bir matris olarak görselleştirebiliriz. Bu matrisin her bir girdisi öznitelik vektörleri arasındaki mesafeye denktir. Bu matrisi de sol alt köşeden sağ üst köşeye giderken mesafeyi minimize ettiğimiz bir çizge (graf) problemi olarak düşünebiliriz. 

Saklı değişken modelini eğitebilmek için, doğru cevapların enerjisini olabildiğince küçültmemiz ve tüm yanlış cevaplar için ise olabildiğince büyütmemiz gerekir. Bunun için, yanlış kelimelerin kalıplarını o anki öznitelik dizilerinden uzaklaştıran ve gradyanları geri yayan bir objektif fonksiyonu kullanmamız gerekir.

## Enerji bazlı faktör çizgeleri *(Energy based factor graphs)*

<!--
## Energy based factor graphs
The idea behind energy-based factor graphs is to build an energy-based model in which the energy is sum of partial energy terms or when the probability is a product of factors. The benefit of these models is that efficient inference algorithms can be employed.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Figure 2.
</center>
-->

Bu yapıların ardındaki ana fikir, enerjinin kısmi enerji terimlerinin toplamı veya olasılığın faktörlerin bir ürünü olduğu enerji bazlı bir model oluşturmaktır. Bu modellerin yararı ise verimli çıkarım algoritmaları kullanabilmemizdir.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig2.png" style="background-color:#DCDCDC;" /><br>
Şekil 2
</center>

### Dizi Etiketleme *(Sequence Labeling)*

Model, konuşma sinyali X'i girdi olarak alır ve etiketleri Y'yi, toplam enerjiyi minimize edecek biçimde, çıktı olarak verir.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Şekil 3
</center>
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Şekil 4
</center>
Bu durumda, enerji mavi karelerle ifade edilen üç terimin toplamıdır ve mavi kareler girdi değişkenleri için öznitelik vektörleri üreten sinir ağlarıdır. Konuşma tanımada, X konuşma sinyali olarak düşünülürken kare kutular gramer sınırlamalarını ve Y ise üretilen etiket çıktılarını ifade etmektedir.

<!--
### Sequence Labeling
The model takes an input speech signal X and output the labels Y such that the output labels minimize the total energy term.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig3.png" style="background-color:#DCDCDC;" /><br>
Figure 3.
</center>
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig4.png" style="background-color:#DCDCDC;" /><br>
Figure 4.
</center>
In this case, the energy is a sum of three terms represented by blue squares which are neural networks that produce feature vectors for the input variables. In the case of speech recognition X can be thought of as a speech signal and the squares implement the grammatical constraints and Y represent the generated output labels.
-->



## Enerji Bazlı Faktör Çizgelerinde Verimli Çıkarım


<!--## Efficient Inference for Energy-Based Factor Graphs
A Tutorial on Energy-Based Learning (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, and Fu Jie Huang 2006):
Learning and inference with Energy-Based Models involves a minimization of the energy over the set of answers $\mathcal{Y}$ and latent variables $\mathcal{Z}$. When the cardinality of $\mathcal{Y}\times \mathcal{Z}$ is large, this minimization can become intractable. One approach to the problem is to exploit the structure of the energy function in order to perform the minimization efficiently. One case where the structure can be exploited occurs when the energy can be expressed as a sum of individual functions (called factors) that each depend on different subsets of the variables in Y and Z. These dependencies are best expressed in the form of a factor graph. Factor graphs are a general form of graphical models, or belief networks.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Figure 5.
</center>
A simple example of a factor graph is shown in Figure 19 (top). The energy function is the sum of four factors:
$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$
where $Y = [Y_1, Y_2]$ are the output variables and $Z = [Z_1, Z_2]$ are the latent variables. Each factor can be seen as representing soft constraints between the values of its input variables. The inference problem consists in finding:
$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$
Let’s assume that $Z_1$, $Z_2$, and $Y_1$ are discrete binary variables, and $Y_2$ is a ternary variable. The cardinality of the domain of $X$ is immaterial since X is always observed. The number of possible configurations of $Z$ and $Y$ given X is $2 \times 2 \times 2 \times 3 = 24$. A naive minimization algorithm through exhaustive search would evaluate the entire energy function 24 times (96 single factor evaluations).
However, we notice that for a given $X$, $E_a$ only has two possible input configurations: $Z_1 = 0$ and $Z_1 = 1$. Similarly, $E_b$ and $E_c$ only have 4 possible input configurations, and $E_d$ has 6. Hence,
there is no need for more than $2 + 4 + 4 + 6 = 16$ single factor evaluations.
Hence, we can precompute the 16 factor values, and put them on the arcs in a trellis as shown in Figure 19 (bottom).
The nodes in each column represent the possible values of a single variable. Each edge is weighted by the output energy of the factor for the corresponding values of its input variables. With this representation, a single path from the start node to the end node represents one possible configuration of all the variables. The sum of the weights along a path is equal to the total energy for the corresponding configuration. Therefore, the inference problem can be reduced to searching for the **shortest path** in this graph. This can be performed using a dynamic programming method such as the Viterbi algorithm, or the A* algorithm. The cost is proportional to the number of edges (16), which is exponentially smaller than the number of paths in general.
To compute $E(Y, X) = \min_{z\in Z} E(Y, z, X)$, we follow the same procedure, but we restrict the graph to the subset of arcs that are compatible with the prescribed value of $Y$.
The above procedure is sometimes called the min-sum algorithm, and it is the log domain version of the traditional max-product for graphical models. The procedure can easily be generalized to factor graphs where the factors take more than two variables as inputs, and to factor graphs that have a tree structure instead of a chain structure.
However, it only applies to factor graphs that are bipartite trees (with no loops). When loops are present in the graph, the min-sum algorithm may give an approximate solution when iterated, or may not converge at all. In this case, a descent algorithm such as simulated annealing could be used.-->


Enerji Bazlı Öğrenmeye Giriş (Yann LeCun, Sumit Chopra, Raia Hadsell, Marc’Aurelio Ranzato, ve Fu Jie Huang, 2006):

Enerji bazlı modellerde öğrenme ve çıkarım, enerjinin cevaplar $\mathcal{y}$ ve saklı değişkenler kümesi $\mathcal{z}$ üzerinden minimizasyonuyla gerçekleşir. Kartezyen çarpım $\mathcal{y}\times \mathcal{z}$'nin kardinalitesi büyük ise, bu minimizasyon kontrol edilemez hale gelebilir. Bu probleme bir çözüm, enerji fonksiyonunun yapısını kullanarak minimizasyonu verimli bir şekilde gerçekleştirmektir. Yapının kullanılabildiği bir durum, enerjinin her biri Y ve Z'deki değişkenlerin farklı altkümelerine bağlı bireysel fonksiyonların (faktörler) toplamı olarak ifade edilebildiği zaman ortaya çıkar. Bu ihtiyaçlar en iyi şekilde faktör çizgesi *(factor graph)* ile ifade edilebilir. Faktör çizgeleri, grafik modellerinin genelleştirilmiş hali veya inanç ağlarıdır*(belief networks)*.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig5.png" style="background-color:#DCDCDC;" /><br>
Şekil 5
</center>

Şekil 5'te faktör çizgesi için bir örnek görebilirsiniz. Enerji fonksiyonu, 4 adet faktörün toplamı olarak ifade edilmektedir:

$$E(Y, Z, X) = E_a(X, Z_1) + E_b(X, Z_1, Z_2) + E_c(Z_2, Y_1) + E_d(Y_1, Y_2)$$

burada $Y = [Y_1, Y_2]$ çıktı değişkenleri ve  $Z = [Z_1, Z_2]$ ise saklı değişkenleri ifade etmektedir. Her bir faktörü, girdi değişkenlerinin değerleri arasında tanımlı, hafif bir sınırlama olarak düşünebiliriz. Çıkarım problemini matematiksel olarak ifade etmek gerekirse: 

$$(\bar{Y}, \bar{Z})=\operatorname{argmin}_{y \in \mathcal{Y}, z \in \mathcal{Z}}\left(E_{a}\left(X, z_{1}\right)+E_{b}\left(X, z_{1}, z_{2}\right)+E_{c}\left(z_{2}, y_{1}\right)+E_{d}\left(y_{1}, y_{2}\right)\right)$$

$Z_1$, $Z_2$, ve $Y_1$ ayrık ikili değişkenler ve $Y_2$'yi de üçlü değişken olarak sayalım. $X$ kümesinin kardinalitesi önemsizdir çünkü X her zaman gözlemlenebilmektedir. X bilindiğinde $Z$ ve $Y$'nin olası konfigürasyonlarının sayısı $2 \times 2 \times 2 \times 3 = 24$'tür.  Naif bir minizasyon algoritması, kapsamlı bir arama ile tüm enerji fonksiyonunu 24 kere (96 tane faktör hesaplaması) hesaplar.

Fakat, bize verilen $X$ ve $E_a$ sadece iki olası girdi konfigürasyonuna sahip: $Z_1 = 0$ ve $Z_1 = 1$. Aynı şekilde, $E_b$ ve $E_c$ sadece 4 ve $E_d$ sadece 6 olası girdi konfigürasyonuna sahiptir. Böylece, sadece $2 + 4 + 4 + 6 = 16$ faktör hesabı yeterli olacaktır.

Bu yüzden, önceden 16 faktör değerini hesaplayıp onları aşağıdaki Şekil 5'teki trellis diyagramındaki kavislerin üzerine yerleştirebiliriz.

Her bir sütundaki nokta *(node)*, bir değişkenin olası değerlerini temsil eder. Her bir ayrıt *(edge)* ise faktörün girdisi olan değişkenlerin değerleri için açığa çıkan enerjiyle orantılıdır. Bu gösterim sayesinde, başlangıç noktasından bitiş noktasına olan bir yol, tüm değişkenlerin olası bir konfigürasyonunu temsil eder. Yol üzerindeki ağırlıkların toplamı, o konfigürasyonun toplam enerjisine eşittir. Böylelikle, çıkarım problemi, çizge üzerindeki **en kısa yolu** bulma problemine dönüşür. Bu problemi, bir dinamik programlama yöntemi olan Viterbi algoritmasını veya A* algoritmasını kullanarak çözebiliriz. Bedelimiz, yolların toplam sayısından oldukça küçük olan, ayrıtların sayısıyla (16) doğru orantılıdır.

$E(Y, X) = \min_{z\in Z} E(Y, z, X)$'yi hesaplamak için aynı prosedürü kullanacağız; fakat burada çizgemizi $Y$'nin önceden belirlenmiş değeriyle uyumlu olan  kavislerin alt kümesiyle sınırlandırıyoruz.

Yukarıdaki prosedür bazen min-sum algoritması olarak da adlandırılır, ve grafik modelleri için kullanılan max-product algoritmasının logaritmik versiyonudur. Prosedür rahatlıkla faktörlerin girdi olarak ikiden fazla değişken aldığı aldığı faktör çizgelerine ve zincir yapısı yerine ağaç yapısına sahip olan faktör çizgelerine de genellenebilir.

Fakat, prosedür, sadece ikili ağaçlar (döngüleri olmayan) şeklinde olan faktör çizgelerine uygulanabilir. Eğer çizgede döngüler varsa, min-sum algoritması ya yaklaşık bir sonuç verir ya da sonuç veremez. Bu tarz bir durumda, benzetimli tavlama *(simulated annealing)* gibi bir iniş algoritması kullanılır.

## Sığ Faktörler ile Basit Enerji Bazlı Faktör Çizgeleri

<!--## Simple Energy-Based Factor Graphs with “Shallow” Factors
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Figure 6.
</center>
The factor graph shown in Figure 20 is a log domain factor graph for linear structured models ("simple energy-based factor graphs" we are talking about)
Each factor is a linear function of the trainable parameters. It depends on the input $$ and on a pair of individual labels $(Y_m, Y_n)$. In general, each factor could depend on more than two individual labels, but we will limit the discussion to pairwise factors to simplify the notation:
$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$
Here $\mathcal{F}$ denotes the set of factors (the set of pairs of individual labels that have a direct inter-dependency), $W_{m n}$ is the parameter vector for factor $(m, n),$ and $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ is a (fixed) feature vector. The global parameter vector $W$ is the concatenation of all the $W_{m n}.$
And then we can think about like what type of loss function. Here comes several different models.-->

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig6.png" style="background-color:#DCDCDC;" /><br>
Şekil 6
</center>

Yukarıdaki faktör çizgesi, linear yapılandırılmış modeller için logaritmik bir faktör çizgesini göstermektedir (basit enerji bazlı faktör çizgeleri).

Her bir faktör, eğitilebilen parametrelerde tanımlı bir doğrusal fonksiyondur. Faktörler, girdi $x$ ve ikili etiket çiftleri $(Y_m, Y_n)$'ne bağlıdır. Genelde, her bir faktör, ikiden fazla etikete bağlı olabilir; ancak notasyonu basitleştirmek için tartışmayı ikili faktörlerle sınırlayacağız:

$$E(W, Y, X)=\sum_{(m, n) \in \mathcal{F}} W_{m n}^{T} f_{m n}\left(X, Y_{m}, Y_{n}\right)$$

Burada, $\mathcal{F}$ faktörlerin kümesini (birbirlerine doğrudan bağlı etiket ikililerinin kümesi), $W_{m n}$ faktör $(m, n)$ için tanımlı olan parametre vektörünü ve $f_{m n}\left(X, Y_{m}, Y_{n}\right)$ ise (sabit) öznitelik vektörünü temsil etmektedir. Global parametre vektörü $W$ ise tüm $W_{m n}$'lerin birleştirilmesiyle oluşturulur. 

Sonrasında, farklı yitim fonksiyonları hakkında düşünebiliriz. Şimdi farklı değişik modellere değineceğiz.


### Koşullu Rastgele Alanlar *(Conditional Random Fields)*

Negatif logaritmik olabilirlik yitim fonksiyonunu lineer yapılandırılmış bir model eğitirken kullanabiliriz. Buna da koşullu rastgele alanlar *(conditional random fields)* adını veriyoruz. Burada doğru cevabın enerjisinin düşük ve iyi olanın da dahil olduğu tüm cevapların üsselinin logaritmasının büyük olmasını istiyoruz. 

Negatif logaritmik olabilirlik yitim fonksiyonun tanımı aşağıdaki gibidir:

$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$ 

<!--
### Conditional Random Field
We can use the negative log-likelihood loss function to train a linear structured model.
This is the Conditional Random Field
The intuition is we want the energy of the correct answer to below and want the log of exponential for all the answers, including the good one, to be large.
Below is the formal definition for the negative log-likelihood loss function:
$$\mathcal{L}_{\mathrm{nll}}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)+\frac{1}{\beta} \log \sum_{y \in \mathcal{Y}} e^{-\beta E\left(W, y, X^{i}\right)}$$ -->


### Maksimum Marjin Markov Ağları ve Saklı SVM

Menteşe yitimi *(Hinge loss)* fonksiyonunu da optimizasyon için kullanabiliriz. 

Bunun altında yatan fikir, doğru cevap için enerjinin düşük olmasını istememiz. Sonrasında, tüm yanlış cevapların olası konfigürasyonlarında yanlış veya kötü olanların arasında en düşük enerjiye sahip olanı arayacağız. Bundan sonra, bulduğumuz konfigürayonun enerjisini yükselteceğiz. Diğer kötü cevapların enerjisini zaten fazla olduğu için onların enerjilerini yükseltmemize gerek yok. 

Maksimum Marjin Markov Ağları ve Saklı SVM'ler arkasındaki mantık budur.
<!--
### Max Margin Markov Nets and Latent SVM
We can also using the Hinge loss function for optimization.
The intuition behind is that we want the energy of the correct answer to be low, and then among all possible configurations of incorrect answers, we are going to look for the one that has the lowest energy among all the wrong or the bad ones. And then we are going to push up the energy of this one. We don't need to push up the energy for the other bad answers because they are larger anyway.
This is the idea behind Max Margin Markov Nets and Latent SVM. -->

### Yapılandırılmış Algılayıcı Modeli

Algılayıcı *(perceptron)* yitim fonksiyonunu kullanarak doğrusal yapılandırılmış bir model eğitebiliriz.

Collins [Collins, 2000; Collins, 2002] bu hata fonksiyonunun doğal dil işleme bağlamında doğrusal yapılandırılmış modellerde kullanımını savunmuştur:$$

\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$
burada $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ sistem tarafından üretilen cevaptır.

<!--### Structured Perceptron model
We can train the linear structured model byy using perceptron loss.
Collins [Collins, 2000, Collins, 2002] has advocated its use for linear structured models in the context of NLP:
$$
\mathcal{L}_{\text {perceptron }}(W)=\frac{1}{P} \sum_{i=1}^{P} E\left(W, Y^{i}, X^{i}\right)-E\left(W, Y^{* i}, X^{i}\right)
$$
where $Y^{* i}=\operatorname{argmin}_{y \in \mathcal{Y}} E\left(W, y, X^{i}\right)$ is the answer produced by the system.-->

#### Konuşma/el yazısı tanıma için ayrımcı eğitimde ilk denemeler

Minimum Empirik Hata Kaybı(Ljolje ve Rabiner, 1990):
Diziler üzerinde eğitim yaparken, sisteme bu ses veya o yer gibi bilgileri söylemezler. Sisteme, girdi cümlesini ve kelimelere göre transkripsiyonunu verirler ve sistemden zamanı bükerek *(time warping)* bunu çözmesini isterler. Eskiden sinir ağlarını kullanmamışlardı ve konuşma sinyallerini ses kategorilerine dönüştürmenin başka yollar vardı. 

<!--#### Early trails on discrimitive training for speech/handwritten recognition.
Minimum Empirical Error Loss (Ljolje, and Rabiner 1990):
By training at sequence level, they do not tell the system this sound or that location. They give the system input sentence and transcription of it in term of words, and ask the system to figure it out by doing time warping. They did not use nerual networks, and have other ways in turing speech signals into sound categories.--> 

## Çizge Dönüştürücü Ağ *(Graph Transformer Net)*
<!--## Graph Transformer Net
Here the problem is that we have a sequence of digits at the input and we do not know how to do segmentation. What we can do is build a graph in which each path is a way of breaking up the sequence of characters, and we are going to find out the path with lowest energy, basically is to find the shortest path. Here is a concrete example of how it works.
We have input image 34. Run this through segmenter, and get multiple alternative segmentations. These segmentation are ways to group these blobs of thing together. Each path in the segmentation graph corresponds to one particular way of grouping the blobs of ink.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Figure 7.
</center>
We run each through the same charecter recognition ConvNet, and get a list of 10 scores (Two here but essentially should be 10, representing 10 categories). For example, 1 [0.1] means the energy is 0.1 for category 1. So I get a graph here, and you can think of it as a weird from of tensor. It is a sparse tensor really. It is a tensor that says for each possible configuration of this variable, tell me the cost of the variable. It's more like a distribution over tensors, or log distribution because we are talking about energies.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Figure 8.
</center>
Take this graph and then I want to compute the energy of the correct answer. I am telling you the correct answer is 34. Select within those paths and find out ones that say 34.  There are two of them, one the energy 3.4 + 2.4 = 5.8, and the other 0.1 + 0.6 = 0.7. Pick the path with the lowest energy. Here we get the path with energy 0.7.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Figure 9.
</center>
So finding the path is like minimizing over the latent variable where latent variable is which path you pick. Conceptually, it is an energy model with latent variable as a path.
Now we have the energy of the correct path, 0.7. What we need to do now is backpropagate gradient through this entire structure, so that we can change the weight in ConvNet in such a way that final energy goes down. It looks daunting, but is entirely possible. Because this entire system is built out of element we already know about, nerual net is regular and the Path Selector and Viterbi Transformer are basically swtiches that pick a particular edge or not.
So how do we backpropagate. Well, the point 0.7 is the sum of 0.1 and 0.6. So both point 0.1 and 0.6 will have gradient +1, which are indicated in the brackets. Then Viterbi Transformer just select one path among two. So just copy the gradient for the corresponding edge in the input graph and set  the gradeint for other paths that are not selected as zero. It's exactly what's happening in Max-Pooling or Mean-Pooling. The Path Selector is the same, it is just a system that selects the correct answer. Note that 3 [0.1] (0) in the graph should be 3 [0.1] (1) at this stage, and wil come back to this later. Then you can backpropagate gradient through the nerual net. That will make the energy of the correct answer small.
What's important here is that this structure is dynamic in the scence that if I give you a new input, the number of instances of nerual net will change with the number of segmentations, and graphs derived will also change. We need to backpropagate through this dynamical structure. This is the suitation where things like PyTorch are really important.
This phrase of backpropagation make the energy of correct answer small. And there's going to be a second phrase where we are going to make the energy of incorrect answer large. In this case, we just let the system pick whatever answer it wants. This is going to be a simplified form of discrimitive training for structure prediction that use perceptual loss.
The first stages of phrase two are exactly the same with the first phrase. The Viterbi Transformer here just pick the best path with the lowest energy, we do not care whether is path is a correct path or not here. The energy you get here is going to be smaller or equal to the one you get from phrase one, since the energy get here is the smallest among all possible paths.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Figure 10.
</center>
Putting phrase one and two together. The loss function should be energy1 - energy2. Before, we introduced how to backpropagate through the left part, and now we actually need to backpropagate through the entire structure. Whatever path on the left side will get +1, and whatever path in right hand side will get -1. So 3 [0.1] appeared in both path, thus should get gradient 0. If we do this, the system will eventually minimize the difference between the energy of the correct answer and the energy of the best answer whatever it is. The Loss function here is the perception loss.
<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Figure 11.
</center>-->

Bu kısımda problemimiz, girdi olarak elimizde bir rakam dizisinin olması ve bunu nasıl bölütleyeceğimizi bilmememizdir. Yapabileceğimiz şey ise her bir yolun elimizdeki karakter dizisini ayırmanın bir yolu olduğu bir çizge oluşturmaktır ve bu çizgedeki en düşük enerjili yolu yani en kısa yolu bulacağız. Bu yöntemin nasıl çalıştığına dair somut bir örneği inceleyelim.

Elimizde girdi resmi 34 var. Bu resmi bölütleyiciden geçirip bir sürü alternatif bölütleme  elde edelim. Bu bölütlemeler aslında elimizdeki parçaları gruplama yollardır. Bölütleme çizgesindeki her bir yol, elimizdeki mürekkep parçalarını birleştirebileceğimiz belirli bir yola karşılık gelmektedir.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig7.png" style="background-color:#DCDCDC;" /><br>
Şekil 7
</center>

Her birini ConvNet'te aynı karakter tanımadan geçiririz ve 10 skordan oluşan bir liste elde ederiz (Burada iki tane olsa da normalde 10 kategoriyi gösteren 10 skor olmalıdır.). Örneğin, 1 [0.1] 1. kategori için enerjinni 0.1 olduğu anlamına gelir. Burada bir çizge elde ediyorum ve bu yapıyı tensörün garip bir formu olarak düşünebilirsiniz. Aslında bu yapı seyrek bir tensör. Bu tensör, bir değişkenin tüm olası konfigürasyonları için bu değişkenin bedelini bize söyleyen bir tensör. Bu, tensörler üzerinde bir dağılım veya log dağılımı çünkü enerji bazlı modeller hakkında konuşuyoruz.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig8.png" style="background-color:#DCDCDC;" /><br>
Şekil 8
</center>

Bu çizgeyi ele alalım ve doğru cevabın enerjisini hesaplayalım. Size doğru cevabın 34 olduğunu söylüyorum. Yukarıdaki yollar arasından doğru cevabın 34 olduğu yolları bulun. İki tane var: birinin enerjisi  3.4 + 2.4 = 5.8, diğerinin ise 0.1 + 0.6 = 0.7. En düşük enerjili yolu seçin. Enerjisi 0.7 olan yolu seçtik.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig9.png" style="background-color:#DCDCDC;" /><br>
Şekil 9
</center>

Yolu bulmak, saklı değişkene, yani seçtiğimiz yola göre, göre minimize etmek gibi. Kavramsal olarak, saklı değişkenin bir yola denk geldiği bir enerji modeli.

Şimdi elmizide doğru olan yolun enerjisi var, 0.7. Şimdi yapmamız gereken bu yapı üzerinde gradyanları geri yaymak, böylece ConvNet ağırlıklarını son enerji düşecek şekilde değiştirebilelim. Göz korkutucu gözükse de imkansız değil çünkü tüm sistem bildiğimiz yapılardan oluşuyor. Sinir ağı sıradan ve Yol Seçici ve Viterbi Dönüştürücüsü ise aç kapa görevini üstlenir yani belli bir ayrıtı (veya yolu) seçip seçmemizi kontrol eder. 

Peki geri yayılımı nasıl gerçekleştireceğiz? 0.7 noktası 0.1 ve 0.6' nın toplamı. Yani 0.1 ve 0.6 noktalarının ikisinin de gradyeni +1 olacak ve köşeli parantezler ile göstereceğiz. Viterbi Dönüştürücüsü iki yoldan birini seçecek. Sonrasında, girdi çizgesinde bu yola karşılık gelen ayrıtın gradyenini kopyalamamız ve seçilmeyen diğer yolların gradyanlarını 0 olarak belirleyeceğiz. Tıpkı maksimum örnekleme *(max pooling)* ve ortalama örnekleme *(mean pooling)*'de olduğu gibi. Örneklemelede ve burada da yol seçici aynı; yol seçici doğru cevabı seçen bir sistem sadece. Çizgedeki 3[0.1](0)'in bu aşamada 3[0.1](1) olması gerektiğine dikkat edin, buna daha sonra döneceğiz. Artık sinir ağı üzerinde gradyanı geri yayabilirsin. Böylelikle, doğru cevabın enerjisini küçültmüş olacağız. 

Buradaki kritik kısım, yapının dinamik olması yani sisteme yeni bir girdi verdiğimizde, sinir ağındaki örnek sayısı bölütleme sayısı ile değişecektir ve üretilen çizgeler de değişecektir. Geri yayılımı, bu dinamik bir yapı üzerinde gerçekleştirmemiz gerekiyor. İşte bu tarz durumlarda PyTorch oldukça önemli hale geliyor.

Bu fazda, geri yayılım ile doğru cevabın enerjisini küçültüyoruz. İkinci fazda ise yanlış cevabın enerjisini büyütüyoruz. Bu durumda, sistemin istediği cevabı seçebilmesine izin veriyoruz. Bu işlemler ile algı kaybı *(perception loss)* fonksiyonu kullanan yapılandırılmış kestirim problemleri için ayrıştırıcı eğitimin basit bir hali olacak. 

İkinci fazın ilk adımları, ilk fazınkiyle tamamen aynı. Viterbi Dönüştürücüsü yine en düşük enerjili yolu seçecek, seçilen yolun doğru veya yanlış olduğunu burada önemsemiyoruz. Burada elde ettiğimiz enerji, ilk fazda elde ettiğimiz enerjiden ya küçük ya da bu enerjiye eşit olacak çünkü bu fazda elde ettiğimiz enerji, tüm olası yollardaki enerjilerin en küçüğü.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig10.png" style="background-color:#DCDCDC;" /><br>
Şekil 10
</center>

Faz 1 ve Faz 2'yi birleştirelim. Yitim fonksiyonu enerji1 - enerji2 olmalı. Sol dal üzerinde geri yayılımı nasıl gerçekleştireceğimizi anlatmıştık, şimdi sırada tüm yapı üzerinde geri yayılımı gerçekleştirmekte. Sol taraftan herhangi bir yol +1 ve sağ taraftaki herhangi bir yol ise  -1 gradyanına sahip. Bu yüzden, iki yolda da 3[0.1] var, bu nedenle 3[0.1]'in gradyanı 0 olmalı. Bunu yaparsak, sistem nihayetinde doğru cevabın enerjisi ile en iyi cevabın enerjisi arasındaki farkı minimize edecektir. Buradaki yitim fonksiyonu, algılayıcı yitim fonksiyonudur.

<center>
<img src="{{site.baseurl}}/images/week14/14-1/Fig11.png" style="background-color:#DCDCDC;" /><br>
Şekil 11
</center>

## Kavrama Soruları ve Cevapları   

#### Soru 1: Neden enerji bazlı faktör çizgelerinde çıkarım kolaydır?
Saklı değişkenli enerji bazlı modellerde çıkarım, enerjiyi minimize etmek için gradyan inişini kullanmak gibi kapsamlı yöntemleri içermektedir; ancak, bu durumda, enerji, faktörlerin toplamı olduğu olduğu için gradyan inişi yerine dinamik programlama gibi teknikler kullanılabilir.


#### Soru 2: Faktör çizgelerindeki saklı değişkenler sürekli değişkenler olsaydı ne olurdu? Minimum toplam algoritmasını kullanmaya devam edebilir miydik?

Devam edemezdik çünkü şu anda tüm faktör değerleri için olası tüm kombinasyonları arayamıyoruz; ancak, bu durumda, enerjiler bize bir avantaj sağlıyor çünkü birbirinden bağımsız optimizasyon işlemleri yapabiliyoruz. Tıpkı Şekil 5'te $Z_1$ ve $Z_2$'nin kombinasyonunun sadece $E_b$'yi etkilediği gibi. Çıkarım için bağımsız optimizasyon ve dinamik programlama yapabiliriz.

#### Soru 3: Sinir ağı kutuları ayrı ConvNet'leri mi temsil ediyor?
Kutular paylaşılıyor yani kutular aslında aynı ConvNet'in kopyalarından ibaret. Bu sadece bir karakter tanıma ağı.

<!--
## Comprehension Questions and Answers
#### Question1: Why is inference easy in the case of energy-based factor graphs?
Inference in the case of the energy-based model with latent variable involves the usage of exhaustive techniques such as gradient descent to minimize the energy however since the energy, in this case, is the sum of factors and techniques such as dynamic programming can be used instead.
#### Question2: What if the latent variables in factor graphs are continuous variables? Can we still using min-sum algorithm?
We can't since we can't search for all possible combination for all factor values now. However, in this case, energies also gives us an advantage, because we can do independent optimizations. Like the combination of $Z_1$ and $Z_2$ only affects $E_b$ in Figure 19. We can do independent optimization and dynamic programming to do the inference.
#### Question3: Are the NN boxes refering to seperate ConvNets?
They are shared. They are multiple copies of the same ConvNet. It's just a character recognition network.
-->
