---
lang-ref: ch.12-1
title: NLP için Derin Öğrenme
lecturer: Mike Lewis
authors: Jiayu Qiu, Yuhong Zhu, Lyuang Fu, Ian Leefmans
date: 20 Apr 2020
lang: tr
translation-date: 8 Aug 2020
translator: mevah
---


## [Genel Bakış](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=44s)
<!--
* Amazing progress in recent years:
  - Humans prefer machine translation to human translators for some languages
  - Super-human performance on many question answering datasets
  - Language models generate fluent paragraphs (e.g Radford et al. 2019)
*  Minimal specialist techniques needed per task, can achieve these things with fairly generic models
-->
* Son senelerdeki inanılmaz gelişmeler:
  - İnsanlar bazı diller için insan çevirmenler kullanmak yerine makine çevirisini tercih ediyor
  - Birçok soru cevap veri setinde gösterilen süper-insan performansları
  - Dil modelleri akıcı paragraflar üretebiliyor (örn. Radford et al. 2019)
*  Her bir görev için çok az uzman bilgisine ihtiyaç var, bunları epeyce genel modellerle elde edebiliyoruz 

## Dil Modelleri
<!--
* Language models assign a probability to a text:
  $p(x_0, \cdots, x_n)$
* Many possible sentences so we can’t just train a classifier
* Most popular method is to factorize distribution using chain rule:
-->
* Dil modelleri yazıya bir olasılık atarlar:
  $p(x_0, \cdots, x_n)$
* Çok fazla olası cümle olabilir, bu yüzden sadece bir ayırıcı eğitemeyiz
* En popüler metod zincir kuralını kullanarak bu dağılımı faktörize etmektir:

$$p(x_0,...x_n) = p(x_0)p(x_1 \mid x_0) \cdots p(x_n \mid x_{n-1})$$


## Sinirsel Dil Modelleri
<!--
Basically we input the text into a neural network, the neural network will map all this context onto a vector. This vector represents the next word and we have some big word embedding matrix. The word embedding matrix contains a vector for every possible word the model can output. We then compute similarity by dot product of the context vector and each of the word vectors. We'll get a likelihood of predicting the next word, then train this model by maximum likelihood. The key detail here is that we don't deal with words directly, but we deal with things called sub-words or characters.
-->
Örneğin bir yazıyı sinirsel ağa girdi olarak veriyoruz, sinirsel ağ bunu bir vektöre eşleyecektir. Bu vektör bir sonraki kelimeyi temsil eder ve sonunda büyük bir kelime gömme matrisimiz olur. Kelime gömme matrisi, modelin çıktı olarak verebileceği her kelime için bir vektör içerir. Daha sonra bağlam vektörü ile her bir kelime vektörünün iç çarğımını alarak benzerliği hesaplarız. Bir sonraki kelimeyi tahmin etmek için bir olabilirlik *(likelihood)* elde ederiz, ve bu modeli maksimum olabilirlik *(maximum likelihood)* ile eğitiriz. Buradaki önemli nokta kelimelerle direkt olarak ilgilenmememiz, alt-kelime dediğimiz şeylerle ya da karakterlerle ilgileniyor olmamız.

$$p(x_0 \mid x_{0, \cdots, n-1}) = \text{softmax}(E f(x_{0, \cdots, n-1}))$$

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig1.jpg">
  <center>  Fig.1: Sinirsel dil modeli</center>
</figure>


### Evrişimli Dil Modelleri
<!--
* The first neural language model
* Embed each word as a vector, which is a lookup table to the embedding matrix, so the word will get the same vector no matter what context it appears in
* Apply same feed forward network at each time step
* Unfortunately, fixed length history means it can only condition on bounded context
* These models do have the upside of being very fast
-->
* İlk sinirsel dil modeli
* Her kelimeyi vektör olarak göm, bu da gömme matrisinde çizelgeye bakarak karşılığını bulmaya tekabül ediyor, böylece hangi bağlamda olursa olsun o kelime aynı vektörü veriyor
* Her adımda aynı ileri besleme ağını uygula
* Malesef, geçmişte uzunluğun sabit olması demek sınırlı bağlamda şartlanması anlamına gelir
* Bu modellerin çok hızlı olma avantajları var

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig2.jpg">
  <center>  Fig.2: Evrişimli dil modeli</center>
</figure>


### Yinelemeli Dil Modelleri
<!--
* The most popular approach until a couple years ago.
* Conceptually straightforward: every time step we maintain some state (received from the previous time step, which represents what we've read so far. This is combined with current word being read and used at later state. Then we repeat this process for as many time steps as we need.
* Uses unbounded context: in principle the title of a book would affect the hidden states of last word of the book.
* Disadvantages:
  - The whole history of the document reading is compressed into fixed-size vector at each time step, which is the bottleneck of this model
  - Gradients tend to vanish with long contexts
  - Not possible to parallelize over time-steps, so slow training
-->
* Birkaç yıl öncesine kadarki en popüler yaklaşım
* Konsept olarak açık ve anlaşılabilir: her zaman aralığında belli bir durum elde ederiz (daha önceki zaman adımından gelen ve şu ana kadar ne okuduğumuzu gösteren). Bu durum şu anda okunan kelime ile birleştirilerek daha sonraki durum için kullanılır. Ne kadar zaman adımı varsa o bu işlem o kadar tekrar ettirilir.
* Sınırsız bağlam kullanır: örneğin bir kitabın başlığı kitabın son kelimesinin gizli durum(*state*)larını etkileyecektir.
* Dezavantajlar:
 - Her zaman adımında bütün okunmuş doküman uzunluğu belli bir vektöre sıkıştırılır, bu da modelin sıkışma noktası olur (*bottleneck*)
 - Gradyanlar uzun bağlamlarda yok olmaya eğilimlidir
 - Zaman adımları üstünde paralelleştirilmesi mümkün değildir, yani yavaş eğitilir

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig3.jpg">
  <center>  Fig.3: Yinelemeli dil modeli</center>
</figure>


### [Dönüştürücü (Transformer) Dil Modelleri](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=828s)
<!--
* Most recent model used in NLP
* Revolutionized penalty
* Three main stages
    * Input stage
    * $n$ times transformer blocks (encoding layers) with different parameters
    * Output stage
* Example with 6 transformer modules (encoding layers) in the original transformer paper:
-->
* Doğal dil işleme (NLP)'de en son kullanılan model
* Ceza konseptini ortaya çıkarttı
* Üç ana aşama:
    * Girdi aşaması
    * Değişik parametreli $n$ tane dönüştürücü (*transformer*) bloğu (kodlayıcı katlanlar)
    * Çıktı aşaması
* Orijinal transformer makalesindeki 6 transformer modüllü (kodlayıcı katmanlı) örnek:

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig4.jpg">
  <center>  Fig.4:Dönüştürücü (*transformer*) modeli </center>
</figure>

<!--
Sub-layers are connected by the boxes labelled "Add&Norm". The "Add" part means it is a residual connection, which helps in stopping the gradient from vanishing. The norm here denotes layer normalization.
-->
Alt katmanlar "Ekleme&Normalize" (*Add & Norm*) ile gösterilen kutularla birbirine bağlanırlar. "Add" kısmı artık (*residual*) bir bağlantı olduğunu gösteriyor, bu da gradyanın yok olmasını engellemekte yardımcı oluyor. Norm ise katman normalizasyonunu gösteriyor.

<figure>
  <img src="{{site.baseurl}}/images/week12/12-1/fig5.jpg">
  <center>  Fig.5: Kodlayıcı Katman </center>
</figure>

<!--
It should be noted that transformers share weights across time-steps.
-->
Dönüştürücüler değişik zaman adımlarındaki ağırlıkları paylaşırlar.

# Çok başlı dikkat (*Multi-headed attention*)

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig6.png">
<center>  Fig.6: Çok başlı dikkat </center>
</figure>

<!--
For the words we are trying to predict, we compute values called **query(q)**. For all the previous words use to predict we call them **keys(k)**. Query is something that tells about the context, such as previous adjectives. Key is like a label containing information about the current word such as whether it's an adjective or not. Once q is computed, we can derive the distribution of previous words ($p_i$):
-->
Tahmin etmeye çalıştığımız kelimeler için , **query(q)** (sorgu) denilen değerleri hesaplarız. Daha önceki tahminler için kullanılan tüm kelimeler **keys(k)** (anahtar) olarak adlandırılırlar. Query, bağlam hakkında fikir veren, örneğin daha önceki sıfatlar gibi şeylerdir. Key ise şu anki kelime ile ilgili bilgi taşıyan etiketlerdir, örneğin şu anki kelimenin sıfat olup olmaması gibi. q hesaplandığında, daha önceki kelimelerin dağılımı olan ($p_i$)'yı şöyle hesaplarız:

$$p_i = \text{softmax}(q,k_i)$$

<!--
Then we also compute quantities called **values(v)** for the previous words. Values represent the content of the words.

Once we have the values, we compute the hidden states by maximizing the attention distribution:
-->

Daha sonra **values(v)**  (değer) denilen değerleri de hesaplarız. Value'lar kelimelerin içeriklerini temsil ederler.

Değerleri hesapladığımızda, saklı durumları dikkat dağılımını maksimize ederek hesaplayabiliriz:

$$h_i = \sum_{i}{p_i v_i}$$

<!--
We compute the same thing with different queries, values, and keys multiple times in parallel. The reason for this is that we want to predict the next word using different things. For example, when we predict the word "unicorns" using three previous words "These" "horned" and "silver-white". We know it is a unicorn by "horned" "silver-white". However, we can know it is plural "unicorns" by "These". Therefore, we probably want to use all these three words to know what the next word should be. Multi-headed attention is a way of letting each word look at multiple previous words.

One big advantage about the multi-headed attention is that it is very parallelisable. Unlike RNNs, it computes all heads of the multi-head attention modules and all the time-steps at once. One problem of computing all time-steps at once is that it could look at futures words too, while we only want to condition on previous words. One solution to that is what is called **self-attention masking**. The mask is an upper triangular matrix that have zeros in the lower triangle and negative infinity in the upper triangle. The effect of adding this mask to the output of the attention module is that every word  to the left has a much higher attention score than words to the right, so the model in practice only focuses on previous words. The application of the mask is crucial in language model because it makes it mathematically correct, however, in text encoders, bidirectional context can be helpful.

One detail to make the transformer language model work is to add the positional embedding to the input. In language, some properties like the order are important to interpret. The technique used here is learning separate embeddings at different time-steps and adding these to the input, so the input now is the summation of word vector and the positional vector. This gives the order information.
-->

Farklı query, value ve keyler için aynı şeyi paralel şekilde birden fazla kez hesaplarız. Bunun nedeni sonraki kelimeyi tahmin ederken değişik şeyleri kullanmak. Örneğin, "unicornlar" kelimesini, ondan önceki üç kelime olan "Bu", "boynuzlu" ve "gümüş-beyazı" ile tahmin ederken. "Boynuzlu" ve "gümüş-beyazı" kelimelerinden bir unicorn olduğunu bilmiş oluyoruz. Ama "Bu" (*These*) kelimesi olduğundan unicorn'un çoğul olacağını biliyoruz. Bu nedenle, önceden gelen üç kelimeyi de daha sonraki kelimenin tahmininde kullanmayı isteriz. Çok başlı dikkat, her kelimenin birden fazla önceden gelen kelimeye bakmasına yarayan bir yol.

Çok başlı dikkatin bir büyük avantajı ise çok fazla parallelleştirmeye imkanı olması. RNN'lerin aksine, çok başlı dikkatin tüm başları ve tüm zaman adımları aynı anda hesaplanabiliyor. Bütün zaman adımlarını aynı anda hesaplamanın problemi ise, sadece önceki kelimelere şartlamak isterken gelecekteki kelimelere de bakabiliyor olmamız. Bu da **öz-dikkat maskeleme** denilen yöntemle çözülebilir. Kullanılan "maske" bir alt üçgen kısmında sıfırlar olan ve üst üçgen kısmında negatif sonsuz olan bir üst üçgenlenmiş matris. Bu maskeyi dikkat modülünün çıktı kısmına eklemek şöyle bir etki yaratıyor: her kelimenin solundaki kelime sağındaki kelimeden çok daha fazla dikkat skoruna sahip oluyor, böylece model pratikte sadece önce gelen kelimelere odaklanıyor. Dil modelinde bu maske uygulamasını kullanmak çok önemli çünkü matematiksel olarak doğru yapan şey bu, fakat metin kodlayıcılarında iki yönlü bağlamlar da önemli olabilir.

Dönüştürücü dil modelinin çalışmasında etkili olan bir detay da girdinin konumsal olarak gömülmesi. Dilde, sıralama gibi bazı özellikler anlama için önemlidir. Burada kullanılan teknik ise farklı zaman adımlarında ayrı ayrı gömmeler öğrenerek bunları girdiye eklemek, böylece girdi kelime vektörü ve konumsal vektörün bir toplamı oluyor, bu da sıralama bilgisini tutmuş oluyor.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig7.png">
<center>  Fig.7: Dönüştürücü modeli </center>
</figure>

**Neden bu model bu kadar iyi:**

<!--
1. It gives direct connections between each pair of words. Each word can directly access the hidden states of the previous words, mitigating vanishing gradients. It learns very expensive function very easily
2. All time-steps are computed in parallel
3. Self-attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length
-->

1. Model her kelime ikilisi için direkt bağlantılar sağlıyor. Her kelime önceki kelimelerin gizli durumlarına direkt olarak, gradyanlar kaybolmadan erişebiliyor. Model çok pahalı bir fonksiyonu kolayca öğreniyor
2. Her zaman adımı paralel olarak hesaplanıyor
3. Öz-dikkat ikinci dereceden bir fonksiyon (her zaman adımı diğer adımlara bağlanabilir), bu da maksimum dizi boyutunu limitler

<!--## [Some tricks (especially for multi-head attention and positional encoding) and decoding Language Models](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)

### Trick 1: Extensive use of layer normalization to stabilize training is really helpful

- Really important for transformers


### Trick 2: Warm-up + Inverse-square root training schedule

- Make use of learning rate schedule: in order to make the transformers work well, you have to make your learning rate decay linearly from zero to thousandth steps.


### Trick 3: Careful initialization

- Really helpful for a task like machine translation


### Trick 4: Label smoothing

- Really helpful for a task like machine translation

The following are the results from some methods mentioned above. In these tests, the metric on the right called `ppl` was perplexity (the lower the `ppl` the better).
-->
## [Bazı taktikler (özellikle çok başlı dikkat ve konumlamalı kodlama için) ve kodçözücü Dil Modelleri](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=1975s)

### Taktik 1: Eğitme sırasında katman normalizasyonunu çokça kullanmak, stabilizasyon için çok yararlı

- Dönüştürücüler için çok önemli

### Taktik 2: Isınma + Ters karekök eğitme planlaması

- Öğrenme hızı planlamasını kullanmak: dönüştürücülerin iyi çalışması için, öğrenme hızını sıfırdan bininci adıma doğru lineer olarak azaltma planı yapmalısınız

### Taktik 3: Dikkatli başlangıç değerleri

- Makine çevirisi gibi işlerde gerçekten yardımı oluyor

### Taktik 4: Etiket düzleştirme

- Makine çevirisi gibi işlerde gerçekten yardımı oluyor

Aşağıdakiler, az önce bahsedilen metodların sonuçları. Bu testlerde, sağdaki `ppl` diye adlandırılan metrik ise perplexity (karışıklık)'dir (`ppl` ne kadar küçükse o kadar iyi).

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig8.png">
<center>  Fig.8: Model Performansları Karşılaştırması </center>
</figure>

<!--You could see that when transformers were introduced, the performance was greatly improved.-->
Dönüştürücüler işin içine girdiğinde performansın ne kadar arttığını görebilirsiniz.

<!--
## Some important facts of Transformer Language Models

 - Minimal inductive bias
 - All words directly connected, which will mitigate vanishing gradients.
 - All time-steps computed in parallel.


Self attention is quadratic (all time-steps can attend to all others), limiting maximum sequence length.

- As self attention is quadratic, its expense grows linearly in practice, which could cause a problem.
-->
## Dönüştürücü Dil Modelleri'nin bazı önemli özellikleri

- Minimal model varsayımı
- Bütün kelimeler direkt olarak birbirine bağlı, kaybolan gradyanları azaltıyor.
- Bütün zaman adımları paralel olarak hesaplanıyor.


Öz-dikkat ikinci dereceden bir fonksiyon (her zaman adımı diğer adımlara bağlanabilir), bu da maksimum dizi boyutunu limitliyor.

- Öz dikkat ikinci dereceden olduğundan, maliyeti pratikte lineer olarak büyür, bu da problem oluşturabilir.

<figure>
<img src="{{site.baseurl}}/images/week12/12-1/fig9.png">
<center>  Fig.9: Dönüştürücüler vs. RNN'ler </center>
</figure>

<!--
### Transformers scale up very well

1. Unlimited training data, even far more than you need
2. GPT 2 used 2 billion parameters in 2019
3. Recent models use up to 17B parameters and in 2020


## Decoding Language Models

We can now train a probability distribution over text - now essentially we could get exponentially many possible outputs, so we can’t compute the maximum. Whatever choice you make for your first word could affect all the other decisions.
Thus, given that, the greedy decoding was introduced as follows.


### Greedy Decoding does not work

We take most likely word at each time step. However, no guarantee this gives most likely sequence because if you have to make that step at some point, then you get no way of back-tracking your search to undo any previous sessions.


### Exhaustive search also not possible

It requires computing all possible sequences and because of the complexity of $O(V^T)$, it will be too expensive


## Comprehension Questions and Answers

1. What is the benefit of multi-headed attention as opposed to a single-headed attention model?

    * To predict the next word you need to observe multiple separate things, in other words attention can be placed on multiple previous words in trying to understand the context necessary to predict the next word.

2. How do transformers solve the informational bottlenecks of CNNs and RNNs?

    * Attention models allow for direct connection between all words allowing for each word to be conditioned on all previous words, effectively removing this bottleneck.

3. How do transformers differ from RNNs in the way they exploit GPU parallelization?

    * The multi-headed attention modules in transformers are highly parallelisable whereas RNNs are not and therefore cannot take advantage of GPU technology. In fact transformers compute all time steps at once in single forward pass.
-->
### Dönüştürücüler büyütülmeye çok elverişlidir

1. Sınırsız eğitme verisi, ihtiyacımız olandan bile fazla
2. GPT-2, 2019'da 2 milyar parametre kullandı
3. Son modeller 17 milyara kadar parametre kullanıyor


## Kodçözücü Dil Modelleri

Artık bütün metin üzerinde bir olasılık dağılımı eğitebiliriz - ve üstel derecede fazla olasılıklı çıktılar elde edebiliriz, ve bu yüzden maksimumunu hesaplayamayız. İlk kelimeyi hangisi seçerseniz, bütün kararlar bu seçimden etkilenebilir.
Bu nedenle, açgözlü kodçözme fikri ortaya sunuldu.

### Açgözlü Kodçözme işe yaramıyor

Her zaman adımında en olası kelime alınır. Fakat bunun en olası diziyi verdiğinin garantisi yoktur çünkü eğer o adımı bir şekilde almak gerekirse, yapılan aramaya geri dönüp arayarak önceki aşamaları geri alma imkanı yoktur.

### Kapsayıcı arama da mümkün değil

Tüm dizileri hesaplamayı gerektiriyor ve kompleksliği $O(V^T)$ olduğundan çok pahalı olur

## Anlama ölçen Soru ve Cevaplar

1. Çok başlı dikkatin, tek başlı dikkate göre avantajı nedir?

    * Bir sonraki kelimeyi tahmin etmek için birden çok şeyi görmeniz gerekiyor; başka bir deyişle dikkat önceki birden fazla kelimeye atanarak bir sonraki kelimeyi tahmin etmek için gerekli bağlamı anlamayı sağlıyor.

2. Dönüştürücüler, CNN ve RNN'lerin bilgi sıkışma noktalarını nasıl çözerler?

  * Dikkat modelleri bütün kelimeler arasında direkt bağlantı olmasını sağlar, her kelimenin bir önceki kelimelere şartlı olması da bu sıkışma noktasını yok eder.

3. Dönüştürücülerin RNN'lerden GPU paralelizasyonu açısından farkı nedir?

  *  Dönüştürücülerdeki çok başlı dikkat modülleri, GPU teknolojilerinden yararlanamayan RNN'lerin aksine oldukça paralelleştirilebilirlerdir. Hatta dönüştürücüler bir ileri geçişte bütün zaman adımlarını tek seferde hesaplayabilirler.
