---
lang: tr
lang-ref: ch.11-3
lecturer: Alfredo Canziani
title: Belirsizlik Altında Tahmin ve Politika Öğrenimi (BATPÖ)
authors: Anuj Menta, Dipika Rajesh, Vikas Patidar, Mohith Damarapati
date: 14 April 2020
translation-date: 10 Sep 2020
translator: Mehmet Aygun
---

<!--## [Introduction and problem setup](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

Let us say we want to learn how to drive in a model-free Reinforcement learning way. We train models in RL by letting the model make mistakes and learn from them. But this is not the best way since mistakes might take us to heaven/hell where there is no point in learning.

So, let us talk about a more 'human' way to learn how to drive a car. Consider an example of lane switching. Assuming the car is moving at 100 km/h, which roughly translates to 30 m/s, if we look 30 m in front of us, we are roughly looking 1 s into the future.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Looking into future while driving
</center>

If we were turning, we need to make a decision based on the near future. To take a turn in a few meters, we take an action now, which in this context is turning the steering wheel. Making a decision not only depends on your driving but also the surrounding vehicles in the traffic. Since everyone around us is not so deterministic, it is very hard to take every possibility into account.

Let us now break down what is happening in this scenario. We have an agent(represented here by a brain) that takes the input $s_t$ (position, velocity and context images) and produces an action $a_t$(steering control, acceleration and braking).  The environment takes us to a new state and returns a cost $c_t$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 2:</b> Illustration of an agent in the real world
</center>

This is like a simple network where you take actions given a specific state and the world gives us the next state and the next consequence. This is model-free because with every action we are interacting with the real world. But can we train an agent without actually interacting with the real world?

Yes, we can! Let us find out in the "Learning world model" section.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 3:</b> Illustration of an agent in the world model
</center>-->
## [Giriş ve Problem Tanımı](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=63s)

Diyelim ki modelden bağımsız bir pekiştirmeli öğrenme yolu ile nasıl sürüleceğini öğrenmek istiyoruz. Modelin hata yapmasını ve hatalarından öğrenmesine izin vererek modelleri RL'de eğitiyoruz. Ancak hatalar bizi öğrenmenin hiçbir anlamı olmayan cennet/cehennem gibi koşullara götürebileceğinden bu en iyi yol değildir.

Öyleyse, araba kullanmayı öğrenmenin daha 'insansı' bir yolundan bahsedelim. Şerit değiştirme örneğini düşünün. Arabanın 100 km/s hızla gittiğini varsayarsak, bu kabaca 30 m/s'ye karşılık gelir, eğer önümüzdeki 30 mye bakarsak, kabaca 1s geleceğe bakabildiğimiz anlamına gelir.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure1.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Şekil 1:</b> Sürüş sırasında geleceğe bakmak
</center>

Dönüyorsak, yakın geleceğe göre bir karar vermemiz gerekiyor. Birkaç metre sonra bir dönüş yapmak için, şu an bir aksiyon alıyoruz.  Bu bağlamda direksiyon simidini çeviren bir aksiyona girişiyoruz. Aldığımız kararlar sadece sizin sürüşünüze değil, aynı zamanda trafikte çevredeki araçlara da bağlıdır. Çevremizdeki herkes o kadar deterministik olmadığı için her olasılığı hesaba katmak çok zor.

Şimdi bu senaryoda neler olduğunu inceleyelim. Girdiyi alan bir ajanımız var (burada bir beyin ile temsil edilir) $s_t$ (pozisyon, hız ve resim) ve bir aksiyona karar veriyor $a_t$(direksiyon kontrolü, hızlanma ve frenleme). Çevre bizi yeni bir duruma götürür ve bir maliyet geri dönderir $c_t$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure2.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Şekil 2:</b> Gerçek dünyadaki bir ajanın çizimi
</center>

Bu, belirli bir durumla ilgili eylemlerde bulunduğunuz ve dünyanın bize bir sonraki durumu ve bir sonraki sonucu verdiği basit bir ağ gibidir. Bu model içermez çünkü her eylemde gerçek dünya ile etkileşim halindeyiz. Ama gerçek dünyayla etkileşime girmeden bir ajan eğitebilir miyiz?

Evet yapabiliriz! Buna "dünya modeli öğrenme" bölümünde bakalım.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure3.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Şekil 3:</b> Dünya modelindeki bir ajanın çizimi
</center>


<!--## Data set

Before discussing how to learn the world model, let us explore the dataset we have. We have 7 cameras mounted on top of a 30 story building facing the interstate. We adjust the cameras to get the top-down view and then extract bounding boxes for each vehicle. At a time $t$, we can determine $p_t$ representing the position, $v_t$
representing the velocity and $i_t$ representing the current traffic state around the vehicle.

Since we know the kinematics of the driving, we can invert them to figure out what are the actions that the driver is taking. For example, if the car is moving in a rectilinear uniform motion, we know that the acceleration is zero(meaning there is no action)

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 4:</b> Machine representation of a single frame
</center>

The illustration in blue is the feed and the illustration in green is what we can call the machine representation. To understand this better, we have isolated a few vehicles(marked in the illustration). The views we see below are the bounding boxes of the field-of-view of these vehicles.-->
## Veri Kümesi

Dünya modelini nasıl öğreneceğimizi tartışmadan önce, sahip olduğumuz veri setini inceleyelim. Eyaletlerarası yola bakan 30 katlı bir binanın tepesine monte edilmiş 7 kameramız var. Yukarıdan aşağı görünümü elde etmek için kameraları ayarlıyoruz ve ardından her araç için sınırlayıcı kutuları çıkarıyoruz. Zaman $t$ , pozisyon $p_t$, hız $v_t$, anlık trafik durumunu ve etraftaki araçların durumlarını $i_t$ belirtsin. 

Sürüşün kinematiğini bildiğimizden, sürücünün yaptığı eylemlerin neler olduğunu anlamak için onları tersine çevirebiliriz. Örneğin, araba doğrusal tekdüze bir hareketle hareket ediyorsa, ivmenin sıfır olduğunu anlayabiliriz (yani hiçbir eylem yok). 

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure4.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 4:</b> Tek bir karenin makine gösterimi
</center>

Mavi renkli resime besleme, yeşil resime de makine temsili diyebilıriz. Bunu daha iyi anlamak için, birkaç aracı izole ettik (şekilde işaretlenmiştir). Aşağıda gördüğümüz görüntüler, bu araçların görüş alanlarının sınırlayıcı kutularıdır.


<!--## Cost

There are two different types of costs here: lane cost and proximity cost. Lane cost tells us how well we are within a lane and proximity cost tells us how close we are to the other cars.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 5:</b> Lane cost
</center>

In the above figure, dotted lines represent actual lanes and red lines help us figure out the lane cost given the current position of our car.  Red lines move as our car moves. The height of the intersection of the red lines with the potential curve (in cyan) gives us the cost. If the car is in the centre of the lane, both the red lines overlap with the actual lanes resulting in zero cost. On the other hand, as the car moves away from the centre, the red lines also move to result in a non-zero cost.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Proximity cost
</center>

Proximity cost has two components ($\mathcal{L}_x$ and $\mathcal{L}_y$). $\mathcal{L}_y$ is similar to the lane cost and $\mathcal{L}_x$ depends on the speed of our car. The Orange curve in Figure 6 tells us about the safety distance. As the speed of the car increases, the orange curve widens. So faster the car is travelling, the more you will need to look ahead and behind. The height of the intersection of a car with the orange curve determines $\mathcal{L}_x$.

The product of these two components gives us the proximity cost.-->
## Maliyet

Burada iki farklı maliyet türü vardır: şerit maliyeti ve yakınlık maliyeti. Şerit maliyeti bize bir şeritte ne kadar iyi olduğumuzu söyler ve yakınlık maliyeti bize diğer arabalara ne kadar yakın olduğumuzu söyler.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure5.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 5:</b> Şerit maliyeti
</center>

Yukarıdaki şekilde, noktalı çizgiler gerçek şeritleri temsil eder ve kırmızı çizgiler, arabamızın mevcut konumu göz önüne alındığında şerit maliyetini anlamamıza yardımcı olur. Arabamız hareket ettikçe kırmızı çizgiler de hareket eder. Kırmızı çizgilerin potansiyel eğriyle kesişme yüksekliği (camgöbeği renginde olan alan) bize maliyeti verir. Araç şeridin merkezinde ise, her iki kırmızı çizgi de gerçek şeritlerle çakışarak sıfır maliyet verir. Öte yandan, araba merkezden uzaklaştıkça kırmızı çizgiler de hareket ederek sıfır olmayan bir maliyet oluşturur.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure6.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 6:</b> Yakınlık maliyeti
</center>

Yakınlık maliyetinin iki bileşeni vardır ($\mathcal{L}_x$ and $\mathcal{L}_y$). $\mathcal{L}_y$ şerit maliyetine benzer ve $\mathcal{L}_x$ arabamızın hızına bağlıdır. Şekil 6'daki Turuncu eğri bize güvenlik mesafesini anlatır. Arabanın hızı arttıkça turuncu eğri genişler. Araba ne kadar hızlı giderse, o kadar çok ileriye ve arkaya bakmanız gerekecektir. Bir arabanın turuncu eğri ile kesişme noktasının yüksekliği $\mathcal{L}_x$'i belirler.

Bu iki bileşenin çarpımı bize yakınlık maliyetini verir.


<!--## Learning world model

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 7:</b> Illustration of the world model
</center>

The world model is fed with an action $a_t$ (steering, brake, and acceleration) and $s_{1:t}$ (sequence of states where each state is represented by position, velocity and context images at that time) and it predicts the next state $\hat s_{t+1}$.  On the other hand, we have the real world which tells us what actually happened ($s_{t+1}$). We optimize MSE (Mean Squared Error) between prediction ($\hat s_{t+1}$) and target ($s_{t+1}$) to train our model.-->
## Dünya modelini öğrenmek

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure7.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Şekil 7:</b> Dünya modelinin çizimi
</center>

Dünya modeli bir eylemle $a_t$ (direksiyon, fren ve hızlanma) ve durumlar dizisiyle $s_{1:t}$ (Her bir durumun o andaki konum, hız ve bağlam görüntüleriyle temsil edildiği durumlar dizisi) besleniyor ve gelecek durumu $\hat s_{t+1}$ tahmin ediyor. Öte yandan, bize gerçekte ne olduğunu anlatan gerçek dünyaya da sahibiz. ($s_{t+1}$). Biz tahmin ($\hat s_{t+1}$) ve hedef ($s_{t+1}$) arasındaki MSE (Ortalama Kare Hata) optimize edereek modelimizi eğitebiliriz.


<!--## Deterministic predictor-decoder

One way to train our world model is by using a predictor-decoder model explained below.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 8:</b> Deterministic predictor-decoder to learn the world model
</center>

As depicted in Figure 8, we have a sequence of states($s_{1:t}$) and action ($a_t$) which are provided to the predictor module. The predictor outputs a hidden representation of the future which is passed on to the decoder. The decoder is decoding the hidden representation of the future and outputs a prediction($\hat s_{t+1}$). We then train our model by minimising MSE between prediction $\hat s_{t+1}$ and target $s_{t+1}$.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Figure 9:</b> Actual future *vs.* Deterministic future
</center>

Unfortunately, this does not work!

We see that the deterministic output becomes very hazy. This is because our model is averaging over all the future possibilities. This can be compared to the future's multimodality discussed a couple of classes earlier, where a pen placed at origin is dropped randomly. If we take the average across all locations, it gives us a belief that pen never moved which is incorrect.

We can address this problem by introducing latent variables in our model.-->
## Deterministik tahminci-kod çözücü

Dünya modelimizi eğitmenin bir yolu, aşağıda açıklanacak bir tahmin-kod çözücü modeli kullanmaktır.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure8.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Şekil 8:</b> Dünya modelini öğrenmek için deterministik tahmin-kod çözücü
</center>

Şekil 8'de gösterildiği gibi, tahmin modülü tarafından sağlanan bir dizi durumumuz ($s_{1:t}$) ve aksiyonumuz ($a_t$) var. Tahmin modülü , kod çözücüye aktarılan geleceğin gizli bir temsilini çıkarır. Kod çözücü, geleceğin gizli temsilinin kodunu çözer ve bir tahmin çıkarır.($\hat s_{t+1}$). Ardından, tahmin $\hat s_{t+1}$ ve hedef  $s_{t+1}$ arasındaki MSE'yi en aza indirerek modelimizi eğitiyoruz.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure9.png" style="zoom: 20%; background-color:#DCDCDC;" /><br>
<b>Şekil 9:</b> Gerçek gelecek *vs.* Deterministik gelecek
</center>

Maalesef bu işe yaramıyor!

Deterministik çıktının çok bulanık hale geldiğini görüyoruz. Bunun nedeni, modelimizin gelecekteki tüm olasılıkların ortalamasını almasıdır. Bu, daha önce birkaç derste tartışılan geleceğin multimodalitesiyle karşılaştırılabilir, orijine yerleştirilen bir kalemin rastgele düştüğü yer. Tüm lokasyonların ortalamasını alırsak, bu bize kalemin hiç hareket etmediği inancını verir ve bu yanlıştır.

Modelimize gizli değişkenler ekleyerek bu sorunu çözebiliriz.


<!--## [Variational predictive network](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

To solve the problem stated in the previous section, we add a low dimensional latent variable $z_t$ to the original network which goes through an expansion module $f_{exp}$ to match the dimensionality.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 10:</b> Variational predictive network - train
</center>

The $z_t$ is chosen such that the MSE is minimized for a specific prediction. By tuning the latent variable, you can still get MSE to zero by doing gradient descent into latent space. But this is very expensive. So, we can actually predict that latent variable using an encoder. Encoder takes the future state to give us a distribution with a mean and variance from which we can sample $z_t$.

During training, we can find out what is happening by looking into the future and getting information from it and use that information to predict the latent variable. However, we don't have access to the future during testing time. We fix this by enforcing the encoder to give us a posterior distribution as close as possible to the prior by optimizing KL divergence.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 11:</b> Variational predictive network - train (with prior distribution)
</center>

Now, let us look at the inference - How do we drive?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>Figure 12:</b> Variational predictive network - inference
</center>

We sample the low-dimensional latent variable $z_t$ from the prior by enforcing the encoder to shoot it towards this distribution. After getting the prediction $\hat s_{t+1}$, we put it back (in an auto-regressive step) and get the next prediction $\hat s_{t+2}$ and keep feeding the network this way.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>Figure 13:</b> Actual future *vs.* Deterministic
</center>

On the right hand side in the above figure, we can see four different draws from the normal distribution. We start with same initial state and provide different 200 values to the latent variable.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Figure 14:</b> Actual future *vs.* Deterministic - after movement
</center>

We can notice that providing different latent variables generates different sequences of states with different behaviours. Which means we have a network that generates the future. Quite fascinating!

What's next?

We can now use this huge amount of data to train our policy by optimizing the lane and proximity costs described above.

These multiple futures come from the sequence of latent variables that you feed to the network. If you perform gradient ascent - in the latent space, you try to increase the proximity cost so you get the sequence of latent variables such that the other cars are going to be driving into you.-->
## [Varyasyonel tahmin ağı](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=1779s)

Önceki bölümde belirtilen problemi çözmek için, orijinal ağa, boyutları eşitlemek için bir genişletme modülünden $f_ {exp}$ geçen düşük boyutlu bir gizli değişken $z_t$ ekliyoruz.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure10.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 10:</b> Varyasyonel tahmin ağı - eğitim
</center>

$z_t$, MSE'nin belirli bir tahmin için en aza indirileceği şekilde seçilir. Gizli değişkeni ayarlayarak, gizli alanda (latent space) gradyan inişi yaparak MSE'yi sıfıra getirebilirsiniz. Ancak bu çok pahalıdır. Bir kodlayıcı kullanarak bu gizli değişkeni aslında tahmin edebiliriz. Kodlayıcı gelecek durumu alıp bize $z_t$ 'yi örnekleyebileceğimiz ortalama ve varyansa sahip bir dağılım verir.

Eğitim sırasında, geleceğe bakarak ve kodlayıcıdan bilgi alarak neler olup bittiğini öğrenebilir ve bu bilgiyi gizli değişkeni tahmin etmek için kullanabiliriz. Ancak, test sırasında geleceğe erişimimiz yoktur. KL sapmasını optimize ederek kodlayıcıyının bize öncüle olabildiğince yakın bir ardıl dağıtım sağlamaya zorlayıp bu sorunu çözebiliriz.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure11.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 11:</b> Varyasyonel tahmin ağı - eğitim (öncül dağıtımla)
</center>

Şimdi, çıkarıma bakalım - Nasıl sürüyoruz?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure12.png" style="zoom: 32%; background-color:#DCDCDC;" /><br>
<b>Şekil 12:</b> Varyasyonel tahmin ağı - çıkarım
</center>

Düşük boyutlu gizli değişkeni $z_t$ kodlayıcıyı bu dağıtıma doğru çekmeye zorlayarak öncülden örnekliyoruz. Tahmini $\hat s_{t+1}$ aldıktan sonra, geri koyarız (otomatik gerileyen bir adımda) ve sonraki tahminini $\hat s_{t+2}$ alırız ve ağı bu şekilde beslemeye devam ederiz.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure13.png" style="zoom: 22%; background-color:#DCDCDC;" /><br>
<b>Şekil 13:</b> Gerçek gelecek * vs * Deterministik
</center>

Yukarıdaki şekilde sağ tarafta, normal dağılımdan dört farklı çekiliş görebiliriz. Aynı başlangıç durumu ile başlıyoruz ve gizli değişkene farklı 200 değer sağlıyoruz.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure14.png" style="zoom: 30%; background-color:#DCDCDC;" /><br>
<b>Şekil 14:</b> Gerçek gelecek * vs * Deterministik - hareketten sonra
</center>

Farklı gizli değişkenler sağlamanın, farklı davranışlara sahip farklı durum dizileri oluşturduğunu fark edebiliriz. Bu da geleceği üreten bir ağımız olduğu anlamına geliyor. Oldukça etkileyici!

Sırada?

Artık yukarıda açıklanan şerit ve yakınlık maliyetlerini optimize ederek politikamızı eğitmek için bu büyük miktardaki veriyi kullanabiliriz.

Bu bir çok gelecek, ağa beslediğiniz gizli değişkenler dizisinden gelir. Gizli alanda, gradyan tırmanışı gerçekleştirirseniz, yakınlık maliyetini artırmaya çalışırsınız, böylece diğer arabaların size yakınlaşacağı şekilde gizli değişkenlerin sırasını elde edersiniz.

<!--## Action insensitivity & latent dropout

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 15:</b> Issues - Action Insensitivity
</center>

Given that you actually have access to the future, if you turn to the left even slightly, everything is going to be turning to the right and that will contribute in a huge way to the MSE. The MSE loss can be minimized if the latent variable can inform the bottom part of the network that everything is going to turn to the right - which is not what we want! We can tell when everything turns to the right since that is a deterministic task.

The big arrow in Figure 15 signifies a leak of information and therefore it was not any more sensitive to the current action being provided to the predictor.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 16:</b> Issue - Action Insensitivity
</center>

In figure 16, in the rightmost diagram we have the real sequence of latent variables (the latent variables that allow us to get the most precise future) and we have the real sequence of actions taken by the expert. The two figures to the left of this one have randomly sampled latent variables but the real sequence of actions so we expect to see the steering. The last one on the left-hand side has the real sequence of latent variable but arbitrary actions and we can clearly see that the turning came mostly from the latent rather than the action, which encodes the rotation and the action (which are sampled from other episodes).

How to fix this problem?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 17:</b> Fix - Latent Dropout
</center>

The problem is not a memory leak but an information leak. We fix this problem by simply dropping out this latent and sampling it from the prior distribution at random. We don't always rely on the output of the encoder ($f_{enc}$) but pick from the prior. In this way, you cannot encode the rotation in the latent variable any more. In this way, information gets encoded in the action rather than the latent variable.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 18:</b> Performance with latent dropout
</center>

In the last two images on the right-hand side, we see two different sets of latent variables having a real sequence of actions and these networks have been trained with the latent dropout trick. We can now see that the rotation is now encoded by the action and no longer by the latent variables.-->
## Eylem duyarsızlığı ve iletim sönümü(dropout)

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure15.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 15:</b> Sorunlar - Eylem Duyarsızlığı
</center>

Geleceğe erişiminiz olduğu göz önüne alındığında, biraz sola dönerseniz, her şey sağa dönecektir ve bu MSE'ye çok büyük bir katkı sağlayacaktır. Gizli değişken ağın alt kısmına her şeyin sağa döneceğini bildirebilirse, MSE kaybı en aza indirilebilir - ki bu bizim istediğimiz şey değil! Her şeyin ne zaman sağa döndüğünü söyleyebiliriz çünkü bu deterministik bir iştir.

Şekil 15'teki büyük ok bir bilgi sızıntısını gösterir ve bu nedenle tahmin ediciye sağlanan mevcut eyleme artık duyarlı değildir.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure16.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 16:</b> Sorunlar - Eylem Duyarsızlığı
</center>

Şekil 16'da, en sağdaki diyagramda, gizli değişkenlerin (en kesin şekilde geleceği elde etmemizi sağlayan gizli değişkenler) gerçek sırasına sahibiz ve ayrıca bir uzman tarafından gerçekleştirilen eylemlerin gerçek sırasına da sahibiz. Bunun solundaki iki figür, rastgele örneklenmiş gizli değişkenlere ancak gerçek eylem dizisine sahiptir, bundan dolayı direksiyon hareketini görmeyi bekliyoruz. Sol taraftaki sonuncusu, gizli değişkenlerin gerçek sırasına ancak keyfi eylemlere sahiptir.  Ve dönüşün, eylemi (diğerinden örneklenen) kodlayan eylemden ziyade çoğunlukla gizli olandan geldiğini açıkça görebiliriz.

Bu sorun nasıl çözülür?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure17.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 17:</b> Düzeltme - İletim sönümü
</center>

Sorun bellek sızıntısı değil, bilgi sızıntısıdır.Bu sorunu basitçe bu gizliliği sönümleyip öncül dağıtımdan rastgele örnekleyerek çözüyoruz. Her zaman kodlayıcının($f_{enc}$) çıktısına güvenmeyip, öncülden seçiyoruz. Bu şekilde, artık dönüşü gizli değişkende kodlayamazsınız. Bu şekilde bilgi, gizli değişken yerine eylemde kodlanır.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure18.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 18:</b> Gizli İletim sönümü (Latent Dropout) ile performans
</center>

Sağ taraftaki son iki görüntüde, gerçek bir eylem dizisine sahip iki farklı gizli değişken kümesi görüyoruz ve bu ağlar, gizli iletim sönümü numarasıyla eğitilmiş. Artık dönüşün eylem tarafından kodlandığını gizli değişkenler tarafından kodlanmadığını görebiliriz.


<!--## [Training the agent](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

In the previous sections, we saw how we can obtain a world model by simulating real world experiences.  In this section, we will use this world model to train our agent.  Our goal is to learn the policy to take an action given the history of previous states.  Given a state $s_t$ (velocity, position & context images), the agent takes an action $a_t$ (acceleration, brake & steering), the world model outputs a next state and cost associated with that $(s_t, a_t)$ pair which is a combination of proximity cost and lane cost.

$$
c_\text{task} = c_\text{proximity} + \lambda_l c_\text{lane}
$$

As discussed in the previous section, to avoid hazy predictions, we need to sample latent variable $z_t$ from the encoder module of the future state $s_{t+1}$ or from prior distribution $P(z)$.  The world model gets previous states $s_{1:t}$, action taken by our agent and latent variable $z_t$ to predict the next state $\hat s_{t+1}$ and the cost.  This constitutes one module that is replicated multiple times (Figure 19) to give us final prediction and loss to optimize.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 19:</b> Task specific model architecture
</center>

So, we have our model ready.  Let’s see how it looks !!

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 20:</b> Learned policy: Agent either collides or moves away from the road
</center>

Unfortunately, this does not work.  Policy trained this way is not useful as it learns to predict all black since it results in zero cost.

How can we address this issue? Can we try imitating other vehicles to improve our predictions?-->
## [Ajanın Eğitimi](https://www.youtube.com/watch?v=VcrCr-KNBHc&t=3232s)

Önceki bölümlerde gerçek dünya deneyimlerini simüle ederek nasıl bir dünya modeli elde edebileceğimizi gördük.  Bu bölümde, ajanımızı eğitmek için bu dünya modelini kullanacağız.  Amacımız, önceki durum serileri göz önüne alındığında aksiyon almak için bir politika öğrenmektir.  Verilen duruma $s_t$(hız, pozisyon, resim) göre ajan bir aksiyon$a_t$ alır (hızlanma, durma, dönme), dünya modeli bir sonraki durumu ve o duruma bağlı olan yakınlık ve şerit maliyetinin kombinasyonu olan maliyeti $(s_t, a_t)$ üretir.


$$
c_\text{görev} = c_\text{yakınlık} + \lambda_l c_\text{şerit}
$$

Önceki bölümde tartışıldığı gibi, belirsiz tahminlerden kaçınmak için,  gelecek durumunun $s_{t+1}$ kodlayıcı modülünden veya öncül dağıtım $P(z)$ 'dan gizli değişken $z_t$ örneklememiz gerekir.  Dünya modeli önceki durumları $s_{1:t}$, ajanımız tarfından alınan aksiyonu, ve  gizli değişken $z_t$'yi alıp gelecek durumu $\hat s_{t+1}$ ve maliyeti tahmin eder.  Bu, bize nihai tahmini ve optimize etmemiz gereken zararı vermek için birden çok kez tekrarlanan (Şekil 19) bir modül oluşturur.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure19.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 19:</b> Göreve özgü model mimarisi
</center>

Yani modelimizi hazırladık. Nasıl göründüğüne bakalım !!

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure20.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 20:</b> Öğrenilen politika: Ajan çarpışır veya yoldan uzaklaşır
</center>

Maalesef bu işe yaramıyor. Bu şekilde eğitilen politika, sıfır maliyetle sonuçlandığı ve her şeyi siyah olarak tahmin etmeyi öğrendiği için kullanışlı değildir.

Bu sorunu nasıl çözebiliriz? Tahminlerimizi iyileştirmek için diğer araçları taklit etmeyi deneyebilir miyiz?


<!--## Imitating the expert

How do we imitate the experts here? We want the prediction of our model after taking a particular action from a state to be as close as possible to the actual future. This acts as an expert regulariser for our training. Our cost function now includes both the task specific cost(proximity cost and lane cost) and this expert regulariser term. Now as we are also calculating the loss with respect to the actual future, we have to remove the latent variable from the model because the latent variable gives us a specific prediction, but this setting works better if we just work with the average prediction.

$$
\mathcal{L} = c_\text{task} + \lambda u_\text{expert}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 21:</b>  Expert regularization based model architecture
</center>

So how does this model perform?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Learned policy by imitating the experts
</center>

As we can see in the above figure, the model actually does incredibly well and learns to make very good predictions. This was model based imitation learning, we tried to model our agent to try to imitate others.

But can we do better?
Did we just train the Variational Autoencoder to remove it in the end?

It turns out we can still improve if we look to minimize the uncertainty of the forward model predictions.-->
## Uzmanı Taklit Etmek

Buradaki uzmanları nasıl taklit ederiz? Bir durumdayken belirli bir eylem yaptıktan sonra modelimizin öngörüsünün gerçek geleceğe mümkün olduğunca yakın olmasını istiyoruz. Bu, eğitimimiz için uzman bir düzenleyici görevi görür. Maliyet fonksiyonumuz artık hem göreve özel maliyeti (yakınlık maliyeti ve şerit maliyeti) hem de bu uzman düzenleyici terimini içerir.Şimdi, gerçek geleceğe göre kaybı da hesapladığımız için, gizli değişkeni modelden çıkarmalıyız çünkü gizli değişken bize belirli bir tahmin verir, ancak bu koşullarda, sadece ortalama tahminle çalışırsak modelimiz daha iyi çalışır.

$$
\mathcal{L} = c_\text{görev} + \lambda u_\text{uzman}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure21.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 21:</b>  Uzman düzenleme tabanlı model mimarisi
</center>

Peki bu model nasıl çalışıyor?

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure22.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 22:</b> Uzmanları taklit ederek öğrenilen politika
</center>

Yukarıdaki şekilde görebileceğimiz gibi, model aslında inanılmaz derecede iyi işliyor ve çok iyi tahminler yapmayı öğreniyor. Bu model tabanlı taklit öğrenmeydi, ajanımızı başkalarını taklit etmek için modellemeye çalıştık.

Ama daha iyisini yapabilir miyiz?
Sadece sonunda kaldırmak için mi Variational Autoencoder'ı eğittik ?

İleriye dönük model tahminlerinin belirsizliğini en aza indirmeye çalışırsak, hala modelimizi iyileştirebiliriz .


<!--## Minimizing the Forward Model Uncertainty

What do we mean by minimizing forward model uncertainty and how would we do it? Before we answer that, let’s recap something we saw in the third week’s practicum.

If we train multiple models on the same data, all those models agree on the points in the training region (shown in red) resulting in zero variance in the training region. But as we move further away from the training region, the trajectories of loss functions of these models start diverging and variance increases. This is depicted in the figure 23.  But as the variance is differentiable, we can run gradient descent over the variance in order to minimize it.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Cost visualization across the entire input space
</center>

Coming back to our discussion, we observe that learning a policy using only observational data is challenging because the distribution of states it produces at execution time may differ from what was  observed during the training phase. The world model may make arbitrary predictions outside the domain it was trained on, which may wrongly result in low cost. The policy network may then exploit these errors in the dynamics model and produce actions which lead to wrongly optimistic states.

To address this, we propose an additional cost which measures the uncertainty of the dynamics model about its own predictions. This can be calculated by passing the same input and action through several different dropout masks, and computing the variance across the different outputs.  This encourages the policy network to only produce actions for which the forward model is confident.

$$
\mathcal{L} = c_\text{task} + \lambda c_\text{uncertainty}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Uncertainty regulariser based model architecture
</center>

So, does uncertainty regulariser help us in learning better policy?

Yes, it does. The policy learned this way is better than the previous models.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Learned policy based on uncertainty regulariser
</center>-->

## İleri Model Belirsizliğini En Aza İndirmek

İleriye dönük model belirsizliğini en aza indirgemekle ne demek istiyoruz ve bunu nasıl yapacağız? Bunu yanıtlamadan önce, üçüncü hafta uygulamasında gördüğümüz bir şeyi özetleyelim.

Aynı veriler üzerinde birden fazla model eğitirsek, tüm bu modeller eğitim bölgesindeki (kırmızıyla gösterilen) noktalar üzerinde anlaşarak eğitim bölgesinde sıfır varyansla sonuçlanır. Ancak eğitim bölgesinden uzaklaştıkça, bu modellerin kayıp fonksiyonlarının yörüngeleri farklılaşmaya başlar ve varyans artar. Bu, şekil 23'te tasvir edilmiştir. Ancak varyans türevlenebilinir olduğundan, minimize etmek için varyans üzerinde gradyan inişi uygulayabiliriz.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure23.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Şekil 23:</b> Tüm girdi alanı boyunca maliyetin görselleştirmesi
</center>

Tartışmamıza geri dönersek, sadece eğitim verileri kullanarak bir politika öğrenmenin zor olduğunu gözlemliyoruz çünkü test zamanındaki durumların dağılımı, eğitim aşamasında gözlemlenenden farklı olabilir. Dünya modeli, eğitim aldığı alan dışında keyfi tahminlerde bulunabilir ve bu da yanlış bir şekilde düşük maliyetle sonuçlanabilir. Politika ağı daha sonra dinamik modeldeki bu hataları kullanabilir, aslında yanlışlıkla iyimser durumlara yol açan eylemler üretebilir.

Bunu ele almak için, dinamik modelin kendi tahminlerine ilişkin belirsizliğini ölçen ek bir maliyet öneriyoruz. Bu, aynı girdi ve eylemi birkaç farklı ileti sönümleme maskesinden geçirerek ve farklı çıktılar arasındaki varyansa bakarak hesaplanabilir. Bu, politika ağını yalnızca ileri modelin kendinden emin olduğu eylemler üretmeye teşvik eder.

$$
\mathcal{L} = c_\text{görev} + \lambda c_\text{belirsizlik}
$$

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure24.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 24:</b> Belirsizlik düzenleyici tabanlı model mimarisi
</center>

Peki, belirsizlik düzenleyici daha iyi politika öğrenmemize yardımcı olur mu?


Evet öyle. Bu şekilde öğrenilen politika önceki modellerden daha iyidir.

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure25.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Şekil 25:</b> Belirsizlik düzenleyiciye dayalı öğrenilen politika
</center>


<!--## Evaluation

Figure 26 shows how well our agent learned to drive in dense traffic.  Yellow car is the original driver, blue car is our learned agent and all green cars are blind to us (cannot be controlled).

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Performance of model with uncertainty regulariser
</center>-->
## Değerlendirme

Şekil 26, temsilcimizin yoğun trafikte araç kullanmayı ne kadar iyi öğrendiğini gösteriyor. Sarı araba orijinal sürücüdür, mavi araba öğrenilmiş temsilcimizdir ve tüm yeşil arabalar bize göre kördür (kontrol edilemez).

<center>
<img src="{{site.baseurl}}/images/week11/11-3/figure26.gif" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Şekil 26:</b> Belirsizlik düzenleyicili modelin performansı
</center>
