---
lang-ref: ch.09-3
lang: tr
title: Üretici Çekişmeli Ağlar
lecturer: Alfredo Canziani
authors: William Huang, Kunal Gadkar, Gaomin Wu, Lin Ye
date: 31 Mar 2020
translation-date: 18 JUn 2020
translator: emirceyani
---

<!-- title: Generative Adversarial Networks -->

## [Çekişmeli Üretici Ağlara Giriş (GANs)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s)
<!-- ## [Introduction to generative adversarial networks (GANs)](https://www.youtube.com/watch?v=xYc11zyZ26M&t=57s) -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANArchitecture.png" height="400px" /><br>
<b>Şekil 1</b>: GAN Yapısı
 <!-- GAN Architecture -->
</center>

GAN'lar denetimsiz makine öğrenmesinde kullanılan bir sinir ağı türüdür. İki adet çekişmeli modülden oluşurlar:  _üretici_ (generator) ve _maliyet_ (cost) ağları. Bu modüllerden _maliyet_ ağı sahte örnekleri filtrelemeye çalışırken _üretici_ ağı da gerçekçi örnekler $\vect{\hat{x}}$ üreterek _maliyet_ ağını kandırmaya çalışır. Bu rekabet ile model gerçekçi veri üretebilen bir üretici öğrenir. Bu üreticiler geleceği tahmin etme veya belirli bir veri kümesi üzerinde eğitildikten sonra, görüntü oluşturma gibi görevlerde kullanılabilir.

 <!--
GANs are a type of neural network used for unsupervised machine learning. They are comprised of two adversarial modules: _generator_ and _cost_ networks. These modules compete with each other such that the _cost_ network tries to filter fake examples while the _generator_ tries to trick this filter by creating realistic examples $\vect{\hat{x}}$. Through this competition, the model learns a generator that creates realistic data. They can be used in tasks such as future predictions or for generating images after being trained on a particular dataset. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANMapping.png" height="400px" /><br>
<b>Şekil 2</b>: Rastgele Değişkenden GAN Bağlanımı
 <!-- GAN Mapping from Random Variable -->
</center>

GAN'lar, enerji bazlı modellerin (EBM) örneklerinden bir tanesidir. Öyle ki, maliyet ağı, Şekil 2'de görüldüğü üzere, pembe ile ifade edilmiş gerçek veri dağılımına $\vect{x}$ yakın girdiler için düşük maliyet üretmesi için eğitilir. Diğer dağılımlardan gelen verilerin (Şekil 2'deki mavi noktalar, $\vect{\hat{x}}$) maliyetlerinin de yüksek olması gerekir. Maliyet ağının performansını ölçmek için ortalama karesel hata (MSE) kullanılabilir. Önemli bir nokta ise, maliyet fonksiyonu belirli bir aralıkta kısıtlı, pozitif skaler değerleri çıktı olarak verir ($\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). Bildiğimiz ayrıştırıcılarda ise çıktılar ayrık bir biçimde birbirlerinden ayırılır.

<!--
GANs are examples of energy based models (EBMs). As such, the cost network is trained to produce low costs for inputs closer to the true data distribution denoted by the pink $\vect{x}$ in Fig. 2. Data from other distributions, like the blue $\vect{\hat{x}}$ in Fig. 2, should have high cost. A mean squared error (MSE) loss is typically used to calculate the cost network's performance. It is worth noting that the cost function outputs a positive scalar value within a specified range (i.e. $\text{cost} : \mathbb{R}^n \rightarrow \mathbb{R}^+ \cup \{0\}$). This is unlike a classic discriminator which uses discrete classification for its outputs. -->

Üretici ağ ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) ise rastgele değişken $\vect{z}$'yi gerçekçi üretilmiş veriye bağlayan bağlanımı iyileştirmek için eğitilir. Üretici, maliyet ağının çıktısına göre eğitilir ve $\vect{\hat{x}}$'nin enerjisini minimize etmeye çalışır. Bu enerjiyi $C(G(\vect{z}))$ ile belirtelim, burada $C(\cdot)$ maliyet ağını ve $G(\cdot)$ üretici ağını temsil etmektedir.

<!-- Meanwhile, the generator network ($\text{generator} : \mathcal{Z} \rightarrow \mathbb{R}^n$) is trained to improve its mapping of random variable $\vect{z}$ to realistic generated data $\vect{\hat{x}}$ to trick the cost network. The generator is trained with respect to the cost network's output, trying to minimize the energy of $\vect{\hat{x}}$. We denote this energy as $C(G(\vect{z}))$, where $C(\cdot)$ is the cost network and $G(\cdot)$ is the generator network. -->

Maliyet ağının eğitimi MSE hatasını minimize etmeye dayalı iken üretici ağın eğitimi de maliyet ağını $C(\vect{\hat{x}})$'nin $\vect{\hat{x}}$'e göre gradyanları ile minimize ederek gerçekleşir.

<!--
The training of the cost network is based on minimizing the MSE loss, while the training of the generator network is through minimizing the cost network, using gradients of $C(\vect{\hat{x}})$ with respect to $\vect{\hat{x}}$. -->

Veri manifoldunun dışındaki noktalara yüksek maliyet ve manifoldun içindeki noktalara düşük maliyet atamayı sağlamak için, maliyet ağının kayıp fonksiyonu $\mathcal{L}\_{C} = C(x)+[m-C(G(\vect{z}))]^+$ belli bir pozitif aralık $m$ için tanımlanmıştır. $\mathcal{L}\_{C}$'yi minimize etmek, $C(\vect{x}) \rightarrow 0$ ve $C(G(\vect{z})) \rightarrow m$'yi gerektirir. Üreticinin kayıp fonksiyonu $\mathcal{L}\_{G}$, üretici için $C(G(\vect{z})) \rightarrow 0$  durumu olması için teşvikleyen $C(G(\vect{z}))$ terimidir. Ancak, bu durum dengesizlik yaratmaktadır çünkü
$0 \leftarrow C(G(\vect{z})) \rightarrow m$.

<!-- To ensure that high cost is assigned to points outside the data manifold and low cost is assigned to points within it, the loss function for the cost network $\mathcal{L}\_{C}$ is $C(x)+[m-C(G(\vect{z}))]^+$ for some positive margin $m$. Minimizing $\mathcal{L}\_{C}$ requires that $C(\vect{x}) \rightarrow 0$ and $C(G(\vect{z})) \rightarrow m$. The loss for the generator $\mathcal{L}\_{G}$ is simply $C(G(\vect{z}))$, which encourages the generator to ensure that $C(G(\vect{z})) \rightarrow 0$. However, this does create instability as $0 \leftarrow C(G(\vect{z})) \rightarrow m$. -->


## [GAN ve VAE Arasındaki Fark](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s)

<!-- ## [Difference between GANs and VAEs](https://www.youtube.com/watch?v=xYc11zyZ26M&t=1844s) -->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEArchitecture.png" height="400px" /><br>
<b>Şekil 3</b>: VAE (solda) - GAN (sağda) - Mimari tasarım
 <!-- VAE (left) vs. GAN (right) - Architectural design -->
</center>

Sekizinci haftada işlediğimiz Değişimsel Otokodlayıcılar (VAE) ile kıyaslandığında, GAN üreticileri farklı bir şekilde oluşturur. VAE'ler girdileri $\vect{x}$'i saklı uzay $\mathcal{Z}$'ye bir _kodlayıcı_ (encoder) ile bağlar ve $\mathcal{Z}$'den veriye  $\vect{\hat{x}}$ bir _kodçözümleyici_ (decoder) ile geri bağlar. Sonra, $\vect{\hat{x}}$'i $\vect{x}$'e gerioluşturarak benzetmeye çalışır. GAN'lar ise yukarıda açıklandığı gibi rekabet eden üretici ve maliyet ağları arasındaki çekişmeli bir ortamda eğitilir. Bu ağlar, geri yayılım yoluyla peş peşe eğitilir. Bu yapıların farkları Şekil 3'te görülebilir.

<!-- Compared to Variational Auto-Encoders (VAEs) from week 8, GANs create generators slightly differently. Recall, VAEs map inputs $\vect{x}$ to a latent space $\mathcal{Z}$ with an _encoder_ and then maps from $\mathcal{Z}$ back to the data space with a _decoder_ to get $\vect{\hat{x}}$. It then uses the reconstruction loss to push $\vect{x}$ and $\vect{\hat{x}}$ to be similar. GANs, on the other hand, train through an adversarial setting with the generator and cost networks competing as described above. These networks are successively trained through backpropagation through gradient based methods. Comparison of this architectural difference can be seen in Fig. 3.
-->

<center>
<img src="{{site.baseurl}}/images/week09/09-3/GANvsVAEMapping.jpg" height="250px" /><br>
<b>Şekil 4</b>: VAE (solda) - GAN (sağda) - Saklı Değişken $\vect{z}$'den Bağlanım
 <!--  VAE (left) vs. GAN (right) - Mapping from Random Sample $\vect{z}$ -->
</center>

GAN'lar $\vect{z}$'yi üretme ve kullanmaları bakımından da VAE'lerden ayrılır. GAN'lar tıpkı VAE'lerdeki saklı uzay gibi $\vect{z}$'yi örnekleyerek başlar. Sonra, üretici ağları ile $\vect{z}$'yi $\vect{\hat{x}}$'ye bağlar. Üretilen örnek $\vect{\hat{x}}$, ayrıştırıcıya ne kadar "gerçek" olup olmadığını ölçmek için gönderilir. VAE ve GAN arasındaki temel farklılıklardan biri de, **gerçek çıktı $\vect{x}$ ile üretici ağın çıktısı  $ \ vect {\ hat {x}} $ arasında doğrudan bir ilişki  (*yani* yeniden yapılandırma kaybı) ölçmemize gerek olmamasıdır.** Aksine, üreticiyi ayrıştırıcının $\vect{x}$ için verdiği skorlara benzer skorlar verebilen $\vect{\hat{x}}$ üretmesi için eğiterek  $\vect{\hat{x}}$'i $\vect{x}$'e benzemeye zorluyoruz.

<!-- GANs also differ from VAEs through how they produce and use $\vect{z}$. GANs start by sampling $\vect{z}$, similar to the latent space in a VAE. They then use a generative network to map $\vect{z}$ to $\vect{\hat{x}}$. This $\vect{\hat{x}}$ is then sent through a discriminator/cost network to evaluate how "real" it is. One of the main differences from VAE and GAN is that **we do not need to measure a direct relationship (*i.e.* reconstruction loss) between the output of the generative network $\vect{\hat{x}}$ and real data $\vect{x}$.** Instead, we force $\vect{\hat{x}}$ to be similar to $\vect{x}$ by training the generator to produce $\vect{\hat{x}}$ such that the discriminator/cost network produces scores that are similar to those of real data $\vect{x}$, or more "real". -->


## GAN'ın Önemli Sorunları

<!--## Major pitfalls in GANs -->

GAN'lar ile oldukça güçlü üreticilere sahip olabilsek de, GAN mimarisinde henüz çözümü olmayan önemli problemler mevcuttur.

<!-- While GANs can be powerful for building generators, they have some major pitfalls. -->


### 1. Dengesiz Yakınsama (Unstable convergence)

<!--### 1. Unstable convergence -->

Üretici eğitimle geliştikçe, ayrıştırıcı (discriminator) performansı kötüleşmekte çünkü ayrıştırıcı artık gerçek ile sahte veri arasındaki farkı kolaylıkla belirtemez olur. Eğer üretici mükemmel bir üretici ise, gerçek ve sahte verilerin manifoldları üst üste binmiş olacak ve ayrıştırıcı çok fazla hatalı sınıflandırma yapıcaktır.

<!--As the generator improves with training, the discriminator performance gets worse because the discriminator can no longer easily tell the difference between real and fake data. If the generator is perfect, then the manifold of the real and fake data will lie on top of each other and the discriminator will create many misclassifications. -->

Bu durum, GAN'ların yakınsamasında, yani sistemin bir çözüme kavuşmasında büyük bir sorun teşkil eder: ayrıştırıcının geri dönütü zamanla gücünü yitirir. Eğer GAN ayrıştırıcısı tamamiyle rastgele dönütler verirken eğitime devam edersek, üretici de çöp niteliğinde dönütler ile eğitilmeye başlar ve üreticinin kalitesi de çöküntüye uğrayabilir. [Bkz. [GAN'larda eğitim yakınsaması](https://developers.google.com/machine-learning/gan/training)]

<!-- This poses a problem for convergence of the GAN: the discriminator feedback gets less meaningful over time. If the GAN continues training past the point when the discriminator is giving completely random feedback, then the generator starts to train on junk feedback and its quality may collapse. [Refer to [training convergence in GANs](https://developers.google.com/machine-learning/gan/training)] -->

Üretici ve ayrıştırıcı arasındaki rekabetçi ortamın sonucu dengeden ziyade dengesizliklere sebep vermekterdir.

<!-- As a result of this adversarial nature between the generator and discriminator there is an unstable equilibrium point rather than an equilibrium. -->


###  2. Sönümlenen Gradyan

<--! ###  2. Vanishing gradient -->

Varsayalım ki, GAN için ikili çapraz entropi (binary cross entropy) kayıp fonksıyonu kullanıyoruz:

<!-- Let's consider using the binary cross entropy loss for a GAN: -->

$$
\mathcal{L} = \mathbb{E}_\boldsymbol{x}[\log(D(\boldsymbol{x}))] + \mathbb{E}_\boldsymbol{\hat{x}}[\log(1-D(\boldsymbol{\hat{x}}))] \text{.}
$$

Ayrıştırıcı gitgide sonuçlarına güvenmeye başlayınca, $D(\vect{x})$ $1$'e ve $D(\vect{\hat{x}})$ 'da $0$'a yaklaşacak. Ayrıştırıcının güveni, maliyet ağının çıktılarını gradyanların doyduğu düz bölgelere taşıyacak. Bu düz bölgeler, üretici ağının eğitimini aksatmasına sebebiyet verecek olan sönümlenmiş gradyanların bol olduğu bölgelerdir. Bu yüzden, GAN eğitirken, ayrıştırıcı kendine güvendikçe, hatanın da kademeli olarak arttığından emin olmalıyız.

<!-- As the discriminator becomes more confident, $D(\vect{x})$ gets closer to $1$ and $D(\vect{\hat{x}})$ gets closer to $0$. This confidence moves the outputs of the cost network into flatter regions where the gradients become more saturated. These flatter regions provide small, vanishing gradients that hinder the generator network's training. Thus, when training a GAN, you want to make sure that the cost gradually increases as you become more confident. -->


### 3. Mod Çökmesi

<--! ### 3. Mode collapse -->

Eğer üretici, tüm $\vect{z}$'leri ayrıştırıcıyı kandırabilecek **bir tane** örneğe $\vect{\hat{x}}$'e bağlarsa, üretici **sadece**  bu $\vect{\hat{x}}$ üretir. Eninde sonunda, ayrştırıcı da **spesifik olarak** bu sahte girdiyi öğrenecektir. Sonuç olarak, üretici de sonraki en uygun $\vect{\hat{x}}$'i kullanır ve bu süreç sürekli devam eder. Böylelikle, ayrıştırıcı sahte $\vect{\hat{x}}$'leri mütemadiyen ayıklarken yerel minima'dan (lokal minima) kaçamaz. Bu soruna olası bir çözüm, üreticiye farklı girdiler verildiğinde aynı çıktıyı verirse miktar ceza uygulamaktır.

<!--  If a generator maps all $\vect{z}$'s from the sampler to a **single** $\vect{\hat{x}}$ that can fool the discriminator, then the generator will produce **only** that $\vect{\hat{x}}$. Eventually, the discriminator will learn to detect *specifically* this fake input. As a result, the generator simply finds the next most plausible $\vect{\hat{x}}$ and the cycle continues. As a result, the discriminator gets trapped in local minima while cycling through fake $\vect{\hat{x}}$'s. A possible solution to this issue is to enforce some penalty to the generator for always giving the same output given different inputs. -->


## [Derin Evrişimsel Üretici Çekişken Ağ (Deep Convolutional Generative Adversarial Network, DCGAN) kaynak kodu](https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s)

<!--## [Deep Convolutional Generative Adversarial Network (DCGAN) source code](https://www.youtube.com/watch?v=xYc11zyZ26M&t=2911s) -->

Bu örneğin kaynak kodunu [burada](https://github.com/pytorch/examples/blob/master/dcgan/main.py) bulabilirsiniz.

<!-- The source code of the example can be found [here](https://github.com/pytorch/examples/blob/master/dcgan/main.py). -->

### Üretici

<!-- ### Generator -->

1. Üretici girdiyi `nn.ConvTranspose2d` modülleriyle büyütür. Her `nn.ConvTranspose2d`'ın ardından da `nn.BatchNorm2d` ve `nn.ReLU` kullanılır.
2. Sıralı (sequential) modülünün sonunda, ağ `nn.Tanh()` fonksiyonunu çıktıyı $(-1,1)$ aralığında sıkıştırmak için kullanır.
3. Rastgele vektör girdisinin boyutu $nz$'dir. Çıktının boyutu ise $nc \times 64 \times 64$'tür. Kanal sayısı $nc$ ile ifade edilmiştir.

<!--
1. The generator upsamples the input using several `nn.ConvTranspose2d` modules separated with `nn.BatchNorm2d` and `nn.ReLU`.
2. At the end of the sequential, the network uses `nn.Tanh()` to squash outputs to $(-1,1)$.
3. The input random vector has size $nz$. The output has size $nc \times 64 \times 64$, where $nc$ is the number of channels. -->

```python
class Generator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # Girdi Z, evriştirilir
            nn.ConvTranspose2d(     nz, ngf * 8, 4, 1, 0, bias=False),
            nn.BatchNorm2d(ngf * 8),
            nn.ReLU(True),
            # Aktivasyon boyutu: (ngf*8) x 4 x 4
            nn.ConvTranspose2d(ngf * 8, ngf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 4),
            nn.ReLU(True),
            # Aktivasyon boyutu: (ngf*4) x 8 x 8
            nn.ConvTranspose2d(ngf * 4, ngf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf * 2),
            nn.ReLU(True),
            # Aktivasyon boyutu: (ngf*2) x 16 x 16
            nn.ConvTranspose2d(ngf * 2,     ngf, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ngf),
            nn.ReLU(True),
            # Aktivasyon boyutu: (ngf) x 32 x 32
            nn.ConvTranspose2d(    ngf,      nc, 4, 2, 1, bias=False),
            nn.Tanh()
            # Aktivasyon boyutu: (nc) x 64 x 64
        )

    def forward(self, input):
        output = self.main(input)
        return output
```

### Discriminator

<!--  ### Ayrıştırıcı-->

1. Aktivasyon fonksiyonu olarak`nn.LeakyReLU`'nun kullanılması, negatif rejimlerde gradyanı yok etmemek açısından oldukça önemlidir. Bu gradyanlar olmadan, üretici güncellenemez.
2. `Sequential()` modülünün sonunda, ayrıştırıcı `nn.Sigmoid()` fonksiyonu ile girdiyi sınıflar.

<!-- 1. It is important to use `nn.LeakyReLU` as the activation function to avoid killing the gradients in negative regions. Without these gradients, the generator will not receive updates.
2. At the end of the sequential, the discriminator uses `nn.Sigmoid()` to classify the input. -->

```python
class Discriminator(nn.Module):
    def __init__(self):
        super().__init__()
        self.main = nn.Sequential(
            # Girdi boyutu (nc) x 64 x 64
            nn.Conv2d(nc, ndf, 4, 2, 1, bias=False),
            nn.LeakyReLU(0.2, inplace=True),
            # Aktivasyon boyutu (ndf) x 32 x 32
            nn.Conv2d(ndf, ndf * 2, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 2),
            nn.LeakyReLU(0.2, inplace=True),
            # Aktivasyon boyutu (ndf*2) x 16 x 16
            nn.Conv2d(ndf * 2, ndf * 4, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 4),
            nn.LeakyReLU(0.2, inplace=True),
            # Aktivasyon boyutu. (ndf*4) x 8 x 8
            nn.Conv2d(ndf * 4, ndf * 8, 4, 2, 1, bias=False),
            nn.BatchNorm2d(ndf * 8),
            nn.LeakyReLU(0.2, inplace=True),
            # Aktivasyon boyutu. (ndf*8) x 4 x 4
            nn.Conv2d(ndf * 8, 1, 4, 1, 0, bias=False),
            nn.Sigmoid()
        )

    def forward(self, input):
        output = self.main(input)
        return output.view(-1, 1).squeeze(1)
```

Bu sınıflar `netG` and `netD` olarak başlatılır.

<!--
These two classes are initialized as `netG` and `netD`. -->


### GAN için Kayıp Fonksiyonu

<!--
### Loss function for GAN-->

Girdi ve çıktı arasında BCE hata fonksiyonunu kullanıyoruz.

<!-- We use Binary Cross Entropy (BCE) between target and output. -->

```python
criterion = nn.BCELoss()
```

### Düzenek

<!-- ### Setup-->

Değişken `fixed_noise`'un boyutunu `opt.batchSize` ve rastgele vektörün uzunluğunu `nz` alıyoruz. Ayrıca, sırasıyla `real_label` ve `fake_label` değişkenleri ile gerçek ve üretilmiş (sahte) verinin etiketlerini belirliyoruz.

<!-- We set up `fixed_noise` of size `opt.batchSize` and length of random vector `nz`. We also create labels for real data and generated (fake) data called `real_label` and `fake_label`, respectively. -->

```python
fixed_noise = torch.randn(opt.batchSize, nz, 1, 1, device=device)
real_label = 1
fake_label = 0
```

Sonra, ayrıştırıcı ve üretici ağlar için eniyileştiricileri (optimizers) kuruyoruz.

```python
optimizerD = optim.Adam(netD.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
optimizerG = optim.Adam(netG.parameters(), lr=opt.lr, betas=(opt.beta1, 0.999))
```

### Eğitim

<!-- ### Training-->

Her eğitim epoku (epoch) iki adımdan oluşur.

<!-- Each epoch of training is divided into two steps. -->

**1. Adım** ayrıştırıcı ağını güncellemektir. Bu da iki aşamada gerçekleşir. Önce, ayrıştırıcıyı `dataloader` modüllerinden gelen gerçek veri ile besler, çıktı ile `real_label` arasındaki hatayı hesaplar, ve gradyanleri geri yayılım ile biriktiririz. Sonra, ayrıştırıcıyı üretici ağın `fixed_noise` ile ürettiği verilerle besler, `fake_label` ile çıktı arasındaki hatayı hesaplar ve gradyanları biriktiririz. Sonunda, biriktirdiğimiz gradyanları, ayrıştırıcı ağın parametrelerini güncellemek için kullanırız.

<!-- **Step 1** is to update the discriminator network. This is done in two parts. First, we feed the discriminator real data coming from `dataloaders`, compute the loss between the output and `real_label`, and then accumulate gradients with backpropagation. Second, we feed the discriminator data generated by the generator network using the `fixed_noise`, compute the loss between the output and `fake_label`, and then accumulate the gradient. Finally, we use the accumulated gradients to update the parameters for the discriminator network. -->

Ayrıştırıcıyı eğitirken, sahte veriyi ayırmamız (detach) gerekir ki üreticinin bu adımda gradyanlara erişmesini önleyebilelim.

<!-- Note that we detach the fake data to stop gradients from propagating to the generator while we train the discriminator. -->

Ayrıca, `zero_grad()` metodunu bu adımın başında kullanmamız gerekiyor çünkü bir önceki güncellemeden kalan gradyanlerı kullanamayız. Her `.backward()` çağrıldığında `.backward()` metodu ayrıştırıcı ve üretici ağların gradyanlerini biriktirir. Son olarak, ayrıştırıcının parametrelerini güncellememiz için `optimizerD.step()`'i çağırmamız yeterli olacaktır.

<!--Also note that we only need to call `zero_grad()` once in the beginning to clear the gradients so the gradients from both the real and fake data can be used for the update. The two `.backward()` calls accumulate these gradients. We finally only need one call of `optimizerD.step()` to update the parameters. -->

```python
# Gerçek veri ile eğit
netD.zero_grad()
real_cpu = data[0].to(device)
batch_size = real_cpu.size(0)
label = torch.full((batch_size,), real_label, device=device)

output = netD(real_cpu)
errD_real = criterion(output, label)
errD_real.backward()
D_x = output.mean().item()

# Sahte veri ile eğit

noise = torch.randn(batch_size, nz, 1, 1, device=device)
fake = netG(noise)
label.fill_(fake_label)
output = netD(fake.detach())
errD_fake = criterion(output, label)
errD_fake.backward()
D_G_z1 = output.mean().item()
errD = errD_real + errD_fake
optimizerD.step()
```
<!--# train with real -->

<!--#train with fake -->

**2. Adım** üretici ağı güncellemektir. Bu sefer, ayrıştırıcıya sahte verileri gönderiyoruz ama hatayı `real_label` ile hesaplıyoruz! Bunu yapmamızın sebebi üreticiyi gerçekçi $\vect{\hat{x}}$'ler ürettirebilmek için eğitmemizdir.

<!--
**Step 2** is to update the Generator network. This time, we feed the discriminator the fake data, but compute the loss with the `real_label`! The purpose of doing this is to train the generator to make realistic $\vect{\hat{x}}$'s. -->

```python
netG.zero_grad()
label.fill_(real_label)  #
output = netD(fake)
errG = criterion(output, label)
errG.backward()
D_G_z2 = output.mean().item()
optimizerG.step()
```
<!--  # fake labels are real for generator cost -->
