---
lang-ref: ch.09-2
lang: tr
lecturer: Yann LeCun
title: Dünya Modelleri ve Üretken Çekişmeli Ağlar
authors: Bofei Zhang, Andrew Hopen, Maxwell Goldstein, Zeping Zhan
date: 30 Mar 2020
translation-date: 18 Jun 2020
translator: emirceyani
---
<!-- title: World Models and Generative Adversarial Networks -->

## [Otonom Kontrol İçin Dünya Modelleri](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=2526s)

Özdenetimli öğrenmenin en önemli kullanım alanlarından biri de kontrol için dünya modellerini öğrenmektir.
Biz insanlar bir eylem gerçekleştirken, dünyanın nasıl çalıştığına dair içsel bir modele sahibiz.
Örneğin, henüz 9 aylıkken, çoğunlukla gözlem yoluyla fizik için bir sezgi kazanırız.
Bu durum bir bakıma özdenetimli öğrenmeye benzer; neler olacağını tahmin etmeyi öğrenirken, özdenetimli öğrenmede saklı değişkenleri öğrendiğimiz gibi.
Bunu ilerletirsek, içsel modeller bize dünya üzerinde bir eylem gerçekleştirebilmemizi sağlar.
Mesela, öğrendiğimiz fiziksel içgüdü ile kavramayı kullanarak kaslarımızın nasıl çalıştığını tahmin edebilir ve bu bılgiyle düşen bir kalemi nasıl yakalayabileceğimizi tahmin edebiliriz.

<!--One of the most important uses of self-supervised learning is to learn world models for control. 
When humans perform a task, we have an internal model for how the world works. 
For example, we gain an intuition for physics when we're about 9 months old, mostly through observation. In some sense, this is similar to self-supervised learning; in learning to predict what will happen, we learn abstract principles, just like self-supervised models learn latent features. 
But taking this one step further, the internal models let us act on the world. 
For example, we can use our learned physics intuition and our learned understanding of how our muscles work to predict --- and execute --- how to catch a falling pen. -->

### Dünya modeli nedir?

<!-- ### What is a "world model"? --!>

Bir otonom zeka sistemi dört ana modülden oluşmaktadır (Şekil 1). İlk olarak, dünyayı gözlemleyen ve dünyanın durumunu temsil etmeye çalışan bir algı(perception) modülü. Bu temsil tam değildir çünkü 1) eylemci tüm evreni gözlemlemez ve 2) gözlemlerin doğruluğu sınırlıdır. Ayrıca, ileri beslemeli(feed-forward) bir modelde, algı modülü sadece ilk zaman adımında kullanılır. İkinicisi, eylemci(actor) modülü (veya politika modülü) dünyanın durum temsiline göre belli bir eylem yapmaya çalışır. Üçüncü olarak, model modülü dünyayı ifade eden durum temsilini kullanarak, ve tabii ki de var olan bazı saklı değişkenler ile, yapacağı eylemin sonucunu tahmin eder. Bu tahmin, ilk zaman adımından algılama modülünün rolünü üstlenerek, dünyanın bir sonraki durumu için tahmin olarak bir sonraki zaman adımına iletilir. Son olarak, eleştirmen modülü aynı öngörüyü önerlien eylemin maliyetine dönüştürür, örn. hız ile birlikte kalemin düştüğüne inanmam göz önüne alındığında, eğer kaslarımı bu şekilde hareket ettirirsem, kalemi ne kadar kötü bir şekilde kaçırmış olurum?


<!-- An autonomous intelligence system comprises four major modules (Figure 1.). First, the perception module observes the world and computes a representation of the state of the world. This representation is incomplete because 1) the agent doesn't observe the whole universe, and 2) the accuracy of the observations is limited. It is also worth noting that in the feed-forward model, the perception module is only present for the initial time step. Second, the actor module (also called a policy module) imagines taking some action based on the (represented) state of the world. Third, the model module predicts the outcome of the action given the (represented) state of the world, and also possible given some latent features. This prediction gets passed forward to the next time step as the guess for the next state of the world, taking on the role of the perception module from the initial time step. Fig 2 gives detail demonstration of this feed-forward process. Finally, the critic module takes turns that same prediction into a cost of performing the proposed action, e.g. given the speed with which I believe the pen is falling, if I move muscles in this particular way, how badly will I miss the catch? -->

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models_arch.png" height="400px" /><br>
<b>Şekil 1</b>: Bir otonom zeka sistemi gösteriminin Dünya Modeli mimarisi.
  <!-- The World Models architecture of an autonomous intelligence system demonstration. -->
</center>

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_world_models.png" height="400px" /><br>
<b>Şekil 2</b>: Model mimarisi.
  <!-- Model architecture -->
</center>

## Klasik Modelleme

<!-- ## The classical setting-->

Klasik optimal kontrolde aktör/politika modülü yerine eylemi ifade eden bir eylem değişkeni bulunmaktadır. Bu formülasyon, 1960'larda NASA tarafından insan bilgisayarlarından (çoğunlukla Siyah kadın matematikçiler) elektronik bilgisayarlara geçtiklerinde roket yörüngelerini hesaplamak için kullanılan Model Öngörücü Kontrol(Model Predictive Control) adlı klasik bir yöntemle optimize edilmiştir. Bu sistemi zamanla açılmış bir RNN gibi, eylemleri saklı değişkenler gibi, ve geri yayılım ile gradyan yöntemlerini(veya dinamik programlama gibi yöntemleri) de zaman adımı maliyetlerinin toplamını en aza indirgeyen eylemler dizisini öngörmemizi sağlayan yöntemler olarak düşünebiliriz.
Not: Saklı değişkenler ve parametrelerin optimizasyon süreçleri benzer olsa da "çıkarım"(inference) kelimesini saklı değişkenler için ve "öğrenme"(learning) kelimesini parametreler içi kullanırız. Önemli bir fark, saklı değişken her bir örnek için belli bir değer alırken parametreler tüm örnekler arasında paylaşılır.

<!-- 
In classical optimal control, there is no actor/policy module, but rather just an action variable. This formulation is optimized by a classical method called Model Predictive Control, which was used by NASA in the 1960s to compute rocket trajectories when they switched from human computers (mostly Black women mathematicians) to electronic computers. We can think of this system as an unrolled RNN, and the actions as latent variables, and use backpropagation and gradient methods (or possibly other methods, such as dynamic programming for a discrete action set) to infer the sequence of actions that minimizes the sum of the time step costs.
Aside: We use the word "inference" for latent variables, and "learning" for parameters, though the process of optimizing them is generally similar. One important difference is that a latent variable takes a specific value for each sample, whereas, parameters are shared between samples. -->


## An improvement
<!-- ## An improvement -->

Şimdi, planlama yaparken, her seferinde geri yayılım gibi karmaşık bir süreçten geçmemeyi tercih ediyoruz. Bunun için, değişimsel otokodlayıcılarda kullandığımız taktiği seyrek kodlamada kullanacağız: Optimal eylem dizisini doğrudan elimizdeki dünyaya ayit temsilcilerle tahmin edebilmek için bir kodlayıcı eğiteceğiz. Burada, kodlayıcıya politika ağı adını vereceğiz. 

<!-- Now, we'd prefer not to go through the complicated process of backpropagating every time we want to make a plan. To address this, we use the same trick we used for variational autoencoder to improve sparse coding: we train an encoder to directly predict the optimal action sequence from the world representations. In this regime, the encoder is called a policy network. -->

<center>
<img src="{{site.baseurl}}/images/week09/09-2/week9_policy_network.png" height="400px" /><br>
<b>Şekil 3</b>: Politika Ağı.
  <!-- Policy Network ..>
</center>

Bu ağları eğittiğimizde, dünyayı algıladıktan hemen sonra en uygun eylem sırasını tahmin etmek için  kullanabiliriz.

<!-- Once trained, we can use the policy networks to predict the optimal action sequence immediately after perception. -->


## [Pekiştirmeli Öğrenme (RL)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)
<!--
## [Reinforcement learning (RL)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=3993s)-->

Pekiştirmeli öğrenme ile şu ana kadar öğrendiklerimiz arasında iki fark vardır:

1. Pekiştirmeli öğrenmedeki ortamlarda hata fonksiyonu bir kara kutudan ibarettir. Yani, eylemcinin ödül dinamiğini anlaması mümkün değildir.
2. Pekiştirmeli öğrenmede, ortamda ilerlemek için ortamı modelleyen ileriye dönük bir model kullanmayız. Aksine, gerçek dünya ile etkileşime girer ve ne olduğunu gözlemleyerek sonucu öğreniriz. Gerçek dünyada, dünya hakkındaki ölçümlerimiz mükemmel olmadığından, ileride bundan sonra ne olacağını  tahmin etmemiz her zaman  mümkün değildir. 

<!-- The main differences between RL and what we have studied up to this point are two-fold:
1. In Reinforcement learning environments the cost function is a black box. In other words, the agent does not understand the reward dynamics.
2. In the setting of RL, we don’t use a forward model of the world to step the environment. Instead we interact with the real world and learn the result by observing what happens. In the real world our measure of the state of the world is imperfect so it is not always possible to predict what will happen next.-->

Pekiştirmeli öğrenmedeki temel sorun, hata fonksiyonunun türevlenememesidir. Bu yüzden, tek yol deneme ve yanılmadan ibarettir. Burda da problem, durum uzayını verimli bir şekilde nasıl keşfecegimize dönüşüyor. Buna bir çözüm bulduktan sonra, bir sonraki konu da keşif(exploration) ve sömürü(exploitation) temel sorusudur: Çevreyi en üst düzeyde öğrenecek biçimde eylemler mi gerçekleştirmek istersin yoksa olabildiğince yüksek bir ödül almak için daha önce öğrendiklerinden yararlanmak mı istersin?
<!-- The main problem of Reinforcement learning is that the cost function is not differentiable. This means that the only way to learn is through trial and error. Then the problem becomes how to explore the state space efficiently. Once you come up with a solution to this the next issue is the fundamental question of exploration *vs.* exploitation: would you rather take actions to maximally learn about the environment or instead exploit what you have already learned to get as high a reward as possible. -->

Aktör-Eleştirmen(Actor-Critic) yöntemleri hem eylemci hem de eleştirmen eğiten popüler bir RL algoritmaları ailesidir. Birçok RL yöntemi, maliyet fonksiyonunun bir modelini (eleştirmen) eğiterek benzer şekilde çalışır. Aktör-Eleştirmen yöntemlerinde eleştirmenin rolü, değer onksiyonunun(value function) beklenen değerini öğrenmektir. Eleştirmen de bir sinir ağı olduğu için modül üzerinden geri yayılım mümkündür. Aktörün sorumluluğu ortamda gerçekleştirilecek eylemler önermek iken eleştirmenin görevi ise maliyet fonksiyonunun bir modelini öğrenmektir. Aktör ve eleştirmen, hiçbir eleştirmen kullanılmamış olmasından daha verimli öğrenmeye yol açacak şekilde birlikte çalışır. Dünyanın iyi bir modeline sahip değilseniz öğrenmek çok daha zordur: örn. uçurumun yanındaki araba bir uçurumdan düşmenin kötü bir fikir olduğunu bilmeyecektir. Bu, insanların ve hayvanların RL ajanlarından çok daha hızlı öğrenmelerini sağlar: kafamızda gerçekten iyi dünya modelleri var.
<!-- Actor-Critic methods are a popular family of RL algorithms which train both an actor and a critic. Many RL methods work similarly, by training a model of the cost function (the critic). In Actor-Critic methods the role of the critic is to learn the expected value of the value function. This enables back-propagation through the module, since the critic is just a neural network. The actor's responsibility is to propose actions to take in the environment, and the critic's job is to learn a model of the cost function. The actor and the critic work in tandem that leads to more efficient learning than if no critic is used.  If you don't have a good model of the world it is much more difficult to learn: e.g. the car next to the cliff will not know that falling off a cliff is a bad idea. This enables humans and animals to learn much more quickly than RL agents: we have really good world models in our head. -->

Geleceği, dünyanın doğasında varolan belirsizliklerden (Aleatorik ve Epistemik) ötürü, her zaman tahmin etmemiz mümkün değildir. Aleatorik belirsizlik, kontrolümüzün olmadığı veya gözlemleyemediğimiz olaylardan ötürü var olan bir belirsizlik türüdür. Epistemik belirsizlik ise geleceği tahminlemek için modelin yetersizliklerinden kaynaklı belirsizlik türüdür. 

<!-- We cannot always predict the future of the world due to inherent uncertainty: aleatory and epistemic uncertainty. Aleatoric uncertainty is due to things you cannot control or observe in the environment. Epistemic uncertainty is when you cannot predict the future of the world because your model does not have enough training data. -->

İleriye dönük modeller, aşağıdaki gibi tanımlıdır: 
<!-- The forward model would like to be able to predict -->

$$\hat s_{t+1} = g(s_t, a_t, z_t)$$

burada $z$, değerini bilmediğimiz bir saklı değişkendir. $z$ dünya hakkında bilmemizin mümkün olmadığı fakat tahminimizi etkileyen bilgiyi(aleatorik belirsizlik) ifade eder. $z$'yi seyrelterek, gürültü ekleyerek veya kodlayıcı ile düzenlileştirebiliriz. İleriye dönük modelimizi planlamayı öğrenmesi için kullanabiliriz. Sistem bir kodçözücünün durum temsilini ve belirsizlik $z$'yi çözümlemesiyle çalışır. En iyi $z$, $\hat s_{t+1}$ ile gerçekten gözlemlenmiş $s_{t+1}$'in arasındaki farkı minimize eden $z$ olarak tanımlanmıştır.

<!-- where $z$ is a latent variable of which we don't know the value. $z$ represents what you cannot know about the world but which still influences the prediction (*i.e.* aleatoric uncertainty). Can regularize $z$ with sparsity, noise, or with an encoder. Can use forward models to learn to plan. The system works by having a decoder decode a concatenation of the state representation and the uncertainty $z$. The best $z$ is defined as the $z$ that minimizes the difference between $\hat s_{t+1}$ and the actual observed $s_{t+1}$. -->

## [Üretken Çekişmeli Ağ (GAN)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)

<!--## [Generative Adversarial Network](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=5430s)
-->

GAN yapısının oldukça fazla varyasyonu literatğrde mevcuttur ve burada GAN'ı karşıtsal metodların kullanıldığı enerji bazlı bir model olarak ele alıyoruz. GAN, karşıt örneklerin enerjileri yukarı iterken eğitim kümesindeki örneklerin enerjilerini aşağı iter. GAN temelde iki kısımdan oluşur: karşıt örnekleri akıllıca üreten bir üretici(generator) ve enerji modeli olarak davranan, ve esasında bir kayıp fonksiyonu olan, bir ayrıştırıcı(discriminator)(bazen eleştirmen olarak da adlandırılır). Hem üretici hem de ayrıştırıcı birer sinir ağıdır.

<!-- There are many variations of GAN and here we think of GAN as a form of energy-based model using contrastive methods. It pushes up the energy of contrastive samples and pushes down the energy of training samples. A basic GAN consists of two parts: a generator which produces contrastive samples intelligently and a discriminator (sometimes called critic) which is essentially a cost function and acts as an energy model. Both the generator and the discriminator are neural nets. -->

GAN'ın kullandığı iki girdi türü sırasıyla eğitim örneği ve karşıt örneğidir. Eğitim örnekleri için, GAN bu örnekleri ayrıştırıcıdan geçirir ve enerjilerini düşürmeye çalışır. Karşıt örnekler için ise GAN, belli bir dağılımdan saklı bir değişken örnekler, bu örnekleri üreticiden geçirerek eğitim örneklerine benzer örnekler üretir ve bu örnekleri ayrıştırıcıdan geçirerek enerjisini artırmaya çalışır. Ayrıştırıcı için hata fonksiyonu şu şekilde tanımlanmıştır:

<!-- The two kinds of input to GAN are respectively training samples and contrastive samples. For training samples, GAN passes these samples through the discriminator and makes their energy go down. For contrastive samples, GAN samples latent variables from some distribution, runs them through the generator to produce something similar to training samples, and passes them through the discriminator to make their energy go up. The loss function for discriminator is as follows: -->

$$\sum_i L_d(F(y), F(\bar{y}))$$

burada  $L_d$ , $F(y) + [m - F(\bar{y})]^+$ veya $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$  gibi marjin bazlı bir hata fonksiyonu olabilir. Yeter ki $F(y)$ azalsın ve  $F(\bar{y})$ artsın. Bu bağlamda, $y$ bir etiket ve $\bar{y}$ ise $y$ haricinde en düşük enerjiyi sağlayan tepki değişkenidir. Üretici ağ için ise farklı bir hata fonksiyonu tanımlıdır:

<!-- where $L_d$ can be a margin-based loss function like $F(y) + [m - F(\bar{y})]^+$ or $\log(1 + \exp[F(y)]) + \log(1 + \exp[-F(\bar{y})])$ as long as it makes $F(y)$ decrease and $F(\bar{y})$ increase. In this context, $y$ is the label,  and  $\bar{y}$ is the response variable gives lowest energy except $y$ itself.
There is going to be a different loss function for the generator: -->

$$L_g(F(\bar{y}))  = L_g(F(G(z)))$$

burada $z$ saklı değişken ve $G$ de üretici sinir ağıdır. Üreticinin, ağırlıklarını adapte etmesini ve ayrıştırıcıyı kandirabilecek düşük enerjili $\bar{y}$'ler üretmesini istiyoruz.
<!-- where $z$ is the latent variable and $G$ is the generator neural net. We want to make the generator adapt its weight and produce $\bar{y}$ with low energy that can fool the discriminator. -->

Bu modelin üretken çekişmeli ağlar olarak adlandırılmasının sebebi birbiriyle uyumsuz giden iki hata fomksiyonunu aynı anda minimize etmeye çalışmamızdandır. Burdaki sorun gradyan inişi problemi değil çünkü amacımız hedef iki fonksiyon arasında bir Nash denge noktası bulmak istememiz ve gradyan inişi ile böyle bir problemi çözemeyiz.

<!-- The reason why this type of model is called generative adversarial network is because we have two objective functions that are incompatible with each other and we need to minimize them simultaneously. It’s not a gradient descent problem because the goal is to find a Nash equilibrium between these two functions and gradient descent is not capable of this by default. -->

Örneklerimiz gerçek manifolda yakın olduğunda belli problemlerle karşılacağız. Varsayalım ki sonsuz ince bir manifoldumuz olsun. Ayrıştırıcının manifold dışında $0$ olasılık ve içinde ise sonsuz olasılık vermesi beklenmektedir. Bunu yapmak oldukça zor olduğundan, GAN sigmoid kullanarak manifold dışında $0$ ve üzerinde $1$ üretir. Burdaki problem ise eğer biz sistemimizi başarıı bir şekilde eğitmiş olsak dahi, manifoldun dışında ayrıştırıcı 0 değerini veriyorsa, enerji fonksiyonu bu durumda anlamını yitirmiş demektir. Bunun sebebi enerji fonksiyonu pürüzsüz(smooth) değildir ve veri manifoldunun dışında heryerde enerji sonsuz iken manifoldun 
üzerindeki her yerde enerji 0 olucaktır. Enerjinin bir anda $0$'dan sonsuza gitmesi fonksiyonu pürüzlüleştirir. Araştırmacılar, bu problemi çözmek için enerji fonksiyonunu düzenlileştirilmesinden geçen birçok yol önerdiler. Wasserstein GAN'da ayrıştırıcının ağırlıklarını kısıtlayan önemli bir örnektir.

<!--  There will be problems when we have samples that are close to the true manifold. Assume that we have an infinitely thin manifold. The discriminator needs to produce $0$ probability outside the manifold and infinite probability on the manifold. Since this is very difficult to achieve, GAN uses sigmoid and produces $0$ outside the manifold and produces $1$ on the manifold. The problem with this is that if we train the system successfully where we get the discriminator to produce $0$ outside the manifold, the energy function is completely useless. This is because the energy function is not smooth where all energy outside the data manifold will be infinity and all energy on the data manifold will be $0$. We don’t want the energy value to go from $0$ to infinity in a very small step. Researchers have proposed many ways to fix this problem by regularizing the energy function. A good example of improved GAN is Wasserstein GAN which limits the size of discriminator weight. -->
