---
lang: tr
lang-ref: ch.09-1
title: Discriminative Recurrent Sparse Auto-Encoder and Group Sparsity
authors: Kelly Sooch, Anthony Tse, Arushi Himatsingka, Eric Kosgey
date: 30 Mar 2020
translation-date: 12 Jun 2020
translator: Hüseyin Bera Bulut
---

<!-- Discriminative Recurrent Sparse Auto-Encoder and Group Sparsity -->
## [Ayrıştırıcı Tekrarlı Seyrek Otokodlayıcı ve Grup Seyrekliği (DrSAE, *Discriminative recurrent Sparse Auto-Encoder*)](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=35s)

<!-- The idea of DrSAE consists of combining sparse coding, or the sparse auto-encoder, with discriminative training. -->
DrSAE'nin felsefesi seyrek kodlamayı,veya ayrık otokodlayıcı, ayrıştırıcı eğitim ile birleştirmesinden oluşur.
 <center><img src="{{site.baseurl}}/images/week09/09-1/q7pSvUJ.png" width="400px"/></center>

<!-- **Fig 1:** Discriminative Recurrent Sparse Auto-Encoder Network. -->
**Şekil 1:** Ayrıştırıcı Tekrarlı Seyrek Otokodlayıcı Ağ

<!-- The encoder, $W_e$, is similar to the encoder in the LISTA method. The X variable is run through $W_e$, and then through a non-linearity. This result is then multiplied by another learned matrix, S, and added to $W_e$. Then it is sent through another non-linearity. This process can be repeated a number of times, with each repetition as a layer. -->
Kodlayıcı, $W_e$, LISTA metodundaki kodlayıcıya benzer. X değişkeni önce $W_e$ üzerinden, daha sonra doğrusalsızlıktan geçer. Bu sonuç daha sonra bir diğer öğrenilmiş matris, S, ile çarpılır ve sonra $W_e$'ye eklenir.Daha sonra bir diğer doğrusalsızlığa gönderilir. Bu işlem her tekrarın bir katman olacağı şekilde defalarca tekrarlanabilir.

<!-- We train this neural network with 3 different criteria:
1. $L_1$: Apply $L_1$ criterion on the feature vector X to make it sparse.
2. Reconstruct X: This is done using a decoding matrix that reproduces the input on the output. This is done by minimizing square error, indicated by $W_d$ in Figure 1.
3. Add a Third Term: This third term, indicated by $W_c$, is a simple linear classifier which attempts to predict a category. -->
Bu sinir ağını 3 farklı kriter ile eğitiriz:
1. $L_1$: $L_1$ kriterini öznitelik vektörü X'in üzerinde onu seyrek yapmak için üzerinde uygula.
2. X'i iyileştir: Bu çıktıya göre tekrar girdi üreten kodçözücü matrisi kullanarak yapılır. Bu Şekil 1'deki $W_d$ tarafından gösterildiği gibi karesel hatayı en aza indirilerek yapılır.
3. Bir Üçüncü Terim ekle: Bu üçüncü terim, $W_c$ ile gösterilen, kategoriyi tahmin etmeye çalışan basit bir doğrusal sınıflayıcıdır.

<!-- The system is trained to minimize all 3 of these criteria at the same time.

The advantage of this is by forcing the system to find representations that can reconstruct the input, then you're basically biasing the system towards extracting features that contain as much information about the input as possible. In other words, it enriches the features. -->
Bu sistem bu 3 kriterin hepsini aynı anda en aza indirmek için eğitildi.

Bunun avantajı sistemi girdiyi iyileştirebilecek temsilleri bulmaya zorlamasıdır, daha sonra basitçe sistemi girdi hakkında fazlaca bilgi içeren öznitelikleri çıkarmaya doğru yön verir. Diğer bir deyişle öznitelikleri zenginleştirir.

<!-- ### Group Sparsity -->
### Grup Seyrekliği

<!-- ### The idea here is to generate sparse features, but not just normal features that are extracted by convolutions, but to basically produce features that are sparse after pooling. -->
Buradaki niyetimiz seyrek öznitelikler üretmek, ama sadece evrişimlerden çıkan normal öznitelikler değil, örneklemeden sonra seyrek olan öznitelikler üretmek.
 <center><img src="{{site.baseurl}}/images/week09/09-1/kpDK8Xu.png" width="400px" height="135px"/></center>

<!-- **Fig 2:** Auto-Encoder with Group Sparsity-->
**Şekil 2:** Grup Seyreklikli Otokodlayıcı

<!-- Figure 2 shows an example of an auto-encoder with group sparsity. Here, instead of the latent variable Z going to an $L_1$, it goes through basically an $L_2$ over groups. So you take the $L_2$ norm for each component in a group of Z, and take the sum of those norms. So now that is what is used as the regulariser, so we can have sparsity on groups of Z. These groups, or pools of features, tend to group together features that are similar to one another. -->
Şekil 2 grup seyreklikli bir otokodlayıcının örneğini gösteriyor. Burada, saklı değişken Z bir $L_1$ üzerinden gitmek yerine gruplar üstünden bir $L_2$'ye gidiyor. Yani Z'li gruptaki her bileşen için $L_2$ büyüklüğünü alıyoruz, ve bu büyüklükleri topluyoruz. Düzenlileştirici olarak bunu kullandık şimdi Z'li gruplarda seyreklik sahibi olabiliriz. Bu gruplar, veya özniteliklerin havuzları, birbirine benzer öznitelikler ile grup oluşturma eğilimindedirler.


<!-- ## [AE with group sparsity: questions and clarification](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)
 -->
## [Grup Seyreklikli AE(AutoEncoder, Otokodlayıcı): sorular ve açıklamalar](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=918s)

<!-- Q: Can a similar used in the first slide strategy with classifier and regulariser can be applied for VAE?

A: Adding noise and forcing sparsity in a VAE are two ways of reducing the information that the latent variable/code. Prevent learning of an identity function.
 -->
Q: İlk slaytta sınıflayıcı ve düzenlileştirici ile kullanılan stratejiye benzer bir strateji VAE(Variational AutoEncoder, Değişimsel Otokodlayıcı) için kullanılabilir mi?

A: VAE'ye gürültü eklemek ve seyrekliğe zorlamak saklı değişken/ kod'daki bilgiyi azaltmanın iki yoludur. Kimlik fonksiyonunu öğrenmesini engeller.

<!-- Q: In slide "AE with Group Sparsity", what is $P_j$?

A: p is a pool of features. For a vector z, it would be a subset of the values in z.
 --> 
Q: "Grup Seyreklikli AE" slaytındaki $P_j$ nedir?

A: p bir öznitelik havuzudur.Bir z vektörü için, z'deki değerlerin bir altkümesi olur.

<!-- Q: *Clarification on feature pooling.*

A: (Yann draws representation of AE with group sparsity) Encoder produces latent variable z, which is regularized using the $L_2$ norm of pooled features. This z is used by the decoder for image reconstruction.
 -->
Q: *Öznitelik örneklemesi üzerine açıklama.*

A: (Yann grup seyreklikli AE'nin temsilini çiziyor) Kodlayıcı örneklenmiş özniteliklerinin $L_2$ büyüklüklerini kullanarak düzenlileştirilmiş saklı değişken z'yi üretir. Bu z resim iyileştirilmesi için kodçözücü tarafından kullanılır.

<!-- Q: Does group regularization help with grouping similar features.

A: The answer is unclear, work done here was done before computational power/ data was readily available. Techniques have not been brought back to the forefront.
 -->
Q: Grup düzenlileştirme benzer öznitelikleri gruplamada yardımcı oluyor mu?

A: Bunun cevabı kesin değil, buradaki çalışma işlem gücü/ veri hazır olmadan yapılmış. Teknikler ön sıralara geri getirilmemiş.


<!-- ## [Image level training, local filters but no weight sharing](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s) -->
## [Resim düzeyi eğitimi, yerel filtreler var ama ağırlık paylaşımı yok](https://www.youtube.com/watch?v=Pgct8PKV7iw&t=1834s)

<!-- The answer about whether it helps is not clear. People interested in this are either interested in image restoration or some kind of self-supervised learning. This would work well when dataset was very small. When you have an encoder and decoder that is convolutional and you train with group sparsity on complex cells, after you are done pre-training, the system you get rid of the decoder and only use the encoder as a feature extractor, say the first layer of the convolutional net and you stick a second layer on top of it. -->
Yardım edip etmediğinin cevabı kesin değil. Bununla ilgilenen insanlar ya resim restorasyonuyla ya da bir tür özdenetimli öğrenme ile ilgililer. Bu veri kümesi çok küçük olduğunda iyi çalışıyor. Evrişimli bir kodlayıcı ve kodçözücüsüne sahipsiniz ve onları karmaşık hücreler üstünde grup seyrekliği ile eğitiyorsunuz, öneğitimi bitirdikten sonra, elde ettiğiniz kodçözücüden arınmış ve kodlayıcıyı da sadece özellik çıkarıcı olarak kullanan bir sistemdir, diyelim ki evrişimli bir ağın birinci katmanı var siz onun üstüne ikinci bir katman tutturuyorsunuz.

<center><img src="{{site.baseurl}}/images/week09/09-1/7akkfhv.png" width="400px"/></center>
<!-- **Fig 3:** Structure of Convolutional RELU with Group Sparsity -->
**Şekil 3:** Grup Seyreklikli Evrişimli RELU'nun Yapısı

<!-- As can be seen above, you are start with an image, you have an encoder which is basically Convolution RELU and some kind of scaling layer after this. You train with group sparsity. You have a linear decoder and a criterion which is group by 1. You take the group sparsity as a regulariser. This is like L2 pooling with an architecture similar to group sparsity. -->
Yukarıda görüleceği üzere, bir resimle başlıyorsunuz, basitçe Evrişimli RELU gibi olan bir kodlayıcınız ve bundan sonra bir çeşit ölçekleme katmanınız var. Grup seyrekliği ile eğitiyorsunuz. Doğrusal bir kodçözücü ve 1.grup kriteriniz var. Grup seyrekliğini düzenlileştirici olarak kullanıyorsunuz. Bu grup seyrekliğine benzer bir mimaride L2 örneklemesi gibidir.

<!-- You can also train another instance of this network. This time, you can add more layers and have a decoder with the L2 pooling and sparsity criterion, train it to reconstruct its input with pooling on top. This will create a pretrained 2-layer convolutional net. This procedure is also called Stacked Autoencoder. The main characteristic here is that it is trained to produce invariant features with group sparsity. -->
Bu ağın bir diğer örneğini de eğitebilirsiniz. Bu sefer, daha fazla katman ekleyebilirsin ve L2 örnekleyici ile seyreklik kritlerli kodçözücüsüne sahip olabilirsin, onu örnekleme ile birlikte girdisini iyileştirmek için eğit. Bu öneğitilmiş 2 katmanlık evrişimli ağ oluşturacak. Bu prosedür Yığılmış Otokodlayıcı(Stacked Autoencoder) olarak da geçer. Buradaki karakteristik özellik ağın grup seyreklikli değişmez öznitelikleri üretmesi için eğitilmesidir.

<!-- Q : Should we use all possible sub-trees as groups?

A : It’s up to you, you can use multiple trees if you want. We can train the tree with a bigger tree than necessary and then removes branches rarely used. -->
Q : Mümkün olan her alt-ağacı gruplar halinde kullanmalı mıyız?

A : Bu size kalmış, isterseniz birden fazla ağacı kullanabilirsiniz. Ağacı nadir kullanılan dalları kaldıran, gerektiğinden daha büyük bir ağaç ile eğitebiliriz.

<center><img src="{{site.baseurl}}/images/week09/09-1/EuhORxu.jpg" width="400px"/></center>
<!-- **Fig 4:** Image Level Training, local filters but no weight sharing -->
**Şekil 4:** Resim Düzeyi Eğitimi, yerel filtreler var ama ağırlık paylaşımı yok

<!-- These are called pin-wheel patterns. This is a kind of organisation of the features. The orientation variously continuously as you go around those red dots. If we take one of those red dots and if do a little circle around the red dots, you notice that the orientation of the extractor kind of varies continuously as you move around. Similar trends are observed in the brain. -->
Bunlar rüzgar gülü desenleri olarak adlandırılır. Bu özniteliklerin bir tür organizasyonudur. Kırmızı noktalar etrafında gezindikçe oryantasyon sürekli olarak farklıdır. Kırmızı noktalardan birini alırsak ve kırmızı noktalar etrafında küçük bir çember çizersek, hareket ettikçe çıkarıcının oryantasyonunun sürekli olarak değiştiğini fark edersin. Benzer eğilimler beyinde de gözlemlenmiştir.

<!-- Q : Is the group sparsity term trained to have a small value?

It is a regulariser. The term itself is not trained, it's fixed. It's just the L2 norm of the groups and the groups are predetermined. But, because it is a criterion, it determines what the encoder and decoder will do and what sort of features will be extracted. -->
Q : Grup seyrekliği terimi küçük bir değer almak üzere mi eğitilmiştir?

O bir düzenlileştiricidir. Terimin kendisi eğitilmemiştir, belirlenmiştir. O sadece grupların L2 büyüklüğüdür ve gruplar önceden belirlenmiştir. Ama, bir kriter olduğu için, kodlayıcının ve kodçözücünün ne yapacağına ve ne tür özniteliklerin çıkarılacağına karar verir.

<center><img src="{{site.baseurl}}/images/week09/09-1/AS3giSt.jpg" width="400px" height="200px"/></center>
<!-- **Fig 5:** Invariant Features through Lateral Inhibition -->
**Şekil 5:** Yanal Ketleme Vasıtasıyla Değişmez Öznitelikler

<!-- Here, there is a linear decoder with square reconstruction error. There is a criterion in the energy. The matrix S is either determined by hand or learned so as to maximise this term. If the terms in S are positive and large, it implies that the system does not want $z_i$ and $z_j$ to be on at the same time. Thus, it is sort of a mutual inhibition (called natural inhibition in neuroscience). Thus, you try to find a value for S that is as large as possible. -->
Burada kare yeniden oluşturma hatası veren bir doğrusal kodçözücü var. Enerjide bir kriter var. S matrisi ya elle belirlendi ya da terimi en yüksek değere çekmek için öğrendi. Eğer S'deki terimler pozitif ve büyüklerse, sistemin $z_i$'nin ve $z_j$'nin aynı anda aktif olmasını istemediği anlamına gelir. Nitekim, bu bir tür ortak ketlemedir (sinirbilimde doğal ketleme denir). Böylece, S için olabilecek en büyük değeri bulmaya çalışır.

<center><img src="{{site.baseurl}}/images/week09/09-1/sszdGh0.png" width="400px"/></center>
<!-- **Fig 6:** Invariant Features through Lateral Inhibition (Tree Form) -->
**Şekil 6:** Yanal Ketleme Vasıtasıyla Değişmez Öznitelikler (Ağaç Formu)

<!-- If you organise S in terms of a tree, the lines represent the zero terms in the S matrix. Whenever you don't have a line, there is a non-zero term. So, every feature inhibits all other features except those which are up the tree or down the tree from it. This is something like the converse of group sparsity. -->
Eğer S'yi ağaç şartlarında organize ederseniz, çizgiler S matrisinde sıfır terimlerini temsil eder. Çizginiz olmadığı zaman, orada bir sıfır olmayan terim vardır. Yani, her öznitelik ağaçta kendinden yukarıda veya aşağıda olanlar hariç diğer öznitelikleri engeller. Bu grup seyrekliğinin zıttı gibidir.

<!-- You see again that systems are organising features in more or less a continuous fashion. Features along the branch of a tree represent the same feature with different levels of selectivity. Features along the periphery vary more or less continuously because there is no inhibition. -->
Tekrar gördüğünüz gibi sistemler öznitelikleri neredeyse sürekli olarak biçimlendirir. Ağacın dalı boyunca bulunan öznitelikler aynı özniteliğin farklı seçicilikteki halini temsil ederler. Ağacın çevresinde bulunan öznitelikler neredeyse sürekli olarak farklıdır çünkü engelleme yoktur.

<!-- To train this system, at each iteration, you give an $x$ and find the $z$ which minimizes this energy function.Then do one step of gradient descent to update $W$. You can also do one step of gradient ascent to make the terms in $S$ larger. -->
Bu sistemi eğitmek için, her tekrarda, bir $x$ verilir ve enerji fonksiyonunu en aza indiren $z$ bulunur. Sonra $W$'yi güncellemek için bir kez gradyan inişi yapılır. Ayrıca $S$'deki terimleri daha büyük yapmak için bir kez gradyan çıkışı da yapılabilir.
