---
lang-ref: ch.08-3
title: Üretici Modeller - Değişimsel Otokodlayıcılar
lang: tr
lecturer: Alfredo Canziani
authors: Richard Pang, Aja Klevs, Hsin-Rung Chou, Mrinal Jain
date: 24 March 2020
translation-date: 16 Jun 2020
translator: cihanongun
---

<!-- ### [Recap: Auto-encoder (AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s) -->
### [Hatırlatma: Otokodlayıcılar (Autoencoder - AE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=155s)
<!--
To summarize at a high level, a very simple form of AE is as follows:

- First, the autoencoder takes in an input and maps it to a hidden state through an affine transformation $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$, where $f$ is an (element-wise) activation function. This is the **encoder** stage. Note that $\boldsymbol{h}$ is also called the **code**.
- Next, $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$, where $g$ is an activation function. This is the **decoder** stage.

*For a detailed explaination, refer to the notes of [Week 7]({{site.baseurl}}/en/week07/07-3/).*
-->

Kısaca özetlersek basit bir Otokodlayıcı şu şekilde çalışır:

- İlk olarak, otokodlayıcı bir girdi alır alır ve bunu $\boldsymbol{h} = f(\boldsymbol{W}_h \boldsymbol{x} + \boldsymbol{b}_h)$ ile ifade edilen bir afin dönüşümden geçirerek gizli bir değer ile eşleştirir. Dönüşüm formülündeki $f$ değeri eleman çapında bir aktivasyon fonksiyonudur. Bu kodlama aşamasıdır ve $\boldsymbol{h}$ değeri **kod** olarak adlandırılır.
- Sonrasında, **kod çözme** aşamasında  $\hat{\boldsymbol{x}} = g(\boldsymbol{W}_x \boldsymbol{h} + \boldsymbol{b}_x)$ formülü uygulanır. Bu formülde ise $g$ aktivasyon fonksiyonudur.

*Detaylı açıklama için [7. haftanın]({{site.baseurl}}/en/week07/07-3/) ders notlarına bakabilirsiniz.*

<!-- ### Intuition behind VAE and a comparison with classic autoencoders -->
### VAE'nin temelinde yatan mantık ve klasik otokodlayılardan farkları
<!--
Next, we introduce Variational Autoencoders (or VAE), a type of generative models. But why do we even care about generative models? To answer the question, discriminative models learn to make predictions given some observations, but generative models aim to simulate the data generation process. One effect is that generative models can better understand the underlying causal relations which leads to better generalization.
Note that although VAE has "Autoencoders" (AE) in its name (because of structural or architectural similarity to auto-encoders), the formulations between VAEs and AEs are very different. See *Figure 1* below.
-->

Şimdi bir üretici model olan Değişimsel Otokodlayıcılara (Variational Autoencoders, VAE) bakalım. Burada akla gelen ilk soru, neden üretici modellerle ilgilendiğimiz ile ilgilidir. Ayırt edici modeller verilen gözlemlere göre tahmin yapmayı öğrenir, üretici modeller ise data üretim süreçlerini simüle etmeyi amaçlar. Bunun bir etkisi olarak da üretici modeller altta yatan nedensel ilişkileri daha iyi anlayarak daha iyi genelleştirme yapar.

Değişimsel Otokodlayıcılar yapısal ve mimari benzelikleri göze alınarak Otokodlayıcı sınıfında adlandırılsa da, *Şekil 1*'de görüldüğü üzere formülasyonları oldukça farklıdır.

<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Fig. 1</b>: VAE vs. Classic AE
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_1.png" height="400px" /><br>
<b>Şekil 1</b>: Değişimsel Otokodlayıcı vs. Klasik Otokodlayıcı
</center>

<!--**What's the difference between variational auto-encoder (VAE) and classic auto-encoder (AE)?**-->
**Değişimsel otokodlayıcı (VAE) ile klasik otokodlayıcı (AE) arasındaki farklar nelerdir?**

<!--
For VAE:
- First, the encoder stage: we pass the input $\boldsymbol{x}$ to the encoder. Instead of generating a hidden representation $\boldsymbol{h}$ (the code) in AE, the code in VAE comprises two things: $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ where $\boldsymbol{z}$ is the latent random variable following a Gaussian distribution with mean $\mathbb{E}(\boldsymbol{z})$ and variance $\mathbb{V}(\boldsymbol{z})$. Note that people use Gaussian distributions as the encoded distribution in practice, but other distributions can be used as well.
    - The encoder will be a function from $\mathcal{X}$ to $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$ (here we use $\boldsymbol{h}$ to represent the concatenation of $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$).
- Next, we will sample $\boldsymbol{z}$ from the above distribution parametrized by the encoder; specifically, $\mathbb{E}(\boldsymbol{z})$ and $\mathbb{V}(\boldsymbol{z})$ are passed into a **sampler** to generate the latent variable $\boldsymbol{z}$.
- Next, $\boldsymbol{z}$ is passed into the decoder to generate $\hat{\boldsymbol{x}}$.
    - The decoder will be a function from $\mathcal{Z}$ to $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$.

In fact, for classic autoencoder, we can think of $\boldsymbol{h}$ as just the vector $\E(\boldsymbol{z})$ in the VAE formulation. In short, the main difference between VAEs and AEs is that VAEs have a good latent space that enables generative process.
-->

VAE:

- Kodlama aşaması: $\boldsymbol{x}$ girdisini kodlayıcıya veriyoruz. Klasik otokodlayıcılarda olduğu gibi bir saklı gösterim kodu $\boldsymbol{h}$ üretmek yerine, VAE'de üretilen kod 2 kısımdan oluşur: $\mathbb{E}(\boldsymbol{z})$ ve $\mathbb{V}(\boldsymbol{z})$. Burada $\boldsymbol{z}$ değeri ortalaması $\mathbb{E}(\boldsymbol{z})$ varyansı da $\mathbb{V}(\boldsymbol{z})$ olan bir Gauss dağılımına (normal dağılım) ait bir saklı rastgele değişkendir. Her ne kadar pratikte kod dağılımı olarak Gauss dağılımı kullanılsa da, diğer dağılım çeşitleri de kullanılabilir.
	- Kodlayıcı $\mathcal{X}$'ten $\mathbb{R}^{2d}$: $\boldsymbol{x} \mapsto \boldsymbol{h}$'e bir fonksiyon olarak ifade edilebilir. Burada $\boldsymbol{h}$, $\mathbb{E}(\boldsymbol{z})$ ve $\mathbb{V}(\boldsymbol{z})$) değerlerinin birleşimini ifade etmektedir.
- Sonra, $\boldsymbol{z}$ değeri yukarıda kodlayıcı tarafından parametreleştirilen dağılımdan örneklenir. Bunun için $\mathbb{E}(\boldsymbol{z})$ ve $\mathbb{V}(\boldsymbol{z})$ değerleri **örnekleyici fonksiyona** verilerek saklı değişken $\boldsymbol{z}$ üretilir.
- Son olarak, $\boldsymbol{z}$ kodçözücüye verilerek $\hat{\boldsymbol{x}}$ elde edilir.
	- Kodçözücü $\mathcal{Z}$'den $\mathbb{R}^{n}$: $\boldsymbol{z} \mapsto \boldsymbol{\hat{x}}$'e bir fonksiyondur.

Aslında klasik otokodlayıcılardaki $\boldsymbol{h}$'yi VAE formülasyonundaki $\E(\boldsymbol{z})$ vektörü olarak düşünebiliriz. Kısaca klasik otokodlayıcı (AE) ve değişimsel otokodlayıcı (VAE) arasındaki temel fark değişimsel otokodlayıcının (VAE) yeni data üretmeyi sağlayan üretici süreçlere izin veren iyi bir saklı uzaya sahip olmasıdır.

<!-- ### The VAE objective (loss) function -->
### VAE amaç (kayıp) fonksiyonu
<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Şekil 2</b>: Mapping from input space to latent space
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_2.png" /><br>
<b>Şekil 2</b>: Girdi uzayından saklı uzaya eşleme
</center>
<!--*See ure 2 above. For now, ignore the top-right corner (which is the reparameterisation trick explained in the next section).*-->

<!--First, we encode from input space (left) to latent space (right), through encoder and noise. Next, we decode from latent space (right) to output space (left). To go from the latent to input space (the generative process) will need to either learn the distribution (of the latent code) or enforce some structure. In our case, VAE enforces some structure to the latent space.-->
<!--
As usual, to train VAE, we minimize a loss function. The loss function is therefore composed of a reconstruction term as well as a regularization term.
- The reconstruction term is on the final layer (left side of the figure). This corresponds to $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ in the figure.
- The regularization term is on the latent layer, to enforce some specific Gaussian structure on the latent space (right side of the figure). We do so by using a penalty term $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$. Without this term, VAE will act like a classic autoencoder, which may lead to overfitting, and we won't have the generative properties that we desire.
-->

*Yukarıdaki Şekil 2'de sağ üst köşeyi şimdilik görmezden gelebilirsiniz. O bölümde yer alan yeniden parametreleştirme hilesi bir sonraki başlıkta açıklanacaktır.*

Önce, girdi uzayından (sol) saklı uzaya (sağ) kodlayıcı ve gürültü kullanarak kodlama yapıyoruz. Sonra, saklı değer uzayından (sağ) çıktı uzayına (sol) doğru kodu çözüyoruz. Saklı değer uzayından girdi uzayına gitmek için (yeni data üretme) ya saklı değer uzayının dağılımını öğrenmek ya da belirli bir yapıya zorlamak gerekir. Bizim durumumuzda, VAE saklı değer uzayını belirli bir yapıya zorlar.

Her zaman olduğu gibi VAE'yi de eğitmek için bir kayıp fonksiyonunu küçültmemiz gerekir. Kayıp fonksiyonu yeniden oluşturma ve düzenlileştirme terimlerinden oluşur.
- Yeniden oluşturma terimi, çıktı katmanında bulunur. *Şekil 2*'de sol tarafta $l(\boldsymbol{x}, \hat{\boldsymbol{x}})$ bölümü ile ifade edilir.
- Düzenlileştirme terimi saklı katmanda bulunur ve saklı değer uzayını belirli bir Gauss yapısına zorlar (*Şekil 2*.'de sağ tarafta). Bunu yapmak için $l_{KL}(\boldsymbol{z}, \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d))$ ceza terimini kullanırız. Bu terim olmadan VAE klasik otokodlayıcı gibi çalışır, bu da ezberlemeye sebep olabilir ve istediğimiz üretici özelliklere sahip olmaz.

<!-- ### Discussion on sampling $\boldsymbol{z}$ (**reparameterisation trick**) -->
### $\boldsymbol{z}$'yi örneklemek (**yeniden parametreleştirme hilesi**)
<!--
How do we sample from the distribution returned by the encoder in VAE? According to above, we sample from the Gaussian distribution, in order to obtain $\boldsymbol{z}$. However, this is problematic, because when we do gradient descent to train the VAE model, we don't know how to do backpropagation through the sampling module.
Instead, we use the **reparameterization trick** to "sample" $\boldsymbol{z}$. We use $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ where $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$. In this case, backpropagation in training is possible. Specifically, the gradients will go through the (element-wise) multiplication and addition in the above equation.
-->

VAE kodlayıcısı tarafından verilen dağılımdan nasıl örnek üretebiliriz? Yukarıda anlatıldığı gibi $\boldsymbol{z}$'yi elde etmek için Gauss dağılımından örnekleyebiliriz. Fakat bu problemli bir yaklaşımdır çünkü VAE'yi eğitmek için gradyan inişi kullanırsak örnekleme fonksiyonundan nasıl geri yayılım yapılabileceğini bilmiyoruz.

Bunun yerine $\boldsymbol{z}$'yi "örneklemek" için **yeniden parametreleştirme hilesi** kullanıyoruz. $\epsilon\sim \mathcal{N}(\boldsymbol{0}, \boldsymbol{I}_d)$ alarak $\boldsymbol{z} = \mathbb{E}(\boldsymbol{z}) + \boldsymbol{\epsilon} \odot \sqrt{\mathbb{V}(\boldsymbol{z})}$ formülünü kullanıyoruz. Bu sayede, eğitim sırasında geri yayılım mümkün oluyor. Gradyanlar bu formüldeki çarpım ve toplam işlemlerinden eleman çapında geçiyor.

<!-- ## [Breaking apart the VAE Loss Function](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s) -->
## [VAE kayıp fonksiyonunu parçalarına ayırmak](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=997s)

<!-- ### Visualizing Latent Variable Estimates and Reconstruction Loss -->
### Saklı Değişken Tahminlerini ve Yeniden Oluşturma Kaybını Görselleştirmek

<!--As stated above, the loss function for the VAE contains two parts: a reconstruction term and a regularization term.  We can write this as-->
Daha önce de belirtildiği gibi VAE kayıp fonksiyonu 2 kısımdan oluşur: yeniden oluşturma terimi ve düzenlileştirme terimi. Bunu şöyle ifade edebiliriz:

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = l_{reconstruction} + \beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d))
$$

<!-- To visualize the purpose of each term in the loss function, we can think of each estimated $\boldsymbol{z}$ value as a circle in $2d$ space, where the centre of the circle is $\mathbb{E}(\boldsymbol{z})$ and the surrounding area are the possible values of $\boldsymbol{z}$ determined by $\mathbb{V}(\boldsymbol{z}).$
 -->
Kayıp fonksiyonundaki her terimin amacını görselleştirmek için tahmin edilen her $\boldsymbol{z}$ değerini 2 boyutlu uzayda daireler olarak düşünebiliriz. Bu dairelerin merkezi $\mathbb{E}(\boldsymbol{z})$, kapladığı alan da $\boldsymbol{z}$'nin $\mathbb{V}(\boldsymbol{z})$ tarafından belirlenen olası değerleri olacaktır.

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Fig. 3</b>: Visualizing vector z as bubbles in the latent space
</center> -->

<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_3.png" height="350px" /><br>
<b>Şekil 3</b>: z vektörünü saklı uzaydaki daireler olarak görselleştirmek
</center>

<!-- *In Figure 3 above, each bubble represents an estimated region of $\boldsymbol{z}$, and the arrows represent how the reconstruction term pushes each estimated value away from the others, which is explained more below.*

If there is overlap between any two estimates of $z$, (visually, if two bubbles overlap) this creates ambiguity for reconstruction because the points in the overlap can be mapped to both original inputs.  Therefore the reconstruction loss will push the points away from one another.

However, if we use just the reconstruction loss, the estimates will continue to be pushed away from each other and the system could blow up.  This is where the penalty term comes in.

**Note:** for binary inputs the reconstruction loss is -->

*Yukarıda Şekil 3'te, her daire bir $\boldsymbol{z}$ değerinin tahmini bölgesini gösteriyor, oklar ise (aşağıda daha detaylı anlatılacaktır) yeniden oluşturma teriminin her daireyi nasıl birbirinden uzağa ittiğini gösteriyor.*

Eğer herhangi iki tahmini $z$ değeri üst üste gelirse (görsel olarak iki daire üst üste gelirse) bu yeniden oluşturma için belirsizlik yaratır çünkü üst üste gelen değerler her iki orijinal girdi ile de eşleştirilebilir. Bu sebepten yeniden oluşturma kaybı bu iki noktayı birbirinden uzağa iter.

Eğer sadece yeniden oluşturma kaybını kullanırsak, tahmin edilen noktalar birbirinden uzağa itilmeye devam edecek ve sistemin dağılmasına sebep olabilecektir. Bu noktada ceza terimi devreye girer.

**Not:** ikili girdiler için yeniden oluşturma kaybı:

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = - \sum\limits_{i=1}^n [x_i \log{(\hat{x_i})} + (1 - x_i)\log{(1-\hat{x_i})}]
$$

<!-- and for real valued inputs the reconstruction loss is -->
gerçek değerli girdiler için yeniden oluşturma kaybı:

$$
l(\boldsymbol{x}, \hat{\boldsymbol{x}}) = \frac{1}{2} \Vert\boldsymbol{x} - \hat{\boldsymbol{x}} \Vert^2
$$

<!-- ### The penalty term -->
### Ceza terimi

<!-- The second term is the relative entropy (a measure of the distance between two distributions) between $\boldsymbol{z}$ which comes from a Gaussian with mean $\mathbb{E}(\boldsymbol{z})$, variance $\mathbb{V}(\boldsymbol{z})$ and the standard normal distribution. If we expand this second term in the VAE loss function we get:
 -->
İkinci terim, ortalaması $\mathbb{E}(\boldsymbol{z})$ ve varyansı $\mathbb{V}(\boldsymbol{z})$ olan bir Gauss dağılımından örneklenen $\boldsymbol{z}$ ve standart normal dağılım arasındaki göreli entropi (iki dağılım arasındaki mesafe ölçüsü) değeridir. Eğer VAE kayıp fonksiyonundaki bu ikinci terimi açarsak aşağıdaki formülü elde ederiz:

$$
\beta l_{\text{KL}}(\boldsymbol{z},\mathcal{N}(\textbf{0}, \boldsymbol{I}_d)) = \frac{\beta}{2} \sum\limits_{i=1}^d(\mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1 + \mathbb{E}(z_i)^2)
$$

<!-- Where each expression in the summation has four terms. Below we write out and graph the first three terms in *Figure 4*. -->
Bu formüldeki toplamda her değer dört terimden oluşur. Aşağıda, ilk üç terimi ve bunun oluşturduğu grafiği (*Şekil 4*) göreceksiniz

$$
v_i = \mathbb{V}(z_i) - \log{[\mathbb{V}(z_i)]} - 1
$$

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Fig. 4</b>: Plot showing how relative entropy forces the bubbles to have variance = 1
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_4.png" /><br>
<b>Şekil 4</b>: Göreli entropinin dairelerin varyansını 1 olmaya zorlamasını gösteren çizim
</center>

<!-- So we can see that this expression is minimized when $z_i$ has variance 1.  Therefore our penalty loss will keep the variance of our estimated latent variables at around 1.  Visually, this means our "bubbles" from above will have a radius of around 1.

The last term, $\mathbb{E}(z_i)^2$, minimizes the distance between the $z_i$ and therefore prevents the "exploding" encouraged by the reconstruction term. -->

Görebildiğimiz gibi bu ifade, $z_i$'nin varyansı 1 olunca en küçük değere sahip oluyor. Yani ceza kaybımız tahmini kayıp değişkenlerinin varyansını yaklaşık olarak 1'de tutuyor. Bu da görsel olarak yukarıdaki "dairelerin" çapının 1 civarında olması demek oluyor.

Son terim, $\mathbb{E}(z_i)^2$, $z_i$'lar arasındaki mesayi azaltıyor ve yeniden oluşturma teriminin sebep olduğu dairelerin uzaklaşarak "patlama"sını engelliyor.

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Fig. 5</b>: The "bubble-of-bubble" interpretation of VAE
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_5.png" height="400px"/><br>
<b>Şekil 5</b>: VAE'nin "daire içinde daire" temsili
</center>

<!-- *Figure 5 above shows how VAE loss pushed the estimated latent variables as close together as possible without any overlap while keeping the estimated variance of each point around one.*
**Note:** The $\beta$ in the VAE loss function is a hyperparameter that dictates how to weight the reconstruction and penalty terms. -->
*Yukarıda *Şekil 5*, VAE'nin nasıl hiç üst üste binme olmadan ve her dairenin tahmini varyansını yaklaşık 1 seviyesinde tutarak, tahmini saklı değişkenleri mümkün olduğunca bir araya ittiğini gösteriyor.

**Not:** VAE kayıp fonksiyonundaki $\beta$ değeri yeniden oluşturma terimi ve ceza teriminin ağırlıklarını belirleyen bir hiperparametredir.

<!-- ## [Implementation of Variational Autoencoder (VAE)](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s) -->
## [Değişimsel Otokodlayıcı (VAE) kodunun yazımı](https://www.youtube.com/watch?v=7Rb4s9wNOmc&t=1893s)

<!-- The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb).

In this notebook, we implement a VAE and train it on the MNIST dataset. Then we sample $\boldsymbol{z}$ from a normal distribution and feed to the decoder and compare the result. Finally, we look at how $\boldsymbol{z}$ changes in 2D projection.

**Note:** In the MNIST dataset used, the pixel values have been normalized to be in range $[0, 1]$. -->
İlgili Jupyter notebook'a [buradan](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/11-VAE.ipynb) ulaşabilirsiniz.

Bu notebook'ta bir VAE kodu yazıp MNIST veri kümesi ile eğiteceğiz. Sonrasında normal dağılımdan bir $\boldsymbol{z}$ örnekleyip kodçözücüye vereceğiz ve sonuçları kıyaslayacağız. Son olarak, 2 boyutlu gösterimde $\boldsymbol{z}$nin nasıl değiştiğine bakacağız.

**Not:** Kullandığımız MNIST veri kümesindeki piksel değerleri $[0, 1]$ aralığına normalleştirilmiştir.

<!-- ### The Encoder and the Decoder -->
### Kodlayıcı ve Kodçözücü

<!-- 1. We define the encoder and decoder in our `VAE` module.
2. For the last linear layer of encoder, we define the output to be of size $2d$, of which the first $d$ values are the means and the remaining $d$ values are the variances. We sample $\boldsymbol{z} \in R^d$ using these means and variances as explained in the reparameterisation trick before.
3. For the last linear layer in the decoder, we use the sigmoid activation so that we can have output in range $[0, 1]$, similar to the input data. -->
1. `VAE` modülündeki kodlayıcı ve kodçözücüyü tanımlıyoruz.
2. Kodlayıcının son doğrusal katmanında, çıktıyı 2 boyutlu olacak şekilde tanımlıyoruz. İlk boyut ortalamaları, diğer boyut da varyansları ifade edecek. Daha önce yeniden parametreleştirme hilesinde anlatıldığı gibi bu ortalama ve varyans değerleri kullanılarak $\boldsymbol{z} \in R^d$ değerini örnekliyoruz.
3. Girdi verisine benzer şekilde çıktıyı $[0, 1]$ aralığında almak için kodçözücünün son doğrusal katmanında sigmoid aktivasyon fonksiyonunu kullanıyoruz.

```python
class VAE(nn.Module):
    def __init__(self):
        super().__init__()

        self.encoder = nn.Sequential(
            nn.Linear(784, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, d * 2)
        )

        self.decoder = nn.Sequential(
            nn.Linear(d, d ** 2),
            nn.ReLU(),
            nn.Linear(d ** 2, 784),
            nn.Sigmoid(),
        )
```


<!-- ### Reparameterisation and the `forward` function -->
### Yeniden parametreleştirme ve `forward` (ileri) fonksiyonu

<!-- For the `reparameterise` function, if the model is in training mode, we compute the standard deviation (`std`) from log variance (`logvar`). We use log variance instead of variance because we want to make sure the variance is non-negative, and taking the log of it ensures that we have the full range of the variance, which makes the training more stable.

During training, the `reparameterise` function will do the reparameterisation trick so that we can do backpropagation in training. To connect to the concept of a yellow bubble, as explained in the lecture, every time this function is called, we draw a point `eps = std.data.new(std.size()).normal_()`, so if we do 100 times, we will get 100 points which roughly forms a sphere because it's normal distribution, and the line `eps.mul(std).add_(mu)` will make this sphere centred in `mu` with radius equal to `std`.

For the `forward` function, we first compute the `mu` (first half) and `logvar` (second half) from the encoder, then we compute the $\boldsymbol{z}$ via the `reparamterise` function. Finally, we return the output of the decoder. -->
Model eğitim modundayken, `reparameterise` (yeniden parametreleştir) fonksiyonu için standart sapmayı (`std`) varyansın logaritmasını (`logvar`) kullanarak hesaplıyoruz. Varyans yerine varyansın logaritmasını kullanıyoruz çünkü varyansın negatif olmadığından emin olmak istiyoruz. Ayrıca logaritmasını almak, varyansın kullandığı bütün değer aralığını kullanmamızı sağlıyor bu da eğitimi daha kararlı hale getiriyor.

Eğitim boyunca `reparameterise` fonksiyonu yeniden parametreleştirme hilesini uygulayacak, böylelikle eğitim için geri yayılım kullanabileceğiz. Derste anlatılan sarı daire konseptiyle bağdaştırmak gerekirse, bu fonksiyonu her çağırdığımızda bir `eps = std.data.new(std.size()).normal_()` noktası çekiyoruz, yani 100 defa çağırırsak normal dağılım kullandığımız için yaklaşık olarak bir küre oluşturacak 100 nokta elde ederiz. `eps.mul(std).add_(mu)` satırı da bu kürenin `mu` merkezli ve `std` yarıçaplı olmasını sağlıyor.

`forward` fonksiyonunda önce kodlayıcıyı kullanarak `mu` (ilk yarı) ve `logvar`'ı (ikinci yarı) hesaplıyoruz. Sonra `reparameterise` fonksiyonu ile $\boldsymbol{z}$'yi hesaplıyoruz. Son olarak da kodçözücünün çıktısını döndürüyoruz.

```python
def reparameterise(self, mu, logvar):
    if self.training:
        std = logvar.mul(0.5).exp_()
        eps = std.data.new(std.size()).normal_()
        return eps.mul(std).add_(mu)
    else:
        return mu

def forward(self, x):
    mu_logvar = self.encoder(x.view(-1, 784)).view(-1, 2, d)
    mu = mu_logvar[:, 0, :]
    logvar = mu_logvar[:, 1, :]
    z = self.reparameterise(mu, logvar)
    return self.decoder(z), mu, logvar
```

<!-- ### Loss function for the VAE -->
### VAE'nin kayıp fonksiyonu

<!-- Here we define the reconstruction loss (binary cross entropy) and the relative entropy (KL divergence penalty). -->
Burada yeniden oluşturma kaybını (ikili çapraz entropi - binary cross entropy) ve göreli entropiyi (KL ıraksama cezası - KL divergence penalty) tanımlıyoruz.

```python
def loss_function(x_hat, x, mu, logvar):
    BCE = nn.functional.binary_cross_entropy(
        x_hat, x.view(-1, 784), reduction='sum'
    )
    KLD = 0.5 * torch.sum(logvar.exp() - logvar - 1 + mu.pow(2))

    return BCE + KLD
```


<!-- ### Generating new samples -->
### Yeni örneklerin üretilmesi


<!-- After we train our model, we can sample a random $z$ from the normal distribution and feed it to our decoder. We can observe in *Figure 6* that some of the results are not good because our decoder has not "covered" the whole latent space. This can be improved if we train the model for more epochs. -->
Modeli eğittikten sonra normal dağılım kullanarak rastgele bir $z$ örnekleyebilir ve kodçözücüye verebiliriz. *Şekil 6*'da görebileceğimiz gibi bazı sonuçlar iyi değil çünkü kodçözücümüz bütün saklı değer uzayını kapsamıyor. Bu sorunu çözmek için modelimizi daha fazla eğiterek kodçözücüyü geliştirebiliriz.

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Fig. 6</b>: Randomly moving in the latent space
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_6.png" /><br>
<b>Şekil 6</b>: Saklı değer uzayında rastgele hareket etmek
</center>

<!-- We can look at how one digit morphs into another, which would not have been possible if we used an autoencoder. We can see that when we walk in the latent space, the output of the decoder still looks legit. *Figure 7* below shows how we morph the digit $3$ to $8$. -->
Şimdi bir rakamın öbürüne nasıl dönüştüğüne bakabiliriz, eğer klasik otokodlayıcı kullanmış olsaydık bunu görmek mümkün olmayacaktı. Saklı değer uzayında gezindiğimizde kodçözücünün çıktısının mantıklı olduğunu görebiliyoruz. Aşağıda, *Şekil 7*'de $3$ rakamını $8$ rakamına nasıl dönüştürdüğümüzü görebiliriz.

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Fig. 7</b>: Morphing the digit 3 into 8
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_7.png" /><br>
<b>Fig. 7</b>: 3 rakamını 8 rakamına dönüştürmek
</center>


<!-- ### Projection of means -->
### Ortalamaların izdüşümü

<!-- Finally, let's take a look at how the latent space changes during/after training. The following charts in *Figure 8* are the means from the output of the encoder, projected on 2D space, where each colour represents a digit. We can see that from epoch 0, the classes are spreading everywhere, with only little concentration. As the model is trained, the latent space becomes more well-defined and the classes (digits) starts to form clusters. -->
Son olarak, saklı değer uzayının eğitim sırasında/sonrasında nasıl değiştiğine bakalım. Aşağıda, *Şekil 8*'deki grafikler, kodlayıcı çıktısındaki ortalamaların 2 boyutlu uzaydaki izdüşümleri (her renk farklı bir rakamı temsil ediyor). Epok 0'da sınıfların çok az toplanma göstererek farklı yerlere dağıldıklarını görebiliyoruz. Model eğitildikçe saklı değer uzayı daha iyi belirleniyor ve sınıflar (rakamlar) öbekler oluşturmaya başlıyor.

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Fig. 8</b>: 2D projection of the means $\E(\vect{z})$ in latent space
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-3/fig_8.png" /><br>
<b>Şekil 8</b>: Saklı değer uzayındaki $\E(\vect{z})$ ortalamaların 2 boyutlu izdüşümleri
</center>
