---
lang-ref: ch.08-2
lecturer: Yann LeCun
title: Düzenlileştirilmiş Saklı Değişkenli Enerji Bazlı Modeller
authors: Henry Steinitz, Rutvi Malaviya, Aathira Manoj
date: 23 Mar 2020
lang: tr
translation-date: 18 Jun 2020
translator: emirceyani
---

<!-- title: Regularized Latent Variable Energy Based Models -->

## [Düzenlileştirilmiş Saklı Değişkenli EBM'ler](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

Saklı değişkenlere sahip modeller, kestirimlerin $\overline{y}$ gözlemlenen girdi $x$ ve ilaveten bir *saklı değişken* $z$'ye  koşullu dağılımını üretebilir.
Enerji bazlı modeller de saklı değişken(ler) içerebilir:

<!-- ## [Regularized Latent Variable EBMs ](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s) Models with latent variables are capable of making a distribution of predictions $\overline{y}$ conditioned on an observed input $x$ and an additional *latent variable* $z$. Energy-based models can also contain latent variables: -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>Şekil 1</b>: Gizli değişkenli bir EBM örneği
<!-- Example of an EBM with a latent variable -->
</center>

Daha fazla detay için bir önceki dersin notlarına bakabilirsiniz.

<!-- See the previous lecture's notes for more details. -->

Ne yazık ki, eğer saklı değişken $z$ nihai kestirim $\overline{y}$'nin üretim sürecini gereğinden fazla ifade ediyorsa, her gerçek çıktı $y$, girdi $x$ ve uygun bir biçimde seçilmiş $z$ sayesinde kayıpsız yeniden oluşturulabilir. Diğer bir deyişle, enerji fonksiyonu heryerde 0 değerini almış olur çünkü enerji, çıkarım (inference) esnasında  $y$ ve $z$'ye göre eniyilenir (optimize edilir).

<!-- Unfortunately, if the latent variable $z$ has too much expressive power in producing the final prediction $\overline{y}$, every true output $y$ will be perfectly reconstructed from input $x$ with an appropriately chosen $z$. This means that the energy function will be 0 everywhere, since the energy is optimized over both $y$ and $z$ during inference. -->

Bu durum için basit bir çözum, gizli değişken $z$'nin bilgi kapasitesini sınırlamaktır. Bunu yapmanın bir yolu da gizli değişkeni düzenlileştirmektir:

<!-- A natural solution is to limit the information capacity of the latent variable $z$. One way to do this is to regularize the latent variable: -->

$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

Bu yöntem, küçük değerler alan z'nin uzay hacmini sınırlayacak ve bu sınırlamayla düşük enerjiye sahip y'nin uzayını da kontrol edebilmiş olacağız. Lambda'nın değeri bu dengeyi kontrol eder. Bu yöntemi, reel sayılar kümesi $R$ üzerinde anlatmış olsaydık, uygun boyutun neredeyse her yerde türevlenebilen  yakınsaması olan $L_1$ normu bu yöntemi oldukça iyi anlatmış olurdu. $z$'nin $L_2$ normunu kısıtlarken üzerine gürültü eklemek de bilgi kapasitesini sınırlar (VAE).

<!-- This method will limit the volume of space of z which takes a small value and the value which will, in turn, controls the space of y that has low energy. The value of Lambda controls this tradeoff. A useful example of $R$ is the $L_1$ norm, which can be viewed as an almost everywhere differentiable approximation of effective dimension. Adding noise to $z$ while limiting its $L_2$ norm can also limit its information content (VAE). -->


### Seyrek Kodlama (Sparse Coding)

Seyrek kodlama, veriyi parçalı bir doğrusal fonksiyon ile yakınsamaya çalışan koşulsuz düzenlileştirilmiş saklı değişkenli bir enerji bazlı modeldir.

<!-- Sparse coding is an example of an unconditional regularized latent-variable EBM which essentially attempts to approximate the data with a piecewise linear function. -->

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

$n$ boyutlu vektör $z$, maximum sayıda sıfırdan farklı elemana $m << n$ sahiptir. Böylece, her $Wz$, $W$'nun sütünlarının $m$ tanesinin oluşturduğu uzayının içindeki bir elemanı olacaktır.

<!-- The $n$-dimensional vector $z$ will tend to have a maximum number of nonzero components $m << n$. Then each $Wz$ will be elements in the span of $m$ columns of $W$. -->

Her eniyileme adımından sonra, matris $W$ ve saklı değişken $z$, $W$'nun sütünlarının $L_2$ normları toplamı ile normalize edilir. Bu işlemi yaparak, $W$ ve $z$'nin sıfıra veya sonsuza ulaşmamasını garantilemiş oluruz.

<!-- After each optimization step, the matrix $W$ and latent variable $z$ are normalized by the sum of the $L_2$ norms of the columns of $W$. This ensures that $W$ and $z$ do not diverge to infinity and zero. -->


### FISTA

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>Şekil 2</b>: FISTA hesaplamalı çizgesi
<!-- FISTA computation graph -->
</center>

FISTA (fast ISTA, Hızlı ISTA) seyrek kodlama enerji fonksiyonu $E(y,z)$'i $z$'ye göre eniyilemek için  $\Vert y - Wz\Vert^2$ ve $\lambda \Vert z\Vert_{L^1}$ terimlerini dönüşümlü olarak eniyileyen bir algortimadır. $Z(0)$'a ilk değerini verir ve $Z$'yi aşağıdaki kurala göre güncelleriz:


<!-- FISTA (fast ISTA) is an algorithm that optimizes the sparse coding energy function $E(y,z)$ with respect to $z$ by alternately optimizing the two terms $\Vert y - Wz\Vert^2$ and $\lambda \Vert z\Vert_{L^1}$. We initialize $Z(0)$ and iteratively update $Z$ according to the following rule: -->

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$


 $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ terimi, $\Vert y - Wz\Vert^2$ terimi için bir gradyan adımıdır. $\text{Shrinkage}$ fonksiyonu değerleri sıfıra doğru iterek $\lambda \Vert z\Vert_{L_1}$ terimini eniyilemiş olur.

<!-- The inner expression $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ is a gradient step for the $\Vert y - Wz\Vert^2$ term. The $\text{Shrinkage}$ function then shifts values towards 0, which optimizes the $\lambda \Vert z\Vert_{L_1}$ term. -->


### LISTA

FISTA'yı büyük boyutlu veri kümelerine (örn. resimler) uygulamak oldukça maliyetlidir. FISTA algoritmasını daha da verimlileştirmek için en iyi saklı değişken $z$'yı öngörmek için bir ağ eğitmektir:

<!-- FISTA is too expensive to apply to large sets of high-dimensional data (e.g. images). One way to make it more efficient is to instead train a network to predict the optimal latent variable $z$: -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>Şekil 3</b>: Saklı değişken kodlayıcılı EBM modeli
 <!-- EBM with latent variable encoder -->
</center>

Bu yapının enerji fonksiyonu, öngörülen gizli değişken $\ overline z $ ile optimal gizli değişken $z$ arasındakı farkı ölçen ek bir terim içerir:

<!-- The energy of this architecture then includes an additional term that measures the difference between the predicted latent variable $\overline z$ and the optimal latent variable $z$: -->

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

Daha fazla tanımlamak gerekirse,

<!-- We can further define -->

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

ve sonra aşağıdaki gibi yazabiliriz:

<!-- and then write -->

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

Yukarıdaki kuralı yinelemeli sinir ağı gibi yorumlamak, yani saklı değişken $z$'yi sürekli tahmin edebilmemizi sağlayan parametreleri $W_e$ öğrenmek mümkündür. Ağ, sabit sayıda $K$ adımı kadar çalıştırılır ve $W_e$'nin gradyanları zamanla geri yayılım yöntemiyle hesaplanır. Eğitilmiş ağ, FISTA algoritmasından daha kısa adımda iyi $z$'ler üretir.

<!-- This update rule can be interpreted as a recurrent network, which suggests that we can instead learn the parameters $W_e$ that iteratively determine the latent variable $z$. The network is run for a fixed number of time steps $K$ and the gradients of $W_e$ are computed using standard backpropagation-through-time. The trained network then produces a good $z$ in fewer iterations than the FISTA algorithm. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>Şekil 4</b>: Zamanla açılmış bir yinelemeli ağ olarak LISTA
 <!-- LISTA as a recurrent net unfolded through time. -->
</center>


### Seyrek Kodlama Örnekleri

<!-- ### Sparse Coding Examples -->

256 boyutlu bir saklı değişkene sahip seyrek kodlama sistemi MNIST veri setinde kullanıldığında, sistem eğitim kümesinin neredeyse tamamını doğrusal bir şekilde birleştirerek oluşturabilmemizi sağlayan 256 kalem vuruşunu öğrenir. Seyrek düzenleştirici ise yeni örnekleri oluştururken olabildiğince az kalem vuruşu kullanmaya zorlar.

<!-- When a sparse coding system with 256 dimensional latent vector is applied to MNIST handwritten digits, the system learns a set of 256 strokes that can be linearly combined to nearly reproduce the entire training set. The sparse regularizer ensures that they can be reproduced from a small number of strokes. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>Şekil 5</b>: MNIST'te Seyrek Kodlama. Her bir resim W'nin öğrenilmiş sütunudur.
 <!--  Sparse coding on MNIST. Each image is a learned column of W. -->
</center>

Seyrek kodlama sistemi, doğal görüntü yamalarında eğititldiğinde, öğrenilen öznitelikler yönlendirilmiş kenarlara sahip gabor filtreleridir. Bu öznitelikler, hayvan görme sistemlerinin ilk kısımlarında öğrenilen öznitelikleri andırmaktadır.

<!-- When a sparse coding system is trained on natural image patches, the learned features are gabor filters, which are oriented edges. These features resemble features learned in early parts of animal visual systems. -->


### [Evrişimsel Seyrek Kodlama (Convolutional Sparse Coding)](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

<!-- ### [Convolutional sparse coding](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s) -->

Diyelim ki bir resmimiz ve resmin öznitelik haritası ($z_1, z_2, \cdots, z_n$) olsun. Ardından, her bir öznitelik haritasını çekirdek $K_i$ ile evrişimleyebiliriz ($*$). Yeniden oluşturum (reconstruction) hesabı aşağıdaki gibidir:

<!-- Suppose, we have an image and the feature maps ($z_1z_2...z_n$) of the image. Then we can convolve ($*$) each of the feature maps with the kernel $K_i$. Then the reconstruction can be simply calculated as: -->

$$Y=\sum_{i}K_i*Z_i$$

Burada yeniden oluşturum, bildiğimiz seyrek kodlamadakinden, $Y=\sum_{i}W_iZ_i$, farklıdır. Seyrek kodlamada, sütünlar ve $Z_i$'nin katsayıları ile ağırlıklı toplam kullanılarak yeniden oluşturum gerçekleştirilir. Evrişimsel seyrek kodlamada, hala doğrusal bir işlem yapmaktayız, ancak sözlük (dictionary) matrisi artık öznitelik haritalarıyla ifade edilir ve her bir öznitelik haritasını tüm çekirdeklerler ile evriştirip sonuçları toplayarak yeniden oluşturum gerçekleştirilir.

<!-- This is different from the original sparse coding where the reconstruction was done as $Y=\sum_{i}W_iZ_i$. In regular sparse coding, we have a weighted sum of columns where the weights are coefficients of $Z_i$. In convolutional sparse coding, it is still a linear operation but the dictionary matrix is now a bunch of feature maps and we convolve each feature map with each kernel and sum up the results. -->


#### Doğal Görüntülerde Evrişimsel Seyrek Özkodyalıcı

<!-- #### Convolutional Sparse Auto-Encoder on Natural Images -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>Şekil 6</b> Elde edlien Filtreler ve Temel Fonksiyonlar. Doğrusal Evrişimsel Kodçözücü
<!--  Filters and Basis Functions obtained. Linear convolutional decoder  -->
</center>

Kodlayıcı (encoder) ve kodçözücüdeki (decoder) filtreler görünüş itibariyle birbirlerine benzerdir. Kodlayıcı, sırasıyla evrişim üzerine doğrusal olmayan bir işlem ve bu işlemi takip eden ölçeği manipüle eden diyagonal katmandan ibarettir. Sonra, kodun kısıtlamasında seyreklik bulunmaktadır. Kodçözücü ise evrişimsel ve doğrusal bir kodçözücüdür. Geridönüştürüm kare hatasıyla gerçekleştirirlir.

<!-- The filters in the encoder and decoder look very similar. Encoder is simply a convolution followed by some non-linearity and then a diagonal layer to change the scale. Then there is sparsity on the constraint of the code. The decoder is just a convolutional linear decoder and the reconstruction here is the square error. -->

Yani, sadece bir tane filtre olduğunu dayatırsak o zaman bu filtre merkezi bir filtredir. İki filtre ile değişik şekillerde filtreler elde edebiliriz. Dört filtreyle yatay ve dikey kenarlar elde edebiliriz; her filtre için 2 kutba sahip oluruz. Sekiz filtreyle sekiz farklı yönde yönlendirilmiş filtreler elde edebiliriz. On altı tane ile, merkeze doğru daha fazla yön elde ederiz. Filtre sayısını arttırdıkça, kenar dedektörlerine ek olarak daha değişik filtreler ve değişik yönlerde dedektörler elde edebiliriz.

<!-- So, if we impose that there is only one filter then it is just a center surround type filter. With two filters, we can get some weird shaped filters. With four filters, we get oriented edges (horizontal and vertical); we get 2 polarities for each of the filters. With eight filters we can get oriented edges at 8 different orientations. With 16, we get more orientation along with the centers around. As we go on increasing the filters, we get more diverse filters that is in addition to edge detectors, we also get grating detectors of various orientations, centers around, etc. -->

Bu olay ilginç gözükebilir çünkü yukarıdaki filtreler ile görsel kortekste gözlemlediklerimiz aslında oldukça benzerdir. Bu da, iyi öznitelikleri tamamiyle denetimsiz bir şekilde öğrenebileceğimizin bir göstergesidir.

<!-- This phenomenon seems to be interesting since it is similar to what we observe in the visual cortex. So this is an indication that we can learn really good features in a completely unsupervised way. -->

Eğer bu öznitelikleri evrişimsel bir ağda kullanıp bir görev için eğitirsek, baştan eğittiğimiz bir ağın performansına sahip olamayacağız. Ancak, bu öznitelikler bazı durumlarda performansı iyileştirebilir. Örneğin, elimizdeki verinin sayısı yeterli değilse veya çok az sayıda kategori varsa, denetimli öğrenme ile, işe yaramayan öznitelikler elde edebiliriz.

<!-- As a side use, if we take these features and plug them in a convolutional net and then train them on some task, then we don't necessarily get better results than training an image net from scratch. However, there are some instances where it can help to boost performance. For instance, in cases where the number of samples are not large enough or there are few categories, by training in a purely supervised manner, we get degenerate features. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>Şekil 7 </b> Renkli resimde Evrişimsel Seyrek Kodlama
<!-- Convolutional sparse encoding on colour image -->
</center>

Yukardaki şekil, renkli görüntülerde bir başka örnektir. Kodçözücü çekirdeğin (sağ tarafta) boyutu 9'a 9'dur. Bu çekirdek tüm resme evrişimsel bir biçimde uygulanır. Soldaki resim, kodçözücüdeki seyrek kodları göstermektedir. $Z$ vektöründe bileşenlerin çok azı beyaz veya siyahtır ki bu da vektörün oldukça seyrek olduğunu göstermektedir.

<!-- The figure above is another example on color images. The decoding kernel (on the right side) is of size 9 by 9. This kernel is applied convolutionally over the entire image. The image on the left is of the sparse codes from the encoder. The $Z$ vector is very sparse space where there are just few components that are white or black (non-gray). -->


### [Değişimsel Otokodlayıcılar](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)

Değişimsel Otokodlayıcılar, seyreklik haricinde düzenlileştirilmiş saklı değişken enerji bazlı modelleri ile benzer bir mimariye sahiptir. Fakat bilgi, koda gürültü ekleyerek sınırlandırılır.

<!-- Variational Autoencoders have an architecture similar to Regularized Latent Variable EBM, with the exception of sparsity. Instead, the information content of the code is limited by making it noisy. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>Şekil 8</b>: Değişimsel Otokodlayıcı Mimarisi
 <!-- Architecture of Variational Autoencoder -->
</center>

Saklı değişken $z$, enerji fonksiyonunu $z$'ye göre minimize ederek hesaplanmaz. Burada enerji fonksiyonunu, logaritmasını aldığımızda bize ${\overline z}$'ye bağlanma bedelini veren bir dağılımdan saklı değişken $z$'nin rastgele örneklenmesi olarak düşünebiliriz. Burada dağılım, ortalaması ${\overline z}$ olan bir Gaussian dağılımıdır ve ${\overline z}$'nin üzerine Gaussian gürültüsü eklemiş oluruz.

<!-- The latent variable $z$ is not computed by minimizing the energy function with respect to $z$. Instead, the energy function is viewed as sampling $z$ randomly according to a distribution whose logarithm is the cost that links it to ${\overline z}$. The distribution is a Gaussian with mean ${\overline z}$ and this results in Gaussian noise being added to ${\overline z}$. -->

Üzerine Gaussian gürültüsü eklenmiş kod vektörlerini Şekil 9(a)'da görebilirsiniz.

<!-- The code vectors with added Gaussian noise can be visualized as fuzzy balls as shown in Fig. 9(a). -->

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) Bulanık toplar kümesi <!--Original set of fuzzy balls-->  </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b) Topların düzenlileştirme olmadan enerji minimizasyonu sebebiyle hareketi
<!--Movement of fuzzy balls due to energy minimization without regularization-->
</center>  |

<center><b>Şekil 9:</b> Bulanık toplarda enerji minimizasyonunun etkisi
<!-- Effect of energy minimization on fuzzy balls -->
</center>

Sistem, $z$'nin (gürültü) etkisini olabildiğince azaltmak için kod vektörleri ${\overline z}$'yi mümkün olduğunca büyütmeye çalışır. Bu durumu da, Şekil 9(b)'de görüldüğü gibi orjinden uzaklaşan bulanık toplar (fuzzy balls) ile anlayabiliriz. Sistemin kod vektörlerini olabildiğince büyütmek istemesinin bir diğer sebebi de bulanık topların çakışmasını engellemek, yani çözümleyicinin farklı örneklerin yeniden oluşturumu sırasında oluşabilecek karmaşayı engellemektir.

<!-- The system tries to make the code vectors ${\overline z}$ as large as possible so that the effect of $z$(noise) is as small as possible. This results in the fuzzy balls floating away from the origin as shown in Fig. 8(b). Another reason why the system tries to make the code vectors large is to prevent overlapping fuzzy balls, which causes the decoder to confuse between different samples during reconstruction. -->

Fakat, eğer varsa, bulanık topların veri manifoldu etrafında toplanmasını isteriz. Bu yüzden, sistemin kod vektörlerini bir ortalamaya ve sıfıra yakın bir varyansları olmasına zorlamalıdır. Bu zorlamayı gerçekleştirmek için, Şekil 10'daki gibi topları, yani kod vektörlerini, orjine bir yayla bağladığımızı düşünelim.

<!-- But we want the fuzzy balls to cluster around a data manifold, if there is one. So, the code vectors are regularized to have a mean and variance close to zero. To do this, we link them to the origin by a spring as shown in Fig. 10. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>Şekil 10</b>: Yaylarla görselleştirilen düzenlileştirmenin etkileri
 <!-- Effects of regularization visualized with springs  -->
</center>

Yayın gücü, bulanık topların orijine ne kadar yakın olduğunu belirler. Eğer yay çok zayıf ise, toplar orjinden uzaklaşacaktır. Eğer çok güçlüyse, toplar orjinde kümelenecektir ki bu da yüksek enerjiye sebep verecektir. Bu durumu engellemek için, sistem kürelerin örneklerinin benzer olması şartıyla üst üste gelmesine izim verecektir.

<!-- The strength of the spring determines how close the fuzzy balls are to the origin. If the spring is too weak, then the fuzzy balls would fly away from the origin. And if it's too strong, then they would collapse at the origin, resulting in a high energy value. To prevent this, the system lets the spheres overlap only if the corresponding samples are similar. -->

Topların boyutlarını da kontrol edebilmek mümkündür. Bu kontrol, varyansı 1'e yaklaştırmaya çalışarak topu ne çok büyütüp ne de çok küçülten KL Iraksaması (KL Divergence) ile yapılır.

<!-- It is also possible to adapt the size of the fuzzy balls. This is limited by a penalty function (KL Divergence) that tries to make the variance close to 1 so that the size of the ball is neither too big nor too small that it collapses. -->
