---
lang-ref: ch.08-1
lang: tr
title: Enerjı Bazlı Modellerde Karşıtsal Yöntemler
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 23 Mar 2020
traslation-date: 17 June 2020
translator : emirceyani
---
<!-- title: Contrastive Methods in Energy-Based Models -->

## [Tekrar](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

<!--## [Review](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s) -->

Dr. LeCun dersin ilk 15 dakikasında enerji bazli modelleri tekrar etmişti.
Bu konu icin lütfen bir önceki haftayı, özellikle karşıtsal öğrenme yöntemlerini, gözden geçiriniz.

<!-- Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods. -->

Önceki dersten öğrendiğimiz üzere, öğrenme yöntemleri iki ana sınıfa ayrılmaktadır:
1. Eğitim kümesindeki örneklerin enerjilerini $F(x_i, y_i)$ aşağı çekerken geri kalan her yerde ise enerjiyi yukarı iten $F(x_i, y’)$ Karşıtsal Yontemler.
2. Düzenlileştirme yardımı ile sınırlı sayıda düşük enerji bölgelerine sahip bir enerji fonksiyonu F modelleyen Yapısal Yöntemler.

<!-- As we have learned from the last lecture, there are two main classes of learning methods:
1. Contrastive Methods that push down the energy of training data points, $F(x_i, y_i)$, while pushing up energy on everywhere else, $F(x_i, y’)$.
2. Architectural Methods that build energy function F which has minimized/limited low energy regions by applying regularization. -->

Farklı eğitim yöntemlerinin özelllklerini ayırt edebilmek için, Dr. Yann LeCun enerji fonksiyonunu biçimlendirmemizi sağlayan 7 strateji önermişti. Bu stratejilerden biri de veri noktalarının enerjisini aşağı çeken ve geri kalan tüm noktaların enerjisini iten En Büyük Olabilirlik (Maximum Likelihood) yöntemine benzer yöntemlerdir.

<!-- To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method, which push down the energy of data points and push up everywhere else. -->

En Büyük Olabilirlik yöntemi olasılıksal bir şekilde eğitim kümesindeki verilerin enerjilerini aşağı çekerken geri kalan her yerde, ($y'\neq y_i$), enerjileri yukarı doğru iter. Bu yöntem enerjilerin "mutlak değerleri"nden ziyade "aralarındaki farkı" dikkate alır. Bunun sebebi ise olasılık dağılımlarının toplamının/integralinin her zaman 1 edecek şekilde normalize edilmesidir ki bu durumda herhangi iki noktanın oranına bakmak mutlak değerlerini kıyaslamaktan daha yararlıdır.

<!-- Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of $y’\neq y_i$. Maximum Likelihood doesn’t “care” about the absolute values of energies but only “cares” about the difference between energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values. -->


## [Özdenetimli öğrenmede Karşıtsal Yontemler](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

<!--## [Contrastive Methods in Self-Supervised Learning](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)   -->

Karşıtsal yöntemlerde eğitim kümesinde gözlemiş olduğumuz örneklerin ($x_i$, $y_i$) enerjilerini aşağı iterken, eğitim kümesinin manifoldu dışında kalan örneklerin enerjlerini yukarı itiyoruz.

<!-- In contrastive methods, we push down on the energy of observed training data points ($x_i$, $y_i$), while pushing up on the energy of points outside of the training data manifold. -->

Özdenetimli öğrenmede girdinin bir kısmını kulllanarak diğer kısımlarını tahmin etmeye çalışırız. Bu öğrenme modelinden beklentimiz, modelimizin bilgisayarlı görü için denetimli görevlerle rekabet edebilecek seviyede iyi öznitelikler üretebilmesidir.

<!-- In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks. -->

Araştırmacılar, özdenetimli öğrenme modellerinde karşıtsal gömülme (contrastive embedding) yöntemlerini uygulayarak denetimli modellere rakip olabilecek performanslar elde edilebildiğini deneysel olarak gözlemlemişlerdir. Bu yöntemlerden bazılarını ve sonuçlarını aşağıda inceleyeceğiz.

<!-- Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below. -->

### Karşıtsal Gömülme (Contrastive Embedding)

<!-- ### Contrastive Embedding -->

Bir çift ($x$, $y$) düşünelim, $x$'in bir görüntü ve $y$ de $x$ 'in içeriği koruyan bir dönüşüm (döndürme, büyütme, kırpma, vb.) olsun.  Bu çifti **pozitif** çift olarak adlandıralım.

<!-- Consider a pair ($x$, $y$), such that $x$ is an image and $y$ is a transformation of $x$ that preserves its content (rotation, magnification, cropping, etc). We call this a **positive** pair. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Pozitif Çift
</center>

Konsept olarak, karşıtsal gömülme yöntemleri, pozitif çifti evrişimsel bir ağın girdisi olarak kullanır ve iki öznitelik vektörü $h$ ve $h'$'ı öğrenir. Pozitif çift $x$ ve $y$ aynı içeriğe sahip olduğu için, öznitelik vektörlerinin de olabildiğince benzer olmalarını istiyoruz. Bu amacı gerçekleştirmek için, benzerlik metriği (kosinüs benzerliği gibi) ve $h$ ile $h'$ arasındaki benzerliği maksimize eden bir kayıp fonksiyonu tanımlamamız gerekiyor. Bunu yaparak, eğitim verisini barındıran manifoldun içinde bulunan tüm görüntülerin enerjilerini düşürüyoruz.

<!-- Conceptually, contrastive embedding methods take a convolutional network, and feed $x$ and $y$ through this network to obtain two feature vectors: $h$ and $h'$. Because $x$ and $y$ have the same content (i.e a positive pair), we want their feature vectors to be as similar as possible. As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between $h$ and $h'$. By doing this, we lower the energy for images on the training data manifold. -->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Negatif Çift
</center>

Ancak, manifoldun dışında kalan noktaların enerjisini yukarı itmek zorundayız. Bu yüzden **negatif** örnekler, yani farklı içeriğe sahip resimler (örneğin farklı sınıf etiketi), ($x_{\text{neg}}$, $y_{\text{neg}}$), üretiyoruz. Bu örnekleri ağımıza girdi olarak verip, öznitelik vektörleri $h$ ile $h'$'ı elde ediyor ve bu iki vektör arasındaki benzerliği minimize etmeye çalışıyoruz.

<!-- However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$, $y_{\text{neg}}$), images with different content (different class labels, for example). We feed these to our network above, obtain feature vectors $h$ and $h'$, and now try to minimize the similarity between them. -->

Bu yöntem, benzer çiftlerin enerjisini aşağı çekerken benzer olmayan çiftlerin enerjilerini de yukarı itmemizi sağlar.

<!-- This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs. -->

ImageNet'teki yeni sonuçlar bize bu yöntemin, nesne tanıma için denetimli öğrenme yöntemleriyle öğrenilen özelliklere rakip olabilecek derecede iyi özellikler üretebileceğini göstermiştir.

<!-- Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods. -->

### Özdenetimli Öğrenilmiş Sonuçlar (MoCo, PIRL, SimCLR)

<!-- ### Self-Supervised Results (MoCo, PIRL, SimCLR) -->

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: ImageNet üzerinde PIRL ve MoCo
</center>

Yukarıdaki şekilde de görüldüğü üzere, MoCo ve PIRL SOTA (Alanının En İyisi, State of the Art) sonuçlara ulaşmıştır (özellikle az sayıda parametreli ve düşük kapasiteli modellerde). PIRl, diğer denetimli sistemlerin doğruluğuna (~75%) yaklaşmaya başlamıştır.

<!-- As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRl is starting to approach the top-1 linear accuracy of supervised baselines (~75%). -->

PIRL yöntemini, amaç fonksiyonu aşağıdaki gibi olan NCE'yi (Gürültüye Karşıt Kestirici, Noise Contrastive Estimator) inceleyerek daha iyi anlayabiliriz.

<!-- We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows. -->

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

Burada, iki özniitelik haritası/vektörü arasındaki benzerlik metriği kosinüs benzerliği olarak tanımlanmıştır.

<!-- Here we define the similarity metric between two feature maps/vectors as the cosine similarity. -->

PIRL'in farkı evrişimsel öznitelik üreticisinin çıktısını doğrudan kullanmamasıdır. Aksine, evrişimsel öznitelik üreticisinden bağımsız katmanlar, $f$ ve $g$, kullanır.


<!-- What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_ $f$ and $g$, which can be thought of as independent layers on top of the base convolutional feature extractor. -->

Her şeyi bir araya getirirsek, PIRL'in NCE amaç fonksiyonu şu şekilde çalışır. Bir miniyığında (mini-batch), bir pozitif (benzer) çift ve çok sayıda negatif (benzer olmayan) çiftlere sahip olalım. Önce, dönüştürülmüş resmin öznitelik vektörü ile miniyığındaki tüm örneklerin arasındaki benzerliği hesaplayalım. Sonra, pozitif çift için softmax-vari fonksiyonun skorunu hesaplayalım. Softmax skorunu maksimize etmemiz geri kalan tüm skorları minimize etmek demektir ki bu bizim enerji bazlı modellerde istediğimiz bir durumdur. Böylelikle, NCE kayıp fonksiyonu, benzer çiftlerin enerjilerini aşağı iterken benzer olmayan çiftlerin enerjilerini de yukarı itmemize olanak veren bir model tasarlamamızı sağlar.


<!-- Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs. -->

Dr. LeCun, PIRL'ın çalışması için oldukça fazla sayıda negatif örneğe ihtiyaç uyulduğunu belirtmektedir. SGD'de miniyığındaki negatif örneklerin çoğunu sürekli olarak tutabilmek zor olabilir. Bü  durumu çözmek için PIRL, özel bir ön bellek yapısı kullanmaktadır.

<!-- Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank. -->

**Soru**: L2 normu yerine neden kosinüs benzerliği kullanıyoruz?
Cevap: Çünkü, oldukça kısa (merkeze yakın) ya da oldukça uzun (merkezden uzak) iki vektör seçersek bu iki vektör L2 normuna göre birbirlerine benzer diyebiliriz. Bunun sebebi, L2 normunun vektörlerin elemanları arasındaki farklarının kareleri toplamıdır. Dolayısıyla, kosinüs benzerliği kullanarak sistemimizi "hile yapmamaya" yani vektörleri uzaltıp kısaltmadan iyi bir sonuç bulmaya zorluyoruz.

<!-- **Question**: Why do we use cosine similarity instead of L2 Norm? -->
<!-- Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to center) or make two vectors dissimilar by making them very "long" (away from the center). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long. -->


### SimCLR

<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: SimCLR'ın  ImageNet Üzerindeki Sonuçları
</center>

SimCLR önceki metodlardan daha iyi sonuçlar göstermektedir. Hatta, denetimli metodlarin Imagenet'te ulaştığı en iyi 1. lineer doğruluk performansına erişmiştir.
benzer çiftler oluşturmak için karmaşık bir veri büyütme yöntemi kullanır ve TPU'larda büyük miktarda (çok, çok büyük parti yığınlarla) eğitim yapar.
Dr. LeCun, SimCLR'in bir ölçüde karşıtsal yöntemlerin sınır çizgisi olduğuna inanmakta.
Yüksek boyutlu bir uzayda, veri manifoldundan gerçekten daha yüksek olduğundan emin olmak için enerjiyi yükseltmeniz gereken birçok bölge var. Gösterimlerin boyutları arttıkça, daha fazla negatif örneğe ihtiyaç duyulmaktadir ki enerjinin manifold üzerinde olmayan bölgelerinde daha yüksek olması şartı sağlanabilsin.


<!-- SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet. The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs. Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold. -->

## [Arıtan Otokodlayıcılar](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

<!-- ## [Denoising Autoencoders](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)-->

[7. haftanın uygulamasında](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), arıtan otokodlayıcıdan bahsetmiştik.
Bu yapı, veri gösterimini bozuk girdiyi orjinal veriye geri dönüştürmeye çalışarak öğrenir.
Detaylıca bahsedersek, sistemi, bozulmuş veriler veri manifoldundan uzaklaştıkça karesel bir oranda büyüyen bir enerji fonksiyonu üretebilmesi için eğitiyoruz.

<!-- In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input. More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold. -->


<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>:Arıtan Otokodlayıcı Mimarisi
</center>

### Problemler

<!-- ### Issues -->

Ancak arıtan otokodlayıcılar ile ilgili çeşitli sorunlar bulunmaktadır.
Öncelikle, çok boyutlu ve sürekli bir uzayda, veriyi bozmanın sonsuz sayıda yolu vardır. Bu yüzden enerji fonksiyonunu basitçe bir sürü değişik bölgede yukarı iterek şekillendirebileceğimizin garantisi yoktur.
Bir diğer problem ise saklı değişkenlerin noksanlığından ötürü arıtan otokodlayıcılar görüntülerde kötu performans sergilemektedir.
Bir resmi yeniden oluşturmanın sayısız yöntemi olduğundan, sistem çeşitli tahminler üretir ve bilhassa iyi öznitelikler öğrenemez.
Ayrıca, manifoldun ortasında kalan bozunmuş noktaları iki taraftan da onarmamız mümkün. Bu durum enerji fonksiyonumuzda düz bölgeler oluşmasına neden olur ve genel performansı etkiler.

<!-- However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations. Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features. Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance. -->

## Diger Karşıtsal Yontemler


Karşıtsal ıraksama (Contrastive divergence), Oran Eşleştirme (Ratio Matching), Gürültüye Karşıt Kestirim (Noise Contrastive Estimation) ve Minimum Olasılık Akışı (Minimum Probability Flow) gibi çeşitli karşıtsal yöntemler literatürde bulunmaktadır. Bu bölümde, karşıtsal ıraksamanın arkasında yatan temel fikirden bahsedeceğiz.

<!-- ## Other Contrastive Methods
There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence. -->

### Karşıtsal Iraksama(Contrastive Divergence)

Karşıtsal Iraksama (CD) girdileri akıllıca bozarak veri gösterimi öğrenmeyi hedefler.
Sürekli bir uzayda, önce eğitim kümemizden bir örnek $y$ seçip sonra onun enerjisini düşürüyoruz. Seçtiğimiz örnek için, gradyan bazlı bir süreç ile gürültü kullanarak enerji yüzeyinde hareket ediyoruz. Eğer girdilerimiz ayrık bir uzaydan alınıyorsa, örneği rastgele bozmamız o örneğin enerjisini değiştirmek için yeterli olacaktır. Bozunum sonucu eğer enerji düşüyor ise o örneği tutuyoruz. Aksi takdirde, belli bir olasılık ile o örneği atıyoruz. Bu süreci devam ettirdikçe $y$'nin enerjisi de en sonunda düşecektir. Daha sonra, enerji fonksiyonumuzun parametresini $y$ ve zıtlaştırılmış örneğimiz $\bar y$'i kayıp fonksiyonu kullanarak kıyaslayıp güncelleyebilmiş oluruz.

<!-- ### Contrastive Divergence
Contrastive divergence is another model that learns the representation by smartly corrupting the input sample. In a continuous space, we first pick a training sample $y$ and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. Keep doing so will eventually lower the energy of $y$. We can then update the parameter of our energy function by comparing $y$ and the contrasted sample $\bar y$ with some loss function. -->


### Kalıcı Karşıtsal Iraksama (Persistent Contrastive Divergence)

Karşıtsal Iraksama'nın özel bir versiyonu ise Kalıcı Karşıtsal Iraksama yöntemidir. Önceki yönteme kıyasla sistem, konumunu hatırlayabilen bir grup "parçacık" kullanır. Bu parçacıklar tıpkı CD'deki gibi enerji yüzeyinde hareket ettirilir. Sonunda, bu parçaçıklar enerji yüzeyimizdeki düşük enerjili yerleri bulacak ve yukarı itilmelerini sağlayacaktır. Ancak, boyut arttıkça sistem performansı kötü etkilenmektedir.


<!-- ### Persistent Contrastive Divergence
One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD. Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases. -->
