---
lang-ref: ch.07-3
lang: tr
title: Otokodlayıcılara giriş
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 19 Jul 2020
translator: yavuzdrmzksr
---

## [Otokodlayıcıların uygulamaları](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)

<!--## [Application of autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)-->


### Resim üretimi

<!--### Image generation-->

Fig. 1'deki resimlerden hangisinin sahte olduğunu söyleyebilir misiniz? Aslında, ikisi de StyleGan2 üreticisi tarafından oluşturuldu. Yüz detayları çok gerçekçi olsa da, arkaplan garip görünüyor (sol: bulanık, sağ: şekilsiz objeler). Bunun sebebi sinir ağının yüz örnekleri üzerinde eğitilmiş olması. Arkaplanın değişkenliği çok daha yüksek. Burada data manifoldunun boyutu yaklaşık 50, yüz resminin serbestlik derecesine eşit.

<!--Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: StyleGan2 tarafından üretilen yüzler
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces generated from StyleGan2
</center>-->


### Piksel Uzayı ve Gizli Uzayda Ara Değer Bulmanın Farkı

<!--### Difference of Interpolation in Pixel Space and Latent Space-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: Bir köpek ve bir kuş
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: A dog and a bird
</center>-->

Eğer köpek ve kuş resimleri (Fig. 2) arasındaki ara değeri lineer bir şekilde piksel uzayında bulursak, Fig. 3'teki iki resmin üst üste binmiş görüntüsünü elde ederiz. Sol üstten sağ alta, köpek resminin ağırlığı azalırken kuş resminin ağırlığı artıyor.

<!--If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Ara değer bulmanın sonuçları
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Results after interpolation
</center>-->

Eğer iki saklı uzay gösteriminin ara değerini bulup bunu kodçözücüye verirsek, Fig. 4'teki köpekten kediye dönüşümü elde ederiz.

<!--If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Kodçözücüden gelen sonuçlar
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Results after feeding into decoder
</center>-->

Açık bir şekilde saklı uzay resmin yapısını anlamakta daha iyi.

<!--Obviously, latent space is better at capturing the structure of an image.-->


### Dönüşüm Örnekleri

<!--### Transformation Examples-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Yakınlaştırma
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center>-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Kaydırma
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Shift
</center>-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Parlaklık
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brightness
</center>-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Döndürme (Dönmenin 3 boyutlu olabileceğini unutmayın)
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotation (Note that the rotation could be 3D)
</center>-->


### Görüntü Süper-çözünürlüğü

<!--### Image Super-resolution-->

Bu modelin amacı görüntüyü geliştirip orijinal yüzleri yeniden oluşturmak. Fig. 9'da soldan sağa, ilk sütun 16x16'lık girdi görüntüsü, ikincisi standart bikübik ara değer bulmadan elde ettiğimiz, üçüncüsü sinir ağı tarafından oluşturulan sonuç, en sağdaki ise orijinal resim. (https://github.com/david-gpu/srez)

<!--This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez)-->

<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Orijinal yüzlerin yeniden oluşturulması
</center>

<!--<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstructing original faces
</center>-->

Çıktı resimlerinden eğitim verisinde önyargı olduğu çok açık, bu da yeniden oluşturulan yüzlerin hatalı olmasına sebep oluyor. Örneğin, sol üstteki Asyalı adam, dengesiz eğitim görüntülerinden dolayı çıktıda Avrupalı gibi görünüyor. Sol alttaki kadının yeniden oluşturulmuş yüzü eğitim resimlerindeki o açıdaki örnek eksikliğinden dolayı garip gözüküyor.

<!--From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data.-->


### Görüntü Renklendirme

<!--### Image Inpainting-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Yüzlere gri parça konulması
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Putting grey patch on faces
</center>-->

Fig. 10'daki gibi yüzün üzerine gri bir parça koymak resmi eğitim manifoldundan uzaklaştırır. Fig. 11'deki gibi yüzü yeniden oluşturmak, Enerji fonksiyonunu minimize ederek en yakın örnek resmi bularak yapılıyor.

<!--Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: <b>Fig. 10</b>'un yeniden oluşturulmuş görüntüsü
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Reconstructed image of <b>Fig. 10</b>
</center>-->


### Açıklamadan Görüntü Oluşturmak

<!--### Caption to Image-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Açıklamadan görüntü oluşturma örneği
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Caption to Image example
</center>-->

Fig. 12'deki gibi yazılı açıklamadan görüntüyü metnin özelliklerinden önemli görsel bilgileri çıkarıp onları görüntüye çevirerek yapılıyor.

<!--The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images.-->


## [Otokodlayıcılar nedir?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

<!--## [What are autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)-->

Otokodlayıcılar, denetimsiz bir şekilde eğitilen, önce verimizin kodlanmış gösterimini öğrenip daha sonra bu kodlanmış gösterimden girdi verisini mümkün olan en yakın şekilde üreten yapay sinir ağlarıdır. Bu yüzden, otokodlayıcının çıktısı, girdi için bir tahmindir.

<!--Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Basit bir otokodlayıcının mimarisi<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Architecture of a basic autoencoder<br>
</center>-->

Fig. 13 basit bir otokodlayıcının mimarisini gösteriyor. Daha önce olduğu gibi, aşağıdan girdi $\boldsymbol{x}$ ile başlayıp, daha sonra onu otokodlayıcıya ($\boldsymbol{W_h}$ ve arkasından gelen sıkıştırma ile tanımlanan bir afin dönüşümü) veriyoruz. Bu işlemin sonucu ara gizli katman $\boldsymbol{h}$. Bu da daha sonra kodçözücüye ($\boldsymbol{W_x}$ ve arkasından gelen sıkıştırmayla tanımlanan başka bir afin dönüşümü) girdi olarak veriliyor. Buradan çıkan ise modelimizin girdisinin tahmini/yeniden üretimi olan $\boldsymbol{\hat{x}}$. Daha önce yaptığımıza benzer olarak, buna 3 katmanlı bir sinir ağı diyoruz.

<!--Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder (affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network.-->

Yukarıdaki ağı bu denklemlerle matematiksel olarak gösterebiliriz:

<!--We can represent the above network mathematically by using the following equations:-->

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

Ayrıca aşağıdaki boyutları belirtiyoruz:

<!--We also specify the following dimensionalities:-->

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<b>Not:</b> PCA gösteriminde, ağırlıklarımızın tanımı $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$ olabilir.

<!--<b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$-->


## Neden otokodlayıcıları kullanıyoruz?

<!--## Why are we using autoencoders?-->

Bu noktada girdiyi tahmin etmenin amacını ve otokodlayıcıların uygulamalarını merak ediyor olabilirsiniz.

<!--At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders.-->

Otokodlayıcıların ana kullanım alanları aykırılık tespiti ve resim arıtma. Otokodlayıcının görevinin veriyi manifoldun (verdiğimiz veri manifoldu) üzerinde yeniden oluşturmak olduğunu biliyoruz. Otokodlayıcımızın sadece manifold üzerindeki girdileri üretebilmesini istiyoruz. Bu yüzden modeli eğitim sırasında gördüklerini üretecek şekilde sınırlandırıyoruz, böylece yeni girdilerde bulunan farklılıklar silinecek çünkü model böyle değişikliklere karşı duyarsız.

<!--The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold i.e. given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations.-->

Otokodlayıcıların başka bir uygulaması da görüntü sıkıştırma. Eğer ara katman boyutumuz $d$ girdi boyutumuz $n$'den daha küçükse, kodlayıcı sıkıştırıcı olarak kullanılır ve saklı (kodlanmış) gösterim girdinin büyün (veya çoğu) özelliğini tutarken daha az yer kaplayacak.

<!--Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space.-->


## Yeniden oluşturma kaybı

<!--## Reconstruction loss-->

Şimdi de genelde kullanılan yeniden oluşturma kayıp fonksiyonlarına bakalım. Veri kümesinin tamamının kaybı örnek başına kaybın ortalamasına eşit. Yani

<!--Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e.-->

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

Girdimiz kategorilendirildiyse, Çapraz Entropi kaybını kullanarak örnek başına kaybı şu şekilde hesaplayabiliriz:

<!--When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by-->

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

Ve girdi reel bir değer olduğunda, Ortalama Karesel Hata Kaybını kullanabiliriz:

<!--And when the input is real-valued, we may want to use the Mean Squared Error Loss given by-->

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$


## Az ve çok doldurulmuş saklı katman

<!--## Under-/over-complete hidden layer-->

Saklı katmanın boyutu $d$ girdinin boyunu $n$'den küçük olduğu zaman, buna az doldurulmuş saklı katman diyoruz. Benzer şekilde, $d>n$ olduğunda, çok doldurulmuş saklı katman diyoruz. Fig. 14 solda az doldurulmuş, sağda da çok doldurulmuş bir saklı katman gösteriyor. 

<!--When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: Az doldurulmuş ve çok doldurulmuş saklı katmanlar<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: An under-complete vs an over-complete hidden layer<br>
</center>-->

Yukarıda tartıştığımız gibi, az doldurulmuş bir saklı katman sıkıştırma için kullanılabilir, çünkü girdideki bilgiyi daha az boyuta kodluyoruz. Diğer tarafta, çok doldurulmuş bir katmanda girdiden daha çok boyutlu bir kodlama yapıyoruz. Bu da optimizasyonu kolaylaştırıyor.

<!--As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier.-->

Girdiyi yeniden oluşturduğumuz için, model girdi özelliklerinin hepsini saklı katmana kopyalayıp bunları çıktıya taşıyarak birim fonksiyon olarak çalışmaya yatkın. Bu modelimizin herhangi bir şeyi öğrenmesini engelleyeceği için bundan kaçınılmalı. Bu yüzden bir bilgi darboğazı kullanarak bazı ekstra kısıtlamalar getirmeliyiz. Bunu saklı katmanı sadece eğitim sırasında görülen değerlerle kısıtlayarak yapıyoruz. Bu seçici yeniden oluşturmayı (girdi uzayının bir alt kümesiyle sınırlı) sağlayıp modeli manifoldun üzerinde olmayan her şeye karşı duyarsız yapıyor.

<!--Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction (limited to a subset of the input space) and makes the model insensitive to everything not in the manifold.-->

Az doldurulmuş bir katmanın girdiyi kopyalayacak yeterince boyutu olmadığı için birim fonksiyon olarak davranamayacağına dikkat etmeliyiz. Bundan dolayı az doldurulmuş bir saklı katmanın aşırı öğrenmesi çok doldurulmuş bir saklı katmana göre daha az muhtemel, ancak yine de mümkün. Örneğin güçlü bir kodlayıcı ve kodçözücü verildiğinde, model her veri noktasına bir sayıyla eşleştirip fonksiyonu öğrenebilir. Aşırı öğrenmeyi engellemek için düzenlileştirme, mimari yöntemler, vb. kullanabiliriz.

<!--It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc.-->


## Arıtan otokodlayıcı

<!--## Denoising autoencoder-->

Fig. 15 bir arıtan otokodlayıcının manifoldunu gösterip nasıl çalıştığı hakkında bir sezgi sahibi olmamızı sağlıyor.

<!--Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Arıtan otokodlayıcı<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Denoising autoencoder<br>
</center>-->

Bu modelde, gerçekte göreceğimiz gürültülü dağılımı verdiğimizi varsayıyoruz, böylece ondan nasıl güçlü bir şekilde düzelteceğimizi öğrenebiliriz.
Girdi ve çıktıyı karşılaştırarak manifoldun üzerindeki noktaların hareket etmediğini, manifolddan uzakta olan noktalarınsa çok hareket ettiğini söyleyebiliriz.

<!--In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it.
By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot.-->

Fig. 16 girdi ve çıktı verisi arasındaki ilişkiyi gösteriyor.

<!--Fig.16 gives the relationship between the input data and output data.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Arıtan otokodlayıcının girdi ve çıktısı<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Input and output of denoising autoencoder<br>
</center>-->

Fig. 17'de olduğu gibi her girdinin hareketinin mesafesini göstermek için farklı renkler kullanabiliriz.

<!--We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Girdi verisinin hareket mesafesinin ölçülmesi<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Measuring the traveling distance of the input data<br>
</center>-->

Renk açıldıkça, noktanın hareket mesafesi uzuyor. Şekilden köşelerdeki noktalarin 1 birime yakın hareket ettiğini, iki kol arasındaki noktalarınsa eğitim sırasında üst ve alt kollar tarafından çekildiği için hareket etmediğini söyleyebiliriz.

<!--The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process.-->


## Daraltan otokodlayıcı

<!--## Contractive autoencoder-->

Fig. 18 daraltan otokodlayıcının kayıp fonksiyonunu ve manifoldu gösteriyor.

<!--Fig.18 shows the loss function of the contractive autoencoder and the manifold.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Daraltan otokodlayıcı <br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Contractive autoencoder <br>
</center>-->

Kayıp fonksiyonu yeniden oluşturma terimi artı saklı gösterimin girdiye göre gradyanının uzunluğunun karesini içeriyor. Bu yüzden genel kayıp girdinin değişkenliğine göre saklı katmanın değişkenliğini minimize edecek. Bunun faydası modelin yeniden oluşturma yönlerine duyarlıyken diğer olası yönlere duyarsız olması.

<!--The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions.-->

Fig. 19 otokodlayıcıların genel olarak nasıl çalıştığını gösteriyor.

<!--Fig.19 shows how these autoencoders work in general.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basit otokodlayıcı <br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basic autoencoder <br>
</center>-->

Eğitim manifoldu üç boyutta ilerleyen tek boyutlu bir obje. $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$ ve $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$ iken, otokodlayıcının hedefi kıvrımlı çizgiyi bir yönde uzatmak. Bunun bir sonucu olarak girdi katmanındaki bir nokta saklı katmandaki bir noktaya dönüştürülecek. Şimdi girdi uzayı ve saklı uzaydaki noktalar arasında bağıntımız var, ancak girdi uzayı ve saklı uzay bölgeleri arasında bir bağıntımız yok. Daha sonra, kodçözücüyü saklı saklı katmandaki bir noktadan anlamlı bir çıktı katmanı oluşturması için kullanacağız.

<!--The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, the goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondence between points in the input space and the points on the latent space but do not have the correspondence between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer.-->


## [Otokodlayıcının uygulanması - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

<!--## [Implement autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)-->

Jupyter notebook [burada](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb) bulunabilir.

<!--The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).-->

Bu çalışmada, standart bir otokodlayıcı ve bir arıtan otokodlayıcıyı yazıp çıktılarını karşılaştıracağız.

<!--In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs.-->


### Otokodlayıcı model mimarisi ve yeniden oluşturma kaybının tanımlanması

<!--### Define autoencoder model architecture and reconstruction loss-->

$28 \times 28$'lik resim ve 30 boyutlu saklı katman kullanıyoruz. Dönüşüm süreci $784\to30\to784$ şeklinde. Hiperbolik tanjant fonksiyonunu kodlayıcıya ve kodçözücüye uygulayarak, çıktının görüntü kümesini $(-1, 1)$'e sınırlandırmış oluyoruz. Ortalama Karesel Hata (MSE) bu modelin kayıp fonksiyonu olarak kullanılacak.

<!--Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model.-->

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```


### Standart otokodlayıcının eğitimi

<!--### Train standard autoencoder-->

PyTorch kullanarak standart otokodlayıcıyı eğitmek için sıradaki 5 fonksiyonu eğitim döngüsüne koymalısınız:

<!--To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop:-->


#### İleri gidiş:

<!--#### Going forward:-->

1) Girdiyi resmini `output = model(img)`'ı çağırarak modele göndermek. <br>
2) `criterion(output, img.data)` kullanarak kaybı hesaplamak

<!--1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`.-->


#### Geri gidiş:

<!--#### Going backward:-->

3) `optimizer.zero_grad()` ile gradyanı sıfırlayıp değerin toplanmasını önlemek. <br>
4) `loss.backward()` kullanarak geri yayılım <br>
5) `optimizer.step()` kullanarak geri adım

<!--3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()`-->

Fig. 20 standart otokodlayıcının çıktısını gösteriyor.

<!--Fig. 20 shows the output of the standard autoencoder.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Standart otokodlayıcının çıktısı <br>
</center>
<br/>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Output of standard autoencoder <br>
</center>
<br/>-->


### Arıtan otokodlayıcının eğitimi

<!--### Train denoising autoencoder-->

Arıtan otokodlayıcı için aşağıdaki adımları eklemelisiniz:<br>
1) `nn.Dropout()` kullanarak rastgele nöronları kapatmak. <br>
2) `do(torch.ones(img.shape))` kullanarak gürültü maskesi yaratmak.<br>
3) İyi resimleri ikili maskeler `img_bad = (img * noise).to(device)` ile çarparak kötü resimler yaratmak.

<!--For denoising autoencoder, you need to add the following steps:<br>
1) Calling `nn.Dropout()` to randomly turning off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binary masks: `img_bad = (img * noise).to(device)`.-->

Fig. 21 arıtan otokodlayıcının çıktısını gösteriyor.

<!--Fig. 21 shows the output of the denoising autoencoder.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Arıtan otokodlayıcının çıktısı <br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Output of denoising autoencoder <br>
</center>-->


### Çekirdeklerin karşılaştırılması

<!--### Kernels comparison-->

Dikkat etmemiz gereken bir şey girdinin boyutunun $28 \times 28 = 784$ ve saklı katmanın boyutunun 500 olmasına rağmen, siyah piksellerin sayısından dolayı model hala çok doldurulmuş bir katmana sahip. Aşağıdaki örnekler az doldurulmuş standart bir otokodlayıcıda kullanılan çekirdeklerin örnekleri. Açık bir şekilde sayıların bulunduğu bölgedeki pikseller bir çeşit örüntünün keşfedildiğini gösterirken, bu bölgenin dışındaki pikseller rastgele. Bu da standart otokodlayıcının sayının bulunduğu bölge dışındaki piksellerle ilgilenmediğini gösteriyor.

<!--It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image.
Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standart otokodlayıcı çekirdekleri.
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standard AE kernels.
</center>-->

Diğer bir tarafta da, aynı veri iletim sönümünün her görüntüye modeli eğitmeden önce uygulandığı arıtan otokodlayıcıya verildiğinde farklı bir şey oluyor. Her çekirdek sayının bulunduğu bölgenin dışındaki pikselleri sabit bir değere eşitliyor. İletim sönümü uygulandığı için model artık sayının bulunduğu bölgenin dışındaki pikselleri de önemsiyor.

<!--On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Arıtan otokodlayıcı çekirdekleri.
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Denoising AE kernels.
</center>-->

En gelişmiş yöntemlerle karşılaştırdığımızda aslında bizim otokodlayıcımız daha başarılı!! Sonuçları aşağıda görebilirsiniz.

<!--Compared to the state of the art, our autoencoder actually does better!! You can see the results below.-->


<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Girdi verisi (MNIST rakamları).
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Input data (MNIST digits).
</center>-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Arıtan otokodlayıcının yeniden oluşturdukları.
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Denoising AE reconstructions.
</center>-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea renklendirme çıktısı.
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea inpainting output.
</center>-->

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Navier-Stokes renklendirme çıktısı.
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Navier-Stokes inpainting output.
</center>-->
