---
lang-ref: ch.07-2
lang: tr
lecturer: Yann LeCun
title: Örnekler ve Detaylarla SSL ve EBM
authors: Ravi Choudhary， B V Nithish Addepalli, Syed Rahman，Jiayi Du
date: 9 Mar 2020
translation-date: 17 Jul 2020
translator: yavuzdrmzksr
---

## [Özdenetimli Öğrenme](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

Özdenetimli Öğrenme (SSL) hem denetimli hem de denetimsiz öğrenmeyi kapsıyor. SSL'nin amacı girdinin iyi bir gösterimini öğrenmek, böylece daha sonra bunu denetimli görevlerde kullanılabilir. SSL'de model verinin bir kısmını tahmin etmek için geri kalan veriyi kullanarak eğitiliyor. Örneğin, BERT SSL yöntemleri kullanılarak eğitildi ve Arıtan Otokodlayıcı (DAE) bize Doğal Dil İşlemedeki (NLP) en gelişmiş sonuçları veriyor.

<!--## [Self supervised learning](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)

Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning. The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-Encoder (DAE) has particularly shown state-of-the-art results in Natural Language Processing (NLP).-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Özdenetimli Öğrenme
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Self Supervised Learning
</center>-->

Özdenetimli Öğrenme görevleri şunlarla tanımlanabilir:
* Geçmişi kullanarak geleceği tahmin etmek
* Görünenleri kullanarak gizli olanları tahmin etmek
* Elimizdeki her şeyi kullanarak ulaşamadığımız kısımları tahmin etmek

<!--Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts.-->

Örneğin, eğer bir sistem kamera hareket ettiğindeki yeni kareyi tahmin etmek için eğitildiyse, sistem dolaylı olarak derinliği ve ıraklık açısını öğrenecek. Bu da sistemi görüşünde bulunmayan objelerin yok olmadığını, hareketli, hareketsiz nesneler ve arkaplan arasındaki farkı öğrenmeye zorlayacak. Bu sayede yerçekimi gibi fizik hakkında sezgilere de sahip olabilir.

<!--For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity.-->

En gelişmiş NLP sistemleri (BERT) dev bir sinir ağını bir SSL göreviyle öneğitiyor. Cümleden bazı kelimeleri çıkarıp sistemin eksik kelimeleri tahmin etmesini istiyorsunuz. Bu çok başarılı oldu. Benzer fikirler bilgisayarlı görü dünyasında da denendi. Aşağıdaki resimde gösterildiği gibi, resmin bir kısmını çıkarıp modeli eksik parçayı tahmin etmesi için eğitebilirsiniz. 

<!--State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Bilgisayarlı görüdeki eş sonuçlar
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Corresponding results in computer vision
</center>-->

Modeller eksik kısmı doldurabilse de, NLP sistemleri kadar başarılı değiller. Eğer bu modeller tarafından oluşturulan iç gösterimleri alıp bir bilgisayarlı görü sistemine girdi olarak verirseniz, ImageNet kullanılarak denetimli bir şekilde öneğitilen sistemden daha başarısız oluyor. Buradaki fark NLP ayrık iken resimlerin sürekli olması. Başarıdaki farkın sebebi ise, ayrık durumda belirsizliği nasıl göstereceğimizi biliyorken (muhtemel çıktılar üzerinde büyük bir softmax kullanabiliriz), sürekli durumda nasıl yapacağımızı bilmiyoruz.

<!--Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continuous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not.-->

Zeki bir sistemin karar vermek için hareketlerinin çevresinde ve kendisine nasıl sonuçları olacağını tahmin etmesi gerekiyor. Dünya tamamen deterministik olmadığı ve makinede/insan beyninde her ihtimali hesaplayacak işlem gücü olmadığı için, yapay zeka sistemlerine belirsizlik durumunda yüksek boyutlu uzaylarda tahmin etmeyi öğretmemiz gerekiyor. Enerji temelli modeller (EBMler) bu iş için oldukça faydalı olabilir.

<!--An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models (EBMs) can be extremely useful for this.-->

En küçük kareler kullanılarak videonun sıradaki karesini tahmin etmek için eğitilen bir sinir ağının ürettiği kareler bulanık resimler olacak, çünkü model geleceği tam olarak tahmin edemiyor, kaybı azaltmak için tüm olası yeni karelerin ortalamasını alıyor.

<!--A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss.-->


### Yeni karenin tahminini yapabilmek için saklı değişkenli enerji temelli modelleri kullanmak:

<!--### Latent variable energy-based models as a solution to make predictions for next frame:-->

Doğrusal bağlanımdan farklı olarak, saklı değişkenli enerji temelli modeller dünya hakkında bildiklerimizin yanında gerçekte ne olduğu hakkında bilgi veren saklı bir değişken de alıyor. Bu iki bilginin birleşimi gerçeğe daha yakın bir tahmin için kullanılabilir.

<!--Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs.-->

Bu modeller girdi $x$ ve gerçek çıktı $y$ arasındaki uyumluluğu sistemin enerjisini en aza indiren saklı değişkene bağlı olarak değerlendiren sistemler olarak düşünülebilir. Girdi $x$'i gözlemleyip girdinin ve saklı değişkenler $z$'nin farklı kombinasyonları ile muhtemel tahminler olan $\bar{y}$'leri üretip enerjiyi, tahmin hatasını en aza indireni seçiyoruz.

<!--These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$ for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system.-->

Çizdiğimiz saklı değişkene bağlı olarak, tüm muhtemel tahminlere sahip olabiliriz. Saklı değişken girdi $x$'te bulunmayan çıktı $y$'nin önemli bir bilgisi olarak düşünülebilir.

<!--Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$.-->

Skaler değerli enerji fonksiyonunun iki versiyonu bulunmakta:
1. Koşullu $F(x, y)$ - $x$ ve $y$ arasındaki uyumluluğu ölçmek
2. Koşulsuz $F(y)$   - $y$'nin bileşenleri arasındaki uyumluluğu ölçmek

<!--Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$-->


## Bir Enerji Temelli Modeli Eğitmek

<!--## [Training an Energy-Based Model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)-->

$F(x, y)$'yi parametrize etmek için Enerji Temelli Model eğitmenin iki ayrı türü bulunmakta.
1. **Karşılaştırmalı yöntemler:** $F(x[i], y[i])$'de düşürüp, diğer $F(x[i], y')$'lerde yükseltmek
2. **Mimari yöntemler:** Düzenlileştirme ile $F(x, y)$'yi düşük enerjili bölgeler sınırlı veya minimum olacak şekilde oluşturmak

<!--There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $F(x, y)$ so that the volume of low energy regions is limited or minimized through regularization-->

Enerji fonksiyonunu şekillendirmek için yedi farklı strateji var. Karşılaştırmalı yöntemler yükseltecekleri noktaları seçmede farklılık gösteriyor. Mimari yöntemler ise kodun bilgisinin kapasitesini sınırlandırdığı yöntemler ile farklılık gösteriyor.

<!--There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the way they limit the information capacity of the code.-->

Karşılaştırmalı yöntemlerden biri En Büyük Olabilirlik öğrenmesi. Enerji normalize edilmemiş negatif log yoğunluğu olarak yorumlanabilir. Gibbs dağılımı bize verilen $x$'e göre $y$'nin olabilirliğini veriyor. Şu şekilde formülleştirilebilir:

<!--An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalised negative log density. Gibbs distribution gives us the likelihood of $y$ given $x$. It can be formulated as follows:-->

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

En Büyük Olabilirlik, olabilirliği maksimuma çıkarmak için payı büyütüp paydayı küçültüyor. Bu, aşağıdaki gibi $-\log(P(Y \mid W))$'yi minimize etmeye eşdeğer.

<!--Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below-->

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\log\int_{y}e^{-\beta E(y,W)}
$$

Bir Y örneği için negatif log olabilirlik kaybının gradyanı aşağıdaki gibi:

<!--Gradient of the negative log likelihood loss for one sample Y is as follows:-->

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

Yukarıdaki gradyanda, gradyanın ilk terimi veri noktamız $Y$'deki, ve ikinci terimi tüm $Y$'lerdeki beklenti değerini veriyor. Bundan dolayı, gradyan inişi yaptığımızda, ilk terim veri noktamız $Y$'deki enerjiyi düşürmeye çalışırken ikinci terim diğer tüm $Y$'lerdeki enerjiyi arttırmaya çalışıyor.

<!--In the above gradient, the first term of the gradient at the data point $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy over all $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the data point $Y$ and the second term tries to increase the energy given to all other $Y$s.-->

Enerji fonksiyonunun gradyanı genellikle çok karmaşık, bu yüzden integrali hesaplamak, tahmin etmek veya integrale yaklaşmak genelde zorlu olduğu için çok ilgi çekicidir.

<!--The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases.-->


## Saklı değişkenli enerji temelli model

<!--## [Latent variable energy-based model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)-->

Saklı değişkenli modellerin asıl avantajı, saklı değişken sayesinde çok sayıda tahmini mümkün kılmaktır. $z$ küme üzerinde değiştikçe, $y$ olası tahminlerin manifoldu üzerinde değişiyor. Bazı örnekler:
1. K-ortalama
2. Seyrek modelleme
3. [GLO](https://arxiv.org/abs/1707.05776)

<!--The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ varies over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modelling
3. [GLO](https://arxiv.org/abs/1707.05776)-->

Bunlar iki tür olabilir:
1. $y$'nin $x$'e bağlı olduğu koşullu modeller
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. $y$'nin bileşenleri arasındaki uyumluluğu ölçen $F(y)$ skaler enerji fonksiyonu olan koşulsuz modeller
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<!--These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, $F(y)$ that measures the compatibility between the components of $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Saklı Değişkenli EBM
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Latent Variable EBM
</center>-->


## Saklı değişkenli EBM örneği: $K$-ortalama

<!--## Latent variable EBM example: $K$-means-->

K-ortalama $y$ üzerindeki dağılımı modellemeye çalıştığımız bir enerji temelli model olarak düşünülebilecek basit bir kümeleme algoritmasıdır.

<!--K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-ortalama örneği
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-means example
</center>-->

Verilen $y$ ve $k$ değerini kullanarak, $W$'nun $k$ adet muhtemel sütunundan hangisinin yeniden üretme hatası veya enerji fonksiyonunu minimize ettiğini bulup çıkarım yapabiliriz. Algoritmayı eğitmek için yaklaşımımız $W$'nun $y$'ye en yakın sütununu seçmek için $z$'yi bulup daha sonra daha da yaklaşmak için gradyan adımı atıp işlemi tekrar edebiliriz. Ancak, koordinat gradyan inişi aslında daha iyi ve daha hızlı çalışıyor.

<!--Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster.-->

Aşağıdaki grafikte, pembe sarmal üzerinde veri noktalarını görebiliriz. Bu çizgiyi çevreleyen siyah damla, $W$'nun prototiplerinin etrafındaki ikinci dereceden düşüşlere karşılık geliyor.

<!--In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of $W$.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Sarmal grafik
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Spiral plot
</center>-->

Enerji fonksiyonunu öğrendiğimizde aşağıdaki soruları ele almaya başlayabiliriz:
1. $y_1$ noktası verildiğinde $y_2$ noktasını tahmin edebilir miyiz?
2. $y$ verildiğinde, veri manifoldundaki en yakın noktayı bulabilir miyiz?

<!--Once we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold?-->

K-ortalama bir mimari yöntemdir (karşılaştırmalı yöntemlerden farklı). Yani enerjiyi herhangi bir yerde yükseltmiyoruz, tek yaptığımız enerjiyi belli bölgelerde düşürmek. Bunun bir dezavantajı $k$ değerine karar verdikten sonra, sadece $k$ adet noktada 0 enerjiye sahip olabiliriz ve bu noktalardan uzaklaştıkça karesel bir oranda artacak.

<!--K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them.-->


## Karşılaştırmalı yöntemler

<!--## Contrastive methods-->

Dr Yann LeCun'a göre, herkes bir noktada mimari yöntemleri kullanacak, ama şu an resimler üzerinde karşılaştırmalı yöntemler daha iyi çalışıyor. Bazı veri noktalarını ve enerji yüzeyinin eşyükselti eğrilerini gösteren aşağıdaki şekle bakın. İdeal olarak, enerji yüzeyinin en düşük enerjiye veri manifoldu üzerinde sahip olmasını isteriz. Böylece yapmak istediğimiz şey, eğitim örneğinin etrafında enerjiyi (yani $F(x,y)$ değerini) düşürmek, ama bu tek başına yeterli olmayabilir. Bu yüzden yüksek enerjiye sahip olması gereken ama düşük enerjiye sahip olan $y$'lerde de yükseltiyoruz.

<!--According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (i.e. the value of $F(x,y)$) around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Karşılaştırmalı yöntemler
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Contrastive methods
</center>-->

Enerjiyi yükseltmek istediğimiz $y$'leri bulmak için birkaç farklı yol var. Bazı örnekler:
1. Arıtan Otokodlayıcı
2. Karşıtsal Iraksama
3. Monte Carlo
4. Markov Zincirli Monte Carlo
5. Hamiltonian Monte Carlo

<!--There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo-->

Arıtan otokodlayıcı ve karşıtsal ıraksama hakkında kısaca tartışacağız.

<!--We will briefly discuss denoising autoencoders and contrastive divergence.-->


### Arıtan otokodlayıcı (DAE)

<!--### Denoising autoencoder (DAE)-->

Enerjiyi arttıracağımız $y$'leri bulmanın bir yolu, aşağıdaki grafikte yeşil oklarla gösterildiği gibi eğitim örneğini rastgele bozmaktır.

<!--One way of finding $y$'s to increase energy for it is by randomly perturbing the training example as shown by the green arrows in the plot below.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topografik harita
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topographic map
</center>-->

Veri noktasını bozduktan sonra, enerjiyi burada yükseltebiliriz. Eğer bunu her veri noktası için yeterince kez yaparsak, enerji eğitim örneklerinin yanında bükülecek. Aşağıdaki grafik eğitimin nasıl yapıldığını gösteriyor.

<!--Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Eğitim
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Training
</center>-->

Eğitim adımları:
1. $y$ noktasını al ve onu boz
2. Kodlayıcı ve Kodçözücüyü bozulmuş veri noktasından orijinal veri noktasını oluşturacak şekilde eğit

<!--Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point-->

Eğer DAE düzgün bir şekilde eğitilirse, enerji veri manifoldundan uzaklaştıkça karesel bir şekilde büyüyecek.

<!--If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold.-->

Aşağıdaki grafik DAE'yi nasıl kullandığımızı gösteriyor.

<!--The following plot illustrates how we use the DAE.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: DAE nasıl kullanılır
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: How DAE is used
</center>-->


### BERT

<!--### BERT-->

BERT benzer bir şekilde eğitiliyor, ancak bu sefer uzay ayrık ve metinle uğraşıyoruz. Bozma tekniğiyle bazı kelimeleri gizleyip, yeniden oluşturma adımında bunları tahmin etmeye çalışıyoruz. Bundan dolayı bu yöntemin başka bir adı da gizli otokodlayıcı.

<!--BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstruction step consists of trying to predict these. Hence, this is also called a masked autoencoder.-->


### Karşıtsal Iraksama

<!--### Contrastive divergence-->

Karşıtsal ıraksama bize enerjiyi yükselteceğimiz $y$ noktalarını bulmak için daha akıllıca bir yöntem sunuyor. Eğitim noktamıza rastgele bir vuruş yapıp gradyan inişiyle enerji fonksiyonunda aşağı inebiliriz. Yolun sonunda geldiğimiz noktada enerjiyi yükseltiyoruz. Bu aşağıdaki grafikte yeşil çizgiyle gösteriliyor.

<!--Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line.-->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Karşıtsal Iraksama
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Contrastive Divergence
</center>-->
