---
lang-ref: ch.07-1
lang: tr
title: Enerji Temelli Modeller
authors: Karanbir Singh Chahal，Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
lang: turkish
translation-date: 18 Jun 2020
translator: Berkay Silsupur

---


<!--## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)-->

<!--We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:
1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities.-->

## [Genel Bakış](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)

Modelleri tanımlamak için yeni bir çatı tanıtacağız. Bu çatı; denetimli, denetimsiz ve özdenetimli modelleri tanımlaya yardımcı olacak birleştirici bir şemsiye görevi görecek. Enerji temelli modeller bir $x$ değişkenler grubunu gözlemler ve bir $y$ değişkenler grubunu çıktı verir. İleri beslemeli ağlarda 2 büyük sorun var:
1.	Çıkarsama yordamı, ağırlıklı toplamların yığılmış katmanlarından daha karmaşık bir hesaplama ise ne olur?
2.	Tek bir girdi için birden çok olası çıktı varsa ne olur? Örnek: Videonun gelecek çerçevelerini öngörmek. Temel olarak bir sınıflandırma ağında, bu ağı her sınıf için bir puan verecek şekilde eğitiyoruz. Bununla beraber, görüntüler gibi yüksek boyutlu bir tanım alanında bunu yapmak mümkün değildir. (Görüntüler üzerine eşiksiz en büyük koyulamaz!). Çıktı kesikli olsa bile, geniş bir örneklem uzayına sahip olabilir. Örneğin, metnin bileşimsel olması çok sayıda olası kombinasyona yol açar. Enerji temelli modeller, bu yöntemleri modellemek için daha iyi bir çatı sağlar.

<!--## EBM approach

Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:

- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`?-->


<!-- This method of inference by minimizing a function and a large class of models work this way. By minimizing $f(x,y)$ or "energy". Hence, we perform inference by minimizing constraints where these constraints are represented by $f(x,y)$. We shall call $f(x,y)$ the "Energy function" from henceforth.
 -->

## EBM yaklaşımı

$x$’leri $y$’lere sınıflandırmaya çalışmak yerine, belirli bir ($x$, $y$) çiftinin birbirine uyup uymadığını tahmin etmek istiyoruz. Ya da başka bir deyişle, $x$ ile uyumlu bir $y$ bulun. Sorunu, düşük olan bazı $F($x$, $y$)$’ler için bir y bulma olarak da ortaya koyabiliriz. Örnek olarak:

- $Y$, $x$’in doğru yüksek çözünürlüklü görüntüsü mü?
- `A` metni, `B` metninin iyi bir çevirisi mi?

Yorum: Bir fonksiyonu en aza indirdiğimiz bu çıkarsama yöntemi ve geniş bir modeller sınıfı bu şekilde işler. $f(x,y)$'yi veya "enerji"'yi en aza indirerek. Bu nedenle, çıkarsama yöntemini $f(x,y)$ ile gösterilen kısıtlamaları en aza indirerek uyguluyoruz. Bundan böyle $f(x,y)$'ye "Enerji fonksiyonu" diyoruz.

<!--### Definition

We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation:

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$


### Solution: gradient-based inference

We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.

**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring. -->

<!-- There are a type of Energy Based Models that are quite popular. These are
 -->

### Tanım

$F(x,y)$'nin $(x,y)$ çiftleri arasındaki bağımlılık seviyesini belirteceği şekilde bir enerji fonksiyonu $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ tanımlarız. (Bu enerjinin öğrenmede değil, çıkarsamada kullanıldığını dikkate alın.) Çıkarsama, aşağıdaki denklemle ifade edilebilir:
$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$

### Çözüm: gradyan temelli çıkarsama
Enerji fonksiyonunun pürüzsüz ve türevlenebilir olmasını istiyoruz, böylece fonksiyonu çıkarsama için gradyan temelli yöntemleri uygulama amacıyla kullanabiliriz. Çıkarsamayı uygularken, uyumlu $y$’leri bulmak için gradyan inişini kullanarak bu fonksiyonu ararız. En düşük değeri elde etmek için gradyan yöntemlere alternatif birçok yöntem mevcuttur.

**Öte yandan:** Grafik modeller, Enerji temelli modellerin özel bir halidir. Enerji fonksiyonu, enerji terimlerinin bir toplamı olarak ayrışır. Her enerji terimi, ilgilendiğimiz değişkenlerin bir alt kümesini dikkate alır. Belirli bir şekilde düzenlendikleri takdirde, çıkarsamasıyla ilgilendiğimiz değişkene göre terimlerin toplamının en düşük değerini bulmak için etkili çıkarım algoritmaları mevcuttur.

<!--## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (e.g. French). Hence, having this latent variable in our model will be very useful to interpret such an input.-->

## [Saklı Değişkenler ile EBM](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)

$Y$ çıktısı, $x$ ve değerini bilmediğimiz ilave bir değişken olan $z$’ye (saklı değişken) bağlıdır. Bu saklı değişkenler yardımcı bilgi sağlayabilir. Örneğin, saklı bir değişken size bir metin parçasındaki kelime sınırlarının konumlarını işaret edebilir. Bu bize el yazısını boşluk bırakmadan yorumlama konusunda yardımcı olabilir. Bunun bilinmesi, deşifre edilmesi zor boşluklara sahip olan konuşmalar konusunda da yarar sağlayacaktır. Ek olarak, bazı diller çok zayıf sözcük sınırlarına sahiptir (örn. Fransızca). Bu nedenle, modelimizde bu saklı değişkenin bulunması, böyle bir girdiyi yorumlamak için çok yararlı olacaktır. 

<!--### Inference

To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$.

<!--  ## Latent-Variable EBM -->
<!--Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

This allows a machine to produce multiple outputs, not just one. 

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Computation graph for Energy-based models
</center>
-->

### Çıkarım

EBM gizli değişkeniyle çıkarsama yapmak için, $y$ ve $z$’ye göre aynı anda enerji fonksiyonunu en aza indirmek istiyoruz.

$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$

Bu da enerji fonksiyonunu şu şekilde yeniden tanımlamakla eşdeğerdir: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, bu da eşittir: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$. $\beta \rightarrow \infty$ iken $\check{y} = \text{argmin}_{y}F(x,y)$ olur.

## Saklı Değişkenli EBM

Saklı değişkenlerin bir başka büyük avantajı da, saklı değişkeni bir küme üzerinde değiştirerek, $y$ tahmin çıktısını olası tahminlerin manifoldu üzerinde de değiştirebilmemizdir (şerit aşağıdaki grafikte gösterilmiştir): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

Bu, makinenin sadece bir değil, birden çok çıktı üretmesine olanak sağlar.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Enerji Temelli Modeller için hesaplamalı çizge
</center>

<!--### Examples

One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.

Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced.-->

### Örnekler

Video tahmini bir örnek olarak verilebilir. Video tahminini kullanmamız için birçok iyi uygulama var, örneğin bir video sıkıştırma sistemi yapmak. Veya, kendi kendine giden bir arabanın videosunu kullanarak diğer arabaların ne yapacağını tahmin etmek de bir örnek olabilir. Bir başka örnek olarak da tercüme verilebilir. Bir metin parçası için bir dilden diğerine tek bir doğru çeviri olmadığından dil çevirisi her zaman zorlu bir sorun olmuştur. Genellikle, aynı fikri ifade etmenin birçok farklı yolu vardır ve insanlar neden bir yolu diğerine tercih ettiklerini muhakeme etmekte zorlanırlar. Bu nedenle, bir sistemin verilen bir metne yanıt olarak üretebileceği tüm olası tercümeleri parametreleştirmenin bir yoluna sahip olmak iyi olabilir. Diyelim ki Almanca’dan İngilizce’ye tercüme yapmak istiyoruz, İngilizce’de hepsi doğru olan birden fazla tercüme olabilir ve bazı saklı değişkenleri değiştirerek üretilen tercümeyi de değiştirebiliriz.

<!--## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is:

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy)-->

## [Enerji temelli modeller vs olasılıksal modeller](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)

Enerjilere normalize edilmemiş negatif log olasılıkları olarak bakabilir ve normalleştirmeden sonra enerjiden olasılığa geçiş için Gibbs-Boltzmann dağılımını şu şekilde kullanabiliriz: 

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

Bu denklemde $\beta$ pozitif sabittir ve modelinize uyacak şekilde ayarlanması gerekir. $\beta$ değeri arttıkça modelin dalgalanması artarken, $\beta$ değerinin azalmasıyla model daha pürüzsüz bi hal alır. (Fizikte $\beta$ sıcaklığın tersidir: $\beta \rightarrow \infty$ sıcaklığın sıfıra gittiği anlamına gelir).

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

$Y$ üzerinde tümleştirirsek: $P(y \mid x) = \int_z P(y,z \mid x)$, şu denklemi elde ederiz:

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

Bu nedenle, bir saklı değişken modelimiz varsa ve saklı değişken $z$’yi olasılıksal olarak doğru bir şekilde ortadan kaldırmak istiyorsak, tek yapmamız gereken enerji fonksiyonu $F_\beta$’yi yeniden tanımlamaktır.


<!--### Free Energy

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done.

Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy.-->

### Serbest Enerji

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

Bunu hesaplamak muhtemelen çoğu durumda baş edilmesi çok zor bir sorun olacaktır. Dolayısıyla, modelinizde en aza indirmek istediğiniz veya tümleştirmeye çalıştığınız (Enerji fonksiyonu $F$’yi  yeniden tanımlayarak) saklı bir değişkeniniz varsa, ve en aza indirmek yukarıdaki formülde $\beta$’nın sonsuz limitine karşılık geliyorsa, o zaman yapılabilir. Yukarıdaki $F_\beta(x, y)$ tanımı göz önüne alındığında, $P(y \mid x)$'nin yalnızca Gibbs-Boltzmann formülünün bir uygulaması olduğu söylenebilir, ve $z$ de bunun içerisinde dolaylı bir şekilde tümleştirilmiştir. Fizikçiler buna ‘Serbest Enerji’ dediğinden biz de $F$ diyoruz. Yani $e$ enerji, $F$ ise serbest enerjidir.

<!--***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.***

The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, may more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use maximum likelihood -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualization of the energy function that captures dependency between x and y
</center>
-->

***Soru: Enerji temelli modellerin sağladığı avantajları detaylandırabilir misiniz? Olasılık temelli modeller, üzerinde tümleştirme yapılabilen saklı değişkenler de içerebilir.

Olasılıksal modellerdeki fark, en aza indireceğiniz nesne fonksiyonunu seçme şansınızın olmamasıdır. Aynı zamanda manipüle ettiğiniz her nesnenin bir normalleştirilmiş dağılım olması gerektiğinden, olasılıksal çatıya sadık kalmanız gerekir (değişimli yöntemler vb. kullanılarak yaklaşımlanabilir). Burada, nihayetinde bu modellerle yapmak istenen şeyin karar vermek olduğunu söyleyebiliriz. Araba sürebilen bir sistem kurduysanız ve sistem size “0.8 ihtimalle sola veya 0.2 ihtimalle sağa dön” derse, sola döneceksiniz. Olasılıkların 0.2 ve 0.8 olduğu gerçeği önemsizdir. Yapmak istediğiniz şey en iyi kararı vermektir, çünkü bir karar vermek zorundasınız. Bu yüzden olasılıklar karar vermede işe yaramaz. Otomatik bir sistemin çıktısını başka bir sisteminkiyle bir araya getirmek isterseniz (örneğin bir insan, veya başka bir sistem), ve bu sistemler beraber değil, aksine ayrı ayrı eğitilmişse, o zaman ihtiyacınız olan şey iyi bir karar verebilmek için iki sistemin kalibre edilmiş puanlarını birleştirmektir. Puanları kalibre etmenin tek yolu, onları olasılığa dönüştürmektir. Diğer tüm yollar ikinci planda kalmış, uğraşmaya değmezdir. Ancak karar vermek için bir sistemi uçtan uca eğitecekseniz, en iyi karara en iyi puanı verdiği sürece hangi puanlama fonksiyonunu kullanırsanız kullanın işe yarayacaktır. Enerji temelli modeller; modeli nasıl ele alacağınız, nasıl eğiteceğiniz, ve hangi nesne fonksiyonunu kullanacağınız konusunda size çok daha fazla seçenek sunar. Modelinizin olasılıksal olması için ısrarcıysanız, en büyük olabilirlik kullanmanız gerekir. Temel olarak modelinizi, gözlemlediğiniz verilere en yüksek olasılığı verecek şekilde eğitmelisiniz. Sorun, bunun sadece modelinizin “doğru” olduğu durumda işe yaramasıdır ve modeliniz asla “doğru” değildir. Ünlü istatistikçi George Box’un da dediği gibi “Tüm modeller yanlıştır, ama bazıları faydalıdır.”. Dolayısıyla tüm olasılıksal modeller, özellikle yüksek boyutlu ve birleşimsel (metin gibi) uzaydakiler, yaklaşık modellerdir. Bu modellerin hepsi bir şekilde yanlıştır, ve bunları normalleştirmeye çalışırsanız daha da yanlış hale getirirsiniz. Yani onları normalleştirmemek daha iyidir.

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: x ve y arasındaki bağımlılığı ölçen enerji fonksiyonunun görselleştirilmesi
</center>

<!--This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what maximum likelihood will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example:

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Example for multiple prediction of EBM as an implicit function
</center>

There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.  Maximum likelihood sucks [in this case]!

So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regularizer})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser.

So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong. -->

Bu, *x* ve *y* arasındaki bağımlılığı yakalamaya çalışan bir enerji fonksiyonudur. Adeta sıradağlara benzer. Vadiler siyah noktaların olduğu yerlerdir (bunlar veri noktalarıdır), ve dört bir yanı dağlarla çevrilidir. Eğer olasılıksal bir modeli bununla eğitirseniz, noktaların sonsuz incelikte bir manifoldda olduğunu hayal edin. Yani siyah noktaların veri dağılımı aslında sadece bir doğru, ve bu doğrulardan üç tane var. Aslında genişlikleri yok. Bundan yola çıkarak bir olasılıksal model eğitecek olursanız, yoğunluk modeliniz size ne zaman bu manifoldda olduğunuzu söylemeleridir. Bu manifoldda yoğunluk sonsuz, sadece epsilon kadar dışındayken ise sıfır olmalıdır. Bu dağılımın doğru modelini elde etmek bu şekilde mümkün olacaktır. Yoğunluğun sonsuz olmasının yanında, [x ve y] üzerinde integralin de 1 olması gerekir. Bunu bilgisayarda uygulamak çok zordur. Hatta sadece zor değil, imkansızdır. Diyelim ki bu fonksiyonu bir çeşit sinir ağı ile hesaplamak istiyorsunuz- sinir ağınız sonsuz ağırlığa sahip olmalı ve sistemin çıktısının tüm alan üzerindeki integrali 1 olacak şekilde ayarlanmalıdır. Bu temelde imkansızdır. Bu veri örneği ile doğru, geçerli bir olasılıksal model yaratmak mümkün değildir. En büyük olabilirlik sizden bunu üretmenizi isteyecektir, ve dünyada bu hesabı yapabilecek bir bilgisayar yoktur. Aslında bu ilginç bile değil. Bu örnek için elinizde kusursuz bir yoğunluk modeli, yani (x,y) uzayındaki ince bir levha olduğunu hayal edin, çıkarsama yapamazsınız! Size x değerini verir ve “y’nin en iyi değeri nedir?” diye sorarsam bulamazsınız çünkü sıfır olasılık kümesi haricindeki tüm y değerlerinin sıfır olasılığı vardır, ve mümkün olan sadece birkaç değer mevcuttur. Örneğin bu x değerleri için:

<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Gizli bir fonksiyon olarak EBM'nin çok sayıda tahmin örnekleri
</center>

Mümkün olan 3 y değeri vardır ve bunlar sonsuz derecede dardır. Bu nedenle onları bulamazsınız. Bulmanıza yarayacak bir çıkarsama algoritması da mevcut değildir. Bu değerleri bulmanızın tek yolu zıtlık fonksiyonunuzu pürüzsüz ve türevlenebilir hale getirmektir, daha sonra istediğiniz bir noktadan başlayabilir ve gradyan inişiyle herhangi bir x değerine karşılık iyi bir y değeri bulabilirsiniz. Ancak dağılım önceden bahsettiğim şekilde ise bu, dağılımın iyi bir olasılıksal modeli olmayacaktır. Bu da iyi bir olasılıksal modele sahip olmak için ısrar etmenin aslında kötü olduğu bir durumdur. En büyük olabilirlik [bu durumda] işe yaramazdır!

Yani eğer gerçek bir Bayes’çiyseniz “ama bu, yoğunluk fonksiyonunuzun pürüzsüz olması gerektiğini söyleyen güçlü bir önsele sahip olarak düzeltilebilir” dersiniz. Bunu bir önsel olarak düşünebilirsiniz. Fakat Bayes terimleriyle yaptığınız her şeyde- logaritma almak, normalleştirmeyi unutmak- enerji temelli modeller elde edersiniz. Enerji fonksiyonunuza eklenebilecek bir düzenlileştiriciye sahip olan enerji temelli modeller, olabilirliğin enerjinin üsseli olduğu Bayes modellerine tamamıyla eşdeğerdir. Elde ettiğiniz şey $\exp(\text{energy}) \exp(\text{regularizer})$ olur, bu da şuna eşittir: $\exp(\text{energy} + \text{regulariser})$. Eğer üsseli çıkarırsanız düzenlileştirici eklenmiş bir enerji temelli model elde etmiş olursunuz. 

Yani olasılıksal ve Bayesçi yöntemler arasında bir uyuşma var, ama en büyük olabilirlik için ısrarcı olmak, özellikle de olasılıksal modelinizin çok yanlış olacağı yüksek boyutlu veya birleşimsel uzayda, bazen sizin için kötü olabilir. Kesikli dağılımlarda çok yanlış değildir (sorun değil), ancak sürekli durumlarda, gerçekten yanlış olabilir. Aslında tüm modeller yanlış olacaktır.
