---
lang-ref: ch.06-3
lang: tr
title: RNN ve LSTM Modellerinin Mimarileri
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
translator: İrem Demirtaş
translation-date: 21 Jul 2020
---


<!-- ## [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is just temporal inputs of X. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions. -->

## [Genel Bakış](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

RNN (Reccurrent Neural Network, Özyinelemeli Sinir Ağı) dizi şeklindeki veriyle uğraşırken kullanabileceğimiz mimarilerden biridir. CNN (Convolutional Neural Network, Evrişimli Sinir Ağı) dersinde bir sinyalin, alana göre, 1, 2, ya da 3 boyutlu olabileceğini öğrendik. Dizi şeklindeki veride ilgili alan X'in zamana göre girdileri olduğundan tek boyutlu veriyle uğraşılır. Yine de RNN'i iki yöne sahip olan 2 boyutlu veriyle de kullanabilirsiniz. 

<!-- ### Vanilla vs. Recurrent NN

Figure 1 is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Vanilla Architecture
</center>

In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown in Figure 2. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> RNN Architecture
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Basic NN Architecture
</center>

Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in Figure 3, the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation i.e. rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Yann's RNN Architecture
</center> -->

### Düz Sinir Ağı vs. Özyinelemeli Sinir Ağı

Fig 1'de üç katmanlı düz bir sinir ağının diyagramını görebilirsiniz. Pembe balon girdi vektörü x'i gösterirken gizli katman ve çıktı katmanı sırasıyla yeşil ve mavi ile gösterir. Sağ taraftaki dijital elektronik örneğinde görüldüğü gibi bu kombinasyonel mantığa benzer, şimdiki çıktı sadece şimdiki girdiye bağlıdır.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 1:</b> Düz Mimari
</center>

Düz sinir ağının aksine, özyinelemeli ağlarda şimdiki çıktı sadece şimdiki girdiye değil, aynı zamanda, Fig 2.'de görüldüğü üzere, sistemin o anki durumuna bağlıdır. Bu dijital elektronikteki ardışık mantığa benzer, çıktı bir "mandal" *(flip-flop, dijital elektronikte basit bir bellek ünitesi)* devresine bağımlıdır. Bu yüzden buradaki ana farklılık düz sinir ağının çıktısı sadece o anki girdiye bağlıyken, özyinelemeli bir ağın çıktısının sistemin durumuna da bağlı olmasıdır.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 2:</b> RNN Mimarisi
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 3:</b> Basit Sinir Ağı Mimarisi
</center>

Yann'ın diyagramı bir tensörden (vektörden) diğerine eşlemeyi göstermek için bu şekilleri nöronların arasına ekler. Örneğin, Fig 3'te, girdi vektörü x, bu eklenmiş birimden eşlenip gizli gösterim h'e gidecektir. Bu aslında bir afin dönüşümdür (yani döndürme ve sonrasında bozma). Daha sonra başka bir dönüşümle gizli katmandan son çıktıyı alırız. Benzer şekilde, RNN diyagramında görüldüğü gibi, nöronlar arasına eklenmiş şekilleri aynı şekilde görebilirsiniz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 4:</b> Yann'ın RNN Mimarisi
</center>

<!-- ### Four types of RNN Architectures and Examples

The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Vec to Seq
</center>

An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using Figure 6, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> vec2seq Example: Image to Text
</center>

The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7:</b> Seq to Vec
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 8:</b> Input lines of Python Codes
</center>

Then the network will be able to output the correct solution of this program. Another more complicated program like this:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Input lines of Python Codes in a more Completed Case
</center>

Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.

The third is sequence to vector to sequence, shown in Figure 10. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018).

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Seq to Vec to Seq
</center>

If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 11:</b> Words Grouped by Semantics after PCA
</center>

If we zoom in, we will see that the in the same location there are all the months, like January and November.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 12:</b> Zooming in Word Groups
</center>

If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 13:</b> Word Groups in another Region
</center>

From these examples, we see that different locations will have some specific common meanings.

Figure 14 showcases how how by training this kind of network will pick up on some semantics features. For exmaple in this case you can see there is a vector connecting man to woman and another between king and queen, which means woman minus man is going to be equal to queen minus king. You will get the same distance in this embeddings space applied to cases like male-female. Another example will be walking to walked and swimming to swam. You can always apply this kind of specific linear transofmation going from one word to another or from country to capital.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 14:</b> Semantics Features Picked during Training
</center>

The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 15:</b> Seq to Seq
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 16:</b> Text Auto-Completion Model of Seq to Seq Model
</center> -->

### Dört RNN Türü ve Örnekleri

İlk durum vektörden diziyedir. Burada girdi bir balondur ve devamında sistemin içsel durumunun evrimi yeşil balonlarla gösterilmiştir. Sistem evrildikçe, her zaman adımında belirli bir çıktı olacaktır. 

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 5:</b> Vektörden Diziye
</center>

Bu tip mimarinin örneği girdi olarak bir görüntü alıp çıktı olarak görüntünün kelime dizisi halinde İngilizce açıklamasının üretilmesidir. Fig 6'yı kullanarak açıklayacak olursak, her bir mavi balon İngilizce kelimelerin İngilizce sözlükteki indeksi olabilir. Örneğin, eğer çıktı "This is a yellow school bus" cümlesiyse, öncelikle "This" kelimesinin indeksini, sonra "is" kelimesinin indeksini alarak devam edersiniz. Bu ağdan elde edilen bazı sonuçlar aşağıda gösterilmiştir. Örneğin, ilk sütunda son resim için üretilen açıklama, "A herd of elephants walking across a dry grass field." ("Bir fil sürüsü kurak yeşillik alan boyunca yürüyor."), epey detaylı. İkinci sütunda ilk resim için "Two dogs play in the grass." ("İki köpek çimenlik alanda oynuyor.") cümlesi üretiliyor, ancak resimde aslında üç köpek var. Son sütunda, "A yellow school bus parked in a parking lot." ("Yeşil bir okul servisi otoparka park edilmiş.") gibi, daha yanlış örnekler var. Genel olarak, bu sonuçlar bu ağın sert bir şekilde başarısız olabileceğini ve aynı zamanda bazen de iyi çalışabileceğini gösteriyor. Bu girdinin sadece tek bir vektör, resmin gösterimi, çıktınınsa bir dizi sembol, örneğin İngilizce cümleleri oluşturan kelimeleri oluşturan karakterler, olduğu bir örnek. Bu tür mimarilere otoregresif ağ denir. Bir otoregresif ağ bir önceki adımda süretilen çıktının bir sonraki adıma girdi olarak verildiği ağdır.  

<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 6:</b> Vektörden Diziye Örnek: Resimden Metine
</center>

İkinci türde bir diziden bir vektör üretilir. Bu ağ bir dizi sembolü besler ve sadece son adımda bir çıktı üretir. Bu tür bir uygulama Python yorumlamak için kullanılabilir. Örneğin girdiler bir Python programının satırları olabilir.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 7:</b> Diziden Vektöre
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 8:</b> Python kodunun girdi satırları
</center>

Ağ bu programın doğru çözümünü verecektir. Daha karmaşık bir program aşağıdaki gibi olabilir:

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Daha karmaşık bir durum için Python girdi satırları
</center>

Bu durumda çıktı 12184 olmalıdır. Bu iki örnek bir sinir ağını bu tür bir uygulama için eğitebileceğinizi gösteriyor. Sadece bir sembol dizisi besleyip çıktının belli bir sayı olmasını sağlamalıyız.

Üçüncü durumda, Fig 10'da görüldüğü gibi, sekanstan vektör vektörden sekans üretilir. Bu mimari eskiden makine tercümesi için kullanılan standart mimariydi. Burada pembeyle gösterildiği gibi bir dizi sembolle başlarsınız. Her şey son bir h vektöründe toplanır ve bu vektör bir konsepti temsil eder. Örneğin, bir cümleyi girdi olarak alıp, cümlenin anlamını ve vermek istediği mesajı temsil eden, geçici bir vektöre sıkıştırabiliriz. Daha sonra herhangi bir dösterimde bu anlamı aldıktan sonra, ağ başka bir dilde onu açabilir. Örneğin "Today I'm very happy" ("Bugün çok mutluyum") İtalyanca ya da Çince'ye çevrilebilecek bir İngilizce kelime dizisidir. Son olarak, ağ aynı sıkıştırılmış versiyon verildiğinde bir kodçözme işlemi uygular. Son zamanlarda, bir sonraki derste işleyeceğimiz, Dönüştürücü (Transformer), gibi ağların tercüme görevlerinde bu metoddan daha iyi sonuçlar aldığını gördük. Bu mimari 2018 yılında en iyi çalışan yöntemdi.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Sekanstan Vektöre Vektörden Sekansa
</center>


Eğer saklı uzayda PCA (Principle Component Analysis, Temel Bileşen Analizi) uygularsanız, grafikte görüldüğü gibi, kelimelerin anlamlarına göre gruplandığını görürsünüz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 11:</b> PCA sonrası anlamlarına göre gruplanmış kelimeler
</center>

Yaklaştığımızda aynı alanda "January" (Ocak) ve "November" (Kasım) gibi ayların olduğunu görürüz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 12:</b> Kelime gruplarına yakından bakış
</center>

Başka bir alana bakarsanız, "a few days ago" (birkaç gün önce) "the next few months" (gelecek birkaç ayda) gibi kalıpları görebilirsiniz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 13:</b> Başka bir bölgedeki kelime grupları
</center>

Bu örneklerden görüldüğü gibi farklı alanlar belirli paylaşılan anlamları kapsar.

Fig 14. bu tür bir ağ eğiterek nasıl anlamsal özelliklerin yakalanabildiğini gösterir. Örneğin, bu örnekte bir vektörün "man" (adam) ve "woman" (kadın) kelimelerini "king" (kral) ve "queen" (kraliçe) kelimelerine benzer bir şekilde bağladığını görebilirsiniz. Bu gömülmelerde erkek-kadın ilişkilerinde benzer uzaklıkları elde edersiniz. Bir başka örnek "walking" (yürüyor-) "walked" (yürüdü-) ve "swimming" (yüzüyor-) "swam" (yüzdü-) arasında görülebilir. Bu türk doğrusal dönüşümleri uygularak bir kelimeden diğerine ya da bir ülkeden başkentine geçebilirsiniz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 14:</b> Eğitim esnasında yakalanan anlamsal özellikler
</center>

The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest.

Dördüncü ve son durumda diziden dizi üretilir. Bu ağda girdi beslendikçe ağ çıktı üretir. Bu tür mimarinin örneği T9'dur. Nokia telefonları hatırlıyorsanız, siz yazdıkça telefonun öneride bulunduğunu hatırlarsınız. Bir başka örnek konuşmadan altyazı oluşturmaktır. Havalı bir örnek yazar-RNN'dir. "the rings of Saturn glittered while" yazdığınızda size "two men looked at each other" cümlesi önerilir. Bu ağ bilimkurgu romanları üzerinde eğitildiğinden bir şeyler yazıp size bir kitap yazmanızda yardım edecek öneriler alabilirsiniz. Bir başka örnek Fig 16'da görülebilir. Üstteki cümle verildiğinde ağ kalanını tamamlamaya çalışır.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 15:</b> Diziden diziye
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 16:</b> Diziden diziye modelle metin tamamlama modeli
</center>

<!-- ## [Back Propagation through time](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)


### Model architecture

In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 17:</b> Back Propagation through time
</center>

Hidden representations are stated as

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

which corresponds to the stack representation of the input.

$y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step. -->

## [Zamanda Geri Yayılım](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)


### Model Mimarisi

Bir RNN eğitmek için zamanda geri yayılım (BPTT, Back Propagation Through Time) kullanılmalıdır. RNN mimarisi aşağıdaki figürde berilmiştir. Soldaki dizayn döngü gösterimini kullanırken, sağdaki döngüyü açarak zamanda bir doğru üzerinde gösterir.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 17:</b> Zamanda geri yayılım
</center>

Gizli gösterimler şöyle gösterilmiştir

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

İlk denklem doğrusal olmayan bir fonksiyonun girdinin yığın şeklinde, gizli katmanın bir önceki konfigürasyonun sona eklendiği versiyonunun döndürülmüş haline uygulanışını gösterir. Başta, $h[0]$'a sıfır atanmıştır. Denklemi sadeleştirmek için, $W_h$, $\left[ W_{hx}\ W_{hh}\right]$ olarak iki ayrı matris halinde yazılabilir ve bazen dönüşüm şu şekilde ifade edilebilir.

$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$

bu girdinin yığın halinde gösterilişine denk gelir. 

$y[t]$ son döndürmede hesaplanır ve sonrasında zincir kuralını kullanarak bir önceki zaman adımına hatayı geri yayabiliriz.

<!-- ### Batch-Ification in Language Modeling

When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b> Batch-Ification
</center>

If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Batch-Ification
</center> -->

### Dil Modellemede Yığınlaştırma (Batch-ification)

Bir sembol dizisiyle uğraşırken metni çeşitli boyutlarda yığınlaştırabiliriz. Örneğin, dizilerle uğraşırken, aşağıdaki figürde gösterildiği gibi, önce yığınlaştırma uygulanarak dikeyde zaman alanı korunabilir. Bu örnekte yığın boyutu dört olarak belirlenmiştir.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b> Yığınlaştırma
</center>

Eğer BPTT periodu $T$'ye 3 atanmışsa, RNN'deki ilk girdi $x[1:T]$ ve çıktı $y[1:T]$ şöyle belirlenir

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

RNN ilk yığın üzerinde çalışırken, önce $x[1] = [a\ g\ m\ s]$ beslenir ve çıktının $y[1] = [b\ h\ n\ t]$ olması sağlanır. Gizli gösterim $h[1]$, $x[2]$'den $y[2]$'nin üretilebilmesi için bir sonraki adıma iletilir. $h[T-1]$, son girdi olan $x[T]$'den son çıktı $y[T]$'nin üretilebilmesi için bir sonraki adıma iletildiğinde gradyanların sonsuza kadar yayılmasını önlemek için hem $h[T]$ hem $h[0]$ için gradyan yayılımı işlemi kesilir (PyTorch'ta .detach()). Tüm süreç aşağıdaki figürde gösterilmiştir.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Yığınlaştırma
</center>

<!-- ## Vanishing and Exploding Gradient


### Problem

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b> Vanishing Problem
</center>

The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.

In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed.


### Solution

An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b> Skip Connection
</center>

In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.

LSTM is one prevalent gated RNN and is introduced in detail in the following sections. -->

## Kaybolan ve Patlayan Gradyan

### Problem

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b> Kaybolma Problemi
</center>

Yukarıdaki figür tipik bir RNN mimarisidir. RNN'de önceki adımlardan döndürme yapılabilmesi için, yukarıdaki modelde yatay oklarla gösterilen matrisleri kullanırız. Matrisler çıktıların boyutlarını değiştirebileceğinden, eğer seçtiğimiz determinant 1'den büyükse, gradyan zamanla büyüyecek ve gradyan patlamasına sebep olacaktır. Başka bir deyişle, eğer seçtiğimiz özdeğer 0 boyunca küçükse, yayılım süreci gradyanları küçültecek ve gradyan kaybolmasına sebep olacaktır. 

Tipik RNN'lerde, gradyanlar tüm olası oklar üzerinden iletilir ve bu gradyanların kaybolması veya patlaması için büyük olanak sağlar. Örneğin, parlak rengin gösterdiği üzere zaman 1'de gradyan büyüktür. Bir rotasyondan geçtiğinde epey küçülür ve zaman 3'te tamamen ölür. 

### Çözüm

Gradyanların patlamasını ve kaybolmasını önlemenin yollarından biri atlamalı bağlantılardır. Bunu sağlamak için birden fazla ağ kullanılabilir.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b> Atlamalı bağlantı
</center>

Yukarıdaki örnekte, orijinal ağ dört ağa bölünmüştür. İlk ağı ele alalım. Zaman 1'den bir değer alır ve çıktıyı gizli katmandaki ilk ara duruma gönderir. Durum, $\circ$ların gradyanların geçmesini sağladığı, $-$lerinse önlediği, üç ağ içerir. Bu tekniğe kapılı yinelemeli ağ denir. 

LSTM yaygın bir kapılı RNN'lerden biridir ve bir sonraki bölümlerde detaylı olarak anlatılmıştır.

<!-- ## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)


### Model Architecture

Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22:</b> LSTM Architecture
</center>

Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c}[t]$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.

How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 23:</b> LSTM Architecture - Output On
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 24:</b> LSTM Architecture - Output Off
</center>

Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and $i[t]$ to be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 25:</b> Visualization of the Memory Cell
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 26:</b> LSTM Architecture - Reset Memory
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 27:</b> LSTM Architecture - Keep Memory
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 28:</b> LSTM Architecture - Write Memory
</center>
 -->


## [Uzun Ömürlü Kısa Dönem Bellek](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)


### Model Mimarisi

Aşağıdaki denklemler LSTM'i ifade eder. Girdi kapısı, afin transformasyon olacak olan, sarı kutularla gösterilmiştir. Bu transformasyon, aday kapımız olan $c[t]$ ile çarpılacaktır.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22:</b> LSTM Mimarisi
</center>

Unutmama kapısı önceki hücre belleği $c[t-1]$ ile çarpılacaktır. Toplam hücre değeri $c[t]$ girdi ve unutmama kapılarının toplamıdır. Son izli durum gösterimi çıktı kapısı $o[t]$ ile $c[t]$'nin hiperbolik tanjant versiyonunun Hadamard çarpımıdır. Son olarak, basitçe, $\tilde{c}[t]$ bir yinelemeli ağdır. Yani çıktıyı modüle etmek için bir $o[t]$, unutmama kapısını modüle etmek için bir $f[t]$, ve girdiyi modüle etmek için bir $i[t]$'yi kullanırız. Tüm bu bellek ve kapılar arasındaki etkileşimler çarpımsal etkileşimlerdir. $i[t]$, $f[t]$ ve $o[t]$ sıfırdan bire kadar değerler alan sigmoidlerdir. Dolayısıyla, sıfırla çarparken kapalı bir kapı elde edersiniz, birle çarparken açık bir kapı elde edersiniz. 

Peki çıktıyı nasıl kapatırız? Mor bir iç gösterim olan $th$'yi ele alalım ve çıktı kapısına sıfır verelim. Çıktı sıfırla bir şeyin çarpımı olur ve sıfır elde ederiz. Eğer çıktı kapısına bir verirsek mor gösterimle aynı değeri elde ederiz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 23:</b> LSTM Mimarisi - Çıktı açık
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 24:</b> LSTM Mimarisi - Çıktı kapalı
</center>

Benzer bir şekilde belleği de kontrol edebiliriz. Örneğin $f[t]$ ve $i[t]$'yi sıfır yaparak belleği sıfırlayabiliriz. Çarpım ve toplamadan sonra bellekte sıfır elde ederiz. Öte yandan iç gösterim $th$'yi sıfır tutarken $f[t]$'ye bir vererek bellek içeriğini koruyabiliriz. Bu yüzden toplam $c[t-1]$ değerini alır ve iletmeye devam eder. Son olarak, girdi kapısında bir elde edecek, çarpımın mor değeri alabileceği ve unutmama kapısına sıfır vererek aslında unutmasını sağlayacak şekilde belleğe yazabiliriz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 25:</b> Bellek hücresinin görselleştirilmesi
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 26:</b> LSTM Mimarisi - Belleğin sıfırlanması
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 27:</b> LSTM Mimarisi - Belleğin korunması
</center>

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 28:</b> LSTM Mimari - Belleğe yazma
</center>


<!-- ## Notebook Examples


### Sequence Classification

The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.

1). Dataset Exploration

The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figure 29:</b> Input Vector Example
</center>


2). Defining the Model and Training

Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:

 * Perform the forward pass of the model
 * Compute the loss
 * Zero the gradient cache
 * Backpropagate to compute the partial derivative of loss with regard to parameters
 * Step in the opposite direction of the gradient

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 30:</b> Simple RNN vs LSTM - 10 Epochs
</center>

With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 31:</b> Simple RNN vs LSTM - 100 Epochs
</center>

If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 32:</b> Visualization of Hidden State Value
</center>

The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence. -->

## Notebook Örnekleri


### Dizi Sınıflandırma

Burada amaç dizileri sınıflandırmaktır. Elemanlar ve hedefler yerel olarak temsil edilir (sadece bir elemanı sıfır olmayan vektörler halinde). Dizi bir `B` ile başlar, bir `E` ile biter ("tetik sembolü") ve $t_1$ ve $t_2$ pozisyonlarında `X` veya `Y` karakterlerinden birini alan karakterleri dışındaki diğer karakterleri `{a, b, c, d}` kümesinden rastgele seçilen karakterlerden oluşur. `DifficultyLevel.HARD` ("ZorlukSeviyesi.ZOR") örneğinde dizi uzunluğu 100-110 arasından , $t_1$ 10-20 arasından ve $t_2$ 50-60 arasından rastgele seçilir. Dört dizi sınıfı `Q`, `R`, `S` ve `U` `X` ve `Y`'nin zamansal sıralarına bağlıdır. Kurallar şöyledir: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.
 
1). Verikümesi İncelemesi

Veri oluşturucusundan döndürülen tip uzunluğu 2 olan bir demettir (tuple). Demetin ilk elemanı $(32, 9, 8)$ şeklindeki dizi yığınıdır. Bu veri ağa beslenir. Her satırda sekiz farklı sembol bulunur  (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Her satır bir one-hot vektördür. Bir satır dizisi bir sembol dizisini gösterir. İlk tamamen sıfırdan oluşan satır dolgulamayı gösterir. Dolgulama dizinin boyu kısa olduğunda maksimum boyuta tamamlamak için kullanılır. Demetin ikinci elemanı yığına karşılık gelen, dört sınıfımız olduğu için (`Q`, `R`, `S`, and `U`), $(32, 4)$ şeklindeki sınıf etiketleridir. İlk dizi `BbXcXcbE`'dir. Kodçözülmüş sınıf etiteti ise `Q`'ya karşılık gelen $[1, 0, 0, 0]$ vektörüdür.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Fig 29:</b> Girdi vektörü örneği
</center>


2). Modelin Tanımlanması ve Eğitimi

Basit bir özyinelemeli ağ, bir LSTM, tanımlayalım ve 10 epok boyunca eğitelim. Eğitim döngüsünde aşağıdaki beş adıma dikkat etmeliyiz:

* Modelin ileri geçişi
* Kaybın hesaplanması
* Gradyan önbelleğinin sıfırlanması
* Kaybın parametrelere göre kısmi türevlerinin geri yayılımla hesaplanması
* Gradyanların tersi yönde güncelleme

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 30:</b> Basit RNN vs LSTM - 10 Epok
</center>

Basit zorluk seviyesinde, 10 epoktan sonra, RNN %50 doğruluk oranına ulaşırken LSTM %100'e ulaşır. Ama LSTM RNN'in dört katı ağırlığa sahiptir ve iki gizli katmandan oluşur, bu nedenle bu adil bir karşılaştırma değildir. 100 epoktan sonra RNN de %100 doğruluk oranına erişir ve LSTM'e göre daha uzun sürede eğitilir.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 31:</b> Basit RNN vs LSTM - 100 Epok
</center>

Daha uzun diziler kullanarak eğitimdeki zorluk seviyesini artırdığımızda LSTM çalışmaya devam ederken RNN'in başarısız olduğunu görürüz.

<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Fig 32:</b> Gizli durum değerinin görselleştirilmesi
</center>

Yukarıdaki görsel LSTM'in gizli durumunun zamana göre değişimini gösterir. Girdileri tanh üzerinden göndeririz, böylece $-2.5$'in altındaki değerler $-1$'e, $2.5$ üzerindeki değerler $1$'e eşlenir. Bu örnekte `X` için bir gizli katmanın seçildiğini (resimdeki beşinci satır) ve sonrasında başka bir `X` değeri için kırmızı olduğunu görebiliriz. Yani, hücrenin beşinci gizli biriminin `X`'i gözlemlediğinde tetiklendiğini ve diğer `X`'i gördükten sonra sessizleştiğini görebiliriz. Bu bizim sekansın sınıfını tanımamızı sağlar.

<!-- ### Signal Echoing

Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said.

Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past. -->

### Sinyal Yankılama

Sinyali n adım yankılama senkonize çoktan-çoğa görevlere örnektir. Bir örnekte, ilk girdi dizisi `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, ilk hedef dizisi `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`'dir. Bu örnekte çıktı üç adım gecikmelidir. Yani bu bilgiyi tutabilmek için bir kısa-dönem belleğe ihtiyaç duyarız. Bir dil modelindeyse daha önceden henüz söylenmemiş bir şeyi söyler.

Tüm diziyi ağa göndermeden ve son hedefi bir şey olması için zorlamadan önce, uzun dizileri küçük parçalara ayırmamız gerekir. Yeni bir parçayı beslerken, bir sonraki yeni parçayı beslerken iç duruma girdi olarak verebilmek için gizli durumu takip etmemiz gerekir. LSTM'de yeterince kapasiteye sahip olduğunuz sürece belleği uzun süre koruyabilirsiniz. RNN belli bir uzunluğa eriştikten sonra geçmişte ne olduğunu unutmaya başlar.
