---
lang-ref: ch.05-1
lang: tr
title: Optimizasyon Yöntemleri 1
lecturer: Aaron Defazio
authors: Vaibhav Gupta, Himani Shah, Gowri Addepalli, Lakshmi Addepalli
date: 24 Feb 2020
translation date: 17 Jul 2020
translator: melikenurm
---

<!--
## [Gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

We start our study of Optimization Methods with the most basic and the worst (reasoning to follow) method of the lot, Gradient Descent.

**Problem:**

$$
\min_w f(w)
$$

**Iterative Solution:**

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

where,
 - $w_{k+1}$ is the updated value after the $k$-th iteration,
 - $w_k$ is the initial value before the $k$-th iteration,
 - $\gamma_k$ is the step size,
 - $\nabla f(w_k)$ is the gradient of $f$.

-->

## [Gradyan inişi](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

Optimizasyon Yöntemleri dersine birçok yöntem içinde en basit ve en kötü (neden olduğundan bahsedeceğiz) yöntem olan Gradyan İnişi ile başlayacağız.

**Problem:**

$$
\min_w f(w)
$$

**Tekrarlamalı Çözüm:**

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

burada,
 - $k$-ıncı iterasyondan sonra güncellenmiş değer $w_{k+1}$,
 - $k$-ıncı iterasyondan önceki başlangıç değeri $w_k$,
 - $\gamma_k$ adım boyutu,
 - $\nabla f(w_k)$ ise $f$'in gradyanı.

<!--
The assumption here is that the function $f$ is continuous and differentiable. Our aim is to find the lowest point (valley) of the optimization function. However, the actual direction to this valley is not known. We can only look locally, and therefore the direction of the negative gradient is the best information that we have. Taking a small step in that direction can only take us closer to the minimum. Once we have taken the small step, we again compute the new gradient and again move a small amount in that direction, till we reach the valley. Therefore, essentially all that the gradient descent is doing is following the direction of steepest descent (negative gradient).

The $\gamma$ parameter in the iterative update equation is called the **step size**. Generally we don't know the value of the optimal step-size; so we have to try different values. Standard practice is to try a bunch of values on a log-scale and then use the best one. There are a few different scenarios that can occur. The image above depicts these scenarios for a 1D quadratic. If the learning rate is too low, then we would make steady progress towards the minimum. However, this might take more time than what is ideal. It is generally very difficult (or impossible) to get a step-size that would directly take us to the minimum. What we would ideally want is to have a step-size a little larger than the optimal. In practice, this gives the quickest convergence. However, if we use too large a learning rate, then the iterates get further and further away from the minima and we get divergence. In practice, we would want to use a learning rate that is just a little less than diverging.
-->

Burada $f$ fonksiyonunun sürekli ve türevlenebilir olduğu varsayılmaktadır. Amacımız optimizasyon fonksiyonunun en düşük noktasını (vadi) bulmaktır. Ancak, bu vadiye giden kesin yön bilinmemektedir. Yalnız bölgesel olarak bakılınca negatif gradyanın yönü sahip olduğumuz en iyi bilgidir. Ancak bu yönde küçük bir adım atmak bizi minimuma yaklaştırır. Bir kez küçük bir adım attıktan sonra, tekrar yeni gradyanı hesaplarız ve tekrar bu yönde küçük bir miktar hareket ederiz, ta ki vadiye ulaşıncaya kadar. Aslında temel olarak gradyan inişinin yaptığı şey en dik iniş (negatif gradyan) yönünü takip etmektir.

Tekrarmalı güncelleme denklemindeki $\gamma$ parametresine **adım boyutu** denir. Genelde optimal adım boyutunun değeri bilinmez; bu yüzden farklı değerler denemek zorunda kalırız. Standart uygulama, bir log-ölçeğinde bir grup değeri denemek ve en iyisini kullanmaktır. Bu durumda oluşabilecek birkaç farklı senaryo vardır. Yukarıdaki görüntü 1 boyutlu ikinci dereceden *(quadratic)* bir fonksiyon için bu senaryoları göstermektedir. Öğrenme hızı çok düşük olursa minimum seviyeye doğru istikrarlı bir ilerleme kaydedebiliriz. Ancak bu ideal olandan daha fazla zaman alabilir. Bizi doğrudan minimuma indirecek bir adım boyutu elde etmek genellikle çok zordur (veya imkansızdır). Bu durumda ideal olarak isteyeceğimiz şey, optimalden biraz daha büyük bir adım boyutudur.  Pratikte bu en hızlı yakınsamayı sağlar. Bununla birlikte çok büyük bir öğrenme oranı kullanırsak iterasyonlar sonunda minimumdan uzaklaşırız ve sapmış oluruz. Dolayısıyla uygulamada bizi saptıracak değerden biraz daha düşük bir öğrenme hızı kullanmak isteriz.

<!--
<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Step sizes for 1D Quadratic
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Şekil 1:</b> 1 boyutlu ikinci dereceden fonksiyon için adım miktarları
</center>

<!--
## [Stochastic gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)

In Stochastic Gradient Descent, we replace the actual gradient vector with a stochastic estimation of the gradient vector. Specifically for a neural network, the stochastic estimation means the gradient of the loss for a single data point (single instance).

Let $f_i$ denote the loss of the network for the $i$-th instance.

$$
f_i = l(x_i, y_i, w)
$$

The function that we eventually want to minimize is $f$, the total loss over all instances.

$$
f = \frac{1}{n}\sum_i^n f_i
$$
-->

## [Stokastik gradyan inişi](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)

Stokastik gradyan inişinde gerçek gradyan vektörünü stokastik bir tahmini ile değiştiriyoruz. Özellikle bir sinir ağı için, stokastik tahmin tek bir veri noktasının (tek örnek) kaybının *(loss)* gradyanı anlamına gelir.

$i$-inci örnek için ağın kaybını $f_i$ ile gösterelim.

$$
f_i = l(x_i, y_i, w)
$$

Nihai olarak en aza indirmek istediğimiz fonksiyon, tüm örneklerin toplam kaybı olan $f$ 'dir.

$$
f = \frac{1}{n}\sum_i^n f_i
$$

<!--
In SGD, we update the weights according to the gradient over $f_i$ (as opposed to the gradient over the total loss $f$).

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i chosen uniformly at random)}
\end{aligned}
$$

If $i$ is chosen randomly, then $f_i$ is a noisy but unbiased estimator of $f$, which is mathematically written as:

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$
-->

SGD'de, $f_i$ üzerindeki gradyana (toplam kayıp $f$'in gradyanını kullanmak yerine) göre ağırlıkları güncelliyoruz.

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i rastgele birbiçimli olarak seçilir)}
\end{aligned}
$$

Eğer $i$ rastgele seçilirse, $f_i$, $f$'in gürültülü *(noisy)* ama tarafsız bir tahminleyicisidir ve matematiksel olarak şu şekilde yazılır:

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$

<!--
As a result of this, the expected $k$-th step of SGD is the same as the $k$-th step of full gradient descent:

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$
-->

Bunun sonucu olarak, SGD'nin beklenen $k$-ıncı adımı, tam gradyan inişin $k$-ıncı adımı ile aynıdır:

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$

<!--
Thus, any SGD update is the same as full-batch update in expectation. However, SGD is not just faster gradient descent with noise. Along with being faster, SGD can also get us better results than full-batch gradient descent. The noise in SGD can help us avoid the shallow local minima and find a better (deeper) minima. This phenomenon is called **annealing**.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Figure 2:</b> Annealing with SGD
</center>
-->

Bu nedenle, herhangi bir SGD güncellemesi, beklentide tam-toplu *(full-batch)* güncelleme ile aynıdır. Ancak, SGD sadece gürültülü ve daha hızlı gradyan inişi değildir. Daha hızlı olmanın yanı sıra, SGD bize tam-toplu gradyan inişten daha iyi sonuçlar verebilir. SGD'deki gürültü sığ yerel minimumlardan kaçınmak ve daha iyi (daha derin) bir minimum bulmak için yardımcı olabilir. Bu olaya **tavlama** denir.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Şekil 2:</b> SGD'de tavlama
</center>

<!--
In summary, the advantages of Stochastic Gradient Descent are as follows:

 1. There is a lot of redundant information across instances. SGD prevents a lot of these redundant computations.
 2. At early stages, the noise is small as compared to the information in the gradient. Therefore a SGD step is *virtually as good as* a GD step.
 3. *Annealing* - The noise in SGD update can prevent convergence to a bad(shallow) local minima.
 4. Stochastic Gradient Descent is drastically cheaper to compute (as you don't go over all data points).
-->

Özet olarak, Stokastik Gradyan İnişinin avantajları aşağıdaki gibidir:

 1. Örnekler arasında çok fazla gereksiz bilgi vardır. SGD bu gereksiz hesaplamaların çoğunu önler.
 2. Erken aşamalarda gürültü, gradyandaki bilgilere kıyasla küçüktür. Bu nedenle, bir SGD adımı *neredeyse* bir GD adımı kadar iyidir.
 3. *Tavlama* - SGD güncellemesindeki gürültü, kötü (sığ) bir yerel minimumda yakınsamayı önleyebilir.
 4. Stokastik Gradyan İnişini hesaplamak büyük ölçüde daha ucuzdur (tüm veri noktalarının üzerinden geçmediğiniz için).

<!--
### Mini-batching

In mini-batching, we consider the loss over multiple randomly selected instances instead of calculating it over just one instance. This reduces the noise in the step update.

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$
-->

### Mini-gruplama

Mini gruplamada, tek bir örnek üzerinden hesaplamak yerine, rastgele seçilmiş birden çok örnek üzerindeki kaybı dikkate alırız. Bu adım güncellemesinde oluşan gürültüyü azaltır.

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$

<!--
Often we are able to make better use of our hardware by using mini batches instead of a single instance. For example, GPUs are poorly utilized when we use single instance training. Distributed network training techniques split a large mini-batch between the machines of a cluster and then aggregate the resulting gradients. Facebook recently trained a network on ImageNet data within an hour, using distributed training.

It is important to note that Gradient Descent should never be used with full sized batches. In case you want to train on the full batch-size, use an optimization technique called LBFGS. PyTorch and SciPy both provide implementations of this technique.
-->

Genellikle tek bir örnek yerine mini gruplar oluşturarak donanımımızı daha iyi kullanabiliriz. Örneğin, tek örnekli eğitim kullandığımızda GPU'lardan yetersiz faydalanılmaktadır. Dağıtılmış (distributed) ağlar için sunulan eğitim teknikleri, büyük bir mini grubu bir makine kümesine paylaştırır ve sonra ortaya çıkan gradyanları toplar. Facebook yakın zamanda dağıtılmış eğitim yöntemlerini kullanarak bir saat içinde ImageNet verileri ile bir ağ eğitmiştir.

Gradyan İnişin tam boyutlu gruplar ile hiçbir zaman kullanılmaması gerektiğini belirtmek önemlidir. Tam toplu boyutta eğitim yapmak istiyorsak, LBFGS adlı bir optimizasyon tekniğini kullanırız. PyTorch ve SciPy'da bu tekniğin uygulamaları bulunmaktadır.

<!--
## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

In Momentum, we have two iterates ($p$ and $w$) instead of just one. The updates are as follows:

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$
-->

## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

Momentum'da bir yerine iki adet her iterasyonda değeri değişen değer ($p$ ve $w$) vardır. Güncellemeler aşağıdaki gibidir:

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$

<!--
$p$ is called the SGD momentum. At each update step we add the stochastic gradient to the old value of the momentum, after dampening it by a factor $\beta$ (value between 0 and 1). $p$ can be thought of as a running average of the gradients. Finally we move $w$ in the direction of the new momentum $p$.
-->

$p$, SGD momentumu olarak adlandırılır. Her güncelleme adımında, stokastik gradyan $\beta$ çarpanıyla (0 ile 1 arasında bir değer) sönümlendikten sonra momentumun eski değerine eklenir. $p$ gradyanların sürekli hesaplanan ortalaması olarak düşünülebilir. Sonunda $w$ yeni momentum $p$ yönünde hareket ettirilir.

<!--
Alternate Form: Stochastic Heavy Ball Method

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

This form is mathematically equivalent to the previous form. Here, the next step is a combination of previous step's direction ($w_k - w_{k-1}$) and the new negative gradient.
-->

Alternatif Yapı: Stokastik Ağır Top Metodu

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

Bu yapı, matematiksel olarak önceki yapıyla eşdeğerdir. Burada bir sonraki adım, önceki adımın yönünün ($w_k - w_ {k-1}$) ve yeni negatif gradyanın birleşimidir.

<!--
### Intuition

SGD Momentum is similar to the concept of momentum in physics. The optimization process resembles a heavy ball rolling down the hill. Momentum keeps the ball moving in the same direction that it is already moving in. Gradient can be thought of as a force pushing the ball in some other direction.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Figure 3:</b> Effect of Momentum<br>
<b>Source:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

Rather than making dramatic changes in the direction of travel (as in the figure on the left), momentum makes modest changes. Momentum dampens the oscillations which are common when we use only SGD.

The $\beta$ parameter is called the Dampening Factor. $\beta$ has to be greater than zero, because if it is equal to zero, you are just doing gradient descent. It also has to be less than 1, otherwise everything will blow up. Smaller values of $\beta$ result in change in direction quicker. For larger values, it takes longer to make turns.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Effect of Beta on Convergence
</center>
-->

### Sezgisel Yaklaşım

SGD Momentum fizikteki momentum kavramına benzer. Optimizasyon süreci tepeden aşağı yuvarlanan ağır bir topa benzer. Momentum topu gittiği yönde devam edecek şekilde hareket ettirir. Gradyan ise topu başka bir yöne iten bir kuvvet olarak düşünülebilir.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Şekil 3:</b> Momentumun Etkisi<br>
<b>Source:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

Momentum gidişat yönünde (soldaki şekilde olduğu gibi) etkili değişiklikler yapmak yerine, mütevazı değişiklikler yapar. Momentum tek başına SGD kullandığımızda çoğunlukla karşımıza çıkan salınımları sönümler.

$\beta$ parametresine Sönümleme Faktörü denir. $\beta$ sıfırdan büyük olmalıdır, sıfıra eşit olursa sadece gradyan inişi yapmış oluruz. Ayrıca 1'den küçük olmalıdır, aksi takdirde her şey patlar. $\beta$ 'nın daha küçük değerleri, yönün daha çabuk değişmesine neden olur. Daha büyük değerler için güncellemenin başka yöne dönmesi daha uzun sürer.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Şekil 4:</b> Beta'nın Yakınsamadaki Etkisi
</center>

<!--
### Practical guidelines

Momentum must pretty much be always be used with stochastic gradient descent.
$\beta$ = 0.9 or 0.99 almost always works well.

The step size parameter usually needs to be decreased when the momentum parameter is increased to maintain convergence. If $\beta$ changes from 0.9 to 0.99, learning rate must be decreased by a factor of 10.


### Why does momentum works?


#### Acceleration

The following are the update rules for Nesterov's momentum.

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

With Nesterov's Momentum, you can get accelerated convergence if you choose the constants very carefully. But this applies only to convex problems and not to Neural Networks.

Many people say that normal momentum is also an accelerated method. But in reality, it is accelerated only for quadratics. Also, acceleration does not work well with SGD, as SGD has noise and acceleration does not work well with noise. Therefore, though some bit of acceleration is present with Momentum SGD, it alone is not a good explanation for the high performance of the technique.
-->

### Uygulama Yönergeleri

Momentum hemen hemen her zaman stokastik gradyan inişi ile birlikte kullanılmalıdır.
$\beta$ = 0.9 veya 0.99 neredeyse her zaman iyi çalışır.

Yakınsamayı sağlamak için momentum parametresi artırıldığında adım boyutu parametresinin genellikle azaltılması gerekir. $\beta$ 0,9'dan 0,99'a değiştirilirse, öğrenme oranı 10 kat azaltılmalıdır.

### Momentum neden çalışıyor?


#### Hızlandırma

Aşağıda Nesterov momentumu için güncelleme kuralları verilmiştir.

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

Nesterov Momentumu ile sabitleri çok dikkatli seçerseniz hızlandırılmış yakınsama elde edebilirsiniz. Ancak bu sadece dışbükey problemler için geçerlidir, sinir ağları için geçerli değildir.

Birçok insan normal momentumun da hızlandırılmış bir yöntem olduğunu söyler. Ancak gerçekte sadece ikinci derece fonksiyonlar için hızlandırma sağlanır. Ayrıca, SGD gürültüye sahip olduğundan ve hızlandırma gürültüyle iyi çalışmadığından hızlandırma SGD ile iyi çalışmaz. Bu nedenle Momentum SGD ile bir miktar hızlanma mevcut olsa da, bu durum tek başına tekniğin yüksek performansı için iyi bir açıklama değildir.

<!--
#### Noise smoothing

Probably a more practical and probable reason to why momentum works is Noise Smoothing.

Momentum averages gradients. It is a running average of gradients that we use for each step update.

Theoretically, for SGD to work we should take average over all step updates.

$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

The great thing about SGD with momentum is that this averaging is no longer necessary. Momentum adds smoothing to the optimization process, which makes each update a good approximation to the solution. With SGD you would want to average a whole bunch of updates and then take a step in that direction.

Both Acceleration and Noise smoothing contribute to high performance of momentum.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> SGD *vs.* Momentum
</center>

With SGD, we make good progress towards solution initially but when we reach bowl (bottom of the valley) we bounce around in this floor. If we adjust learning rate we will bounce around slower. With momentum we smooth out the steps, so that there is no bouncing around.
-->

#### Gürültü Yumuşatma

Momentumun çalışmasının muhtemelen daha pratik ve daha olası bir nedeni Gürültü Yumuşatmadır.

Momentum gradyanları ortalar. Her adım güncellemesinde sürekli çalışan ortalama bir gradyandır.

Teorik olarak, SGD'nin çalışması için tüm adım güncellemelerinin ortalamasını almalıyız.

$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

SGD'nin momentumla birlikte kullanılmasının en güzel yanı, bu ortalama hesaplamasının artık gerekli olmamasıdır. Momentum optimizasyon sürecine yumuşatma ekleyerek her güncellemeyi çözüme iyi bir yaklaşım haline getirir. SGD ile bir sürü güncellemeyi ortalamak ve daha sonra bu yönde bir adım atmak amaçlanır.

Hem Hızlanma hem de Gürültü yumuşatma, momentum ile yüksek performans elde etmeye katkıda bulunur.

<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Şekil 5:</b> SGD <i>vs.</i> Momentum
</center>

SGD ile başlangıçta çözüme doğru iyi bir ilerleme kaydediyoruz ancak kaseye (vadi tabanına) ulaştığımızda bu zeminin etrafında zıplıyoruz. Öğrenme hızını ayarlarsak, etrafında daha yavaş zıplarız. Momentum ile adımları yumuşatırız, böylece zemin etrafında zıplama olmaz.
