---
lang-ref: ch.03-1
title: Sinir Ağlarındaki Parametre Transformasyonunun Görselleştirilmesi ve Evrişimin Temel Konseptleri
lecturer: Alfredo Canziani
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
typora-root-url: 03-1
lang: tr
translation-date: 12 Jun 2020
translator: mevah
---


## [Sinir Ağlarının Görselleştirilmesi](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)
<!--
In this section we will visualise the inner workings of a neural network.
-->
Bu bölümde, sinir ağlarının içinde olanları görselleştireceğiz.
<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Şekil 1: Ağ Yapısı</center>
<!--
Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize.
-->
Şekil 1, görselleştirmek istediğimiz sinir ağının yapısını betimliyor. Genellikle bir sinir ağının yapısını çizdiğimizde, girdileri aşağıda ya da solda; çıktıları yukarıda ya da sağda gösteririz. Figür 1'de, pembe nöronlar girdileri, mavi nöronlar ise çıktıları gösteriyor. Bu ağda, 4 adet saklı katman var (yeşiller), yani toplamda 6 tane katman var (4 saklı katman + 1 girdi katmanı + 1 çıktı katmanı). Bu örnekte, her gizli katmanda 2'şer nöron var, yani ağırlık matrisi ($W$)nın boyutu her katmanda 2 ye 2. Bunun nedeni ise giriş düzlemini görselleştirebileceğimiz bir düzleme dönüştürebilmek istememiz.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Şekil 2: Katlanma uzayının görüntülenmesi</center>

<!--
The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$.
-->
Her katmanın dönüşümü (transformation), Şekil 2'de gösterildiği gibi, düzlemimizi belli yerlerinden katlamaya benziyor. Bu katlamalar çok keskin, çünkü bütün dönüşümler 2 boyutlu katmanda gerçekleşiyor. Deney sonucunda şunu fark ediyoruz ki eğer saklı katmanda sadece 2 nöron olursa, optimizasyon daha uzun sürüyor; eğer saklı katmanda daha çok nöron olursa optimizasyon kolaylaşıyor. Bu da aklımıza şu soruyu getiriyor: Neden saklı katmanında daha az nöron olan bir ağı eğitmek daha zor? Bu soruyu kendi kendinize düşünmelisiniz, $\texttt{ReLU}$'nun *(rectified linear unit, düzeltilmiş lineer birim)* görselleştirmesinden sonra buna geri döneceğiz.

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|
<center>Şekil 3: ReLU operatörünün görselleştirilmesi</center>
<!--
When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4.
-->

Ağın her saklı katmanına teker teker baktığımızda, her katmanın önce bir afin *(affine, ilgin	)* dönüşüm sonrasında lineer olmayan ReLU operasyonu yaptığını görüyoruz, ReLU operasyonu negatif değerleri yok ediyor. Şekil 3(a) ve (b) de, ReLU operatörünün nasıl göründüğünü görebiliriz. ReLU operatorü lineer olmayan dönüşümler yapmamıza yarar. Çok sayıda afin dönüşüm uygulayıp sonrasında ReLU operatörünü uyguladığımızda, Şekil 4'te de görülebileceği gibi veriyi lineer olarak doğrular ile ayırmayı başarabiliyoruz.

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Şekil 4: Çıktıların Görselleştirilmesi</center>

<!--
This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - i.e. adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned.
-->
Bu bize neden 2 nöronlu saklı katmanların daha zor eğitildiği hakkında fikir veriyor. 6 katmanlı ağımızın her saklı katmanında birer yanlılığı *(bias)* var. Bu nedenle eğer bu yanlılıkların herhangi biri sağ üstteki çeyrek düzlemin dışında bir yere işaret ediyorsa, ReLU operatörü bu noktaları sıfırlayacaktır. Sonrasında, ne kadar ileride olursa olsun, katmanların veriye yapacağı dönüşümler sonrasında bu noktalar sıfır kalmaya devam edecektir. Bir sinir ağını daha "şişman" yaparak (saklı katmanlara daha çok nöron ekleyerek) daha kolay eğitilmesini sağlayabiliriz, ya da daha çok saklı katman ekleyebiliriz, ya da bu iki yöntemin bir kombinasyonunu kullanabiliriz. Beklemeyin ve görün, bu ders boyunca bize verilen probleme göre en iyi ağ yapısının ne olduğuna karar vermeyi keşfedeceğiz.

## [Parametre dönüşümleri (Parameter Transformations)](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)
<!--
General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows,
-->
Genel olarak parametre dönüşümü, parametre vektörü $w$'nin bir fonksiyonun sonucu olduğu anlamına gelir. Bu dönüşüm ile, orijinal parametre uzayını başka bir uzaya eşleştirebiliriz. Şekil 5'teki $w$, $H$nin $u$ parametresiyle olan halinin çıktısı. $G(x,w)$ bir ağ ve $C(y,\bar y)$ bir maliyet fonksiyonu. Geri yayılım *(backpropagation)* formülü
$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$
şeklinde yazılabilir.
<!--
These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent.
-->
Bu formüller matris formunda uygulanırlar. Terimlerin boyutlarının birbirine uyması gerektiğine dikkat edelim. $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ , sırayla  $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$ boyutlarına sahip. Bu nedenle geri yayılım formülümüzün boyutları birbiriyle uyuşuyor.

<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Şekil 5: Parametre Dönüşümlerinin Genel Formu</center>


### Kolay bir parametre dönüşümü: Ağırlık Paylaşma
<!--
A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as,
-->
Ağırlık paylaşma dönüşümü, $H(u)$ 'nun, $u$'nun bir bileşenini $w$'nın birden çok bileşenine kopyaladığı anlamına gelir. $H(u)$, $u_1$'i, $w_1$, $w_2$'ye kopyalayan bir **Y** kısmı gibi. Bunu şu şekilde ifade edebiliriz:
$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$
<!--
We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$.
-->
Paylaşılan parametrelerin eşit olmasını zorunlu kılıyoruz, böylece paylaşılan parametlere göre alınan gradyan (eğim), geri yayılımda toplanmış olacak. Örneğin maliyet fonksiyonu $C(y, \bar y)$ 'nun $u_1$'a göre gradyanı, $C(y, \bar y)$'nın $w_1$ 'a göre olan gradyanı ve $C(y, \bar y)$'nın $w_2$'ye göre olan gradyanının toplamına eşit olacak.

### Hiperağ (Hypernetwork)
<!--
A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful.
-->
Bir ağın ağırlıkları diğer ağın çıktısı ise buna hiperağ adı verilir. Şekil 6 bir "hiperağ"ın hesaplama grafiğini gösteriyor. Burada $H$ fonksiyonu, $u$ parametre vektörüne ve $x$ girdisine sahip bir ağ. Sonucunda, $G(x,w)$'nin ağırlıkları $H(x,u)$ ağı tarafından dinamik olarak ayarlanıyor. Bu eski bir fikir olsa da hala çok güçlü olan bir fikir.
<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Şekil: 6 "Hiperağ"</center>


### Sıralı verilerde motifler bulma
<!--
Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (i.e. a particular sound in speech signal), and the outputs (i.e. a score) goes into a maximum function.
-->
Ağırlık paylaşımı dönüşümü, motif bulmaya uygulanabilir. Motif bulma, konuşma ya da yazı gibi sıralı verilerdeki motifleri bulma anlamına gelir. Bunu yapmanın bir yolu, Şekil 7'de görüldüğü gibi, verinin üzerinden bir pencere kaydırmak, bu da ağırlık paylaşma fonksiyonunu belli bir motifi bulması için kaydırıyor (örn. bir konuşma sinyali içindeki belli bir ses), böylece çıktılar (örn. bir skor) maksimum fonksiyonuna doğru gidiyor.
<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Şekil: 7 Sıralı Verilerde Motifler Bulma</center>
<!--
In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient.
-->
Bu örnekte bu fonksiyonlardan elimizde 5 adet var. Bu sonuca göre, beş gradyanı topluyoruz ve hatayı geri yayılım yapıp $w$ parametresini güncelliyoruz. Bunu PyTorch'ta kodlarken, bu gradyanların dolaylı olarak yığılmasını önlemeliyiz, bu yüzden gradyanların ilk değerlerini atamak için `zero_grad()`'ı kullanmalıyız.

### Resimlerde motifler bulma
<!--
The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C".
-->
Motif bulmanın diğer bir yararlı uygulaması resimlerde motif bulma. Resimlerin üzerinden "şablon"ları kaydırarak, yer ve bozukluklarından bağımsız olarak şekilleri bulabiliriz. Şekil 8'de görüldüğü gibi, "C" ile "D" yi ayırt etmek basit bir örnek. "C" ile "D" arasındaki fark, "C" nin iki ucunun, "D"nin iki köşesinin olması. Böylelikle "uç şablonları" ve "köşe şablonları" tasarlayabiliriz. Eğer önümüzdeki şekil "şablon"lara benziyorsa, eşikte olan çıktılar verecek. Böylece bu çıktıları toplayarak harfleri ayırt edebiliriz. Şekil 8'de, ağ iki adet uç ve sıfır köşe buluyor, böylece "C"yi aktive ediyor.
<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Şekil 8: Resimlerde motifler bulma</center>

<!--
It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (i.e. the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection.
-->
"Şablon eşleştirme"mizin kaydırma ile değişmez olması da önemli - yani girdiyi kaydırdığımızda, çıktı (örn. bulunan harf) değişmemeli. Bu ağırlık paylaşma transformasyonuyla çözülebilir. Şekil 9'da da görüldüğü gibi, "D"nin yerini değiştirdiğimizde, kaydırılmış olmalarına rağmen hala köşe motiflerini algılayabiliyoruz. Bu motifleri topladığımızda, toplam "D" harfini algılayacak şekilde ağı aktive edecek.
<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Şekil 9: Kayma Değişmezliği *(Shift Invariance)*</center>

<!--
This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates".
-->
Bu elle oluşturulmuş, yerel dedektörleri kullanıp toplamı ile rakamı algılama metodu senelerdir kullanılıyor. Ama bize şöyle bir problem sunuyor: Bu "şablon"ları nasıl otomatik olarak dizayn edebiliriz? Sinir ağlarını bu "şablon"ları öğrenmek için kullanabilir miyiz? Sırada, **evrişim** konsepti var, bu da resimleri "şablonlar" ile eşleştirmek için kullandığımız operasyon.

## Ayrık zamanlı evrişim *(Discrete convolution)*


### Evrişim *(Convolution)*
<!--
The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is:
-->
Tek boyutlu düzlemde, girdi $x$ ile, $w$ arasındaki evrişimin tam olarak matematiksel tanımı şu şekildedir:
$$y_i = \sum_j w_j x_{i-j}$$
<!--
In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted.
-->
Kelimelerle ifade edersek, $i$'nci çıktı, **ters çevrilmiş** $w$ ile $x$ boyutundaki bir pencerenin arasındaki iç çarpım ile hesaplanabilir. Bütün çıktıyı hesaplamak için, pencere en baştan başlar, $x$ tamamlanana kadar bu pencere birer girdi kaydırılır ve bu şekilde tekrar edilir.

### Çapraz korelasyon (Cross-correlation)
<!--
In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**:
-->
Pratikte, derin öğrenme alanındaki PyTorch gibi yazılımlarda kabul edilen tanım biraz farklıdır. Evrişim, PyTorch'ta $w$nin **ters çevrilmemiş** hali ile kodlanmıştır:
$$y_i = \sum_j w_j x_{i+j}$$
<!--
Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.
Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts.
-->
Matematikçiler bu formülasyona "çapraz korelasyon" derler. Bizim bağlamımımızda, bu fark sadece bir kural farkıdır. Pratik olarak çapraz korelasyon ve evrişim, bilgisayar hafızasındaki ağırlıkları baştan sona ya da sondan başa okuyarak, birbiri yerine kullanılabilir.
Bunun farkında olmak önemlidir, mesela biri matematiksel bir makale üzerinden evrişim/korelasyon'un özelliklerinden faydalanmak isterse bunu göz önüne almalıdır.

### Yüksek boyutlarda evrişim
<!--
For two dimensional inputs such as images, we make use of the two dimensional version of convolution:
-->
Resimler gibi iki boyutlu girdilerde iki boyutlu evrişimden yararlanırız:

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$
<!--
This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel*
-->
Bu tanım, iki boyuttan üç ve dört boyuta da kolayca taşınabilir. Bu tanımda $w$'ye evrişim çekirdeği *(convolution kernel)* adı verilir.

### DCNN'lerde evrişim operatörüyle yapılabilecek değişiklikler
<!--
1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).
Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:
-->
1.**Adım Kaydırmak** *(striding)*: Pencereyi her seferinde $x$ üzerinde bir girdi kaydırmak yerine, daha büyük adımlarla da yapabiliriz (örneğin her seferinde iki ya da üç girdi kaydırmak gibi).
Örnek: Farz edelim ki $x$ tek boyutlu ve 100 boyutunda, $w$ de 5 boyutunda olsun. *(Stride)* 1 ve 2 ile olacak çıktı aşağıdaki tabloda gösterilmiştir:

| Adım         | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Çıktı boyutu:| $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |


<!--
2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable.
-->
2. **Dolgulama** *(padding)*: Derin Sinir Ağlarını dizayn ederken çoğu zaman evrişimdeki çıktının girdiyle aynı boyutta olmasını isteriz. Bunu girdinin iki tarafını da (genelde) sıfırlarla doldurarak yapabiliriz. Dolgulama çoğunlukla kolaylık olsun diye yapılır. Bazen performansı etkileyebilir, kenarlarda tuhaf efektlere yol açabilir; ama ReLU aktivasyonu kullanıldığında sıfırla dolgulama mantıksız değildir.

## Derin Evrişimli Sinir Ağları (DCNNs)
<!--
As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.
The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties.
Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world.
-->
Daha önceden de açıklandığı gibi, derin sinir ağları genelde tekrar tekrar birbirini takip eden lineer operatörler ve noktasal olarak lineer olmayan *(pointwise nonlinear)* katmanlardan oluşturulur. Evrişimli sinir ağlarında, bu lineer operatör, yukarda açıklanan evrişim operatörüdür. Bir de üçüncü bir katman çeşidi olan örnekleme *(pooling)* katmanı vardır.

Bu şekilde katmanları üst üste dizmemizin sebebi verinin hiyerarşik bir gösterimini oluşturmak istememizdir. CNN'ler sadece resimleri değil, konuşma ve dil verilerini de başarıyla işleyebilirler. Teknik olarak dizi *(array)* şeklinde olan herhangi bir veriye uygulanabilirler, yine de bu diziler belli özelliklere sahip olmalıdır.

Neden dünyanın hiyerarşik bir gösterimini oluşturmak istiyoruz? Çünkü üstünde yaşadığımız dünya birleşimsel bir yapı. Önceki bölümlerde de bunu ima etmiştik. Bu hiyerarşik yapı, yakın piksellerin birleşerek yönlü kenarlar gibi basit motifler oluşturduğu gerçeğinden anlaşılabilir. Bu kenarlar da birleşerek yerel çapta köşeler, T-kesişim noktaları gibi özellikleri oluştururlar. Bu köşeler birleşerek daha da soyut olan motifleri oluşturur. Böyle hiyerarşik şekilde inşa etmeye devam ederek sonuçta gerçek hayattaki objeleri oluşturmuş oluruz.

<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Şekil 10: Imagenet verisi üzerinde eğitilmiş evrişimli ağın öznitelik görselleştirilmesi [Zeiler & Fergus 2013]</center>
<!--
This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.
The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in:
> The most incomprehensible thing about the universe is that it is comprehensible.
The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:
> The world is compositional or God exists.
-->
Dolayısıyla doğada gözlemlediğimiz bu hiyerarşik ve birleşimsel yapı, sadece bizim görsel algımızın bir sonucu değil, fiziksel seviyede de doğru bir şey. En basit haliyle tanımlarsak, elimizde basit partiküller var, bunlar birleşerek atomları, atomlar birleşerek molekülleri oluşturuyorlar; bu şekilde ilerleyerek materyalleri, objelerin kısımlarını ve sonuçta da gerçek hayattaki bir objenin tamamını oluşturuyoruz.

Dünyanın bu birleşimsel yapısı, Einstein'ın insanların yaşadıkları dünyayı nasıl anladıkları ile ilgili retorik sorusunun cevabı olabilir:

> Evrenle ilgili en anlaşılmaz şey anlaşılabilir olmasıdır.

Yann'a göre, bu birleşimsel yapı sayesinde dünyanın insanlar tarafından anlaşılabilir olması hala bir komplo teorisi gibi duruyor. Yine de tartışılır, birleşme olmadan, insanların yaşadıkları dünyayı anlamaları için çok daha fazla sihir olması gerek. Büyük matematikçi Stuart Geman'ın sözleri ile:
> Ya dünya birleşimsel ya da Tanrı var.

## [Biyolojiden İlhamlar](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)
<!--
So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next:
-->
Peki neden Derin Öğrenme, dünyamızın anlaşılabilir ve birleşimsel bir yapısı olduğu fikrinin üzerine kurulmuş olmak zorunda olsun? Simon Thorpe'un araştırması bunu motive etmeye daha da yardımcı oldu. Araştırma etrafımızdaki objeleri aşırı hızlı tanıdığımızı gösterdi. Thorpe deneylerinde insanlara her 100ms'de bir resim göstererek onların resmin ne olduğunu söylemelerini istedi, ve insanlar da bunu başarıyla gerçekleştirdiler. Bu da onların objelerin ne olduğunu 100ms gibi bir sürede anladığını gösterdi. Buna ek olarak, aşağıdaki diyagramda beyinin bir bölgesinden diğerine ne kadar sürede nöronlarla iletim olduğunu görebilirsiniz:
<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<div align="center">Şekil 11: Simon Thorpe'un beyindeki görsel bilgi akışı modeli <div>
<!--
Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.
Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process.
These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.
One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways:
-->
Sinyaller retinadan LGN'ye (konstrast artırımı, kontrol gibi konularda yardımcı bölüm), sonra da V1 primer görme korteksi, V2, V4 ve sonrasında inferotemporal kortekse (PIT), yani beyinde kategorilerin tanımlandığı yere iletilir. Açık beyin ameliyatlarındaki gözlemlerin gösterdiğine göre, bir insana film izletildiğinde, PIT'deki nöronlar sadece belli görseller algılandığında ateşleniyorlar --Jennifer Aniston ya da kişi anneannesini gördüğünde-- ve diğer hiçbir görselde bu olmuyor. Nöronların ateşlenmesi, pozisyon, boyut, ışıklandırma gibi şeylerle, anneannenizin hangi yöne baktığı, ya da ne giydiğiyle de değişmiyor.
<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<div align="center">Şekil 12: Gallen & Van Essen'in beyne giden dorsal ve ventral yol modeli <div>

<!--
The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course).
-->
Sağ kısım ventral yolu gösteriyor, yani size neye baktığınızı söyleyen şey. Sol kısım dorsal yolu gösteriyor, yani yeri, geometriyi ve hareketi algılayan şey. İnsan ve primat görsel kortekslerinde bu yollar ayrı gibi gözüküyorlar (tabii aralarında birkaç etkileşim olsa da).

### Hubel & Weisel'in katkıları (1962)

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<div align="center">Şekil 13: Hubel & Weisel'in kedi beynindeki görsel uyarıcılarla olan deneyleri <div>
<!--
Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.
They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions".
Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input.
-->
Hubel ve Weisel, kedi beyninin görsel uyarıcılara verdiği nöron ateşlemelerini ölçmek için deneylerinde elektrotları kullandılar. V1 bölgesindeki nöronların görsel alandaki yalnızca belli alanlara duyarlı olduğunu keşfettiler ("reseptif alanlar", *receptive fields*), ve o alanlarda nöronların yönlü kenarlar algıladığını fark ettiler. Örneğin, kediye dik duran bir sopa gösterip sopayı döndürmeye başlarsanız, belli bir açıda nöronlar ateşlenir. Benzer olarak o açıdan uzaklaştıkça o nörondaki aktivasyon da azalır. Hubel ve Weisel bu aktivasyonlara duyarlı nöronlara yerel özellikleri algılayabildikleri için "basit hücreler" adını verdiler.

Eğer sopayı reseptif alandan çıkarırsanız, önceki nöronun artık ateşlenmediğini, ama farklı bir nöronun ateşlendiğini keşfettiler. Görsel alanın her yerine denk gelen yerel özellik algılayıcıları vardır, insan beyninin de görsel bilgiyi "evrişim" koleksiyonlarından ibaret olarak işlediği fikri de burdan gelir.

Hubel ve Weisel'in "karmaşık hücreler" diye adlandırdığı, diğer bir nöron türü ise, belli alandaki birden fazla basit hücrenin çıktısını biriktirir. Bu hücreleri, aktivasyonların birikmiş hallerini hesaplıyor gibi düşünebiliriz, maksimum, toplam, kareler toplamı, ya da sıraya bağlı olmayan herhangi bir diğer fonksiyon kullanarak. Bu karmaşık hücreler bir alandaki kenarları ve yönlenmeleri, uyarıcının tam olarak nerede olduğuna bağlı kalmadan algılarlar. Diğer bir deyişle girdinin pozisyonundaki küçük değişikliklere karşı kayma değişmezliğine sahiptirler *(shift invariance)*.

### Fukushima'nın katkıları (1982)

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<div align="center">Şekil 14: Fukushima'nın CNN modeli <div>
<!--
Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.
Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.)
-->

Fukushima, basit ve karmaşık hücrelerin birden fazla katmanla bilgisayar modellerinde kodlanması fikrinin ilk sahibiydi, ve bunun için elle yazılmış rakam verilerini kullandı. Bu öznitelik algılayıcılarının bazıları özel olarak oluşturulmuş ve öğrenilmişti; ama denetimsiz *(unsupervised)* öbekleme *(clustering)* algoritmalarını kullanıyordu, her katman için ayrı ayrı eğitiliyordu ve geri yayılım da henüz kullanımda değildi.

Yann LeCun birkaç sene sonra aynı yapıyı kurdu, ama bu sefer denetimli *(supervised)* olarak geri yayılımla eğitti. Bu, evrişimli sinir ağlarının başlangıcı sayılmaktadır.
(Not: Riesenhuber MIT'de 1999'da bu yapıyı tekrardan keşfetti fakat geri yayılımı kullanmadı.)
