---
lang-ref: ch.02-1
lang: tr
lecturer: Yann LeCun
title: Gradyan İnişi ve Geri Yayılım Algoritmalarına Giriş
authors: Amartya Prasad, Dongning Fang, Yuxin Tang, Sahana Upadhya
date: 3 Feb 2020
translation-date: 6 Sep 2020
translator: İrem Demirtaş
---


<!-- ## [Gradient Descent optimization algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)


### Parametrised models

$$
\bar{y} = G(x,w)
$$

Parametrised models are simply functions that depend on inputs and trainable parameters. There is no fundamental difference between the two, except that trainable parameters are shared across training samples whereas the input varies from sample to sample. In most deep learning frameworks, parameters are implicit, that is, they aren't passed when the function is called. They are 'saved inside the function', so to speak, at least in the object-oriented versions of models.

The parametrised model (function) takes in an input, has a parameter vector and produces an output. In supervised learning, this output goes into the cost function ($C(y,\bar{y}$)), which compares the true output (${y}$) with the model output ($\bar{y}$). The computation graph for this model is shown in Figure 1.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>Figure 1: Computation Graph representation for a Parametrised Model </center>|

Examples of parametrised functions -

- Linear Model - Weighted Sum of Components of the Input Vector :

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

- Nearest Neighbor - There is an input $\vect{x}$ and a weight matrix $\matr{W}$ with each row of the matrix indexed by $k$. The output is the value of $k$ that corresponds to the row of $\matr{W}$ that is closest to $\vect{x}$:

  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  Parameterized models could also involve complicated functions. -->

## [Gradyan İnişi Optimizasyon Algoritması (Gradient Descent optimization algorithm)](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)


### Parametrik Modeller

$$
\bar{y} = G(x,w)
$$

Basit bir şekilde, parametrik modeller girdilere ve eğitilebilir parametrelere bağlı olan modellerdir. İkisi arasında eğitilebilen parametreler eğitim örnekleri arasında paylaşılırken, girdilerin örnekten örneğe değişmesi dışında bir fark yoktur. Çoğu derin öğrenme küyüğhanesinde parametreler üstü kapalıdır, yani fonksiyon çağrıldığında argüman olarak verilmez. Modellerin obje yönelimli versiyonlarında "fonksiyonun içine kaydedilmiş" olduklarını söyleyebiliriz.

Parametrik model bir girdi alır, bir parametre vektörüne sahiptir ve bir çıktı üretir. Denetimli öğrenmede bu girdi gerçek çıktıyla (${y}$) model tarafından üretilen çıktıyı ($\bar{y}$) karşılaştıran maliyet fonksiyonuna girer. Bu model için hesaplama çizgesi Fig. 1'de gösterilmektedir.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>Fig. 1: Parametrik Model için Hesaplama Çizgesii Gösterimi </center>|

Parametrik fonksiyonlara örnekler -
- Lineer model - Girdi vektörünün elemenlarının ağırlıklı toplamı

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

- En yakın komşu - Girdi $\vect{x}$ ve satırları $k$ ile indekslenen ağırlık matrisi $\matr{W}$ bulunur. Çıktı $\matr{W}$ matrisinin $\vect{x}$ vektörüne en yakın satırının $k$ değeridir.
  
  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  Parametrik modeller daha karmaşık fonksiyonları da içerebilir.

<!-- #### Block diagram notations for computation graphs

- Variables (tensor, scalar, continuous, discrete)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> is an observed input to the system
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> is a computed variable which is produced by a deterministic function

- Deterministic functions

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - Takes in multiple inputs and can produce multiple outputs
    - It has an implicit parameter variable (${w}$)
    - The rounded side indicates the direction in which it is easy to compute. In the above diagram, it is easier to compute ${\bar{y}}$ from ${x}$ than the other way around

- Scalar-valued function

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - Used to represent cost functions
    - Has an implicit scalar output
    - Takes multiple inputs and outputs a single value (usually the distance between the inputs)
 -->

#### Hesaplama Çizgeleri için Blok Diyagramı Notasyonları

- Değişkenler (tensör, skaler, sürekli, ayrık)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> sistemin gözlemlenen girdisi
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> deterministik bir fonksiyon tarafından üretilen bir hesaplanmış değişken.

- Deterministik fonksiyonlar

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - Birden fazla girdi alır ve birden fazla çıktı üretir
    - Üstü kapalı bir parametre değişkeni vardır (${w}$)
    - Yuvarlanan taraf hesaplaması kolay olan yönü gösterir. Yukarıdaki diyagramda ${\bar{y}}$'nin ${x}$'ten hesaplanması aksi yönden daha kolaydır.

- Skaler değerli fonksiyon

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - Maliyet fonksiyonlarını göstermek için kullanılır
    - Üstü kapalı bir skaler çıktısı vardır
    - Birden fazla girdi alır ve tek bir çıktı verir (genellikle girdiler arası uzaklık)

<!-- #### Loss functions

Loss function is a function that is minimized during training. There are two types of losses:

1) Per Sample Loss -
$$
 L(x,y,w) = C(y, G(x,w))
$$
2) Average Loss -

​	For any set of Samples $$S = \{(x[p],y[p]) \mid p=0,1...P-1 \}$$

​	Average Loss over the Set S is given by :  $$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>Figure 2: Computation graph for model with Average Loss    </center>|

In the standard Supervised Learning paradigm, the loss (per sample) is simply the output of the cost function. Machine Learning is mostly about optimizing functions (usually minimizing them). It could also involve finding Nash Equilibria between two functions like with GANs. This is done using Gradient Based Methods, though not necessarily Gradient Descent. -->

#### Kayıp Fonksiyonu

Kayıp fonksiyonu eğitim süresince azaltılan bir fonksiyondur. İki tür kayıp vardır:

1) Örnek başına kayıp -
$$
 L(x,y,w) = C(y, G(x,w))
$$
2) Ortalama kayıp -

​	Tüm örnek kümeleri için $$S = \{(x[p],y[p]) \mid p=0,1...P-1 \}$$

​	Küme için hesaplanan ortalama kayıp şu şekilde verilir :  $$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>Fig. 2: Ortalama kayıplı model için hesaplama çizgesi </center>|


Standart denetimli öğrenme paradigmalarında (örnek başına) kayıp basitçe maliyet fonksiyonunun çıktısıdır. Makine öğrenmesi büyük oranda fonksiyonların optimize edilmesidir (genellikle azaltılması). GAN'lerde (Generative Adverserial Network) olduğu gibi Nash dengesini bulmayı da içerebilir. Bu, mutlaka gradyan inişi olmamakla beraber, gradyan temelli metotlarla yapılır.

### Gradyan İnişi

Bir **Gradyan Temelli Metot**, fonksiyonun gradyanının basit bir şekilde hesaplanacağı varsayılırsa, bir fonksiyonun minimasını bulan metot/algoritmadır. Fonksiyonun sürekli ve neredeyse her yerde türevlenebilir (her yerde türevlenebilir olmak zorunda değil) olduğunu varsayar.

**Gradyan İnişi Sezgisi** - Sisli bir gecede bir dağın ortasında olduğunuzu hayal edin. Aşağıdaki köye gitmek istediğinizden ve kısıtlı görüşe sahip olduğunuzdan, yakınınıza bakıp en dik inişi bulup o yönde aşağı doğru adım atarsınız.

**Gradyan İnişi için Farklı Metotlar**

- Tam (yığın) gradyan inişi güncelleme kuralı :
  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$

- SGD (Stokastik Gradyan İnişi, Stochastic Gradient  Descent) için güncelleme kuralı şu hale gelir :
  - Pick a $p$ in $\text{0...P-1}$, then update
    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$

Burada $${w}$$ optimize edilecek parametreyi gösterir.

$\eta \text{ burada sabit, ama daha sofisyike algoritmalarda bir matris olabilir.}$.

Eğer bu bir pozitif yarı-tanımlı matrisse, yine de aşağı doğru ilerleriz, ancak mutlaka en dik iniş yönünü takip etmeyiz. Hatta inmek istediğimiz yön her zaman en dik inişin yönü olmayabilir.

Eğer fonksiyon türevlenebilir değilse, yani merdiven gibiyse, içinde bir delik varsa ya da düzse, gradyan inişi bize bir bilgi vermez ve diğer metotları kullanırız. Bunlara Sıfırıncı Derece Metotlar ya da Gradyansız Metotlar denir. Derin öğrenme tamamen gradyan temelli metotlarla ilgilidir.

Ancak RL (Pekiştirmeli Öğrenme, Reinforcement Learning) gradyanın açık formu olmadan **Gradyan Tahmini**ni içerir. Buna örnek olarak robotun düşe kalka bisiklet sürmeyi öğrenmeye çalışması verilebilir. Amaç fonksiyonu bisikletin düşmeden ne kadar süre dik kalabildiğini ölçer. Ne yazık ki amaç fonksiyonu için bir gradyan yoktur. Robotun farklı şeyler denemesi gerekir.

RL maliyet fonksiyonu çoğu zaman türevlenebilir değildir ama çıktıyı hesaplayan ağ gradyan temellidir. Denetimli öğrenmeyle pekiştirmeli öğrenme arasındaki ana fark budur. İkincisinde maliyet fonksiyonu C türevlenebilir değildir, hatta tamamen bilinmezdir. Sadece, adeta bir kara kutu gibi, bir girdi verildiğinde bir çıktı üretir. Bu onu fazlasıyla verimsiz hale getirir ve bu RL'deki temel engellerden biridir -özellikle parametre vektörü yüksek boyutlu olduğunda (bu aranacak dev bir çözüm uzayı olduğunu ima eder ve nereye hareket edileceğinin bulunmasını zorlaştırır). 

RL'de en popüler yöntemlerden biri Aktör Kritik Metotlardır. Bir kritik metodu basitçe eğitilebilir ve bilinen ikinci bir C modülüne sahiptir. C modülü türevlenebilirdir ve maliyet/ödül fonksiyonunu yaklaşık olarak hesaplamak için eğitilebilir. Ödül negatif maliyettir ve daha çok bir cezadır. Bu maliyet fonksiyonunu türevlenebilir yapabilmenin, ya da en azından geri yayılımın kullanılabilmesi için türevlenebilir bir fonsiyonla yaklaşmanın, bir yoludur. 

<!-- ## [Advantages of SGD and backpropagation for traditional neural nets](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)


### Advantages of Stochastic Gradient Descent (SGD)

In practice, we use stochastic gradient to compute the gradient of the objective function w.r.t the parameters. Instead of computing the full gradient of the objective function, which is the average of all samples, stochastic gradient just takes one sample, computes the loss, $L$, and the gradient of the loss w.r.t the parameters, and then takes one step in the negative gradient direction.

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

In the formula, $w$ is approached by $w$ minus the step-size, times the gradient of the per-sample loss function w.r.t the parameters for a given sample, ($x[p]$,$y[p]$).

If we do this on a single sample, we will get a very noisy trajectory as shown in Figure 3. Instead of the loss going directly downhill, it’s stochastic. Every sample will pull the loss towards a different direction. It’s just the average that pulls us to the minimum of the average. Although it looks inefficient, it’s much faster than batch gradient descent at least in the context of machine learning when the samples have some redundancy.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>Figure 3: Stochastic Gradient Descent trajectory for per sample update </center>|


In practice, we use batches instead of doing stochastic gradient descent on a single sample. We compute the average of the gradient over a batch of samples, not a single sample, and then take one step. The only reason for doing this is that we can make more efficient use of the existing hardware  (i.e. GPUs, multicore CPUs) if we use batches since it's easier to parallelize. Batching is the simplest way to parallelize. -->

## [SGD'nin Avantajları ve Geleneksel Sinir Ağları İçin Geri Yayılım](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)

### Stokastik Gradyan İnişinin Avantajları (Stochastic  Gradient Descent, SGD)

Pratikte amaç fonksiyonunun parametrelere göre gradyanını hesaplamak için stokastik gradyan inişini kullanırız. Amaç fonksiyonun tüm gradyanını hesaplamaktansa (tüm örneklerin ortalaması), stokastik gradyan inişi bir örnek için kaybı ve gradyanı hesaplar ve gradyanın negatif yönünde adıma atar.

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

Formülde $w$'ya $w$ eksi adım büyüklüğü çarı örnek başına kayıp fonksiyonu gradyanı ile yaklaşılır, ($x[p]$,$y[p]$).

Bunu tek bir örnek için yaparsak Fig. 3'te görüldüğü gibi gürültülü bir yörünge elde ederiz. Kayıp direkt olarak aşağı doğru gitmektense stokastik bir şekilde gider. Her örnek kaybı farklı bir yöne yönlendirecektir. Bizi ortalamanın minimumuna ulaştıran ortalamadır. Her ne kadar verimsiz görünse de makine öğrenmesi bağlamında örnekler fazlalık içerdiğinde yığın gradyan inişinden daha hızlıdır.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>Fig. 3: Örnek başına güncelleme için stokastik gradyan inişi yörüngesi </center>|


Pratikte tek bir örnek yerine bir yığın örnek kullanarak stokastik gradyan inişini kullanırız. Bir örnek yerine bir yığın için ortalama gradyanı hesaplayıp bir adım atarız. Bunu yapmamızın sebebi yığınları kullandığımızda paralelleştirmenin daha kolay olması ve elimizdeki donanımı daha verimli kullanmaktır (i.e. GPU, çok çekirdekli CPU). 

<!-- ### Traditional neural network

Traditional Neural Nets are basically interspersed layers of linear operations and point-wise non-linear operations. For linear operations, conceptually it is just a matrix-vector multiplication. We take the (input) vector multiplied by a matrix formed by the weights. The second type of operation is to take all the components of the weighted sums vector and pass it through some simple non-linearity (i.e. $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …).

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>Figure 4: Traditional Neural Network             </center>|

Figure 4 is an example of a 2-layer network, because what matters are the pairs (i.e linear+non-linear). Some people call it a 3-layer network because they count the variables. Note that if there are no non-linearities in the middle, we may as well have a single layer because the product of two linear functions is a linear function.

Figure 5 shows how the linear and non-linear functional blocks of the network stack:

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>Figure 5: Looking inside the linear and non-linear blocks   </center>|

In the graph, $s[i]$ is the weighted sum of unit ${i}$ which is computed as:

$$
s[i]=\Sigma_{j \in UP(i)}w[i,j]\cdot z[j]
$$

where $UP(i)$ denotes the predecessors of $i$ and  $z[j]$ is the $j$th output from the previous layer.

The output $z[i]$ is computed as:

$$
z[i]=f(s[i])
$$

where $f$ is a non-linear function. -->

### Geleneksel Sinir Ağı


Geleneksel sinir ağları serpiştirilmiş doğrusal ve noktasal doğrusal olmayan işlemlerden oluşan katmanlardır. Doğrusal işlemler için, kavramsal olarka sadece bir matris çarpımıdır. Girdi vektörünü ağırlık matrisiyle çarparız. İkinci tür işlem vektörlerin ağırlıklı toplamını alıp basit bir doğrusal olmayan fonksiyondan geçirmektir (i.e. $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …). 

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>Fig 4: Geleneksel sinir ağı             </center>|


Fig. 4 iki katmanlı bir ağa örnektir, çünkü önemli olan çiftlerdir (yani doğrusal ve doğrusal olmayan). Bazıları değişkenleri de sayarak bu ağa üç katmanlı der. Orta katmanda hiçbir doğrusal olmayan fonksiyon yoksa bu ağa tek katmanlı ağ diyebiliriz, çünkü bu durumda sadece iki doğrusal fonksiyonun çarpımı yine bir doğrusal fonksiyondur.

Fig. 5 ağın doğrusal ve doğrusal olmayan fonksiyonel bloklarını göstermektedir:

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>Fig. 5: Doğrusal ve doğrusal olmayan bloklara bir bakış   </center>|

Çizgede $s[i]$ ${i}$'nin ağırlıklı toplamıdır ve şöyle hesaplanır:

$$
s[i]=\Sigma_{j \in UP(i)}w[i,j]\cdot z[j]
$$

$UP(i)$ $i$'nin öncellerini gösterir ve $z[j]$ önceki katmanın $j$. çıktısıdır. 

Çıktı $z[i]$ şöyle hesaplanabilir:

$$
z[i]=f(s[i])
$$

$f$ doğrusal olmayan bir fonksiyondur.

<!-- ### Backpropagation through a non-linear function

The first way to do backpropagation is to backpropagate through a non linear function. We take a particular non-linear function $h$ from the network and leave everything else in the blackbox.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>Figure 6: Backpropagation through non-linear function     </center>|

We are going to use the chain rule to compute the gradients:

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

where $h'(s)$ is the derivative of $z$ w.r.t $s$ represented by $\frac{\mathrm{d}z}{\mathrm{d}s}$.
To make the connection between derivatives clear, we rewrite the formula above as:

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

Hence if we have a chain of those functions in the network, we can backpropagate by multiplying by the derivatives of all the ${h}$ functions one after the other all the way back to the bottom.

It’s more intuitive to think of it in terms of perturbations. Perturbing $s$ by $\mathrm{d}s$ will perturb $z$ by:

$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

This would in turn perturb C by:

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

Once again, we end up with the same formula as the one shown above. -->

### Doğrusal Olmayan Fonksiyonla Geri Yayılım

The first way to do backpropagation is to backpropagate through a non linear function. We take a particular non-linear function $h$ from the network and leave everything else in the blackbox.

Geri yayılımı gerçekleştirmenin ilk yolu doğrusal olmayan bir fonksiyon ile geri yayılımı gerçekleştirmektir. Ağdan belirli bir doğrusal olmayan $h$ fonksiyonu alıp, geriye kalan her şeyi kara kutu olarak bırakıyoruz. 

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>Fig. 6: Doğrusal olmayan fonksiyonla geri yayılım     </center>|

Zincir kuralını kullanarak gradyanları hesaplacağız:

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

$h'(s)$ $z$'nin $\frac{\mathrm{d}z}{\mathrm{d}s}$ ile gösterilen $s$'ye göre türevidir. 


Türevlerin arasındaki ilişkiyi daha net hale getirmek için formülü tekrar şöyle yazabiliriz:

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

Bundan dolayı ağda bu fonksiyonların zincirleri varsa, tüm ${h}$ fonksiyonlarının türevlerini birbiri ardına çarparak geri yayılımı gerçekleştirebiliriz.

Bunu sarsımlar şeklinde düşünmek daha sezgiseldir. $s$'yi $\mathrm{d}s$ ile sarsmak $z$'yi

$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

ile sarsacaktır. 

Bu da C'yi 

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

ile sarsacaktır.

Bir kez daha yukarıdakiye aynı formüle ulaşırız.

<!-- ### Backpropagation through a weighted sum

For a linear module, we do backpropagation through a weighted sum. Here we view the entire network as a blackbox except for 3 connections going from a ${z}$ variable to a bunch of $s$ variables.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>Figure 7: Backpropagation through weighted sum        </center>|


This time the perturbation is a weighted sum. Z influences several variables. Perturbing $z$ by $\mathrm{d}z$ will perturb $s[0]$, $s[1]$ and $s[2]$ by:

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

 This will perturb C by

$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$

Hence C is going to vary by the sum of the 3 variations:

$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$ -->

### Ağırlıklı Toplamla Geri Yayılım

Doğrusal bir modül için geri yayılımı ağırlıklı toplamla gerçekleştiririz. Burada bir ${z}$ değişkeninden $s$ değişkenlerine olan bağlantılar hariç tüm ağa kara kutu olarak bakacağız.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>Fig. 7: Ağırlıklı toplamla geri yayılım        </center>|


Bu sefer sarsım bir ağırlıklı toplamdır. Z birden fazla değişkeni etkiler. $z$'yi $\mathrm{d}z$ ile sarsmak $s[0]$,
$s[1]$ ve $s[2]$'yi:

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

ile sarsacaktır.

Bu C'yi 
$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$

ile sarsacaktır.

Dolayısıyla C üç sarsımın toplamıyla değişecektir.
$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$

<!-- ## [PyTorch implementation of neural network and a generalized backprop algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)


### Block diagram of a traditional neural net

- Linear blocks $s_{k+1}=w_kz_k$
- Non-linear blocks $z_k=h(s_k)$

  <center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figure 7" style="zoom: 33%;" /></center>

$w_k$: matrix $z_k$: vector $h$: application of scalar ${h}$ function to every component. This is a 3-layer neural net with pairs of linear and non-linear functions, though most modern neural nets do not have such clear linear and non-linear separations and are more complex.


### PyTorch implementation

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```

- We can implement neural nets with object oriented classes in PyTorch. First we define a class for the neural net and initialize linear layers in the constructor using predefined nn.Linear class. Linear layers have to be separate objects because each of them contains a parameter vector. The nn.Linear class also adds the bias vector implicitly. Then we define a forward function on how to compute outputs with $\text{torch.relu}$ function as the nonlinear activation. We don't have to initialize separate relu functions because they don't have parameters.

- We do not need to compute the gradient ourselves since PyTorch knows how to back propagate and calculate the gradients given the forward function. -->

## [Sinir Ağının PyTorch ile Gerçeklenmesi ve Bir Genelleştirilmiş Geri Yayılım Algoritması](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)


### Geleneksel Sinir Ağının Blok Diyagramı

- Doğrusal bloklar $s_{k+1}=w_kz_k$
- Doğrusal olmayan bloklar $z_k=h(s_k)$

  <center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figure 7" style="zoom: 33%;" /></center>

$w_k$: matris $z_k$: vektör $h$: skalerin uygulanması ${h}$ tüm bileşenler için bir fonksiyon. Bu doğrusal ve doğrusal olmayan fonksiyon çiftlerinden oluşan üç katmanlı bir sinir ağıdır. Çoğu modern sinir ağında doğrusal ve doğrusal olmayan ayrımı bu kadar net değildir ve çok modern ağlar çok daha karmaşıktır.


### PyTorch Uygulaması

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```


- Sinir ağlarını PyTorch ile nesne tabanlı sınıflar halinde gerçekleyebiliriz. Öncelikle sinir ağı için bir sınıf tanımlayıp doğrusal katmanları önceden tanımlanmış olan nn.Linear sınıfını kullanarak tanımlayabiliriz. Lineer katmanlar her biri bir parametre vektörü içerdiğinden ayrı nesneler olarak tanımlanmalıdır. Ayrıca nn.Linear önyargı vektörünü örtülü bir şekilde ekler. Daha sonra çıktıları hesaplamak için $\text{torch.relu}$'yu doğrusal olmayan aktivasyon olarak kullanarak bir "ileri" (forward) fonksiyonu tanımlarız. Relu fonksiyonu parametre içermediğinden ayrı olarak tanımlanmasına gerek yoktur.

- PyTorch geri yayılımın nasıl gerçekleştirileceğini ve verilen ileri fonksiyonu için gradyanların nasıl hesaplanacağını bildiğinden bizim gradyanları hesaplamamıza gerek yoktur.

<!-- ### Backprop through a functional module

We now present a more generalized form of backpropagation.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center>Figure 8: Backpropagation through a functional module     </center>|


- Using chain rule for vector functions

  $$
   z_g : [d_g\times 1]
  $$

  $$
   z_f:[d_f\times 1]
  $$

  $$
  \frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
  $$

  $$
  [1\times d_f]= [1\times d_g]\times[d_g\times d_f]
  $$

  This is the basic formula for $\frac{\partial c}{\partial{z_f}}$ using the chain rule. Note that the gradient of a scalar function with respect to a vector is a vector of the same size as the vector with respect to which you differentiate. In order to make the notations consistent, it is a row vector instead of a column vector.

- Jacobian matrix

  $$
  \left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
  $$

  We need $\frac{\partial {z_g}}{\partial {z_f}}$ (Jacobian matrix entries) to compute the gradient of the cost function with respect to $z_f$ given gradient of the cost function with respect to $z_g$. Each entry $ij$ is equal to the partial derivative of the $i$th component of the output vector with respect to the $j$th component of the input vector.

  If we have a cascade of modules, we keep multiplying the Jacobian matrices of all the modules going down and we get the gradients w.r.t all the internal variables. -->

### Fonksiyonel Modüllerle Geri Yayılım

Geri yayılımın daha genelleştirilmiş bir halini sunuyoruz.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center>Fig. 8: Fonksiyonel modüllerle geri yayılım     </center>|

- Zincir kuralını kullanarak vektör fonksiyonları için

  $$
   z_g : [d_g\times 1]
  $$

  $$
   z_f:[d_f\times 1]
  $$

  $$
  \frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
  $$

  $$
  [1\times d_f]= [1\times d_g]\times[d_g\times d_f]
  $$

  This is the basic formula for $\frac{\partial c}{\partial{z_f}}$ using the chain rule. Note that the gradient of a scalar function with respect to a vector is a vector of the same size as the vector with respect to which you differentiate. In order to make the notations consistent, it is a row vector instead of a column vector.

  Bu zincir kuralının $\frac{\partial c}{\partial{z_f}}$ için basit formülüdür. Bir skaler fonksiyonun bir vektöre göre gradyanının kendisine göre türevini aldığınız aynı boyutlarda bir vektör olduğuna dikkat edin. Notasyonu tutarlı tutabilmek için bu bir sütun vektör yerine bir satır vektördür.

- Jacobi matrisi

  $$
  \left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
  $$

  Kayıp fonksiyonunun $z_g$'ye göre gradyanı verildiğinde kayıp fonskyionunun $z_f$'ye göre gradyaını hesaplamak için $\frac{\partial {z_g}}{\partial {z_f}}$'ye ihtiyacımız vardır. Her $ij$ girdisi çıktının $i$. bileşeninin girdinin $j$. bileşenine göre kısmi türevini gösterir. 


  Eğer kademeli modüllerimiz varsa, aşağıya gittikçe tüm modüllerin Jacobi matrislerini çarparak devam ederek tüm iç değişkenlerin gradyanlarını elde ederiz. 

<!-- ### Backprop through a multi-stage graph

Consider a stack of many modules in a neural network as shown in Figure 9.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>Figure 9: Backprop through multi-stage graph         </center>|

For the backprop algorithm, we need two sets of gradients - one with respect to the states (each module of the network) and one with respect to the weights (all the parameters in a particular module). So we have two Jacobian matrices associated with each module. We can again use chain rule for backprop.

- Using chain rule for vector functions

  $$
  \frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
  $$

  $$
  \frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
  $$

- Two Jacobian matrices for the module
    - One with respect to $z[k]$
    - One with respect to $w[k]$
 -->
### Çok Aşamalı Çizgede Geri Yayılım

Fig. 9'daki gibi bir ağdaki yığın halindeki modülleri düşünün.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>Fig. 9: Çok aşamalı çizgede geri yayılım         </center>|

Geri yayılım algoritması için iki grup gradyana ihtiyacımız vardır, bir tane durumlara göre (ağdaki her bir modül için), bir tane de ağırlıklara göre (belirli bir modüldeki tüm parametreler için). Böylelikle her bir modül için bir Jacobi matrisi elde ederiz ve geri yayılım için zincir kuralını kullanabiliriz.

- Vektör fonksiyonları için zincir kuralını kullanarak
  $$
  \frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
  $$

  $$
  \frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
  $$

- Modül için iki Jacobi matrisi
    - Bir tane $z[k]$'ye göre
    - Bir tane $w[k]$'ye

