---
lang: tr
lang-ref: ch.01-2
lecturer: Yann LeCun
title: CNN'lerin Gelişimi, Kullanmı ve Neden Derin Öğrenme?
authors: Marina Zavalina, Peeyush Jain, Adrian Pearl, Davida Kollmar
date: 27 Jan 2020
translation-date: 11 Sep 2020
translator: tugbatumer
---


<!--## [Evolution of CNNs](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)
-->

##[Evrişimli Sinir Ağlarının (CNN) Gelişimi](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2965s)

<!--In animal brains, neurons react to edges that are at particular orientations. Groups of neurons that react to the same orientations are replicated over all of the visual field.
-->

Hayvan beyinlerinde, sinir hücreleri belirli yönelimlerdeki kenarlara tepki verir. Aynı yönelimlere tepki veren sinir hücresi grupları görme alanının tümünde kopyalanmıştır.

<!--Fukushima (1982) built a neural net (NN) that worked the same way as the brain, based on two concepts. First, neurons are replicated across the visual field. Second, there are complex cells that pool the information from simple cells (orientation-selective units). As a result, the shift of the picture will change the activation of simple cells, but will not influence the integrated activation of the complex cell (convolutional pooling).
-->

1982 yılında Fukushima iki konsepte dayanan ve beyinle aynı şekilde çalışan bir sinir ağı (*NN*) oluşturdu. Bu konseptlerden ilki sinir hücrelerinin görme alanının içinde kopyalanmış olması, ikincisi ise bilgiyi basit hücrelerden örnekleyen kompleks hücrelerin (yönelim seçici birimler) bulunmasıydı. Sonuç olarak, resmin kayması basit hücrelerin aktivasyonunu değiştirse bile, kompleks hücrenin birleşmiş aktivasyonunu etkilemeyecekti (evrişimli örnekleme).

<!--LeCun (1990) used backprop to train a CNN to recognize handwritten digits. There is a demo from 1992 where the algorithm recognizes the digits of any style. Doing character/pattern recognition using a model that is trained end-to-end was new at that time. Previously, people had used feature extractors with a supervised model on top.
-->

1990 yılında LeCun elle yazılmış sayıları tanıması için bir CNN'i geri yayılım kullanarak eğitti. Bu algoritmanın her biçimde yazılmış sayıları tanıyabildiğini gösteren 1992'den bir demo mevcut. O zamanlarda karakter/şekil tanımayı uçtan uca eğitilmiş bir model kullanarak yapmak yeniydi. Bunun öncesinde üstlerinde denetimli bir model bulunan özellik çıkartıcılar kullanılıyordu.

<!--These new CNN systems could recognize multiple characters in the image at the same time. To do it, people used a small input window for a CNN and swiped it over the whole image. If it activated, it meant there was a particular character present.
-->

Bu yeni CNN sistemleri bir görseldeki birden fazla karakteri aynı anda tanıyabiliyorlardı. Bu, CNN için küçük bir girdi penceresi kullanılarak ve bu pencere tüm görsel üzerinde kaydırılarak yapılıyordu. Aktive olması, orada bir karakterin var olduğunu gösteriyordu.

<!--Later, this idea was applied to faces/people detection and semantic segmentation (pixel-wise classification). Examples include Hadsell (2009) and Farabet (2012). This eventually became popular in industry, used in autonomous driving applications such as lane tracking.
-->

Sonralarda, bu fikir hem yüz/insan belirlemede hem de anlamsal bölümlemede (piksel bazlı sınıflandırma) kullanıldı. Hadsell (2009) ve Farabet (2012) bunun örneği olarak gösterilebilir. En sonunda fikir endüstride popüler hale geldi ve şerit takibi gibi otonom sürüş uygulamalarında kullanıldı.

<!--Special types of hardware to train CNN were a hot topic in the 1980s, then the interest dropped, and now it has become popular again.
-->

CNN'leri eğitmek için kullanılan özel donanımlar 1980'lerde popüler bir konuydu, sonrasında ilgi düştü, ve günümüzde tekrar popüler oldu.

<!--The deep learning (though the term was not used at that time) revolution started in 2010-2013. Researchers focused on inventing algorithms that could help train large CNNs faster. Krizhevsky (2012) came up with AlexNet, which was a much larger CNN than those used before, and trained it on ImageNet (1.3 million samples) using GPUs. After running for a couple of weeks AlexNet beat the performance of the best competing systems by a large margin -- a 25.8% *vs.* 16.4% top-5 error rate.
-->

Derin öğrenmedeki (bu terim o zamanlarda kullanılmasa da) devrim 2010-2013 yıllarında başladı. Araştırmacılar büyük CNN'lerin daha hızlı eğitilebilmesi için algoritmalar keşfetmeye odaklandılar. 2012 yılında Krizhevsky eskiden kullanılan CNN'lerden çok daha büyük olan AlexNet'i tasarladı ve ImageNet'te (1.3 milyon örnek içeren) GPU kullanarak eğitti. Birkaç hafta çalıştırıldıktan sonra AlexNet eskiden %25.8 olan ilk 5 hata oranını %16.4 hata oranıyla çok büyük bir farkla geçti.

<!--After seeing AlexNet's success, the computer vision (CV) community was convinced that CNNs work. While all papers from 2011-2012 that mentioned CNNs had been rejected, since 2016 most accepted CV papers use CNNs.
-->

AlexNet'in başarısını gördükten sonra bilgisayarlı görme (*computer vision, CV*) topluluğu CNN'lerin iyi çalıştığına ikna oldu. 2011-2012 yıllarında CNN'lerden bahseden tüm makaleler reddedilmesine rağmen, 2016dan itibaren kabul edilen çoğu makale CNN'leri kullanmakta.

<!--Over the years, the number of layers used has been increasing: LeNet -- 7, AlexNet -- 12, VGG -- 19, ResNet -- 50. However, there is a trade-off between the number of operations needed to compute the output, the size of the model, and its accuracy. Thus, a popular topic now is how to compress the networks to make the computations faster.
-->

Yıllar geçtikçe CNN'lerde kullanılan katman sayısı da artış gösterdi: *LaNet* -- 7, *AlexNet* -- 12, *VGG* -- 19, *ResNet* -- 50. Ancak çıktının oluşturulması için gereken işlem sayısı ve modelin büyüklüğüyle modelin doğruluğu arasında bir ödünleşim (*trade-off*) olması sebebiyle, şimdilerdeki popüler bir araştırma konusu da işlemleri hızlandırmak amacıyla ağların nasıl daha küçük oluşturulabileceği.


<!--## [Deep Learning and Feature Extraction](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)
-->

## [Derin Öğrenme ve Özellik Çıkarımı](https://www.youtube.com/watch?v=0bMe_vCZo30&t=3955s)

<!--Multilayer networks are successful because they exploit the compositional structure of natural data. In compositional hierarchy, combinations of objects at one layer in the hierarchy form the objects at the next layer. If we mimic this hierarchy as multiple layers and let the network learn the appropriate combination of features, we get what is called Deep Learning architecture. Thus, Deep Learning networks are hierarchical in nature.
-->

Çok katmanlı ağlar, doğal verilerin bileşimsel yapısından faydalandıkları için başarılıdır. Bileşimsel hiyeraşide, hiyeraşinin bir katmanındaki objelerin kombinasyonu, bir sonraki katmandaki nesneleri oluşturur. Birden çok katman kullanarak ve ağın doğru özelliklerin kombinasyonunu öğrenmesini sağlayarak bu hiyeraşi taklit edilebilir, ve Derin Öğrenme Mimarileri elde edilir. Sonuç olarak derin öğrenme ağları tabiatları gereği hiyeraşiktir.

<!--Deep learning architectures have led to an incredible progress in computer vision tasks ranging from identifying and generating accurate masks around the objects to identifying spatial properties of an object. Mask-RCNN and RetinaNet architectures mainly led to this improvement.
-->

Derin Öğrenme Mimarileri, nesnelerin etrafında doğru maskelerin tanımlanması ve üretilmesinden nesnelerin uzamsal özelliklerinin belirlenmesine uzanan bilgisayarlı görme görevlerinde olağanüstü bir ilerlemeye yol açtı. Mask-RCNN ve RetinaNet bu gelişime yol açan ana mimarilerdendir.

<!--Mask RCNNs have found their use in segmenting individual objects, *i.e.* creating masks for each object in an image. The input and output are both images. The architecture can also be used to do instance segmentation, *i.e.* identifying different objects of the same type in an image. Detectron, a Facebook AI Research (FAIR) software system, implements all these state-of-the-art object detection algorithms and is open source.
-->

Mask-RCNN'ler bir görseli her obje için parçalara ayırmada *başka bir deyişle* görseldeki her obje için maske yaratmakta kullanılıyor. Bu kullanım şeklinde hem girdi hem de çıktı görsel. Aynı zamanda mimari, örnek sınıflandırma *başka bir deyişle* bir görsel içinde aynı tipteki farklı objeleri belirlemekte de kullanılıyor. Facebook AI Research (FAIR) grubunun bir yazılım sistemi olan Detectron, tüm bu nesne belirleme algoritmalarını oluşturmuş, ve açık kaynak halinde bulunabiliyor.

<!--Some of the practical applications of CNNs are powering autonomous driving and analysing medical images.
-->

CNN'ler pratikte otonom sürüşe ve medikal görselleri analiz etme gibi uygulamalara da güç veriyor.

<!--Although the science and mathematics behind deep learning is fairly understood, there are still some interesting questions that require more research. These questions include: Why do architectures with multiple layers perform better, given that we can approximate any function with two layers? Why do CNNs work well with natural data such as speech, images, and text? How are we able to optimize non-convex functions so well? Why do over-parametrised architectures work?
-->

Derin öğrenmenin arkasında yatan matematik ve bilime dair fikirler neredeyse tamamen anlaşılmış olsa da, halen araştırılmaya ihtiyacı olan ve yanıtlanmamış sorular da bulunuyor. Bu sorulardan bazıları şöyle sıralanabilir: Neden iki katman kullanarak her fonksiyona yaklaşılabilmesine rağmen birçok katman içeren mimariler daha iyi sonuç veriyor? CNN'ler neden konuşma, görüntü ve yazı gibi doğal verilerde iyi çalışıyor? Konveks olmayan fonksiyonları eniyileştirme konusunda neden bu kadar iyi sonuç alınıyor? Neden aşırı parametrize edilmiş mimariler çalışıyor?

<!--Feature extraction consists of expanding the representational dimension such that the expanded features are more likely to be linearly separable; data points in higher dimensional space are more likely to be linearly separable due to the increase in the number of possible separating planes.
-->

Daha çok boyutlu uzaylarda olası ayırma düzlemlerinin sayısının artması sebebiyle veri noktalarının doğrusal ayrılabilir olma olasılığı daha yüksektir. Bu sebeple özellik çıkarmada yapılan işlemlerden biri de genişletilmiş özelliklerin doğrusal ayrılabilir olması için temsil boyutunun genişletilmesidir.

<!--Earlier machine learning practitioners relied on high quality, hand crafted, and task specific features to build artificial intelligence models, but with the advent of Deep Learning, the models are able to extract the generic features automatically. Some common approaches used in feature extraction algorithms are highlighted below:
-->

Daha öncelerde makine öğrenmesinde çalışanlar yapay zeka modellerini oluşturmak için yüksek kaliteli, el yapımı ve göreve özel özelliklere dayanıyordu, fakat derin öğrenmenin ortaya çıkmasıyla modeller kapsamlı özellikleri otomatik olarak çıkarabilmeye başladı. Yaygın kullanılan bazı özellik çıkarma algoritmaları aşağıda belirtilmiştir:

<!--
- Space tiling
- Random Projections
- Polynomial Classifier (feature cross-products)
- Radial basis functions
- Kernel Machines
-->

- Uzayın bölünmesi (*tiling*)
- Rastgele İzdüşümler
- Polinom Sınıflandırıcı (özellik vektör çarpımları)
- Radyal temel fonksiyonları
- Kernel makineleri

<!--Because of the compositional nature of data, learned features have a hierarchy of representations with increasing level of abstractions. For example:
-->

Verilerin birleşik doğası sebebiyle öğrenilmiş özellikler yükselen soyutluk seviyesine göre hiyeraşik bir gösterime sahiptir. Örneğin:

<!--
-  Images - At the most granular level, images can be thought of as pixels. Combination of pixels constitute edges which when combined forms textons (multi-edge shapes). Textons form motifs and motifs form parts of the image. By combining these parts together we get the final image.
-  Text - Similarly, there is an inherent hierarchy in textual data. Characters form words, when we combine words together we get word-groups, then clauses, then by combining clauses we get sentences. Sentences finally tell us what story is being conveyed.
-  Speech - In speech, samples compose bands, which compose sounds, which compose phones, then phonemes, then whole words, then sentences, thus showing a clear hierarchy in representation.
-->

- Görseller - En tanecikli haliyle, görseller pikseller olarak düşünülebilir. Piksellerin kombinasyonu kenarları, kenarların kombinasyonu ise textonları (çok kenarlı şekiller) oluşturur. Texton'lar motifleri, motiflerse görselin parçalarını oluşturur. Bu parçaları birleştirerek ise görselin bütününü elde ederiz.
- Metin - Görsellere benzer olarak, metinsel verinin doğasında da bir hiyeraşi vardır. Karakterler kelimeleri, kelimeler kelime gruplarını, kelime grupları yan cümleleri, son olarak da yan cümleler cümleleri oluşturur. Cümleler de bize aktarılan hikayenin içeriğiyle ilgili bilgi verir.
- Konuşma - Konuşmada, örnekler frekans bantlarını, frekans bantları sesleri, sesler sesbirimciklerini, sesbirimcikleri sesbirimlerini, sesbirimleri kelimeleri, kelimeler ise cümleleri oluşturur. Bu da gösterimde kullanılabilecek açık bir hiyeraşidir.

<!--## [Learning representations](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)
-->

## [Öğrenme gösterimleri](https://www.youtube.com/watch?v=0bMe_vCZo30&t=4767s)

<!--There are those who dismiss Deep Learning: if we can approximate any function with 2 layers, why have more?
-->

"Eğer 2 katman kullanarak her fonksiyona yakaşabiliyorsak neden daha fazlasını kullanalım?" sorusundan yola çıkarak derin öğrenmeyi reddedenler bulunuyor.

<!--For example: SVMs find a separating hyperplane "in the span of the data", meaning predictions are based on comparisons to training examples. SVMs are essentially a very simplistic 2 layer neural net, where the first layer defines "templates" and the second layer is a linear classifier. The problem with 2 layer fallacy is that the complexity and size of the middle layer is exponential in $N$ (to do well with a difficult task, need LOTS of templates). But if you expand the number of layers to $\log(N)$, the layers become linear in $N$. There is a trade-off between time and space.
-->

Örneğin: Destek Vektör Makineleri (*Support Vector Machine, SVM*) "veri aralığında" bir ayırıcı üst düzlem bulur, bunun anlamı da tahminlerin eğitim örnekleriyle karşılaştırılarak yapıldığıdır. SVM'ler temelde oldukça basit 2 katmanlı bir sinir ağıdır, ilk katman "şablonları" tanımlarken ikinci katman bir doğrusal sınıflayıcıdır. 2 katman yanılgısındaki sorun ise ortanca katmanın büyüklüğü ve karmaşıklığının $N$ ile üstel bir şekilde orantılı olmasıdır (zor bir görevde iyi sonuç elde etmek için, ÇOK FAZLA şablona ihtiyaç duyulur). Ama katman sayısı $\log(N)$'e orantılı olacak şekilde genişletildiğinde, katmanların karmaşıklığı $N$ ile orantılı hale gelir. Zaman ve katmanların sayısı arasında bir ödünleşim mevcuttur.

<!--An analogy is designing a circuit to compute a boolean function with no more than two layers of gates -- we can compute **any boolean function** this way! But, the complexity and resources of the first layer (number of gates) quickly becomes infeasible for complex functions.
-->

Az önce anlatılanlara benzeşim olarak iki katmandan daha fazla mantık geçidi (*logic gate*) içermeyen ve mantıksal bir fonksiyonu hesaplayan bir devre örnek gösterilebilir. Bu şekilde **herhangi bir mantıksal fonksiyon** hesaplanabilir. Fakat, ilk katmanın karmaşıklığı ve kullanılacak kaynaklar (geçit sayısı) kompleks bir fonksiyon için kolay bir şekilde mümkün olmayan hale gelebilir.

<!--What is "deep"?
-->

"Derin" nedir?

<!--
- An SVM isn't deep because it only has two layers
- A classification tree isn't deep because every layer analyses the same (raw) features
- A deep network has several layers and uses them to build a **hierarchy of features of increasing complexity**
-->

- SVM sadece iki katmandan oluştuğu için derin değildir.
- Sınıflandırma ağacı (*Classification tree*) her katmanı aynı (ham) özellikleri analiz ettiği için derin değildir.
- Derin ağ birçok katmandan oluşur ve bu katmanları bir **artan karmaşıklıkla özellik hiyeraşisi** oluşturmak için kullanır.

<!--How can models learn representations (good features)?
-->

Modeller gösterimleri (iyi özellikler) nasıl öğrenir?

<!--Manifold hypothesis: natural data lives in a low-dimensional manifold. Set of possible images is essentially infinite, set of "natural" images is a tiny subset. For example: for an image of a person, the set of possible images is on the order of magnitude of the number of face muscles they can move (degrees of freedom) ~ 50. An ideal (and unrealistic) feature extractor represents all the factors of variation (each of the muscles, lighting, *etc.*).
-->

Manifold hipotezi: Doğal veriler düşük boyutlu bir manifoldda yer alır. Olabilecek her görselin sayısı sonsuz bir küme oluştursa da, "doğal" görsellerin kümesi bu sonsuz kümenin küçük bir alt kümesidir. Örneğin: bir insanın görselini ele alırsak, olası görseller kümesinin büyüklüğü hareket edebilen yüz kasları büyüklüğüne göre belirlenir (serbestlik derecesi (*degrees of freedom*)) ~ 50. İdeal (ve gerçekçi olmayan) bir özellik çıkarıcı değişebilecek tüm faktörleri temsil eder (hareket edebilen herhangi bir kas, ışıklar, *vb.*).

<!--Q&A from the end of lecture:
-->

Dersin sonundan soru-cevap:

<!--
- For the face example, could some other dimensionality reduction technique (*i.e.* PCA) extract these features?
  - Answer: would only work if the manifold surface is a hyperplane, which it is not
-->

- Yüz örneğini ele alırsak, başka bir boyut azaltma tekniği (*PCA gibi*) bu özellikleri çıkarabilir miydi?
  - Cevap: Sadece manifold yüzeyi bir üst düzlem (*hyperplane*) olsaydı işe yarardı, fakat değil.
