---
lang: tr
lang-ref: ch.01-1
lecturer: Yann LeCun
title: Derin Öğrenmenin Motivasyonu, Tarihi ve Esin Kaynağı
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 12 Jun 2020
translator: Yiğit Sever
---

<!--
title: Motivation of Deep Learning, and Its History and Inspiration
-->


<!--
## [Course plan](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)
-->

## [Ders Planı](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)


<!--
- Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond
-->

- Denetimli Öğrenme, Sinir Ağları ve Derin Öğrenme Temelleri
- Geri Yayılım ve Mimari Bilesenler
- Evrişimli Sinir Ağları (CNN, Convolutional Neural Networks)
- Derin Öğrenme Mimarileri
- Düzenlileştirmenin İncelikleri / Eniyilestirmenin İncelikleri/ Derin Öğrenmenin çalışma mantığını kavramak
- Enerji Tabanlı Modeller
- Özdenetimli Öğrenme ve Sonrası


<!--
## Inspiration of Deep Learning and its history
-->

## Derin Öğrenmenin Esin Kaynağı ve Tarihi


<!--
On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.
-->

Derin öğrenme temelde insan beyninden esinlenmiştir ancak beynin her detayı derin öğrenme için önemli değildir. Bunu uçakların kuşlardan esinlenmiş olmasına benzetebiliriz. İkisi de uçuyor olsa da, gerçekte nasıl uçtukları oldukça farklıdır.


<!--
The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.
-->

Derin öğrenmenin temelleri, günümüzde artık sibernetik olarak bilinen bilim dalına dayanır. 1940'lı yıllarda McCulloch ve Pitts ile başlamıştır. İkili, beyindeki sinir hücrelerinin bir eşik değere göre aktif ya da pasif olarak çalıştığı fikrini ortaya attı. Sinir hücrelerini birbirlerine baglayarak bir Boole cebiri devresi kurabilir ve bu devreyi kullanarak mantıksal çıkarımlar yapabilirsiniz. Beynimizdeki sinir hücreleri ikilik düzenle çalıştıkları için beynimiz de bir mantıksal çıkarım makinası olarak nitelendirilebilir. Sinir hücreleri girdilerini belli katsayılarla çarparak bir ağırlıklı toplam alır ve sonucu bir eşik değer ile karşılaştırırlar. Eğer sonuç eşik değerden yüksekse sinir hücresi iletişime geçer, aksi taktirde bir iletim olmaz. Yapay sinir ağları da temelde böyle çalışır.


<!---
In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.
-->

1947 yılında Donald Hebb, beynimizdeki sinir hücrelerinin arasındaki bağlantıların şiddetini değiştirerek öğrendiği fikrini ortaya attı. Bu fikre hiperöğrenme denir; karşılıklı iletişime geçen sinir hücreleri arasındaki bağlantılar güçlenir, iletişime geçmeyenlerde ise bağlantılar zayıflar.


<!--
Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.
-->

1948 senesinde ise, Norbert Wiener sensör ve eyleyicilerden oluşan bir sistemin geri bildirim döngüsünde kendi kendini denetleyebileceğini savunan sibernetik alanını ortaya koydu. Arabalardaki geri bildirim kurallarının temeli bu çalışmaya dayanır.


<!--
In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.
-->

1957 senesinde Frank Rosenblatt basit yapay sinir ağlarındaki ağırlıkları değiştirebilen Perseptron öğrenme algoritmasını önerdi.


<!--
Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:
-->

Genel olarak, sinir hücrelerini taklit ederek düşünebilen makinalar inşa etme fikri 1940'larda ortaya çıktı, 1950'lerde ivme kazandı ve 1960'ların sonunda tamamen söndü. Bu alanın 1960'larda ortadan kaybolmasının nedenleri:

<!--
- The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.
-->

- Araştırmacılar ikili sinir hücreleri kullandılar. Geri yayılımın çalışması için sürekli aktifleştirme fonksiyonları gerekir. Bahsettiğimiz yıllardaki araştırmacılar sürekli sinir hücresi kullanma fikrinden uzaklardı ve ikili sinir hücrelerinin türevi alınamayacağı için gradyanlar ile öğrenmenin mümkün olmadığını düşünüyorlardı.
- Sürekli sinir hücreleri kullanıldığı zaman, bir girdinin ağırlıklı toplama etkisini görebilmek için bir aktiflestirme değeri ile çarpılması gerekir. Ancak 1980'den önce iki sayının çarpımı, özellikle gerçel sayıların çarpımı oldukça yavaştı. Sürekli sinir hücreleri kullanmaya yaklaşılmamasının bir diğer sebebi de buydu.


<!--
Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields.
-->

1985'te geri yayılımın ortaya çıkması ile birlikte Derin Öğrenme tekrar harekete geçti. 1995'te ise alan tekrar duruldu ve makina öğrenmesi topluluğu yapay sinir ağları fikrinden vazgeçtiler. 2010'lu yılların başında yapay sinir ağlarının konuşma tanımada büyük başarıyla uygulanmasının ardından piyasada da yaygın bir şekilde kullanılmaya başlandı. 2013'te bilgisayarlı görü yapay sinir ağlarına geçmeye başladı. 2016 yılında doğal dil işleme aynı geçişi tekrar etti. Yakında aynı devrim robotik, kontrol ve diğer çoğu başka alanda yaşanacak.


<!--
### Supervised Learning
-->

### Denetimli Öğrenme


<!--
$90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.
-->

Derin öğrenme uygulamalarının $\%90$'ı denetimli öğrenme kullanır. Denetimli öğrenme için öncelikle çok sayıda girdi-çıktı çifti toplanır ve doğru çıktının öğrenilmesi için girdiler makinaya verilir. Eğer makina doğru çıktı verirse bir şey yapılmaz. Yanlış çıktıda ise makinanın ayarları ile oynanarak makinanın verdiği çıktı istenen çıktıya yakınlaştırılmaya çalışılır. Burada işin püf noktası parametrelerin hangi yöne doğru ve ne kadar değişeceğine karar vermektir, bu da gradyan hesabına ve geri beslemeye bağlıdır.

<!--
Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.
-->

Denetimli öğrenmenin kökleri Perseptron ve Adaline'a dayanır. Adaline ağırlıklı girdilerin kullanıldığı mimariyle aynı temellere sahiptir; eşik değer üzerine çıkıldığında iletişime geçer, eşik değer altında kalırsa ise sessiz kalır. Perceptron ise 2. katmanın eğitilebildiği, ilk katmanın ise sabit tutulduğu 2 katmanlı bir yapay sinir ağıdır. İlişkili katman adı verilen ilk katman çoğu zaman rastgele başlatılır.

<!--
## [History of Pattern Recognition and introduction to Gradient Descent](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)
-->

## [Şekil Tanımanın Tarihi ve Gradyan İnişine giriş](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!--
The foregoing is the conceptual basis of pattern recognition before deep learning developed. The standard model of pattern recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, pattern recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.
-->

Yukarıdaki videoda derin öğrenme yaygınlaşmadan önce kullanılan şekil tanıma yöntemlerinin kavramsal altyapısı anlatılmıştır. Şekil tanıma için kullanılan genelgeçer model birer öznitelik çıkarıcısı ve eğitilebilir sınıflandırıcıdan oluşur. Girdi, işimize yarayabilecek özellikleri bulunmak üzere öznitelik çıkarısıcına verilir, mesela yüzleri tanımak istiyorsak gözleri saptayabilir. Sonrasında elde edilen öznitelik vektörleri eğitilebilir sınıflandırıcıdan geçirilir ve ağırlıklı toplam hesaplanarak eşik değer ile karşılaştırılır. Burada eğitilebilir sınıflandırıcı bir perseptron ya da tek katmanlı yapay sinir ağı olabilir. Buradaki asıl sorun öznitelik çıkarıcısının elle hazırlanmasının gerekmesi. Şekil tanıma ya da bilgisayarlı görü çalışmalarında harcanan zamanın çoğu eğitilebilir bir sınıflandırıcı üretmektense öznitelik çıkarıcısının eldeki problem için özel tasarımına harcanıyor.


<!--
After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.
-->

Derin öğrenmenin ortaya çıkışı ve olgunlaşması sonrasında yukarıda bahsedilen iki aşamalı süreç birbiri ardına eklenen, ayarlanabilir değişkenli, eğrisel modüller ile yapılmaya başlandı. Bu modülleri üst üste koyarak edinilen çok katmanlı yapı aynı zamanda alana "derin öğrenme" adını veriyor. Doğrusal yerine eğrisel modüller kullanılmasının sebebi ise doğrusal cebirden gelir; iki doğrusal katman birleştirilerek tek bir doğrusal katmana indirgenebilir.


<!--
The simplest multi-layer architecture with tunable parameters and nonlinearity could be: the input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix whose coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.
-->

Ayarlanabilir değişkenlere sahip eğrisel çok katmanlı yapıya bir örnek verelim: öncelikle, resimleri ya da sesleri vektörlerle ifade edebiliriz. Bu vektörleri girdi olarak alıp, elemanları ayarlanabilir değişkenler olan bir ağırlık matrisiyle çarpabiliriz. Çıktı olarak elde ettiğimiz matrisin her elemanını ReLU gibi bir eğrisel fonksiyondan geçirebiliriz. Bu adımları tekrarlayarak basit bir yapay sinir ağı elde ederiz. Bu yapıya yapay sinir ağı denmesinin sebebi ise girdi vektörünün ağırlıklı toplamının elde edilmesi için bir matristeki karşılığına denk gelen satırlarıyla çarpılmasıdır.


<!--
Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is the loss, computing a distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.
-->

Denetimli öğrenmeye dönecek olursak; amacımız yukarıda bir turda elde ettiğimiz çıktıyı, istenilen çıktıyla karşılaştırıp, amaç fonksiyonu olarak kullandığımız kayıp fonksiyonunu eniyilemek için istenilen çıktı ile elimizdeki çıktı arasında uzaklık/ceza/ıraksama hesaplamak ve kayıp fonksiyonunun bütün eğitim kümesi üzerindeki ortalamasını almak. Buradaki hedefimiz kayıp fonksiyonunu en aza indirmek. Başka bir deyişle kayıp fonksiyonunun bütün eğitim kümesi üzerindeki değerini en aza indirecek değişken kümesini arıyoruz.


<!--
The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.
-->

Bu kümeyi bulmak için gradyan hesabı kullanılır. Örnek vermek gerekirse, sisli bir gece vakti engebesiz bir dağda kaybolduğumuzu ve vadideki köye inmeye çalıştığımızı düşünelim. Yolumuzu bulmak için etrafımızı yoklayarak hangi yönün yokuş aşağı olduğunu kestirip oraya doğru küçük bir atım atabiliriz. Bu yön (eksi) gradyandır. Örneğimizdeki vadinin içbükey olduğunu varsayarak köye ulaşabiliriz.


<!--
The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.
-->

Bu yöntemin daha verimli haline Stokastik Gradyan İnişi (Stochastic Gradient Descent (SGD)) denir. Eğitim kümesi üzerindeki ortalama kaybı en aza indirmek amacıyla, önce bir örnek ya da küçük bir örneklem kümesi alarak onun ya da onların üzerinden hata hesaplaması yaptıktan sonra gradyan inişini gerçekleştirebiliriz. Sonrasında, yeni bir örneklem alarak yeni bir hata değeri ve yeni bir gradyan ile genellikle farklı bir yön elde ederiz. SGD'yi tercih etmemizin iki sebebi var; çok büyük eğitim kümelerinde bir modelin hızlıca yakınsamasını sağladığı deneysel olarak kanıtlanmıştır. Ayrıca daha iyi genelleme yapmamıza imkan tanır, böylelikle farklı veri kümelerinde benzer performans alabiliriz.

<!--
### [Computing gradients by backpropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)
-->

### [Geri yayılım ile gradyan hesaplanması](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)


<!--
Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:
-->

Geri yayılım ile gradyan hesabı zincir kuralı uygulanarak yapılır. Girdi gradyanı için geri besleme denklemi aşağıda verilmiştir.

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

<!--
The backpropagation equation for the weight gradients is as follows:
-->

Ağırlık gradyanları için geri besleme denklemi ise aşağıdadır.

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$


<!--
Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.
-->

Skaler girdiler yerine vektörel ya da genel bir tabirle çok boyutlu girdiler olacağını unutmayın. Geri besleme kullanarak beklediğiniz çıktı ile elde ettiğiniz çıktı arasındaki farkın (amaç fonksiyonunun verdiği değer) yapay sinir ağı içinde herhangi bir değere göre türevini alabilirsiniz. Son olarak geri besleme, çok katmanlı yapıda çalışabilmesi nedeniyle vazgeçilmezdir.


<!--
It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.
-->

Girdilerin nasıl ele alınacağı da önemlidir. Örnek vermek gerekirse; 256$$\times$$256'lık bir resim 200,000 elemanlı bir matrisle ifade edilebilir. Bu kadar büyük matrisler sinir ağı katmanlarına ağır gelebilir ve böyle matrisleri kullanmak mantıksız olabilir. Bu nedenle nasıl bir matris ile çalışılacağı önceden düşünülmelidir.


<!--
## Hierarchical representation of the Visual Cortex
-->

## Görme Korteksinin Akışsal Gösterimi


<!--
Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does pattern recognition in a hierarchical manner.
-->

Fukushima'nin yaptığı deneyler beynimizin gözlerimizden gelen bilgiyi nasıl işlediği konusunda bize genel bir fikir verdi. Özetle, retinanın önündeki nöronların görüntüyü sıkıştırdığı (kontrast normalizasyonu olarak bilinir) ve sonrasında bu sinyalin gözlerimizden beynimize gittiği keşfedildi. Beynimizde görüntü aşamalı olarak işlenir ve belirli sınıflara göre belirli nöronlar aktifleşir. Görme merkezi şekilleri sıralı bir düzen kullanarak tanır diyebiliriz.


<!--
Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (e.g. vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.
-->

Araştırmacılar, V1 alanı başta gelmek üzere, görme merkezini elektrotlarla dürterek yaptıkları deneylerle, bir grup sinir hücresinin gördüğümüz alanın çok küçük bir kısmındaki motiflere tepki verdiğini ve komşu gruplardaki sinir hücrelerinin yine gördüğümüz alanda birbirine komşu olan yerlere karşılık gelecek şekilde iletişime geçtiklerini fark ettiler. Ayrıca, aynı kareye tepki veren sinir hücreleri farklı kenar tiplerine (dikey ya da yatay) bir ağızdan farklı tepkiler veriyorlar. Altını çizmemiz gereken başka bir nokta ise görme sürecinin özünde bir ileri besleme süreci olduğu fikri. Böylece, yinelemeli işlemlere gerek duymadan hızlıca tanıma gerçekleştirmek mümkün.
