---
lang: ru
lang-ref: ch.12-2
title: Декодирующие модели языка
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
translation-date: 03 Dec 2020
translator: Evgeniy Pak
---


<!-- ## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability.

The algorithm selects the best scoring hypothesis.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: Beam Decoding
</center>

How deep does the beam tree branch out ?

The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished.

Why (in NMT) do very large beam sizes often results in empty translations?

At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam.

Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached. -->

## [Лучевой поиск](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

Лучевой поиск - это ещё одна техника декодирования модели языка и генерации текста. На каждом шаге алгоритм отслеживает $k$ наиболее вероятных (наилучших) частичных переводов (гипотез). Оценка каждой гипотезы равна логарифму её вероятности.

Алгоритм выбирает гипотезы с лучшей оценкой.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Рис. 1</b>: Лучевое декодирование
</center>

Как глубоко разветвляется лучевое дерево ?

Лучевое дерево продолжается, пока не достигнет конца предложения. После вывода конца предложения, гипотеза завершена.

Почему (в нейронном машинном переводе) очень большие размерности луча часто приводят к пустому переводу?

В момент обучения алгоритм часто не использует луч, поскольку это очень дорого. Вместо этого используется авторегрессивная факторизация (по данному предыдущему корректному выходу, предсказывает $n+1$ первых слов). Модель не отображает собственные ошибки в процессе обучения, так что возможно появление "бессмыслицы" в луче.

Сводка: Продолжайте лучевой поиск, пока все $k$ гипотез порождают конечный токен или пока не достигнете максимального предела декодирования T.


<!-- ### Sampling

We may not want the most likely sequence. Instead we can sample from the model distribution.

However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops. -->

### Семплирование

Нам может быть не нужна наиболее вероятная последовательность. Вместо этого мы можем семплировать из распределения модели.

Однако выборка из распределения модели приносит свои проблемы. После "плохого" выбора, модель находится в состоянии, с которым никогда не сталкивалась в процессе обучения, возрастает вероятность продолжения "плохой" оценки. Алгоритм может затем застрять в ужасных циклах обратной связи.


<!-- ### Top-K Sampling

A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: Top K Sampling
</center> -->


### Топ-K семлирование

Чистая техника семплирования, где вы усекаете распределение до $k$ наилучших и затем перенормализуете и выбираете из распределения.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Рис. 2</b>: Топ K семлирование
</center>


<!-- #### Question: Why does Top-K sampling work so well?

This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail. -->


#### Вопрос: Почему Топ-K семплирование работает так хорошо?

Этот метод работает хорошо, поскольку он по сути пытается предотвратить выход за пределы многообразия хорошего языка, когда мы выбираем что-то плохое, используя только головную часть распределения и обрезая хвостовую часть.


<!-- ## Evaluating Text Generation

Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues. -->


## Оценка генерации текста

Оценка модели языка требует просто вычислить логарифм вероятности выведенных данных. Однако, таким образом сложно оценить текст. Обычно используются метрики совпадения слов с упоминанем (BLEU, ROUGE etc.), но у них есть свои проблемы.


<!-- ## Sequence-To-Sequence Models -->

## Sequence-To-Sequence модели


<!-- ### Conditional Language Models

Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input.

Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer -->

### Обусловленные модели языка

Обусловленные модели языка не подходят для генерации случайых семплов на английском, но они полезны для генерации текста по заданному входу.

Примеры:

- По заданному предложению на французском сгенерируйте английский перевод
- По заданному документу сгенерируйте краткое изложение
- По заданному диалогу сгенерируйте следующий ответ
- По заданному вопросу сгенерируйте ответ


<!-- ### Sequence-To-Sequence Models

Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: Thought Vector
</center> -->


### Sequence-To-Sequence модели

Обычно входной текст закодирован. Эта результирующая характеристика известна как "thought vector", которая затем передаётся декодеру для генерации токенов слово за слово.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Рис. 3</b>: Thought Vector
</center>


<!-- ### Sequence-To-Sequence Transformer

The sequence-to-sequence variation of transformers has 2 stacks:

1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input

2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Fig. 4</b>: Sequence to Sequence Transformer
</center>

Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models. -->


### Sequence-To-Sequence трансформер

Sequence-to-sequence варианты трансформеров имеют 2 стека:

1. Стек кодировщик – Self-attention не маскируется, так что каждый входной токен может смотреть на любой другой токен входа

2. Стек декодировщик – Помимо использования внимания на себе, он также использует внимание по всему входу

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Рис. 4</b>: Sequence to Sequence трансформер
</center>

Каждый токен на выходе имеет прямую связь с каждым предыдущим выходным токеном, а также с каждым входным словом. Связи делают модели очень выразительными и мощными. Эти трансформеры улучшили оценку в машинном переводе по сравнению с предыдущими рекуррентными и свёрточными моделями.


<!-- ## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model. -->


## [Обратный перевод](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

При обучении этих моделей мы обычно полагаемся на большие объёмы размеченного текста. Хороший источник данных - это отчёты Европейского Парламента - текст вручную переведён на несколько языков, который мы можем затем использовать как входы и выходы модели.


<!-- ### Issues

- Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?
- Since models like transformers do much better with more data, how do we use monolingual text efficiently, *i.e.* no input / output pairs?

Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German

- Using some limited bi-text we can acquire same sentences in 2 different languages
- Once we have an English to German model, translate a lot of monolingual words from English to German.

Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that:

- It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English -->


### Проблемы

- Не все языки представлены в Европейском Парламенте, означая, что мы не получим пары переводов по всем языкам, в которых мы можем заинтересоваться. Как мы находим текст для обучения на языке, для которого мы не можем получить данные?
- Поскольку модели как трансформеры намного более производительны при большем количестве данных, как мы используем монолингвистический текст эффективно, *т.е.* нет входных / выходных пар?

Предположим, мы хотим обучить модель для перевода с немецкого языка на английский. Идея обратного перевода заключается в том, что сперва обучаем обратную модель с английского на немецкий.

- Используя некоторый ограниченный парный текст, мы можем получать одинаковые предложения на двух различных языках
- Как только мы имеем модель перевода с английского языка на немецкий, переводим множество монолингвистических слов с английского на немецкий.

Наконец, обучаем модель перевода с немецкого языка на английский, используя немецкие слова, которые были 'обратно переведены' на предыдущем шаге. Отметим, что:

- Неважно, насколько хороша обратная модель - мы можем иметь зашумленные немецкие переводы, но в итоге чисто перевести на английский.
- Нам нужно обучить модель, чтобы понимать английский хорошо за пределами данных англиских/немецких пар (уже переведённых) - использовать большие объёмы монолингвистических данных на английском языке


<!-- ### Iterated Back-translation

- We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data -->


### Итеративный обратный перевод

- Мы можем итерировать процедуру обратного перевода, чтобы генерировать ещё больше двунаправленных текстовых данных и достичь лучшей производительности - просто продолжая обучаться на монолингвистических данных.
- Сильно помогает, когда немного параллельных данных


<!-- ## Massive multilingual MT

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: Multilingual MT
</center>

- Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: Multilingual NN Results
</center>

Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language). -->


## Массивный мультиязычный машинный перевод

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Рис. 5</b>: мультиязычный машинный перевод
</center>

- Вместо того, чтобы пытаться обучить модель переводить с одого языка на другой, попытаться создать нейронную сеть для обучения переводам на несколько языков.
- Модель изучает некоторую общую языко-независимую информацию.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Рис. 6</b>: Результаты мультиязычной нейронной сети
</center>

Отличные результаты, особенно если мы хотим обучить модель переводить на язык, для которого у нас нет много доступных данных (низко ресурсный язык).


<!-- ## Unsupervised Learning for NLP

There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text? -->


## Обучение без учителя для естественной обработки языка

Есть большое количество текстовых данных без какой-либо разметки и немного размеченных данных. Как много мы можем изучить о языке, просто читая неразмеченный текст?


<!-- ### `word2vec`

Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean.

- Goal is to learn vector space representations for words (learn embeddings)

Pretraining task - mask some word and use neighbouring words to fill in the blanks.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: word2vec masking visual
</center>

For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal.

Take the words and apply a linear projection

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  word2vec embeddings
</center>

Want to know

$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

Word embeddings hold some structure

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: Embedding structure example
</center>

- The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors -->


### `word2vec`

Наитие - если слова появляются близко друг к другу в тексте, они вероятно связаны между собой, поэтому мы надеемся, что просто посмотрев на неразмеченный английский текст, мы можем обучиться, что они значат.

- Целью является изучить векторное пространство представлений слов (изучить характеристики)

Задача предобучения - замаскируем некоторые слова и используем соседние слова, чтобы заполнить пробелы.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Рис. 7</b>: word2vec визуализация маскировки
</center>

Например, здесь, идея заключается в том, что "рогатый" и "седовласый" более вероятно появятся в контексте "единорога", чем какого-то другого животного.

Возьмём слова и применим линейную проекцию

<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Рис. 8</b>:  word2vec характеристики
</center>

Хотим узнать

$$
p(\texttt{единороги} \mid \texttt{Эти седовласые ??? были ранее неизвестны})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

Характеристики слов придерживаются некоторой структуры

<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Рис. 9</b>: Пример структуры характеристик
</center>

- Идея заключается в том, что если мы возьмём характеристический вектор для слова "король" после обучения и добавим характеристический вектор для слова "женский" мы получим характеристику, очень близкую к слову "королева"
- Показывает некоторые выразительные разности между векторами


<!-- #### Question: Are the word representation dependent or independent of context?

Independent and have no idea how they relate to other words -->

#### Вопрос: Представления слов зависимы или независимы от контекста?

Независимы и не имеют представления, как они зависят от других слов


<!-- #### Question: What would be an example of a situation that this model would struggle in?

Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word. -->

#### Вопрос: Какой может быть пример ситуации, затруднительный для данной модели?

Интерпретация слов сильно зависит от контекста. Поэтому на примерах двусмысленных слов - слов, которые могут иметь множество значений - модель будет затрудняться, поскольку характеристические вектора не будут захватывать контекст, необходимый для корректного понимания слова.

<!-- ### GPT

To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature.

- Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review

This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks. -->

### GPT

Чтобы добавить контекст, мы можем обучить обусловленную модель языка. Затем, по заданной модели языка, которая предсказывает слово на каждом временном шаге, заменяем каждый выход модели на некоторую другую характеристику.

- Предобучение - предсказываем следующее слово
- Тонкая настройка - заменяем на специфическую задачу. Например:
  - Предсказываем где существительное, а где прилагательное
  - По заданному некоторому тексту, содержащему обзор с Amazon, предсказать оценку настроения для обзора

Этот подход хорош, поскольку мы можем использовать модель повторно. Мы предобучаем одну большую модель и можем тонко настраивать её для других задач.


<!-- ### ELMo

GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot.

Here the approach is to train _two_ language models

- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context.

This is still a "shallow" combination, and we want some more complex interaction between the left and right context. -->


### ELMo

GPT рассматривает только левосторонний контекст, что означает модель не может зависеть от каких-либо будущих слов - это ограничивает, что модель не может делать довольно много.

Подход заключается в обучении _двух_ моделей языка

- Одну на тексте слева направо
- Одну на тексте справа налево
- Конкатенируем выходы двух моделей, чтобы получить представление слова. Теперь можно обусловливать на обоих: правостороннем и левостороннем контексте.

Это до сих пор "поверхностная" комбинация, и мы хотим некоторое более сложное взаимодействие между левым и правым контекстом.


<!-- ### BERT

BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank.

Can scale up BERT (RoBERTa):

- Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text

Even larger improvements on top of BERT performance - on question answering task performance is superhuman now. -->


### BERT

BERT похож на word2vec в том смысле, что у нас также есть задача заполнения пробелов. Однако, в word2vec у нас есть линейные проекции в то время, как в BERT есть большой трансформер, которые может посмотреть больше контекста. Для обучения мы маскируем 15% токенов и пытаемся предсказать пробелы.

Можем увеличить масштаб BERT (RoBERTa):

- Упростим задачу предобучения BERT
- Увеличим размер батча
- Обучим на большом количестве GPUs
- Обучим на ещё большем количестве текста

Ещё больше улучшений поверх BERT производительности - в задаче ответов на вопросы сейчас производительность свехрчеловека.


<!-- ## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP.

- XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order

- SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens

- ELECTRA:

  Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not.

- ALBERT:

  A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy.

- XLM:

  Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better.

The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet


Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training. -->


## [Предобучение для обработки естественного языка](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

Давайте кратко рассмотрим различные подходы предобучения самостоятельного обучения, разработанные для естественной обработки языка.

- XLNet:

  Вместо того, чтобы предсказывать все замаскированные токены условно-независимо, XLNet предсказывает замаскированные токены авторегрессивно в случайном порядке

- SpanBERT

   Маскирует диапазон (последовательность слов) вместо токенов

- ELECTRA:

  Вместо маскировки слов, мы заменяем токены на похожие. Затем мы решаем задачу бинарной классификации, пытаясь предсказать, где были заменены токены.

- ALBERT:

  Облегченный Bert: Мы модифицируем BERT и облегчаем его уменьшая количество весов  the weights в слоях. Это уменьшает количество параметров модели и сложные вычисления. Интересно, что авторам ALBERT не пришлось сильно жертвовать точностью.

- XLM:

  Мультиязычный BERT: Вместо подачи английского текста, мы подаём текст из множества языков. Как и ожидалось, она изучает межязыковые соединения лучше.

Ключевые выводы из различных моделей, упомянутых выше:

- Много различных задач предобучения работают хорошо!

- Глубина модели критична, двунаправленные взаимодействия между словами

- Большой выигрыш от увеличения масштабов предобучения, до сих пор без чётких ограничений.


Большинство моделей, обсуждённых выше разработаны для решения задачи классификации текста. Однако, для решения задачи генерации текста, где мы генерируем выход последовательно, очень похоже на `seq2seq` модель, нам нужен немного другой подход для предобучения.


<!-- #### Pre-training for Conditional Generation: BART and T5

BART: pre-training `seq2seq` models by de-noising text

In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence.

This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc.

BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa. -->


#### Предобучение для обусловленной генерации: BART и T5

BART: предобучение `seq2seq` модели посредством очищения текста от шумов

В BART для предобучения мы берём последовательность и искажаем её, маскируя токены случайным образом. Вместо предсказания замаскированных токенов (как в задаче BERT), мы подаём целую искажённую последовательность и пытаемся предсказать искажённую последовательность целиком.

Этот `seq2seq` подход предобучения даёт нам гибкость в дизайне наших искажённых схем. Мы можем перемешивать предложения, удалять фразы, вставлять новые фразы и т. д.

BART сопоставим с RoBERTa на задачах SQUAD и GLUE. Однако, он был новым SOTA на обобщениях, диалогах и абстрактных вопросах/ответах выборках данных. Эти результаты усиливают нашу мотивацию для BART, быть лучше в задачах генерации текста, чем BERT/RoBERTa.


<!-- ### Some open questions in NLP

- How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language? -->


### Некоторые открытые вопросы в естественной обработке языка NLP

- Как нам интегрировать мировые знания
- Как нам моделировать длинные документы?  (модели на основе BERT обычно используют 512 токенов)
- Как нам лучше всего выполнять многозадачное обучение?
- Можем ли мы выполнять тонкую настройку с меньшим количеством данных?
- Эти модели на самом деле понимают язык?


<!-- ### Summary

- Training models on lots of data beats explicitly modelling linguistic structure.

From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks

- Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy

- Bidirectional context is crucial -->


### Резюме

- Обучение моделей на большом количестве данных лучше, чем явное моделирование лингвистической структуры

С точки зрения дисперсии смещения, трансформеры малосмещённые (очень выразительные) модели. Подавая этим моделям большое количество текста лучше явного моделирования лингвистических структур (сильно смещённых). Архитектуры должны сжимать последовательность дл прохождения через узкие места

- Модели могут изучить много о языке, предсказывая слова в неразмеченном тексте. Это оказывается отличной задачей обучения без учителя. Тонкая настройка для специфических задач после проста.

- Двунаправленность контекста критична


<!-- ### Additional Insights from questions after class:

What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language?

"The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data.

Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way. -->


### Дополнительные идеи из вопросов после лекции:

Какими способами можно измерить 'понимание языка’? КАк мы можем узнать, что эти модели действительно понимают язык?

"Трофей не поместился в чемодан, поскольку он был очень большим”: Разрешить ссылку ‘оно’ в этом предложении сложно для машин. Люди хороши в этой задаче. Есть выборка данных, состоящая из подобных сложных примеров и люди достигают 95% точности на этой выборке. Компьютерные программы были способны достичь лишь около 60% до революции, совершённой трансформерами. Современные модели транфсормеры способны достигать больше 90% на этой выборке данных. Это повзоляет предположить, что эти модели не просто запоминают / эксплуатируют данные, но изучают концепции и объекты посредством статистических шаблонов в данных.

Более того, BERT и RoBERTa достигают сверхчеловеческой производительности на SQUAD и Glue. Текстовые сводки, сгенерированные BART,смотрятся очень реалистично для людей (высокие оценки BLEU). Эти факты свидетельства того, что модели понимают язык в каком-то плане.


<!-- #### Grounded Language

Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization. -->


#### Приземлённый язык

Интересно, что лектор (Майк Льюис, Учёный исследователь, FAIR) работает над концепцией, называемой ‘Grounded Language’. Цель этой области исследований создать разоговорных агентов, которые будут способны болтать или вести переговоры. Болтовня и переговоры абстрактные задачи с нечёткими целями по сравнению с классификацией текста или резюмирование текста.


<!-- #### Can we evaluate whether the model already has world knowledge?

‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’. -->


#### Можем ли мы оценить, когда модель уже обладает мировыми знаниями?

‘Мировые знания’ это абстрактная концепция. Мы можем тестировать модели на очень базовом уровне на их мировые знания, спрашивая их простые вопросы о концепциях, которые нам интересны. Модели как BERT, RoBERTa и T5 имеют миллиарды параметров. Учитывая, что эти модели обучаются на большом своде информационного текста, как Википедия, они запомнили бы факты, используя их параметры и смогли бы ответить на наши вопросы. Более того, мы можем также подумать о проведении того же самого теста знаний до и после тонкой настройки модели для какой-либо задачи. Это даст нам представление о том, как много информации "забыла" модель.
