---
lang-ref: ch.10-1
title: Самостоятельное обучение - Предварительные Задачи
lecturer: Ishan Misra
authors: Aniket Bhatnagar, Dhruv Goyal, Cole Smith, Nikhil Supekar
date: 6 Apr 2020
translation-date: 25 Sep 2020
translator: Kateryna Solonko
---


<!--## [Success story of supervision: Pre-training](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)-->
## [Истории успеха обучения с учителем: Предварительная тренировка (Pre-training)](https://www.youtube.com/watch?v=0KeR6i1_56g&t=75s)

<!--In the past decade, one of the major success recipes for many different Computer Vision problems has been learning visual representations by performing supervised learning for ImageNet classification. And, using these learned representations, or learned model weights as initialization for other computer vision tasks, where a large quantum of labelled data might not be available.-->
На протяжении последнего десятилетия одним из главных рецептов успеха для различных задач Компьютерного Зрения было получение визуальных представлений применяя методы обучения с учителем для ImageNet классификации. Затем эти представления или веса модели использовали для инициализации других задач Компьютерного Зрения для которых существует нехватка тренировочных данных.

<!--However, getting annotations for a dataset of the magnitude of ImageNet is immensely time-consuming and expensive. Example: ImageNet labelling with 14M images took roughly 22 human years.-->
Однако получение аннотаций для набора данных масштаба ImageNet занимает очень много времени и это достаточно дорого. К примеру: для разметки 14 миллионов изображений из ImageNet потребовалось примерно 22 человеко-года.

<!--Because of this, the community started to look for alternate labelling processes, such as hashtags for social media images, GPS locations, or self-supervised approaches where the label is a property of the data sample itself.-->
Поэтому сообщество начало искать альтернативные способы разметки, такие как хэштеги для изображений в социальных сетях, GPS локации или подходы самостоятельного обучения, когда метка является свойством самой выборки данных.

<!--But an important question that arises before looking for alternate labelling processes is:-->
Но перед поиском альтернативных процессов разметки возникает важный вопрос:

<!--**How much labelled data can we get after all?**-->
**Как много размеченных данных мы вообще можем получить?**

<!--
- If we search for all images with object-level category and bounding box annotations then there are roughly 1 million images.
- Now, if the constraint for bounding box coordinates is relaxed, the number of images available jumps to 14 million (approximately).
- However, if we consider all images available on the internet, there is a jump of 5 orders in the quantity of data available.
- And, then there is data apart from images, which requires other sensory input to capture or understand.-->
- Если мы ищем все изображения с категориями на уровне объекта и аннотациями ограничивающих рамок, то получим примерно 1 миллион изображений.
- Теперь, если ослабить ограничение на координаты ограничивающей рамки, количество доступных изображений увеличится приблизительно до 14 миллионов.
- Однако, если рассматривать все изображения, доступные в Интернете, количество доступных данных увеличивается на 5 порядков.
- Кроме того, есть данные, помимо изображений, которые требуют вовлечение других сенсоров для их понимания. 

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img01.jpg" width="80%"/><br>
<!--<b>Figure 1:</b> -->
<b>Рисунок 1:</b>
<!--Variation in available data quantum basis complexity of annotation-->
Количество данных и сложность их разметки
</center>

<!--Hence, drawing from the fact that ImageNet specific annotation alone took 22 human years worth of time, scaling labelling to all internet photos or beyond is completely infeasible.-->
Следовательно, исходя из того факта, что одна только аннотация ImageNet заняла 22 человеческих года, масштабирование разметки для всех фотографий в Интернете или за его пределами совершенно невозможно.

<!--**Problem of Rare Concepts** (*Long Tail Problem*)-->
**Проблема редких концепций** (*Проблема длинного хвоста*)

<!--Generally, the plot presenting distribution of the labels for internet images looks like a long tail. That is, most of the images correspond to very few labels, while there exist a large number of labels for which not many images are present. Thus, getting annotated samples for categories towards the end of the tail requires huge quantities of data to be labelled because of the nature of the distribution of categories.-->
В целом график распределения меток для изображений в Интернете выглядит как длинный хвост. То есть большинство изображений соответствуют очень немногим меткам, тогда как существует большое количество меток, для которых присутствует немного изображений. Таким образом, получение аннотированных выборок для категорий ближе к концу хвоста требует маркировки огромных объемов данных из-за характера распределения категорий.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img02.png" width="80%"/><br>
<!--<b>Figure 2:</b> -->
<b>Рисунок 2:</b>

<!--Variation in distribution of available images with labels-->
Вариация распределения доступных изображений с метками
</center>

<!--**Problem of Different Domains**-->
**Проблема разных доменов**

<!--This method of ImageNet pre-training and fine-tuning on downstream task gets even murkier when the downstream task images belong to a completely different domain, such as medical imaging. And, obtaining a dataset of the quantum of ImageNet for pre-training for different domains is not possible.-->
Этот метод предварительного обучения и тонкой настройки ImageNet для последующих задач становится еще более сомнительным, когда изображения последующих задач относятся к совершенно другой области, например, к медицинской. Часто невозможно получить количество данных сопоставимых в масштабах с ImageNet для предварительного обучения в разных доменах.


<!--## What is self-supervised Learning?-->
## Что такое Самостоятельное обучение?

<!--**Two ways to define self-supervised learning**-->
**Два способа определения самостоятельного обучения**

<!--- **Basis supervised learning definition**, *i.e.* the network follows supervised learning where labels are obtained in a semi-automated manner, without human input.
- **Prediction problem**, where a part of the data is hidden, and rest visible. Hence, the aim is to either predict the hidden data or to predict some property of the hidden data.-->
- **Базовое определение обучения с учителем**, *то есть* обучения на метках полученных полуавтоматическим способом, без участия человека.
- **Проблема прогнозирования**, когда одна часть данных скрыта, а другая часть доступна. Следовательно, цель состоит в том, чтобы либо предсказать скрытые данные, либо предсказать некоторые свойства скрытых данных.

<!---**How self-supervised learning differs from supervised learning and unsupervised learning?**-->
**В чём отличия самостоятельного обучения от обучения с/без учителя?**

<!--- Supervised learning tasks have pre-defined (and generally human-provided) labels,
- Unsupervised learning has just the data samples without any supervision, label or correct output.
- Self-supervised learning derives its labels from a co-occurring modality for the given data sample or from a co-occurring part of the data sample itself.-->
- Задачи обучения с учителем имеют заранее определенные (и обычно предоставляемые человеком) метки,
- При обучении без учителя используются только объекты без какого-либо контроля, меток или правильного ответа.
- Самостоятельное обучение получает свои метки из совпадения свойств для данного объекта выборки или из возникающих вместе (co-occurring) частей самой выборки данных.


<!--### Self-Supervised Learning in Natural Language Processing-->
### Самостоятельное обучение для Обработки Естественного Языка (NLP)

#### Word2Vec

<!--- Given an input sentence, the task involves predicting a missing word from that sentence, which is specifically omitted for the purpose of building a pretext task.
- Hence, the set of labels becomes all possible words in the vocabulary, and, the correct label is the word that was omitted from the sentence.
- Thus, the network can then be trained using regular gradient-based methods to learn word-level representations.-->
- Имея входное предложение, задача состоит в предсказании пропущенного слова из этого предложения, которое специально пропущено с целью создания предварительной задачи (pretext task).
- Следовательно, набором меток становится весь словарь, и правильная метка - это слово, которое было опущено в предложении.
- Таким образом можно обучить сеть для получение представлений слов используя стандартные градиентные методы.


<!--### Why self-supervised learning?-->
### Почему именно Самостоятельное обучение?

<!--- Self-supervised learning enables learning representations of data by just observations of how different parts of the data interact.
- Thereby drops the requirement of huge amount of annotated data.
- Additionally, enables to leverage multiple modalities that might be associated with a single data sample.-->
- Самостоятельное обучение позволяет изучать представления данных, просто наблюдая за тем, как взаимодействуют различные части данных.
- Тем самым отпадает потребность в огромном количестве аннотированных данных.
- Кроме того оно позволяет использовать несколько модальностей, которые могут быть связаны с одной выборкой данных.


<!--### Self-Supervised Learning in Computer Vision-->
### Самостоятельное обучение в Компьютерном Зрении

<!--Generally, computer vision pipelines that employ self-supervised learning involve performing two tasks, a pretext task and a real (downstream) task.

- The real (downstream) task can be anything like classification or detection task, with insufficient annotated data samples.
- The pretext task is the self-supervised learning task solved to learn visual representations, with the aim of using the learned representations or model weights obtained in the process, for the downstream task. -->

Как правило, решения задач компьютерного зрения, использующие сомообучение, включают в себя выполнение двух задач: предварительной задачи и реальной (нисходящей) задачи.

- Реальная (нисходящая) задача может быть чем угодно, например задачей классификации или обнаружения, с недостаточными выборками аннотированных данных.
- Предзадача (pretext) - это задача самостоятельного обучения, решаемая для получения визуальных представлений с целью использования полученных представлений или весов модели, в процессе обучения последующей задачи.


<!--#### Developing pretext tasks -->
#### Создание предзадач 

<!--- Pretext tasks for computer vision problems can be developed using either images, video, or video and sound.
- In each pretext task, there is part visible and part hidden data, while the task is to predict either the hidden data or some property of the hidden data.-->
- Предварительные задачи для компьютерного зрения могут быть разработаны с использованием изображений, видео или видео и звука.
- В каждой предзадаче есть частично видимые и частично скрытые данные, тогда как задача состоит в том, чтобы предсказать либо скрытые данные, либо какое-то свойство скрытых данных.


<!--#### [Example pretext tasks: Predicting relative position of image patches](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)-->
#### [Пример предзадачи: Предсказание относительного расположения частей изображения](https://www.youtube.com/watch?v=0KeR6i1_56g&t=759s)

<!--- Input: 2 image patches, one is the anchor image patch while the other is the query image patch.
- Given the 2 image patches, the network needs to predict the relative position of the query image patch with respect to the anchor image patch.
- Thus, this problem can be modelled as an 8-way classification problem, since there are 8 possible locations for a query image, given an anchor.
- And, the label for this task can be automatically generated by feeding the relative position of query patch with respect to the anchor.-->
- Вход: 2 фрагмента изображения, один - фрагмент от которого ведётся отсчёт, а второй - фрагмент-запрос.
- Дано 2 фрагмента изображения, сеть должна спрогнозировать их относительное положение. 
- Таким образом эта проблема может быть смоделирована как проблема 8-классовой классификации, поскольку существует 8 возможных местоположений для фрагмента- запроса относительно данного фрагмента.
- И метка для этой задачи может быть автоматически сгенерирована путем подачи относительной позиции фрагмента-запроса относительно первого фрагмента.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img03.jpg" width="70%"/><br>
<!--<b>Figure 3:</b> -->
<b>Рисунок 3:</b>
<!--Relative Position task-->
Задача относительной позиции
</center>


<!--#### Visual representations learned by relative position prediction task-->
#### Визуальное представление полученное из задачи предсказания относительной позиции

<!--We can evaluate the effectiveness of the learned visual representations by checking nearest neighbours for a given image patch basis feature representations provided by the network. For computing nearest neighbours of a given image patch,

- Compute the CNN features for all images in the dataset, that will act as the sample pool for retrieval.
- Compute CNN features for the required image patch.
- Identify nearest neighbours for the feature vector of the required image, from the pool of feature vectors of images available.

Relative position task finds out image patches that are very similar to the input image patch, while maintains invariance to factors such as object colour. Thus, the relative position task is able to learn visual representations, where representations for image patches with similar visual appearance are closer in the representation space as well.-->
Мы можем оценить эффективность изученных визуальных представлений, проверив ближайших соседей в пространстве признаков полученных из обученной сети. Для вычисления ближайших соседей данного участка изображения,
- Вычислить функции CNN для всех изображений в наборе данных, которые будут выступать в качестве пула образцов для поиска.
- Вычислить CNN признаки для рассматриваемого фрагмента изображения.
- Определите ближайших соседей для вектора признаков рассматриваемого изображения из пула векторов признаков всех доступных изображений.

Задача относительного положения обнаруживает фрагменты изображения, которые очень похожи на фрагмент-запрос, но при этом сохраняет инвариантность к таким факторам, как цвет объекта. Таким образом, задача относительного положения может изучать визуальные представления, где представления для похожих фрагментов изображения  также близки в пространстве представлений.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img04.jpg" width="100%"/><br>
<!--<b>Figure 4:</b> -->
<b>Рисунок 4:</b> 
<!--Relative Position: Nearest Neighbours-->
Отосительная Позиция: Ближайшие Соседи
</center>


<!--#### Predicting Rotation of Images-->
#### Предсказание поворота изображения

<!--- Predicting rotations is one of the most popular pretext task which has a simple and straightforward architecture and requires minimal sampling.
- We apply rotations of 0, 90, 180, 270 degrees to the image and send these rotated images to the network to predict what sort of rotation was applied to the image and the network simply performs a 4-way classification to predict the rotation.
- Predicting rotations does not make any semantic sense, we are just using this pretext task as a proxy to learn some features and representations to be used in a downstream task.-->
- Прогнозирование поворота - одна из самых популярных предзадач, которая имеет простую и понятную архитектуру и требует минимальной выборки.
- Мы применяем поворот к изображению на 0, 90, 180, 270 градусов и отправляем эти повернутые изображения в сеть, чтобы предсказать, какой тип поворота был применен к изображению, и сеть просто выполняет 4-классовую классификацию для прогнозирования поворота.
- Прогнозирование поворота не имеет никакого семантического смысла, мы просто используем эту предзадачу в качестве прокси для изучения некоторых признаков и представлений, которые будут использоваться в последующих задачах.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img05.png" width="80%"/><br>
<!--<b>Figure 5:</b> -->
<b>Рисунок 5:</b>
<!--Rotations of Image-->
Поворот изображения
</center>


<!--#### Why rotation helps or why it works?-->
#### Почему предзадача поворота полезна и как это работает?

<!--It has been proven that it works empirically. The intuition behind it is that in order to predict the rotations, model needs to understand the rough boundaries and representation of an image. For example, it will have to segregate the sky from water or sand from the water or will understand that trees grow upwards and so on. -->
Эмпирическим путём было доказано что это работает. Интуитивно можно понять что для того чтобы предсказать поворот модель должна изучить приблизительные границы и представления изображения. К примеру, она должна была бы различать небо и воду или песок и воду, или понимать что деревья растут вверх и так далее. 


<!--#### Colourisation-->
#### Раскраска 

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img06.png" width="65%"/><br>
<!--<b>Figure 6:</b> -->
<b>Рисунок 6: Раскраска </b>
<!--Colourisation-->
</center>

<!--In this pretext task, we predict the colours of a grey image. It can be formulated for any image, we just remove the colour and feed this greyscale image to the network to predict its colour. This task is useful in some respects like for colourising the old greyscale films [//]: <> (we can apply this pretext task). The intuition behind this task is that the network needs to understand some meaningful information like that the trees are green, the sky is blue and so on.-->

В этой предзадаче мы предсказываем цвета в черно-белом изображении. Эта задача может быть сформулирована для любого изображения, мы просто убираем цвет и отдаём черно-белое изображение сети для предсказания цвета. Эта задача полезна к примеру для раскраски старой черно-белой фотографии. Интуитивно эта задача заставляет сеть изучить информацию что, допустим, деревья зелёные, небо голубое и т.д.

<!--It is important to note that colour mapping is not deterministic, and several possible true solutions exist. So, for an object if there are several possible colours then the network will colour it as grey which is the mean of all possible solutions. There have been recent works using Variational Auto Encoders and latent variables for diverse colourisation.-->

Важно заметить, что соответствие объектов цветам не детерминировано, и существует несколько правильных ответов. Тогда если для объекта существует несколько возможных раскрасок сеть выдаст серый цвет, который является средним из всех возможных решений.


<!--#### Fill in the blanks-->
#### Заполните пробелы

<!--We hide a part of an image and predict the hidden part from the remaining surrounding part of the image. This works because the network will learn the implicit structure of the data like to represent that cars run on roads, buildings are composed of windows & doors and so on.-->
Мы закрываем часть картинки и затем пытаемся предсказать закрытую часть по оставшейся видимой части. Это работает потому что сеть выучит неявную структуру данных, как допустим то что машины ездят по дорогам, а у зданий есть окна и двери, и т.д.


<!--### Pretext Tasks for videos-->
### Предварительные задачи  для видео

<!--Videos are composed of sequences of frames and this notion is the idea behind self-supervision, which can be leveraged for some pretext tasks like predicting the order of frames, fill in the blanks and object tracking.-->
Видео состоят из последовательности кадров и именно это используется  для построения предварительных задач для самостоятельного обучения, таких как предсказание порядка кадров, заполнение пробелом и отслеживание объектов.


<!--#### Shuffle & Learn-->
#### Перестановка и обучение (Shuffle & Learn)

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img07.png" width="70%"/><br>
<!--<b>Figure 7:</b> -->
<b>Рисунок 7: Интерполяция</b>
<!--Interpolation-->
</center>

<!--Given a bunch of frames, we extract three frames and if they are extracted in the right order we label it as positive, else if they are shuffled, label it as negative. This now becomes a binary classification problem to predict if the frames are in the right order or not. So, given a start and end point, we check if the middle is a valid interpolation of the two.-->
Возьмём набор кадров и извелечем три кадра, и если они были извелечены в правильном порядке мы присваиваем позитивную метку, в противном случае кадры перемешиваються и получают негативную метку. Таким образом это представляет собой задачу бинарной классификации - предсказать в правильно ли порядке росположены кадры. При данном первом и последнем кадрах мы проверяем являеться ли средний кадр интерполяцией между ними.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img08.png" width="70%"/><br>
<!--<b>Figure 8:</b> Shuffle & Learn architecture-->
<b>Рисунок 8: Архитектура Перемешивания и Обучения</b>
</center>

<!--We can use a triplet Siamese network, where the three frames are independently fed forward and then we concatenate the generated features and perform the binary classification to predict if the frames are shuffled or not.-->
Мы можем использовать триплетную сиамскую сеть, в которую независимо подаються три кадра, затем полученные признаки конкатенируються и производиться бинарная классификация, предсказывающая перемешаны кадры или нет.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img09.png" width="100%"/><br>
<!--<b>Figure 9:</b> Nearest Neighbours Representation-->
<b>Рисунок 8: Представления Ближайших Соседей</b>
</center>

<!--Again, we can use the Nearest Neighbours algorithm to visualize what our networks are learning. In fig. 9 above, first we have a query frame which we feed-forward to get a feature representation and then look at the nearest neighbours in the representation space. While comparing, we can observe a stark difference between neighbours obtained from ImageNet, Shuffle & Learn and Random.-->
Опять таки, мы можем использовать алгоритм ближайших соседей, для визуализвции того, что изучает наша сеть. На рис. 9 выше, сперва у нас есть кадр запроса, который мы передаем cети, чтобы получить набор признаков, а затем смотрим на ближайших соседей в этом пространстве. При сравнении мы можем наблюдать резкую разницу между соседями, полученными из ImageNet, Перемешивании и Обучении (Shuffle & Learn) и Случайным выбором.

<!--ImageNet is good at collapsing the entire semantic as it could figure out that it is a gym scene for the first input. Similarly, it could figure out that it is an outdoor scene with grass etc. for the second query. Whereas, when we observe Random we can see that it gives high importance to the background colour.-->
ImageNet хороша в представлении всей семантики изображения, поскольку она может определить, что в первом случае это сцена спортзала. Точно так же она может определить, что это сцена на природе, с травой и т.д. во втором случае. В то же время, мы видим, что Случайный выбор придает большое значение цвету фона.

<!--On observing Shuffle & Learn, it is not immediately clear whether it is focusing on the colour or on the semantic concept. After further inspection and observing various examples, it was observed that it is looking at the pose of the person. For example, in the first image the person is upside down and in second the feet are in a particular position similar to query frame, ignoring the scene or background colour. The reasoning behind this is that our pretext task was predicting whether the frames are in the right order or not, and to do this the network needs to focus on what is moving in the scene, in this case, the person.-->
При наблюдении за Shuffle & Learn не совсем очевидно фокусируется ли она на цвете или на семантике изображения. После дальнейшего рассмотрения и наблюдения за различными примерами было замечено, что она смотрит на позу человека. Например, на первом изображении человек перевернут, а на втором - ноги находятся в определенном положении, аналогичном кадру запроса, без учета сцены или цвета фона. Причина этого в том, что наша предварительная задача заключалась в предсказании в правильном ли порядке находяться данные кадры, и для этого сети необходимо сосредоточиться на том, что движется, в данном случае - на человеке.

<!--It was verified quantitatively by fine-tuning this representation to the task of human key-point estimation, where given a human image we predict where certain key points like nose, left shoulder, right shoulder, left elbow, right elbow, etc. are. This method is useful for tracking and pose estimation.-->
Это было подтверждено количественно путем дообучения этих представлений для задачи оценки ключевых точек человека, где при данном изображении человека мы предсказываем, где находятся определенные ключевые точки, такие как нос, левое плечо, правое плечо, левый локоть, правый локоть и т.д. Этот метод полезен для отслеживания и оценки позы.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img10.png" width="80%"/><br>
<!--<b>Figure 10:</b> Key point Estimation comparison-->
<b>Рисунок 10:</b> Сравнение качества Оценки Ключевых Точек.
</center>

<!--In figure 10, we compare the results for supervised ImageNet and Self-Supervised Shuffle & Learn on FLIC and MPII datasets and we can see that Shuffle and Learn gives good results for key point estimation.-->
На рисунке 10 мы сравниваем результаты для обученной с учителем ImageNet и самообученной Shuffle & Learn на датасетах FLIC и MPII. Мы видим что Shuffle & Learn показывает хорошый результат на задаче оценки ключевых точек.


<!--### Pretext Tasks for videos and sound-->
### Предварительные задачи для видео и аудио

<!--Video and Sound are multi-modal where we have two modalities or sensory inputs one for video and one for sound. Where we try to predict whether the given video clip corresponds to the audio clip or not.-->
Видео и аудио - мультимодальны, им присущи две модальности или сенсорных входа: один для видео и один для аудио. Мы попытаемся определить относится ли данный видео клип к данному аудио клипу.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img11.png" width="100%"/><br>
<!--<b>Figure 11:</b> Video and sound sampling-->
<b>Рисунок 11:</b> Сэмплирование видео и аудио
</center>

<!--Given a video with audio of a drum, sample the video frame with corresponding audio and call it a positive set. Next, take the audio of a drum and the video frame of a guitar and tag it as a negative set. Now we can train a network to solve this as a binary classification problem.-->
Дано видео со звуком барабана, выбираем видеокадр с соответствующим звуком и называем это положительным набором. Затем возьмём звук барабана и видеокадр гитары и назовём это негативным набором. Теперь мы можем обучить сеть решать эту задачу как задачу бинарной классификации.

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img12.png" width="70%"/><br>
<!--<b>Figure 12:</b> Architecture-->
<b>Рисунок 12:</b> Архитектура
</center>

<!--**Architecture:** Pass the video frames to the vision subnetwork and pass the audio to the audio subnetwork, which gives 128-dimensional features and embeddings, we then fuse them together and solve it as a binary classification problem predicting if they correspond with each other or not.-->
**Архитектура:** Передаём видеокадры в подсеть для изображений а звук - в подсеть для аудио, из которой получаем 128-мерные представления, затем мы объединяем их вместе и решаем как задачу бинарной классификации, предсказывающей соответствуют ли они друг другу.

<!--It can be used to predict what in the frame might be making a sound. The intuition is if it is the sound of a guitar, the network roughly needs to understand how the guitar looks and same should be true for drums.-->
Это может использоваться, для предсказывания что именно издает звук в кадре. Интуиция состоит в том, что если это звук гитары, сети примерно необходимо понимать, как выглядит гитара, то же самое должно быть верно и для ударных.


<!--## [Understanding what the "pretext" task learns](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)-->
## [Что изучает "предварительня" задача](https://www.youtube.com/watch?v=0KeR6i1_56g&t=2426s)

<!--* Pretext tasks should be **complementary**-->

 <!-- * Let's take for example the pretext tasks *Relative Position* and *Colourisation*. We can boost performance by training a model to learn both pretext tasks as shown below:-->
* Предварительная задача должна **дополнять**
  * Возьмём, к примеру, предварительную задачу *Относительной Позиции* и *Расскраски*. Мы можем улучшить качество тренируя модель использовать обе эти задачи, как показано ниже:

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img13.png" width="80%"/><br>
<!--<b>Figure 13:</b> Comparison of disjoint *vs.* combined training of Relative Position and Colourisation pretext tasks. ResNet101. (Misra)-->
<b>Рисунок 13:</b> Сравнение раздельных и совместных использований предварительных задач Относительной Позиции (Relative Position) и Расскраски (Colourisation) и их влияние на качество модели на основной задаче. ResNet101. (Misra)
</center>

<!--* A single pretext task may not be the right answer to learn SS representations-->
* Одной предварительной задачи может быть не достаточно для получения представлений самообучением

<!--* Pretext tasks vary greatly in what they try to predict (difficultly)-->
* Предварительные задачи очень разнятся в зависимости от того что они пытаются предсказать (по сложности)

<!--
  * Relative position is easy since it's a simple classification
  * Masking and fill-in is far harder ==> **better representation**
  * **Contrastive methods** generate even more info than pretext tasks-->

  * Задача относительной позиции сравнительно проста так как сводится к простой классификации
  * Маскировка и заполнение куда сложнее ==> соответственно получает **лучшие представления**
  * **Контрастивные методы** генерируют еще больше информации чем даже предвариетльные задачи

<!--* **Question:** How do we train multiple pre-training tasks?-->
* **Вопрос:** Как нам обучать несколько предварительных задач одновременно?

<!--* The pretext output will depend on the input. The final fully-connected layer of the network can be **swapped** depending on the batch type.
  * For example: A batch of black-and-white images is fed to the network in which the model is to produce a coloured image. Then, the final layer is switched, and given a batch of patches to predict relative position.-->
  * Выход предварительной задачи зависит от её входа. Последний полносвязный слой сети может быть заменён в зависимости от типа батча.
  * К примеру: Батч чёрно белых изображений отправлется на вход сети, которая должна произвести цветные изображение. Затем последний слой подменяеться и подаётся батч кусков изображения для определения относительной позиции.

<!--*  **Question:** How much should we train on a pretext task?-->
*  **Вопрос:** Сколько нужно обучаться на предварительной задаче?

<!--  * Rule of thumb: Have a very difficult pretext task such that it improves the downstream task.
  * In practice, the pretext task is trained, and may not be re-trained. In development, it is trained as part of the entire pipeline.-->

  * Как правило: Используйте сложную предварительную задачу, так чтобы она улучшила качество основной задачи.
  * На практике производится тренировка на предварительной задаче только один раз. Во время разработки она тренируется как часть всего пайплайна, вместе с основной задачей.


<!--## Scaling Self-Supervised Learning-->
## Масштабирование Самостоятельного обучения


<!--### Jigsaw Puzzles-->
### Головоломки

<!--* Partition an image into multiple tiles and then shuffle these tiles. The model is then tasked with un-shuffling the tiles back to the original configuration. (Noorozi & Favaro, 2016)-->
* Разделим изображение на несколько кусочков и перемешаем их. Затем модель постарается расставить их по своим местам. (Noorozi & Favaro, 2016)

 <!-- * Predict which permutation was applied to the input
  * This is done by creating batches of tiles such that **each tile of an image is evaluated independently**. The convolution output are then concatenated and the permutation is predicted as in figure below-->

  * Предсказать какая перестановка произошла 
  * Это делается путем создания групп кусочков, так что **каждый кусочек изображения оценивается независимо**. Затем выходные данные свертки (конволюции) объединяются, и перестановка прогнозируется, как показано на рисунке ниже. 

<center>
<img src="{{site.baseurl}}/images/week10/10-1/img14.png" width="80%"/><br>
<!--<b>Figure 14:</b> Siamese network architecture for a Jigsaw pretext task. Each tile is passed through independently, with encodings concatenated to predict a permutation. (Misra)-->
<b>Рисунок 14:</b> Архитектура сиамской сети для предварительной задачи решения Головоломки. Каждый кусочек изображения подаётся независимо, и представления конкатенируются для предсказания перестановки.
</center>

  <!--* Considerations:
    1. Use a subset of permutations *i.e.* From 9!, use 100)
    2. The n-way ConvNet uses shared parameters
    3. The problem complexity is the size of the subset. The *amount of information you are predicting.*-->
  * Заметки:
    1. Использовать подмножество всех возможных перестановок. К примеру не все 9!, а 100)
    2. Использовать общие параметры между слоями многослойной конволюционной сети
    3. Сложность проблемы заключается в размере подмножества. *Количество информации, которое прогнозируется.*

 <!--* Sometimes, this method can perform better on downstream tasks than supervised methods, since the network is able to learn some concepts about the geometry of its input.-->
* Иногда этот метод показывает лучшие результаты на основной задаче чем методы обучения с учителем, так как сеть может получить информацию о геометрии входа.

 <!--* Shortcomings: Few Shot Learning: Limited number of training examples-->
* Недостатки: Обучение по нескольким примерам: Ограниченое количество тренировочных данных

  <!--* **Self-supervised representations are not as sample efficient**-->
  * **Представления, полученный при самообучении, нуждаются в большом количестве данных (используют данные менее ефективно)** 


 <!--### Evaluation: Fine-tuning *vs.* Linear Classifier-->
### Оценка качества: Дообучений в сравнении с Линейным Классификатором

   <!--This form of evaluation is a kind of **Transfer Learning**.-->
  Эта форма оценки качества является видом **Трансферного обучения**.

 <!--* **Fine Tuning**: When applying to our downstream task, we use our entire network as an **initialization** for which to train a new one, updating all the weights.-->
* **Дообучение**: Когда мы используем предварительную задачу для основной мы берём всю предобученную сеть как инициальзацию, и дообучаем на основной задаче.

 <!--* **Linear Classifier**: On top of our pretext network, we train a small linear classifier to perform our downstream task, leaving the rest of the network intact.-->
* **Линейный Классификатор**: На основе нашей предварительной задачи мы строим простой линейный классификатор для основной задачи, и не меняем веса в процессе обучения.

<!-- A good representation should transfer with a **little training**.-->
> Хорошее представление не будет нуждатся в большом количестве **дообучения**.

<!--* It is helpful to evaluate the pretext learning on a **multitude of different tasks**. We can do so by extracting the representation created by different layers in the network as **fixed features** and evaluating their usefulness across these different tasks.-->
* Полезно оценить качество предарительного обучения на **различных задачах**. Мы можем это сделать, извлекая представления созданное разными слоями сети и **фиксируя эти представления**, оценивая их полезность для решения этих различных задач.
<!--  * Measurement: Mean Average Precision (mAP) --The precision averaged across all the different tasks we are considering.
  * Some examples of these tasks include: Object Detection (using fine-tuning), Surface Normal Estimation (see NYU-v2 dataset)
* What does each layer learn?
  * Generally, as the layers become deeper, the mean average precision on downstream tasks using their representations will increase.
  * However, the **final layer** will see a sharp drop in the mAP due to the layer becoming overly **specialized**.
    * This contrasts with supervised networks, in that the mAP generally always increases with depth of layer.
    * This shows that the pretext task is **not well-aligned** to the downstream task.-->
  * Измерения: Средняя точность (Mean Average Precision - mAP) - точность, усредненная для всех различных задач, которые мы рассматриваем.
  * Некоторые примеры этих задач включают: обнаружение объектов (с использованием дообучения), оценка нормали поверхности (см. Набор данных NYU-v2)
* Что изучает каждый из слоёв?
  * Как правило, по мере того, как слои становятся глубже, средняя точность последующих задач, использующих их представления, увеличивается.
   * Однако **последний слой** увидит резкое падение mAP из-за того, что слой стал чрезмерно **специализированным**.
     * Это контрастирует с сетями обучаемые с учителем в том, что mAP обычно всегда увеличивается с глубиной слоя.
     * Это показывает, что предварительная задача **плохо согласована** с последующей задачей.



