---
lang-ref: ch.01-3
lang: ru
title: Движущая сила задачи, линейная алгебра и визуализация
lecturer: Alfredo Canziani
authors: Derek Yen, Tony Xu, Ben Stadnick, Prasanthi Gurumurthy
date: 28 Jan 2020
translation-date: 06 Oct 2020
translator: Evgeniy Pak
---


<!-- ## Resources -->
## Ресурсы

<!-- Please follow Alfredo Canziani [on Twitter @alfcnz](https://twitter.com/alfcnz). Videos and textbooks with relevant details on linear algebra and singular value decomposition (SVD) can be found by searching Alfredo's Twitter, for example type `linear algebra (from:alfcnz)` in the search box. -->

Пожалуйста, подпишитесь на [Твиттер @alfcnz](https://twitter.com/alfcnz) Alfredo Canziani. Видео и книги с соответствующими подробностями по линейной алгебре и сингулярному разложению (SVD) можно найти при помощи поиска по твиттеру Alfredo, например, напечатайте `linear algebra (from:alfcnz)` в поле поиска.

<!-- ## [Transformations and motivation](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s) -->

## [Преобразования и мотивация](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=233s)

<!-- As a motivating example, let us consider image classification. Suppose we take a picture with a 1 megapixel camera. This image will have about 1,000 pixels vertically and 1,000 pixels horizontally, and each pixel will have three colour dimensions for red, green, and blue (RGB). Each particular image can then be considered as one point in a 3 million-dimensional space. With such massive dimensionality, many interesting images we might want to classify -- such as a dog *vs.* a cat -- will essentially be in the same region of the space.

In order to effectively separate these images, we consider ways of transforming the data in order to move the points. Recall that in 2-D space, a linear transformation is the same as matrix multiplication. For example, the following are linear transformations:

-   Rotation (when the matrix is orthonormal).
-   Scaling (when the matrix is diagonal).
-   Reflection (when the determinant is negative).
-   Shearing.

Note that translation alone is not linear since 0 will not always be mapped to 0, but it is an affine transformation. Returning to our image example, we can transform the data points by translating such that the points are clustered around 0 and scaling with a diagonal matrix such that we "zoom in" to that region. Finally, we can do classification by finding lines across the space which separate the different points into their respective classes. In other words, the idea is to use linear and nonlinear transformations to map the points into a space such that they are linearly separable. This idea will be made more concrete in the following sections. -->

В качестве мотивирующего примера давайте рассмотрим классификацию изображений. Предположим, что мы делаем снимок на камеру с разрешением 1 мегапиксель. Это изображение будет размером около 1,000 пикселей по вертикали и 1,000 пикселей по горизонтали, и каждый пиксель будет также содержать три цветовых размерности для красного, зелёного и синего (RGB). Каждое изображение затем можно рассматривать как точку в 3 миллионо-мерном пространстве. При такой огромной размерности многие интересные изображения, которые мы могли бы захотеть классифицировать -- такие как собака *против* кошки -- будут в основном находиться в одной и той же области пространства.

Чтобы эффективно разделить эти изображения, мы рассматриваем способы преобразования данных для перемещения точек. Напомним, что в двумерном пространстве, линейные преобразования эквивалентны умножению на матрицу. Например, следующие линейные преобразования:

-   Поворот (когда матрица ортонормальная).
-   Масштабирование (когда матрица диагональная).
-   Отражение (когда определитель матрицы отрицательный).
-   Сдвиг.

Обратите внимание, что перемещение само по себе не является линейным, поскольку 0 не всегда будет отображаться в 0, но это афинное преобразование. Возвращаясь к нашему примеру с изображением, мы можем преобразовать точки данных, перемещая их таким образом, что точки будут кластеризованы вокруг 0 и, масштабируя диагональной матрицей таким образом, что мы "приблизим" эту область. Наконец, мы можем произвести классификацию, находя прямые в пространстве, которые разделяют различные точки по их соответствующим классам. Другими словами, идея состоит в применении линейных и нелинейных преобразований для отображения точек в пространстве таким образом, чтобы они стали линейно-разделимы. В следующих разделах будет больше конкретики относительно этой идеи.


<!-- ## [Data visualization - separating points by colour using a network](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s) -->
## [Визуализация данных - разделение точек по цветам при помощи сети](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=798s)

<!-- In our visualization, we have five branches of a spiral, with each branch corresponding to a different colour. The points live in a two dimensional plane and can be represented as a tuple; the colour represents a third dimension which can be thought of as the different classes for each of the points. We then use the network to separate each of the points by colour.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Input points, pre-network             |            (b) Output points, post-network             |

<center> Figure 1: Five colour spiral </center>
The network \"stretches\" the space fabric in order to separate each of the points into different subspaces. At convergence, the network separates each of the colours into different subspaces of the final manifold. In other words, each of the colours in this new space will be linearly separable using a one *vs.* all regression. The vectors in the diagram can be represented by a five by two matrix; this matrix can be multiplied to each point to return scores for each of the five colours. Each of the points can then be classified by colour using their respective scores. Here, the output dimension is five, one for each of the colours, and the input dimension is two, one for the x and y coordinates of each of the points. To recap, this network basically takes the space fabric and performs a space transformation parametrised by several matrices and then by non-linearities. -->


В нашей визуализации у нас есть пять ветвей спирали, каждая из которых соответствует своему цвету. Точки находятся на двумерной плоскости и могут быть представлены в виде кортежа: цвет представляет третье измерение, которое можно интерпретировать, как различные классы для каждой из точек. Затем мы используем сеть для разделения каждой точки по цветам.

| <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral1.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week01/01-3/Spiral2.png" width="200px"/></center> |
|             (a) Точки на входе сети             |            (b) Точки на выходе сети             |

<center> Рисунок 1: Пятицветная спираль </center>
Сеть \"растягивает\" такнь пространства, чтобы разделить все точки на разные подпространства. При сходимости сеть разделяет каждый из цветов в различные подпространства конечного многообразия. Другими словами, каждый из цветов в этом новом пространстве будет линейно отделим, применяя регрессию один *против* всех. Вектора на графике могут быть представлены матрицей размера пять на два, эта матрица может быть умножена на каждую точку, чтобы получить оценки для каждого из пяти цветов. Каждая из точек затем может быть классифицирована по цвету при помощи их соответствующих оценок. Здесь размерность выхода равна пяти, по одной на каждый цвет, а размерность входа рвна двум, по одной для x и y координат каждой точки. Напомним, эта сеть в основном берёт ткань пространства и производит преобразование пространства, параметризованное сначала несколькими матрицами, а затем - нелинейностями.


<!-- ### Network architecture -->
### Архитектура сети

<!-- <center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Figure 2: Network Architecture
</center>

The first matrix maps the two dimensional input to a 100 dimensional intermediate hidden layer. We then have a non-linear layer, `ReLU` or Rectified Linear Unit, which is simply *positive part* $(\cdot)^+$ function. Next, to display our image in a graphical representation, we include an embedding layer that maps the 100 dimensional hidden layer input to a two-dimensional output. Lastly, the embedding layer is projected to the final, five-dimensional layer of the network, representing a score for each colour.
-->

<center>
<img src="{{site.baseurl}}/images/week01/01-3/Network.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
Рисунок 2: Архитектура сети
</center>

Первая матрица отображает двумерный вход в 100 мерный промежуточный скрытый слой. Затем у нас идёт нелинейный слой, `ReLU` или Rectified Linear Unit, который является просто *положительной частью* $(\cdot)^+$ функции. После, чтобы отобразить наше изображение графически, мы добавили встраиваемый слой, который отображает 100 мерный скрытый слой-вход в двумерный выход. Наконец, встраиваемый слой проецируется на последний, пятимерный слой сети, представляющий оценку для каждого цвета.


<!-- ## [Random projections - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s) -->
## [Произвольные проекции - Jupyter Notebook](https://www.youtube.com/watch?v=5_qrxVq1kvc&t=1693s)

<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). In order to run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md). -->

Jupyter Notebook можно найти [здесь](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/02-space_stretching.ipynb). Чтобы запустить notebook, убедитесь, что Вы установили `pDL` среду, как указано в [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).

<!-- ### PyTorch `device` -->
### PyTorch `device`

<!-- PyTorch can run on both the CPU and GPU of a computer. The CPU is useful for sequential tasks, while the GPU is useful for parallel tasks. Before executing on our desired device, we first have to make sure our tensors and models are transferred to the device's memory. This can be done with the following two lines of code:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

The first line creates a variable, called `device`, that is assigned to the GPU if one is available; otherwise, it defaults to the CPU. In the next line, a tensor is created and sent to the device's memory by calling `.to(device)`. -->

PyTorch может запускаться, как на CPU, так и на GPU компьютера. CPU полезен для последовательных задач, в то время как GPU полезна для параллельных задач. Перед выполнением на желаемом устройстве, мы сперва должны убедиться, что наши тензоры и модели переданы в память устройства. Это можно сделать при помощи следующих двух строк кода:

```python
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
X = torch.randn(n_points, 2).to(device)
```

Первая строка создаёт переменную с именем  `device`, которой присваивается значение GPU, если есть хотя бы одна в доступе, в противном случае используется значение по умолчанию - CPU. Посредством следующей строки кода создаётся тензор и отправляется в память устройства вызовом `.to(device)`.

<!-- ### Jupyter Notebook tip -->
### Советы по Jupyter Notebook

<!-- To see the documentation for a function in a notebook cell, use `Shift + Tab.` -->
Чтобы посмотреть документацию для функции в ячейке notebook, используйте `Shift + Tab.`


<!-- ### Visualizing linear transformations -->
### Визуализация линейных преобразований

<!-- Recall that a linear transformation can be represented as a matrix. Using singular value decomposition, we can decompose this matrix into three component matrices, each representing a different linear transformation.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

In eq. (1), matrices $U$ and $V^\top$ are orthogonal and represent rotation and reflection transformations. The middle matrix is diagonal and represents a scaling transformation.

We visualize the linear transformations of several random matrices in Fig. 3. Note the effect of the singular values on the resulting transformations.

The matrices used were generated with Numpy; however, we can also use PyTorch's `nn.Linear` class with `bias = False` to create linear transformations.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Original points       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Figure 3:  Linear transformations from random matrices </center> -->

Напомним, что линейное преобразование может быть представлено матрицей. Используя сингулярное разложение, мы можем разложить эту матрицу на три составляющие матрицы, каждая из которых представляет различные линейные преобразования.

$$
W = U\begin{bmatrix}s_1 & 0 \\ 0 & s_2 \end{bmatrix} V^\top
$$

В уравнении (1) матрицы $U$ и $V^\top$ ортогональны и представляют преобразования поворота и отражения. Матрица посередине диагональная и представляет преобразование масштабирования.

Мы визуализировали линейные преобразования нескольких произвольных матриц на Рис. 3. Обратите внимание на влияние сингулярных значений на результирующие преобразования.

Используемые матрицы были сгенерированны посредством Numpy, однако мы можем также использовать PyTorch `nn.Linear` класс со значением `bias = False` для создания линейных преобразований.

| ![]({{site.baseurl}}/images/week01/01-3/initial_scatter_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1.png) | ![]({{site.baseurl}}/images/week01/01-3/matrix_multiplication_lab1_2.png) |
|     (a) Первоначальные точки       |   (b) $s_1$ = 1.540, $s_2$ = 0.304  |   (c) $s_1$ = 0.464, $s_2$ = 0.017    |

<center> Рисунок 3:  Линейные преобразования произвольных матриц </center>


<!-- ### Non-linear transformations -->
### Нелинейные преобразования

<!-- Next, we visualize the following transformation:

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Recall, the graph of $\tanh(\cdot)$ in Fig. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Figure 4: hyperbolic tangent non-linearity
</center>

The effect of this non-linearity is to bound points between $-1$ and $+1$, creating a square. As the value of $s$ in eq. (2) increases, more and more points are pushed to the edge of the square. This is shown in Fig. 5. By forcing more points to the edge, we spread them out more and can then attempt to classify them.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Non-linearity with $s=1$                 |                 (b) Nonlinearity with $s=5$                  |

<center> Figure 5:   Non-linear Transformations </center> -->

После, мы визуализировали следующие преобразования:

$$
f(\vx) = \tanh\bigg(\begin{bmatrix} s & 0 \\ 0 & s \end{bmatrix} \vx \bigg)
$$

Напомним, график $\tanh(\cdot)$ на Рис. 4.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/tanh_lab1.png" width="250px" /><br>
Рисунок 4: нелиненость вида гиперболический тангенс
</center>

Эффект этой нелинейности заключается в ограничении точек между $-1$ и $+1$, образуя квадрат. Поскольку значение $s$ в уравнении (2) возрастает, всё больше и больше точек отодвигаются к рёбрам квадрата. Это показано на Рис. 5. Отодвигая больше точек к рёбрам, мы разбрасываем их дальше и затем можем попытаться их классифицировать.

| <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=1_lab1.png" width="200px" /> | <img src="{{site.baseurl}}/images/week01/01-3/matrix_multiplication_with_nonlinearity_s=5_lab1.png" width="200px" /> |
|                 (a) Нелинейность при $s=1$                 |                 (b) Нелинейность при $s=5$                  |

<center> Рисунок 5:   Нелинейные преобразования </center>



<!-- ### Random neural net -->
### Произвольная нейронная сеть

<!-- Lastly, we visualize the transformation performed by a simple, untrained neural network. The network consists of a linear layer, which performs an affine transformation, followed by a hyperbolic tangent non-linearity, and finally another linear layer. Examining the transformation in Fig. 6, we see that it is unlike the linear and non-linear transformations seen earlier. Going forward, we will see how to make these transformations performed by neural networks useful for our end goal of classification.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Figure 6:  Transformation from an untrained neural network
</center> -->

Наконец, мы визуализируем преобразование, произведённое простой, необученной нейронной сетью. Сеть состоит из линейного слоя, который производит аффинное преобразование, с последующей нелинейностью вида гиперболический тангенс, и, наконец, ещё одного линейного слоя. Изучая преобразование на Рис. 6, мы видим, что оно отличается от линейных и нелинейных преобразований, виденных ранее. В дальнейшем мы увидим, как сделать эти преобразования, выполняемые нейронными сетями, полезными для нашей конечной цели классификации.

<center>
<img src="{{site.baseurl}}/images/week01/01-3/untrained_nn_transformation_lab1.png" width="200px" /><br>
Рисунок 6:  Преобразование посредством необученной нейронной сети
</center>
