---
lang: ru
lang-ref: ch.01-1
lecturer: Yann LeCun
title: Движущая сила Глубокого Обучения, его История и Вдохновение
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 23 Sep 2020
translator: Evgeniy Pak
---


<!-- ## [Course plan](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s) -->

## [План курса](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

<!-- - Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond -->

- Основы обучения с учителем, Нейронные сети, Глубокое обучение
- Метод обратного распространения ошибки и архитектурные компоненты
- Свёрточные нейронные сети и их применение
- Больше архитектур глубокого обучения
- Хитрости регуляризации / Хитрости оптимизации / Понимание того, как работает глубокое обучение
- Энергетические модели
- Самостоятельное обучение и дальше


<!-- ## Inspiration of Deep Learning and its history -->

## Вдохновление Глубокого обучения и его история

<!-- On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.

The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.

In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.

Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.

In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.

Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:

- The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.

Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields. -->

На концептуальном уровне Глубокое обучение было вдохновлено устройством головного мозга, но не в точности всеми элементами мозга. Для сравнения: изобретатели самолётов были вдохновлены птицами. Основной принцип полёта тот же, но детали разительно отличаются.

История глубокого обучения берёт своё начало в области, которая ныне носит название "кибернетика". Начало положили в 40-е годы 20-го века МакКаллох и Питтс. Они пришли к идее, что нейроны - это пороговые элементы с возможными состояниями: включён и выключен. Вы можете сконструировать Булеву схему, соединяя нейроны один с другим, и управлять логическим выводом нейронами. Головной мозг, в принципе, машина логического вывода, поскольку нейроны двоичны. Нейроны вычисляют взвешенную сумму входов и сравнивают её с их пороговым значением. Нейрон активируется, если значение больше порога и деактивируется, если значение ниже, что и является упрощённым представлением о работе нейронных сетей.

В 1947 у Дональда Хебба появилась идея, что нейроны в головном мозге обучаются, изменяя силу связей между нейронами. Это называется гиперобучением, если два нейрона активируются вместе, тогда связь между ними усиливается; если нет, - связь ослабевает.

Затем, в 1948, кибернетика была предложена Норбертом Винером, который сформулировал идею, что имея систему датчиков и приводов, вы получаете обратную связь и систему саморегулирования. Все правила механизмов обратной связи в автомобилях основываются на этой работе.

В 1957 Фрэнк Розенблатт изобрёл Перцептрон, который являет собой алгоритм обучения, изменяющий веса очень простой нейронной сети.

В целом идея создания интеллектуальных машин путем моделирования множества нейронов зародилась в 1940-х, взлетела в 1950-х, и полностью умерла в конце 1960-х. Основные причины гибели этой области в 60-е:

- Исследователи использовали двоичные нейроны. Однако, чтобы метод обратного распространения ошибки работал, необходимо использовать непрерывные функции активации. В то время у исследователей не было идеи использовать непрерывные нейроны и они не думали, что могут обучать нейронные сети при помощи градиентов, поскольку двоичные нейроны не дифференцируемы.
- С непрерывными нейронами была иная проблема: необходимо было умножить значение функции активации нейрона на вес, чтобы получить вклад во взвешенную сумму. Однако, до 1980-х умножение двух чисел, особенно чисел с плавающей точкой, было чрезвычайно медленным. Это побудило избегать непрерывные нейроны.

Глубокое обучение вновь стало популярным в 1985 году, с появлением метода обратного распространения ошибки. В 1995 году исследования в этой области снова прекратились, и сообщество машинного обучения отказалось от идеи нейронных сетей. В начале 2010-х люди стали использовать нейронные сети в распознавании речи с огромным улучшением производительности, и позже нейронные сети стали широко распространяться в коммерческой сфере. В 2013 компьютерное зрение начало переходить на нейронные сети. В 2016 аналогичный переход наблюдался в обработке естественного языка. Позже похожие революции произойдут в робототехнике, управлении и многих других областях.


<!-- ### Supervised Learning -->

### Обучение с учителем

<!-- $90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.

Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers. -->


$90\%$ приложений глубокого обучения используют обучение с учителем. Обучение с учителем это процесс, в котором в котором вы собираете кучу пар входных и выходных данных, нейросеть получает входные данные и учится предсказывать правильные выходные данные. Когда выходные данные корректны, вы не делаете ничего. Если же выходные данные неверны, вы настраиваете параметры машины и корректируете выходные данные в направлении, которое пожелаете. Уловка здесь в том, как сильно и в каком направлении вы меняете параметры, и это возвращает нас к вычислению градиентов и методу обратного распространения ошибки.

Обучение с учителем просиходит от Перцептрона и Adaline. Adaline основывается на той же архитектуре со взвешенными входами: когда значение выше порога, он активирован, когда ниже, он деактивирован. Перцептрон - это двухслойная нейронная сеть, где второй слой обучаемый, а первый слой неизменяемый. В большинстве случаев, первый слой определяется случайным образом и это называется ассоциативным слоем.


<!-- ## [History of Pattern Recognition and introduction to Gradient Descent](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s) -->

## [История распознавания образов и введение в метод Градиентного Спуска](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!-- The foregoing is the conceptual basis of pattern recognition before deep learning developed. The standard model of pattern recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, pattern recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.

After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.

The simplest multi-layer architecture with tunable parameters and nonlinearity could be: the input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix whose coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.

Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is the loss, computing a distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.

The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.

The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data. -->

Вышеизложенное является концептуальной основой распознавания образов до развития Глубокого Обучения. Стандартная модель распознавания образов состоит из выделителя признаков и обучаемого классификатора. Вход проходит через выделитель признаков, извлекающий соответствующие полезные характеристики входа, такие как обнаружение глаза, когда конечной целью является распознавание лица. Затем вектор признаков передаётся в обучаемый классификатор для вычисления взвешенной суммы и её сравнения с пороговым значением. Здесь обучаемый классификатор может быть перцептроном или однослойной нейронной сетью. Проблема в том, что выделитель признаков должен быть спроектирован вручную. Что значит распознавание образов/компьютерное зрение сосредоточивается на выделителе признаков, учитывая, как реализовать его для конкретной задачи, обучаемому классификатору уделяется меньше внимания.

После появления и развития глубокого обучения, 2-хэтапный процесс сменился последовательностью модулей. В каждом модуле есть настраиваемые параметры и нелинейность. Так можно соединять их, создавая многослойную структуру. Вот почему это называется "глубокое обучение". Причина, по которой используется нелинейность, в том, что два линейных слоя могут быть представлены одним линейным слоем, поскольку поскольку линейная комбинация двух линейностей линейна.

Простейшая многослойная архитектура с настраиваемыми параметрами может быть следующей: вход представлен вектором таким, как изображение или аудио. Этот вход умножается на матрицу весов, коэффициенты которой - настраиваемые параметры. Затем каждый компонент результирующего вектора подаётся на вход нелинейной функции, такой как ReLU. Повторяя этот процесс, получаем базовую нейронную сеть. Эта архитектура называется нейронной сетью, потому что она вычисляет взвешенную сумму входов по соответствующим строкам матрицы.

Возвращаясь к моменту обучения с учителем, мы сравниваем полученный результат с желаемым, потом оптимизируем целевую функцию, являющейся функцией потерь, вычисляя расстояние/штраф/отклонение между результатом и целью. После усредняем значение функции потерь по обучающей выборке. Это и есть значение, которое мы хотим минимизировать. Иными словами: мы хотим найти значение параметров, минимизирующее среднее ошибок.

Метод, которым можно найти значения, - вычисление градиентов. Например, если мы заблудились на гладкой горе туманной ночью и хотим добраться до деревни в долине. Одним из способов может быть посмотреть вокруг, в каком направлении самый крутой спуск, затем сделать небольшой шаг туда. Направление и есть (отрицательный) градиент. Предполагая выпуклость долины, мы можем достичь цели.

Более эффективный способ называется стохастическим градиентным спуском (SGD). Поскольку мы хотим минимизировать среднее ошибок по обучающей выборке, берём только один элемент или небольшую группу представителей выборки и вычисляем ошибку, затем применяя градиентный спуск. На следующем шаге мы берём новый элемент и получаем новое значение ошибки, получая градиент, который обычно в ином направлении. Две основных причины использовать SGD: он помогает модели сходиться быстро эмпиричиски, если обучающая выборка очень большая, это приводит к лучшему обобщению, что означает получение аналогичной производительности на различных множествах данных.


<!-- ### [Computing gradients by backpropagation](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s) -->

### [Вычисление градиентов методом обратного распространения ошибки](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!-- Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

The backpropagation equation for the weight gradients is as follows:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.

It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix. -->

Вычисление градиентов методом обратного распространения ошибки есть практическое применение правила дифференцирования сложной функции. Уравнения метода обратного распространения ошибки для градиентов входов следующие:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

Уравнения метода обратного распространения ошибки для градиентов весов следующие:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

Заметьте, что вместо скалярных используются векторные входы. В общем случае - многомерные входы. Метод обратного распространения ошибки позволяет вам вычислять производную различия между желаемым и полученным выходами (значения целевой функции) по любому из значений внутри сети. Наконец, метод обратного распространения ошибки весьма важен, поскольку применим к нескольким слоям.

Важно учитывать, как интерпретировать входы. Например, для изображения размерности $256{\times}256$ необходима матрица с 200,000 значений. Возможны огромные матрицы, с которыми слои нейронной сети вынуждены обращаться. Использовать такие матрицы было бы непрактично. Следовательно, важно выдвигать предположения о структуре матриц.


<!-- ## Hierarchical representation of the Visual Cortex -->

## Иерархическое представление зрительной коры головного мозга

<!-- Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does pattern recognition in a hierarchical manner.

Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (*e.g.* vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections. -->

Фукусима своими экспериментами предоставил нам понимание того, как наш мозг интерпретирует входные данные наших глаз. В итоге, было обнаружено, что нейроны перед сетчаткой глаза сжимают входной сигнал (известно, как контрастная нормализация), и сигнал проходит от глаз к головному мозгу. После этого, изображение обрабатывается поэтапно, на определённых категориях активируются определённые нейроны. Следовательно, зрительная кора распознаёт образы иерархически.

Эксперименты, в которых исследователи подключали электроды к определённым областям зрительной коры, в особенности к первичной зрительной коре (V1), дали понять исследователям, что определённые нейроны реагируют на визуальные мотивы, которые появляются в очень небольшой области зрительного поля, и показали схожесть соседних нейронов и соседних областей в зрительном поле. Вдобавок к тому, нейроны, реагирующие на одинаковые зрительные поля, организованно реагируют на различные типы граней (например, вертикальные или горизонтальные грани). Также важно заметить, что зрительный процесс по существу представляет собой процесс прямого прохода. Отсюда, каким-то образом распознавание может выполняться быстро без каких-либо рекуррентных связей.
