---
lang: pt
lang-ref: ch.08-2
lecturer: Yann LeCun
title: Variáveis Latentes Regularizadas em Modelos Baeados em Energia
authors: Henry Steinitz, Rutvi Malaviya, Aathira Manoj
date: 23 Mar 2020
translation-date: 28 March 2022
translator: Diogo Santiago
---


<!-- 
## [Regularized latent variable EBMs](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s) 
-->
## [Variáveis Latentes Regularizadas EBMs](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=2233s)

<!-- 
Models with latent variables are capable of making a distribution of predictions $\overline{y}$ conditioned on an observed input $x$ and an additional *latent variable* $z$. Energy-based models can also contain latent variables: 
-->
Modelos com variáveis latentes são capazes de fazer uma distribuição de predições $\overline{y}$ condicionada a uma entrada observada $x$ e uma *variável latente* adicional $z$. Modelos baseados em energia podem também conter variáveis latentes:

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>Fig. 1</b>: Example of an EBM with a latent variable
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig1.png" height="50%" width="50%"/><br>
<b>Fig. 1</b>: Exemplo de um EBM com uma variável latente
</center>

<!-- 
See the previous lecture's notes for more details. 
-->
Veja os tópicos anteriores para maiores detalhes.

<!-- 
Unfortunately, if the latent variable $z$ has too much expressive power in producing the final prediction $\overline{y}$, every true output $y$ will be perfectly reconstructed from input $x$ with an appropriately chosen $z$. This means that the energy function will be 0 everywhere, since the energy is optimized over both $y$ and $z$ during inference. 
-->
Infelizmente, se a variável latente $z$ tem muito poder de expressão na predição final $\overline{y}$, cada saída verdadeira $y$ irá ser perfeitamente reconstruída a partir da entrada $x$ com um $z$ apropriadamente escolhido. Isto significa que a função de energia será 0 em todos os demais locais, já que a energia é otimizada em $y$ e $z$ durante a inferência.

<!-- 
A natural solution is to limit the information capacity of the latent variable $z$. One way to do this is to regularize the latent variable: 
-->
Uma solução natural é limitar a capacidade de informação da variável latente $z$. Uma maneira de fazermos isto é regularizar a variável latente:

$$E(x,y,z) = C(y, \text{Dec}(\text{Pred}(x), z)) + \lambda R(z)$$

<!-- 
This method will limit the volume of space of $z$ which takes a small value and the value which will, in turn, controls the space of $y$ that has low energy. The value of $\lambda$ controls this tradeoff. A useful example of $R$ is the $L_1$ norm, which can be viewed as an almost everywhere differentiable approximation of effective dimension. Adding noise to $z$ while limiting its $L_2$ norm can also limit its information content (VAE). 
-->
Este método irá limitar o volume do espaço de $z$ que pega um pequeno valor e o valor, que irá em troca, controlar o espaço de $y$ que tem baixa energia. O valor de $\lambda$ controla este custo benefício. Um exemplo útil de $R$ é a norma $L_1$, que pode ser vista como sendo uma aproximação diferencial da dimensão efetiva. Adicionando ruído ao $z$ enquanto limitando sua norma $L_2$ pode também limitar a informação de seu conteúdo (VAE).


<!-- 
### Sparse Coding 
-->
### Codificação Esparsa

<!-- 
Sparse coding is an example of an unconditional regularized latent-variable EBM which essentially attempts to approximate the data with a piecewise linear function. 
-->
Codificação Esparsa é um exemplo de uma variável latente EBM regularizada não condicional a qual essencialmente tenta aproximar os dados com uma parte de uma função linear.

$$E(z, y) = \Vert y - Wz\Vert^2 + \lambda \Vert z\Vert_{L^1}$$

<!-- 
The $n$-dimensional vector $z$ will tend to have a maximum number of non-zero components $m << n$. Then each $Wz$ will be elements in the span of $m$ columns of $W$. 
-->
O vetor $n$-dimensional $z$ irá tender a ter um número máximo de componentes não-zeros $m << n$. Após, cada $Wz$ serão os elementos no intervalo de $m$ colunas de $W$.

<!-- 
After each optimization step, the matrix $W$ and latent variable $z$ are normalized by the sum of the $L_2$ norms of the columns of $W$. This ensures that $W$ and $z$ do not diverge to infinity and zero.
-->
Após cada passo de otimização, a matrix $W$ e a variável latente $z$ são normalizadas pela soma da norma $L_2$ das colunas de $W$. Isto garante que  $W$ e $z$ não diverge do infinito e zero.


### FISTA

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>Fig. 2</b>: FISTA computation graph
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig2.png" width="90%"/><br>
<b>Fig. 2</b>: Grafo computacional FISTA 
</center>


<!-- 
FISTA (fast ISTA) is an algorithm that optimizes the sparse coding energy function $E(y,z)$ with respect to $z$ by alternately optimizing the two terms $\Vert y - Wz\Vert^2$ and $\lambda \Vert z\Vert_{L^1}$. We initialize $Z(0)$ and iteratively update $Z$ according to the following rule: 
-->
FISTA (fast ISTA) é um algorítmo que otimiza a função de energia de codificação esparsa $E(y,z)$ com respeito a $z$ por alternar a otimização dos dois termos $\Vert y - Wz\Vert^2$ e $\lambda \Vert z\Vert_{L^1}$. Nós inicializamos $Z(0)$ e iterativamente atualizamos $Z$ de acordo com a seguinte regra:

$$z(t + 1) = \text{Shrinkage}_\frac{\lambda}{L}(z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - y))$$

<!-- 
The inner expression $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ is a gradient step for the $\Vert y - Wz\Vert^2$ term. The $\text{Shrinkage}$ function then shifts values towards 0, which optimizes the $\lambda \Vert z\Vert_{L_1}$ term. 
-->
A expressão interna $Z(t) - \frac{1}{L}W_d^\top(W_dZ(t) - Y)$ é um passo no gradiente para o termo $\Vert y - Wz\Vert^2$. A função $\text{Shrinkage}$ então desloca os valores em direção de 0, o qual otimiza o termo $\lambda \Vert z\Vert_{L_1}$.


### LISTA

<!-- 
FISTA is too expensive to apply to large sets of high-dimensional data (*e.g.* images). One way to make it more efficient is to instead train a network to predict the optimal latent variable $z$: 
-->
FISTA é muito pesado para se aplicar a grandes volumes de dados com alta dimensionalidade (imagens por exemplo). Uma forma de o tornar mais eficiente é treinar a rede para predizer o valor ótimo de $z$:

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>Fig. 3</b>: EBM with latent variable encoder
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig3.png" height="50%" width="50%"/><br>
<b>Fig. 3</b>: EBM com encoder de variável latente
</center>

<!-- 
The energy of this architecture then includes an additional term that measures the difference between the predicted latent variable $\overline z$ and the optimal latent variable $z$: 
-->
A energia desta arquitetura inclui um termo adicional que mede a diferença entre a variável latente predita $\overline z$ e a variável latente ótima $z$:

$$ C(y, \text{Dec}(z,h)) + D(z, \text{Enc}(y, h)) + \lambda R(z)$$

<!-- 
We can further define 
-->
Podemos ainda definir

$$W_e = \frac{1}{L}W_d$$

$$S = I - \frac{1}{L}W_d^\top W_d$$

<!-- 
and then write 
-->
e então escrever

$$z(t+1) = \text{Shrinkage}_{\frac{\lambda}{L}}[W_e^\top y - Sz(t)]$$

<!-- 
This update rule can be interpreted as a recurrent network, which suggests that we can instead learn the parameters $W_e$ that iteratively determine the latent variable $z$. The network is run for a fixed number of time steps $K$ and the gradients of $W_e$ are computed using standard backpropagation-through-time. The trained network then produces a good $z$ in fewer iterations than the FISTA algorithm. 
-->
Esta regra de atualização pode ser interpretada como uma rede neural recorrente, a qual sugere que ao invés de aprendermos os parâmetros $W_e$ que iterativamente determinam a variável latente $z$. A rede roda por um período fixo de passos $K$ e os gradientes de $W_e$ são computados usando retro-propagação através do tempo. A rede treinada então produz um bom $z$ em menos iterações que o algoritmo FISTA.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>Fig. 4</b>: LISTA as a recurrent net unfolded through time.
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig4.png" height="70%" width="80%"/><br>
<b>Fig. 4</b>: LISTA como uma rede neural recorrente desdobrada na linha do tempo.
</center>


<!-- 
### Sparse coding examples 
-->
### Exemplos de codificação esparsa

<!-- 
When a sparse coding system with 256 dimensional latent vector is applied to MNIST handwritten digits, the system learns a set of 256 strokes that can be linearly combined to nearly reproduce the entire training set. The sparse regularizer ensures that they can be reproduced from a small number of strokes. 
-->

Quando um sistema de codificação esparsa com vetores latentes de 256 dimensões são aplicados aos dígitos manuscritos do MNIST, o sistema aprende um conjunto de 256 sequências que podem ser linearmente combinadas para praticamente reproduzir todo o conjunto de dados de treinamento. O regularizador esparso garante que poassam ser reproduzidos com um pequeno número de valores.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>Fig. 5</b>: Sparse coding on MNIST. Each image is a learned column of $W$. 
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig5.png" height="70%" width="90%"/><br>
<b>Fig. 5</b>: Codificação esparsa no MNIST. Cada imagem é uma coluna $W$ aprendida.
</center>

<!-- 
When a sparse coding system is trained on natural image patches, the learned features are Gabor filters, which are oriented edges. These features resemble features learned in early parts of animal visual systems. 
-->
Quando um sistema de codificação esparsa é treinado em divisões de imagens, as características aprendidas são filtros de Gabor, que são bordas orientadas. Estas características remetem características aprendidas nas fases iniciais do sistema de visualização animal.


<!-- 
### [Convolutional sparse coding](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s) 
-->
### [Codificação esparsa convolucional](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4066s)

<!-- 
Suppose, we have an image and the feature maps ($z_1, z_2, \cdots, z_n$) of the image. Then we can convolve ($*$) each of the feature maps with the kernel $K_i$. Then the reconstruction can be simply calculated as: 
-->
Suponha, temos uma imagem e o mapa de características ($z_1, z_2, \cdots, z_n$) da imagem. Em seguida, podemos convolucionar ($*$) cada mapa de características com o kernel $K_i$. Após a reconstrução pode ser simplemente calculada como sendo:

$$Y=\sum_{i}K_i*Z_i$$

<!-- 
This is different from the original sparse coding where the reconstruction was done as $Y=\sum_{i}W_iZ_i$. In regular sparse coding, we have a weighted sum of columns where the weights are coefficients of $Z_i$. In convolutional sparse coding, it is still a linear operation but the dictionary matrix is now a bunch of feature maps and we convolve each feature map with each kernel and sum up the results. 
-->
Isto é diferente da codificação esparsa original onde a reconstrução era feita sendo $Y=\sum_{i}W_iZ_i$. Na codificação esparsa comum, nós temos uma soma ponderada das colunas onde os pesos são coeficientes de $Z_i$. Na codificação esparsa convolucional, ainda temos uma operação linear porém a matrix dicionário agora é um aglomerado de mapas de características e nós convolucionamos cada mapa com cada kernel somando os resultados.


<!-- 
#### Convolutional sparse auto-encoder on natural images 
-->
#### Auto-encoder convolutional esparso em imagens

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>Fig.6</b> Filters and Basis Functions obtained. Linear convolutional decoder
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig6.png" height="90%" width="90%"/><br>
<b>Fig.6</b> Filtros e Funções Bases obtidas. Decodificador convolucional Linear
</center>

<!-- 
The filters in the encoder and decoder look very similar. Encoder is simply a convolution followed by some non-linearity and then a diagonal layer to change the scale. Then there is sparsity on the constraint of the code. The decoder is just a convolutional linear decoder and the reconstruction here is the square error. 
-->
Os filtros em um encoder e decoder são muito semelhantes. O encoder é simplesmente uma convolução seguida por alguma não-linearidade e então uma camada diagonal para mudar a escala. Após, há a esparsidade na restrição do código. O decodificador é apenas um decodificador de convolução linear e a reconstrução aqui é o erro quadrático.

<!-- 
So, if we impose that there is only one filter then it is just a centre surround type filter. With two filters, we can get some weird shaped filters. With four filters, we get oriented edges (horizontal and vertical); we get 2 polarities for each of the filters. With eight filters we can get oriented edges at 8 different orientations. With 16, we get more orientation along with the centres around. As we go on increasing the filters, we get more diverse filters that is in addition to edge detectors, we also get grating detectors of various orientations, centres around, etc. 
-->
Caso, nós impusermos que há apenas um filtro então este é apenas um tipo de filtro que circunda o centro. Com dois filtros, nós podemos obter filtros de formatos inesperados. Com quatro filtros, nós conseguimos bordas orientadas (horizontal e vertical); nós obtemos 2 polaridades para cada um dos filtros. Com oito filtros nós obtemos bordas orientadas em 8 orientações diferentes. Com 16, nós obtemos ainda mais orientações além dos pontos centrais próximos. Conforme formos incrementando os filtros, obtemos filtros cada vez mais diversos que ainda por cima são detectores de bordas, ainda obtemos detectores em grade para diversas orientações, pontos centrais próximos, etc.

<!-- 
This phenomenon seems to be interesting since it is similar to what we observe in the visual cortex. So this is an indication that we can learn really good features in a completely unsupervised way. 
-->
Este fenômeno é interessante desde que seja similar com o que observamos no nosso cortex visual. Portanto esta é uma indicação que realmente aprendemos boas características de uma maneira completamente não-supervisionada.

<!-- 
As a side use, if we take these features and plug them in a convolutional net and then train them on some task, then we don't necessarily get better results than training an image net from scratch. However, there are some instances where it can help to boost performance. For instance, in cases where the number of samples are not large enough or there are few categories, by training in a purely supervised manner, we get degenerate features. 
-->
Como uso a parte, se pegarmos estas características e plugá-las numa rede convolucional e treiná-las em alguma tarefa, então não necessariamente obteremos melhores resultados que treinar um image net do zero. Entretanto, há algumas formas onde pode-se obter um aumento de performance. Em casos, onde o número de amostras não é suficientemente grande ou há poucas categorias, treinando apenas de maneira supervisiondada, nós podemos obter características degeneradas.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>Fig. 7 </b> Convolutional sparse encoding on colour image
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig7.png" height="90%" width="90%"/><br>
<b>Fig. 7 </b> Codificador esparso convolucional em imagens coloridas
</center>

<!-- 
The figure above is another example on colour images. The decoding kernel (on the right side) is of size 9 by 9. This kernel is applied convolutionally over the entire image. The image on the left is of the sparse codes from the encoder. The $Z$ vector is very sparse space where there are just few components that are white or black (non-grey). 
-->
A figura acima é outro exemplo em imagens coloridas. O kernel decodificador (do lado direito) é de tamanho 9 por 9. Este kernel é aplicado convolucionalmente por toda a imagem. A imagem à esquerda percence a codificação esparsa do encoder. O vetor $Z$ é um espaço bem esparso onde há poucos componentes que são branco ou preto (não-cinza).


<!-- 
### [Variational autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s) 
-->
### [Autoencoder variacional](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=4371s)

<!-- Variational Autoencoders have an architecture similar to Regularized Latent Variable EBM, with the exception of sparsity. Instead, the information content of the code is limited by making it noisy. -->
Autoencoders Variacionais tem uma arquitetura semelhante às das Variávels Latentes Regularizadas EBM, com exceção da esparsidade. Ao invés, a informação do conteúdo do código é limitada o tornando ruídoso.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>Fig. 8</b>: Architecture of Variational Autoencoder
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig8.png" height="50%" width="50%"/><br>
<b>Fig. 8</b>: Arquitetura de um Autoencoder Variacional
</center>

<!-- 
The latent variable $z$ is not computed by minimizing the energy function with respect to $z$. Instead, the energy function is viewed as sampling $z$ randomly according to a distribution whose logarithm is the cost that links it to ${\overline z}$. The distribution is a Gaussian with mean ${\overline z}$ and this results in Gaussian noise being added to ${\overline z}$. 
-->
A variável latente $z$ não é computada minimizando a função de energia com respeito a $z$. Ao invés disto, a função de energia é vista como amostras aleatórias de $z$ de acordo com uma ditribuição do qual o logaritmo é o custo que conecta-o ao ${\overline z}$. A distribuição é uma Gaussiana com média ${\overline z}$ e isto resulta em ruído Gaussiano sendo adicionado ao ${\overline z}$.

<!-- 
The code vectors with added Gaussian noise can be visualized as fuzzy balls as shown in Fig. 9(a). 
-->
Os vetores de código com o ruído Gaussiano adicionado podem ser visualizados como as bolinhas na Fig. 9(a).

<!-- 
| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) Original set of fuzzy balls </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b) Movement of fuzzy balls due to energy minimization without regularization</center>  |
-->

| <center><img src="{{site.baseurl}}/images/week08/08-2/fig9.png" height="75%" width="75%"/><br>(a) Bolinhas originais. </center> | <center><img src="{{site.baseurl}}/images/week08/08-2/fig10.png" height="75%" width="75%"/><br>(b) Movimento das bolinhas em função da minimização de sua energia sem regularizar</center>  |

<!-- 
<center><b>Fig. 9:</b> Effect of energy minimization on fuzzy balls</center> 
-->
<center><b>Fig. 9:</b> Efeito da minimização da energia das bolinhas</center>

<!-- 
The system tries to make the code vectors ${\overline z}$ as large as possible so that the effect of $z$(noise) is as small as possible. This results in the fuzzy balls floating away from the origin as shown in Fig. 9(b). Another reason why the system tries to make the code vectors large is to prevent overlapping fuzzy balls, which causes the decoder to confuse between different samples during reconstruction. 
-->
O sistema tenta criar vetores de código ${\overline z}$ tão grandes quanto for possível para que o efeito de $z$(ruído) seja o mínimo possível. Isto resulta em bolinhas flutuando para longe da origem como visto na Fig. 9(b). Outro motivo pelo qual o sistema tenta criar vetores de códigos grande é para prevenir a sobreposição das bolinhas, as quais fazem o decodificador confundir entre diferentes amostras durante a reconstrução.

<!-- 
But we want the fuzzy balls to cluster around a data manifold, if there is one. So, the code vectors are regularized to have a mean and variance close to zero. To do this, we link them to the origin by a spring as shown in Fig. 10.
-->
Mas queremos que as bolinhas se agrupem ao redor de um conjunto de dados, caso haja um. Então, os vetores de código são regularizados tendo média e variância perto de zero. Para isto, nós os conectamos a origem por uma mola como visto na Fig. 10.

<!-- 
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>Fig. 10</b>: Effects of regularization visualized with springs
</center> 
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-2/fig11.png" height="50%" width="50%"/><br>
<b>Fig. 10</b>: Efeitos da regularização visualizado através de molas
</center>

<!-- 
The strength of the spring determines how close the fuzzy balls are to the origin. If the spring is too weak, then the fuzzy balls would fly away from the origin. And if it's too strong, then they would collapse at the origin, resulting in a high energy value. To prevent this, the system lets the spheres overlap only if the corresponding samples are similar. 
-->
A força de uma mola determina o quão próxima as bolinhas se encontram da origem. Se a mola for muito fraca, então as bolinhas iriam voar para além da origem. E caso seja muito resistente, então irão todas se aglutinar na origem, resultando em um valor alto de energia. Para previnir isto, o sistema deixa as esferas sobrepor apenas caso as amostras sejam similares.

<!-- 
It is also possible to adapt the size of the fuzzy balls. This is limited by a penalty function (KL Divergence) that tries to make the variance close to 1 so that the size of the ball is neither too big nor too small that it collapses. 
-->
É possível adaptar o tamanho da bolinha. Isto é limitado pela penalidade da função (Divergência KL) que tenta fazer a variância próxima de 1 para que o tamanho da bolinha não seja nem tão pequeno nem tão grande que pode colapsar.
