---
lang: pt
lang-ref: ch.08-1
lecturer: Yann LeCun
title: Métodos Contrastantes em Modelos Baseados em Energia
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 23 Mar 2020
translation-date: 28 March 2022
translator: Diogo Santiago
---


<!-- 
## [Recap](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s) 
-->
## [Recapitulando](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

<!--
Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods.
-->
Dr. LeCun passou ~15 minutos revisando modelos baseados em energia. Checar a última semana (notas da semana 7) para esta informação, especialmente o conceito de métodos de Aprendizado Contrastante.

<!--
As we have learned from the last lecture, there are two main classes of learning methods:
1. Contrastive Methods that push down the energy of training data points, $F(x_i, y_i)$, while pushing up energy on everywhere else, $F(x_i, y’)$.
2. Architectural Methods that build energy function $F$ which has minimized/limited low energy regions by applying regularization.
-->
Como aprendemos na última lição, há duas classes principais de métodos de aprendizado:
1. Métodos Contrastantes diminuem a energia dos dados de treinamento, $F(x_i, y_i)$, enquanto aumentam a energia de todos os demais, $F(x_i, y’)$.
2. Métodos Arquiteturais que geram a função de energia $F$ a qual minimiza/limita as regiões de baixa energia aplicando regularização.

<!--
To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method, which push down the energy of data points and push up everywhere else.
-->
Para distinguir as características de diferentes métodos de treinamento, Dr. Yann LeCun foi além, sumarizando 7 estratégias de treinamento de 2 classes mencionadas anteriormente. Um destes métodos é um método similar ao Maximum Likelihood (Máxima Verossimilhança), a qual diminui a energia dos pontos de dados e aumenta em todo o resto.

<!--
Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of $y’\neq y_i$. Maximum Likelihood doesn't “care” about the absolute values of energies but only “cares” about the difference between energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values.
-->
O método Maximum Likelihood probabilísticamente diminui a energia nos dados de treinamento e aumenta em todo o resto para cada outro valor de $y’\neq y_i$. Maximum Likelihood não "se importa" com os valores absolutos das energias mas só se "importa" com a diferença entre energias. Porque a distribuição probabilística é sempre normalizada ao somatório/integral sendo 1, comparando a razão entre quaisquer 2 pontos de dados é mais útil que simplesmente comparar os valores absolutos.


<!-- 
## [Contrastive methods in self-supervised learning](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s) 
-->
## [Métodos Contrastantes em Aprendizado Auto-Supervisionado](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

<!--
In contrastive methods, we push down on the energy of observed training data points ($x_i$, $y_i$), while pushing up on the energy of points outside of the training data manifold.
-->
Em métodos contrastantes, nós diminuímos a energia dos dados de treino observados ($x_i$, $y_i$), enquanto aumentamos a energia dos dados que se encontram fora do treinamento.

<!--
In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks.
-->
No aprendizado auto-supervisionado, nós usamos uma parte dos dados de entrada para predizer as demais partes. Nós esperamos que nosso modelo possa produzir boas características para a visão computacional que rivaliza com tarefas supervisionadas.

<!--
Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below.
-->
Pesquisadores encontraram de forma empírica que aplicando métodos de _embedding_ contrastante para modelos auto-supervisionados pode-se realmente obter uma boa performance que rivaliza modelos supervisionados. Iremos explorar alguns destes métodos e seus resultados abaixo:

<!-- 
### Contrastive embedding 
-->
### Embedding Contrastante

<!--
Consider a pair ($x$, $y$), such that $x$ is an image and $y$ is a transformation of $x$ that preserves its content (rotation, magnification, cropping, *etc.*). We call this a **positive** pair.
-->
Considere o par ($x$, $y$), tal que $x$ é uma imagem e $y$ é uma transformação de $x$ que preserva seu conteúdo (rotação, ampliação, corte, *etc.*). Nós chamamos isto de par **positivo**.

<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Positive Pair
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Par Positivo
</center>

<!--
Conceptually, contrastive embedding methods take a convolutional network, and feed $x$ and $y$ through this network to obtain two feature vectors: $h$ and $h'$. Because $x$ and $y$ have the same content (*i.e.* a positive pair), we want their feature vectors to be as similar as possible. As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between $h$ and $h'$. By doing this, we lower the energy for images on the training data manifold.
-->
Conceitualmente, métodos de embedding contrastantes usam uma rede convolucional, alimentam $x$ e $y$ por esta rede para obter 2 vetores de características: $h$ e $h'$. Porque $x$ e $y$ possuem o mesmo conteúdo (um par positivo), queremos que os vetores de características sejam o mais similar possível. Como resultado, escolhemos uma métrica de similaridade (tal como a similaridade pelo cosseno) e uma função custo que maximiza a similaridade entre $h$ e $h'$. Fazendo isto, diminuímos a energia para imagens no conjunto de treinamento.

<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Negative Pair
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Par Negativo
</center>

<!--
However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$, $y_{\text{neg}}$), images with different content (different class labels, for example). We feed these to our network above, obtain feature vectors $h$ and $h'$, and now try to minimize the similarity between them.
-->
Entretanto, também precisamos aumentar a energia dos dados fora deste grupo. Então nós geramos amostras **negativas** ($x_{\text{neg}}$, $y_{\text{neg}}$), imagens com conteúdos diferentes (rótulos de classe diferentes, por exemplo). Alimentamos a rede acima, obtendo os vetores de características $h$ e $h'$, e agora tentamos minimizar a similaridade entre eles.

<!--
This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs.
-->
Este método nos permite diminuir a energia dos pares similares enquanto aumentamos a energia dos pares dissimilares.

<!--
Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods.
-->
Resultados recentes (no ImageNet) mostraram que este método pode produzir características que são boas para reconhecimento de objetos que rivalizam as características aprendidas por métodos supervisionados.


<!-- 
### Self-Supervised Results (MoCo, PIRL, SimCLR) 
-->
### Resultados Auto-Supervisionados (MoCo, PIRL, SimCLR)

<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL and MoCo on ImageNet
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL e MoCo no ImageNet
</center>

<!--
As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRL is starting to approach the top-1 linear accuracy of supervised baselines (~75%).
-->
Como visto na figura acima, MoCo e PIRL alcançam resultados SOTA (State of the Art - Estado da Arte), especialmente para modelos de baixa-capacidade, com um pequeno número de parâmetros. PIRL está alcançando o top-1 de acurácia linear de baselines (modelos de base) supervisionados(~75%).

<!--
We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows.
-->
Nós podemos melhor entender o PIRL olhando sua função objetivo: NCE (Noise Contrastive Estimator - Estimador de Ruído Contrastante) como segue:

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

<!--
Here we define the similarity metric between two feature maps/vectors as the cosine similarity.
-->
Aqui nós definimos a métrica de similaridade entre 2 mapas/vetores de características como a similaridade pelo cosseno.

<!--
What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_ $f$ and $g$, which can be thought of as independent layers on top of the base convolutional feature extractor.
-->
O que o PIRL faz diferente é que ele não usa as saídas do extrator de características convolucional diretamente. Ao invés, ele define diferentes _cabeçalhos_ $f$ e $g$, os quais podem ser pensados como camadas independentes no topo da base do extrator de características convolucional.

<!--
Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs.
-->
Juntando as partes, a função objetivo NCE do PIRL funciona como segue. Em um mini-batch, nós teremos um par positivo (similar) e vários pares negativos (dissimilares). Nós então computamos a similaridade entre o vetor de característica da imagem ($I^t$) e o resto dos vetores de característica no mini-batch (um positivo, todo resto negativo). Após computamos o resultado de uma função estilo softmax no par positivo. Maximizar o resultado de um softmax significa minimizar o resto dos resultados, os quais são exatamente o que queremos para um modelo baseado em energia. A função custo final, entretanto, nos permite construir um modelo que diminui a energia em pares similares enquanto aumenta a energia em pares dissimilares.

<!--
Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank.
-->
Dr. LeCun menciona que para fazer funcionar, é necessário um número alto de amostras negativas. No SGD (Gradiente Descendente Estocástico), pode ser difícil manter de forma consistente um grande números destes exemplos negativos nos mini-batches. Então, o PIRL se utiliza de uma memória cacheada para tal.

<!--
**Question**: Why do we use cosine similarity instead of L2 Norm?
Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to centre) or make two vectors dissimilar by making them very "long" (away from the centre). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long.
-->
**Pergunta**: Por que utilizamos a similaridade pelo cossenos ao invés da norma L2?
Resposta: Com a norma L2, é muito simples fazer dois vetores similares os tornando "curtos" (próximo do centro) ou fazendo dois vetores dissimilares os tornando bem "longos" (afastados do centro). Isto porque a norma L2 é apenas a somatória das raízes das diferenças parciais entre os vetores. Portanto, usando a similaridade pelo cosseno forçamos o sistema a encontrar uma boa solução sem "trapacear" fazendo os vetores curtos ou longos.

<!--
### SimCLR
-->
### SimCLR

<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: SimCLR Results on ImageNet
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: SimCLR Resultados no ImageNet
</center>

<!--
SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet. The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs. Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold.
-->
SimCLR demonstra melhores resultados que os métodos anteriores. De fato, ele alcança a performance de métodos supervisionados no ImageNet, com top-1 de acurácia linear accuracy no ImageNet. A técnica se utiliza de um sofisticado métodos de augumentação de dados para gerar pares similares, e eles treinam por um longo período de tempo (com tamanhos de batches grandes, muito grandes) em TPUs. Dr. LeCun acredita que SimCLR, até certo ponto, mostra os limites dos métodos contrastantes. Há muitas, muitas regiões em um espaço de alta dimensionalidade onde você aumenta a energia para garantir que elas estejam no mínimo maior que no conjunto de dados. Conforme aumentamos a dimensão de representação, precisamos de mais e mais exemplos negativos para garantir que a energia é maior nos locais que não estão no conjunto.

<!--
## [Denoising autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)
-->
## [Autoencoder para Remoção de Ruídos](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

<!--
In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input. More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold.
-->
Na [prática da semana 7](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), discutímos o autoencoder para remoção de ruídos. O modelo tende a aprender a representação dos dados reconstruindo as entradas de dados corrompidas dos dados originais. Mais especificamente, treinamos o sistema para produzir uma função de energia que cresce quadraticamente conforme os dados corrompidos se afastam do conjunto de dados.

<!--
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: Architecture of denoising autoencoder
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: Arquitetura do autoencoder de remoção de ruídos
</center>


<!--
### Issues
-->
### Problemas

<!--
However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations. Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features. Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance.
-->
Entretanto, há diversos problemas com autoencoders de remoção de ruído. Um problema é tal que em um espaço contínuo de alta dimensionalidade, há incontáveis maneiras de corromper parte dos dados. Portanto, não há garantia de que nós podemos modelar a função de energia simplesmente a aumentando em diversos locais diferentes. Outro problema com o modelo é que ele performa mal se tratando de imagens pela falta de variáveis latentes. Desde que haja diversas maneiras de se reconstruir as imagens, o sistema produz várias predições e não aprende nenhuma boa característica em particular. Além disto, dados corrompidos no meio do conjunto podem ser reconstruídos para ambos os lados. Isto irá criar locais achatados na função de energia que afetam a performance em geral.


<!-- 
## Other Contrastive Methods 
-->
## Outros Métodos Constrastantes

<!-- 
There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence. 
-->
Há outros métodos contrastantes como: divergência contrastante, Similaridade Racional, Estimativa do Ruído Contrastante e Fluxo da Mínima Probabilidade. Iremos discutir, de forma suscinta a idéia básica da divergência contrastante.


<!-- 
### Contrastive Divergence 
-->
### Divergência Contrastante

<!-- 
Contrastive divergence (CD) is another model that learns the representation by smartly corrupting the input sample. In a continuous space, we first pick a training sample $y$ and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. Keep doing so will eventually lower the energy of $y$. We can then update the parameter of our energy function by comparing $y$ and the contrasted sample $\bar y$ with some loss function. 
-->
Divergência Contrastante (Contrastive Divergence - CD) é outro modelo que aprende uma representação corrompendo de forma inteligente, os dados de entrada. Em um espaço contínuo, nós pegamos a primeira amostra $y$ e diminuímos sua energia. Por exemplo, nós usamos alguma forma de processo baseado em gradiente para diminuir a energia na superfície com ruído. Se o espaço de entrada é discreto, nós podemos ao invés, perturbar os dados de treinamento aleatoriamente para modificar a energia. Se a energia que obtemos for menor, nós a mantemos. Caso contrário, a descartamos com alguma probabilidade. Continuamos esta iteração até eventualemnte baixar a energia de $y$. Podemos então atualizar o parâmentro da nossa função de energia comparando $y$ e a amostra contrastante $\bar y$ com alguma função custo.


<!-- 
### Persistent Contrastive Divergence 
-->
### Divergência Contrastante Persistente

<!-- 
One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD. Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases. 
-->
Um dos refinamentos da divergência constrastante é a divergência constrastante persistente. O sistema usa um conjunto de "partículas" e recorda suas posições. Estas partículas são diminuídas da superfície de energia da mesma forma que fizemos com o CD normal. Eventualmente, elas encontrarão locais de baixa energia em nossa superfície de energia e irá forçá-las a aumentar. Entretanto, o sistema não escala bem conforme a dimensionalidade for aumentando.
