---
lang-ref: ch.07-3
lang: pt
title: Introdução aos Autoencoders
lecturer: Alfredo Canziani
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
translation-date: 5 March 2021
translator: Catarina Carvalho
---

<!--
## [Application of autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)
-->
## [Aplicação de autoencoders](https://www.youtube.com/watch?v=bggwq14dd9m&t=55S)

<!--
### Image generation
-->
### Geração de Imagem

<!--Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image.
-->
Você pode dizer qual cara é falsa na Fig. 1? De fato, ambos são produzidos pelo gerador do Stylegan2. Embora os detalhes faciais sejam muito realistas, o fundo parece estranho (à esquerda: desfocagem, direita: objetos de desformatados). Isso ocorre porque a rede neural é treinada em amostras de rostos. O fundo tem então uma variabilidade muito maior. Aqui, o conjunto de dados tem cerca de 50 dimensões, igual aos graus de liberdade de uma imagem de rosto.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces generated from StyleGan2
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces geradas a partir do Stylegan2
</center>


<!--
### Difference of Interpolation in Pixel Space and Latent Space
-->
### Diferença de interpolação no espaço dos pixels e no espaço latente

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: A dog and a bird
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: Um cão e um pássaro
</center>


<!--If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases.
-->
Se nós interpolaramos linearmente entre a imagem fo cão e a imagem do pássaro (Fig. 2) no espaço dos pixels, teremos uma sobreposição desbotada das duas imagens na Fig.3. Do canto superior esquerdo para o canto inferior direito, o peso da imagem do cão diminui e o peso da imagem do passaro aumenta.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Results after interpolation
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Resultados após a interpolação
</center>

<!--If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4.
-->
Se interpolarmos em duas representação no espaço latente e alimentá-las para o decodificador (decoder), obteremos a transformação do cão para o pássaro na Fig.4.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Results after feeding into decoder
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Resultados após a alimentação do decodificador
</center>

<!--Obviously, latent space is better at capturing the structure of an image.
-->
Obviamente, o espaço latente é melhor a capturar a estrutura de uma imagem.

<!--
### Transformation Examples
-->
### Exemplos de transformação.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center>


<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Shift
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Deslocação
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brightness
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brilho
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotation (Note that the rotation could be 3D)
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotação (Nota que a rotação pode acontecer em 3D)
</center>

<!--
### Image Super-resolution
-->

### Imagem super-resolução

<!--This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez)
-->
Este modelo visa aumentar a resolução das imagens e reconstruir os rostos originais. Da esquerda para a direita na Fig.9, a primeira coluna é a imagem de entrada de 16x16, a segunda é o que você receberia de uma interpolação bicúbica padrão, a terceira é a saída gerada pela rede neural e à direita é a imagem real/referência. (https://github.com/david-gpu/srez)

<!--<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstructing original faces
</center>
-->
<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstruindo faces originais
</center>


<!--From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data.
-->
Segundo as imagens de saída, é claro que existem vieses nos dados de treinamento, o que torna as faces reconstruídas imprecisas. Por exemplo, o homem asiático no canto esquero parece europeu à saída da rede devido a imagens de treinamento desequilibradas. O rosto reconstruído da mulher do canto inferior esquerdo parece estranho devido à falta de imagens desse ângulo nos dados de treinamento.

<!--
### Image Inpainting
-->

### Image Inpainting

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Putting grey patch on faces
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Colocando remendo(patch) cinza em faces
</center>


<!--Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization.
-->
Colocar um remendo(patch) cinza no rosto como na Fig. 10 coloca a imagem longe do conjunto de treinamento. A reconstrução da face na Fig. 11 é feita encontrando a imagem de amostra mais próxima no conjunto de treinamento através da minimização da função de energia.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Reconstructed image of <b>Fig. 10</b>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Imagem reconstruída de <b>Fig. 10</b>
</center>


<!--
### Caption to Image
-->
### Legenda para imagem

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Caption to Image example
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Legenda para o exemplo de imagem
</center>

<!--The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images.
-->
A tradução da descrição de texto para imagem na Fig. 12 é obtida extraindo representações de recursos de texto associadas a importantes informações visuais e depois decodificando-as para imagens.

<!--
## [What are autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)
-->
## [O que são autoencoders?](Https://www.youtube.com/watch?v=bggwq14dd9m&t=879S)

<!--Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input.
-->
Os autoencoders são redes neurais artificiais, treinadas de maneira não supervisionada, que visam primeiro aprender representações codificadas de nossos dados e, em seguida, gerar os dados de entrada (o mais próximo possível) a partir das representações codificadas aprendidas. Assim, a saída de um autoencoder é sua previsão para a os dados de entrada.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Architecture of a basic autoencoder<br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Arquitetura de um autoencoder básico<br>
</center>

<!--Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder (affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network.
-->
A Fig. 13 mostra a arquitetura de um autoencoder básico. Como antes, começamos a partir da parte inferior com a entrada $\boldsymbol{x}$ que é submetida a um codificador (transformação afim definida por $\boldsymbol{W_h}$, seguida por achatamento). Isso resulta numa camada oculta intermedia $\boldsymbol{h}$. Isso é submetido ao decodificador (outra transformação de afim definida por $\boldsymbol{W_x}$ seguida de outro achatamento). Isso produz a saída $\boldsymbol{\hat{x}}$, que é a previsão/reconstrução do nosso modelo para os dados de entrada. De acordo com a nossa convenção, dizemos que esta é uma rede neural de 3 camadas.

<!--We can represent the above network mathematically by using the following equations:
-->
Podemos representar a rede acima matematicamente usando as seguintes equações:

<!--$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$
-->

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

<!--We also specify the following dimensionalities:
-->
Também especificamos as seguintes dimensões:

<!--$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$
-->

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<!--<b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$
-->
<b> Nota: </b> Para representar o PCA, podemos ter pesos apertados (ou pesos amarrados) definidos por $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$

<!--
## Why are we using autoencoders?
-->
## Por que estamos usando autoencoders?

<!--At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders.
-->
Neste ponto, você pode se perguntar qual é o ponto de prever a entrada e quais são as aplicações dos autoencoders.

<!--The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold *i.e.* given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations.
-->
As aplicações primárias de um autoencoder são para detecção de anomalia ou remoção de ruído de imagens. Sabemos que o propósito de um autoencoder é o de reconstruir dados que vive no conjunto de dados *p.e.*, dado um conjunto de dados, queremos que o nosso autoencoder seja capaz de reconstruir apenas os dados de entrada que existem nesse conjunto. Assim, restringimos o modelo para reconstruir coisas que foram observadas durante o treinamento e, portanto, qualquer variação presente em novos dados de entrada serão removidos porque o modelo seria insensível a esses tipos de perturbações.

<!--Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space.
-->
Outra aplicação de um autoencoder é como compressor de imagens. Se tivermos uma dimensionalidade intermediária $d$ inferior à dimensionalidade de entrada $n$, então o codificador pode ser usado como um compressor e as representações ocultas (representações codificadas) abordariam todas (ou mais) as informações especificas do dado de entrada, mas ocuparia menos espaço.

<!--
## Reconstruction loss
-->
## Função de custo para reconstrução

<!--Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e.
-->
Vamos agora olhar para as funções de custo para reconstrução que geralmente usamos. O custo geral para o conjunto de dados é dada como a média por perda de amostra p.ex.

<!--$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$
-->

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

<!--When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by
-->
Quando a entrada é categórica, poderíamos usar a Função de Custo de Entropia Cruzada (Cross-Entropy loss) para calcular o custo por amostra que é dada por

<!--$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$
-->

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

<!--And when the input is real-valued, we may want to use the Mean Squared Error Loss given by
-->
E quando a entrada é um valor-real, podemos querer usar a função de custo do erro quadrático médio (Mean Squared Error Loss) dada por

<!--$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$
-->

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$

<!--
## Under-/over-complete hidden layer
-->
## Camada oculta sub-/super- completa

<!--When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right.
-->
Quando a dimensionalidade da camada oculta $d$ é menor que a dimensionalidade da entrada $n$, dizemos que está sob uma camada oculta sub-completa. E da mesma forma, quando $d> n$, dizemos que é uma camada oculta super-completa. A Fig. 14 mostra uma camada oculta sub-completa à esquerda e uma camada oculta super-completa à direita.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: An under-complete *vs.* an over-complete hidden layer<br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: Uma camada oculta sub-completa *vs.* uma camada oculta sobre-completa<br>
</center>


<!--As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier.
-->
Como discutido acima, uma camada oculta sub-completa pode ser usada para compactação, pois estamos codificando as informações da entrada em menos dimensões. Por outro lado, em uma camada sobre-completa, usamos uma codificação com dimensionalidade mais alta do que a entrada. Isso facilita a otimização.

<!--Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction (limited to a subset of the input space) and makes the model insensitive to everything not in the manifold.
-->
Como estamos tentando reconstruir a entrada, o modelo é propenso a copiar todos os recursos de entrada para a camada oculta e passa-los como sendo a saída, portanto, comportando-se essencialmente como uma função de identidade. Isso precisa ser evitado, pois isso implicaria que nosso modelo não aprende nada. Portanto, precisamos aplicar algumas restrições adicionais aplicando um gargalo de informação. Fazemos isso restringindo as possíveis configurações que a camada oculta pode ter para apenas aquelas configurações observadas durante o treinamento. Isso permite uma reconstrução seletiva (limitada a um subconjunto do espaço de dados de entrada) e torna o modelo insensível a tudo o que não esteja nesse conjunto.

<!--It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc.
-->
Devem observar que uma camada sub-completa não pode se comportar como uma função de identidade simplesmente porque a camada oculta não tem dimensões suficientes para copiar a entrada. Assim, uma camada oculta sub-completa é menos provável de sobreajustar (overfit) em comparação com uma camada oculta super-completa, podendo na mesma fazer sobreajuste (overfit). Por exemplo, dado um poderoso codificador (encoder) e um decodificador (decoder), o modelo poderia simplesmente associar um número a cada ponto de dados e aprender esse mapeamento. Existem vários métodos para evitar o sobreajuste (overfitting), como métodos de regularização, métodos arquitetônicos, etc.

<!--
## Denoising autoencoder
-->
## Autoencoder de denoising

<!--Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works.
-->
A Fig.15 mostra um autoencoder de denoising e a intuição de como funciona.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Denoising autoencoder<br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Autoencoder de denoising<br>
</center>

<!--In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it.
By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot.
-->
Neste modelo, assumimos que estamos fornecendo a mesma distribuição de ruído que vamos observar na realidade, para que possamos aprender a recuperar robustamente dessa interferência.
Ao comparar a entrada e saída, podemos dizer que os pontos que já existem no conjunto de dados não se moveram, e os pontos que longe do conjunto de dados se moveram muito.

<!--Fig.16 gives the relationship between the input data and output data.
-->
A Fig.16 fornece a relação entre os dados de entrada e dados de saída.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Input and output of denoising autoencoder<br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Entrada e saída do autoencoder de denoising <br>
</center>


<!--We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram.
-->
Também podemos usar cores diferentes para representar a distância que cada do ponto de entrada se desloca, a Fig.17 mostra o diagrama.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Measuring the traveling distance of the input data<br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Medindo a distância de viagem dos dados de entrada<br>
</center>

<!--The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process.
-->
Quanto mais leve a cor, maior a distância percorrida. Do diagrama, podemos dizer que os pontos nos cantos viajavram perto de 1 unidade, enquanto os pontos dentro dos 2 ramos não se moveram, uma vez que são atraídos pelos ramos superiores e inferiores durante o processo de treinamento.

<!--
## Contractive autoencoder
-->
## Autoencoder Contrativo

<!--Fig.18 shows the loss function of the contractive autoencoder and the manifold.
-->
A Fig.18 mostra a função de custo do autoencoder contrativo e do conjunto de dados.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Contractive autoencoder <br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Autoencoder contrativo <br>
</center>


<!--The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions.
-->
A função de custo contém o termo de reconstrução mais a norma quadrada do gradiente da representação oculta em relação à entrada. Portanto, o custo global minimizará a variação da camada oculta dada a variação da entrada. O benefício seria tornar o modelo sensível a direcções de reconstrução, enquanto insensível a quaisquer outras direções possíveis.

<!--Fig.19 shows how these autoencoders work in general.
-->
A Fig.19 mostra como esses autoencoders funcionam em geral.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basic autoencoder <br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Autoencoder básico <br>
</center>

<!--The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, the goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondence between points in the input space and the points on the latent space but do not have the correspondence between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer.
-->
O conjunto de treinamento é um objeto mono-dimensional que atravessa três dimensões. Onde $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, o objectivo para o autoencoder, é esticar a linha encaracolada em uma direção, onde $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. Como resultado, um ponto da camada de entrada será transformado em um ponto na camada latente. Agora temos a correspondência entre pontos no espaço de entrada e os pontos do espaço latente, mas não temos a correspondência entre regiões do espaço de entrada e regiões do espaço latente. Mais tarde, utilizaremos o decodificador (decoder) para transformar um ponto da camada latente para gerar uma camada de saída significativa.

<!--
## [Implement autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)
-->
## [Implementar autoencoder - notebook](https://www.youtube.com/watch?v=bggwq14dd9m&t=2491s)

<!--The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb).
-->
O notebook Jupyter pode ser encontrado [aqui](https://github.com/atcold/pytorch-deep-learning/blob/master/10-autoencoder.ipynb).

<!--In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs.
-->
Nesse notebook, vamos implementar um autoencoder padrão e um autoencoder de denoising e, em seguida, comparar as saídas.

<!--
### Define autoencoder model architecture and reconstruction loss
-->
### Definir a arquitectura do modelo de autoencoder e a função de custo de reconstrução

<!--Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model.
-->
Usando imagens $28 \times 28$ e uma camada oculta com 30 dimensões. A rotina de transformação seria ir de $784\to30\to784$. Através da aplicação da função tangente hiperbólica para as rotinas do codificador e decodificador, somos capazes de limitar a faixa de saída para $(-1, 1)$. O custo do erro quadrático médio(MSE) será usada como a função de custo deste modelo.

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```

<!--
### Train standard autoencoder
-->
### Treinar um autoencoder padrão

<!--To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop:
-->
Para treinar um autoencoder padrão usando o Pytorch, você precisa colocar os seguintes 5 métodos no loop de treinamento:

<!--
#### Going forward:
-->
#### Indo para frente:

<!--1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`.
-->
1) Enviando a imagem de entrada através do modelo chamando `output = model(img)` . <br>
2) Calcule o custo usando: `criterion(output, img.data)`.

<!--
#### Going backward:
-->
#### Indo para trás:

<!--3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()`
-->
3) Limpe o gradiente para se certificar de que não acumulamos o valor: `optimizer.zero_grad()`. <br>
4) Retropropagação: `loss.backward()`<br>
5) Passo para trás: `optimizer.step()`

<!--Fig. 20 shows the output of the standard autoencoder.
-->
A Fig. 20 mostra a saída do autoencoder padrão.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Output of standard autoencoder <br>
</center>
<br/>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Saída de autoencoder padrão <br>
</center>
<br/>


<!--
### Train denoising autoencoder
-->
### Treinar um autoencoder de Denoising

<!--For denoising autoencoder, you need to add the following steps:<br>
1) Calling `do = nn.Dropout()` creates a function that randomly turns off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binary masks: `img_bad = (img * noise).to(device)`.
-->
Para treinar um autoencoder de Denoising, você precisa adicionar as seguintes etapas: <br>
1) Chamar `do = nn.Dropout()` cria uma função que desliga aleatoriamente neurônios.<br>
2) Criar máscara de ruído: `do(torch.ones(img.shape))`.<br>
3) Crie imagens ruins através da multiplicação de boas imagens para as máscaras binárias: `img_bad = (img * noise).to(device)`.

<!--Fig. 21 shows the output of the denoising autoencoder.
-->
A Fig. 21 mostra a saída do autoencoder de denoising.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Output of denoising autoencoder <br>
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Saída de autoencoder de denoising <br>
</center>


<!--
### Kernels comparison
-->
### Comparação de kernels.

<!--It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image.
Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is.
-->
É importante notar que, apesar do fato de que a dimensão da camada de entrada é de US $28 \times 28 = 784$, uma camada oculta com uma dimensão de 500 é ainda uma camada sobre-completa por causa do número de pixels pretos na imagem.
Abaixo estão exemplos de kernels utilizados no autoencoder padrão sub-completo treinado. Claramente, os pixels na região onde o número existe indica a detecção de algum tipo de padrão, enquanto os pixels fora dessa região são basicamente aleatórios. Isso indica que o autoencoder padrão não se importa com os pixels fora da região onde o número existe.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standard AE kernels.
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Kernels padrão de AutoEncoders(AE).
</center>

<!--On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region.
-->
Por outro lado, quando os mesmos dados são alimentados a um autoencoder de denoising, onde uma máscara de dropout é aplicada a cada imagem antes de ajustar o modelo, algo diferente acontece. Todo o kernel que aprende um padrão define os pixels fora da região onde o número existe para algum valor constante. Como uma máscara de dropout é aplicada às imagens, o modelo agora se importa com os pixels fora da região dos números.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Denoising AE kernels.
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Kernels para Autoencoders (AE) de denoising 
</center>


<!--Compared to the state of the art, our autoencoder actually does better!! You can see the results below.
-->
Em comparação com o estado da arte, nosso autoencoder realmente faz melhor!! Você pode ver os resultados abaixo.

<!--
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Input data (MNIST digits).
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Dados de entrada (Dígitos Mnist).
</center>


<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Denoising AE reconstructions.
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Reconstrução com AE de denoising.
</center>


<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea inpainting output.
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Inpainting da Telea.
</center>


<!--<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Navier-Stokes inpainting output.
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Saída de Navier-Stokes inpainting.
</center>
