---
lang: pt
lang-ref: ch.07-2
lecturer: Yann LeCun
title: SSL, EBM com detalhes e exemplos
authors: Ravi Choudhary, B V Nithish Addepalli, Syed Rahman，Jiayi Du
date: 9 Mar 2020
translation-date: 5 March 2021
translator: Catarina Carvalho
---

<!--
## [Self supervised learning](https://www.youtube.com/watch?v=tVwV14YkbYs&t=2683s)
-->
## [Aprendizagem semi-supervisionada](https://www.youtube.com/watch?v=tvwv14ykbys&t=2683s)

<!--Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning. The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-Encoder (DAE) has particularly shown state-of-the-art results in Natural Language Processing (NLP).
-->
A aprendizagem semi-supervisionada (self-supervised SSL) engloba a aprendizagem supervisionada e a não-supervisionada. O objetivo de uma tarefa SSL é aprender uma boa representação da entrada para que ela seja posteriormente usada para tarefas supervisionadas. No SSL, o modelo é treinado para prever uma parte dos dados dados outras partes dos dados. Por exemplo, o BERT foi treinado usando técnicas SSL e um Denoising Auto-Encoder (DAE) e tem mostrado particularmente resultados ao nível do estado-da-arte em processamento de linguagem natural (NLP).

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Self Supervised Learning
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Aprendizagem semi-supervisionada
</center>

<!--Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts.
-->
A tarefa de aprendizagem semi-supervisionada pode ser definida segundo o seguinte:
* Prever o futuro a partir do passado.
* Prever as partes mascaradas a partir das visiveis.
* Prever quaisquer partes ocluídas de todas as partes disponíveis.

<!--For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity.
-->
Por exemplo, se um sistema for treinado para prever o próximo quadro quando a câmera for movida, o sistema irá implicitamente aprender sobre a profundidade e paralaxe. Isso forçará o sistema a aprender que objetos ocluídos de sua visão não desaparecem, mas continuam a existir e a distinção entre objetos animados, inanimados e o fundo. Também pode acabar aprendendo sobre física intuitiva, tal como a gravidade.

<!--State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion.
-->
Sistemas NLP de última geração (BERT) pré-treinam uma rede neural gigante em uma tarefa SSL. Você remove algumas das palavras de uma frase e faz com que o sistema preveja as palavras que faltam. Isso tem sido muito bem sucedido. Ideias semelhantes também foram experimentadas na área da visão de computador. Como mostrado na imagem abaixo, você pode pegar numa imagem e remover uma parte da imagem e treinar o modelo para prever a parte ausente.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Corresponding results in computer vision
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Resultados correspondentes em visão computacional
</center>

<!--Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continuous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not.
-->
Embora os modelos possam preencher o espaço ausente, eles não compartilharam o mesmo nível de sucesso que os sistemas NLP. Se você fosse usar as representações internas geradas por esses modelos, como entrada para um sistema de visão de computador, este seria incapaz de bater um modelo que foi pré-treinado de maneira supervisionada no ImageNet. A diferença aqui é que a NLP é discreta enquanto imagens são contínuas. A diferença no sucesso existe porque no domínio discreto nós sabemos representar incerteza, podemos usar um grande softmax sobre as possíveis saídas, no domínio contínuo não fazemos como fazer o mesmo.

<!--An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models (EBMs) can be extremely useful for this.
-->
Um sistema inteligente (agente AI) precisa ser capaz de prever os resultados de sua própria ação sobre o entorno e sobre si mesmo para tomar decisões inteligentes. Sendo que o mundo não é completamente determinista e não há potência suficiente de computação em uma máquina/cérebro humano para explicar todas as possibilidades, precisamos ensinar sistemas de AI a prever na presença de incerteza em espaços de alta dimensão. Modelos baseados em energia (EBMs) podem ser extremamente úteis para isso.

<!--A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss.
-->
Uma rede neural treinada usando o método dos mínimos quadrados para prever o próximo quadro de um vídeo resultará em imagens desfocadas porque o modelo não pode prever o futuro com exactidão, então ele aprende a calcular a média de todas as possibilidades do próximo quadro a partir dos dados de treinamento para reduzir a perda.

<!--
### Latent variable energy-based models as a solution to make predictions for next frame:
-->
### Modelos de energia com variável latente como solução para fazer previsões para o próximo quadro:

<!--Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs.
-->
Ao contrário da regressão linear, os modelos baseados em energia com variáveis latentes utilizam o que sabemos sobre o mundo, bem como uma variável latente que nos dá informações sobre o que aconteceu na realidade. Uma combinação dessas duas informações pode ser usada para fazer uma previsão que estará próxima do que realmente ocorre.

<!--These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$ for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system.
-->
Esses modelos podem ser pensados como sistemas que avaliam a compatibilidade entre a entrada $x$ e a saída real $y$, dependendo da previsão usando a variável latente que minimiza a energia do sistema. Você observa a entrada $x$ e produz possíveis previsões $\bar{y}$ para diferentes combinações de entrada $x$ e variável latente $z$ e escolhe aquela que minimiza a energia, erro de previsão, do sistema.

<!--Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$.
-->
Dependendo da variável latente que desenhamos, podemos acabar por obter todas as possíveis previsões. A variável latente pode ser pensada como uma peça de informação importante sobre a saída $y$ que não está presente na entrada $x$.

<!--Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$
-->
A função de energia, em valor escalar, pode levar assumir duas versões:
1. Condicional $F(x, y)$ - Mede a compatibilidade entre $x$ e $y$
2. Incodicional $F(y)$ - Mede a compatibilidade entre os componentes de $y$

<!--
## [Training an Energy-Based Model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=3957s)
-->
## [Treinando um modelo baseado em energia](https://www.youtube.com/watch?v=tvwv14ykbys&t=3957s)

<!--There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $F(x, y)$ so that the volume of low energy regions is limited or minimized through regularization
-->
Existem duas classes de modelos de aprendizagem para treinar um modelo baseado em energia para parametrizar $F(x, y)$.
1. **Métodos contrastivos:** Empurram $F(x[i], y[i])$ para baixo, empurram para cima os outros pontos $F(x[i], y')$
2. **Métodos arquitetônicos:** Constroi-se $F(x, y)$ para que o volume das regiões de baixa energia sejam limitados ou minimizados através da regularização

<!--There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the way they limit the information capacity of the code.
-->
Existem sete estratégias para moldar a função de energia. Os métodos contrastivos diferem na maneira como se escolhe os pontos a aumentar. Enquanto os métodos arquitetônicos diferem na maneira como limitam a capacidade de informação do código.

<!--An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalised negative log density. Gibbs distribution gives us the likelihood of $y$ given $x$. It can be formulated as follows:
-->
Um exemplo do método contrastivo é o máximo de aprendizagem de verossimilhança (Maximum Likelihood learning). A energia pode ser interpretada como uma densidade logarítmica negativa não normalizada. A distribuição de Gibbs nos dá a verossimilhança de $y$ dado $x$. Pode ser formulado da seguinte forma:

<!--$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$
-->

$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

<!--Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below
-->
A máxima verossimilhança tenta tornar o numerador grande e o denominador pequeno para maximizar a verossimilhança. Isso é equivalente a minimizar $-\log(P(Y \mid W))$ que é dado abaixo

<!--$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\log\int_{y}e^{-\beta E(y,W)}
$$
-->

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\int_{y}e^{-\beta E(y,W)}
$$


<!--Gradient of the negative log likelihood loss for one sample Y is as follows:
-->
Gradiente da função de custo de verossimilhança de log negativo para uma amostra Y é a seguinte:

<!--$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$
-->

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

<!--In the above gradient, the first term of the gradient at the data point $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy over all $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the data point $Y$ and the second term tries to increase the energy given to all other $Y$s.
-->
No gradiente acima, o primeiro termo do gradiente no ponto $y$ e o segundo termo do gradiente nos dá o valor esperado do gradiente da energia em todos os $Y$s. Assim, quando realizamos o gradiente descendente, o primeiro termo tenta reduzir a energia dada ao ponto $y$ e o segundo termo tenta aumentar a energia dada a todos os outros $Y$s.

<!--The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases.
-->
O gradiente da função de energia é geralmente muito complexo e, portanto, a computação, estimativa ou aproximação do integral é um caso muito interessante, pois é intratável na maioria dos casos.

<!--
## [Latent variable energy-based model](https://www.youtube.com/watch?v=tVwV14YkbYs&t=4767s)
-->
## [Modelo baseado em energia com variável latente](https://www.youtube.com/watch?v=tvwv14ykbys&t=4767s)

<!--The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ varies over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modelling
3. [GLO](https://arxiv.org/abs/1707.05776)
-->
A principal vantagem dos modelos com variáveis latentes é que permitem várias previsões através da variável latente. Como $z$ varia sobre um conjunto, $y$ varia sobre o conjunto de possíveis previsões. Alguns exemplos incluem:
1. K-means
2. Modelagem Esparsa (Sparse modelling)
3. [GLO](https://arxiv.org/abs/1707.05776)

<!--These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, $F(y)$ that measures the compatibility between the components of $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$
-->
Estes podem ser de dois tipos:
1. Modelos condicionais onde $y$ depende de $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Modelos incondicionais que têm função de energia com valores escalares, $F(y)$ que mede a compatibilidade entre os componentes de $y$
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Latent Variable EBM
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Variável latente em EBM
</center>

<!--
## Latent variable EBM example: $K$-means
-->
## Exemplo de EBM com variável latente: $K$-means

<!--K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector.
-->
K-means é um algoritmo de agrupamento simples que também pode ser considerado como um modelo baseado em energia onde estamos tentando modelar a distribuição de $y$. A função de energia é $E(y,z) = \Vert y-Wz \Vert^2$ where $z$, onde $z$ é um vetor de $1$s ($1$-hot vector).

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-means example
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: Exemplo de K-means
</center>

<!--Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster.
-->
Dado um valor de $y$ e $k$, podemos fazer a inferência descobrindo quais das $k$ colunas possiveis de $W$ minimiza o erro de reconstrução ou a função de energia. Para treinar o algoritmo, podemos adotar uma abordagem onde podemos encontrar $z$ para escolher a coluna de $W$ mais próximo de $y$ e, em seguida, tentar ficar ainda mais perto dando um passo ao longo do gradiente, e repetindo o processo. No entanto, coordenar o gradiente descendente funciona realmente melhor e mais rápido.

<!--In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of $W$.
-->
No gráfico abaixo, podemos ver os pontos de dados ao longo da espiral rosa. Os bolhas negras que rodeiam esta linha correspondem a poços quadráticos em torno de cada um dos protótipos de $W$.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Spiral plot
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Gráfico de espiral
</center>

<!--Once we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold?
-->
Uma vez que aprendemos a função de energia, podemos começar a resolver perguntas como:
1. Dado um ponto $y_1$, podemos prever $y_2$?
2. Dado $y$, podemos encontrar o ponto mais próximo no conjunto de dados?

<!--K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them.
-->
K-means pertence aos métodos arquitetônicos (em oposição aos métodos contrastivos). Portanto, não empurram a energia para lugar nenhum, tudo o que fazem é empurrar a energia para baixo em certas regiões. Uma desvantagem é que uma vez que o valor de $k$ já foi decidido, só pode haver $k$ pontos que tenham $0$ energia, e todos os outros pontos terão energia mais alta que cresce quadricamente à medida que nos afastamos deles.

<!--
## Contrastive methods
-->
## Métodos contrastivos

<!--According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (*i.e.* the value of $F(x,y)$) around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy.
-->
De acordo com o Dr. Yann Lecun, todos irão usar métodos arquitetônicos em algum momento, mas neste momento, são os métodos contrastativos que funcionam para imagens. Considere a figura abaixo que nos mostra alguns pontos de dados e contornos da superfície de energia. Idealmente, queremos que a superfície de energia tenha a energia mais baixa no conjunto de dados. Desta forma, o que gostaríamos de fazer é reduzir a energia (*p.ex.* o valor de $F(x, y)$) em torno do exemplo de treinamento, mas isso sozinho pode não ser suficiente. Portanto, também aumentamos para os $y$'s na região que deve ter alta energia, mas tem baixa energia.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Contrastive methods
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Métodos contrastivos
</center>

<!--There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo
-->
Existem várias maneiras de encontrar esses candidatos $y$'s que queremos aumentar a energia. Alguns exemplos são:
1. Autoencoder de denoising
2. Divergência contrastativa.
3. Monte Carlo.
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo

<!--We will briefly discuss denoising autoencoders and contrastive divergence.
-->
Vamos discutir brevemente os autoencoders de denoising e a divergência contrastiva.

<!--
### Denoising autoencoder (DAE)
-->
### Autoencoders de Denoising (DAE)

<!--One way of finding $y$'s to increase energy for it is by randomly perturbing the training example as shown by the green arrows in the plot below.
-->
Uma maneira de encontrar $y$'s para aumentar a energia é perturbando aleatoriamente o exemplo de treinamento, conforme mostrado pelas setas verdes no gráfico abaixo.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topographic map
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Mapa topográfico
</center>

<!--Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done.
-->
Assim que temos um ponto de dados corrompido, podemos empurrar a energia até ai. Se fizermos isso suficientemente vezes para todos os pontos de dados, a amostra de energia enrolará em torno dos exemplos de treinamento. O gráfico a seguir ilustra como o treinamento é feito.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Training
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Treinamento
</center>

<!--Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point
-->
Etapas para treinamento:
1. Pegue um ponto $y$ e corrompe-o
2. Treine o codificador (Encoder) e decodificador (Decoder) para reconstruir o ponto de dados original a partir desse ponto de dados corrompido

<!--If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold.
-->
Se o DAE estiver corretamente treinado, a energia cresce quadraticamente à medida que nos afastarmos do conjunto de dados.

<!--The following plot illustrates how we use the DAE.
-->
O gráfico seguinte ilustra como usamos o DAE.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: How DAE is used
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: Como DAE é usada
</center>

<!--
### BERT
-->
### BERT

<!--BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstruction step consists of trying to predict these. Hence, this is also called a masked autoencoder.
-->
O BERT é treinado da mesma forma, exceto que o espaço é discreto visto estarmos a lidar com texto. A técnica de corrupção consiste em mascarar algumas das palavras e o passo de reconstrução consiste em tentar prever estes. Assim, isso também é chamado de autoencoder-mascarado (masked autoencoder).

<!--
### Contrastive divergence
-->
### Divergência contrastiva

<!--Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line.
-->
A divergência contrastiva nos apresenta uma maneira mais inteligente de encontrar o ponto $y$ que queremos empurrar a energia para cima. Podemos dar um empurrão aleatório ao nosso ponto de treinamento e depois descer a função de energia usando o gradiente descendente. No final da trajetória, empurramos a energia para o ponto onde pousámos. Isso é ilustrado no gráfico abaixo usando a linha verde.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Contrastive Divergence
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Divergência contrastiva
</center>
