---
lang: pt
lang-ref: ch.07-1
lecturer: Yann LeCun
title: Modelos baseados em energia (EBM)
authors: Karanbir Singh Chahal, Meiyi He, Alexander Gao, Weicheng Zhu
date: 9 Mar 2020
translation-date: 5 March 2021
translator: Catarina Carvalho
---

<!--
## [Overview](https://www.youtube.com/watch?v=tVwV14YkbYs&t=64s)
-->
## [Visão geral](https://www.youtube.com/watch?v=tvwv14ykbys&t=64s)
<!--We will introduce a new framework for defining models. It provides a unifying umbrella that helps define supervised, unsupervised and self-supervised models. Energy-based models observe a set of variables $x$ and output a set of variables $y$. There are 2 major problems with feed-forward nets:
-->
Vamos introduzir uma nova *framework* para definir modelos. Ele framework fornece uma estrutura que ajuda a definir modelos supervisionados, não supervisionados e semi-supervisionados. Modelos baseados em energia utilizam um conjunto de variáveis $x$ e produzem um conjunto de variáveis $y$. Existem 2 grandes problemas com redes de alimentação para a frente (feed-forward):

<!--1. What if the inference procedure is a more complex calculation than stacked layers of weighted sums?
2. What if there are multiple possible outputs for a single input? Example: Predicting future frames of video. Essentially in a classification net, we train this net to emit a score for each class. However, this is not possible to do in a continuous high dimensional domain like images. (We cannot have softmax over images!). Even if the output is discrete, it could have a large sample space. For example, the text is compositional leading to a huge number of possible combinations. Energy-based models provide a better framework to model these modalities.
-->
1. E se o procedimento de inferência for um cálculo mais complexo do que camadas empilhadas de somas ponderadas?
2. E se houver várias saídas possíveis para uma única entrada? Exemplo: Prever futuros quadros de vídeo. Essencialmente em uma rede de classificação, treinamos esta rede para emitir uma pontuação para cada classe. No entanto, isso não é possível fazer em um domínio contínuo de alta dimensão como imagens. (Não podemos aplicar softmax sobre imagens!). Mesmo que a saída seja discreta, pode ter um grande espaço de amostra. Por exemplo, o texto é composicional levando a um grande número de combinações possíveis. Modelos baseados em energia fornecem uma melhor estrutura para modelar essas modalidades.

<!--## EBM approach-->

## Abordagem EBM.

<!--Instead of trying to classify $x$'s to $y$'s, we would like to predict if a certain pair of ($x$, $y$) fit together or not. Or in other words, find a $y$ compatible with $x$. We can also pose the problem as finding a $y$ for which some $F(x,y)$ is low. For example:
-->
Em vez de tentar classificar $x$'s para $y$'s, gostaríamos de prever se um determinado par de ($x$, $y$) combinam/enquadram ou não. Ou em outras palavras, encontrar $y$ compatível com $x$. Também podemos representar o problema como encontrar $y$ para o qual alguns $F(x,y)$ é baixo. Por exemplo:

<!-- 
- Is $y$ an accurate high-resolution image of $x$ ?
- Is text `A` a good translation of text `B`?
-->

- é $y$ uma imagem de alta resolução precisa de $x$?
- é o texto `A` uma boa tradução de texto `B`?

<!-- This method of inference by minimizing a function and a large class of models work this way. By minimizing $f(x,y)$ or "energy". Hence, we perform inference by minimizing constraints where these constraints are represented by $f(x,y)$. We shall call $f(x,y)$ the "Energy function" from henceforth.
-->

Este método de inferência, minimizando uma função e uma grande classe de modelos, funciona dessa maneira. Minimizando $f(x,y)$ ou "energia". Assim, realizamos a inferência minimizando as restrições onde essas restrições são representadas por $f(x,y)$. Vamos chamar $f(x,y)$ a "Função de Energia" a partir de agora.

<!--
### Definition
-->

### Definição.

<!--We define an energy function $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ where $F(x,y)$ describes the level of dependency between $(x,y)$ pairs. (**Note** that this energy is used in inference, **not** in learning.) The inference is given by the following equation:
-->
Definimos uma função de energia $F: \mathcal{X} \times \mathcal{Y} \rightarrow \mathcal{R}$ onde $F(x,y)$ descreve o nível de dependência entre $(x,y)$ pares. (** Nota ** esta energia é usada em inferência, **não** na aprendizagem.) A inferência é dada pela seguinte equação:
<!--
$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$
-->

$$
\check{y} = \displaystyle \text{argmin}_y \left \{ F(x,y)\right \}
$$


<!--
### Solution: gradient-based inference
-->

### Solução: Inferência baseada em gradientes

<!--We would like the energy function to be smooth and differentiable so that we can use it to perform the gradient-based method for inference. In order to perform inference, we search this function using gradient descent to find compatible $y$'s.
There are many alternate methods to gradient methods to obtain the minimum.
-->
Gostaríamos que a função de energia fosse suave e diferenciável para que possamos usá-la para realizar o método baseado em gradiente para a inferência. Para realizar a inferência, pesquisamos esta função usando a descida de gradiente de forma a encontrar $Y$'s compatíveis.
Existem muitos métodos alternativos aos métodos de gradientes para obter o mínimo.
<!--**Aside**: Graphical models are a special case of Energy-Based models. The energy function decomposes as a sum of energy terms. Each energy terms take into account a subset of variables that we are dealing with. If they organize in a particular form, there are efficient inference algorithms to find the minimum of the sum of the terms with respect to the variable that we are interested in inferring.
-->


**À parte**: Os modelos gráficos são um caso especial de modelos baseados em energia. A função de energia se decompõe como uma soma de termos de energia. Cada termo de energia leva em conta um subconjunto de variáveis com que estamos lidando. Se eles se organizarem em uma forma específica, existem algoritmos de inferência eficientes para encontrar o mínimo da soma dos termos em relação à variável que estamos interessados em inferir.

<!-- There are a type of Energy Based Models that are quite popular. These are-->
<!-- ## [EBM with latent variables](https://www.youtube.com/watch?v=tVwV14YkbYs&t=904s)
-->

Há um tipo de modelos baseados em energia que são bastante populares.Estes são:

## [EBM com variáveis latentes](https://www.youtube.com/watch?v=tvwv14ykbys&t=904s)

<!--The output $y$ depends on $x$ as well as an extra variable $z$ (the latent variable) which we do not know the value of. These latent variables can provide auxiliary information. For example, a latent variable can tell you the positions of word boundaries in a chunk of text. This would be helpful to know when we want to interpret handwriting without spaces. This is also especially useful to know in speech that can have hard-to-decipher gaps. Additionally, some languages have very faint word boundaries (*e.g.* French). Hence, having this latent variable in our model will be very useful to interpret such an input.
-->
A saída $y$ depende de $x$, bem como uma variável extra $z$ (a variável latente) acerca da qual não conhecemos o valor. Essas variáveis latentes podem fornecer informações auxiliares. Por exemplo, uma variável latente pode dizer-lhe as posições dos limites da palavra em um pedaço de texto. O que seria útil saber quando queremos interpretar a caligrafia sem espaços. Isto também é especialmente útil para percebern em fala que pode ter lacunas difíceis de decifrar. Além disso, algumas línguas têm limites de palavra muito fracos (*p.ex* Francês). Portanto, ter essa variável latente em nosso modelo será muito útil para interpretar esse tipo de entrada.

<!--### Inference-->

### inferência

<!--To do inference with latent variable EBM, we want to simultaneously minimize energy function with respect to y and z.
-->
Para fazer inferência com variável latente EBM, queremos minimizar simultaneamente a função de energia em relação a y e z.
<!--$$\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)$$
-->

$$

\check{y}, \check{z} = \text{argmin}_{y,z} E(x,y,z)

$$

<!--And this is equivalent to redefining the energy function as: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, which equals to: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
When $\beta \rightarrow \infty$, then $\check{y} = \text{argmin}_{y}F(x,y)$.
-->

E isto é equivalente a redefinir a função energética como: $$F_\infty(x,y) = \text{argmin}_{z}E(x,y,z)$$, que é igual a: $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z \exp(-\beta E(x,y,z))$$.
Quando $\beta \rightarrow \infty$, então $\check{y} = \text{argmin}_{y}F(x,y)$.

<!--  ## Latent-Variable EBM -->
<!-- 
Another big advantage of allowing latent variables, is that by varying the latent variable over a set, we can make the prediction output $y$ vary over the manifold of possible predictions as well (the ribbon is shown in the graph below): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.
-->

## Variável latente EBM

Outra grande vantagem de permitir variáveis latentes é que, ao modificar a variável latente em um conjunto, podemos fazer com que o resultado de predição $y$ varie sobre o conjunto de possíveis previsões também (a fita é mostrada no gráfico abaixo): $F(x,y) = \text{argmin}_{z} E(x,y,z)$.

<!--This allows a machine to produce multiple outputs, not just one.
-->

Isso permite que uma máquina produza várias saídas, não apenas uma.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Computation graph for Energy-based models
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig1.png"/><br>
<b>Fig. 1</b>: Gráfico de computação para modelos baseados em energia
</center>
<!--
### Examples
-->

### Exemplos

<!--One example is video prediction. There are many good applications for us to use video prediction, one example is to make a video compression system. Another is to use video taken from a self-driving car and predict what other cars are going to do.
-->

Um exemplo é uma previsão de vídeo. Há muitos bons aplicativos para usar previsão de vídeo, um exemplo é fazer um sistema de compactação de vídeo. Outra é usar um vídeo adquirido a partir de um carro autónomo e prever o que os outros carros vão fazer.
<!--Another example is translation. Language translation has always been a difficult problem because there is no single correct translation for a piece of text from one language to another. Usually, there are a lot of different ways to express the same idea and people find it is hard to reason why they pick one over the other. So it might be nice if we have some way of parametrising all the possible translations that a system could produce to respond to a given text. Let's say if we want to translate German to English, there could be multiple translations in English that are all correct, and by varying some latent variables then you may vary the translation produced.
-->

Outro exemplo é a tradução. A tradução de idioma sempre foi um problema difícil porque não há uma única tradução correta para um texto de um idioma para outro. Normalmente, há muitas maneiras diferentes de expressar a mesma ideia e as pessoas acham difícil explicar por que eles escolhem uma sobre a outra. Por isso, seria bom se tivessemos alguma maneira de parametrizar todas as traduções possíveis que um sistema poderia produzir para responder a um determinado texto. Digamos que se quisessemmos traduzir Alemão para Inglês, poderia haver várias traduções em Inglês que estariam corretas, e variando algumas variáveis latentes, então você pode variar a tradução produzida.

<!--## [Energy-based models *v.s.* probabilistic models](https://www.youtube.com/watch?v=tVwV14YkbYs&t=1703s)-->

## [Modelos baseados em energia *v.s* modelos probabilísticos](https://www.youtube.com/watch?v=tvwv14ykbys&t=1703S)

<!--We can look at the energies as unnormalised negative log probabilities, and use Gibbs-Boltzmann distribution to convert from energy to probability after normalization is:
-->
Podemos analisar as energias como probabilidades log negativas não-normalizadas e usar a distribuição de Gibbs-Boltzmann para converter de energia para probabilidade após a normalização:

<!--$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$
-->

$$P(y \mid x) = \frac{\exp (-\beta F(x,y))}{\int_{y'}\exp(-\beta F(x,y'))}$$

<!--where $\beta$ is positive constant and needs to be calibrated to fit your model. Larger $\beta$ gives a more fluctuate model while smaller $\beta$ gives a smoother model. (In physics, $\beta$ is inverse temperature: $\beta \rightarrow \infty$ means temperature goes to zero).
-->

onde $\beta$ é positivo constante e precisa ser calibrado para se adequar ao seu modelo. Maior $\beta$ resulta num modelo mais flutuante enquanto menor $\beta$ produz um modelo mais suave. (Em física, $\beta$ é a temperatura inversa: $\beta \rightarrow \infty$ o que significa que a temperatura vai para zero).
<!--$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$
-->

$$P(y,z \mid x) = \frac{\exp(-\beta F(x,y,z))}{\int_{y}\int_{z}\exp(-\beta F(x,y,z))}$$

<!--Now if marginalize over y: $P(y \mid x) = \int_z P(y,z \mid x)$, we have:
-->

Agora, se marginalizar sobre y: $P(y \mid x) = \int_z P(y,z \mid x)$, então temos:

<!--$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$
-->

$$
\begin{aligned}
P(y \mid x) & = \frac{\int_z \exp(-\beta E(x,y,z))}{\int_y\int_z \exp(-\beta E(x,y,z))} \\
& = \frac{\exp \left [ -\beta \left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right ) \right ] }{\int_y \exp\left [ -\beta\left (-\frac{1}{\beta}\log \int_z \exp(-\beta E(x,y,z))\right )\right ]} \\
& = \frac{\exp (-\beta F_{\beta}(x,y))}{\int_y \exp (-\beta F_{\beta} (x,y))}
\end{aligned}
$$

<!--Thus, if we have a latent variable model and want to eliminate the latent variable $z$ in a probabilistically correct way, we just need to redefine the energy function $F_\beta$ (Free Energy)
-->
Então, se tivermos um modelo de variável latente e quisermos eliminar a variável latente $z$ de forma probabilisticamente correta, só precisamos redefinir a função de energia $F_\beta$ (energia livre)

<!--### Free Energy-->

### Energia livre

<!--$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$
-->

$$
F_{\beta}(x,y) = - \frac{1}{\beta}\log \int_z \exp (-\beta E(x,y,z))
$$

<!--Computing this can be very hard...  In fact, in most cases, it's probably intractable.  So if you have a latent variable that you want to minimize over inside of your model, or if you have a latent variable that you want to marginalize over (which you do by defining this Energy function $F$), and minimizing corresponds to the infinite $\beta$ limit of this formula, then it can be done.
-->
Calcular isto pode ser muito difícil ... De fato, na maioria dos casos, é provavelmente intratável. Então, se você tiver uma variável latente que deseja minimizar dentro do seu modelo, ou se você tiver uma variável latente que deseja marginalizar (que você faz definindo essa função de energia $F$), e minimizar corresponde ao limite infinito $\beta$ desta fórmula, então pode ser feito.

<!--Under the definition of $F_\beta(x, y)$ above, $P(y \mid x)$ is just an application of the Gibbs-Boltzmann formula and $z$ has been marginalized implicitly inside of this.  Physicists call this "Free Energy", which is why we call it $F$.   So $e$ is the energy, and $F$ is free energy.
-->

Sob a definição de $F_\beta(x, y)$ acima, $P(y \mid x)$ é apenas uma aplicação da fórmula Gibbs-Boltzmann e $z$ foi marginalizada implicitamente dentro dessa. Os físicos chamam a isto "energia livre", e é por isso que lhe chamamos de $F$. Então, $e$ é a energia, e $F$ é a energia livre.

<!--***Question: Can you elaborate on the advantage that energy-based models give?  In probability-based models, you can also have latent variables, which can be marginalized over.***
-->

*** Pergunta: Pode elaborar sobre a vantagem dos modelos baseados em energia? Nos modelos baseados em probabilidade, você também pode ter variáveis latentes, que podem ser marginalizadas.***

<!--The difference is that in probabilistic models, you basically don't have the choice of the objective function you're going to minimize, and you have to stay true to the probabilistic framework in the sense that every object you manipulate has to be a normalized distribution (which you may approximate using variational methods, etc.). Here, we're saying that ultimately what you want to do with these models is make decisions.  If you build a system that drives a car, and the system tells you "I need to turn left with probability 0.8 or turn right with probability 0.2", you're going to turn left.  The fact that the probabilities are 0.2 and 0.8 doesn't matter -- what you want is to make the best decision, because you're forced to make a decision.  So probabilities are useless if you want to make decisions.  If you want to combine the output of an automated system with another one (for example, a human, or some other system), and these systems haven't been trained together, but rather they have been trained separately, then what you want are calibrated scores so that you can combine the scores of the two systems so that you can make a good decision.  There is only one way to calibrate scores, and that is to turn them into probabilities.  All other ways are either inferior or equivalent.  But if you're going to train a system end-to-end to make decisions, then whatever scoring function you use is fine, as long as it gives the best score to the best decision.  Energy-based models give you way more choices in how you handle the model, way more choices of how you train it, and what objective function you use. If you insist your model be probabilistic, you have to use maximum likelihood -- you basically have to train your model in such a way that the probability it gives to the data you observed is maximum.  The problem is that this can only be proven to work in the case where your model is "correct" -- and your model is never "correct".  There's a quote from a famous statistician [Goerge Box] that says ***"All models are wrong, but some are useful."***  So probabilistic models, particularly those in high-dimensional spaces, and in combinatorial spaces such as text, are all approximate models.  They're all wrong in a way, and if you try to normalize them, you make them more wrong.  So you're better off not normalizing them.
-->

A diferença é que em modelos probabilísticos, você basicamente não tem a escolha da função objetiva que você vai minimizar, e você tem que se manter fiel ao esquema probabilístico no sentido de que todo objeto que você manipule tem que ser uma distribuição normalizada (que você pode aproximar usando métodos variacionais, etc.). Aqui, estamos dizendo que, em última análise, o que você quer fazer com esses modelos é tomar decisões. Se você construir um sistema que dirija um carro, e o sistema lhe disser "Eu preciso virar à esquerda com probabilidade 0.8 ou virar à direita com a probabilidade 0.2", você vai virar à esquerda. O fato de que as probabilidades são 0.2 e 0.8 não importa - o que você quer é tomar a melhor decisão, porque você é forçado a tomar uma decisão. Portanto, as probabilidades são inúteis se você quiser tomar decisões. Se você quiser combinar a saída de um sistema automatizado com outro (por exemplo, um humano ou algum outro sistema), e esses sistemas não foram treinados juntos, mas foram antes treinados separadamente, então o que você quer é (escores/pontuações) calibrados para que você possa combinar os escores dos dois sistemas para que você possa tomar uma boa decisão. Há apenas uma maneira de calibrar os escores, e isso é transformá-los em probabilidades. Todas as outras maneiras são inferiores ou equivalentes. Mas se você for treinar um sistema de ponta-a-ponta para tomar decisões, então seja qual for a função de pontuação que você usa está bem, desde que esta associe a melhor pontuação à melhor decisão. Modelos baseados em energia lhe dão muito mais opções em como você lida com o modelo, muito mais opções de como você o treinar e que função objetivo você usa. Se você insistir que o seu modelo seja probabilístico, você tem que usar a máxima verossimilhança (maximum likelihood) - basicamente tem que treinar seu modelo de tal forma que a probabilidade retornada aos dados observados é máxima. O problema é que isso só pode ser provado funcionar no caso do seu modelo ser "correto" - e seu modelo nunca é "correto". Há uma citação de um famoso estatístico [Goerge Box] que diz ***"Todos os modelos estão errados, mas alguns são úteis".*** Assim, modelos probabilísticos, particularmente aqueles em espaços de alta dimensão, e em espaços combinatórios como texto, são todos modelos aproximados. Eles estão todos errados de certa forma, e se você tentar normalizá-los, você os torna mais errados. Então é melhor não os normalizar.

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualization of the energy function that captures dependency between x and y
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 2</b>: Visualização da função de energia que captura a dependência entre x e y
</center>
<!--This is an energy function that's meant to capture the dependency between *x* and *y*.  It's like a mountain range if you will.  The valleys are where the black dots are (these are data points), and there are mountains all around.  Now, if you train a probabilistic model with this, imagine that the points are actually on an infinitely thin manifold.  So the data distribution for the black dots is actually just a line, and there are three of them.  They don't actually have any width.  So if you train a probabilistic model on this, your density model should tell you when you are on this manifold.  On this manifold, the density is infinite, and just $\varepsilon$ outside of it should be zero.  That would be the correct model of this distribution.  Not only should the density be infinite, but the integral over [x and y] should be 1.  This is very difficult to implement on the computer!  Not only that, but it's also basically impossible.  Let's say you want to compute this function through some sort of neural net -- your neural net will have to have infinite weights, and they would need to be calibrated in such a way that the integral of the output of that system over the entire domain is 1.  That's basically impossible.  The accurate, correct probabilistic model for this particular data example is impossible.  This is what maximum likelihood will want you to produce, and there's no computer in the world that can compute this.  So in fact, it's not even interesting.  Imagine that you had the perfect density model for this example, which is a thin plate in that (x, y) space -- you couldn't do inference!  If I give you a value of x, and ask you "what's the best value of y?"  You wouldn't be able to find it because all values of y except a set of zero-probability have a probability of zero, and there are just a few values that are possible.  For these values of x for example:
-->

Esta é uma função de energia que se destina a capturar a dependência entre *x* e *y*. É como uma cordilheira se você quiser. Os vales são onde os pontos pretos estão (estes são pontos de dados), e há montanhas ao redor. Agora, se você treinar um modelo probabilístico com isso, imagine que os pontos estão realmente em uma variedade infinitamente fina. Assim, a distribuição de dados para os pontos negros é realmente apenas uma linha, e há três delas. Elas não têm nenhuma largura. Então, se você treinar um modelo probabilístico sobre isso, seu modelo de densidade deve dizer quando você estiver nessa superficie (manifold). Nesta superficie (manifold), a densidade é infinita, e apenas $\varepsilon$ fora disso deve ser zero. Esse seria o modelo correto dessa distribuição. Não só a densidade deve ser infinita, mas a integral em [x e y] deve ser 1. Isso é muito difícil de implementar no computador! Não só isso, mas também é basicamente impossível. Digamos que você queira calcular essa função através de algum tipo de rede neural - sua rede neural terá que ter pesos infinitos, e eles precisariam ser calibrados de tal maneira que o integral da saída desse sistema em todo o domínio seria 1. Isso é basicamente impossível. O modelo probabilístico exacto (accurate) e correto para este exemplo de dados específico é impossível. Isto é o que a máxima verossimilhança (maximum likelihood) vai querer que você produza, e não há computador no mundo que possa calcular isso. Então, na verdade, isto nem é interessante. Imagine que você tinha o modelo de densidade perfeito para este exemplo, que é uma superficie fina naquele espaço (x,y) - você não poderia fazer inferência! Se eu te der um valor de x, e perguntar a você "Qual é o melhor valor de y?" Você não seria capaz de encontrá-lo porque todos os valores de y, exceto que um conjunto de probabilidade zero ,têm uma probabilidade de zero, e há apenas alguns valores possíveis. Para estes valores de x, por exemplo:

<!--<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Example for multiple prediction of EBM as an implicit function
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week07/07-1/fig4.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: Exemplo para uma previsão múltipla de EBM como uma função implícita
</center>
<!--There are 3 values of y that are possible, and they are infinitely narrow.  So you wouldn't be able to find them.  There's no inference algorithm that will allow you to find them.  The only way you can find them is if you make your contrast function smooth and differentiable, and then you can start from any point and by gradient descent you can find a good value for y for any value of x.  But this is not going to be a good probabilistic model of the distribution if the distribution is of the type I mentioned.  So here is a case where insisting to have a good probabilistic model is actually bad.  Maximum likelihood sucks [in this case]!
-->

Existem 3 valores de y que são possíveis, e eles são infinitamente estreitos. Então você não seria capaz de encontrá-los. Não há algoritmo de inferência que lhe permitirá encontrá-los. A única maneira de encontrá-los é se você fizer sua função de contraste suave e diferenciável, e então você pode começar de qualquer ponto e por descida de gradiente você pode encontrar um bom valor para y para qualquer valor de x. Mas isso não será um bom modelo probabilístico da distribuição se a distribuição for do tipo que mencionei. Então, aqui está um caso em que insistir para ter um bom modelo probabilístico é realmente ruim. Máxima verossimilhança (maximum likelihood) é uma porcaria [neste caso]!

<!--So if you are a true Bayesian, you say "oh but you can correct this by having a strong prior where the prior says your density function has to be smooth".  You could think of this as a prior.  But, everything you do in Bayesian terms -- take the logarithm thereof, forget about normalization -- you get energy-based models.  Energy-based models that have a regulariser, which is additive to your energy function, are completely equivalent to Bayesian models where the likelihood is exponential of the energy, and now you get $\exp(\text{energy}) \exp(\text{regulariser})$, and so it's equal to $\exp(\text{energy} + \text{regulariser})$.  And if you remove the exponential you have an energy-based model with an additive regulariser.
-->

Então, se você é um verdadeiro Bayesiano, você diz "Oh, mas você pode corrigir isso tendo um forte *prior*, onde o *prior* diz que sua função de densidade tem que ser suave". Você poderia pensar nisso como *prior*. Mas, tudo o que você faz em termos bayesianos -- pegue o seu logaritmo, esqueça a normalização -- você obtem modelos baseados em energia. Modelos baseados em energia que têm um regularizador, que é aditivo à sua função de energia, são completamente equivalentes a modelos Bayesianos, onde a verossimilhança (likelihood) é o exponencial da energia, e agora você recebe $\exp(\text{energy}) \exp(\text{regulariser})$, e por isso é igual a $\exp(\text{energy} + \text{regulariser})$. E se você remover o exponencial, você terá um modelo baseado em energia com um regularizador aditivo .

<!--So there is a correspondence between probabilistic and Bayesian methods there, but insisting that you do maximum likelihood is sometimes bad for you, particularly in high-dimensional spaces or combinatorial spaces where your probabilistic model is very wrong. It's not very wrong in discrete distributions (it's okay) but in continuous cases, it can be really wrong.  And all the models are wrong.
-->

Portanto, há uma correspondência entre os métodos probabilísticos e bayesianos, mas insistir em utilizar a máxima verossimilhança (likelihood) é às vezes ruim para você, particularmente em espaços de alta dimensão ou espaços combinatórios onde seu modelo probabilístico está muito errado. Não é muito errado em distribuições discretas (é  ok), mas em casos contínuos, pode ser realmente errado. E todos os modelos estão errados.
