---
lang: pt
lang-ref: ch.06-3
title: Propriedades dos Sinais Naturais
lecturer: Alfredo Canziani
authors: Zhengyuan Ding, Biao Huang, Lin Jiang, Nhung Le
date: 3 Mar 2020
translator: Bernardo Lago
translation-date: 14 Nov 2021
---


<!--
## [Overview](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)
-->

## [Visão geral](https://www.youtube.com/watch?v=8cAffg2jaT0&t=21s)

<!--RNN is one type of architecture that we can use to deal with sequences of data. What is a sequence? From the CNN lesson, we learned that a signal can be either 1D, 2D or 3D depending on the domain. The domain is defined by what you are mapping from and what you are mapping to. Handling sequential data is basically dealing with 1D data since the domain is the temporal axis. Nevertheless, you can also use RNN to deal with 2D data, where you have two directions.
-->

RNN é um tipo de arquitetura que podemos usar para lidar com sequências de dados. O que é uma sequência? Com a lição da CNN, aprendemos que um sinal pode ser 1D, 2D ou 3D, dependendo do domínio. O domínio é definido pelo que você está mapeando e para o que está mapeando. Manipular dados sequenciais é basicamente lidar com dados 1D, uma vez que o domínio é o eixo temporal. No entanto, você também pode usar RNN para lidar com dados 2D, onde você tem duas direções.

<!--
### Vanilla *vs.* Recurrent NN
-->

### Rede Neural "Comum" *vs.* Redes Neurais Recorrentes

<!--Figure 1 is a vanilla neural network diagram with three layers. "Vanilla" is an American term meaning plain. The pink bubble is the input vector x, in the center is the hidden layer in green, and the final blue layer is the output. Using an example from digital electronics on the right, this is like a combinational logic, where the current output only depends on the current input.
-->

A Figura 1 é um diagrama de rede neural comum (vanilla) com três camadas. "Vanilla" é um termo americano que significa simples, comum. O círculo cor-de-rosa é o vetor de entrada x, no centro está a camada oculta em verde e a camada azul final é a saída. Usando um exemplo da eletrônica digital à direita, isso é como uma lógica combinatória, onde a saída de corrente depende apenas da entrada de corrente.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Vanilla Architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vanilla.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 1: </b> Arquitetura "Vanilla"
</center>

<!--In contrast to a vanilla neural network, in recurrent neural networks the current output depends not only on the current input but also on the state of the system, shown in Figure 2. This is like a sequential logic in digital electronics, where the output also depends on a "flip-flop" (a basic memory unit in digital electronics). Therefore the main difference here is that the output of a vanilla neural network only depends on the current input, while the one of RNN depends also on the state of the system.
-->

Em contraste com uma rede neural comum, em redes neurais recorrentes (RNN) a saída atual depende não apenas da entrada atual, mas também do estado do sistema, mostrado na Figura 2. Isso é como uma lógica sequencial na eletrônica digital, onde a saída também depende de um "flip-flop" (uma unidade de memória básica em eletrônica digital). Portanto, a principal diferença aqui é que a saída de uma rede neural comum depende apenas da entrada atual, enquanto a de RNN depende também do estado do sistema.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> RNN Architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 2: </b> Arquitetura RNN
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Basic NN Architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/basic_neural_net.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 3: </b> Arquitetura de uma Rede Neural básica
</center>

<!--Yann's diagram adds these shapes between neurons to represent the mapping between one tensor and another(one vector to another). For example, in Figure 3, the input vector x will map through this additional item to the hidden representations h. This item is actually an affine transformation *i.e.* rotation plus distortion. Then through another transformation, we get from the hidden layer to the final output. Similarly, in the RNN diagram, you can have the same additional items between neurons.
-->

O diagrama de Yann adiciona essas formas entre os neurônios para representar o mapeamento entre um tensor e outro (um vetor para outro). Por exemplo, na Figura 3, o vetor de entrada x será mapeado por meio desse item adicional para as representações ocultas h. Este item é na verdade uma transformação afim, ou seja, rotação mais distorção. Em seguida, por meio de outra transformação, passamos da camada oculta para a saída final. Da mesma forma, no diagrama RNN, você pode ter os mesmos itens adicionais entre os neurônios.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Yann's RNN Architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/yann_rnn.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 4: </b> Arquitetura RNN de Yann
</center>

<!--
### Four types of RNN Architectures and Examples
-->

### Quatro tipos de arquiteturas RNN e exemplos

<!--The first case is vector to sequence. The input is one bubble and then there will be evolutions of the internal state of the system annotated as these green bubbles. As the state of the system evolves, at every time step there will be one specific output.
-->

O primeiro caso é vetor para sequência. A entrada é uma bolha e então haverá evoluções do estado interno do sistema anotadas como essas bolhas verdes. Conforme o estado do sistema evolui, em cada etapa de tempo haverá uma saída específica.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Vec to Seq
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/vec_seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 5: </b> Vec para Seq
</center>

<!--An example of this type of architecture is to have the input as one image while the output will be a sequence of words representing the English descriptions of the input image. To explain using Figure 6, each blue bubble here can be an index in a dictionary of English words. For instance, if the output is the sentence "This is a yellow school bus". You first get the index of the word "This" and then get the index of the word "is" and so on. Some of the results of this network are shown below. For example, in the first column the description regarding the last picture is "A herd of elephants walking across a dry grass field.", which is very well refined. Then in the second column, the first image outputs "Two dogs play in the grass.", while it's actually three dogs. In the last column are the more wrong examples such as "A yellow school bus parked in a parking lot." In general, these results show that this network can fail quite drastically and perform well sometimes. This is the case that is from one input vector, which is the representation of an image, to a sequence of symbols, which are for example characters or words making up the English sentences. This kind of architecture is called an autoregressive network. An autoregressive network is a network which gives an output given that you feed as input the previous output.
-->

Um exemplo desse tipo de arquitetura é ter a entrada como uma imagem, enquanto a saída será uma sequência de palavras representando as descrições em inglês da imagem de entrada. Para explicar usando a Figura 6, cada bolha azul aqui pode ser um índice em um dicionário de palavras em inglês. Por exemplo, se o resultado for a frase "Este é um ônibus escolar amarelo". Primeiro, você obtém o índice da palavra "Isto" e, em seguida, obtém o índice da palavra "é" e assim por diante. Alguns dos resultados desta rede são mostrados a seguir. Por exemplo, na primeira coluna a descrição da última imagem é "Uma manada de elefantes caminhando por um campo de grama seca.", Que é muito bem refinada. Então, na segunda coluna, a primeira imagem mostra "Dois cachorros brincando na grama.", Enquanto na verdade são três cachorros. Na última coluna estão os exemplos mais errados, como "Um ônibus escolar amarelo estacionado em um estacionamento". Em geral, esses resultados mostram que essa rede pode falhar drasticamente e funcionar bem às vezes. É o caso de um vetor de entrada, que é a representação de uma imagem, para uma sequência de símbolos, que são, por exemplo, caracteres ou palavras que constituem as frases em inglês. Este tipo de arquitetura é denominado rede autoregressiva. Uma rede autoregressiva é uma rede que fornece uma saída, dado que você alimenta como entrada a saída anterior.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> vec2seq Example: Image to Text
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/image_to_text_vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 6: </b> vec2seq Exemplo: Imagem para Texto
</center>

<!--The second type is sequence to a final vector. This network keeps feeding a sequence of symbols and only at the end gives a final output. An application of this can be using the network to interpret Python. For example, the input are these lines of Python program.
-->

O segundo tipo é a sequência para um vetor final. Essa rede continua alimentando uma sequência de símbolos e somente no final dá uma saída final. Uma aplicação disso pode ser usar a rede para interpretar Python. Por exemplo, a entrada são essas linhas do programa Python.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 7:</b> Seq to Vec
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 7: </b> Seq para Vec
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 8:</b> Input lines of Python Codes
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 8: </b> Linhas de entrada de códigos Python
</center>

<!--Then the network will be able to output the correct solution of this program. Another more complicated program like this:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 9:</b> Input lines of Python Codes in a more Completed Case
</center>
-->

Então, a rede será capaz de produzir a solução correta deste programa. Outro programa mais complicado como este:
<center>
<img src="{{site.baseurl}}/images/week06/06-3/second_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 9: </b> Linhas de entrada de códigos Python em um caso mais completo
</center>

<!--Then the output should be 12184. These two examples display that you can train a neural network to do this kind of operation. We just need to feed a sequence of symbols and enforce the final output to be a specific value.
-->

Então, a saída deve ser 12184. Esses dois exemplos mostram que você pode treinar uma rede neural para fazer esse tipo de operação. Precisamos apenas alimentar uma sequência de símbolos e fazer com que a saída final seja um valor específico.

<!--The third is sequence to vector to sequence, shown in Figure 10. This architecture used to be the standard way of performing language translation. You start with a sequence of symbols here shown in pink. Then everything gets condensed into this final h, which represents a concept. For instance, we can have a sentence as input and squeeze it temporarily into a vector, which is representing the meaning and message that to send across. Then after getting this meaning in whatever representation, the network unrolls it back into a different language. For example "Today I'm very happy" in a sequence of words in English can be translated into Italian or Chinese. In general, the network gets some kind of encoding as inputs and turns them into a compressed representation. Finally, it performs the decoding given the same compressed version. In recent times we have seen networks like Transformers, which we will cover in the next lesson, outperform this method at language translation tasks. This type of architecture used to be the state of the art about two years ago (2018).
-->

O terceiro é seqüência para vetor para seqüência, mostrado na Figura 10. Essa arquitetura costumava ser a forma padrão de realizar a tradução de idiomas. Você começa com uma sequência de símbolos mostrados aqui em rosa. Então, tudo se condensa neste h final, que representa um conceito. Por exemplo, podemos ter uma frase como entrada e comprimi-la temporariamente em um vetor, que representa o significado e a mensagem a ser enviada. Então, depois de obter esse significado em qualquer representação, a rede o desenrola de volta para uma linguagem diferente. Por exemplo, "Hoje estou muito feliz" em uma sequência de palavras em inglês pode ser traduzido para o italiano ou chinês. Em geral, a rede obtém algum tipo de codificação como entradas e as transforma em uma representação compactada. Finalmente, ele realiza a decodificação dada a mesma versão compactada. Recentemente, vimos redes como Transformers, que abordaremos na próxima lição, superar esse método em tarefas de tradução de idiomas. Este tipo de arquitetura era o estado da arte há cerca de dois anos (2018).

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 10:</b> Seq to Vec to Seq
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2vec2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 10: </b> Seq para Vec para Seq
</center>

<!--If you do a PCA over the latent space, you will have the words grouped by semantics like shown in this graph.
-->

Se você fizer um PCA sobre o espaço latente, terá as palavras agrupadas por semântica como mostrado neste gráfico.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 11:</b> Words Grouped by Semantics after PCA
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 11: </b> Palavras agrupadas por semântica após PCA
</center>

<!--If we zoom in, we will see that the in the same location there are all the months, like January and November.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 12:</b> Zooming in Word Groups
</center>
-->

Se aumentarmos o zoom, veremos que no mesmo local estão todos os meses, como janeiro e novembro.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 12: </b> Ampliação de grupos de palavras
</center>

<!--If you focus on a different region, you get phrases like "a few days ago " "the next few months" etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 13:</b> Word Groups in another Region
</center>
-->

Se você focar em uma região diferente, obterá frases como "alguns dias atrás" "nos próximos meses" etc.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/third_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 13: </b> Grupos de palavras em outra região
</center>

<!--From these examples, we see that different locations will have some specific common meanings.
-->

A partir desses exemplos, vemos que diferentes locais terão alguns significados comuns específicos.

<!--Figure 14 showcases how how by training this kind of network will pick up on some semantics features. For exmaple in this case you can see there is a vector connecting man to woman and another between king and queen, which means woman minus man is going to be equal to queen minus king. You will get the same distance in this embeddings space applied to cases like male-female. Another example will be walking to walked and swimming to swam. You can always apply this kind of specific linear transofmation going from one word to another or from country to capital.
-->

A Figura 14 mostra como, com o treinamento, esse tipo de rede irá captar alguns recursos semânticos. Por exemplo, neste caso, você pode ver que há um vetor conectando homem a mulher e outro entre rei e rainha, o que significa que mulher menos homem será igual a rainha menos rei. Você obterá a mesma distância neste espaço de embeddings aplicado a casos como masculino-feminino. Outro exemplo será caminhar para caminhar e nadar para nadar. Você sempre pode aplicar esse tipo de transformação linear específica, indo de uma palavra para outra ou de um país para a capital.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 14:</b> Semantics Features Picked during Training
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/fourth.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 14: </b> recursos semânticos escolhidos durante o treinamento
</center>

<!--The fourth and final case is sequence to sequence. In this network, as you start feeding in input the network starts generating outputs. An example of this type of architecture is T9, if you remember using a Nokia phone, you would get text suggestions as you were typing. Another example is speech to captions. One cool example is this RNN-writer. When you start typing "the rings of Saturn glittered while", it suggests the following "two men looked at each other". This network was trained on some sci-fi novels so that you can just type something and let it make suggestions to help you write a book. One more example is shown in Figure 16. You input the top prompt and then this network will try to complete the rest.
-->

O quarto e último caso é seqüência a seqüência. Nessa rede, conforme você começa a alimentar a entrada, a rede começa a gerar saídas. Um exemplo desse tipo de arquitetura é o T9. Se você se lembra de usar um telefone Nokia, receberá sugestões de texto enquanto digita. Outro exemplo é a fala com legendas. Um exemplo legal é este escritor RNN. Quando você começa a digitar "os anéis de Saturno brilharam enquanto", isso sugere o seguinte "dois homens se entreolharam". Esta rede foi treinada em alguns romances de ficção científica para que você simplesmente digite algo e deixe que ela faça sugestões para ajudá-lo a escrever um livro. Mais um exemplo é mostrado na Figura 16. Você insere o prompt superior e, em seguida, esta rede tentará completar o resto.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 15:</b> Seq to Seq
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 15: </b> Seq a Seq
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 16:</b> Text Auto-Completion Model of Seq to Seq Model
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/seq2seq_model_completion.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 16: </b> Modelo de preenchimento automático de texto do modelo Seq para Seq
</center>

<!--
## [Back Propagation through time](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)
-->

## [Retropropagação no tempo](https://www.youtube.com/watch?v=8cAffg2jaT0&t=855s)

<!--
### Model architecture
-->

### Arquitetura do modelo

<!--In order to train an RNN, backpropagation through time (BPTT) must be used. The model architecture of RNN is given in the figure below. The left design uses loop representation while the right figure unfolds the loop into a row over time.
-->

Para treinar um RNN, a retropropagação através do tempo (BPTT) deve ser usada. A arquitetura do modelo do RNN é fornecida na figura abaixo. O design da esquerda usa a representação do loop, enquanto a figura da direita desdobra o loop em uma linha ao longo do tempo.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 17:</b> Back Propagation through time
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/bptt.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 17: </b> Retropropagação ao longo do tempo
</center>

<!--Hidden representations are stated as
-->

As representações ocultas são indicadas como

<!--$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$
-->

$$
\begin{aligned}
\begin{cases}
h[t]&= g(W_{h}\begin{bmatrix}
x[t] \\
h[t-1]
\end{bmatrix}
+b_h)  \\
h[0]&\dot=\ \boldsymbol{0},\ W_h\dot=\left[ W_{hx} W_{hh}\right] \\
\hat{y}[t]&= g(W_yh[t]+b_y)
\end{cases}
\end{aligned}
$$

<!--The first equation indicates a non-linear function applied on a rotation of a stack version of input where the previous configuration of the hidden layer is appended. At the beginning, $h[0]$ is set 0. To simplify the equation, $W_h$ can be written as two separate matrices, $\left[ W_{hx}\ W_{hh}\right]$, thus sometimes the transformation can be stated as
-->

A primeira equação indica uma função não linear aplicada em uma rotação de uma versão da pilha de entrada onde a configuração anterior da camada oculta é anexada. No início, $ h [0] $ é definido como 0. Para simplificar a equação, $ W_h $ pode ser escrito como duas matrizes separadas, $ \ left [W_ {hx} \ W_ {hh} \ right] $, portanto, às vezes a transformação pode ser declarada como

<!--$$
W_{hx}\cdot x[t]+W_{hh}\cdot h[t-1]
$$
-->

$$
W_ {hx} \ cdot x [t] + W_ {hh} \ cdot h [t-1]
$$

<!--which corresponds to the stack representation of the input.
-->

que corresponde à representação da pilha da entrada.

<!--$y[t]$ is calculated at the final rotation and then we can use the chain rule to backpropagate the error to the previous time step.
-->

$ y [t] $ é calculado na rotação final e então podemos usar a regra da cadeia para retropropagar o erro para a etapa de tempo anterior.

<!--
### Batch-Ification in Language Modeling
-->

### "Loteamento" na Modelagem de Linguagem

<!--When dealing with a sequence of symbols, we can batchify the text into different sizes. For example, when dealing with sequences shown in the following figure, batch-ification can be applied first, where the time domain is preserved vertically. In this case, the batch size is set to 4.
-->

Ao lidar com uma sequência de símbolos, podemos agrupar o texto em diferentes tamanhos. Por exemplo, ao lidar com as sequências mostradas na figura a seguir, a ificação em lote pode ser aplicada primeiro, onde o domínio do tempo é preservado verticalmente. Nesse caso, o tamanho do lote é definido como 4.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 18:</b> Batch-Ification
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_1.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 18: </b> "Loteamento" (Batch-Ification)
</center>

<!--If BPTT period $T$ is set to 3, the first input $x[1:T]$ and output $y[1:T]$ for RNN is determined as
-->

Se o período $T$ da retropropagação baseada no tempo (BPTT) for definido como 3, a primeira entrada $x[1:T]$ e a saída $y[1:T]$ para RNN é determinada como

<!--$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$
-->

$$
\begin{aligned}
x[1:T] &= \begin{bmatrix}
a & g & m & s \\
b & h & n & t \\
c & i & o & u \\
\end{bmatrix} \\
y[1:T] &= \begin{bmatrix}
b & h & n & t \\
c & i & o & u \\
d & j & p & v
\end{bmatrix}
\end{aligned}
$$

<!--When performing RNN on the first batch, firstly, we feed $x[1] = [a\ g\ m\ s]$ into RNN and force the output to be $y[1] = [b\ h\ n\ t]$. The hidden representation $h[1]$ will be sent forward into next time step to help the RNN predict $y[2]$ from $x[2]$. After sending $h[T-1]$ to the final set of $x[T]$ and $y[T]$, we cut gradient propagation process for both $h[T]$ and $h[0]$ so that gradients will not propagate infinitely(.detach() in Pytorch). The whole process is shown in figure below.
-->

Ao realizar RNN no primeiro lote, em primeiro lugar, alimentamos $x[1] = [a\ g\ m\ s]$ em RNN e forçamos a saída a ser  $y[1] = [b\ h\ n\ t]$. A representação oculta $h[1]$ será enviada para a próxima etapa de tempo para ajudar o RNN a prever $y[2]$ a partir de $x[2]$. Depois de enviar $h[T-1]$ para o conjunto final de $x[T]$ e $y[T]$, cortamos o processo de propagação de gradiente para $h[T]$ e $h[0]$ então que os gradientes não se propagam infinitamente (.detach () no Pytorch). Todo o processo é mostrado na figura abaixo.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 19:</b> Batch-Ification
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/batchify_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 19: </b> "Loteamento" (Batch-Ification)
</center>

<!--
## Vanishing and Exploding Gradient
-->

## Dissipação e Explosão de Gradiente 

<!--
### Problem
-->

### Problema

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 20:</b> Vanishing Problem
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 20: </b> Problema de dissipação
</center>

<!--The figure above is a typical RNN architecture. In order to perform rotation over previous steps in RNN, we use matrices, which can be regarded as horizontal arrows in the model above. Since the matrices can change the size of outputs, if the determinant we select is larger than 1, the gradient will inflate over time and cause gradient explosion. Relatively speaking, if the eigenvalue we select is small across 0, the propagation process will shrink gradients and leads to the gradient vanishing.
-->

A figura acima é uma arquitetura RNN típica. Para realizar a rotação pelas etapas anteriores no RNN, usamos matrizes, que podem ser consideradas como setas horizontais no modelo acima. Uma vez que as matrizes podem alterar o tamanho das saídas, se o determinante que selecionamos for maior que 1, o gradiente se inflará com o tempo e causará a explosão do gradiente. Relativamente falando, se o autovalor que selecionamos for pequeno em 0, o processo de propagação reduzirá os gradientes e levará ao desaparecimento do gradiente (problema da dissipação de gradiente).

<!--In typical RNNs, gradients will be propagated through all the possible arrows, which provides the gradients a large chance to vanish or explode. For example, the gradient at time 1 is large, which is indicated by the bright color. When it goes through one rotation, the gradient shrinks a lot and at time 3, it gets killed.
-->

Em RNNs típicos, os gradientes serão propagados por todas as setas possíveis, o que fornece aos gradientes uma grande chance de desaparecer ou explodir. Por exemplo, o gradiente no tempo 1 é grande, o que é indicado pela cor brilhante. Quando ele passa por uma rotação, o gradiente encolhe muito e no tempo 3, ele morre.

<!--
### Solution
-->

### Solução

<!--An ideal to prevent gradients from exploding or vanishing is to skip connections. To fulfill this, multiply networks can be used.
-->

Um ideal para evitar que gradientes explodam ou desapareçam é pular conexões. Para cumprir isso, multiplique as redes podem ser usadas.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 21:</b> Skip Connection
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/rnn_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 21: </b> Pular conexão
</center>

<!--In the case above, we split the original network into 4 networks. Take the first network for instance. It takes in a value from input at time 1 and sends the output to the first intermediate state in the hidden layer. The state has 3 other networks where the $\circ$s allows the gradients to pass while the $-$s blocks propagation. Such a technique is called gated recurrent network.
-->

No caso acima, dividimos a rede original em 4 redes. Pegue a primeira rede, por exemplo. Ele obtém um valor da entrada no tempo 1 e envia a saída para o primeiro estado intermediário na camada oculta. O estado tem 3 outras redes onde $ \ circ $ s permite que os gradientes passem enquanto $ - $ s bloqueia a propagação. Essa técnica é chamada de rede recorrente com portas.

<!--LSTM is one prevalent gated RNN and is introduced in detail in the following sections.
-->

O LSTM é um RNN fechado predominante e é apresentado em detalhes nas seções a seguir.

<!--
## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)
-->

## [Long Short-Term Memory](https://www.youtube.com/watch?v=8cAffg2jaT0&t=1838s)

<!--
### Model Architecture
-->

### Arquitetura do Modelo

<!--Below are equations expressing an LSTM. The input gate is highlighted by yellow boxes, which will be an affine transformation. This input transformation will be multiplying $c[t]$, which is our candidate gate.
-->

Abaixo estão as equações que expressam um LSTM. A porta de entrada é destacada por caixas amarelas, que será uma transformação afim. Essa transformação de entrada multiplicará $ c [t] $, que é nossa porta candidata.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 22:</b> LSTM Architecture
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 22: </b> Arquitetura LSTM
</center>

<!--Don’t forget gate is multiplying the previous value of cell memory $c[t-1]$. Total cell value $c[t]$ is don’t forget gate plus input gate. Final hidden representation is element-wise multiplication between output gate $o[t]$ and hyperbolic tangent version of the cell $c[t]$, such that things are bounded. Finally, candidate gate $\tilde{c}[t]$ is simply a recurrent net. So we have a $o[t]$ to modulate the output, a $f[t]$ to modulate the don’t forget gate, and a $i[t]$ to modulate the input gate. All these interactions between memory and gates are multiplicative interactions. $i[t]$, $f[t]$ and $o[t]$ are all sigmoids, going from zero to one. Hence, when multiplying by zero, you have a closed gate. When multiplying by one, you have an open gate.
-->

Não se esqueça de que o gate está multiplicando o valor anterior da memória da célula $ c [t-1] $. O valor total da célula $ c [t] $ é não se esqueça da porta mais a porta de entrada. A representação oculta final é a multiplicação elemento a elemento entre a porta de saída $ o [t] $ e a versão tangente hiperbólica da célula $ c [t] $, de forma que as coisas sejam limitadas. Finalmente, a porta candidata $ \ tilde {c} [t] $ é simplesmente uma rede recorrente. Portanto, temos $ o [t] $ para modular a saída, $ f [t] $ para modular a porta não se esqueça e $ i [t] $ para modular a porta de entrada. Todas essas interações entre memória e portas são interações multiplicativas. $ i [t] $, $ f [t] $ e $ o [t] $ são todos sigmóides, indo de zero a um. Portanto, ao multiplicar por zero, você tem uma porta fechada. Ao multiplicar por um, você tem um portão aberto.

<!--How do we turn off the output? Let’s say we have a purple internal representation $th$ and put a zero in the output gate. Then the output will be zero multiplied by something, and we get a zero. If we put a one in the output gate, we will get the same value as the purple representation.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 23:</b> LSTM Architecture - Output On
</center>
-->

Como desligamos a saída? Digamos que temos uma representação interna roxa $ th $ e colocamos um zero na porta de saída. Então, a saída será zero multiplicado por alguma coisa, e obteremos um zero. Se colocarmos um na porta de saída, obteremos o mesmo valor da representação roxa.
<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_2.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 23: </b> Arquitetura LSTM - Saída Ligada
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 24:</b> LSTM Architecture - Output Off
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_3.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 24: </b> Arquitetura LSTM - Saída Desligada
</center>

<!--Similarly, we can control the memory. For example, we can reset it by having $f[t]$ and $i[t]$ to be zeros. After multiplication and summation, we have a zero inside the memory. Otherwise, we can keep the memory, by still zeroing out the internal representation $th$ but keep a one in $f[t]$. Hence, the sum gets $c[t-1]$ and keeps sending it out. Finally, we can write such that we can get a one in the input gate, the multiplication gets purple, then set a zero in the don’t forget gate so it actually forget.
-->

Da mesma forma, podemos controlar a memória. Por exemplo, podemos redefini-lo fazendo com que $ f [t] $ e $ i [t] $ sejam zeros. Após a multiplicação e somatório, temos um zero na memória. Caso contrário, podemos manter a memória, ainda zerando a representação interna $ th $, mas mantendo um em $ f [t] $. Portanto, a soma obtém $ c [t-1] $ e continua sendo enviada. Finalmente, podemos escrever de forma que possamos obter um no portão de entrada, a multiplicação fica roxa e, em seguida, definir um zero no portão não se esqueça para que realmente esqueça.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 25:</b> Visualization of the Memory Cell
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/memory_cell_vis.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 25: </b> Visualização da célula de memória
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 26:</b> LSTM Architecture - Reset Memory
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_4.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 26: </b> Arquitetura LSTM - Redefinir memória
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 27:</b> LSTM Architecture - Keep Memory
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_keep_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 27: </b> Arquitetura LSTM - Manter memória
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 28:</b> LSTM Architecture - Write Memory
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/lstm_write_memory.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 28: </b> Arquitetura LSTM - Memória de Gravação
</center>

<!--
## Notebook Examples
-->

## Exemplos de Notebook

<!--
### Sequence Classification
-->

### Classificação de sequências (sequences)

<!--The goal is to classify sequences. Elements and targets are represented locally (input vectors with only one non-zero bit). The sequence **b**egins with an `B`, **e**nds with a `E` (the “trigger symbol”), and otherwise consists of randomly chosen symbols from the set `{a, b, c, d}` except for two elements at positions $t_1$ and $t_2$ that are either `X` or `Y`. For the `DifficultyLevel.HARD` case, the sequence length is randomly chosen between 100 and 110, $t_1$ is randomly chosen between 10 and 20, and $t_2$ is randomly chosen between 50 and 60. There are 4 sequence classes `Q`, `R`, `S`, and `U`, which depend on the temporal order of `X` and `Y`. The rules are: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.
-->

O objetivo é classificar as sequências. Elementos e destinos são representados localmente (vetores de entrada com apenas um bit diferente de zero). A sequência ** b ** egins com um `B`, ** e ** nds com um` E` (o “símbolo de gatilho”), e de outra forma consiste em símbolos escolhidos aleatoriamente do conjunto `{a, b, c , d} `exceto por dois elementos nas posições $ t_1 $ e $ t_2 $ que são` X` ou `Y`. Para o caso `DifficultyLevel.HARD`, o comprimento da sequência é escolhido aleatoriamente entre 100 e 110, $ t_1 $ é escolhido aleatoriamente entre 10 e 20, e $ t_2 $ é escolhido aleatoriamente entre 50 e 60. Existem 4 classes de sequência` Q `,` R`, `S` e` U`, que dependem da ordem temporal de `X` e` Y`. As regras são: `X, X -> Q`; `X, Y -> R`; `Y, X -> S`; `Y, Y -> U`.

<!--1). Dataset Exploration
-->

1). Exploração de conjunto de dados

<!--The return type from a data generator is a tuple with length 2. The first item in the tuple is the batch of sequences with shape $(32, 9, 8)$. This is the data going to be fed into the network. There are eight different symbols in each row (`X`, `Y`, `a`, `b`, `c`, `d`, `B`, `E`). Each row is a one-hot vector. A sequence of rows represents a sequence of symbols. The first all-zero row is padding. We use padding when the length of the sequence is shorter than the maximum length in the batch.  The second item in the tuple is the corresponding batch of class labels with shape $(32, 4)$, since we have 4 classes (`Q`, `R`, `S`, and `U`). The first sequence is: `BbXcXcbE`. Then its decoded class label is $[1, 0, 0, 0]$, corresponding to `Q`.
-->

O tipo de retorno de um gerador de dados é uma tupla com comprimento 2. O primeiro item na tupla é o lote de sequências com forma $ (32, 9, 8) $. Esses são os dados que serão alimentados na rede. Existem oito símbolos diferentes em cada linha (`X`,` Y`, `a`,` b`, `c`,` d`, `B`,` E`). Cada linha é um vetor único. Uma sequência de linhas representa uma sequência de símbolos. A primeira linha totalmente zero é o preenchimento. Usamos preenchimento quando o comprimento da sequência é menor que o comprimento máximo do lote. O segundo item na tupla é o lote correspondente de rótulos de classe com forma $ (32, 4) $, uma vez que temos 4 classes (`Q`,` R`, `S` e` U`). A primeira sequência é: `BbXcXcbE`. Então, seu rótulo de classe decodificado é $ [1, 0, 0, 0] $, correspondendo a `Q`.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b>Figure 29:</b> Input Vector Example
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/dataset.png" style="zoom: 15%; background-color:#DCDCDC;"/><br>
<b> Figura 29: </b> Exemplo de vetor de entrada
</center>

<!--
2). Defining the Model and Training
-->

2). Definição do modelo e treinamento

<!--Let’s create a simple recurrent network, an LSTM, and train for 10 epochs. In the training loop, we should always look for five steps:
-->

Vamos criar uma rede recorrente simples, um LSTM, e treinar por 10 períodos. No ciclo de treinamento, devemos sempre procurar cinco etapas:

<!-- * Perform the forward pass of the model
 * Compute the loss
 * Zero the gradient cache
 * Backpropagate to compute the partial derivative of loss with regard to parameters
 * Step in the opposite direction of the gradient
-->

* Execute o passe para frente do modelo
 * Calcule a perda
 * Zere o cache de gradiente
 * Backpropagate para calcular a derivada parcial de perda em relação aos parâmetros
 * Pise na direção oposta do gradiente

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 30:</b> Simple RNN *vs.* LSTM - 10 Epochs
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_easy.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 30: </b> RNN Simples *vs.* LSTM - 10 épocas
</center>

<!--With an easy level of difficulty, RNN gets 50% accuracy while LSTM gets 100% after 10 epochs. But LSTM has four times more weights than RNN and has two hidden layers, so it is not a fair comparison. After 100 epochs, RNN also gets 100% accuracy, taking longer to train than the LSTM.
-->

Com um nível de dificuldade fácil, RNN obtém 50% de precisão enquanto LSTM obtém 100% após 10 épocas. Mas LSTM tem quatro vezes mais pesos do que RNN e tem duas camadas ocultas, portanto, não é uma comparação justa. Após 100 épocas, o RNN também obtém 100% de precisão, levando mais tempo para treinar do que o LSTM.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 31:</b> Simple RNN *vs.* LSTM - 100 Epochs
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/train_test_hard.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 31:</b> RNN Simples *vs.* LSTM - 100 Épocas
</center>

<!--If we increase the difficulty of the training part (using longer sequences), we will see the RNN fails while LSTM continues to work.
-->

Se aumentarmos a dificuldade da parte de treinamento (usando sequências mais longas), veremos o RNN falhar enquanto o LSTM continua a funcionar.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 32:</b> Visualization of Hidden State Value
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-3/hidden_state_lstm.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 32:</b> Visualização do valor do estado oculto
</center>

<!--The above visualization is drawing the value of hidden state over time in LSTM. We will send the inputs through a hyperbolic tangent, such that if the input is below $-2.5$, it will be mapped to $-1$, and if it is above $2.5$, it will be mapped to $1$. So in this case, we can see the specific hidden layer picked on `X` (fifth row in the picture) and then it became red until we got the other `X`. So, the fifth hidden unit of the cell is triggered by observing the `X` and goes quiet after seeing the other `X`. This allows us to recognize the class of sequence.
-->

A visualização acima está desenhando o valor do estado oculto ao longo do tempo no LSTM. Enviaremos as entradas por meio de uma tangente hiperbólica, de forma que se a entrada estiver abaixo de $-2.5$, ela será mapeada para $-1$, e se estiver acima de $2,5$, será mapeada para $1$. Portanto, neste caso, podemos ver a camada oculta específica escolhida em `X` (quinta linha na imagem) e então ela se tornou vermelha até que obtivemos o outro` X`. Assim, a quinta unidade oculta da célula é acionada observando o `X` e fica quieta após ver o outro` X`. Isso nos permite reconhecer a classe de sequência.

<!--
### Signal Echoing
-->

### Eco de sinal

<!--Echoing signal n steps is an example of synchronized many-to-many task. For instance, the 1st input sequence is `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, and the 1st target sequence is `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. In this case, the output is three steps after. So we need a short-time working memory to keep the information. Whereas in the language model, it says something that hasn't already been said.
-->

Ecoar o sinal n etapas é um exemplo de tarefa muitos-para-muitos sincronizada. Por exemplo, a 1ª sequência de entrada é `"1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 1 1 1 ..."`, e a 1ª sequência de destino é `"0 0 0 1 1 0 0 1 0 1 1 0 0 0 0 0 0 0 0 1 ..."`. Nesse caso, a saída ocorre três etapas depois. Portanto, precisamos de uma memória de trabalho de curta duração para manter as informações. Já no modelo de linguagem, diz algo que ainda não foi dito.

<!--Before we send the whole sequence to the network and force the final target to be something, we need to cut the long sequence into little chunks. While feeding a new chunk, we need to keep track of the hidden state and send it as input to the internal state when adding the next new chunk. In LSTM, you can keep the memory for a long time as long as you have enough capacity. In RNN, after you reach a certain length, it starts to forget about what happened in the past.
-->

Antes de enviarmos toda a sequência para a rede e forçarmos o destino final a ser algo, precisamos cortar a sequência longa em pequenos pedaços. Ao alimentar um novo pedaço, precisamos acompanhar o estado oculto e enviá-lo como entrada para o estado interno ao adicionar o próximo novo pedaço. No LSTM, você pode manter a memória por muito tempo, desde que tenha capacidade suficiente. No RNN, depois de atingir um determinado comprimento, começa a esquecer o que aconteceu no passado.

