---
lang: pt
lang-ref: ch.06-2
lecturer: Yann LeCun
title: RNNs, GRUs, LSTMs, Modelos de Atenção, Seq2Seq e Redes com Memória
authors: Jiayao Liu, Jialing Xu, Zhengyang Bian, Christina Dominguez
date: 2 March 2020
translator: Bernardo Lago
translation-date: 14 Nov 2021
---

<!--
## [Deep Learning Architectures](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)
-->

## [Arquitetura de Aprendizagem Profunda](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=2620s)

<!--In deep learning, there are different modules to realize different functions. Expertise in deep learning involves designing architectures to complete particular tasks.  Similar to writing programs with algorithms to give instructions to a computer in earlier days, deep learning reduces a complex function into a graph of functional modules (possibly dynamic), the functions of which are finalized by learning.
-->

Na aprendizagem profunda, existem diferentes módulos para realizar diferentes funções. A especialização em aprendizagem profunda envolve o projeto de arquiteturas para concluir tarefas específicas. Semelhante a escrever programas com algoritmos para dar instruções a um computador nos dias anteriores, o aprendizado profundo reduz uma função complexa em um gráfico de módulos funcionais (possivelmente dinâmicos), cujas funções são finalizadas pelo aprendizado.

<!--As with what we saw with convolutional networks, network architecture is important.
-->

Como com o que vimos com redes convolucionais, a arquitetura de rede é importante.

<!--
## Recurrent Networks
-->

## Redes Neurais Recorrentes

<!--In a Convolutional Neural Network, the graph or interconnections between the modules cannot have loops. There exists at least a partial order among the modules such that the inputs are available when we compute the outputs.
-->

Em uma Rede Neural Convolucional, o gráfico ou as interconexões entre os módulos não podem ter laços. Existe pelo menos uma ordem parcial entre os módulos, de modo que as entradas estão disponíveis quando calculamos as saídas.

<!--As shown in Figure 1, there are loops in Recurrent Neural Networks.
-->

Conforme mostrado na Figura 1, existem loops nas Redes Neurais Recorrentes.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figure 1. Recurrent Neural Network with roll
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_rolled.png" /><br>
Figura 1. Rede Neural Recorrente com loops
</center>

<!-- - $x(t)$ : input that varies across time
 - $\text{Enc}(x(t))$: encoder that generates a representation of input
 - $h(t)$: a representation of the input
 - $w$: trainable parameters
 - $z(t-1)$: previous hidden state, which is the output of the previous time step
 - $z(t)$: current hidden state
 - $g$: function that can be a complicated neural network; one of the inputs is $z(t-1)$ which is the output of the previous time step
 - $\text{Dec}(z(t))$: decoder that generates an output
-->

- $x(t)$: entrada que varia ao longo do tempo
  - $\text{Enc}(x(t))$: codificador que gera uma representação de entrada
  - $h(t)$: uma representação da entrada
  - $w$: parâmetros treináveis
  - $z(t-1)$: estado oculto anterior, que é a saída da etapa de tempo anterior
  - $z(t)$: estado oculto atual
  - $g$: função que pode ser uma rede neural complicada; uma das entradas é $z(t-1)$ que é a saída da etapa de tempo anterior
  - $\text{Dec}(z(t))$: decodificador que gera uma saída

<!--
## Recurrent Networks: Unroll the loop
-->


## Redes Neurais Recorrentes: desenrolando os loops

<!--Unroll the loop in time. The input is a sequence $x_1, x_2, \cdots, x_T$.
-->

Desenrole o loop no tempo. A entrada é uma sequência $x_1, x_2, \cdots, x_T$.

<!--<center>
 "
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figure 2. Recurrent Networks with unrolled loop
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/RNN_unrolled.png" /><br>
Figura 2. Redes recorrentes com loop desenrolado
</center>

<!--In Figure 2, the input is $x_1, x_2, x_3$.
-->

Na Figura 2, a entrada é $x_1, x_2, x_3$.

<!--At time t=0, the input $x(0)$ is passed to the encoder and it generates the representation $h(x(0)) = \text{Enc}(x(0))$ and then passes it to G to generate hidden state $z(0) = G(h_0, z', w)$. At $t = 0$, $z'$ in $G$ can be initialized as $0$ or randomly initialized. $z(0)$ is passed to decoder to generate an output and also to the next time step.
-->

No tempo t = 0, a entrada  $x(0)$ é passada para o codificador e ele gera a representação $h(x(0)) = \text{Enc}(x(0))$ e então a passa para G para gerar o estado oculto $z(0) = G(h_0, z', w)$. Em $t = 0$, $z'$ em $G$ pode ser inicializado como $0$ ou inicializado aleatoriamente. $z(0)$ é passado para o decodificador para gerar uma saída e também para a próxima etapa de tempo.

<!--As there are no loops in this network, and we can implement backpropagation.
-->

Como não há loops nesta rede, podemos implementar a retropropagação.

<!--Figure 2 shows a regular network with one particular characteristic: every block shares the same weights. Three encoders, decoders and G functions have same weights respectively across different time steps.
-->

A Figura 2 mostra uma rede regular com uma característica particular: cada bloco compartilha os mesmos pesos. Três codificadores, decodificadores e funções G têm os mesmos pesos, respectivamente, em diferentes intervalos de tempo.

<!--BPTT: Backprop through time.  Unfortunately, BPTT doesn't work so well in the naive form of RNN.
-->

BPTT: Retropropagação através do tempo (Backpropagation through time). Infelizmente, o BPTT não funciona tão bem na forma mais simples de RNN.

<!--Problems with RNNs:
-->

Problemas com RNNs:

<!--1. Vanishing gradients
   - In a long sequence, the gradients get multiplied by the weight matrix (transpose) at every time step. If there are small values in the weight matrix, the norm of gradients get smaller and smaller exponentially.
2. Exploding gradients
   - If we have a large weight matrix and the non-linearity in the recurrent layer is not saturating, the gradients will explode. The weights will diverge at the update step. We may have to use a tiny learning rate for the gradient descent to work.
-->

1. Perda da informação do Gradiente (Dissipação do Gradiente)
    - Em uma longa sequência, os gradientes são multiplicados pela matriz de peso (transposição) a cada passo de tempo. Se houver valores pequenos na matriz de peso, a norma dos gradientes fica cada vez menor exponencialmente.
2. Explosão de gradientes
    - Se tivermos uma matriz de peso grande e a não linearidade na camada recorrente não for saturada, os gradientes explodirão. Os pesos irão divergir na etapa de atualização. Podemos ter que usar uma pequena taxa de aprendizado para que o gradiente descendente funcione.

<!--One reason to use RNNs is for the advantage of remembering information in the past. However, it could fail to memorize the information long ago in a simple RNN without tricks.
-->

Uma razão para usar RNNs é a vantagem de lembrar informações do passado. No entanto, ele pode falhar ao memorizar as informações há muito tempo em um RNN simples sem truques.

<!--An example that has vanishing gradient problem:
-->

Um exemplo que tem problema de perda da informação do gradiente:

<!--The input is the characters from a C Program. The system will tell whether it is a syntactically correct program. A syntactically correct program should have a valid number of braces and parentheses. Thus, the network should remember how many open parentheses and braces there are to check, and whether we have closed them all. The network has to store such information in hidden states like a counter.  However, because of vanishing gradients, it will fail to preserve such information in a long program.
-->

A entrada são os caracteres de um programa em C. O sistema dirá se é um programa sintaticamente correto. Um programa sintaticamente correto deve ter um número válido de chaves e parênteses. Portanto, a rede deve lembrar quantos parênteses e colchetes devem ser verificados e se todos eles foram fechados. A rede precisa armazenar essas informações em estados ocultos, como um contador. No entanto, devido ao desaparecimento de gradientes, ele deixará de preservar essas informações em um programa longo.

<!--
##  RNN Tricks
-->

##  Truques em RNN

<!--- clipping gradients:  (avoid exploding gradients)
   Squash the gradients when they get too large.
- Initialization (start in right ballpark avoids exploding/vanishing)
   Initialize the weight matrices to preserve the norm to some extent. For example, orthogonal initialization initializes the weight matrix as a random orthogonal matrix.
-->

- gradientes de recorte: (evite a explosão de gradientes)
    Esmague os gradientes quando eles ficarem muito grandes.
- Inicialização (começar no estádio certo evita explodir / desaparecer)
    Inicialize as matrizes de peso para preservar a norma até certo ponto. Por exemplo, a inicialização ortogonal inicializa a matriz de peso como uma matriz ortogonal aleatória.

<!--
## Multiplicative Modules
-->

## Módulos Multiplicativos

<!--In multiplicative modules rather than only computing a weighted sum of inputs, we compute products of inputs and then compute weighted sum of that.
-->

Em módulos multiplicativos, ao invés de apenas computar uma soma ponderada de entradas, calculamos produtos de entradas e, em seguida, calculamos a soma ponderada disso.

<!--Suppose $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ and $z \in {R}^{d\times1}$. Here U is a tensor.
-->

Suponha que $x \in {R}^{n\times1}$, $W \in {R}^{m \times n}$, $U \in {R}^{m \times n \times d}$ e $z \in {R}^{d\times1}$. Aqui U é um tensor.

<!--$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$
-->

$$
w_{ij} = u_{ij}^\top z =
\begin{pmatrix}
u_{ij1} & u_{ij2} & \cdots &u_{ijd}\\
\end{pmatrix}
\begin{pmatrix}
z_1\\
z_2\\
\vdots\\
z_d\\
\end{pmatrix} = \sum_ku_{ijk}z_k
$$

<!--$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$
-->

$$
s =
\begin{pmatrix}
s_1\\
s_2\\
\vdots\\
s_m\\
\end{pmatrix} = Wx =  \begin{pmatrix}
w_{11} & w_{12} & \cdots &w_{1n}\\
w_{21} & w_{22} & \cdots &w_{2n}\\
\vdots\\
w_{m1} & w_{m2} & \cdots &w_{mn}
\end{pmatrix}
\begin{pmatrix}
x_1\\
x_2\\
\vdots\\
x_n\\
\end{pmatrix}
$$

<!--where $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.
-->

onde $s_i = w_{i}^\top x = \sum_j w_{ij}x_j$.

<!--The output of the system is a classic weighted sum of inputs and weights. Weights themselves are also weighted sums of weights and inputs.
-->

A saída do sistema é uma soma ponderada clássica de entradas e pesos. Os próprios pesos também são somas ponderadas de pesos e entradas.

<!--Hypernetwork architecture: weights are computed by another network.
-->

Arquitetura de hiper-rede: os pesos são calculados por outra rede.

<!--
## Attention
-->


## Atenção (Attention)

<!--$x_1$ and $x_2$ are vectors, $w_1$ and $w_2$ are scalars after softmax where $w_1 + w_2 = 1$, and  $w_1$ and $w_2$ are between 0 and 1.
-->

$x_1$ e $x_2$ são vetores, $w_1$ e $w_2$ são escalares após softmax onde $w_1 + w_2 = 1$, e $w_1$ e $w_2$ estão entre 0 e 1.

<!--$w_1x_1 + w_2x_2$ is a weighted sum of $x_1$ and $x_2$ weighted by coefficients $w_1$ and $w_2$.
-->

$w_1x_1 + w_2x_2$ é uma soma ponderada de $x_1$ e $x_2$ ponderada pelos coeficientes $w_1$ e $w_2$.

<!--By changing the relative size of $w_1$ and $w_2$, we can switch the output of $w_1x_1 + w_2x_2$ to $x_1$ or $x_2$ or some linear combinations of $x_1$ and $x_2$.
-->

Alterando o tamanho relativo de $w_1$ e $w_2$, podemos mudar a saída de $w_1x_1 + w_2x_2$ para $x_1$ ou $x_2$ ou algumas combinações lineares de $x_1$ e $x_2$.

<!--The inputs can have multiple $x$ vectors (more than $x_1$ and $x_2$). The system will choose an appropriate combination, the choice of which is determined by another variable z. An attention mechanism allows the neural network to focus its attention on particular input(s) and ignore the others.
-->

As entradas podem ter vários vetores $x$ (mais de $x_1$ e $x_2$). O sistema escolherá uma combinação apropriada, cuja escolha é determinada por outra variável z. Um mecanismo de atenção permite que a rede neural concentre sua atenção em determinadas entradas e ignore as outras.

<!--Attention is increasingly important in NLP systems that use transformer architectures or other types of attention.
-->

A atenção é cada vez mais importante em sistemas de PNL que usam arquiteturas de transformador ou outros tipos de atenção.

<!--The weights are data independent because z is data independent.
-->

Os pesos são independentes dos dados porque z é independente dos dados.

<!--
## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)
-->


## [Gated Recurrent Units (GRU)](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=3549s)

<!--As mentioned above, RNN suffers from vanishing/exploding gradients and can’t remember states for very long. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), is an application of multiplicative modules that attempts to solve these problems. It's an example of recurrent net with memory (another is LSTM). The structure of A GRU unit is shown below:
-->

Como mencionado acima, RNN sofre de dissipação e explosão de gradientes e não consegue se lembrar dos estados por muito tempo. GRU, [Cho, 2014](https://arxiv.org/abs/1406.1078), é uma aplicação de módulos multiplicativos que tenta resolver esses problemas. É um exemplo de rede recorrente com memória (outra é LSTM). A estrutura de uma unidade GRU é mostrada abaixo:

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figure 3. Gated Recurrent Unit
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/GRU.png" height="300px" style="background-color:#226;"/><br>
Figura 3. Gated Recurrent Unit
</center>

<!--$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$
-->

$$
\begin{array}{l}
z_t = \sigma_g(W_zx_t + U_zh_{t-1} + b_z)\\
r_t = \sigma_g(W_rx_t + U_rh_{t-1} + b_r)\\
h_t = z_t\odot h_{t-1} + (1- z_t)\odot\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)
\end{array}
$$

<!--where $\odot$ denotes element-wise multiplication(Hadamard product), $x_t$ is the input vector, $h_t$ is the output vector, $z_t$ is the update gate vector, $r_t$ is the reset gate vector, $\phi_h$ is a hyperbolic tanh, and $W$,$U$,$b$ are learnable parameters.
-->

onde $\odot$ denota multiplicação elemento a elemento (produto Hadamard), $ x_t $ é o vetor de entrada, $h_t$é o vetor de saída, $z_t$ é o vetor de porta de atualização, $r_t$ é o vetor de porta de reset, $\phi_h$ é um tanh hiperbólico e $W$, $U$, $b$ são parâmetros que podem ser aprendidos.

<!--To be specific, $z_t$ is a gating vector that determines how much of the past information should be passed along to the future. It applies a sigmoid function to the sum of two linear layers and a bias over the input $x_t$ and the previous state $h_{t-1}$.  $z_t$ contains coefficients between 0 and 1 as a result of applying sigmoid. The final output state $h_t$ is a convex combination of $h_{t-1}$ and $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. If the coefficient is 1, the current unit output is just a copy of the previous state and ignores the input (which is the default behaviour). If it is less than one, then it takes into account some new information from the input.
-->

Para ser específico, $z_t$ é um vetor de passagem que determina quanto das informações do passado deve ser repassado para o futuro. Ele aplica uma função sigmóide à soma de duas camadas lineares e um viés sobre a entrada $x_t$ e o estado anterior $h_{t-1}$. $z_t$ contém coeficientes entre 0 e 1 como resultado da aplicação de sigmóide. O estado de saída final $ h_t $ é uma combinação convexa de $h_{t-1}$ e $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$ via $z_t$. Se o coeficiente for 1, a saída da unidade atual é apenas uma cópia do estado anterior e ignora a entrada (que é o comportamento padrão). Se for menor que um, leva em consideração algumas novas informações da entrada.

<!--The reset gate $r_t$ is used to decide how much of the past information to forget. In the new memory content $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, if the coefficient in $r_t$ is 0, then it stores none of the information from the past. If at the same time $z_t$ is 0, then the system is completely reset since $h_t$ would only look at the input.
-->

A porta de reinicialização $r_t$ é usada para decidir quanto das informações anteriores deve ser esquecido. No novo conteúdo de memória $\phi_h(W_hx_t + U_h(r_t\odot h_{t-1}) + b_h)$, se o coeficiente em $r_t$ for 0, então ele não armazena nenhuma das informações do passado. Se ao mesmo tempo $z_t$ for 0, então o sistema será completamente reiniciado, já que $h_t$ só olharia para a entrada.

<!--
## LSTM (Long Short-Term Memory)
-->


## LSTM (Long Short-Term Memory)

<!--GRU is actually a simplified version of LSTM which came out much earlier, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). By building up memory cells to preserve past information, LSTMs also aim to solve long term memory loss issues in RNNs. The structure of LSTMs is shown below:
-->

GRU é na verdade uma versão simplificada do LSTM que saiu muito antes, [Hochreiter, Schmidhuber, 1997](https://www.bioinf.jku.at/publications/older/2604.pdf). Ao construir células de memória para preservar informações anteriores, os LSTMs também visam resolver problemas de perda de memória de longo prazo em RNNs. A estrutura dos LSTMs é mostrada abaixo:

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figure 4. LSTM
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/LSTM.png" height="300px"/><br>
Figura 4. LSTM
</center>

<!--$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$
-->

$$
\begin{array}{l}
f_t = \sigma_g(W_fx_t + U_fh_{t-1} + b_f)\\
i_t = \sigma_g(W_ix_t + U_ih_{t-1} + b_i)\\
o_t = \sigma_o(W_ox_t + U_oh_{t-1} + b_o)\\
c_t = f_t\odot c_{t-1} + i_t\odot \tanh(W_cx_t + U_ch_{t-1} + b_c)\\
h_t = o_t \odot\tanh(c_t)
\end{array}
$$

<!--where $\odot$ denotes element-wise multiplication, $x_t\in\mathbb{R}^a$ is an input vector to the LSTM unit, $f_t\in\mathbb{R}^h$ is the forget gate's activation vector, $i_t\in\mathbb{R}^h$ is the input/update gate's activation vector, $o_t\in\mathbb{R}^h$ is the output gate's activation vector, $h_t\in\mathbb{R}^h$ is the hidden state vector (also known as output), $c_t\in\mathbb{R}^h$ is the cell state vector.
-->

onde $\odot$ denota multiplicação elemento a elemento, $x_t\in\mathbb{R}^a$ é um vetor de entrada para a unidade LSTM, $f_t\in\mathbb{R}^h$ é o vetor de ativação do portal de esquecimento , $i_t\in\mathbb{R}^h$ é o vetor de ativação da porta de entrada / atualização, $o_t\in\mathbb{R}^h$ é o vetor de ativação da porta de saída, $h_t\in\mathbb{R}^h$ é o vetor de estado oculto (também conhecido como saída), $c_t\in\mathbb{R}^h$ é o vetor de estado da célula.

<!--An LSTM unit uses a cell state $c_t$ to convey the information through the unit. It regulates how information is preserved or removed from the cell state through structures called gates. The forget gate $f_t$ decides how much information we want to keep from the previous cell state $c_{t-1}$ by looking at the current input and previous hidden state, and produces a number between 0 and 1 as the coefficient of $c_{t-1}$.  $\tanh(W_cx_t + U_ch_{t-1} + b_c)$ computes a new candidate to update the cell state, and like the forget gate, the input gate $i_t$ decides how much of the update to be applied. Finally, the output $h_t$ will be based on the cell state $c_t$, but will be put through a $\tanh$ then filtered by the output gate $o_t$.
-->

Uma unidade LSTM usa um estado de célula $c_t$ para transmitir as informações através da unidade. Ele regula como as informações são preservadas ou removidas do estado da célula por meio de estruturas chamadas de portas. A porta de esquecimento $f_t$ decide quanta informação queremos manter do estado da célula anterior $c_{t-1}$ olhando para a entrada atual e o estado anterior oculto, e produz um número entre 0 e 1 como o coeficiente de $ c_ {t-1} $. $ \ tanh (W_cx_t + U_ch_ {t-1} + b_c) $ calcula um novo candidato para atualizar o estado da célula e, como a porta de esquecimento, a porta de entrada $ i_t $ decide quanto da atualização a ser aplicada. Finalmente, a saída $ h_t $ será baseada no estado da célula $ c_t $, mas será colocada em um $ \ tanh $ e então filtrada pela porta de saída $ o_t $.

<!--Though LSTMs are widely used in NLP, their popularity is decreasing. For example, speech recognition is moving towards using temporal CNN, and NLP is moving towards using transformers.
-->

Embora os LSTMs sejam amplamente usados na PNL, sua popularidade está diminuindo. Por exemplo, o reconhecimento de voz está se movendo em direção ao uso de CNN temporal, e a PNL está se movendo em direção ao uso de transformadores.

<!--
## Sequence to Sequence Model
-->


## Modelo Sequência para Sequência (Seq2Seq)

<!--The approach proposed by [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) is the first neural machine translation system to have comparable performance to classic approaches. It uses an encoder-decoder architecture where both the encoder and decoder are multi-layered LSTMs.
-->

A abordagem proposta por [Sutskever NIPS 2014](https://papers.nips.cc/paper/5346-sequence-to-sequence-learning-with-neural-networks.pdf) é o primeiro sistema de tradução automática neural a ter comparação desempenho às abordagens clássicas. Ele usa uma arquitetura do tipo codificador-decodificador em que o codificador e o decodificador são LSTMs de várias camadas.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figure 5. Seq2Seq
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2Seq.png" height="300px" /><br>
Figura 5. Seq2Seq
</center>

<!--Each cell in the figure is an LSTM. For the encoder (the part on the left), the number of time steps equals the length of the sentence to be translated. At each step, there is a stack of LSTMs (four layers in the paper) where the hidden state of the previous LSTM is fed into the next one. The last layer of the last time step outputs a vector that represents the meaning of the entire sentence, which is then fed into another multi-layer LSTM (the decoder), that produces words in the target language. In the decoder, the text is generated in a sequential fashion. Each step produces one word, which is fed as an input to the next time step.
-->

Cada célula na figura é um LSTM. Para o codificador (a parte à esquerda), o número de intervalos de tempo é igual ao comprimento da frase a ser traduzida. Em cada etapa, há uma pilha de LSTMs (quatro camadas no papel) onde o estado oculto do LSTM anterior é alimentado para o próximo. A última camada da última etapa de tempo produz um vetor que representa o significado de toda a frase, que é então alimentado em outro LSTM de várias camadas (o decodificador), que produz palavras no idioma de destino. No decodificador, o texto é gerado de forma sequencial. Cada etapa produz uma palavra, que é alimentada como uma entrada para a próxima etapa de tempo.

<!--This architecture is not satisfying in two ways: First, the entire meaning of the sentence has to be squeezed into the hidden state between the encoder and decoder. Second, LSTMs actually do not preserve information for more than about 20 words. The fix for these issues is called a Bi-LSTM, which runs two LSTMs in opposite directions.  In a Bi-LSTM the meaning is encoded in two vectors, one generated by running LSTM from left to right, and another from right to left.  This allows doubling the length of the sentence without losing too much information.
-->

Essa arquitetura não é satisfatória de duas maneiras: primeiro, todo o significado da frase deve ser comprimido no estado oculto entre o codificador e o decodificador. Em segundo lugar, os LSTMs na verdade não preservam informações por mais de cerca de 20 palavras. A correção para esses problemas é chamada de Bi-LSTM, que executa dois LSTMs em direções opostas. Em um Bi-LSTM, o significado é codificado em dois vetores, um gerado pela execução do LSTM da esquerda para a direita e outro da direita para a esquerda. Isso permite dobrar o comprimento da frase sem perder muitas informações.

<!--
## Seq2seq with Attention
-->


## Seq2seq com Atenção (Attention)

<!--The success of the approach above was short-lived. Another paper by [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473)  suggested that instead of having a gigantic network that squeezes the meaning of the entire sentence into one vector, it would make more sense if at every time step we only focus the attention on the relevant locations in the original language with equivalent meaning, *i.e.* the attention mechanism.
-->

O sucesso da abordagem acima teve vida curta. Outro artigo de [Bahdanau, Cho, Bengio](https://arxiv.org/abs/1409.0473) sugeriu que, em vez de ter uma rede gigantesca que comprime o significado de toda a frase em um vetor, faria mais sentido se em a cada passo, nós apenas focamos a atenção nos locais relevantes no idioma original com significado equivalente, ou seja, o mecanismo de atenção.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figure 6. Seq2Seq with Attention
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/Seq2SeqwAttention.png" height="300px" /><br>
Figura 6. Seq2seq com Atenção 
</center>

<!--In Attention, to produce the current word at each time step, we first need to decide which hidden representations of words in the input sentence to focus on. Essentially, a network will learn to score how well each encoded input matches the current output of the decoder. These scores are normalized by a softmax, then the coefficients are used to compute a weighted sum of the hidden states in the encoder at different time steps. By adjusting the weights, the system can adjust the area of inputs to focus on. The magic of this mechanism is that the network used to compute the coefficients can be trained through backpropagation. There is no need to build them by hand!
-->

Em Atenção, para produzir a palavra atual em cada etapa de tempo, primeiro precisamos decidir em quais representações ocultas de palavras na frase de entrada nos concentrar. Essencialmente, uma rede aprenderá a pontuar quão bem cada entrada codificada corresponde à saída atual do decodificador. Essas pontuações são normalizadas por um softmax, então os coeficientes são usados para calcular uma soma ponderada dos estados ocultos no codificador em diferentes etapas de tempo. Ao ajustar os pesos, o sistema pode ajustar a área de entradas para focar. A mágica desse mecanismo é que a rede usada para calcular os coeficientes pode ser treinada por meio de retropropagação. Não há necessidade de construí-los manualmente!

<!--Attention mechanisms completely transformed neural machine translation. Later, Google published a paper [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762), and they put forward transformer, where each layer and group of neurons is implementing attention.
-->

Os mecanismos de atenção transformaram completamente a tradução automática feita por redes neurais. Posteriormente, o Google publicou um artigo [*Attention Is All You Need*](https://arxiv.org/abs/1706.03762) e apresentou o transformer, em que cada camada e grupo de neurônios está implementando a atenção.

<!--
## [Memory network](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)
-->


## [Redes com Memória](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=4575s)

<!--Memory networks stem from work at Facebook that was started by [Antoine Bordes](https://arxiv.org/abs/1410.3916) in 2014 and [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) in 2015.
-->

Redes de memória derivam do trabalho no Facebook iniciado por [Antoine Bordes](https://arxiv.org/abs/1410.3916) em 2014 e [Sainbayar Sukhbaatar](https://arxiv.org/abs/1503.08895) em 2015.

<!--The idea of a memory network is that there are two important parts in your brain: one is the **cortex**, which is where you have long term memory. There is a separate chunk of neurons called the **hippocampus** which sends wires to nearly everywhere in the cortex. The hippocampus is thought to be used for short term memory, remembering things for a relatively short period of time. The prevalent theory is that when you sleep, there is a lot of information transferred from the hippocampus to the cortex to be solidified in long term memory since the hippocampus has limited capacity.
-->

A ideia de uma rede com memória é que existem duas partes importantes em seu cérebro: uma é o **córtex**, que é onde você tem memória de longo prazo. Há um grupo separado de neurônios chamado **hipocampo**, que envia fios para quase todos os cantos do córtex. Acredita-se que o hipocampo seja usado para memória de curto prazo, lembrando coisas por um período de tempo relativamente curto. A teoria prevalente é que, quando você dorme, muitas informações são transferidas do hipocampo para o córtex para serem solidificadas na memória de longo prazo, já que o hipocampo tem capacidade limitada.

<!--For a memory network, there is an input to the network, $x$ (think of it as an address of the memory), and compare this $x$ with vectors $k_1, k_2, k_3, \cdots$ ("keys") through a dot product. Put them through a softmax, what you get are an array of numbers which sum to one. And there are a set of other vectors $v_1, v_2, v_3, \cdots$ ("values"). Multiply these vectors by the scalers from softmax and sum these vectors up (note the resemblance to the attention mechanism) gives you the result.
-->

Para uma rede com memória, há uma entrada para a rede, $ x $ (pense nisso como um endereço da memória), e compare este $ x $ com os vetores $k_1, k_2, k_3, \cdots$ ("chaves") por meio de um produto escalar. Coloque-os em um softmax, o que você obtém é uma matriz de números que somam um. E há um conjunto de outros vetores $v_1, v_2, v_3, \cdots$ ("valores"). Multiplique esses vetores pelos escalonadores de softmax e some esses vetores (observe a semelhança com o mecanismo de atenção) para obter o resultado.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figure 7. Memory Network
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork1.png" height="300px"/><br>
Figura 7. Redes com Memória
</center>

<!--If one of the keys (*e.g.* $k_i$) exactly matches $x$, then the coefficient associated with this key will be very close to one. So the output of the system will essentially be $v_i$.
-->

Se uma das chaves (*por exemplo* $ k_i $) corresponder exatamente a $ x $, então o coeficiente associado a esta chave será muito próximo de um. Portanto, a saída do sistema será essencialmente $ v_i $.

<!--This is **addressable associative memory**. Associative memory is that if your input matches a key, you get *that* value. And this is just a soft differentiable version of it, which allows you to backpropagate and change the vectors through gradient descent.
-->

Esta é a **memória associativa endereçável**. A memória associativa é que, se sua entrada corresponder a uma chave, você obtém *aquele* valor. E esta é apenas uma versão soft diferenciável dele, que permite retropropagar e alterar os vetores por meio de gradiente descendente.

<!--What the authors did was tell a story to a system by giving it a sequence of sentences. The sentences are encoded into vectors by running them through a neural net that has not been pretrained. The sentences are returned to the memory of this type. When you ask a question to the system, you encode the question and put it as the input of a neural net, the neural net produces an $x$ to the memory, and the memory returns a value.
-->

O que os autores fizeram foi contar uma história a um sistema, dando-lhe uma sequência de frases. As sentenças são codificadas em vetores, passando-as por uma rede neural que não foi pré-treinada. As frases são devolvidas à memória deste tipo. Quando você faz uma pergunta ao sistema, você codifica a pergunta e a coloca como a entrada de uma rede neural, a rede neural produz um $ x $ para a memória, e a memória retorna um valor.

<!--This value, together with the previous state of the network, is used to re-access the memory. And you train this entire network to produce an answer to your question. After extensive training, this model actually learns to store stories and answer questions.
-->

Este valor, junto com o estado anterior da rede, é usado para acessar novamente a memória. E você treina toda essa rede para produzir uma resposta à sua pergunta. Após um treinamento extensivo, esse modelo realmente aprende a armazenar histórias e responder a perguntas.

<!--$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$
-->

$$
\alpha_i = k_i^\top x \\
c = \text{softmax}(\alpha) \\
s = \sum_i c_i v_i
$$

<!--In memory network, there is a neural net that takes an input and then produces an address for the memory, gets the value back to the network, keeps going, and eventually produces an output. This is very much like computer since there is a CPU and an external memory to read and write.
-->

Na rede de memória, há uma rede neural que recebe uma entrada e, em seguida, produz um endereço para a memória, retorna o valor para a rede, continua e, por fim, produz uma saída. É muito parecido com um computador, pois há uma CPU e uma memória externa para ler e escrever.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork2.png" height="200px" />
<img src="{{site.baseurl}}/images/week06/06-2/MemoryNetwork3.png" height="200px" /> <br>

<!--Figure 8. Comparision between memory network and computer (Photo by <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>
-->

Figura 8. Comparação entre a rede com memória e um computador (Foto <a href='https://www.khanacademy.org/computing/ap-computer-science-principles/computers-101/computer--components/a/computer-memory'>Khan Acadamy</a>)
</center>

<!--There are people who imagine that you can actually build **differentiable computers** out of this. One example is the [Neural Turing Machine](https://arxiv.org/abs/1410.5401) from DeepMind, which was made public three days after Facebook's paper was published on arXiv.
-->

Existem pessoas que imaginam que você pode realmente construir **computadores diferenciáveis** a partir disso. Um exemplo é a [Máquina de Turing Neural](https://arxiv.org/abs/1410.5401) da DeepMind, que se tornou pública três dias depois que o artigo do Facebook foi publicado no arXiv.

<!--The idea is to compare inputs to keys, generate coefficients, and produce values - which is basically what a transformer is.  A transformer is basically a neural net in which every group of neurons is one of these networks.
-->

A ideia é comparar entradas para chaves, gerar coeficientes e produzir valores - que é basicamente o que é um transformador. Um transformador é basicamente uma rede neural em que cada grupo de neurônios é uma dessas redes.

