---
lang: pt
lang-ref: ch.06-1
lecturer: Yann LeCun
title: Aplicações de Redes Convolucionais
authors: Shiqing Li, Chenqin Yang, Yakun Wang, Jimin Tan
date: 2 Mar 2020
translator: Bernardo Lago
translation-date: 14 Nov 2021
---


<!--
## [Zip Code Recognition](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)
-->

## [Reconhecimento de código postal](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=43s)

<!--In the previous lecture, we demonstrated that a convolutional network can recognize digits, however, the question remains, how does the model pick each digit and avoid perturbation on neighboring digits. The next step is to detect non/overlapping objects and use the general approach of Non-Maximum Suppression (NMS). Now, given the assumption that the input is a series of non-overlapping digits, the strategy is to train several convolutional networks and using either majority vote or picking the digits corresponding to the highest score generated by the convolutional network.
-->

Na aula anterior, demonstramos que uma rede convolucional pode reconhecer dígitos, no entanto, a questão permanece, como o modelo escolhe cada dígito e evita perturbação nos dígitos vizinhos. A próxima etapa é detectar objetos não sobrepostos e usar a abordagem geral de Supressão Não Máxima (NMS). Agora, dada a suposição de que a entrada é uma série de dígitos não sobrepostos, a estratégia é treinar várias redes convolucionais e usando o voto da maioria ou escolhendo os dígitos correspondentes à pontuação mais alta gerada pela rede convolucional.

<!--
### Recognition with CNN
-->

### Reconhecimento com CNN

<!--Here we present the task of recognizing 5 non-overlapping zip codes. The system was not given any instructions on how to separate each digit but knows that is must predict 5 digits. The system (Figure 1) consists of 4 different sized convolutional networks, each producing one set of outputs. The output is represented in matrices. The four output matrices are from models with a different kernel width in the last layer. In each output, there are 10 rows, representing 10 categories from 0 to 9. The larger white square represents a higher score in that category. In these four output blocks, the horizontal sizes of the last kernel layers are 5, 4, 3 and 2 respectively. The size of the kernel decides the width of the model's viewing window on the input, therefore each model is predicting digits based on different window sizes. The model then takes a majority vote and selects the category that corresponds to the highest score in that window. To extract useful information, one should keep in mind that not all combinations of characters are possible, therefore error correction leveraging input restrictions is useful to ensure the outputs are true zip codes.
-->

Aqui apresentamos a tarefa de reconhecer 5 CEPs não sobrepostos. O sistema não recebeu instruções sobre como separar cada dígito, mas sabe que deve prever 5 dígitos. O sistema (Figura 1) consiste em 4 redes convolucionais de tamanhos diferentes, cada uma produzindo um conjunto de saídas. A saída é representada em matrizes. As quatro matrizes de saída são de modelos com largura de kernel diferente na última camada. Em cada saída, há 10 linhas, representando 10 categorias de 0 a 9. O quadrado branco maior representa uma pontuação mais alta nessa categoria. Nestes quatro blocos de saída, os tamanhos horizontais das últimas camadas do kernel são 5, 4, 3 e 2, respectivamente. O tamanho do kernel decide a largura da janela de visualização do modelo na entrada, portanto, cada modelo está prevendo dígitos com base em tamanhos de janela diferentes. O modelo, então, obtém uma votação majoritária e seleciona a categoria que corresponde à pontuação mais alta naquela janela. Para extrair informações úteis, deve-se ter em mente que nem todas as combinações de caracteres são possíveis, portanto, a correção de erros com base nas restrições de entrada é útil para garantir que as saídas sejam códigos postais verdadeiros.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 1:</b> Multiple classifiers on zip code recognition
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/O1IN3JD.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 1: </b> Múltiplos classificadores no reconhecimento do CEP
</center>

<!--Now to impose the order of the characters. The trick is to utilize a shortest path algorithm. Since we are given ranges of possible characters and the total number of digits to predict, We can approach this problem by computing the minimum cost of producing digits and transitions between digit. The path has to be continuous from the lower left cell to the upper right cell on the graph, and the path is restricted to only contain movements from left to right and bottom to top. Note that if the same number is repeated next to each other, the algorithm should be able to distinguish there are repeated numbers instead of predicting a single digit.
-->

Agora, para impor a ordem dos personagens. O truque é utilizar um algoritmo de caminho mais curto. Uma vez que recebemos faixas de caracteres possíveis e o número total de dígitos a prever, podemos abordar esse problema calculando o custo mínimo de produção de dígitos e transições entre os dígitos. O caminho deve ser contínuo da célula inferior esquerda para a célula superior direita no gráfico, e o caminho é restrito para conter apenas movimentos da esquerda para a direita e de baixo para cima. Observe que se o mesmo número for repetido um ao lado do outro, o algoritmo deve ser capaz de distinguir que há números repetidos em vez de prever um único dígito.

<!--
## [Face detection](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)
-->

## [Detecção de faces](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1241s)

<!--Convolutional neural networks perform well on detection tasks and face detection is no exception. To perform face detection we collect a dataset of images with faces and without faces, on which we train a convolutional net with a window size such as 30 $\times$ 30 pixels and ask the network to tell whether there is a face or not. Once trained, we apply the model to a new image and if there are faces roughly within a 30 $\times$ 30 pixel window, the convolutional net will light up the output at the corresponding locations. However, two problems exist.
-->

As redes neurais convolucionais têm um bom desempenho em tarefas de detecção e a detecção de faces não é exceção. Para realizar a detecção de faces, coletamos um conjunto de dados de imagens com faces e sem faces, no qual treinamos uma rede convolucional com um tamanho de janela de 30 $\times$ 30 pixels e pedimos à rede para dizer se há um rosto ou não. Uma vez treinado, aplicamos o modelo a uma nova imagem e se houver faces dentro de uma janela de 30 $\times$ 30 pixels, a rede convolucional iluminará a saída nos locais correspondentes. No entanto, existem dois problemas.

<!--
- **False Positives**: There are many different variations of non-face objects that may appear in a patch of an image. During the training stage, the model may not see all of them (*i.e.* a fully representative set of non-face patches). Therefore, the model may suffer from a lot of false positives at test time. For example, if the network has not been trained on images containing hands, it may detect faces based on skin tones and incorrectly classify patches of images containing hands as faces, thereby giving rise to false positives.
-->

- **Falsos positivos**: Existem muitas variações diferentes de objetos não-face que podem aparecer em um patch de uma imagem. Durante o estágio de treinamento, o modelo pode não ver todos eles (*ou seja*, um conjunto totalmente representativo de remendos não faciais). Portanto, o modelo pode apresentar muitos falsos positivos no momento do teste. Por exemplo, se a rede não foi treinada em imagens contendo mãos, ela pode detectar rostos com base em tons de pele e classificar incorretamente manchas de imagens contendo mãos como rostos, dando origem a falsos positivos.

<!--- **Different Face Size:** Not all faces are 30 $\times$ 30 pixels, so faces of differing sizes may not be detected. One way to handle this issue is to generate multi-scale versions of the same image. The original detector will detect faces around 30 $\times$ 30 pixels. If applying a scale on the image of factor $\sqrt 2$, the model will detect faces that were smaller in the original image since what was 30 $\times$ 30 is now 20 $\times$ 20 pixels roughly. To detect bigger faces, we can downsize the image. This process is inexpensive as half of the expense comes from processing the original non-scaled image. The sum of the expenses of all other networks combined is about the same as processing the original non-scaled image. The size of the network is the square of the size of the image on one side, so if you scale down the image by $\sqrt 2$, the network you need to run is smaller by a factor of 2. So the overall cost is $1+1/2+1/4+1/8+1/16…$, which is 2. Performing a multi-scale model only doubles the computational cost.
-->

- **Tamanho de rosto diferente:** Nem todos os rostos têm 30 $\times$ 30 pixels, portanto, rostos de tamanhos diferentes podem não ser detectados. Uma maneira de lidar com esse problema é gerar versões em várias escalas da mesma imagem. O detector original detectará rostos em torno de  30 $\times$ 30 pixels. Se aplicar uma escala na imagem do fator  $\sqrt 2$, o modelo detectará faces que eram menores na imagem original, pois o que era  30 $\times$ 30 agora é 20 $\times$ 20 pixels aproximadamente. Para detectar rostos maiores, podemos reduzir o tamanho da imagem. Esse processo é barato, pois metade das despesas vem do processamento da imagem original sem escala. A soma das despesas de todas as outras redes combinadas é quase a mesma do processamento da imagem original sem escala. O tamanho da rede é o quadrado do tamanho da imagem de um lado, então, se você reduzir a imagem em $\sqrt 2$, a rede que você precisa para executar é menor em um fator de 2. Portanto, o custo geral é $1+1/2+1/4+1/8+1/16…$, que é 2. Executar um modelo em várias escalas apenas duplica o custo computacional.

<!--
### A multi-scale face detection system
-->

### Um sistema de detecção de faces em várias escalas

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 2:</b> Face detection system
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/8R3v0Dj.png" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b> Figura 2: </b> Sistema de detecção de faces
</center>

<!--The maps shown in (Figure 3) indicate the scores of face detectors. This face detector recognizes faces that are 20 $\times$ 20 pixels in size. In fine-scale (Scale 3) there are many high scores but are not very definitive. When the scaling factor goes up (Scale 6), we see more clustered white regions. Those white regions represent detected faces. We then apply non-maximum suppression to get the final location of the face.
-->

Os mapas mostrados na (Figura 3) indicam a pontuação dos detectores de face. Este detector facial reconhece rostos com tamanho de 20 $\times$ 20 pixels. Em escala fina (Escala 3), há muitas pontuações altas, mas não são muito definitivas. Quando o fator de escala aumenta (Escala 6), vemos mais regiões brancas agrupadas. Essas regiões brancas representam rostos detectados. Em seguida, aplicamos a supressão não máxima para obter a localização final do rosto.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 3:</b> Face detector scores for various scaling factors
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/CQ8T00O.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 3: </b> Pontuações do detector facial para vários fatores de escala
</center>

<!--
### Non-maximum suppression
-->

### Supressão não máxima

<!--For each high-scoring region, there is probably a face underneath. If more faces are detected very close to the first, it means that only one should be considered correct and the rest are wrong. With non-maximum suppression, we take the highest-scoring of the overlapping bounding boxes and remove the others. The result will be a single bounding box at the optimum location.
-->

Para cada região de alta pontuação, provavelmente há um rosto por baixo. Se forem detectados mais rostos muito próximos do primeiro, significa que apenas um deve ser considerado correto e os demais estão errados. Com a supressão não máxima, pegamos a pontuação mais alta das caixas delimitadoras sobrepostas e removemos as outras. O resultado será uma única caixa delimitadora no local ideal.

<!--
### Negative mining
-->

### Mineração negativa

<!--In the last section, we discussed how the model may run into a large number of false positives at test time as there are many ways for non-face objects to appear similar to a face. No training set will include all the possible non-face objects that look like faces. We can mitigate this problem through negative mining. In negative mining, we create a negative dataset of non-face patches which the model has (erroneously) detected as faces. The data is collected by running the model on inputs that are known to contain no faces. Then we retrain the detector using the negative dataset. We can repeat this process to increase the robustness of our model against false positives.
-->

Na última seção, discutimos como o modelo pode ser executado em um grande número de falsos positivos no momento do teste, pois há muitas maneiras de objetos não-face parecerem semelhantes a um rosto. Nenhum conjunto de treinamento incluirá todos os possíveis objetos não-rostos que se parecem com rostos. Podemos mitigar esse problema por meio da mineração negativa. Na mineração negativa, criamos um conjunto de dados negativos de patches não faciais que o modelo detectou (erroneamente) como faces. Os dados são coletados executando o modelo em entradas que são conhecidas por não conterem faces. Em seguida, treinamos novamente o detector usando o conjunto de dados negativo. Podemos repetir esse processo para aumentar a robustez do nosso modelo contra falsos positivos.

<!--
## Semantic segmentation
-->

## Segmentação semântica

<!--Semantic segmentation is the task of assigning a category to every pixel in an input image.
-->

A segmentação semântica é a tarefa de atribuir uma categoria a cada pixel em uma imagem de entrada.

<!--
### [CNN for Long Range Adaptive Robot Vision](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)
-->

### [CNN para Visão de Robôs Adaptável de Longo Alcance](https://www.youtube.com/watch?v=ycbMGyCPzvE&t=1669s)

<!--In this project, the goal was to label regions from input images so that a robot can distinguish between roads and obstacles. In the figure, the green regions are areas the robot can drive on and the red regions are obstacles like tall grass. To train the network for this task, we took a patch from the image and manually label it traversable or not (green or red). We then train the convolutional network on the patches by asking it to predict the color of the patch. Once the system is sufficiently trained, it is applied to the entire image, labeling all the regions of the image as green or red.
-->

Neste projeto, o objetivo era rotular regiões a partir de imagens de entrada para que um robô pudesse distinguir entre estradas e obstáculos. Na figura, as regiões verdes são áreas nas quais o robô pode dirigir e as regiões vermelhas são obstáculos como grama alta. Para treinar a rede para essa tarefa, pegamos um patch da imagem e rotulamos manualmente como atravessável ou não (verde ou vermelho). Em seguida, treinamos a rede convolucional nos patches, pedindo-lhe para prever a cor do patch. Uma vez que o sistema esteja suficientemente treinado, ele é aplicado em toda a imagem, rotulando todas as regiões da imagem como verdes ou vermelhas.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> CNN for Long Range Adaptive Robot Vision (DARPA LAGR program 2005-2008)
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/5mM7dTT.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b> Figura 4: </b> CNN para Visão do Robô Adaptável de Longo Alcance (programa DARPA LAGR 2005-2008)
</center>

<!--There were five categories for prediction: 1) super green, 2) green, 3) purple: obstacle foot line, 4) red obstacle  5) super red: definitely an obstacle.
-->

Havia cinco categorias de previsão: 1) superverde, 2) verde, 3) roxo: linha do pé do obstáculo, 4) obstáculo vermelho 5) super vermelho: definitivamente um obstáculo.

<!--
**Stereo Labels** (Figure 4, Column 2)
 Images are captured by the 4 cameras on the robot, which are grouped into 2 stereo vision pairs. Using the known distances between the stereo pair cameras, the positions of every pixel in 3D space are then estimated by measuring the relative distances between the pixels that appear in both the cameras in a stereo pair. This is the same process our brains use to estimate the distance of the objects that we see. Using the estimated position information, a plane is fit to the ground, and pixels are then labeled as green if they are near the ground and red if they are above it.
-->

**Rótulos estéreo** (Figura 4, Coluna 2)
 As imagens são capturadas pelas 4 câmeras do robô, que são agrupadas em 2 pares de visão estéreo. Usando as distâncias conhecidas entre as câmeras do par estéreo, as posições de cada pixel no espaço 3D são estimadas medindo as distâncias relativas entre os pixels que aparecem em ambas as câmeras em um par estéreo. Este é o mesmo processo que nosso cérebro usa para estimar a distância dos objetos que vemos. Usando as informações de posição estimada, um plano é ajustado ao solo e os pixels são rotulados como verdes se estiverem próximos do solo e vermelhos se estiverem acima dele.

<!--* **Limitations & Motivation for ConvNet**: The stereo vision only works up to 10 meters and driving a robot requires long-range vision. A ConvNet however, is capable of detecting objects at much greater distances, if trained correctly.
-->

* **Limitações e motivação para ConvNet**: A visão estéreo funciona apenas até 10 metros e dirigir um robô requer visão de longo alcance. Um ConvNet, entretanto, é capaz de detectar objetos em distâncias muito maiores, se treinado corretamente.

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> Scale-invariant Pyramid of Distance-normalized Images
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/rcxY4Lb.png" style="zoom: 100%; background-color:#DCDCDC;"/><br>
<b> Figura 5: </b> Pirâmide invariante de escala de imagens normalizadas por distância
</center>

<!--* **Served as Model Inputs**: Important pre-processing includes building a scale-invariant pyramid of distance-normalized images (Figure 5). It is similar to what we have done earlier of this lecture when we tried to detect faces of multiple scales.
-->

* **Servido como entradas do modelo**: o pré-processamento importante inclui a construção de uma pirâmide invariante de escala de imagens normalizadas por distância (Figura 5). É semelhante ao que fizemos anteriormente nesta aula, quando tentamos detectar faces de escalas múltiplas.

<!--**Model Outputs** (Figure 4, Column 3)
-->

**Saídas do modelo** (Figura 4, Coluna 3)

<!--The model outputs a label for every pixel in the image **up to the horizon**. These are classifier outputs of a multi-scale convolutional network.
-->

O modelo gera um rótulo para cada pixel na imagem **até o horizonte**. Estas são as saídas do classificador de uma rede convolucional multi-escala.

<!--* **How the Model Becomes Adaptive**: The robots have continuous access to the stereo labels, allowing the network to re-train, adapting to the new environment it's in. Please note that only the last layer of the network would be re-trained. The previous layers are trained in the lab and fixed.
-->

* **Como o modelo se torna adaptativo**: Os robôs têm acesso contínuo às etiquetas estéreo, permitindo que a rede seja treinada novamente, adaptando-se ao novo ambiente em que se encontra. Observe que apenas a última camada da rede seria refeita -treinado. As camadas anteriores são treinadas em laboratório e fixas.

<!--**System Performance**
-->

**Performance do sistema**

<!--When trying to get to a GPS coordinate on the other side of a barrier, the robot "saw" the barrier from far away and planned a route that avoided it. This is thanks to the CNN detecting objects up 50-100m away.
-->

Ao tentar chegar a uma coordenada GPS do outro lado de uma barreira, o robô "avistou" a barreira de longe e planejou uma rota para evitá-la. Isso é graças à CNN detectando objetos até 50-100m de distância.

<!--**Limitation**
-->

**Limitação**

<!--Back in the 2000s, computation resources were restricted. The robot was able to process around 1 frame per second, which means it would not be able to detect a person that walks in its way for a whole second before being able to react. The solution for this limitation is a **Low-Cost Visual Odometry** model. It is not based on neural networks, has a vision of ~2.5m but reacts quickly.
-->

Na década de 2000, os recursos de computação eram restritos. O robô foi capaz de processar cerca de 1 quadro por segundo, o que significa que ele não seria capaz de detectar uma pessoa que andasse em seu caminho por um segundo inteiro antes de ser capaz de reagir. A solução para essa limitação é um modelo de **Odometria visual de baixo custo**. Não é baseado em redes neurais, tem uma visão de ~2,5m, mas reage rapidamente.

<!--
### Scene Parsing and Labelling
-->

### Análise e rotulagem de cenas

<!--In this task, the model outputs an object category (buildings, cars, sky, etc.) for every pixel. The architecture is also multi-scale (Figure 6).
-->

Nesta tarefa, o modelo gera uma categoria de objeto (edifícios, carros, céu, etc.) para cada pixel. A arquitetura também é multi-escala (Figura 6).

<!--<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b>Figure 6:</b> Multi-scale CNN for scene parsing
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week06/06-1/VpVbkl5.jpg" style="zoom: 30%; background-color:#DCDCDC;"/><br>
<b> Figura 6: </b> CNN em várias escalas para análise de cena
</center>

<!--Notice that if we back project one output of the CNN onto the input, it corresponds to an input window of size $46\times46$ on the original image at the bottom of the Laplacian Pyramid. It means we are **using the context of $46\times46$ pixels to decide the category of the central pixel**.
-->

Observe que se projetarmos de volta uma saída da CNN na entrada, ela corresponderá a uma janela de entrada de tamanho $46\times46$ na imagem original na parte inferior da Pirâmide Laplaciana. Isso significa que estamos **usando o contexto de $46\times46$ pixels para decidir a categoria do pixel central**.

<!--However, sometimes this context size is not enough to determine the category for larger objects.
-->

No entanto, às vezes, esse tamanho de contexto não é suficiente para determinar a categoria de objetos maiores.

<!--**The multiscale approach enables a wider vision by providing extra rescaled images as  inputs.** The steps are as follows:
1. Take the same image, reduce it by the factor of 2 and a factor of 4, separately.
2. These two extra rescaled images are fed to **the same ConvNet** (same weights, same kernels) and we get another two sets of Level 2 Features.
3. **Upsample** these features so that they have the same size as the Level 2 Features of the original image.
4. **Stack** the three sets of (upsampled) features together and feed them to a classifier.
-->

**A abordagem multiescala permite uma visão mais ampla, fornecendo imagens extras redimensionadas como entradas.** As etapas são as seguintes:
1. Pegue a mesma imagem, reduza-a pelo fator de 2 e pelo fator de 4, separadamente.
2. Essas duas imagens redimensionadas extras são alimentadas **a mesma ConvNet** (mesmos pesos, mesmos kernels) e obtemos outros dois conjuntos de recursos de nível 2.
3. **Aumente a amostra** desses recursos para que tenham o mesmo tamanho que os Recursos de Nível 2 da imagem original.
4. **Empilhe** os três conjuntos de recursos (amostrados) e os envie a um classificador.

<!--
Now the largest effective size of content, which is from the 1/4 resized image, is $184\times 184\, (46\times 4=184)$.
-->

Agora, o maior tamanho efetivo de conteúdo, que é da imagem redimensionada de 1/4, é $184\times 184\, (46\times 4=184)$.

<!--**Performance**: With no post-processing and running frame-by-frame, the model runs very fast even on standard hardware. It has a rather small size of training data (2k~3k), but the results are still record-breaking.
-->

**Desempenho**: sem pós-processamento e execução quadro a quadro, o modelo funciona muito rápido, mesmo em hardware padrão. Tem um tamanho bastante pequeno de dados de treinamento (2k ~ 3k), mas os resultados ainda são recordes.

