---
lang: pt
lang-ref: ch.05-3
title: Noções básicas sobre convoluções e mecanismo de diferenciação automática
lecturer: Alfredo Canziani
authors: Leyi Zhu, Siqi Wang, Tao Wang, Anqi Zhang
date: 25 Feb 2020
translator: Felipe Schiavon
translation-date: 14 Nov 2021
---

<!--
## [Understanding 1D convolution](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)
-->


## [Entendendo a convolução 1D](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=140s)

<!--In this part we will discuss convolution, since we would like to explore the sparsity, stationarity, compositionality of the data.
-->

Nesta parte discutiremos a convolução, uma vez que gostaríamos de explorar a esparsidade, estacionariedade e composicionalidade dos dados.

<!--Instead of using the matrix $A$ discussed in the [previous week]({{site.baseurl}}/en/week04/04-1), we will change the matrix width to the kernel size $k$. Therefore, each row of the matrix is a kernel. We can use the kernels by stacking and shifting (see Fig 1). Then we can have $m$ layers of height $n-k+1$.
-->

Ao invés de usar a matriz $A$ discutida na [semana anterior]({{site.baseurl}}/pt/week04/04-1), vamos alterar a largura da matriz para o tamanho do kernel $k$. Portanto, cada linha da matriz é um kernel. Podemos usar os kernels os empilhando e deslocando (veja a Fig. 1). Então podemos ter $m$ camadas de altura $n-k+1$.
<!--<center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<b>Fig 1</b>: Illustration of 1D Convolution
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Illustration_1D_Conv.png" alt="1" style="zoom:40%;" /><br>
<b>Fig 1</b>: Ilustração de uma Convolução 1D
</center>

<!--The output is $m$ (thickness) vectors of size $n-k+1$.
-->

A saída são $m$ (espessura) vetores de tamanho $n-k+1$.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<b>Fig 2</b>: Result of 1D Convolution
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Result_1D_Conv.png" alt="2" style="zoom:40%;" /><br>
<b>Fig 2</b>: Resultado da Convolução 1D
</center>

<!--Furthermore, a single input vector can viewed as a monophonic signal.
-->

Além disso, um único vetor de entrada pode ser visto como um sinal monofônico.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<b>Fig 3</b>: Monophonic Signal
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Monophonic_Signal.png" alt="3" style="zoom:40%;" /><br>
<b>Fig 3</b>: Monofônico Signal
</center>

<!--Now, the input $x$ is a mapping
-->

Agora, a entrada $x$ é o mapeamento

<!--$$
x:\Omega\rightarrow\mathbb{R}^{c}
$$
-->

$$
x:\Omega\rightarrow\mathbb{R}^{c}
$$

<!--where $\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$ (since this is $1$ dimensional signal / it has a $1$ dimensional domain) and in this case the channel number $c$ is $1$. When $c = 2$ this becomes a stereophonic signal.
-->

onde $\Omega = \lbrace 1, 2, 3, \cdots \rbrace \subset \mathbb{N}^1$ (uma vez que este é um sinal $1$ dimensional / tem um domínio unidimensional) e, neste caso, o canal o número $c$ é $1$. Quando $c = 2$, isso se torna um sinal estereofônico.

<!--For the 1D convolution, we can just compute the scalar product, kernel by kernel (see Fig 4).
-->

Para a convolução 1D, podemos apenas calcular o produto escalar, kernel por kernel (consulte a Figura 4).

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-3/Layer_by_layer_scalar_product.png" alt="4" style="zoom:40%;" /><br>
<b>Fig 4</b>: Layer-by-layer Scalar Product of 1D Convolution
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Layer_by_layer_scalar_product.png" alt="4" style="zoom:40%;" /><br>
<b>Fig 4</b>: Produto escalar camada por camada da convolução 1D
</center>

<!--
## [Dimension of kernels and output width in PyTorch](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)
-->


## [Dimensões das larguras dos kernels e saídas no PyTorch](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1095s)

<!--Tips: We can use ***question mark*** in IPython to get access to the documents of functions. For example,
-->

Dicas: Podemos usar ***ponto de interrogação*** no IPython para obter acesso à documentação das funções. Por exemplo,

<!--```python
Init signature:
nn.Conv1d(
	in_channels,           # number of channels in the input image
	out_channels,          # number of channels produced by the convolution
	kernel_size,           # size of the convolving kernel
	stride=1,              # stride of the convolution
	padding=0,             # zero-padding added to both sides of the input
	dilation=1,            # spacing between kernel elements
	groups=1,              # nb of blocked connections from input to output
	bias=True,             # if `True`, adds a learnable bias to the output
	padding_mode='zeros',  # accepted values `zeros` and `circular`
)
```
-->

```python
Init signature:
nn.Conv1d(
	in_channels,           # número de canais na imagem de entrada
	out_channels,          # número de canais produzidos pela convolução
	kernel_size,           # tamanho do kernel convolvente
	stride=1,              # stride (passo) da convolução
	padding=0,             # zero-padding (preenchimento com zero) adicionado nos dois lados da entrada
	dilation=1,            # espaçamento entre os elementos do kernel
	groups=1,              # número de conexões bloqueadas da entrada para a saída
	bias=True,             # se `True`, adiciona um viés "aprendível" na saída
	padding_mode='zeros',  # modo de preenchimento, aceita valores `zeros` e `circular`
)
```

<!--
### 1D convolution
-->


### Convolução 1D

<!--We have $1$ dimensional convolution going from $2$ channels (stereophonic signal) to $16$ channels ($16$ kernels) with kernel size of $3$ and stride of $1$. We then have $16$ kernels with thickness $2$ and length $3$. Let's assume that the input signal has a batch of size $1$ (one signal), $2$ channels and $64$ samples. The resulting output layer has $1$ signal, $16$ channels and the length of the signal is $62$ ($=64-3+1$). Also, if we output the bias size, we'll find the bias size is $16$, since we have one bias per weight.
-->

Temos $1$ convolução dimensional indo de $2$ canais (sinal estereofônico) para $16$ canais ($16$ kernels) com tamanho de kernel de $3$ e *stride* (passo) de $1$. Temos então $16$ kernels com espessura $2$ e comprimento $3$. Vamos supor que o sinal de entrada tenha um lote de tamanho $1$ (um sinal), $2$ canais e $64$ amostras. A camada de saída resultante tem $1$ sinal, $16$ canais e o comprimento do sinal é $62$ ($=64-3+1$). Além disso, se gerarmos o tamanho do enviesamento, descobriremos que o tamanho do viés é $16$, já que temos um viés para cada peso.

<!--```python
conv = nn.Conv1d(2, 16, 3)  # 2 channels (stereo signal), 16 kernels of size 3
conv.weight.size()          # output: torch.Size([16, 2, 3])
conv.bias.size()            # output: torch.Size([16])
x = torch.rand(1, 2, 64)    # batch of size 1, 2 channels, 64 samples
conv(x).size()              # saída: torch.Size([1, 16, 62])
conv = nn.Conv1d(2, 16, 5)  # 2 channels, 16 kernels of size 5
conv(x).size()              # output: torch.Size([1, 16, 60])
```

-->

```python
conv = nn.Conv1d(2, 16, 3)  # 2 canais (sinal estéreo), 16 kernels de tamanho 3
conv.weight.size()          # saída: torch.Size([16, 2, 3])
conv.bias.size()            # saída: torch.Size([16])
x = torch.rand(1, 2, 64)    # lote de tamanho 1, 2 canais, 64 amostras
conv(x).size()              # saída: torch.Size([1, 16, 62])
conv = nn.Conv1d(2, 16, 5)  # 2 canais, 16 kernels de tamanho 5
conv(x).size()              # saída: torch.Size([1, 16, 60])

```

<!--
### 2D convolution
-->


### Convolução 2D

<!--We first define the input data as $1$ sample, $20$ channels (say, we're using an hyperspectral image) with height $64$ and width $128$. The 2D convolution has $20$ channels from input and $16$ kernels with size of $3 \times 5$. After the convolution, the output data has $1$ sample, $16$ channels with height $62$ ($=64-3+1$) and width $124$ ($=128-5+1$).
-->

Primeiro definimos os dados de entrada como $1$ amostra, $20$ canais (digamos, estamos usando uma imagem hiperespectral) com altura $64$ e largura $128$. A convolução 2D tem $20$ canais de entrada e $16$ kernels com tamanho de $3\times 5$. Após a convolução, os dados de saída têm $1$ amostra, $16$ canais com altura $62$ ($=64-3+1$) e largura $124$ ($=128-5+1$).

<!--```python
x = torch.rand(1, 20, 64, 128)    # 1 sample, 20 channels, height 64, and width 128
conv = nn.Conv2d(20, 16, (3, 5))  # 20 channels, 16 kernels, kernel size is 3 x 5
conv.weight.size()                # output: torch.Size([16, 20, 3, 5])
conv(x).size()                    # output: torch.Size([1, 16, 62, 124])
```
-->

```python
x = torch.rand(1, 20, 64, 128)    # 1 amostra, 20 canais, altura 64 e largura 128
conv = nn.Conv2d(20, 16, (3, 5))  # 20 canais, 16 kernels, kernel de tamanho 3 x 5
conv.weight.size()                # saída: torch.Size([16, 20, 3, 5])
conv(x).size()                    # saída: torch.Size([1, 16, 62, 124])
```

<!--If we want to achieve the same dimensionality, we can have paddings. Continuing the code above, we can add new parameters to the convolution function: `stride=1` and `padding=(1, 2)`, which means $1$ on $y$ direction ($1$ at the top and $1$ at the bottom) and $2$ on $x$ direction. Then the output signal is in the same size compared to the input signal. The number of dimensions that is required to store the collection of kernels when you perform 2D convolution is $4$.
-->

Se quisermos atingir a mesma dimensionalidade, podemos ter preenchimentos. Continuando o código acima, podemos adicionar novos parâmetros à função de convolução: `stride = 1` e` padding = (1, 2) `, o que significa $1$ em $y$ direction ($1$ no topo e $1$ na parte inferior) e $2$ na direção $x$. Então, o sinal de saída tem o mesmo tamanho em comparação com o sinal de entrada. O número de dimensões necessárias para armazenar a coleção de kernels ao realizar a convolução 2D é $4$.

<!--```python
# 20 channels, 16 kernels of size 3 x 5, stride is 1, padding of 1 and 2
conv = nn.Conv2d(20, 16, (3, 5), 1, (1, 2))
conv(x).size()  # output: torch.Size([1, 16, 64, 128])
```
-->

```python
# 20 canais, 16 kernels de tamanho 3 x 5, stride de 1, preenchimento (padding) de 1 e 2
conv = nn.Conv2d(20, 16, (3, 5), 1, (1, 2))
conv(x).size()  # saída: torch.Size([1, 16, 64, 128])
```

<!--
## [How automatic gradient works?](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)
-->


## [Como funciona o gradiente automático?](https://www.youtube.com/watch?v=eEzCZnOFU1w&t=1634s)

<!--In this section we're going to ask torch to check all the computation over the tensors so that we can perform the computation of partial derivatives.
-->

Nesta seção, vamos pedir ao torch para verificar todos os cálculos sobre os tensores para que possamos realizar o cálculo das derivadas parciais.

<!--- Create a $2\times2$ tensor $\boldsymbol{x}$ with gradient-accumulation capabilities;
- Deduct $2$ from all elements of $\boldsymbol{x}$ and get $\boldsymbol{y}$; (If we print `y.grad_fn`, we will get `<SubBackward0 object at 0x12904b290>`, which means that `y` is generated by the module of subtraction $\boldsymbol{x}-2$. Also we can use `y.grad_fn.next_functions[0][0].variable` to derive the original tensor.)
- Do more operations: $\boldsymbol{z} = 3\boldsymbol{y}^2$;
- Calculate the mean of $\boldsymbol{z}$.
-->

- Crie um tensor $2\times2$ $\boldsymbol{x}$ com capacidades de acumulação de gradiente;
- Deduza $2$ de todos os elementos de $\boldsymbol{x}$ e obtenha $\boldsymbol{y}$; (Se imprimirmos `y.grad_fn`, obteremos` <SubBackward0 object em 0x12904b290> `, o que significa que `y` é gerado pelo módulo da subtração $\boldsymbol{x}-2$. Também podemos usar `y.grad_fn.next_functions[0][0].variable` para derivar o tensor original.)
- Faça mais operações: $\boldsymbol{z}=3 \boldsymbol{y}^2 $;
- Calcule a média de $\boldsymbol{z}$.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>Fig 5</b>: Flow Chart of the Auto-gradient Example
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-3/Flow_Chart.png" alt="5" style="zoom:60%;" /><br>
<b>Fig 5</b>: Fluxograma do Exemplo de gradiente automático
</center>

<!--Back propagation is used for computing the gradients. In this example, the process of back propagation can be viewed as computing the gradient $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. After computing $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$ by hand as a validation, we can find that the execution of `a.backward()` gives us the same value of *x.grad* as our computation.
-->

A retropropagação (backpropagation) é usada para calcular os gradientes. Neste exemplo, o processo de retropropagação pode ser visto como o cálculo do gradiente $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$. Depois de calcular $\frac{d\boldsymbol{a}}{d\boldsymbol{x}}$ manualmente como uma validação, podemos descobrir que a execução de `a.backward()` nos dá o mesmo valor de *x.grad* como nosso cálculo.

<!--Here is the process of computing back propagation by hand:
-->

Aqui está o processo de cálculo da retropropagação manualmente:

<!--$$
\begin{aligned}
a &= \frac{1}{4} (z_1 + z_2 + z_3 + z_4) \\
z_i &= 3y_i^2 = 3(x_i-2)^2 \\
\frac{da}{dx_i} &= \frac{1}{4}\times3\times2(x_i-2) = \frac{3}{2}x_i-3 \\
x &= \begin{pmatrix} 1&2\\3&4\end{pmatrix} \\
\left(\frac{da}{dx_i}\right)^\top &= \begin{pmatrix} 1.5-3&3-3\\[2mm]4.5-3&6-3\end{pmatrix}=\begin{pmatrix} -1.5&0\\[2mm]1.5&3\end{pmatrix}
\end{aligned}
$$
-->

$$
\begin{aligned}
a &= \frac{1}{4} (z_1 + z_2 + z_3 + z_4) \\
z_i &= 3y_i^2 = 3(x_i-2)^2 \\
\frac{da}{dx_i} &= \frac{1}{4}\times3\times2(x_i-2) = \frac{3}{2}x_i-3 \\
x &= \begin{pmatrix} 1&2\\3&4\end{pmatrix} \\
\left(\frac{da}{dx_i}\right)^\top &= \begin{pmatrix} 1.5-3&3-3\\[2mm]4.5-3&6-3\end{pmatrix}=\begin{pmatrix} -1.5&0\\[2mm]1.5&3\end{pmatrix}
\end{aligned}
$$

<!--Whenever you use partial derivative in PyTorch, you get the same shape of the original data. But the correct Jacobian thing should be the transpose.
-->

Sempre que você usa derivada parcial em PyTorch, obtém a mesma forma dos dados originais. Mas a coisa jacobiana correta deveria ser a transposição.

<!--
### From basic to more crazy
-->


### Do básico ao mais louco

<!--Now we have a $1\times3$ vector $x$, assign $y$ to the double $x$ and keep doubling $y$ until its norm is smaller than $1000$. Due to the randomness we have for $x$, we cannot directly know the number of iterations when the procedure terminates.
-->

Agora temos um vetor $1\times3$ $x$, atribua $y$ ao dobro de $x$ e continue dobrando $y$ até que sua norma seja menor que $1000$. Devido à aleatoriedade que temos para $x$, não podemos saber diretamente o número de iterações quando o procedimento termina.

<!--```python
x = torch.randn(3, requires_grad=True)
y = x * 2
i = 0
while y.data.norm() < 1000:
    y = y * 2
    i += 1
```
-->

```python
x = torch.randn(3, requires_grad=True)

y = x * 2
i = 0
while y.data.norm() < 1000:
    y = y * 2
    i += 1
```

<!--However, we can infer it easily by knowing the gradients we have.
-->

No entanto, podemos inferir isso facilmente conhecendo os gradientes que temos.

<!--```python
gradients = torch.FloatTensor([0.1, 1.0, 0.0001])
y.backward(gradients)
print(x.grad)
tensor([1.0240e+02, 1.0240e+03, 1.0240e-01])
print(i)
9
```
-->

```python
gradients = torch.FloatTensor([0.1, 1.0, 0.0001])
y.backward(gradients)

print(x.grad)
tensor([1.0240e+02, 1.0240e+03, 1.0240e-01])
print(i)
9
```

<!--As for the inference, we can use `requires_grad=True` to label that we want to track the gradient accumulation as shown below. If we omit `requires_grad=True` in either $x$ or $w$'s declaration and call `backward()` on $z$, there will be runtime error due to we do not have gradient accumulation on $x$ or $w$.
-->

Quanto à inferência, podemos usar `requires_grad=True` para rotular que queremos rastrear o acúmulo de gradiente conforme mostrado abaixo. Se omitirmos `requires_grad=True` na declaração de $x$ ou $w$ e chamar`backward ()`em $z$, haverá um erro de execução devido a não termos acumulação de gradiente em $x$ ou $w$.

<!--```python
# Both x and w that allows gradient accumulation
x = torch.arange(1., n + 1, requires_grad=True)
w = torch.ones(n, requires_grad=True)
z = w @ x
z.backward()
print(x.grad, w.grad, sep='\n')
```
-->

```python
# Tanto x quanto w que permitem o acúmulo de gradiente
x = torch.arange(1., n + 1, requires_grad=True)
w = torch.ones(n, requires_grad=True)
z = w @ x
z.backward()
print(x.grad, w.grad, sep='\n')
```

<!--And, we can have `with torch.no_grad()` to omit the gradient accumulation.
-->

E, podemos usar o comando `with torch.no_grad()` para omitir o acúmulo de gradiente.

<!--```python
x = torch.arange(1., n + 1)
w = torch.ones(n, requires_grad=True)

# All torch tensors will not have gradient accumulation
with torch.no_grad():
    z = w @ x

try:
    z.backward()  # PyTorch will throw an error here, since z has no grad accum.
except RuntimeError as e:
    print('RuntimeError!!! >:[')
    print(e)
```
-->


```python
x = torch.arange(1., n + 1)
w = torch.ones(n, requires_grad=True)

# Todos os tensores do torch não terão gradientes acumulados
with torch.no_grad():
    z = w @ x

try:
    z.backward()  # PyTorch vai lançar um erro aqui, pois z não tem acumulador de gradientes
except RuntimeError as e:
    print('RuntimeError!!! >:[')
    print(e)
```

<!--
## More stuff -- custom gradients
-->


## Mais coisas - gradientes personalizados

<!--Also, instead of basic numerical operations, we can generate our own self-defined modules / functions, which can be plugged into the neural graph. The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb).
-->

Além disso, em vez de operações numéricas básicas, podemos criar nossos próprios módulos / funções, que podem ser plugados no grafo da rede neural. O Jupyter Notebook pode ser encontrado [aqui](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/extra/b-custom_grads.ipynb).

<!--To do so, we need to inherit `torch.autograd.Function` and override `forward()` and `backward()` functions. For example, if we want to training nets, we need to get the forward pass and know the partial derivatives of the input respect to the output, such that we can use this module in any kind of point in the code. Then, by using back-propagation (chain rule), we can plug the thing anywhere in the chain of operations, as long as we know the partial derivatives of the input respect to the output.
-->

Para fazer isso, precisamos herdar `torch.autograd.Function` e substituir as funções `forward ()` e `backward()`. Por exemplo, se quisermos treinar redes, precisamos obter a passagem pelo *forward* e saber as derivadas parciais da entrada em relação à saída, de forma que possamos usar este módulo em qualquer tipo de ponto do código. Então, usando retropropagação (regra da cadeia), podemos conectar a coisa em qualquer lugar na cadeia de operações, desde que conheçamos as derivadas parciais da entrada em relação à saída.

<!--In this case, there are three examples of ***custom modules*** in the *notebook*, the `add`, `split`, and `max` modules. For example, the custom addition module:
-->

Neste caso, existem três exemplos de ***módulos personalizados*** no *notebook*, os módulos `add`,`split` e `max`. Por exemplo, o módulo de adição personalizado:

<!--```python
# Custom addition module
class MyAdd(torch.autograd.Function):

    @staticmethod
    def forward(ctx, x1, x2):
        # ctx is a context where we can save
        # computations for backward.
        ctx.save_for_backward(x1, x2)
        return x1 + x2

    @staticmethod
    def backward(ctx, grad_output):
        x1, x2 = ctx.saved_tensors
        grad_x1 = grad_output * torch.ones_like(x1)
        grad_x2 = grad_output * torch.ones_like(x2)
        # need to return grads in order
        # of inputs to forward (excluding ctx)
        return grad_x1, grad_x2
```
-->

```python
# Custom addition module
class MyAdd(torch.autograd.Function):

    @staticmethod
    def forward(ctx, x1, x2):
        # ctx is a context where we can save
        # computations for backward.
        ctx.save_for_backward(x1, x2)
        return x1 + x2

    @staticmethod
    def backward(ctx, grad_output):
        x1, x2 = ctx.saved_tensors
        grad_x1 = grad_output * torch.ones_like(x1)
        grad_x2 = grad_output * torch.ones_like(x2)
        # need to return grads in order
        # of inputs to forward (excluding ctx)
        return grad_x1, grad_x2
```

<!--If we have addition of two things and get an output, we need to overwrite the forward function like this. And when we go down to do back propagation, the gradients copied over both sides. So we overwrite the backward function by copying.
-->

Se adicionarmos duas coisas e obtivermos uma saída, precisamos sobrescrever a função forward desta forma. E quando descemos para fazer a propagação reversa, os gradientes são copiados em ambos os lados. Portanto, sobrescrevemos a função de retrocesso copiando.

<!--For `split` and `max`, see the code of how we overwrite forward and backward functions in the *notebook*. If we come from the same thing and **Split**, when go down doing gradients, we should add / sum them. For `argmax`, it selects the index of the highest thing, so the index of the highest should be $1$ while others being $0$. Remember, according to different custom modules, we need to overwrite its own forward pass and how they do gradients in backward function.
-->

Para `split` e `max`, veja o código de como sobrescrevemos as funções de avanço e retrocesso no *bloco de notas*. Se viermos da mesma coisa e **Dividir**, ao descermos fazendo gradientes, devemos somar / somar. Para `argmax`, ele seleciona o índice da coisa mais alta, então o índice da mais alta deve ser $1$ enquanto os outros devem ser $0$. Lembre-se, de acordo com diferentes módulos personalizados, precisamos sobrescrever sua própria passagem do *forward* e como eles fazem os gradientes na função *backward*.
