---
lang: pt
lang-ref: ch.05-2
title: Técnicas de Otimização II
lecturer: Aaron Defazio
authors: Guido Petri, Haoyue Ping, Chinmay Singhal, Divya Juneja
date: 24 Feb 2020
translator: Felipe Schiavon
translation-date: 14 Nov 2021
---

<!--
## [Adaptive methods](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s)
-->


## [Métodos Adaptativos](https://www.youtube.com/watch?v=--NZb480zlg&t=2675s) 

<!--SGD with momentum is currently the state of the art optimization method for a lot of ML problems. But there are other methods, generally called Adaptive Methods, innovated over the years that are particularly useful for poorly conditioned problems (if SGD does not work).
-->

Momento com SGD é atualmente o método de otimização de última geração para muitos problemas de aprendizagem de máquina. Mas existem outros métodos, geralmente chamados de Métodos Adaptativos, inovados ao longo dos anos que são particularmente úteis para problemas mal condicionados (se o SGD não funcionar).

<!--In the SGD formulation, every single weight in network is updated using an equation with the same learning rate (global $\gamma$). Here, for adaptive methods, we *adapt a learning rate for each weight individually*. For this purpose, the information we get from gradients for each weight is used.
-->

Na formulação SGD, cada peso na rede é atualizado usando uma equação com a mesma taxa de aprendizado  (global $\gamma$). Aqui, para métodos adaptativos, *adaptamos uma taxa de aprendizagem para cada peso individualmente*. Para tanto, são utilizadas as informações que obtemos dos gradientes para cada peso.

<!--Networks that are often used in practice have different structure in different parts of them. For instance, early parts of CNN may be very shallow convolution layers on large images and later in the network we might have convolutions of large number of channels on small images. Both of these operations are very different so a learning rate which works well for the beginning of the network may not work well for the latter sections of the network. This means adaptive learning rates by layer could be useful.
-->

As redes que são frequentemente usadas na prática têm estruturas diferentes em diferentes partes delas. Por exemplo, partes iniciais da CNN podem ser camadas de convolução muito rasas em imagens grandes e, posteriormente, na rede, podemos ter convoluções de grande número de canais em imagens pequenas. Ambas as operações são muito diferentes, portanto, uma taxa de aprendizado que funciona bem para o início da rede pode não funcionar bem para as últimas seções da rede. Isso significa que as taxas de aprendizagem adaptativa por camada podem ser úteis.

<!--Weights in the latter part of the network (4096 in figure 1 below) directly dictate the output and have a very strong effect on it. Hence, we need smaller learning rates for those. In contrast, earlier weights will have smaller individual effects on the output, especially when initialized randomly.
-->

Os pesos na última parte da rede (4096 na figura 1 abaixo) ditam diretamente a saída e têm um efeito muito forte sobre ela. Portanto, precisamos de taxas de aprendizado menores para eles. Em contraste, pesos anteriores terão efeitos individuais menores na saída, especialmente quando inicializados aleatoriamente.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>Figure 1: </b>VGG16
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_vgg.png" style="zoom:40%"><br>
<b>Figure 1: </b>VGG16
</center>

<!--
### RMSprop
-->


### RMSprop

<!--The key idea of *Root Mean Square Propagation* is that the gradient is normalized by its root-mean-square.
-->

A ideia principal da *Propagação da raiz do valor quadrático médio* (*Root Mean Square Propagation*) é que o gradiente é normalizado por sua raiz quadrada média.

<!--In the equation below, squaring the gradient denotes that each element of the vector is squared individually.
-->

Na equação abaixo, elevar ao quadrado o gradiente denota que cada elemento do vetor é elevado ao quadrado individualmente.

<!--$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$
-->

$$
\begin{aligned}
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {\nabla f_i(w_t)}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!--where $\gamma$ is the global learning rate, $\epsilon$ is a value close to machine $\epsilon$ (on the order of $10^{-7}$ or  $10^{-8}$) -- in order to avoid division by zero errors, and $v_{t+1}$ is the 2nd moment estimate.
-->

onde $\gamma$ é a taxa de aprendizagem global,  $\epsilon$ é um valor próximo a máquina  $\epsilon$ (na ordem de $10^{-7}$ ou $10^{-8}$) - na ordem para evitar erros de divisão por zero, e $v_{t+1}$ é a estimativa do segundo momento.

<!--We update $v$ to estimate this noisy quantity via an *exponential moving average* (which is a standard way of maintaining an average of a quantity that may change over time). We need to put larger weights on the newer values as they provide more information. One way to do that is down-weight old values exponentially. The values in the $v$ calculation that are very old are down-weighted at each step by an $\alpha$ constant, which varies between 0 and 1. This dampens the old values until they are no longer an important part of the exponential moving average.
-->

Atualizamos $v$ para estimar essa quantidade ruidosa por meio de uma *média móvel exponencial* (que é uma maneira padrão de manter uma média de uma quantidade que pode mudar com o tempo). Precisamos colocar pesos maiores nos valores mais novos, pois eles fornecem mais informações. Uma maneira de fazer isso é reduzir exponencialmente os valores antigos. Os valores no cálculo de $v$ que são muito antigos são reduzidos a cada etapa por uma constante $\alpha$, que varia entre 0 e 1. Isso amortece os valores antigos até que eles não sejam mais uma parte importante do exponencial média móvel.

<!--The original method keeps an exponential moving average of a non-central second moment, so we don't subtract the mean here. The *second moment* is used to normalize the gradient element-wise, which means that every element of the gradient is divided by the square root of the second moment estimate. If the expected value of gradient is small, this process is similar to dividing the gradient by the standard deviation.
-->

O método original mantém uma média móvel exponencial de um segundo momento não central, portanto, não subtraímos a média aqui. O *segundo momento* é usado para normalizar o gradiente em termos de elemento, o que significa que cada elemento do gradiente é dividido pela raiz quadrada da estimativa do segundo momento. Se o valor esperado do gradiente for pequeno, esse processo é semelhante a dividir o gradiente pelo desvio padrão.

<!--Using a small $\epsilon$ in the denominator doesn't diverge because when $v$ is very small, the momentum is also very small.
-->

Usar um $\epsilon$ pequeno no denominador não diverge porque quando $v$ é muito pequeno, o momento também é muito pequeno.

<!--
### ADAM
-->


### ADAM

<!--ADAM, or *Adaptive Moment Estimation*, which is RMSprop plus momentum, is a more commonly used method. The momentum update is converted to an exponential moving average and we don't need to change the learning rate when we deal with $\beta$. Just as in RMSprop, we take an exponential moving average of the squared gradient here.
-->

ADAM, ou *Estimativa Adaptativa do Momento*, que é RMSprop mais o Momento, é o método mais comumente usado. A atualização do Momento é convertida em uma média móvel exponencial e não precisamos alterar a taxa de aprendizagem quando lidamos com $\beta$. Assim como no RMSprop, pegamos uma média móvel exponencial do gradiente quadrado aqui.

<!--$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$
-->

$$
\begin{aligned}
m_{t+1} &= {\beta}m_t + (1 - \beta) \nabla f_i(w_t) \\
v_{t+1} &= {\alpha}v_t + (1 - \alpha) \nabla f_i(w_t)^2 \\
w_{t+1} &=  w_t - \gamma \frac {m_{t}}{ \sqrt{v_{t+1}} + \epsilon}
\end{aligned}
$$

<!--where $m_{t+1}$ is the momentum's exponential moving average.
-->

onde $m_{t+1}$ é a média móvel exponencial do momento.

<!--Bias correction that is used to keep the moving average unbiased during early iterations is not shown here.
-->

A correção de viés que é usada para manter a média móvel imparcial durante as iterações iniciais não é mostrada aqui.

<!--
### Practical side
-->


### Lado Prático

<!--When training neural networks, SGD often goes in the wrong direction in the beginning of the training process, whereas RMSprop hones in on the right direction. However, RMSprop suffers from noise just as regular SGD, so it bounces around the optimum significantly once it's close to a local minimizer. Just like when we add momentum to SGD, we get the same kind of improvement with ADAM. It is a good, not-noisy estimate of the solution, so **ADAM is generally recommended over RMSprop**.
-->

Ao treinar redes neurais, o SGD geralmente vai na direção errada no início do processo de treinamento, enquanto o RMSprop aprimora a direção certa. No entanto, o RMSprop sofre de ruído da mesma forma que o SGD normal, então ele oscila em torno do ótimo significativamente quando está perto de um minimizador local. Assim como quando adicionamos impulso ao SGD, obtemos o mesmo tipo de melhoria com o ADAM. É uma estimativa boa e não ruidosa da solução, portanto **ADAM é geralmente recomendado em vez de RMSprop**.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>Figure 2: </b> SGD *vs.* RMSprop *vs.* ADAM
</center><br>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comparison.png" style="zoom:45%"><br>
<b>Figure 2: </b> SGD *vs.* RMSprop *vs.* ADAM
</center><br>

<!--ADAM is necessary for training some of the networks for using language models. For optimizing neural networks, SGD with momentum or ADAM is generally preferred. However, ADAM's theory in papers is poorly understood and it also has several disadvantages:
-->

O ADAM é necessário para treinar algumas das redes para usar modelos de linguagem. Para otimizar redes neurais, SGD com momentum ou ADAM é geralmente preferido. No entanto, a teoria do ADAM em artigos é mal compreendida e também tem várias desvantagens:

<!--* It can be shown on very simple test problems that the method does not converge.
* It is known to give generalization errors. If the neural network is trained to give zero loss on the data you trained it on, it will not give zero loss on other data points that it has never seen before. It is quite common, particularly on image problems, that we get worse generalization errors than when SGD is used. Factors could include that it finds the closest local minimum, or less noise in ADAM, or its structure, for instance.
* With ADAM we need to maintain 3 buffers, whereas SGD needs 2 buffers. This doesn't really matter unless we train a model on the order of several gigabytes in size, in which case it might not fit in memory.
* 2 momentum parameters need to be tuned instead of 1.
-->

* Pode ser mostrado em problemas de teste muito simples que o método não converge.
* É conhecido por fornecer erros de generalização. Se a rede neural for treinada para fornecer perda zero nos dados em que você a treinou, ela não fornecerá perda zero em outros pontos de dados que nunca viu antes. É bastante comum, principalmente em problemas de imagem, obtermos erros de generalização piores do que quando se usa SGD. Os fatores podem incluir que ele encontre o mínimo local mais próximo, ou menos ruído no ADAM, ou sua estrutura, por exemplo.
* Com o ADAM, precisamos manter 3 buffers, enquanto o SGD precisa de 2 buffers. Isso realmente não importa, a menos que treinemos um modelo da ordem de vários gigabytes de tamanho; nesse caso, ele pode não caber na memória.
* 2 parâmetros de momentum precisam ser ajustados em vez de 1.

<!--
## [Normalization layers](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)
-->


## [Camadas de Normalização](https://www.youtube.com/watch?v=--NZb480zlg&t=3907s)

<!--Rather than improving the optimization algorithms, *normalization layers* improve the network structure itself. They are additional layers in between existing layers. The goal is to improve the optimization and generalization performance.
-->

Em vez de melhorar os algoritmos de otimização, as *camadas de normalização* melhoram a própria estrutura da rede. Eles são camadas adicionais entre as camadas existentes. O objetivo é melhorar o desempenho de otimização e generalização.

<!--In neural networks, we typically alternate linear operations with non-linear operations. The non-linear operations are also known as activation functions, such as ReLU. We can place normalization layers before the linear layers, or after the activation functions. The most common practice is to put them between the linear layers and activation functions, as in the figure below.
-->

Em redes neurais, normalmente alternamos operações lineares com operações não lineares. As operações não lineares também são conhecidas como funções de ativação, como ReLU. Podemos colocar camadas de normalização antes das camadas lineares ou após as funções de ativação. A prática mais comum é colocá-los entre as camadas lineares e as funções de ativação, como na figura abaixo.

<!--| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) Before adding normalization                              |                (b) After adding normalization                |                    (c) An example in CNNs                    |
-->

| <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_a.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_b.png" width="200px"/></center> | <center><img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_layer_c.png" width="225px"/></center> |
| (a) Antes de adicionar a normalização                              |                (b) Depois de adicionar a normalização                |                    (c) Um exemplo em CNNs                    |

<!--<center><b>Figure 3:</b> Typical positions of normalization layers.</center>
-->

<center><b>Figura 3:</b> Posições típicas de camadas de normalização.</center>

<!--In figure 3(c), the convolution is the linear layer, followed by batch normalization, followed by ReLU.
-->

Na figura 3 (c), a convolução é a camada linear, seguida pela normalização do lote, seguida por ReLU.

<!--Note that the normalization layers affect the data that flows through, but they don't change the power of the network in the sense that, with proper configuration of the weights, the unnormalized network can still give the same output as a normalized network.
-->

Observe que as camadas de normalização afetam os dados que fluem, mas não alteram o poder da rede no sentido de que, com a configuração adequada dos pesos, a rede não normalizada ainda pode dar a mesma saída que uma rede normalizada.

<!--
### Normalization operations
-->


### Operações de normalização

<!--This is the generic notation for normalization:
-->

Esta é a notação genérica para normalização:

<!--$$
y = \frac{a}{\sigma}(x - \mu) + b
$$
-->

$$
y = \frac{a}{\sigma}(x - \mu) + b
$$

<!--where $x$ is the input vector, $y$ is the output vector, $\mu$ is the estimate of the mean of $x$, $\sigma$ is the estimate of the standard deviation (std) of $x$, $a$ is the learnable scaling factor, and $b$ is the learnable bias term.
-->

onde $x$ é o vetor de entrada, $y$ é o vetor de saída, $\mu$ é a estimativa da média de $x$, $\sigma$ é a estimativa do desvio padrão (std) de $x$ , $a$ é o fator de escala que pode ser aprendido e $b$ é o termo de polarização que pode ser aprendido.

<!--Without the learnable parameters $a$ and $b$, the distribution of output vector $y$ will have fixed mean 0 and std 1. The scaling factor $a$ and bias term $b$ maintain the representation power of the network,*i.e.*the output values can still be over any particular range. Note that $a$ and $b$ do not reverse the normalization, because they are learnable parameters and are much more stable than $\mu$ and $\sigma$.
-->

Sem os parâmetros aprendíveis $a$ e $b$, a distribuição do vetor de saída $y$ terá média fixa 0 e padrão 1. O fator de escala $a$ e o termo de polarização $b$ mantêm o poder de representação da rede, *ou seja,* os valores de saída ainda podem estar acima de qualquer faixa específica. Observe que $a$ e $b$ não invertem a normalização, porque eles são parâmetros aprendíveis e são muito mais estáveis do que $\mu$ e $\sigma$.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4:</b> Normalization operations.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_norm_operations.png"/><br>
<b>Figure 4:</b> Operações de Normalização.
</center>

<!--There are several ways to normalize the input vector, based on how to select samples for normalization. Figure 4 lists 4 different normalization approaches, for a mini-batch of $N$ images of height $H$ and width $W$, with $C$ channels:
-->

Existem várias maneiras de normalizar o vetor de entrada, com base em como selecionar amostras para normalização. A Figura 4 lista 4 abordagens diferentes de normalização, para um minilote de $N$ imagens de altura $H$ e largura $W$, com canais $C$:

<!--- *Batch norm*: the normalization is applied only over one channel of the input. This is the first proposed and the most well-known approach. Please read [How to Train Your ResNet 7: Batch Norm](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) for more information.
- *Layer norm*: the normalization is applied within one image across all channels.
- *Instance norm*: the normalization is applied only over one image and one channel.
- *Group norm*: the normalization is applied over one image but across a number of channels. For example, channel 0 to 9 is a group, then channel 10 to 19 is another group, and so on. In practice, the group size is almost always 32. This is the approach recommended by Aaron Defazio, since it has good performance in practice and it does not conflict with SGD.
-->

- *Normalização em lote (Batch Norm)*: a normalização é aplicada apenas em um canal da entrada. Esta é a primeira proposta e a abordagem mais conhecida. Leia [Como treinar seu ResNet 7: norma de lote](https://myrtle.ai/learn/how-to-train-your-resnet-7-batch-norm/) para obter mais informações.
- *Normalização de camada (Layer Norm)*: a normalização é aplicada dentro de uma imagem em todos os canais.
- *Normalização de instância (Instance Norm)*: a normalização é aplicada apenas sobre uma imagem e um canal.
- *Normalização de grupo (Group Norm)*: a normalização é aplicada sobre uma imagem, mas em vários canais. Por exemplo, os canais 0 a 9 são um grupo, os canais 10 a 19 são outro grupo e assim por diante. Na prática, o tamanho do grupo é quase sempre de 32. Essa é a abordagem recomendada por Aaron Defazio, pois tem um bom desempenho na prática e não conflita com o SGD.

<!--In practice, batch norm and group norm work well for computer vision problems, while layer norm and instance norm are heavily used for language problems.
-->

Na prática, a norma de lote e a norma de grupo funcionam bem para problemas de visão computacional, enquanto a norma de camada e a norma de instância são muito usadas para problemas de linguagem.

<!--
### Why does normalization help?
-->


### Por que a normalização ajuda?

<!--Although normalization works well in practice, the reasons behind its effectiveness are still disputed. Originally, normalization is proposed to reduce "internal covariate shift", but some scholars proved it wrong in experiments. Nevertheless, normalization clearly has a combination of the following factors:
-->

Embora a normalização funcione bem na prática, as razões por trás de sua eficácia ainda são contestadas. Originalmente, a normalização é proposta para reduzir a "mudança interna da covariável" ("internal covariate shift"), mas alguns estudiosos provaram que estava errada em experimentos. No entanto, a normalização claramente tem uma combinação dos seguintes fatores:

<!--- Networks with normalization layers are easier to optimize, allowing for the use of larger learning rates. Normalization has an optimization effect that speeds up the training of neural networks.
- The mean/std estimates are noisy due to the randomness of the samples in batch. This extra "noise" results in better generalization in some cases. Normalization has a regularization effect.
- Normalization reduces sensitivity to weight initialization.
-->

- Redes com camadas de normalização são mais fáceis de otimizar, permitindo o uso de maiores taxas de aprendizado. A normalização tem um efeito de otimização que acelera o treinamento das redes neurais.
- As estimativas de média/padrão são ruidosas devido à aleatoriedade das amostras no lote. Este "ruído" extra resulta em melhor generalização em alguns casos. A normalização tem um efeito de regularização.
- A normalização reduz a sensibilidade à inicialização do peso.

<!--As a result, normalization lets you be more "careless" -- you can combine almost any neural network building blocks together and have a good chance of training it without having to consider how poorly conditioned it might be.
-->

Como resultado, a normalização permite que você seja mais "descuidado" - você pode combinar quase todos os blocos de construção de rede neural e ter uma boa chance de treiná-la sem ter que considerar o quão mal condicionada ela pode estar.

<!--
### Practical considerations
-->


### Considerações práticas

<!--It’s important that back-propagation is done through the calculation of the mean and std, as well as the application of the normalization: the network training will diverge otherwise. The back-propagation calculation is fairly difficult and error-prone, but PyTorch is able to automatically calculate it for us, which is very helpful. Two normalization layer classes in PyTorch are listed below:
-->

É importante que a retropropagação seja feita por meio do cálculo da média e do padrão, bem como a aplicação da normalização: o treinamento da rede irá divergir de outra forma. O cálculo da propagação reversa é bastante difícil e sujeito a erros, mas o PyTorch é capaz de calculá-lo automaticamente para nós, o que é muito útil. Duas classes de camada de normalização em PyTorch estão listadas abaixo:

<!--```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```
-->

```python
torch.nn.BatchNorm2d(num_features, ...)
torch.nn.GroupNorm(num_groups, num_channels, ...)
```

<!--Batch norm was the first method developed and is the most widely known. However, **Aaron Defazio recommends using group norm** instead. It’s more stable, theoretically simpler, and usually works better. Group size 32 is a good default.
-->

A normalização em lote (batch norm) foi o primeiro método desenvolvido e é o mais amplamente conhecido. No entanto, **Aaron Defazio recomenda usar a normalização de grupo (group norm)** ao invés da primeira. Ele é mais estável, teoricamente mais simples e geralmente funciona melhor. O tamanho do grupo 32 é um bom padrão.

<!--Note that for batch norm and instance norm, the mean/std used are fixed after training, rather than re-computed every time the network is evaluated, because multiple training samples are needed to perform normalization. This is not necessary for group norm and layer norm, since their normalization is over only one training sample.
-->

Observe que para normalização em lote e normalização de instância, a média/padrão usada é fixada após o treinamento, em vez de recalculada toda vez que a rede é avaliada, porque várias amostras de treinamento são necessárias para realizar a normalização. Isso não é necessário para normalização de grupo e normalização de camada, uma vez que sua normalização é sobre apenas uma amostra de treinamento.

<!--
## [The Death of Optimization](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)
-->


## [A morte da otimização](https://www.youtube.com/watch?v=--NZb480zlg&t=4817s)

<!--Sometimes we can barge into a field we know nothing about and improve how they are currently implementing things. One such example is the use of deep neural networks in the field of Magnetic Resonance Imaging (MRI) to accelerate MRI image reconstruction.
-->

Às vezes, podemos invadir um campo sobre o qual nada sabemos e melhorar a forma como eles estão implementando as coisas. Um exemplo é o uso de redes neurais profundas no campo da exames de Ressonância Magnética (MRI) para acelerar a reconstrução de imagens de MRI.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figure 5:</b> Sometimes it actually works!
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_conv_xkcd.png" style="zoom:60%"><br>
<b>Figure 5:</b> Às vezes realmente funciona!
</center>

<!--
### MRI Reconstruction
-->


### Reconstrução de Ressonância Magnética

<!--In the traditional MRI reconstruction problem, raw data is taken from an MRI machine and an image is reconstructed from it using a simple pipeline/algorithm. MRI machines capture data in a 2-dimensional Fourier domain, one row or one column at a time (every few milliseconds). This raw input is composed of a frequency and a phase channel and the value represents the magnitude of a sine wave with that particular frequency and phase. Simply speaking, it can be thought of as a complex valued image, having a real and an imaginary channel. If we apply an inverse Fourier transform on this input, i.e add together all these sine waves weighted by their values, we can get the original anatomical image.
-->

No problema de reconstrução tradicional de exames de ressonância magnética (MRI), os dados brutos são obtidos de uma máquina de MRI e uma imagem é reconstruída a partir dele usando um pipeline/algoritmo simples. As máquinas de ressonância magnética capturam dados em um domínio de Fourier bidimensional, uma linha ou uma coluna por vez (a cada poucos milissegundos). Esta entrada bruta é composta por uma frequência e um canal de fase e o valor representa a magnitude de uma onda senoidal com aquela frequência e fase específicas. Em termos simples, pode ser pensada como uma imagem de valor complexo, possuindo um canal real e outro imaginário. Se aplicarmos uma transformada inversa de Fourier nesta entrada, ou seja, somarmos todas essas ondas senoidais ponderadas por seus valores, podemos obter a imagem anatômica original.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Fig. 6:</b> MRI reconstruction
</center><br>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_mri.png" style="zoom:60%"/><br>
<b>Fig. 6:</b> Reconstrução de ressonância magnética
</center><br>

<!--A linear mapping currently exists to go from the Fourier domain to the image domain and it's very efficient, literally taking milliseconds, no matter how big the image is. But the question is, can we do it even faster?
-->

Existe atualmente um mapeamento linear para ir do domínio de Fourier ao domínio da imagem e é muito eficiente, levando literalmente milissegundos, não importa o tamanho da imagem. Mas a questão é: podemos fazer isso ainda mais rápido?

<!--
### Accelerated MRI
-->


### Ressonância magnética acelerada

<!--The new problem that needs to be solved is accelerated MRI, where by acceleration we mean making the MRI reconstruction process much faster. We want to run the machines quicker and still be able to produce identical quality images. One way we can do this and the most successful way so far has been to not capture all the columns from the MRI scan. We can skip some columns randomly, though it's useful in practice to capture the middle columns, as they contain a lot of information across the image, but outside them we just capture randomly. The problem is that we can't use our linear mapping anymore to reconstruct the image. The rightmost image in Figure 7 shows the output of a linear mapping applied to the subsampled Fourier space. It's clear that this method doesn't give us very useful outputs, and that there's room to do something a little bit more intelligent.
-->

O novo problema que precisa ser resolvido é a ressonância magnética acelerada, onde por aceleração queremos dizer tornar o processo de reconstrução por ressonância magnética muito mais rápido. Queremos operar as máquinas mais rapidamente e ainda ser capazes de produzir imagens de qualidade idêntica. Uma maneira de fazer isso e a maneira mais bem-sucedida até agora tem sido não capturar todas as colunas da varredura de ressonância magnética. Podemos pular algumas colunas aleatoriamente, embora seja útil na prática capturar as colunas do meio, pois elas contêm muitas informações na imagem, mas fora delas apenas capturamos aleatoriamente. O problema é que não podemos mais usar nosso mapeamento linear para reconstruir a imagem. A imagem mais à direita na Figura 7 mostra a saída de um mapeamento linear aplicado ao espaço de Fourier subamostrado. É claro que esse método não nos dá resultados muito úteis e que há espaço para fazer algo um pouco mais inteligente.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Fig.:</b> Linear mapping on subsampled Fourier-space
</center><br>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_acc_mri.png" style="zoom:45%"><br>
<b>Fig.:</b> Mapeamento linear no espaço de Fourier subamostrado
</center><br>

<!--
### Compressed sensing
-->


### Compressed sensing

<!--One of the biggest breakthroughs in theoretical mathematics for a long time was compressed sensing. A paper by <a href="https://arxiv.org/pdf/math/0503066.pdf">Candes et al.</a> showed that theoretically, we can get a perfect reconstruction from the subsampled Fourier-domain image. In other words, when the signal we are trying to reconstruct is sparse or sparsely structured, then it is possible to perfectly reconstruct it from fewer measurements. But there are some practical requirements for this to work -- we don't need to sample randomly, rather we need to sample incoherently -- though in practice, people just end up sampling randomly. Additionally, it takes the same time to sample a full column or half a column, so in practice we also sample entire columns.
-->

Um dos maiores avanços na matemática teórica por muito tempo foi o sensoriamento comprimido. Um artigo de <a href="https://arxiv.org/pdf/math/0503066.pdf"> Candes et al. </a> mostrou que, teoricamente, podemos obter uma reconstrução perfeita a partir da subamostra da imagem do domínio de Fourier . Em outras palavras, quando o sinal que estamos tentando reconstruir é esparso ou esparsamente estruturado, então é possível reconstruí-lo perfeitamente a partir de menos medições. Mas existem alguns requisitos práticos para que isso funcione - não precisamos amostrar aleatoriamente, em vez disso, precisamos amostrar incoerentemente - embora, na prática, as pessoas acabem apenas amostrando aleatoriamente. Além disso, leva o mesmo tempo para amostrar uma coluna inteira ou meia coluna, portanto, na prática, também amostramos colunas inteiras.

<!--Another condition is that we need to have *sparsity* in our image, where by sparsity we mean a lot of zeros or black pixels in the image. The raw input can be represented sparsely if we do a wavelength decomposition, but even this decomposition gives us an approximately sparse and not an exactly sparse image. So, this approach gives us a pretty good but not perfect reconstruction, as we can see in Figure 8. However, if the input were very sparse in the wavelength domain, then we would definitely get a perfect image.
-->

Outra condição é que precisamos ter *esparsidade* em nossa imagem, onde por esparsidade queremos dizer muitos zeros ou pixels pretos na imagem. A entrada bruta pode ser representada esparsamente se fizermos uma decomposição do comprimento de onda, mas mesmo essa decomposição nos dá uma imagem aproximadamente esparsa e não exatamente esparsa. Portanto, essa abordagem nos dá uma reconstrução muito boa, mas não perfeita, como podemos ver na Figura 8. No entanto, se a entrada fosse muito esparsa no domínio do comprimento de onda, com certeza obteríamos uma imagem perfeita.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figure 8: </b>Compressed sensing
</center><br>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_comp_sensing.png" style="zoom:50%"><br>
<b>Figure 8: </b>Sensoriamento comprimido
</center><br>

<!--Compressed sensing is based on the theory of optimization. The way we can get this reconstruction is by solving a mini-optimization problem which has an additional regularization term:
-->

O sensoriamento comprimido é baseado na teoria da otimização. A maneira como podemos obter essa reconstrução é resolvendo um problema de mini-otimização que tem um termo de regularização adicional:

<!--$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$
-->

$$
\hat{x} = \arg\min_x \frac{1}{2} \Vert M (\mathcal{F}(x)) - y \Vert^2 + \lambda TV(x)
$$

<!--where $M$ is the mask function that zeros out non-sampled entries, $\mathcal{F}$ is the Fourier transform, $y$ is the observed Fourier-domain data, $\lambda$ is the regularization penalty strength, and $V$ is the regularization function.
-->

onde $M$ é a função de máscara que zera as entradas não amostradas, $\mathcal{F}$ é a transformação de Fourier, $y$ são os dados observados do domínio de Fourier, $\lambda$ é a força da penalidade de regularização e $V$ é a função de regularização.

<!--The optimization problem must be solved for each time step or each "slice" in an MRI scan, which often takes much longer than the scan itself. This gives us another reason to find something better.
-->

O problema de otimização deve ser resolvido para cada etapa de tempo ou cada "fatia" em uma ressonância magnética, que geralmente leva muito mais tempo do que a própria varredura. Isso nos dá outro motivo para encontrar algo melhor.

<!--
### Who needs optimization?
-->


### Quem precisa de otimização?

<!--Instead of solving the little optimization problem at every time step, why not use a big neural network to produce the required solution directly? Our hope is that we can train a neural network with sufficient complexity that it essentially solves the optimization problem in one step and produces an output that is as good as the solution obtained from solving the optimization problem at each time step.
-->

Em vez de resolver o pequeno problema de otimização em cada etapa do tempo, por que não usar uma grande rede neural para produzir a solução necessária diretamente? Nossa esperança é que possamos treinar uma rede neural com complexidade suficiente para que essencialmente resolva o problema de otimização em uma etapa e produza uma saída que seja tão boa quanto a solução obtida ao resolver o problema de otimização em cada etapa de tempo.

<!--$$
\hat{x} = B(y)
$$
-->

$$
\hat{x} = B(y)
$$

<!--where $B$ is our deep learning model and $y$ is the observed Fourier-domain data.
-->

onde $B$ é o nosso modelo de aprendizado profundo e $y$ são os dados observados do domínio de Fourier.

<!--15 years ago, this approach was difficult -- but nowadays this is a lot easier to implement. Figure 9 shows the result of a deep learning approach to this problem and we can see that the output is much better than the compressed sensing approach and looks very similar to the actual scan.
-->

Há 15 anos, essa abordagem era difícil - mas hoje em dia é muito mais fácil de implementar. A Figura 9 mostra o resultado de uma abordagem de aprendizado profundo para esse problema e podemos ver que a saída é muito melhor do que a abordagem de detecção compactada e é muito semelhante ao exame de imagem real.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9: </b>Deep Learning approach
</center><br>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-2/5_2_dl_approach.png" style="zoom:60%"><br>
<b>Figure 9: </b>Abordagem com aprendizado profundo
</center><br>

<!--The model used to generate this reconstruction uses an ADAM optimizer, group-norm normalization layers, and a U-Net based convolutional neural network. Such an approach is very close to practical applications and we will hopefully be seeing these accelerated MRI scans happening in clinical practice in a few years' time.
-->

O modelo usado para gerar essa reconstrução usa um otimizador ADAM, camadas de normalização de norma de grupo e uma rede neural convolucional baseada em U-Net. Essa abordagem está muito próxima de aplicações práticas e esperamos ver esses exames de ressonância magnética acelerados acontecendo na prática clínica em alguns anos.