---
lang: pt
lang-ref: ch.05-1
title: Técnicas de Otimização I
lecturer: Aaron Defazio
authors: Vaibhav Gupta, Himani Shah, Gowri Addepalli, Lakshmi Addepalli
date: 24 Feb 2020
translation-date: 06 Nov 2021
translator: Felipe Schiavon
---

<!--
## [Gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)
-->


## [Gradiente Descendente](https://www.youtube.com/watch?v=--NZb480zlg&t=88s)

<!--We start our study of Optimization Methods with the most basic and the worst (reasoning to follow) method of the lot, Gradient Descent.
-->

Começamos nosso estudo de Métodos de Otimização com o pior e mais básico método (raciocínio a seguir) do lote, o Gradiente Descendente.

<!--**Problem:**
-->

**Problema:**

<!--$$
\min_w f(w)
$$
-->

$$
\min_w f(w)
$$

<!--**Iterative Solution:**
-->

**Solução Iterativa:**

<!--$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$
-->

$$
w_{k+1} = w_k - \gamma_k \nabla f(w_k)
$$

<!--where,
 - $w_{k+1}$ is the updated value after the $k$-th iteration,
 - $w_k$ is the initial value before the $k$-th iteration,
 - $\gamma_k$ is the step size,
 - $\nabla f(w_k)$ is the gradient of $f$.
-->

onde,
 - $w_{k+1}$ é o valor atualizado depois da $k$-ésima iteração,
 - $w_k$ é o valor inicial antes da $k$-ésima iteração,
 - $\gamma_k$ é o tamanho do passo,
 - $\nabla f(w_k)$ é o gradiente de $f$.

<!--The assumption here is that the function $f$ is continuous and differentiable. Our aim is to find the lowest point (valley) of the optimization function. However, the actual direction to this valley is not known. We can only look locally, and therefore the direction of the negative gradient is the best information that we have. Taking a small step in that direction can only take us closer to the minimum. Once we have taken the small step, we again compute the new gradient and again move a small amount in that direction, till we reach the valley. Therefore, essentially all that the gradient descent is doing is following the direction of steepest descent (negative gradient).
-->

A suposição aqui é que a função $f$ é contínua e diferenciável. Nosso objetivo é encontrar o ponto mais baixo (vale) da função de otimização. No entanto, a direção real para este vale não é conhecida. Só podemos olhar localmente e, portanto, a direção do gradiente negativo é a melhor informação que temos. Dar um pequeno passo nessa direção só pode nos levar mais perto do mínimo. Assim que tivermos dado o pequeno passo, calculamos novamente o novo gradiente e novamente nos movemos um pouco nessa direção, até chegarmos ao vale. Portanto, basicamente tudo o que o gradiente descendente está fazendo é seguir a direção da descida mais acentuada (gradiente negativo).

<!--The $\gamma$ parameter in the iterative update equation is called the **step size**. Generally we don't know the value of the optimal step-size; so we have to try different values. Standard practice is to try a bunch of values on a log-scale and then use the best one. There are a few different scenarios that can occur. The image above depicts these scenarios for a 1D quadratic. If the learning rate is too low, then we would make steady progress towards the minimum. However, this might take more time than what is ideal. It is generally very difficult (or impossible) to get a step-size that would directly take us to the minimum. What we would ideally want is to have a step-size a little larger than the optimal. In practice, this gives the quickest convergence. However, if we use too large a learning rate, then the iterates get further and further away from the minima and we get divergence. In practice, we would want to use a learning rate that is just a little less than diverging.
-->

O parâmetro $\gamma$ na equação de atualização iterativa é chamado de **tamanho do passo**. Geralmente não sabemos o valor do tamanho ideal do passo; então temos que tentar valores diferentes. A prática padrão é tentar vários valores em uma escala logarítmica e, a seguir, usar o melhor valor. Existem alguns cenários diferentes que podem ocorrer. A imagem acima descreve esses cenários para uma função de erro quadrática de uma dimensão (1D). Se a taxa de aprendizado for muito baixa, faremos um progresso constante em direção ao mínimo. No entanto, isso pode levar mais tempo do que o ideal. Geralmente é muito difícil (ou impossível) obter um tamanho de passo que nos leve diretamente ao mínimo. O que desejaríamos idealmente é ter um tamanho de degrau um pouco maior do que o ideal. Na prática, isso dá a convergência mais rápida. No entanto, se usarmos uma taxa de aprendizado muito grande, as iterações se distanciam cada vez mais dos mínimos e obtemos divergência. Na prática, gostaríamos de usar uma taxa de aprendizado um pouco menor do que divergente.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Step sizes for 1D Quadratic
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-1/step-size.png" style="zoom: 70%; background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Tamanhos dos passos para função de erro quadrática de uma dimensão (1D)
</center>

<!--
## [Stochastic gradient descent](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)
-->


## [Gradiente Descendente Estocástico](https://www.youtube.com/watch?v=--NZb480zlg&t=898s)

<!--In Stochastic Gradient Descent, we replace the actual gradient vector with a stochastic estimation of the gradient vector. Specifically for a neural network, the stochastic estimation means the gradient of the loss for a single data point (single instance).
-->

No Gradiente Descendente Estocástico, substituímos o vetor gradiente real por uma estimativa estocástica do vetor gradiente. Especificamente para uma rede neural, a estimativa estocástica significa o gradiente da perda para um único ponto dos dados (única instância).

<!--Let $f_i$ denote the loss of the network for the $i$-th instance.
-->

Seja $f_i$ a perda da rede para a $i$-ésima instância.

<!--$$
f_i = l(x_i, y_i, w)
$$
-->

$$
f_i = l(x_i, y_i, w)
$$

<!--The function that we eventually want to minimize is $f$, the total loss over all instances.
-->

A função que queremos minimizar é $f$, a perda total de todas as instâncias.

<!--$$
f = \frac{1}{n}\sum_i^n f_i
$$
-->

$$
f = \frac{1}{n}\sum_i^n f_i
$$

<!--In SGD, we update the weights according to the gradient over $f_i$ (as opposed to the gradient over the total loss $f$).
-->


No SGD, atualizamos os pesos de acordo com o gradiente sobre $f_i$ (em oposição ao gradiente sobre a perda total $f$).

<!--$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i chosen uniformly at random)}
\end{aligned}
$$
-->

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k \nabla f_i(w_k) & \quad\text{(i escolhido uniformemente ao acaso)}
\end{aligned}
$$

<!--If $i$ is chosen randomly, then $f_i$ is a noisy but unbiased estimator of $f$, which is mathematically written as:
-->

Se $i$ for escolhido aleatoriamente, então $f_i$ é um estimador com ruído, mas sem viés, de $f$, que é matematicamente escrito como:

<!--$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$
-->

$$
\mathbb{E}[\nabla f_i(w_k)] = \nabla f(w_k)
$$

<!--As a result of this, the expected $k$-th step of SGD is the same as the $k$-th step of full gradient descent:
-->

Como resultado disso, a $k$-ésima etapa esperada do SGD é a mesma que a $k$-ésima etapa da Gradiente Descendente completo:

<!--$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$
-->

$$
\mathbb{E}[w_{k+1}] = w_k - \gamma_k \mathbb{E}[\nabla f_i(w_k)] = w_k - \gamma_k \nabla f(w_k)
$$

<!--Thus, any SGD update is the same as full-batch update in expectation. However, SGD is not just faster gradient descent with noise. Along with being faster, SGD can also get us better results than full-batch gradient descent. The noise in SGD can help us avoid the shallow local minima and find a better (deeper) minima. This phenomenon is called **annealing**.
-->

Portanto, qualquer atualização do SGD é igual à atualização de lote completo em expectativa. No entanto, o SGD não é apenas um gradiente descendente mais rápida com algum ruído. Além de ser mais rápido, o SGD também pode nos dar melhores resultados do que o gradiente descendente completo. O ruído no SGD pode nos ajudar a evitar os mínimos locais superficiais e a encontrar mínimos melhores (mais profundos). Este fenômeno é denominado **recozimento** (**annealing**).

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Figure 2:</b> Annealing with SGD
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-1/annealing.png"/><br>
<b>Figure 2:</b> Recozimento com SGD
</center>

<!--In summary, the advantages of Stochastic Gradient Descent are as follows:
-->

Em resumo, as vantagens do Gradiente Descendente Estocástico são as seguintes:

<!-- 1. There is a lot of redundant information across instances. SGD prevents a lot of these redundant computations.
 2. At early stages, the noise is small as compared to the information in the gradient. Therefore a SGD step is *virtually as good as* a GD step.
 3. *Annealing* - The noise in SGD update can prevent convergence to a bad(shallow) local minima.
 4. Stochastic Gradient Descent is drastically cheaper to compute (as you don't go over all data points).
-->

1. Há muitas informações redundantes entre as instâncias. O SGD evita muitos desses cálculos redundantes.
 2. Nos estágios iniciais, o ruído é pequeno em comparação com as informações no gradiente. Portanto, uma etapa SGD é *virtualmente tão boa quanto* uma etapa de Gradiente Descendente.
 3. *Recozimento* - O ruído na atualização do SGD pode impedir a convergência para mínimos locais ruins (rasos).
 4. O Gradiente Descendente Estocástico é drasticamente mais barato para calcular (já que você não passa por todos os pontos de dados).

<!--
### Mini-batching
-->


### Mini-lotes

<!--In mini-batching, we consider the loss over multiple randomly selected instances instead of calculating it over just one instance. This reduces the noise in the step update.
-->

Em mini-lotes, consideramos a perda em várias instâncias selecionadas aleatoriamente em vez de calculá-la em apenas uma instância. Isso reduz o ruído em cada etapa da atualização do passo.

<!--$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$
-->

$$
w_{k+1} = w_k - \gamma_k \frac{1}{|B_i|} \sum_{j \in B_i}\nabla f_j(w_k)
$$

<!--Often we are able to make better use of our hardware by using mini batches instead of a single instance. For example, GPUs are poorly utilized when we use single instance training. Distributed network training techniques split a large mini-batch between the machines of a cluster and then aggregate the resulting gradients. Facebook recently trained a network on ImageNet data within an hour, using distributed training.
-->

Freqüentemente, podemos fazer melhor uso de nosso hardware usando mini-lotes em vez de uma única instância. Por exemplo, as GPUs são mal utilizadas quando usamos o treinamento de instância única. As técnicas de treinamento de rede distribuída dividem um grande mini-lote entre as máquinas de um cluster e, em seguida, agregam os gradientes resultantes. O Facebook treinou recentemente uma rede em dados ImageNet em uma hora, usando treinamento distribuído.

<!--It is important to note that Gradient Descent should never be used with full sized batches. In case you want to train on the full batch-size, use an optimization technique called LBFGS. PyTorch and SciPy both provide implementations of this technique.
-->

É importante observar que o Gradiente Descendente nunca deve ser usado com lotes de tamanho normal. Caso você queira treinar no tamanho total do lote, use uma técnica de otimização chamada LBFGS. O PyTorch e o SciPy possuem implementações desta técnica.

<!--## [Momentum](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)
-->

## [Momento](https://www.youtube.com/watch?v=--NZb480zlg&t=1672s)

<!--In Momentum, we have two iterates ($p$ and $w$) instead of just one. The updates are as follows:
-->

No Momento, temos duas iterações ($p$ e $w$) ao invés de apenas uma. As atualizações são as seguintes:

<!--$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$
-->

$$
\begin{aligned}
p_{k+1} &= \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} &=  w_k - \gamma_kp_{k+1} \\
\end{aligned}
$$

<!--$p$ is called the SGD momentum. At each update step we add the stochastic gradient to the old value of the momentum, after dampening it by a factor $\beta$ (value between 0 and 1). $p$ can be thought of as a running average of the gradients. Finally we move $w$ in the direction of the new momentum $p$.
-->

$p$ é chamado de momento SGD. Em cada etapa de atualização do passo, adicionamos o gradiente estocástico ao antigo valor do momento, após amortecê-lo por um fator $\beta$ (valor entre 0 e 1). $p$ pode ser considerado uma média contínua dos gradientes. Finalmente, movemos $w$ na direção do novo momento $p$.

<!--Alternate Form: Stochastic Heavy Ball Method
-->

Forma alternativa: Método Estocástico de Bola Pesada

<!--$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$
-->

$$
\begin{aligned}
w_{k+1} &= w_k - \gamma_k\nabla f_i(w_k) + \beta_k(w_k - w_{k-1}) & 0 \leq \beta < 1
\end{aligned}
$$

<!--This form is mathematically equivalent to the previous form. Here, the next step is a combination of previous step's direction ($w_k - w_{k-1}$) and the new negative gradient.
-->

Esta forma é matematicamente equivalente à forma anterior. Aqui, o próximo passo é uma combinação da direção do passo anterior ($w_k - w_{k-1}$) e o novo gradiente negativo.

<!--
### Intuition
-->

### Intuição

<!--SGD Momentum is similar to the concept of momentum in physics. The optimization process resembles a heavy ball rolling down the hill. Momentum keeps the ball moving in the same direction that it is already moving in. Gradient can be thought of as a force pushing the ball in some other direction.
-->

O Momento do SGD é semelhante ao conceito de momentum na física. O processo de otimização se assemelha a uma bola pesada rolando colina abaixo. O momento mantém a bola se movendo na mesma direção em que já está se movendo. O gradiente pode ser considerado como uma força que empurra a bola em alguma outra direção.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Figure 3:</b> Effect of Momentum<br>
<b>Source:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum.png"/><br>
<b>Figure 3:</b> Efeito do Momento<br>
<b>Source:</b><a href="https://distill.pub/2017/momentum/" target="_blank"> distill.pub </a><br>
</center>

<!--Rather than making dramatic changes in the direction of travel (as in the figure on the left), momentum makes modest changes. Momentum dampens the oscillations which are common when we use only SGD.
-->


Ao invés de fazer mudanças dramáticas na direção do caminho (como na figura à esquerda), o momento faz mudanças pequenas. O momento amortece as oscilações que são comuns quando usamos apenas SGD.

<!--The $\beta$ parameter is called the Dampening Factor. $\beta$ has to be greater than zero, because if it is equal to zero, you are just doing gradient descent. It also has to be less than 1, otherwise everything will blow up. Smaller values of $\beta$ result in change in direction quicker. For larger values, it takes longer to make turns.
-->

O parâmetro $\beta$ é chamado de fator de amortecimento. $\beta$ tem que ser maior que zero, porque se for igual a zero, você está apenas fazendo um gradiente descendente comum. Também deve ser menor que 1, caso contrário, tudo explodirá. Valores menores de $\beta$ resultam em mudanças de direção mais rápidas. Para valores maiores, leva mais tempo para fazer curvas.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Effect of Beta on Convergence
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-1/momentum-beta.png" style="zoom: 40%; background-color:#DCDCDC;"/><br>
<b>Figure 4:</b> Efeito do Beta na Convergência
</center>

<!--
### Practical guidelines
-->


### Diretrizes práticas

<!--Momentum must pretty much be always be used with stochastic gradient descent.
$\beta$ = 0.9 or 0.99 almost always works well.
-->

O momento deve quase sempre ser usado com o Gradiente Descendente Estocástico.
$\beta$ = 0,9 ou 0,99 quase sempre funciona bem.

<!--The step size parameter usually needs to be decreased when the momentum parameter is increased to maintain convergence. If $\beta$ changes from 0.9 to 0.99, learning rate must be decreased by a factor of 10.
-->

O parâmetro de tamanho do passo geralmente precisa ser reduzido quando o parâmetro de momento é aumentado para manter a convergência. Se $\beta$ mudar de 0,9 para 0,99, a taxa de aprendizagem deve ser reduzida em um fator de 10.

<!--
### Why does momentum works?
-->


### Por que o momento funciona?

<!--
#### Acceleration
-->


#### Aceleração

<!--The following are the update rules for Nesterov's momentum.
-->


A seguir estão as regras de atualização para o Momento de Nesterov.

<!--$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$
-->

$$
p_{k+1} = \hat{\beta_k}p_k + \nabla f_i(w_k) \\
w_{k+1} =  w_k - \gamma_k(\nabla f_i(w_k) +\hat{\beta_k}p_{k+1})
$$

<!--With Nesterov's Momentum, you can get accelerated convergence if you choose the constants very carefully. But this applies only to convex problems and not to Neural Networks.
-->

Com o Momento de Nesterov, você pode obter uma convergência acelerada se escolher as constantes com cuidado. Mas isso se aplica apenas a problemas convexos e não a redes neurais.

<!--Many people say that normal momentum is also an accelerated method. But in reality, it is accelerated only for quadratics. Also, acceleration does not work well with SGD, as SGD has noise and acceleration does not work well with noise. Therefore, though some bit of acceleration is present with Momentum SGD, it alone is not a good explanation for the high performance of the technique.
-->

Muitas pessoas dizem que o momento normal também é um método acelerado. Mas, na realidade, ele é acelerado apenas para funções quadráticas. Além disso, a aceleração não funciona bem com SGD, pois SGD tem ruído e a aceleração não funciona bem com ruído. Portanto, embora um pouco de aceleração esteja presente no SGD com Momento, por si só não é uma boa explicação para o alto desempenho da técnica.

<!--
#### Noise smoothing
-->


#### Suavização de ruído

<!--Probably a more practical and probable reason to why momentum works is Noise Smoothing.
-->

Provavelmente, uma razão mais prática e provável de por que o momento funciona é a Suavização de ruído.

<!--Momentum averages gradients. It is a running average of gradients that we use for each step update.
-->


O momento calcula a média dos gradientes. É uma média contínua de gradientes que usamos para cada atualização do passo.

<!--Theoretically, for SGD to work we should take average over all step updates.
-->

Teoricamente, para que o SGD funcione, devemos obter a média de todas as atualizações dos passos.

<!--$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$
-->

$$
\bar w_k = \frac{1}{K} \sum_{k=1}^K w_k
$$

<!--The great thing about SGD with momentum is that this averaging is no longer necessary. Momentum adds smoothing to the optimization process, which makes each update a good approximation to the solution. With SGD you would want to average a whole bunch of updates and then take a step in that direction.
-->

A grande vantagem do SGD com momento é que essa média não é mais necessária. O Momento adiciona suavização ao processo de otimização, o que torna cada atualização uma boa aproximação da solução. Com o SGD, você desejaria calcular a média de um monte de atualizações e, em seguida, dar um passo nessa direção.

<!--Both Acceleration and Noise smoothing contribute to high performance of momentum.
-->

Tanto a aceleração quanto a suavização de ruído contribuem para um alto desempenho do Momento.

<!--<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> SGD <i>vs.</i> Momentum
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week05/05-1/sgd-vs-momentum.png" style="zoom: 35%; background-color:#DCDCDC;"/><br>
<b>Figure 5:</b> SGD <i>vs.</i> Momento
</center>

<!--With SGD, we make good progress towards solution initially but when we reach bowl (bottom of the valley) we bounce around in this floor. If we adjust learning rate we will bounce around slower. With momentum we smooth out the steps, so that there is no bouncing around.
-->

Com o Gradiente Descendente Estocástico, inicialmente, fazemos um bom progresso em direção à solução, mas quando alcançamos o fundo da "tigela", ficamos rodeando em volta deste piso. Se ajustarmos a taxa de aprendizado, vamos rodear mais devagar. Com o impulso, suavizamos os degraus, para que não haja saltos.
