---
lang: pt
lang-ref: ch.04-1
lecturer: Alfredo Canziani
title: Álgebra Linear e Convoluções
authors: Yuchi Ge, Anshan He, Shuting Gu e Weiyang Wen
date: 18 Feb 2020
translation-date: 05 Nov 2021
translator: Leon Solon
---

<!--
## [Linear Algebra review](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)
-->

## [Revisão de Álgebra Linear](https://www.youtube.com/watch?v=OrBEon3VlQg&t=68s)

<!--This part is a recap of basic linear algebra in the context of neural networks. We start with a simple hidden layer $\boldsymbol{h}$:
-->

Esta parte é uma recapitulação de Álgebra Linear básica no contexto das redes neurais. Começamos com uma camada oculta simples $\boldsymbol{h}$:

<!--$$
\boldsymbol{h} = f(\boldsymbol{z})
$$
-->

$$
\boldsymbol{h} = f(\boldsymbol{z})
$$

<!--The output is a non-linear function $f$ applied to a vector $z$. Here $z$ is the output of an affine transformation $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ to the input vector $\boldsymbol{x} \in\mathbb{R^n}$:
-->

A saída é uma função não linear $f$ aplicada a um vetor $z$. Aqui $z$ é a saída de uma transformação afim (affine transformation) $\boldsymbol{A} \in\mathbb{R^{m\times n}}$ para o vetor de entrada $\boldsymbol{x} \in\mathbb{R^n}$:

<!--$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$
-->

$$
\boldsymbol{z} = \boldsymbol{A} \boldsymbol{x}
$$

<!--For simplicity biases are ignored. The linear equation can be expanded as:
-->

Para simplificar, os viéses (biases) são ignorados. A equação linear pode ser expandida como:

<!--$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$
-->

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
a_{11} & a_{12} & \cdots & a_{1n}\\
a_{21} & a_{22} & \cdots & a_{2n} \\
\vdots & \vdots & \ddots & \vdots \\
a_{m1} & a_{m2} & \cdots & a_{mn} \end{pmatrix} \begin{pmatrix}
x_1 \\ \vdots \\x_n \end{pmatrix} =
\begin{pmatrix}
    \text{---} \; \boldsymbol{a}^{(1)} \; \text{---} \\
    \text{---} \; \boldsymbol{a}^{(2)} \; \text{---} \\
    \vdots \\
    \text{---} \; \boldsymbol{a}^{(m)} \; \text{---} \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
\begin{pmatrix}
    {\boldsymbol{a}}^{(1)} \boldsymbol{x} \\ {\boldsymbol{a}}^{(2)} \boldsymbol{x} \\ \vdots \\ {\boldsymbol{a}}^{(m)} \boldsymbol{x}
\end{pmatrix}_{m \times 1}
$$

<!--where $\boldsymbol{a}^{(i)}$ is the $i$-th row of the matrix $\boldsymbol{A}$.
-->

onde $\boldsymbol{a}^{(i)}$ é a $i$-ésima linha da matriz $\boldsymbol{A}$.

<!--To understand the meaning of this transformation, let us analyse one component of $\boldsymbol{z}$ such as $a^{(1)}\boldsymbol{x}$. Let  $n=2$, then $\boldsymbol{a} = (a_1,a_2)$ and $\boldsymbol{x}  = (x_1,x_2)$.
-->

Para entender o significado dessa transformação, vamos analisar um componente de $\boldsymbol{z}$ como $a^{(1)}\boldsymbol{x}$. Seja $n=2$, então $\boldsymbol{a} = (a_1,a_2)$ e $\boldsymbol{x}  = (x_1,x_2)$.

<!--$\boldsymbol{a}$ and $\boldsymbol{x}$ can be drawn as vectors in the 2D coordinate axis. Now, if the angle between $\boldsymbol{a}$ and $\hat{\boldsymbol{\imath}}$ is $\alpha$ and the angle between $\boldsymbol{x}$ and $\hat{\boldsymbol{\imath}}$ is $\xi$, then with trigonometric formulae $a^\top\boldsymbol{x}$ can be expanded as:
-->

$\boldsymbol{a}$ e $\boldsymbol{x}$ podem ser desenhados como vetores no eixo de coordenadas 2D. Agora, se o ângulo entre $\boldsymbol{a}$ e $\hat{\boldsymbol{\imath}}$ é $\alpha$ e o ângulo entre $\boldsymbol{x}$ e $\hat{\boldsymbol{\imath}}$ é $\xi$, então com fórmulas trigonométricas $a^\top\boldsymbol{x}$ pode ser expandido como:

<!--$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$
-->

$$
\begin {aligned}
\boldsymbol{a}^\top\boldsymbol{x} &= a_1x_1+a_2x_2\\
&=\lVert \boldsymbol{a} \rVert \cos(\alpha)\lVert \boldsymbol{x} \rVert \cos(\xi) + \lVert \boldsymbol{a} \rVert \sin(\alpha)\lVert \boldsymbol{x} \rVert \sin(\xi)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \big(\cos(\alpha)\cos(\xi)+\sin(\alpha)\sin(\xi)\big)\\
&=\lVert \boldsymbol{a} \rVert \lVert \boldsymbol{x} \rVert \cos(\xi-\alpha)
\end {aligned}
$$

<!--
The output measures the alignment of the input to a specific row of the matrix $\boldsymbol{A}$. This can be understood by observing the angle between the two vectors, $\xi-\alpha$. When $\xi = \alpha$, the two vectors are perfectly aligned and maximum is attained. If $\xi - \alpha = \pi$, then $\boldsymbol{a}^\top\boldsymbol{x}$ attains its minimum and the two vectors are pointing at opposite directions. In essence, the linear transformation allows one to see the projection of an input to various orientations as defined by $A$. This intuition is expandable to higher dimensions as well.
-->

A saída mede o alinhamento da entrada a uma linha específica da matriz $\boldsymbol{A}$. Isso pode ser entendido observando o ângulo entre os dois vetores, $\xi-\alpha$. Quando $\xi = \alpha$, os dois vetores estão perfeitamente alinhados e o máximo é atingido. Se $\xi - \alpha = \pi$, então $\boldsymbol{a}^\top\boldsymbol{x}$ atinge seu mínimo e os dois vetores estão apontando em direções opostas. Em essência, a transformação linear permite ver a projeção de uma entrada para várias orientações definidas por $A$. Essa intuição também pode ser expandida para dimensões superiores.

<!--Another way to understand the linear transformation is by understanding that $\boldsymbol{z}$ can also be expanded as:
-->

Outra maneira de entender a transformação linear é entendendo que $\boldsymbol{z}$ também pode ser expandido como:

<!--$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$
-->

$$
\boldsymbol{A}\boldsymbol{x} =
\begin{pmatrix}
    \vert            & \vert            &        & \vert             \\
    \boldsymbol{a}_1 & \boldsymbol{a}_2 & \cdots & \boldsymbol{a}_n  \\
    \vert            & \vert            &        & \vert             \\
\end{pmatrix}
\begin{matrix}
    \rvert \\ \boldsymbol{x} \\ \rvert
\end{matrix} =
x_1 \begin{matrix} \rvert \\ \boldsymbol{a}_1 \\ \rvert \end{matrix} +
x_2 \begin{matrix} \rvert \\ \boldsymbol{a}_2 \\ \rvert \end{matrix} +
    \cdots +
x_n \begin{matrix} \rvert \\ \boldsymbol{a}_n \\ \rvert \end{matrix}
$$

<!--The output is the weighted sum of the columns of matrix $\boldsymbol{A}$. Therefore, the signal is nothing but a composition of the input.
-->

A saída é a soma ponderada das colunas da matriz $\boldsymbol{A}$. Portanto, o sinal nada mais é do que uma composição da entrada.

<!--
## [Extend Linear Algebra to convolutions](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)
-->

## [Extender Álgebra Linear para convoluções](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1030s)

<!--Now we extend linear algebra to convolutions, by using the example of audio data analysis. We start with representing a fully connected layer as a form of matrix multiplication: -
-->

Agora estendemos a álgebra linear às convoluções, usando o exemplo de análise de dados de áudio. Começamos representando uma camada totalmente conectada como uma forma de multiplicação de matriz: -

<!--$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$
-->

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13}\\
w_{21} & w_{22} & w_{23}\\
w_{31} & w_{32} & w_{33}\\
w_{41} & w_{42} & w_{43}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!--In this example, the weight matrix has a size of $4 \times 3$, the input vector has a size of $3 \times 1$ and the output vector has a of size $4 \times 1$.
-->

Neste exemplo, a matriz de peso tem um tamanho de $4 \times 3$, o vetor de entrada tem um tamanho de $3 \times 1$ e o vetor de saída tem um tamanho de $4 \times 1$.

<!--However, for audio data, the data is much longer (not 3-sample long). The number of samples in the audio data is equal to the duration of the audio (*e.g.* 3 seconds) times the sampling rate (*e.g.* 22.05 kHz). As shown below, the input vector $\boldsymbol{x}$ will be quite long. Correspondingly, the weight matrix will become "fat".
-->

No entanto, para dados de áudio, os dados são muito mais longos (não com 3 amostras). O número de amostras nos dados de áudio é igual à duração do áudio (*por exemplo,* 3 segundos) vezes a taxa de amostragem (*por exemplo,* 22,05 kHz). Conforme mostrado abaixo, o vetor de entrada $\boldsymbol{x}$ será bem longo. Correspondentemente, a matriz de peso se tornará "gorda".

<!--$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$
-->

$$
\begin{bmatrix}
w_{11} & w_{12} & w_{13} & w_{14} & \cdots &w_{1k}& \cdots &w_{1n}\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!--The above formulation will be difficult to train. Fortunately there are ways to simplify the same.
-->

A formulação acima será difícil de treinar. Felizmente, existem maneiras de simplificar o mesmo.

<!--
### Property: locality
-->

### Propriedade: localidade

<!--Due to locality (*i.e.* we do not care for data points that are far away) of data, $w_{1k}$ from the weight matrix above, can be filled with 0 when $k$ is relatively large. Therefore, the first row of the matrix becomes a kernel of size 3. Let's denote this size-3 kernel as $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.
-->

Devido à localidade (*ou seja,* não nos importamos com pontos de dados distantes) dos dados, $ w_ {1k} $ da matriz de peso acima pode ser preenchido com 0 quando $ k $ é relativamente grande. Portanto, a primeira linha da matriz torna-se um kernel de tamanho 3. Vamos denotar este kernel de tamanho 3 como $\boldsymbol{a}^{(1)} = \begin{bmatrix} a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)} \end{bmatrix}$.

<!--$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$
-->

$$
\begin{bmatrix}
a_1^{(1)}  & a_2^{(1)}  & a_3^{(1)}  & 0 & \cdots &0& \cdots &0\\
w_{21} & w_{22} & w_{23}& w_{24} & \cdots & w_{2k}&\cdots &w_{2n}\\
w_{31} & w_{32} & w_{33}& w_{34} & \cdots & w_{3k}&\cdots &w_{3n}\\
w_{41} & w_{42} & w_{43}& w_{44} & \cdots & w_{4k}&\cdots &w_{4n}
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix} = \begin{bmatrix}
y_1\\
y_2\\
y_3\\
y_4
\end{bmatrix}
$$

<!--
### Property: stationarity
-->

### Propriedade: estacionariedade

<!--Natural data signals have the property of stationarity (*i.e.* certain patterns/motifs will repeat). This helps us reuse kernel $\mathbf{a}^{(1)}$ that we defined previously. We use this kernel by placing it one step further each time (*i.e.* stride is 1), resulting in the following:
-->

Os sinais de dados naturais têm a propriedade de estacionariedade (*ou seja,* certos padrões / motivos se repetirão). Isso nos ajuda a reutilizar o kernel $\mathbf{a}^{(1)}$ que definimos anteriormente. Usamos este kernel colocando-o um passo adiante a cada vez (*ou seja,* o passo é 1), resultando no seguinte:

<!--$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$
-->

$$
\begin{bmatrix}
a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0 & 0 & 0 & 0&\cdots  &0\\
0 & a_1^{(1)}  & a_2^{(1)} & a_3^{(1)}  & 0&0&0&\cdots &0\\
0 & 0 & a_1^{(1)} & a_2^{(1)}  & a_3^{(1)}  & 0&0&\cdots &0\\
0 & 0 & 0& a_1^{(1)}  & a_2^{(1)}  &a_3^{(1)} &0&\cdots &0\\
0 & 0 & 0& 0 & a_1^{(1)}  &a_2^{(1)} &a_3^{(1)} &\cdots &0\\
\vdots&&\vdots&&\vdots&&\vdots&&\vdots
\end{bmatrix}
\begin{bmatrix}
x_1\\
x_2\\
x_3\\
x_4\\
\vdots\\
x_k\\
\vdots\\
x_n
\end{bmatrix}
$$

<!--Both the upper right part and lower left part of the matrix are filled with $0$s thanks to locality, leading to sparsity. The reuse of a certain kernel again and again is called weight sharing.
-->

Tanto a parte superior direita quanto a parte inferior esquerda da matriz são preenchidas com $ 0 $ s graças à localidade, levando à dispersão. A reutilização de um determinado kernel repetidamente é chamada de divisão de peso.

<!--
### Multiple layers of Toeplitz matrix
-->

### Múltiplas camadas de matriz Toeplitz

<!--After these changes, the number of parameters we are left with is 3 (*i.e.* $a_1,a_2,a_3$). In comparison to the previous weight matrix, which had 12 parameters (*i.e.* $w_{11},w_{12},\cdots,w_{43}$), the current number of parameters is too restrictive and we would like to expand the same.
-->

Após essas alterações, o número de parâmetros que resta é 3 (*ou seja,* $a_1,a_2,a_3$). Em comparação com a matriz de peso anterior, que tinha 12 parâmetros (*por exemplo* $w_{11},w_{12},\cdots,w_{43}$), o número atual de parâmetros é muito restritivo e gostaríamos de expandir o mesmo.

<!--The previous matrix can be considered to be a layer (*i.e.* a convolutional layer) with the kernel $\boldsymbol{a}^{(1)}$. Then we can construct multiple layers with different kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, thereby increasing the parameters.
-->

A matriz anterior pode ser considerada uma camada (*ou seja,* uma camada convolucional) com o kernel $\boldsymbol{a}^{(1)}$. Então podemos construir múltiplas camadas com diferentes kernels $\boldsymbol{a}^{(2)}$, $\boldsymbol{a}^{(3)}$, etc, aumentando assim os parâmetros.

<!--Each layer has a matrix containing just one kernel that is replicated multiple times. This type of matrix is called a Toeplitz matrix. In every Toeplitz matrix, each descending diagonal from left to right is constant. The Toeplitz matrices that we use here are sparse matrices as well.
-->

Cada camada possui uma matriz contendo apenas um kernel que é replicado várias vezes. Este tipo de matriz é denominado matriz de Toeplitz. Em cada matriz de Toeplitz, cada diagonal descendente da esquerda para a direita é constante. As matrizes Toeplitz que usamos aqui também são matrizes esparsas.

<!--Given the first kernel $\boldsymbol{a}^{(1)}$ and the input vector $\boldsymbol{x}$, the first entry in the output given by this layer is, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Therefore, the whole output vector looks like the following: -
-->

Dado o primeiro kernel $\boldsymbol{a}^{(1)}$ e o vetor de entrada $\boldsymbol{x}$, a primeira entrada na saída fornecida por esta camada é, $a_1^{(1)} x_1 + a_2^{(1)} x_2 + a_3^{(1)}x_3$. Portanto, todo o vetor de saída se parece com o seguinte: -

<!--$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$
-->

$$
\begin{bmatrix}
\mathbf{a}^{(1)}x[1:3]\\
\mathbf{a}^{(1)}x[2:4]\\
\mathbf{a}^{(1)}x[3:5]\\
\vdots
\end{bmatrix}
$$

<!--The same matrix multiplication method can be applied on following convolutional layers with other kernels (*e.g.* $\boldsymbol{a}^{(2)}$ and $\boldsymbol{a}^{(3)}$) to get similar results.
-->

O mesmo método de multiplicação de matriz pode ser aplicado nas seguintes camadas convolucionais com outros kernels (*por exemplo* $\boldsymbol{a}^{(2)}$ e $\boldsymbol{a}^{(3)}$) para obter similar resultados.

<!--
## [Listening to convolutions - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)
-->

## [Ouvindo as convoluções - Jupyter Notebook](https://www.youtube.com/watch?v=OrBEon3VlQg&t=1709s)

<!--The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).
-->

O Jupyter Notebook pode ser encontrado [aqui](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/07-listening_to_kernels.ipynb).

<!--In this notebook, we are going to explore Convolution as a 'running scalar product'.
-->

Neste bloco de notas, vamos explorar a Convolução como um 'produto escalar em execução'.

<!--The library `librosa` enables us to load the audio clip $\boldsymbol{x}$ and its sampling rate. In this case, there are 70641 samples, sampling rate is 22.05kHz and total length of the clip is 3.2s. The imported audio signal is wavy (refer to Fig 1) and we can guess what it sounds like from the amplitude of $y$ axis. The audio signal $x(t)$ is actually the sound played when turning off the Windows system (refer to Fig 2).
-->

A biblioteca `librosa` nos permite carregar o clipe de áudio $\boldsymbol{x}$ e sua taxa de amostragem. Nesse caso, existem 70641 amostras, a taxa de amostragem é de 22,05 kHz e a duração total do clipe é de 3,2 s. O sinal de áudio importado é ondulado (consulte a Figura 1) e podemos adivinhar como ele soa a partir da amplitude do eixo $ y $. O sinal de áudio $x(t)$ é na verdade o som reproduzido ao desligar o sistema Windows (consulte a Fig 2).

<!--<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Fig. 1</b>: A visualization of the audio signal.<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/audioSignal.png" width="500px" /><br>
<b>Fig. 1</b>: Uma visualização do sinal de áudio.<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Fig. 2</b>: Notes for the above audio signal.<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/notes.png" width="500px" /><br>
<b>Fig. 2</b>: Observações para o sinal de áudio acima.<br>
</center>

<!--
We need to seperate the notes from the waveform. To achieve this, if we use Fourier transform (FT) all the notes would come out together and it will be hard to figure out the exact time and location of each pitch. Therefore, a localized FT is needed (also known as spectrogram). As is observed in the spectrogram (refer to Fig 3), different pitches peak at different frequencies (*e.g.* first pitch peaks at 1600). Concatenating the four pitches at their frequencies gives us a pitched version of the original signal.
-->

Precisamos separar as notas da forma de onda. Para conseguir isso, se usarmos a transformada de Fourier (FT), todas as notas sairão juntas e será difícil descobrir a hora exata e a localização de cada afinação. Portanto, um FT localizado é necessário (também conhecido como espectrograma). Como é observado no espectrograma (consulte a Fig. 3), diferentes tons de pico em diferentes frequências (*por exemplo* primeiros picos de tom em 1600). A concatenação dos quatro tons em suas frequências nos dá uma versão do sinal original.

<!--<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Fig. 3</b>: Audio signal and its spectrogram.<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/spectrogram.png" width="500px" /><br>
<b>Fig. 3</b>: Sinal de áudio e seu espectrograma.<br>
</center>

<!--Convolution of the input signal with all the pitches (all the keys of the piano for example) can help extract all notes in the input piece (*i.e.* the hits when the audio matches the specific kernels). The spectrograms of the original signal and the signal of the concatenated pitches is shown in Fig 4 while the frequencies of the original signal and the four pitches is shown in Fig 5. The plot of the convolutions of the four kernels with the input signal (original signal) is shown in Fig 6. Fig 6 along with the audio clips of the convolutions prove the effectiveness of the convolutions in extracting the notes.
-->

A convolução do sinal de entrada com todos os tons (todas as teclas do piano, por exemplo) pode ajudar a extrair todas as notas na peça de entrada (*ou seja,* os hits quando o áudio corresponde aos núcleos específicos). Os espectrogramas do sinal original e o sinal dos tons concatenados são mostrados na Fig. 4, enquanto as frequências do sinal original e os quatro tons são mostrados na Fig. 5. O gráfico das convoluções dos quatro núcleos com o sinal de entrada (original sinal) é mostrado na Fig 6. A Fig 6 junto com os clipes de áudio das convoluções comprovam a eficácia das convoluções na extração das notas.

<!--
<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Spectrogram of original signal (left) and Sepctrogram of the concatenation of pitches (right).<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig4.png" width="500px" /><br>
<b>Fig. 4</b>: Espectrograma do sinal original (esquerda) e Espectrograma da concatenação de tons (direita).<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: First note of the melody.<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig5.png" width="500px" /><br>
<b>Fig. 5</b>: Primeira nota da melodia.<br>
</center>

<!--<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolution of four kernels.<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig6.png" width="500px" /><br>
<b>Fig. 6</b>: Convolução de quatro grãos.<br>
</center>

<!--
## Dimensionality of different datasets
-->

## Dimensionalidade de diferentes conjuntos de dados

<!--The last part is a short digression on the different representations of dimensionality and examples for the same. Here we consider input set $X$ is made of  functions mapping from domains $\Omega$ to channels $c$.
-->

A última parte é uma pequena digressão sobre as diferentes representações da dimensionalidade e exemplos para as mesmas. Aqui, consideramos que o conjunto de entrada $X$ é feito de mapeamento de funções dos domínios $\Omega$ para os canais $c$.

<!--
### Examples
-->

### Exemplos

<!--* Audio data: domain is 1-D, discrete signal indexed by time; number of channels $c$ can range from 1 (mono), 2 (stereo), 5+1 (Dolby 5.1), *etc.*
* Image data: domain is 2-D (pixels); $c$ can range from 1(greyscale), 3(colour), 20(hyperspectral), *etc.*
* Special relativity: domain is $\mathbb{R^4} \times \mathbb{R^4}$ (space-time $\times$ four-momentum); when $c = 1$ it is called Hamiltonian.
-->

* Dados de áudio: o domínio é 1-D, sinal discreto indexado pelo tempo; o número de canais $ c $ pode variar de 1 (mono), 2 (estéreo), 5 + 1 (Dolby 5.1), *etc.*
* Dados da imagem: o domínio é 2-D (pixels); $ c $ pode variar de 1 (escala de cinza), 3 (cor), 20 (hiperespectral), *etc.*
* Relatividade especial: o domínio é $\mathbb{R^4} \times \mathbb{R^4}$ (espaço-tempo $\times$ quatro-momento); quando $c = 1$ é chamado de Hamiltoniano.

<!--<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>Fig. 7</b>: Different dimensions of different types of signals.<br>
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week04/04-1/fig7.png" width="600px" /><br>
<b>Fig. 7</b>: Dimensões diferentes de tipos diferentes de sinais.<br>
</center>
