---
lang: pt
lang-ref: ch.03-3
title: Propriedades dos sinais naturais
lecturer: Alfredo Canziani
authors: Ashwin Bhola, Nyutian Long, Linfeng Zhang, and Poornima Haridas
date: 11 Feb 2020
translation-date: 14 Nov 2021
translator: Leon Solon
---


<!--
## [Properties of natural signals](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)
-->

## [Propriedades dos sinais naturais](https://www.youtube.com/watch?v=kwPWpVverkw&t=26s)

<!--All signals can be thought of as vectors. As an example, an audio signal is a 1D signal $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ where each value $x_t$ represents the amplitude of the waveform at time $t$. To make sense of what someone is speaking, your cochlea first converts the air pressure vibrations to signals and then your brain uses a language model to convert this signal to a language *i.e.* it needs to pick the most probable utterance given the signal. For music, the signal is stereophonic which has 2 or more channels to give you an illusion that the sound is coming from multiple directions. Even though it has 2 channels, it's still a 1D signal because time is the only variable along which the signal is changing.
-->

Todos os sinais podem ser considerados vetores. Como exemplo, um sinal de áudio é um sinal 1D $\boldsymbol{x} = [x_1, x_2, \cdots, x_T]$ onde cada valor $x_t$ representa a amplitude da forma de onda no tempo $ t $. Para entender o que alguém está falando, sua cóclea primeiro converte as vibrações da pressão do ar em sinais e, em seguida, seu cérebro usa um modelo de linguagem para converter esse sinal em uma linguagem *ou seja,* ele precisa escolher a expressão mais provável dado o sinal. Para música, o sinal é estereofônico, com 2 ou mais canais para dar a ilusão de que o som vem de várias direções. Embora tenha 2 canais, ainda é um sinal 1D porque o tempo é a única variável ao longo da qual o sinal está mudando.

<!--An image is a 2D signal because the information is spatially depicted. Note that each point can be a vector in itself. This means that if we have $d$ channels in an image, each spatial point in the image is a vector of dimension $d$. A colour image has RGB planes, which means $d = 3$. For any point $x_{i,j}$, this corresponds to the intensity of red, green and blue colours respectively.
-->

Uma imagem é um sinal 2D porque a informação é representada espacialmente. Observe que cada ponto pode ser um vetor em si. Isso significa que se temos $d$ canais em uma imagem, cada ponto espacial na imagem é um vetor de dimensão $d$. Uma imagem colorida tem planos RGB, o que significa $d = 3$. Para qualquer ponto $x_{i,j}$, isso corresponde à intensidade das cores vermelha, verde e azul, respectivamente.

<!--We can even represent language with the above logic. Each word corresponds to a one-hot vector with one at the position it occurs in our vocabulary and zeroes everywhere else. This means that each word is a vector of the size of the vocabulary.
-->

Podemos até representar a linguagem com a lógica acima. Cada palavra corresponde a um vetor one-hot com um na posição em que ocorre em nosso vocabulário e zeros em todas as outras. Isso significa que cada palavra é um vetor do tamanho do vocabulário.

<!--Natural data signals follow these properties:
1. Stationarity: Certain motifs repeat throughout a signal. In audio signals, we observe the same type of patterns over and over again across the temporal domain. In images, this means that we can expect similar visual patterns repeat across the dimensionality.
2. Locality: Nearby points are more correlated than points far away. For 1D signal, this means that if we observe a peak at some point $t_i$, we expect the points in a small window around $t_i$ to have similar values as $t_i$ but for a point $t_j$ far away from $t_i$, $x_{t_i}$ has very less bearing on $x_{t_j}$. More formally, the convolution between a signal and its flipped counterpart has a peak when the signal is perfectly overlapping with it's flipped version. A convolution between two 1D signals (cross-correlation) is nothing but their dot product which is a measure of how similar or close the two vectors are. Thus, information is contained in specific portions and parts of the signal. For images, this means that the correlation between two points in an image decreases as we move the points away. If $x_{0,0}$ pixel is blue, the probability that the next pixel ($x_{1,0},x_{0,1}$) is also blue is pretty high but as you move to the opposite end of the image ($x_{-1,-1}$), the value of this pixel is independent of the pixel value at $x_{0,0}$.
3. Compositionality: Everything in nature is composed of parts that are composed of sub-parts and so on. As an example, characters form strings that form words, which further form sentences. Sentences can be combined to form documents. Compositionality allows the world to be explainable.
-->

Os sinais de dados naturais seguem estas propriedades:
1. Estacionariedade: Certos motivos se repetem ao longo de um sinal. Em sinais de áudio, observamos o mesmo tipo de padrões repetidamente em todo o domínio temporal. Em imagens, isso significa que podemos esperar que padrões visuais semelhantes se repitam em toda a dimensionalidade.
2. Localidade: os pontos próximos são mais correlacionados do que os pontos distantes. Para o sinal 1D, isso significa que se observarmos um pico em algum ponto $t_i$, esperamos que os pontos em uma pequena janela em torno de $t_i$ tenham valores semelhantes a $t_i$, mas para um ponto $t_j$ longe de $t_i$, $x_{t_i}$ tem muito menos influência em $x_{t_j}$. Mais formalmente, a convolução entre um sinal e sua contraparte invertida tem um pico quando o sinal está perfeitamente sobreposto à sua versão invertida. Uma convolução entre dois sinais 1D (correlação cruzada) nada mais é do que seu produto escalar, que é uma medida de quão semelhantes ou próximos os dois vetores são. Assim, a informação está contida em porções e partes específicas do sinal. Para imagens, isso significa que a correlação entre dois pontos em uma imagem diminui à medida que afastamos os pontos. Se $x_{0,0}$ pixel for azul, a probabilidade de que o próximo pixel ($x_{1,0}, x_{0,1}$) também seja azul é muito alta, mas conforme você se move para a extremidade oposta da imagem ($x_{- 1, -1}$), o valor deste pixel é independente do valor do pixel em $x_{0,0}$.
3. Composicionalidade: Tudo na natureza é composto de partes que são compostas de sub-partes e assim por diante. Por exemplo, os caracteres formam cadeias de caracteres que formam palavras, que também formam frases. As frases podem ser combinadas para formar documentos. A composicionalidade permite que o mundo seja explicável.

<!--If our data exhibits stationarity, locality, and compositionality, we can exploit them with networks that use sparsity, weight sharing and stacking of layers.
-->

Se nossos dados exibem estacionariedade, localidade e composicionalidade, podemos explorá-los com redes que usam dispersão, compartilhamento de peso e empilhamento de camadas.

<!--
## [Exploiting properties of natural signals to build invariance and equivariance](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)
-->

## [Explorando propriedades de sinais naturais para construir invariância e equivariância](https://www.youtube.com/watch?v=kwPWpVverkw&t=1074s)

<!--
### Locality  $\Rightarrow$ sparsity
-->

### Localidade $\Rightarrow$ esparcidade

<!--Fig.1 shows a 5-layer fully connected network. Each arrow represents a weight to be multiplied by the inputs. As we can see, this network is very computationally expensive.
-->

A Fig.1 mostra uma rede de 5 camadas totalmente conectada. Cada seta representa um peso a ser multiplicado pelas entradas. Como podemos ver, essa rede é muito cara em termos computacionais.

<!--<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b>Figure 1:</b> Fully Connected Network</center>
-->

<center><img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" width="400px" /><br>
<b> Figura 1: </b> Rede totalmente conectada </center>

<!--If our data exhibits locality, each neuron needs to be connected to only a few local neurons of the previous layer. Thus, some connections can be dropped as shown in Fig.2. Fig.2(a) represents an FC network. Taking advantage of the locality property of our data, we drop connections between far away neurons in Fig.2(b). Although the hidden layer neurons (green) in Fig.2(b) don't span the whole input, the overall architecture will be able to account for all input neurons. The receptive field (RF) is the number of neurons of previous layers, that each neuron of a particular layer can see or has taken into account. Therefore, the RF of the output layer w.r.t the hidden layer is 3, RF of the hidden layer w.r.t the input layer is 3, but the RF of the output layer w.r.t the input layer is 5.
-->

Se nossos dados exibem localidade, cada neurônio precisa ser conectado a apenas alguns neurônios locais da camada anterior. Assim, algumas conexões podem ser interrompidas, conforme mostrado na Fig.2. A Fig.2 (a) representa uma rede FC. Aproveitando a propriedade de localidade de nossos dados, eliminamos as conexões entre neurônios distantes na Fig.2 (b). Embora os neurônios da camada oculta (verde) na Fig.2 (b) não abranjam toda a entrada, a arquitetura geral será capaz de dar conta de todos os neurônios de entrada. O campo receptivo (RF) é o número de neurônios das camadas anteriores, que cada neurônio de uma determinada camada pode ver ou levou em consideração. Portanto, o RF da camada de saída com a camada oculta é 3, o RF da camada oculta com a camada de entrada é 3, mas o RF da camada de saída com a camada de entrada é 5.

<!--|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figure 2(a):</b> Before Applying Sparsity | <b>Figure 2(b):</b> After Applying Sparsity|
-->

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 2(a) Before Applying Sparsity.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 2(b) After Applying Sparsity.png" width="300"/>|
|<b>Figura 2 (a):</b>Antes de aplicar a esparcidade | <b>Figura 2(b):</b> Após a aplicação da esparcidade |

<!--
### Stationarity $\Rightarrow$ parameters sharing
-->

### Estacionariedade $\Rightarrow$ Compartilhamento de parâmetros 

<!--If our data exhibits stationarity, we could use a small set of parameters multiple times across the network architecture. For example in our sparse network, Fig.3(a), we can use a set of 3 shared parameters (yellow, orange and red). The number of parameters will then drop from 9 to 3! The new architecture might even work better because we have more data for training those specific weights.
The weights after applying sparsity and parameter sharing is called a convolution kernel.
-->

Se nossos dados exibirem estacionariedade, poderíamos usar um pequeno conjunto de parâmetros várias vezes na arquitetura da rede. Por exemplo, em nossa rede esparsa, Fig.3 (a), podemos usar um conjunto de 3 parâmetros compartilhados (amarelo, laranja e vermelho). O número de parâmetros cairá de 9 para 3! A nova arquitetura pode até funcionar melhor porque temos mais dados para treinar esses pesos específicos.
Os pesos após a aplicação de dispersão e compartilhamento de parâmetros são chamados de kernel de convolução.

<!--|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>|
|<b>Figure 3(a):</b> Before Applying Parameter Sharing | <b>Figure 3(b):</b> After Applying Parameter Sharing|
-->

|<img src="{{site.baseurl}}/images/week03/03-3/Figure 3(a) Before Applying Parameter Sharing.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure 3(b) After Applying Parameter Sharing.png" width="300"/>| <b> Figura 3 (a): </b> Antes de Aplicar o Compartilhamento de Parâmetro | <b> Figura 3 (b): </b> Após aplicar o compartilhamento de parâmetro |

<!--Following are some advantages of using sparsity and parameter sharing:-
* Parameter sharing
  * faster convergence
  * better generalisation
  * not constained to input size
  * kernel indepence $\Rightarrow$ high parallelisation
* Connection sparsity
  * reduced amount of computation
-->

A seguir estão algumas vantagens de usar esparsidade e compartilhamento de parâmetros: -
* Compartilhamento de parâmetros
  * convergência mais rápida
  * melhor generalização
  * não restrito ao tamanho de entrada
  * independência do kernel $\Rightarrow$ alta paralelização
* Esparsidade de conexão
  * quantidade reduzida de computação

<!--Fig.4 shows an example of kernels on 1D data, where the kernel size is: 2(number of kernels) * 7(thickness of the previous layer) * 3(number of unique connections/weights).
-->

A Fig.4 mostra um exemplo de kernels em dados 1D, onde o tamanho do kernel é: 2(número de kernels) * 7(espessura da camada anterior) * 3(número de conexões / pesos únicos).

<!--The choice of kernel size is empirical. 3 * 3 convolution seems to be the minimal size for spatial data. Convolution of size 1 can be used to obtain a final layer that can be applied to a larger input image. Kernel size of even number might lower the quality of the data, thus we always have kernel size of odd numbers, usually 3 or 5.
-->

A escolha do tamanho do kernel é empírica. A convolução 3 * 3 parece ser o tamanho mínimo para dados espaciais. A convolução de tamanho 1 pode ser usada para obter uma camada final que pode ser aplicada a uma imagem de entrada maior. O tamanho do kernel de número par pode diminuir a qualidade dos dados, portanto, sempre temos o tamanho do kernel de números ímpares, geralmente 3 ou 5.

<!--|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
|<b>Figure 4(a):</b> Kernels on 1D Data | <b>Figure 4(b):</b> Data with Zero Padding|
-->

|<img src="{{site.baseurl}}/images/week03/03-3/Figure_4a_kernels_ on_1D_data.png" width="300"/> | <img src="{{site.baseurl}}/images/week03/03-3/Figure_4b_zero_padding.png" width="350"/>|
| <b> Figura 4 (a): </b> Kernels em dados 1D | <b> Figura 4 (b): </b> Dados com Preenchimento com Zeros |

<!--### Padding
-->

### Preenchimento (Padding)

<!--Padding generally hurts the final results, but it is convenient programmatically. We usually use zero-padding: `size =  (kernel size - 1)/2`.
-->

O preenchimento (padding) geralmente prejudica os resultados finais, mas é conveniente programaticamente. Normalmente usamos preenchimento com zeros (zero-padding): `tamanho = (tamanho do kernel - 1)/2`.

<!--
### Standard spatial CNN
-->

### CNN espacial padrão

<!--A standard spatial CNN has the following properties:
-->

Uma CNN espacial padrão tem as seguintes propriedades:

<!--* Multiple layers
  * Convolution
  * Non-linearity (ReLU and Leaky)
  * Pooling
  * Batch normalisation
* Residual bypass connection
-->

* Múltiplas camadas
  * Convolução
  * Não linearidade (ReLU e Leaky)
  * Pooling
  * Normalização em lote (batch normalization)
* Conexão de bypass residual

<!--Batch normalization and residual bypass connections are very helpful to get the network to train well.
Parts of a signal can get lost if too many layers have been stacked so, additional connections via residual bypass, guarantee a path from bottom to top and also for a path for gradients coming from top to bottom.
-->

A normalização em lote e as conexões de bypass residuais são muito úteis para fazer com que a rede treine bem.
Partes de um sinal podem se perder se muitas camadas forem empilhadas, portanto, conexões adicionais via bypass residual garantem um caminho de baixo para cima e também um caminho para gradientes vindo de cima para baixo.

<!--In Fig.5, while the input image contains mostly spatial information across two dimensions (apart from characteristic information, which is the colour of each pixel), the output layer is thick. Midway, there is a trade off between the spatial information and the characteristic information and the representation becomes denser. Therefore, as we move up the hierarchy, we get denser representation as we lose the spatial information.
-->

Na Fig.5, enquanto a imagem de entrada contém principalmente informações espaciais em duas dimensões (além das informações características, que são a cor de cada pixel), a camada de saída é espessa. No meio do caminho, há uma troca entre as informações espaciais e as informações características e a representação torna-se mais densa. Portanto, à medida que subimos na hierarquia, obtemos uma representação mais densa à medida que perdemos as informações espaciais.

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b>Figure 5:</b> Information Representations Moving up the Hierarchy</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 5 Information Representations Moving up the Hierachy.png" width="350px" /><br>
<b> Figura 5: </b> Representações de informações subindo na hierarquia </center>

<!--
### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)
-->

### [Pooling](https://www.youtube.com/watch?v=kwPWpVverkw&t=2376s)

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b>Figure 6:</b> Illustration of Pooling</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 6 Illustration of Pooling.png" width="350px" /><br>
<b> Figura 6: </b> Ilustração de pooling </center>

<!--A specific operator, $L_p$-norm, is applied to different regions (refer to Fig.6). Such an operator gives only one value per region(1 value for 4 pixels in our example). We then iterate over the whole data region-by-region, taking steps based on the stride. If we start with $m * n$ data with $c$ channels, we will end up with $\frac{m}{2} * \frac{n}{2}$ data still with $c$ channels (refer to Fig.7).
Pooling is not parametrized; nevertheless, we can choose different polling types like max pooling, average pooling and so on. The main purpose of pooling reduces the amount of data so that we can compute in a reasonable amount of time.
-->

Um operador específico, $L_p$-norm, é aplicado a diferentes regiões (consulte a Fig.6). Esse operador fornece apenas um valor por região (1 valor para 4 pixels em nosso exemplo). Em seguida, iteramos sobre todos os dados, região por região, realizando etapas com base no passo. Se começarmos com $m * n$ dados com $c$ canais, terminaremos com $\frac{m}{2} * \frac{n}{2}$ dados ainda com $c$ canais (consulte Fig.7).
O agrupamento não é parametrizado; no entanto, podemos escolher diferentes tipos de sondagem, como pooling máximo, pooling médio e assim por diante. O objetivo principal do agrupamento reduz a quantidade de dados para que possamos computar em um período de tempo razoável.

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b>Figure 7:</b> Pooling results </center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 7 Pooling results.png" width="350px" /><br>
<b> Figura 7: </b> Agrupando resultados </center>

<!--
## CNN - Jupyter Notebook
-->

## CNN - Jupyter Notebook

<!--The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). To run the notebook, make sure you have the `pDL` environment installed as specified in [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md).
-->

O Jupyter Notebook pode ser encontrado [aqui](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/06-convnet.ipynb). Para executar o notebook, certifique-se de ter o ambiente `pDL` instalado conforme especificado em [`README.md`](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/README.md) .

<!--In this notebook, we train a multilayer perceptron (FC network) and a convolution neural network (CNN) for the classification task on the MNIST dataset. Note that both networks have an equal number of parameters. (Fig.8)
-->

Neste notebook, treinamos um perceptron multicamadas (rede totalmente conectada - FC) e uma rede neural convolucional (CNN) para a tarefa de classificação no conjunto de dados MNIST. Observe que ambas as redes têm um número igual de parâmetros. (Fig.8)

<!--<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b>Figure 8:</b> Instances from the Original MNIST Dataset </center>
-->

<center> <img src="{{site.baseurl}}/images/week03/03-3/Figure 8 Instances from the Original MNIST Dataset.png" width="350px" /><br>
<b> Figura 8: </b> instâncias do conjunto de dados MNIST original </center>

<!--Before training, we normalize our data so that the initialization of the network will match our data distribution (very important!). Also, make sure that the following five operations/steps are present in your training:
-->

Antes do treinamento, normalizamos nossos dados para que a inicialização da rede corresponda à nossa distribuição de dados (muito importante!). Além disso, certifique-se de que as cinco operações/etapas a seguir estejam presentes em seu treinamento:

<!-- 1. Feeding data to the model
 2. Computing the loss
 3. Cleaning the cache of accumulated gradients with `zero_grad()`
 4. Computing the gradients
 5. Performing a step in the optimizer method
-->

1. Alimentando dados para o modelo
2. Calculando a perda
3. Limpar o cache de gradientes acumulados com `zero_grad()`
4. Calculando os gradientes
5. Executar uma etapa no método do otimizador

<!--First, we train both the networks on the normalized MNIST data. The accuracy of the FC network turned out to be $87\%$ while the accuracy of the CNN turned out to be $95\%$. Given the same number of parameters, the CNN managed to train many more filters. In the FC network, filters that try to get some dependencies between things that are further away with things that are close by, are trained. They are completely wasted. Instead, in the convolutional network, all these parameters concentrate on the relationship between neighbour pixels.
-->

Primeiro, treinamos ambas as redes nos dados MNIST normalizados. A precisão da rede totalmente conectada acabou sendo $87\%$, enquanto a precisão da CNN acabou sendo $95\%$. Dado o mesmo número de parâmetros, a CNN conseguiu treinar muitos mais filtros. Na rede FC, os filtros que tentam obter algumas dependências entre coisas que estão mais distantes com coisas que estão por perto são treinados. Eles estão completamente perdidos. Em vez disso, na rede convolucional, todos esses parâmetros se concentram na relação entre os pixels vizinhos.

<!--Next, we perform a random permutation of all the pixels in all the images of our MNIST dataset. This transforms our Fig.8 to Fig.9. We then train both the networks on this modified dataset.
-->

Em seguida, realizamos uma permutação aleatória de todos os pixels em todas as imagens de nosso conjunto de dados MNIST. Isso transforma nossa Fig.8 em Fig.9. Em seguida, treinamos ambas as redes neste conjunto de dados modificado.

<!--<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b>Figure 9:</b> Instances from Permuted MNIST Dataset</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-3/Figure 9 Instances from Permuted MNIST Dataset.png" width="350px" /><br>
<b> Figura 9: </b> instâncias do conjunto de dados MNIST permutado </center>

<!--The performance of the FC network almost stayed unchanged ($85\%$), but the accuracy of CNN dropped to $83\%$. This is because, after a random permutation, the images no longer hold the three properties of locality, stationarity, and compositionality, that are exploitable by a CNN.
-->

O desempenho da rede totalmente conectada quase permaneceu inalterado ($85\%$), mas a precisão da CNN caiu para $83\%$. Isso ocorre porque, após uma permutação aleatória, as imagens não possuem mais as três propriedades de localidade, estacionariedade e composicionalidade, que são exploradas por uma CNN.

