---
lang: pt
lang-ref: ch.03-2
lecturer: Yann LeCun
title: Evolução, Arquiteturas, Detalhes de Implementação e Vantagens das Redes Convolucionais.
authors: Chris Ick, Soham Tamba, Ziyu Lei, Hengyu Tang
date: 10 Feb 2020
translation-date: 14 Nov 2021
translator: Leon Solon
---

<!--
## [Proto-CNNs and evolution to modern CNNs](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)
-->


## [Proto-CNNs e evolução para CNNs modernas](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2949s)

<!--
### Proto-convolutional neural nets on small data sets
-->


### Redes neurais protoconvolucionais em pequenos conjuntos de dados

<!--Inspired by Fukushima's work on visual cortex modelling, using the simple/complex cell hierarchy combined with supervised training and backpropagation lead to the development of the first CNN at University of Toronto in '88-'89 by Prof. Yann LeCun. The experiments used a small dataset of 320 'mouser-written' digits. Performances of the following architectures were compared:
-->

Inspirado pelo trabalho de Fukushima na modelagem do córtex visual, o uso da hierarquia celular simples / complexa combinada com treinamento supervisionado e retropropagação levou ao desenvolvimento da primeira CNN na Universidade de Toronto em '88-'89 pelo Prof. Yann LeCun. Os experimentos usaram um pequeno conjunto de dados de 320 dígitos 'escritos no mouse'. Os desempenhos das seguintes arquiteturas foram comparados:

<!--1. Single FC(fully connected) Layer
2. Two FC Layers
3. Locally Connected Layers w/o shared weights
4. Constrained network w/ shared weights and local connections
5. Constrained network w/ shared weights and local connections 2 (more feature maps)
-->

1. Camada FC única (totalmente conectada)
2. Duas camadas FC
3. Camadas conectadas localmente sem pesos compartilhados
4. Rede restrita com pesos compartilhados e conexões locais
5. Rede restrita com pesos compartilhados e conexões locais 2 (mais mapas de recursos)

<!--The most successful networks (constrained network with shared weights) had the strongest generalizability, and form the basis for modern CNNs. Meanwhile, singler FC layer tends to overfit.
-->

As redes mais bem-sucedidas (rede restrita com pesos compartilhados) tiveram a generalização mais forte e formam a base para as CNNs modernas. Enquanto isso, a camada FC simples tende a se ajustar demais.

<!--
### First "real" ConvNets at Bell Labs
-->


### Primeiras ConvNets "reais" na Bell Labs

<!--After moving to Bell Labs, LeCunn's research shifted to using handwritten zipcodes from the US Postal service to train a larger CNN:
-->

Depois de se mudar para o Bell Labs, a pesquisa de LeCunn mudou para o uso de códigos postais manuscritos dos Correios dos EUA para treinar uma CNN maior:

<!--* 256 (16$\times$16) input layer
* 12 5$\times$5 kernels with stride 2 (stepped 2 pixels): next layer has lower resolution
* **NO** separate pooling
-->

* 256 (16$\times$16) camada de entrada
* 12 5$\times$5 kernels com *stride* 2 (com passos de 2 pixels): a próxima camada tem resolução mais baixa
* **Sem** pooling em separado

<!--
### Convolutional network architecture with pooling
-->


### Arquitetura de rede convolucional com pooling

<!--The next year, some changes were made: separate pooling was introduced. Separate pooling is done by averaging input values, adding a bias, and passing to a nonlinear function (hyperbolic tangent function). The 2$\times$2 pooling was performed with a stride of 2, hence reducing resolutions by half.
-->

No ano seguinte, algumas mudanças foram feitas: o pooling separado foi introduzido. O agrupamento separado é feito calculando a média dos valores de entrada, adicionando uma polarização e passando para uma função não linear (função tangente hiperbólica). O pool de 2 $ \ vezes $ 2 foi realizado com um passo de 2, reduzindo, portanto, as resoluções pela metade.

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1</b> ConvNet Architecture
</center>
-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/detailed_convNet.png" width="600px" /><br>
    <b>Fig. 1</b> Arquitetura ConvNet
</center>

<!--An example of a single convolutional layer would be as follows:
1. Take an input with size *32$\times$32*
2. The convolution layer passes a 5$\times$5 kernel with stride 1 over the image, resulting feature map size *28$\times$28*
3. Pass the feature map to a nonlinear function: size *28$\times$28*
4. Pass to the pooling layer that averages over a 2$\times$2 window with stride 2: size *14$\times$14*
5. Repeat 1-4 for 4 kernels
-->

Um exemplo de uma única camada convolucional seria o seguinte:
1. Pegue uma entrada com tamanho *32$\times$32*
2. A camada de convolução passa um kernel 5$\times$5 com *stride* 1 sobre a imagem, resultando no tamanho do mapa de características *28$\times$28*
3. Passe o mapa de características para uma função não linear: tamanho *28$\times$28*
4. Passe para a camada de agrupamento que tem em média uma janela de 2$\times$2 com *stride* 2 (passo 2): tamanho *14$\times$14*
5. Repita 1-4 para 4 kernels

<!--The first-layer, simple convolution/pool combinations usually detect simple features, such as oriented edge detections. After the first convolution/pool layer, the objective is to detect combinations of features from previous layers. To do this, steps 2 to 4 are repeated with multiple kernels over previous-layer feature maps, and are summed in a new feature map:
-->

As combinações simples de convolução/pool de primeira camada geralmente detectam recursos simples, como detecções de bordas orientadas. Após a primeira camada de convolução/pool, o objetivo é detectar combinações de recursos de camadas anteriores. Para fazer isso, as etapas 2 a 4 são repetidas com vários kernels sobre os mapas de recursos da camada anterior e são somados em um novo mapa de recursos:

<!--1. A new 5$\times$5 kernel is slid over all feature maps from previous layers, with results summed up. (Note: In Prof. LeCun's experiment in 1989 the connection is not full for computation purpose. Modern settings usually enforce full connections): size *10$\times$10*
2. Pass the output of the convolution to a nonlinear function: size *10$\times$10*
3. Repeat 1/2 for 16 kernels.
4. Pass the result to the pooling layer that averages over 2$\times$2 window with stride 2: size *5$\times$5* each feature map
-->

1. Um novo kernel 5$\times$5 é deslizado sobre todos os mapas de características das camadas anteriores, com os resultados somados. (Observação: no experimento do Prof. LeCun em 1989, a conexão não está completa para fins de computação. As configurações modernas geralmente impõem conexões completas): tamanho *10$\times$10*
2. Passe a saída da convolução para uma função não linear: tamanho *10$\times$10*
3. Repita 1/2 para 16 grãos.
4. Passe o resultado para a camada de agrupamento que tem em média mais de 2$\times$2 janela com passo 2: tamanho *5$\times$5* cada mapa de característica

<!--To generate an output, the last layer of convolution is conducted, which seems like a full connections but indeed is convolutional.
-->

Para gerar uma saída, a última camada de convolução é conduzida, que parece conexões completas, mas na verdade é convolucional.

<!--1. The final convolution layer slides a 5$\times$5 kernel over all feature maps, with results summed up: size *1$\times$1*
2. Pass through nonlinear function: size *1$\times$1*
3. Generate the single output for one category.
4. Repeat all pervious steps for each of the 10 categories(in parallel)
-->

1. A camada de convolução final desliza um kernel 5$\times$5 sobre todos os mapas de características, com resultados resumidos: tamanho *1$\times$1*
2. Passagem pela função não linear: tamanho *1$\times$1*
3. Gere o resultado único para uma categoria.
4. Repita todas as etapas anteriores para cada uma das 10 categorias (em paralelo)

<!--See [this animation](http://cs231n.github.io/convolutional-networks/) on Andrej Karpathy's website on how convolutions change the shape of the next layer's feature maps. Full paper can be found [here](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).
-->

Veja [esta animação] (http://cs231n.github.io/convolutional-networks/) no site de Andrej Karpathy sobre como as convoluções mudam a forma dos mapas de características da próxima camada. O artigo completo pode ser encontrado [aqui](https://papers.nips.cc/paper/293-handwritten-digit-recognition-with-a-back-propagation-network.pdf).

<!--
### Shift equivariance
-->


### Equivariância de deslocamento (Shift equivariance)

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2</b> Shift Equivariance
</center>
-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/shift_invariance.gif" width="600px" /><br>
    <b>Fig. 2</b> Equivariância de deslocamento (Shift Equivariance)
</center>

<!--As demonstrated by the animation on the slides(here's another example), translating the input image results in same translation of the feature maps. However, the changes in feature maps are scaled by convolution/pooling operations. *E.g.* the 2$\times$2 pooling with stride 2 will reduce the 1-pixel shift in input layer to 0.5-pixel shift in the following feature maps. Spatial resolution is then exchanged for increased number of feature types, *i.e.* making the representation more abstract and less sensitive to shifts and distortions.
-->

Conforme demonstrado pela animação nos slides (aqui está outro exemplo), a tradução da imagem de entrada resulta na mesma tradução dos mapas de características. No entanto, as mudanças nos mapas de recursos são dimensionadas por operações de convolução/agrupamento. *Por exemplo, o agrupamento de 2$\times$2 com *stride* 2 (passo de 2) reduzirá o deslocamento de 1 pixel na camada de entrada para o deslocamento de 0,5 pixel nos seguintes mapas de características. A resolução espacial é então trocada por um número maior de tipos de recursos, *ou seja,* tornando a representação mais abstrata e menos sensível a deslocamentos e distorções.

<!--
### Overall architecture breakdown
-->


### Análise geral da arquitetura

<!--Generic CNN architecture can be broken down into several basic layer archetypes:
-->

A arquitetura genérica da CNN pode ser dividida em vários arquétipos de camadas básicas:

<!--* **Normalisation**
  * Adjusting whitening (optional)
  * Subtractive methods *e.g.* average removal, high pass filtering
  * Divisive: local contrast normalisation, variance normalisation
-->

* **Normalização**
  * Ajustando o clareamento (opcional)
  * Métodos subtrativos *por exemplo* remoção média, filtragem passa-alta
  * Divisivo: normalização de contraste local, normalização de variância

<!--* **Filter Banks**
  * Increase dimensionality
  * Projection on overcomplete basis
  * Edge detections
-->

* **Bancos de filtros**
  * Aumente a dimensionalidade
  * Projeção em base supercompleta
  * Detecções de borda

<!--* **Non-linearities**
  * Sparsification
  * Typically Rectified Linear Unit (ReLU): $\text{ReLU}(x) = \max(x, 0)$
-->

* **Não linearidades**
  * Esparsificação
  * Unidade Linear Retificada(ReLU): $\text{ReLU}(x) = \max(x, 0)$

<!--* **Pooling**
  * Aggregating over a feature map
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$
-->

* **Pooling**
  * Agragação a partir de um mapa de características
  * Max Pooling: $\text{MAX}= \text{Max}_i(X_i)$

<!--  * LP-Norm Pooling:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$
-->

  * Pooling de Norma LP:  $$\text{L}p= \left(\sum_{i=1}^n \|X_i\|^p \right)^{\frac{1}{p}}$$

<!--  * Log-Prob Pooling:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$
-->

  * Pooling de Probabilidade Logarítimica:  $\text{Prob}= \frac{1}{b} \left(\sum_{i=1}^n e^{b X_i} \right)$

<!--
## [LeNet5 and digit recognition](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)
-->


## [LeNet5 e reconhecimento de dígitos](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=3830s)

<!--
### Implementation of LeNet5 in PyTorch
-->


### Implementação da LeNet5 no PyTorch

<!--LeNet5 consists of the following layers (1 being the top-most layer):
-->

LeNet5 consiste nas seguintes camadas (1 sendo a camada superior):

<!--1. Log-softmax
2. Fully connected layer of dimensions 500$\times$10
3. ReLu
4. Fully connected layer of dimensions (4$\times$4$\times$50)$\times$500
5. Max Pooling of dimensions 2$\times$2, stride of 2.
6. ReLu
7. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
8. Max Pooling of dimensions 2$\times$2, stride of 2.
9. ReLu
10. Convolution with 20 output channels, 5$\times$5 kernel, stride of 1.
-->

1. Log-softmax
2. Camada de dimensões totalmente conectada 500$\times$10
3. ReLu
4. Camada de dimensões totalmente conectada (4$\times$4$\times$50)$\times$500
5. Combinação máxima de dimensões 2$\times$2, *stride* de 2 (passo de 2).
6. ReLu
7. Convolução com 20 canais de saída, kernel 5$\times$5, *stride* de 1.
8. Combinação máxima de dimensões 2$\times$2, *stride* de 2.
9. ReLu
10. Convolução com 20 canais de saída, 5$\times$5 kernel, *stride* de 1.

<!--The input is a 32$\times$32 grey scale image (1 input channel).
-->

A entrada é uma imagem em escala de cinza de 32$\times$32 (1 canal de entrada).

<!--LeNet5 can be implemented in PyTorch with the following code:
-->

LeNet5 pode ser implementado em PyTorch com o seguinte código:

<!--```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)
        
        return F.logsoftmax(x, dim=1)
-->

```python
class LeNet5(nn.Module):
    def __init__(self):
        super().__init__()
        self.conv1 = nn.Conv2d(1, 20, 5, 1)
        self.conv2 = nn.Conv2d(20, 20, 5, 1)
        self.fc1 = nn.Linear(4*4*50, 500)
        self.fc2 = nn.Linear(500, 10)

    def forward(self, x):
        x = F.relu(self.conv1(x))
        x = F.max_pool2d(x, 2, 2)
        x = F.relu(self.conv2(x))
        x = F.max_pool2d(x, 2, 2)
        x = x.view(-1, 4*4*50)
        x = F.relu(self.fc1)
        x = self.fc2(x)

        return F.logsoftmax(x, dim=1)
```

<!--Although `fc1` and `fc2` are fully connected layers, they can be thought of as convolutional layers whose kernels cover the entire input. Fully connected layers are used for efficiency purposes.
-->

Embora `fc1` e` fc2` sejam camadas totalmente conectadas, elas podem ser consideradas camadas convolucionais cujos núcleos cobrem toda a entrada. Camadas totalmente conectadas são usadas para fins de eficiência.

<!--The same code can be expressed using `nn.Sequential`, but it is outdated.
-->

O mesmo código pode ser expresso usando `nn.Sequential`, mas está desatualizado.

<!--
## Advantages of CNN
-->


## Vantagens das CNNs

<!--In a fully convolutional network, there is no need to specify the size of the input. However, changing the size of the input changes the size of the output.
-->

Em uma rede totalmente convolucional, não há necessidade de especificar o tamanho da entrada. No entanto, alterar o tamanho da entrada altera o tamanho da saída.

<!--Consider a cursive hand-writing recognition system. We do not have to break the input image into segments. We can apply the CNN over the entire image: the kernels will cover all locations in the entire image and record the same output regardless of where the pattern is located. Applying the CNN over an entire image is much cheaper than applying it at multiple locations separately. No prior segmentation is required, which is a relief because the task of segmenting an image is similar to recognizing an image.
-->

Considere um sistema de reconhecimento de escrita cursiva. Não precisamos quebrar a imagem de entrada em segmentos. Podemos aplicar o CNN em toda a imagem: os kernels cobrirão todos os locais da imagem inteira e registrarão a mesma saída, independentemente de onde o padrão esteja localizado. Aplicar a CNN sobre uma imagem inteira é muito mais barato do que aplicá-la em vários locais separadamente. Nenhuma segmentação anterior é necessária, o que é um alívio porque a tarefa de segmentar uma imagem é semelhante a reconhecer uma imagem.

<!--
### Example: MNIST
-->


### Exemplo: MNIST

<!--LeNet5 is trained on MNIST images of size 32$\times$32 to classify individual digits in the centre of the image. Data augmentation was applied by shifting the digit around, changing the size of the digit, inserting digits to the side. It was also trained with an 11-th category which represented none of the above. Images labelled by this category were generated either by producing blank images, or placing digits at the side but not the centre.
-->

LeNet5 é treinado em imagens MNIST de tamanho 32 $ \ vezes $ 32 para classificar dígitos individuais no centro da imagem. O aumento de dados foi aplicado deslocando o dígito, alterando o tamanho do dígito, inserindo dígitos ao lado. Também foi treinado com uma 11ª categoria que não representou nenhuma das anteriores. As imagens rotuladas por esta categoria foram geradas produzindo imagens em branco ou colocando dígitos na lateral, mas não no centro.

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> Sliding Window ConvNet
</center>
-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/various_input.gif" width="600px" /><br>
    <b>Fig. 3</b> ConvNet (Rede Convolucional) com janela deslizante
</center>

<!--
The above image demonstrates that a LeNet5 network trained on 32$\times$32 can be applied on a 32$\times$64 input image to recognise the digit at multiple locations.
-->

A imagem acima demonstra que uma rede LeNet5 treinada em 32$\times$32 pode ser aplicada em uma imagem de entrada de  32$\times$64 para reconhecer o dígito em vários locais.

<!--
## [Feature binding problem](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)
-->


## [Problema de vinculação de características](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=4827s)

<!--
### What is the feature binding problem?
-->


### Qual é o problema de vinculação de recursos (Feature Binding)?

<!--Visual neural scientists and computer vision people have the problem of defining the object as an object. An object is a collection of features, but how to bind all of the features to form this object?
-->

Cientistas da neurologia visual e especialistas em visão computacional têm o problema de definir o objeto como um objeto. Um objeto é uma coleção de recursos, mas como vincular todos os recursos para formar esse objeto?

<!--
### How to solve it?
-->


### Como solucionar?

<!--We can solve this feature binding problem by using a very simple CNN: only two layers of convolutions with poolings plus another two fully connected layers without any specific mechanism for it, given that we have enough non-linearities and data to train our CNN.
-->

Podemos resolver esse problema de vinculação de recursos usando um CNN muito simples: apenas duas camadas de convoluções com agrupamentos mais outras duas camadas totalmente conectadas sem nenhum mecanismo específico para isso, visto que temos não linearidades e dados suficientes para treinar nosso CNN.

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> ConvNet Addressing Feature Binding
</center>
-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/feature_binding.gif" width="600px" /><br>
    <b>Fig. 4</b> ConvNet solucionando a vinculação de características (Feature Binding)
</center>

<!--The above animation showcases the ability of CNN to recognize different digits by moving a single stroke around, demonstrating its ability to address feature binding problems, *i.e.* recognizing features in a hierarchical, compositional way.
-->

A animação acima mostra a capacidade da CNN de reconhecer diferentes dígitos movendo um único traço, demonstrando sua capacidade de resolver problemas de vinculação de recursos, *ou seja,* reconhecendo recursos de forma hierárquica e composicional.

<!--
### Example: dynamic input length
-->


### Example: comprimento de entrada dinâmica

<!--We can build a CNN with 2 convolution layers with stride 1 and 2 pooling layers with stride 2 such that the overall stride is 4. Thus, if we want to get a new output, we need to shift our input window by 4. To be more explicit, we can see the figure below (green units). First, we have an input of size 10, and we perform convolution of size 3 to get 8 units. After that, we perform pooling of size 2 to get 4 units. Similarly, we repeat the convolution and pooling again and eventually we get 1 output.
-->

Podemos construir um CNN com 2 camadas de convolução com passo 1 e 2 camadas de pool com passo 2, de modo que o passo geral seja 4. Assim, se quisermos obter uma nova saída, precisamos mudar nossa janela de entrada em 4. Para ser mais explícito, podemos ver a figura abaixo (unidades verdes). Primeiro, temos uma entrada de tamanho 10 e realizamos a convolução de tamanho 3 para obter 8 unidades. Depois disso, realizamos o pooling de tamanho 2 para obter 4 unidades. Da mesma forma, repetimos a convolução e o agrupamento novamente e, eventualmente, obtemos 1 saída.

<!--<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> ConvNet Architecture On Variant Input Size Binding
</center>
-->

<center>
    <img src="{{site.baseurl}}/images/week03/03-2/example.jpg" width="600px" /><br>
    <b>Fig. 5</b> Arquitetura ConvNet na vinculação de tamanho de entrada variante
</center>

<!--Let’s assume we add 4 units at the input layer (pink units above), so that we can get 4 more units after the first convolution layer, 2 more units after the first pooling layer, 2 more units after the second convolution layer, and 1 more output. Therefore, window size to generate a new output is 4 (2 stride $\times$2)<!<--the overall subsampling we have shown from input to output is 4 (2x2)->->. Moreover, this is a demonstration of the fact that if we increase the size of the input, we will increase the size of every layer, proving CNNs' capability in handling dynamic length inputs.
-->

Vamos supor que adicionamos 4 unidades na camada de entrada (unidades rosa acima), de modo que possamos obter mais 4 unidades após a primeira camada de convolução, mais 2 unidades após a primeira camada de agrupamento, mais 2 unidades após a segunda camada de convolução e 1 mais saída. Portanto, o tamanho da janela para gerar uma nova saída é 4 (*stride* de 2 $\times$2). Além disso, esta é uma demonstração de que se aumentarmos o tamanho da entrada, aumentaremos o tamanho de cada camada, comprovando a capacidade das CNNs em lidar com entradas de comprimento dinâmico.

<!--
## What are CNN good for
-->


## No que as CNNs são boas

<!--CNNs are good for natural signals that come in the form of multidimensional arrays and have three major properties:
1. **Locality**: The first one is that there is a strong local correlation between values. If we take two nearby pixels of a natural image, those pixels are very likely to have the same colour. As two pixels become further apart, the similarity between them will decrease. The local correlations can help us detect local features, which is what the CNNs are doing. If we feed the CNN with permuted pixels, it will not perform well at recognizing the input images, while FC will not be affected. The local correlation justifies local connections.
2. **Stationarity**: Second character is that the features are essential and can appear anywhere on the image, justifying the shared weights and pooling. Moreover, statistical signals are uniformly distributed, which means we need to repeat the feature detection for every location on the input image.
3. **Compositionality**: Third character is that the natural images are compositional, meaning the features compose an image in a hierarhical manner. This justifies the use of multiple layers of neurons, which also corresponds closely with Hubel and Weisel's research on simple and complex cells.
-->

CNNs são bons para sinais naturais que vêm na forma de matrizes multidimensionais e têm três propriedades principais:
1. **Localidade**: O primeiro é que existe uma forte correlação local entre os valores. Se pegarmos dois pixels próximos de uma imagem natural, é muito provável que esses pixels tenham a mesma cor. À medida que dois pixels se tornam mais distantes, a semelhança entre eles diminui. As correlações locais podem nos ajudar a detectar características locais, que é o que as CNNs estão fazendo. Se alimentarmos a CNN com pixels permutados, ela não terá um bom desempenho no reconhecimento das imagens de entrada, enquanto o FC não será afetado. A correlação local justifica conexões locais.
2. **Estacionaridade**: O segundo caráter é que as características são essenciais e podem aparecer em qualquer lugar da imagem, justificando os pesos compartilhados e pooling. Além disso, os sinais estatísticos são distribuídos uniformemente, o que significa que precisamos repetir a detecção do recurso para cada local na imagem de entrada.
3. **Composicionalidade**: O terceiro caráter é que as imagens naturais são composicionais, ou seja, os recursos compõem uma imagem de forma hierárquica. Isso justifica o uso de múltiplas camadas de neurônios, o que também corresponde intimamente às pesquisas de Hubel e Weisel sobre células simples e complexas.

<!--Furthermore, people make good use of CNNs on videos, images, texts, and speech recognition.
-->

Além disso, as pessoas fazem bom uso das CNNs em vídeos, imagens, textos e reconhecimento de fala.