---
lang: pt
lang-ref: ch.03-1
lecturer: Yann LeCun
title: Visualização da Transformação de Parâmetros de Redes Neurais e Conceitos Fundamentais de Convoluções
authors: Jiuhong Xiao, Trieu Trinh, Elliot Silva, Calliea Pan
date: 10 Feb 2020
typora-root-url: 03-1
translation-date: 14 Nov 2021
translator: Leon Solon
---


<!--
## [Visualization of neural networks](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)
-->

## [Visualização de redes neurais](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=5s)

<!--In this section we will visualise the inner workings of a neural network.
-->

Nesta seção, visualizaremos o funcionamento interno de uma rede neural.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Network Structure</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Network.png" alt="Network" style="zoom:35%;" /><br>
Fig. 1 Estrutura da rede </center>

<!--Figure 1 depicts the structure of the neural network we would like to visualise. Typically, when we draw the structure of a neural network, the input appears on the bottom or on the left, and the output appears on the top side or on the right. In Figure 1, the pink neurons represent the inputs, and the blue neurons represent the outputs. In this network, we have 4 hidden layers (in green), which means we have 6 layers in total (4 hidden layers + 1 input layer + 1 output layer). In this case, we have 2 neurons per hidden layer, and hence the dimension of the weight matrix ($W$) for each layer is 2-by-2. This is because we want to transform our input plane into another plane that we can visualize.
-->

A Figura 1 mostra a estrutura da rede neural que gostaríamos de visualizar. Normalmente, quando desenhamos a estrutura de uma rede neural, a entrada aparece na parte inferior ou à esquerda e a saída aparece na parte superior ou direita. Na Figura 1, os neurônios de cor rosa representam as entradas e os neurônios azuis representam as saídas. Nesta rede, temos 4 camadas ocultas (em verde), o que significa que temos 6 camadas no total (4 camadas ocultas + 1 camada de entrada + 1 camada de saída). Nesse caso, temos 2 neurônios por camada oculta e, portanto, a dimensão da matriz de peso ($W$) para cada camada é 2 por 2. Isso ocorre porque queremos transformar nosso plano de entrada em outro plano que possamos visualizar.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualization of folding space</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual1.png" alt="Network" style="zoom:35%;" /><br>
Fig. 2 Visualização do espaço dobrável </center>

<!--The transformation of each layer is like folding our plane in some specific regions as shown in Figure 2. This folding is very abrupt, this is because all the transformations are performed in the 2D layer. In the experiment, we find that if we have only 2 neurons in each hidden layer, the optimization will take longer; the optimization is easier if we have more neurons in the hidden layers. This leaves us with an important question to consider: Why is it harder to train the network with fewer neurons in the hidden layers? You should consider this question yourself and we will return to it after the visualization of $\texttt{ReLU}$.
-->

A transformação de cada camada é como dobrar nosso plano em algumas regiões específicas, conforme mostrado na Figura 2. Esse dobramento é muito abrupto, isso porque todas as transformações são realizadas na camada 2D. No experimento, descobrimos que, se tivermos apenas 2 neurônios em cada camada oculta, a otimização será mais demorada; a otimização é mais fácil se tivermos mais neurônios nas camadas ocultas. Isso nos deixa com uma questão importante a considerar: por que é mais difícil treinar a rede com menos neurônios nas camadas ocultas? Você mesmo deve considerar esta questão e retornaremos a ela após a visualização de $\texttt{ReLU}$.

<!--| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|
-->

| <img src="{{site.baseurl}}/images/week03/03-1/Visual2a.png" alt="Network" style="zoom:45%;" /> | <img src="{{site.baseurl}}/images/week03/03-1/Visual2b.png" alt="Network" style="zoom:45%;" /> |
|(a)|(b)|

<!--<center>Fig. 3 Visualization of ReLU operator</center>
-->

<center>Fig. 3 Visualização do operador ReLU</center>

<!--When we step through the network one hidden layer at a time, we see that with each layer we perform some affine transformation followed by applying the non-linear ReLU operation, which eliminates any negative values. In Figures 3(a) and (b), we can see the visualisation of ReLU operator. The ReLU operator helps us to do non-linear transformations. After mutliple steps of performing an affine transformation followed by the ReLU operator, we are eventually able to linearly separate the data as can be seen in Figure 4.
-->

Quando percorremos a rede, uma camada oculta de cada vez, vemos que, em cada camada, realizamos alguma transformação afim, seguida pela aplicação da operação ReLU não linear, que elimina quaisquer valores negativos. Nas Figuras 3 (a) e (b), podemos ver a visualização do operador ReLU. O operador ReLU nos ajuda a fazer transformações não lineares. Após várias etapas de realização de uma transformação afim seguida pelo operador ReLU, somos eventualmente capazes de separar linearmente os dados, como pode ser visto na Figura 4.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualization of Outputs</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Visual3.png" alt="Network" style="zoom:30%;" /><br>
Fig. 4 Visualização de saídas </center>

<!--This provides us with some insight into why the 2-neuron hidden layers are harder to train. Our 6-layer network has one bias in each hidden layers. Therefore if one of these biases moves points out of top-right quadrant, then applying the ReLU operator will eliminate these points to zero. After that, no matter how later layers transform the data, the values will remain zero. We can make a neural network easier to train by making the network "fatter" - *i.e.* adding more neurons in hidden layers - or we can add more hidden layers, or a combination of the two methods. Throughout this course we will explore how to determine the best network architecture for a given problem, stay tuned.
-->

Isso nos fornece algumas dicas sobre por que as camadas ocultas de 2 neurônios são mais difíceis de treinar. Nossa rede de 6 camadas tem um viés em cada camada oculta. Portanto, se uma dessas polarizações mover pontos para fora do quadrante superior direito, a aplicação do operador ReLU eliminará esses pontos para zero. Depois disso, não importa o quanto as camadas posteriores transformem os dados, os valores permanecerão zero. Podemos tornar uma rede neural mais fácil de treinar tornando a rede "mais gorda" - *ou seja,* adicionando mais neurônios em camadas ocultas - ou podemos adicionar mais camadas ocultas, ou uma combinação dos dois métodos. Ao longo deste curso, exploraremos como determinar a melhor arquitetura de rede para um determinado problema, fique atento.

<!--
## [Parameter transformations](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)
-->

## [Transformações de parâmetro](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=477s)

<!--General parameter transformation means that our parameter vector $w$ is the output of a function. By this transformation, we can map original parameter space into another space. In Figure 5, $w$ is actually the output of $H$ with the parameter $u$. $G(x,w)$ is a network and $C(y,\bar y)$ is a cost function. The backpropagation formula is also adapted as follows,
-->

A transformação de parâmetro geral significa que nosso vetor de parâmetro $w$ é a saída de uma função. Por meio dessa transformação, podemos mapear o espaço de parâmetro original em outro espaço. Na Figura 5, $ w $ é na verdade a saída de $H$ com o parâmetro $u$. $G (x, w)$ é uma rede e $C(y,\bar y)$ é uma função de custo. A fórmula de retropropagação também é adaptada da seguinte forma,

<!--$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$
-->

$$
u \leftarrow u - \eta\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

<!--$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$
-->

$$
w \leftarrow w - \eta\frac{\partial H}{\partial u}\frac{\partial H}{\partial u}^\top\frac{\partial C}{\partial w}^\top
$$

<!--These formulas are applied in a matrix form. Note that the dimensions of the terms should be consistent. The dimension of $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ are $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectively. Therefore, the dimension of our backpropagation formula is consistent.
-->

Essas fórmulas são aplicadas em forma de matriz. Observe que as dimensões dos termos devem ser consistentes. As dimensões de $u$,$w$,$\frac{\partial H}{\partial u}^\top$,$\frac{\partial C}{\partial w}^\top$ são $[N_u \times 1]$,$[N_w \times 1]$,$[N_u \times N_w]$,$[N_w \times 1]$, respectivamente. Portanto, a dimensão de nossa fórmula de retropropagação é consistente.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 General Form of Parameter Transformations</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/PT.png" alt="Network" style="zoom:35%;" /><br>
Fig. 5 Forma geral das transformações de parâmetros </center>

<!--
### A simple parameter transformation: weight sharing
-->

### Uma transformação de parâmetro simples: compartilhamento de peso

<!--A Weight Sharing Transformation means $H(u)$ just replicates one component of $u$ into multiple components of $w$. $H(u)$ is like a **Y** branch to copy $u_1$ to $w_1$, $w_2$. This can be expressed as,
-->

Uma transformação de compartilhamento de peso significa que $H(u)$ apenas replica um componente de $u$ em vários componentes de $w$. $H(u)$ é como uma divisão em **Y** para copiar $u_1$ para $w_1$, $w_2$. Isso pode ser expressado como,

<!--$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$
-->

$$
w_1 = w_2 = u_1, w_3 = w_4 = u_2
$$

<!--We force shared parameters to be equal, so the gradient w.r.t. to shared parameters will be summed in the backprop. For example the gradient of the cost function $C(y, \bar y)$ with respect to $u_1$ will be the sum of the gradient of the cost function $C(y, \bar y)$ with respect to $w_1$ and the gradient of the cost function $C(y, \bar y)$ with respect to $w_2$.
-->

Forçamos os parâmetros compartilhados a serem iguais, então o gradiente em relação aos parâmetros compartilhados será somado na retroprogação. Por exemplo, o gradiente da função de custo $C(y, \bar y)$ em relação a $u_1$ será a soma do gradiente da função de custo $C(y, \bar y)$ em relação a $w_1$ e o gradiente da função de custo $C(y, \bar y)$ em relação a $w_2$.

<!--
### Hypernetwork
-->

### Hiper-rede

<!--A hypernetwork is a network where the weights of one network is the output of another network. Figure 6 shows the computation graph of a "hypernetwork". Here the function $H$ is a network with parameter vector $u$ and input $x$. As a result, the weights of $G(x,w)$ are dynamically configured by the network $H(x,u)$. Although this is an old idea, it remains very powerful.
-->

Uma hiper-rede é uma rede em que os pesos de uma rede são a saída de outra rede. A Figura 6 mostra o gráfico de computação de uma "hiper-rede". Aqui, a função $H$ é uma rede com vetor de parâmetro $u$ e entrada $x$. Como resultado, os pesos de $G(x,w)$ são configurados dinamicamente pela rede $H(x,u)$. Embora seja uma ideia antiga, continua muito poderosa.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Fig. 6 "Hypernetwork"</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/HyperNetwork.png" alt="Network" style="zoom:35%;" /><br>
Fig. 6 "Hypernetwork" </center>

<!--
### Motif detection in sequential data
-->

### Detecção de motivos em dados sequenciais

<!--Weight sharing transformation can be applied to motif detection. Motif detection means to find some motifs in sequential data like keywords in speech or text. One way to achieve this, as shown in Figure 7, is to use a sliding window on data, which moves the weight-sharing function to detect a particular motif (*i.e.* a particular sound in speech signal), and the outputs (*i.e.* a score) goes into a maximum function.
-->

A transformação de compartilhamento de peso pode ser aplicada à detecção de motivos. A detecção de motivos significa encontrar alguns motivos em dados sequenciais, como palavras-chave em voz ou texto. Uma maneira de conseguir isso, conforme mostrado na Figura 7, é usar uma janela deslizante de dados, que move a função de divisão de peso para detectar um motivo específico (*ou seja* um determinado som no sinal de fala) e as saídas (*ou seja,* uma pontuação) vai para uma função máxima.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 Motif Detection for Sequential Data</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Motif.png" alt="Network" style="zoom:30%;" /><br>
Fig. 7 Detecção de Motivos para Dados Sequenciais </center>

<!--In this example we have 5 of those functions. As a result of this solution, we sum up five gradients and backpropagate the error to update the parameter $w$. When implementing this in PyTorch, we want to prevent the implicit accumulation of these gradients, so we need to use `zero_grad()` to initialize the gradient.
-->

Neste exemplo, temos 5 dessas funções. Como resultado dessa solução, somamos cinco gradientes e retropropagamos o erro para atualizar o parâmetro $w$. Ao implementar isso no PyTorch, queremos evitar o acúmulo implícito desses gradientes, então precisamos usar `zero_grad()` para inicializar o gradiente.

<!--
### Motif detection in images
-->

### Detecção de motivos em imagens

<!--The other useful application is motif detection in images. We usually swipe our "templates" over images to detect the shapes independent of position and distortion of the shapes. A simple example is to distinguish between "C" and "D",  as Figure 8 shows. The difference between "C" and "D" is that "C" has two endpoints and "D" has two corners. So we can design "endpoint templates" and "corner templates". If the shape is similar to the "templates", it will have thresholded outputs. Then we can distinguish letters from these outputs by summing them up. In Figure 8, the network detects two endpoints and zero corners, so it activates "C".
-->

A outra aplicação útil é a detecção de motivos em imagens. Normalmente, passamos nossos "modelos" sobre as imagens para detectar as formas, independentemente da posição e distorção das formas. Um exemplo simples é distinguir entre "C" e "D", como mostra a Figura 8. A diferença entre "C" e "D" é que "C" tem dois pontos finais e "D" tem dois cantos. Assim, podemos projetar "modelos de terminal" e "modelos de canto". Se a forma for semelhante aos "modelos", ele terá saídas limitadas. Então, podemos distinguir as letras dessas saídas, somando-as. Na Figura 8, a rede detecta dois pontos finais e zero cantos, portanto, ativa "C".

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Fig. 8 Motif Detection for Images</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/MotifImage.png" alt="Network" style="zoom:35%;" /><br>
Fig. 8 Detecção de motivos para imagens </center>

<!--It is also important that our "template matching" should be shift-invariant - when we shift the input, the output (*i.e.* the letter detected) shouldn't change. This can be solved with weight sharing transformation. As Figure 9 shows, when we change the location of "D", we can still detect the corner motifs even though they are shifted. When we sum up the motifs, it will activate the "D" detection.
-->

Também é importante que o nosso "modelo de correspondência" seja invariante ao deslocamento - quando mudamos a entrada, a saída (*ou seja,* a letra detectada) não deve mudar. Isso pode ser resolvido com a transformação do compartilhamento de peso. Como mostra a Figura 9, quando mudamos a localização de "D", ainda podemos detectar os motivos dos cantos, embora eles estejam deslocados. Ao somarmos os motivos, ele ativará a detecção "D".

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Fig. 9 Shift Invariance</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/ShiftInvariance.png" alt="Network" style="zoom:35%;" /><br>
Fig. 9 Invariância de deslocamento </center>

<!--This hand-crafted method of using local detectors and summation to for digit-recognition was used for many years. But it presents us with the following problem: How can we design these "templates" automatically? Can we use neural networks to learn these "templates"? Next, We will introduce the concept of **convolutions** , that is, the operation we use to match images with "templates".
-->

Este método artesanal de usar detectores locais e soma para reconhecimento de dígitos foi usado por muitos anos. Mas isso nos apresenta o seguinte problema: Como podemos criar esses "modelos" automaticamente? Podemos usar redes neurais para aprender esses "modelos"? A seguir, apresentaremos o conceito de **convoluções**, ou seja, a operação que usamos para combinar imagens com "modelos".

<!--
## Discrete convolution
-->

## Convolução discreta

<!--
### Convolution
-->

### Convolução

<!--The precise mathematical definition of a convolution in the 1-dimensional case between input $x$ and $w$ is:
-->

A definição matemática precisa de uma convolução no caso unidimensional entre a entrada $x$ e $w$ é:

<!--$$y_i = \sum_j w_j x_{i-j}$$
-->

$$y_i = \sum_j w_j x_{i-j}$$

<!--In words, the $i$-th output is computed as the dot product between the **reversed** $w$ and a window of the same size in $x$. To compute the full output, start the window at the beginning, shift this window by one entry each time and repeat until $x$ is exhausted.
-->

Em palavras, a $i$-ésima saída é calculada como o produto escalar entre o  $w$ **invertido** e uma janela do mesmo tamanho em $x$. Para calcular a saída completa, inicie a janela no início, avance esta janela um passo de cada vez e repita até que $x$ se esgote.

<!--
### Cross-correlation
-->

### Correlação cruzada

<!--In practice, the convention adopted in deep learning frameworks such as PyTorch is slightly different. Convolution in PyTorch is implemented where $w$ is **not reversed**:
-->

Na prática, a convenção adotada em estruturas de aprendizado profundo, como o PyTorch, é um pouco diferente. Na implementação das convoluções no PyTorch, $w$ **não é invertido**:

<!--$$y_i = \sum_j w_j x_{i+j}$$
-->

$$y_i = \sum_j w_j x_{i+j}$$

<!--Mathematicians call this formulation "cross-correlation". In our context, this difference is just a difference in convention. Practically, cross-correlation and convolution can be interchangeable if one reads the weights stored in memory forward or backward.
-->

Os matemáticos chamam essa formulação de "correlação cruzada". Em nosso contexto, essa diferença é apenas uma diferença na convenção. Praticamente, correlação cruzada e convolução podem ser intercambiáveis ​​se alguém ler os pesos armazenados na memória para frente ou para trás.

<!--Being aware of this difference is important, for example, when one want to make use of certain mathematical properties of convolution/correlation from mathematical texts.
-->

Estar ciente dessa diferença é importante, por exemplo, quando se deseja fazer uso de certas propriedades matemáticas de convolução / correlação de textos matemáticos.

<!--
### Higher dimensional convolution
-->

### Convolução dimensional superior

<!--For two dimensional inputs such as images, we make use of the two dimensional version of convolution:
-->

Para entradas bidimensionais, como imagens, usamos a versão bidimensional da convolução:

<!--$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$
-->

$$y_{ij} = \sum_{kl} w_{kl} x_{i+k, j+l}$$

<!--This definition can easily be extended beyond two dimensions to three or four dimensions. Here $w$ is called the *convolution kernel*
-->

Essa definição pode ser facilmente estendida além de duas dimensões para três ou quatro dimensões. Aqui $w$ é chamado de *kernel de convolução*

<!--
### Regular twists that can be made with the convolutional operator in DCNNs
-->

### Torções regulares que podem ser feitas com o operador convolucional em DCNNs

<!--1. **Striding**: instead of shifting the window in $x$ one entry at a time, one can do so with a larger step (for example two or three entries at a time).
Example: Suppose the input $x$ is one dimensional and has size of 100 and $w$ has size 5. The output size with a stride of 1 or 2 is shown in the table below:
-->

1. **Striding**: em vez de mudar a janela em $x$ uma entrada por vez, pode-se fazer isso com um passo maior (por exemplo, duas ou três entradas por vez).
Exemplo: suponha que a entrada $x$ seja unidimensional e tenha tamanho 100 e $w$ tenha tamanho 5. O tamanho de saída com uma passada de 1 ou 2 é mostrado na tabela abaixo:

<!--| Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Output size: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |
-->

| Stride       | 1                          | 2                          |
| ------------ | -------------------------- | -------------------------- |
| Tamanho da saída: | $\frac{100 - (5-1)}{1}=96$ | $\frac{100 - (5-1)}{2}=48$ |

<!--
2. **Padding**: Very often in designing Deep Neural Networks architectures, we want the output of convolution to be of the same size as the input. This can be achieved by padding the input ends with a number of (typically) zero entries, usually on both sides. Padding is done mostly for convenience. It can sometimes impact performance and result in strange border effects, that said, when using a ReLU non-linearity, zero padding is not unreasonable.
-->

2. **Preenchimento (Padding)**: Muito frequentemente, ao projetar arquiteturas de Redes Neurais Profundas, queremos que a saída de convolução seja do mesmo tamanho que a entrada. Isso pode ser obtido preenchendo as extremidades da entrada com um número de entradas (normalmente) de zero, geralmente em ambos os lados. O enchimento é feito principalmente por conveniência. Isso às vezes pode afetar o desempenho e resultar em efeitos de borda estranhos, ou seja, ao usar uma não linearidade ReLU, o preenchimento de zero não é irracional.

<!--
## Deep Convolution Neural Networks (DCNNs)
-->

## Redes Neurais de Convolução Profunda (DCNNs)

<!--As previously described, deep neural networks are typically organized as repeated alternation between linear operators and point-wise nonlinearity layers. In convolutional neural networks, the linear operator will be the convolution operator described above. There is also an optional third type of layer called the pooling layer.
-->

Conforme descrito anteriormente, as redes neurais profundas são normalmente organizadas como alternância repetida entre operadores lineares e camadas não lineares pontuais. Em redes neurais convolucionais, o operador linear será o operador de convolução descrito acima. Também existe um terceiro tipo opcional de camada, denominado camada de pool.

<!--The reason for stacking multiple such layers is that we want to build a hierarchical representation of the data. CNNs do not have to be limited to processing images, they have also been successfully applied to speech and language. Technically they can be applied to any type of data that comes in the form of arrays, although we also these arrays to satisfy certain properties.
-->

A razão para empilhar várias dessas camadas é que queremos construir uma representação hierárquica dos dados. As CNNs não precisam se limitar a processar imagens; elas também foram aplicadas com sucesso à fala e à linguagem. Tecnicamente, eles podem ser aplicados a qualquer tipo de dado que venha na forma de arrays, embora também utilizemos esses arrays para satisfazer certas propriedades.

<!--Why would we want to capture the hierarchical representation of the world? Because the world we live in is compositional. This point is alluded to in previous sections. Such hierarchical nature can be observed from the fact that local pixels assemble to form simple motifs such as oriented edges. These edges in turn are assembled to form local features such as corners, T-junctions, etc. These edges are assembled to form motifs that are even more abstract. We can keep building on these hierarchical representation to eventually form the objects we observe in the real world.
-->

Por que desejaríamos capturar a representação hierárquica do mundo? Porque o mundo em que vivemos é composto. Este ponto é mencionado nas seções anteriores. Essa natureza hierárquica pode ser observada a partir do fato de que os pixels locais se reúnem para formar motivos simples, como bordas orientadas. Essas bordas, por sua vez, são montadas para formar características locais, como cantos, junções em T, etc. Essas bordas são montadas para formar motivos que são ainda mais abstratos. Podemos continuar construindo sobre essas representações hierárquicas para, eventualmente, formar os objetos que observamos no mundo real.

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Figure 10. Feature visualization of convolutional net trained on ImageNet from [Zeiler & Fergus 2013]</center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/cnn_features.png" alt="CNN Features" style="zoom:35%;" /><br>
Figura 10. Visualização de recurso de rede convolucional treinada em ImageNet de [Zeiler & Fergus 2013]</center>

<!--
This compositional, hierarchical nature we observe in the natural world is therefore not just the result of our visual perception, but also true at the physical level. At the lowest level of description, we have elementary particles, which assembled to form atoms, atoms together form molecules, we continue to build on this process to form materials, parts of objects and eventually full objects in the physical world.
-->

Essa natureza composicional e hierárquica que observamos no mundo natural não é, portanto, apenas o resultado de nossa percepção visual, mas também verdadeira no nível físico. No nível mais baixo de descrição, temos partículas elementares, que se agrupam para formar átomos, átomos juntos formam moléculas. Continuamos a desenvolver esse processo para formar materiais, partes de objetos e, eventualmente, objetos completos no mundo físico.

<!--The compositional nature of the world might be the answer to Einstein's rhetorical question on how humans understand the world they live in:
-->

A natureza composicional do mundo pode ser a resposta à pergunta retórica de Einstein sobre como os humanos entendem o mundo em que vivem:

<!-- The most incomprehensible thing about the universe is that it is comprehensible.
-->

> A coisa mais incompreensível sobre o universo é que ele é compreensível.

<!--The fact that humans understand the world thanks to this compositional nature still seems like a conspiracy to Yann. It is, however, argued that without compositionality, it will take even more magic for humans to comprehend the world they live in. Quoting the great mathematician Stuart Geman:
-->

O fato de os humanos entenderem o mundo graças a essa natureza composicional ainda parece uma conspiração para Yann. No entanto, argumenta-se que, sem composicionalidade, será necessário ainda mais magia para os humanos compreenderem o mundo em que vivem. Citando o grande matemático Stuart Geman:

<!-- The world is compositional or God exists.
-->

> O mundo é composicional ou Deus existe.

<!--
## [Inspirations from Biology](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)
-->

## [Inspirações na Biologia](https://www.youtube.com/watch?v=FW5gFiJb-ig&t=2254s)

<!--So why should Deep Learning be rooted in the idea that our world is comprehensible and has a compositional nature? Research conducted by Simon Thorpe helped motivate this further. He showed that the way we recognize everyday objects is extremely fast. His experiments involved flashing a set of images every 100ms, and then asking users to identify these images, which they were able to do successfully. This demonstrated that it takes about 100ms for humans to detect objects. Furthermore, consider the diagram below, illustrating parts of the brain annotated with the time it takes for neurons to propagate from one area to the next:
-->

Então, por que o Deep Learning deveria estar enraizado na ideia de que nosso mundo é compreensível e tem uma natureza composicional? A pesquisa conduzida por Simon Thorpe ajudou a motivar isso ainda mais. Ele mostrou que a maneira como reconhecemos objetos do cotidiano é extremamente rápida. Seus experimentos envolviam gerar um conjunto de imagens a cada 100 ms e, em seguida, pedir aos usuários que identificassem essas imagens, o que eles foram capazes de fazer com sucesso. Isso demonstrou que leva cerca de 100 ms para os humanos detectarem objetos. Além disso, considere o diagrama abaixo, ilustrando partes do cérebro anotadas com o tempo que leva para os neurônios se propagarem de uma área para a próxima:

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Simon_Thorpe.png" alt="Simon_Thorpe" style="zoom:55%;" /></center>

<!--<div align="center">Figure 11. Simon Thorpe's model of visual information flow in the brain <div>
-->

<div align="center">Figura 11. Modelo de Simon Thorpe de fluxo de informações visuais no cérebro</div>

<!--Signals pass from the retina to the LGN (helps with contrast enhancement, gate control, etc.), then to the V1 primary visual cortex, V2, V4, then to the inferotemporal cortex (PIT), which is the part of the brain where categories are defined. Observations from open-brain surgery showed that if you show a human a film, neurons in the PIT will fire only when they detect certain images -- such as Jennifer Aniston or a person's grandmother -- and nothing else. The neural firings are invariant to things such as position, size, illumination, your grandmother's orientation, what she's wearing, etc.
-->

Os sinais passam da retina para o LGN (ajuda com aumento de contraste, controle de porta, etc.), em seguida, para o córtex visual primário V1, V2, V4 e, em seguida, para o córtex inferotemporal (PIT), que é a parte do cérebro onde categorias são definidas. As observações da cirurgia de cérebro aberto mostraram que, se você mostrar um filme a um humano, os neurônios no PIT serão disparados apenas quando detectarem certas imagens - como Jennifer Aniston ou a avó de uma pessoa - e nada mais. Os disparos neurais são invariáveis ​​a coisas como posição, tamanho, iluminação, orientação de sua avó, o que ela está vestindo, etc.

<!--Furthermore, the fast reaction times with which humans were able to categorize these items -- barely enough time for a few spikes to get through -- demonstrates that it's possible to do this without additional time spent on complex recurrent computations. Rather, this is a single feed-forward process.
-->

Além disso, os tempos de reação rápidos com os quais os humanos foram capazes de categorizar esses itens - apenas o tempo suficiente para alguns picos passarem - demonstra que é possível fazer isso sem tempo adicional gasto em cálculos recorrentes complexos. Em vez disso, este é um único processo de feed-forward.

<!--These insights suggested that we could develop a neural network architecture which is completely feed-forward, yet still able to solve the problem of recognition, in a way that is invariant to irrelevant transformations of the input.
-->

Esses insights sugeriram que poderíamos desenvolver uma arquitetura de rede neural que é completamente feed-forward, mas ainda capaz de resolver o problema de reconhecimento, de uma forma que é invariável para transformações irrelevantes de entrada.

<!--One further insight from the human brain comes from Gallant & Van Essen, whose model of the human brain illustrates two distinct pathways:
-->

Um outro insight do cérebro humano vem de Gallant & Van Essen, cujo modelo do cérebro humano ilustra duas vias distintas:

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Gallant_and_Van_Essen.png" alt="Gallant_and_Van_Essen" style="zoom:55%;" /></center>

<!--<div align="center">Figure 12. Gallen & Van Essen's model of dorsal & ventral pathways in the brain <div>
-->

<div align="center">Figura 12. Modelo de Gallen e Van Essen das vias dorsais e ventrais no cérebro </div>

<!--The right side shows the ventral pathway, which tells you what you're looking at, while the left side shows the dorsal pathway, which identifies locations, geometry, and motion. They seem fairly separate in the human (and primate) visual cortex (with a few interactions between them of course).
-->

O lado direito mostra a via ventral, que indica o que você está olhando, enquanto o lado esquerdo mostra a via dorsal, que identifica localizações, geometria e movimento. Eles parecem bastante separados no córtex visual humano (e primata) (com algumas interações entre eles, é claro).

<!--
### Hubel & Weisel's contributions (1962)
-->

### Contribuições de Hubel & Weisel (1962)

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Hubel_and_Weisel.png" alt="Hubel_and_Weisel" style="zoom:55%;" /></center>

<!--<div align="center">Figure 13. Hubel & Weisel's experiments with visual stimuli in cat brains <div>
-->

<div align="center"> Figura 13. Experimentos de Hubel e Wiesel com estímulos visuais em cérebros de gatos </div>

<!--Hubel and Weisel experiments used electrodes to measure neural firings in cat brains in response to visual stimuli. They discovered that neurons in the V1 region are only sensitive to certain areas of a visual field (called "receptive fields"), and detect oriented edges in that area. For example, they demonstrated that if you showed the cat a vertical bar and start rotating it, at a particular angle the neuron will fire. Similarly, as the bar moves away from that angle, the activation of the neuron diminishes. These activation-selective neurons Hubel & Weisel named "simple cells", for their ability to detect local features.
-->

Os experimentos de Hubel e Weisel usaram eletrodos para medir disparos neurais em cérebros de gatos em resposta a estímulos visuais. Eles descobriram que os neurônios na região V1 são sensíveis apenas a certas áreas de um campo visual (chamadas de "campos receptivos") e detectam bordas orientadas nessa área. Por exemplo, eles demonstraram que se você mostrasse ao gato uma barra vertical e começasse a girá-la, em um determinado ângulo o neurônio dispararia. Da mesma forma, conforme a barra se afasta desse ângulo, a ativação do neurônio diminui. Hubel & Weisel denominaram esses neurônios seletivos de ativação de "células simples", por sua capacidade de detectar características locais.

<!--They also discovered that if you move the bar out of the receptive field, that particular neuron doesn't fire any more, but another neuron will. There are local feature detectors corresponding to all areas of the visual field, hence the idea that the human brain processes visual information as a collection of "convolutions".
-->

Eles também descobriram que se você mover a barra para fora do campo receptivo, aquele neurônio específico não dispara mais, mas outro neurônio o faz. Existem detectores de características locais que correspondem a todas as áreas do campo visual, daí a ideia de que o cérebro humano processa informações visuais como uma coleção de "circunvoluções".

<!--Another type of neuron, which they named "complex cells", aggregate the output of multiple simple cells within a certain area. We can think of these as computing an aggregate of the activations using a function such as maximum, sum, sum of squares, or any other function not depending on the order. These complex cells detect edges and orientations in a region, regardless of where those stimuli lie specifically within the region. In other words, they are shift-invariant with respect to small variations in positions of the input.
-->

Outro tipo de neurônio, que eles chamaram de "células complexas", agregam a saída de várias células simples dentro de uma determinada área. Podemos pensar nisso como o cálculo de um agregado das ativações usando uma função como máximo, soma, soma dos quadrados ou qualquer outra função que não dependa da ordem. Essas células complexas detectam bordas e orientações em uma região, independentemente de onde esses estímulos estejam especificamente na região. Em outras palavras, eles são invariáveis ​​ao deslocamento em relação a pequenas variações nas posições da entrada.

<!--
### Fukushima's contributions (1982)
-->

### Contribuições de Fukushima (1982)

<!--<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>
-->

<center><img src="{{site.baseurl}}/images/week03/03-1/Fukushima.png" alt="Fukushima" style="zoom:55%;" /></center>

<!--<div align="center">Figure 14. Fukushima's CNN model <div>
-->

<div align="center"> Figura 14. Modelo CNN de Fukushima </div>

<!--Fukushima was the first to implement the idea of multiple layers of simple cells and complex cells with computer models, using a dataset of handwritten digits. Some of these feature detectors were hand-crafted or learned, though the learning used unsupervised clustering algorithms, trained separately for each layer, as backpropagation was not yet in use.
-->

Fukushima foi o primeiro a implementar a ideia de múltiplas camadas de células simples e células complexas com modelos de computador, usando um conjunto de dados de dígitos escritos à mão. Alguns desses detectores de recursos foram feitos à mão ou aprendidos, embora o aprendizado usasse algoritmos de agrupamento não supervisionados, treinados separadamente para cada camada, já que a retropropagação ainda não estava em uso.

<!--Yann LeCun came in a few years later (1989, 1998) and implemented the same architecture, but this time trained them in a supervised setting using backpropagation. This is widely regarded as the genesis of modern convolutional neural networks. (Note: Riesenhuber at MIT in 1999 also re-discovered this architecture, though he didn't use backpropagation.)
-->

Yann LeCun veio alguns anos depois (1989, 1998) e implementou a mesma arquitetura, mas desta vez os treinou em um ambiente supervisionado usando retropropagação. Isso é amplamente considerado como a gênese das redes neurais convolucionais modernas. (Observação: Riesenhuber no MIT em 1999 também redescobriu essa arquitetura, embora ele não tenha usado a retropropagação.)
