---
lang: pt
lang-ref: ch.02-3
lecturer: Alfredo Canziani
title: Redes neurais artificiais (ANNs)
authors:
date: 4 Feb 2020
typora-root-url: 02-3
translation-date: 28 Fev 2021
translator: Lenin Cristi
---

<!-- ## [Supervised learning for classification](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

* Consider **Fig. 1(a)** below. The points in this graph lie on the branches of the spiral, and live in $\R^2$. Each colour represents a class label. The number of unique classes is $K = 3$. This is represented mathematically by **Eqn. 1(a)**.

* **Fig. 1(b)** shows a similar spiral, with an added Gaussian noise term. This is represented mathematically by **Eqn. 1(b)**.

  In both cases, these points are not linearly separable.

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> "Clean" 2D spiral
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> "Noisy" 2D spiral
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Eqn. 1(a)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Eqn. 1(b)</b></center>

What does it mean to perform **classification**? Consider the case of **logistic regression**. If logistic regression for classification is applied to this data, it will create a set of **linear planes** (decision boundaries) in an attempt to separate the data into its classes. The issue with this solution is that in each region, there are points belonging to multiple classes. The branches of the spiral cross the linear decision boundaries. This is **not** a great solution!

**How do we fix this?** We transform the input space such that the data are forced to be linearly separable. Over the course of training a neural network to do this, the decision boundaries that it learns will try to adapt to the distribution of the training data.

**Note:** A neural network is always represented from the **bottom up**. The first layer is at the bottom, and the last at the top. This is because conceptually, the input data are low-level features for whatever task the neural network is attempting. As the data traverse **upward** through the network, each subsequent layer extracts features at a higher level. -->

## [Aprendizagem supervisionada para classificação](https://www.youtube.com/watch?v=WAn6lip5oWk&t=150s)

* Considere a **Fig. 1(a)** abaixo. Os pontos neste gráfico estão nos ramos da espiral, no intervalo $\R^2$. Cada cor representa um rótulo de classe. O número de classes únicas é $K = 3$. Isso é representado matematicamente por **Eqn. 1(a)**.

* A **Fig. 1(b)** mostra uma espiral semelhante, com um termo de ruído Gaussiano adicionado. Isso é representado matematicamente por **Eqn. 1(b)**.

  Em ambos os casos, esses pontos não são linearmente separáveis.

  <center>
  <table border="0">
    <td>
      <center>
    <img src="{{site.baseurl}}/images/week02/02-3/clean-spiral.png" width="350px" /><br>
       <b>Fig. 1(a)</b> Espiral 2D "limpa"
       </center>
      </td>
      <td>
      <center>
      <img src="{{site.baseurl}}/images/week02/02-3/noisy-spiral.png" width="350px" /><br>
       <b>Fig. 1(b)</b> Espiral 2D "ruidosa"
       </center>
      </td>
  </table>
  </center>


$$
X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1)\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1)\right]}\end{array}\right) \\
0 \leq t \leq 1, \quad k=1, ..., K
$$

  <center><b>Eqn. 1(a)</b> </center>

$$
  X_{k}(t)=t\left(\begin{array}{c}{\sin \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]} \\ {\cos \left[\frac{2 \pi}{K}(2 t+k-1 +\mathcal{N}\left(0, \sigma^{2}\right))\right]}\end{array}\right)\\0 \leq t \leq 1, \quad k=1, ..., K
$$

<center><b>Eqn. 1(b)</b></center>

O que significa realizar uma **classificação**? Considere o caso da **regressão logística**. Se a regressão logística para classificação for aplicada a esses dados, ela vai criar um conjunto de **planos lineares** (limites de decisão) em uma tentativa de separar os dados em suas classes. O problema com esta solução é que em cada região, existem pontos pertencentes a várias classes. Os ramos da espiral cruzam os limites de decisão linear. Esta **não** é a melhor solução!

**Como consertar isso?** Nós transformamos o espaço de entrada de forma que os dados sejam forçados a serem linearmente separáveis. Durante o treinamento de uma rede neural para realizar essa tarefa, os limites de decisão que ela aprende tentarão se adaptar à distribuição dos dados de treinamento.

**Nota:** Uma rede neural é sempre representada a partir **de baixo para cima**. A primeira camada está na parte inferior e a última no topo. Isso ocorre porque, conceitualmente, os dados de entrada são características de baixo nível para qualquer tarefa que a rede neural esteja tentando. Conforme os dados percorrem **para cima** pela rede, cada camada subsequente extrai recursos em um nível superior.

<!-- ## Training data

Last week, we saw that a newly initialised neural network transforms its input in an arbitrary way. This transformation, however, isn't **(initially)** instrumental in performing the task at hand. We explore how, using data, we can force this transformation to have some meaning that is relevant to the task at hand. The following are data used as training input for a network.

* $\vect{X}$ represents the input data, a matrix of dimensions $m$ (number of training data points) x $n$ (dimensionality of each input point). In case of the data shown in Figures **1(a)** and **1(b)**, $n = 2$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Training data
</center>

* Vector $\vect{c}$  and matrix $\boldsymbol{Y}$ both represent class labels for each of the $m$ data points. In the example above, there are $3$ distinct classes.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, and $\vect{c} \in \R^m$. However, we may not use $\vect{c}$ as training data. If we use distinct numeric class labels  $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, the network may infer an order within the classes that isn't representative of the data distribution.
  * To bypass this issue, we use a **one-hot encoding**. For each label $c_i$, a $K$ dimensional zero-vector $\vect{y}^{(i)}$ is created, which has the $c_i$-th element set to $1$ (see **Fig. 3** below).

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> One hot encoding
</center>

  * Therefore, $\boldsymbol Y \in \R^{m \times K}$. This matrix can also be thought of as having some probabilistic mass, which is fully concentrated on one of the $K$ spots. -->

## Dados de treinamento

Na semana passada, vimos que uma rede neural recém-inicializada transforma sua entrada de maneira arbitrária. Essa transformação, no entanto, não é **(inicialmente)** instrumental na execução da tarefa em questão. Exploraremos agora como, usando dados, podemos forçar essa transformação a ter algum significado que seja relevante para a tarefa em questão. A seguir estão os dados usados como entrada de treinamento para uma rede.

* $\vect{X}$ representa os dados de entrada, uma matriz de dimensões $m$ (número de pontos de dados de treinamento) x $n$ (dimensão de cada ponto de entrada). No caso dos dados mostrados nas Figuras **1(a)** e **1(b)**, $n = 2$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/training-data.png" width="600px" /><br>
<b>Fig. 2</b> Dados de treinamento
</center>

* O vetor $\vect{c}$ e a matriz $\boldsymbol{Y}$ ambos representam rótulos de classe para cada um dos $m$ pontos de dados. No exemplo acima, existem $3$ classes distintas.

  * $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, e $\vect{c} \in \R^m$. De qualquer modo, não podemos usar $\vect{c}$ como dados de treinamento. Se usarmos rótulos de classe numéricos distintos $c_i \in \lbrace 1, 2, \cdots, K \rbrace$, a rede pode inferir uma ordem dentro das classes que não é representativa da distribuição dos dados.
  * Para contornar esse problema, usamos um método **one-hot encoding**. Para cada etiqueta $c_i$, um vetor de dimensão $K$ zerado $\vect{y}^{(i)}$ é criado, no qual o $c_i$-ésimo elemento é setado para $1$ (veja a **Fig. 3** abaixo).

<center>
<img src="{{site.baseurl}}/images/week02/02-3/one-hot.png" width="250px" /><br>
<b>Fig. 3</b> Codificação *One hot*
</center>

  * Portanto, $\boldsymbol Y \in \R^{m \times K}$. Esta matriz também pode ser pensada como tendo alguma massa probabilística, que está totalmente concentrada em um dos $K$ pontos.

<!--
## Fully (FC) connected layers

We will now take a look at what a fully connected (FC) network is, and how it works.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Fully connected neural network
</center>

Consider the network shown above in **Fig. 4**. The input data, $\boldsymbol x$, is subject to an affine transformation defined by $\boldsymbol W_h$, followed by a non-linear transformation. The result of this non-linear transformation is denoted as $\boldsymbol h$, representing a **hidden** output, *i.e* one that is not **seen** from outside the network. This is followed by another affine transformation ($\boldsymbol W_y$), followed by another non-linear transformation. This produces the final output, $\boldsymbol{\hat{y}}$. This network can be represented mathematically by the equations in **Eqn. 2** below. $f$ and $g$ are both non-linearities.

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>Eqn. 2</b> Mathematics behind a FC network</center>

A basic neural network such as the one shown above is merely a set of successive pairs, with each pair being an affine transformation followed by a non-linear operation (squashing). Frequently used non-linear functions include ReLU, sigmoid, hyperbolic tangent, and softmax.

The network shown above is a 3-layer network:

 1. input neuron
 2. hidden neuron
 3. output neuron

Therefore, a $3$-layer neural network has $2$ affine transformations. This can be extended to a $n$-layer network.

Now let's move to a more complicated case.

Let's do a case of 3 hidden layers, fully connected in each layer. An illustration can be found in **Fig. 5**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Neural net with 3 hidden layers
</center>

Let's consider a neuron $j$ in the second layer. It's activation is:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

where $\vect{w}^{(j)}$ is the $j$-th row of $\vect{W}^{(1)}$.

Notice that the activation of the input layer in this case is just the identity. The hidden layers can have activations like ReLU, hyperbolic tangent, sigmoid, soft (arg)max, *etc*.

The activation of the last layer in general would depend on your use case, as explained in [this](https://piazza.com/class/k5spqaanqk51ks?cid=36) Piazza post. -->

## Camadas totalmente conectadas (FC)

Vamos agora dar uma olhada no que é uma rede totalmente conectada (FC) e como ela funciona.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/FC-net.png" height="250px" /><br>
<b>Fig. 4</b> Rede neural totalmente conectada
</center>

Considere a rede mostrada acima na **Fig. 4**. Os dados de entrada, $\boldsymbol x$, estão sujeitos a uma transformação afim definida por $\boldsymbol W_h$, seguida por uma transformação não linear. O resultado desta transformação não linear é denotado como $\boldsymbol h$, representando uma saída **oculta**, *isto é* aquela que não é **vista** de fora da rede. Isso é seguido por outra transformação afim ($\boldsymbol W_y$), seguida por outra transformação não linear. Isso produz a saída final, $\boldsymbol{\hat{y}}$. Esta rede pode ser representada matematicamente pelas equações em **Eqn. 2** logo abaixo. $f$ e $g$ são ambas não linearidades.

$$
\begin{aligned}
&\boldsymbol h=f\left(\boldsymbol{W}_{h} \boldsymbol x+ \boldsymbol b_{h}\right)\\
&\boldsymbol{\hat{y}}=g\left(\boldsymbol{W}_{y} \boldsymbol h+ \boldsymbol b_{y}\right)
\end{aligned}
$$

<center><b>Eqn. 2</b> A matemática por trás de uma rede FC</center>

Uma rede neural básica como a mostrada acima é meramente um conjunto de pares sucessivos, com cada par sendo uma transformação afim seguida por uma operação não linear (achatadas). Funções não lineares usadas com frequência incluem *ReLU*, sigmóide, tangente hiperbólica e softmax.

A rede mostrada acima é uma rede de 3 camadas:

 1. neurônio de entrada
 2. neurônio oculto
 3. neurônio de saída

Sendo assim, uma rede de $3$ camadas têm $2$ transformações afins. Isso pode ser estendido a uma rede de $n$ camadas.

Agora vamos passar para um caso mais complicado.

Vamos ver um caso com 3 camadas ocultas, totalmente conectadas em cada camada. Uma ilustração pode ser vista na **Fig. 5**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/pre-inference4layers.png" /><br>
<b>Fig. 5</b> Rede neural com 3 camadas ocultas
</center>

Vamos considerar o neurônio $j$ na segunda camada. Sua ativação é:

$$
a^{(2)}_j = f(\boldsymbol w^{(j)} \boldsymbol x + b_j) = f\Big( \big(\sum_{i=1}^n w_i^{(j)} x_i\big) +b_j ) \Big)
$$

onde $\vect{w}^{(j)}$ é a $j$-ésima linha de $\vect{W}^{(1)}$.

Observe que a ativação da camada de entrada, neste caso, é apenas a identidade. As camadas ocultas podem ter ativações como *ReLU*, tangente hiperbólica, sigmóide, soft (arg)max, *etc*.

A ativação da última camada em geral depende do seu caso de uso, conforme explicado neste artigo no Piazza [this](https://piazza.com/class/k5spqaanqk51ks?cid=36).

<!-- ## Neural network (inference)

Let's think about the three-layer (input, hidden, output) neural network again, as seen in **Fig. 6**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Three-layer neural network
</center>

What kind of functions are we looking at?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

However, it is helpful to visualize the fact that there is a hidden layer, and the mapping can be expanded as:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

What might an example configuration for the case above look like? In this case, one has input of dimension two ($n=2$), the single hidden layer could have dimensionality of 1000 ($d = 1000$), and we have 3 classes ($C=3$). There are good practical reasons to not have so many neurons in one hidden layer, so it could make sense to split that single hidden layer into 3 with 10 neurons each ($1000 \rightarrow 10 \times 10 \times 10$). -->

## Rede neural (inferência)

Vamos pensar sobre a rede neural de três camadas (entrada, oculta, saída) novamente, como vista na **Fig. 6**

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-layer-inference.png" height="250px"/><br>
<b>Fig. 6</b> Rede neural de três camadas
</center>

Que tipo de funções estamos olhando?

$$
\boldsymbol {\hat{y}} = \boldsymbol{\hat{y}(x)}, \boldsymbol{\hat{y}}: \mathbb{R}^n \rightarrow \mathbb{R}^K, \boldsymbol{x} \mapsto \boldsymbol{\hat{y}}
$$

No entanto, é útil visualizar o fato de que há uma camada oculta, e o mapeamento pode ser expandido como:

$$
\boldsymbol{\hat{y}}: \mathbb{R}^{n} \rightarrow \mathbb{R}^d \rightarrow \mathbb{R}^K, d \gg n, K
$$

Como seria uma configuração de exemplo para o caso acima? Neste caso, um tem entrada de dimensão dois ($n=2$), a única camada oculta pode ter dimensionalidade de 1000 ($d = 1000$), e temos 3 classes ($C=3$). Existem boas razões práticas para não ter tantos neurônios em uma camada oculta, então pode fazer sentido dividir essa única camada oculta em 3 camadas com 10 neurônios cada ($1000 \rightarrow 10 \times 10 \times 10$).

<!-- ## [Neural network (training I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

So what does typical training look like? It is helpful to formulate this into the standard terminology of losses.

First, let us re-introduce the soft (arg)max and explicitly state that it is a common activation function for the last layer, when using negative log-likelihood loss, in cases for multi-class prediction. As stated by Professor LeCun in lecture, this is because you get nicer gradients than if you were to use sigmoids and square loss. In addition, your last layer will already be normalized (the sum of all the neurons in the last layer come out to 1), in a way that is nicer for gradient methods than explicit normalization (dividing by the norm).

The soft (arg)max will give you logits in the last layer that look like this:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

It is important to note that the set is not closed because of the strictly positive nature of the exponential function.

Given the set of the predictions $\matr{\hat{Y}}$, the loss will be:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

Here $c$ denotes the integer label, not the one hot encoding representation.

So let's do two examples, one where an example is correctly classified, and one where it is not.

Let's say

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

What is the instance wise loss?

For the case of *nearly perfect prediction* ($\sim$ means *circa*):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

For the case of *nearly absolutely wrong*:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

Note in the above examples, $\sim 0 \rightarrow 0^{+}$ and $\sim 1 \rightarrow 1^{-}$. Why is this so? Take a minute to think.

**Note**: It is important to know that if you use `CrossEntropyLoss`, you will get `LogSoftMax` and negative loglikelihood `NLLLoss` bundled together, so don't do it twice! -->

## [Rede neural (treinamento I)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=822s)

Então, como se parece um treinamento típico? É útil formular isso na terminologia padrão de perdas.

Primeiro, vamos reintroduzir a função soft (arg)max e assumir explicitamente que ela é uma função de ativação comum para a última camada quando usamos uma função negativa logarítmica de probabilidade como função de perda *(negative log-likelihood loss)* nos casos de previsão multi classe. Conforme ensinado pelo professor LeCun na palestra, isso ocorre porque você obtém gradientes mais agradáveis do que se você usasse sigmóides e quadráticas como funções de perda. Adicionalmente, sua última camada já estará normalizada (a soma de todos os neurônios na última camada é 1), de uma forma que é melhor para métodos gradientes do que a normalização explícita (dividir pela norma).

A soft (arg)max fornecerá *logits* na última camada que se parecem com isto:

$$
\text{soft{(arg)}max}(\boldsymbol{l})[c] = \frac{ \exp(\boldsymbol{l}[c])}   {\sum^K_{k=1} \exp(\boldsymbol{l}[k])}  \in (0, 1)
$$

É importante notar que o conjunto não é fechado devido à natureza estritamente positiva da função exponencial.

Dado o conjunto de previsões $\matr{\hat{Y}}$, a perda será:

$$
\mathcal{L}(\boldsymbol{\hat{Y}}, \boldsymbol{c}) = \frac{1}{m} \sum_{i=1}^m \ell(\boldsymbol{\hat{y}_i}, c_i), \quad
\ell(\boldsymbol{\hat{y}}, c) = -\log(\boldsymbol{\hat{y}}[c])
$$

Aqui $c$ indica o rótulo inteiro, e não sua representação codificada em *one hot*.

Vamos fazer então dois exemplos, um corretamente classificado e outro não.

Digamos

$$
\boldsymbol{x}, c = 1 \Rightarrow \boldsymbol{y} =
{\footnotesize\begin{pmatrix}
1 \\
0 \\
0
\end{pmatrix}}
$$

Qual é a perda por instância?

Para o caso de um *previsão quase perfeita* ($\sim$ significa *aproximadamente*):

$$
\hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
 \Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 1 \\ \sim 0 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow 0^{+}
$$

Para o caso de uma previsão *quase que absolutamente errada*:

$$ \hat{\boldsymbol{y}}(\boldsymbol{x}) =
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
\Rightarrow \ell \left(
{\footnotesize\begin{pmatrix} \sim 0 \\ \sim 1 \\ \sim 0 \end{pmatrix}}
, 1\right) \rightarrow +\infty  $$

Note que nos exemplos acima, $\sim 0 \rightarrow 0^{+}$ e $\sim 1 \rightarrow 1^{-}$. Porque isto é assim? Tire um minuto para pensar.

**Nota**: É importante saber que se você usar `CrossEntropyLoss`, você vai ter `LogSoftMax` e uma função de probabilidade logaritmica negativa `NLLLoss` empacotadas juntas, então não faça isso duas vezes!

<!-- ## [Neural network (training II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

For training, we aggregate all trainable parameters -- weight matrices and biases -- into a collection we call $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. This allows us to write the objective function or loss as:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

This makes the loss depend on the output of the network  $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, so we can turn this into an optimization problem.

A simple illustration of how this works can be seen in **Fig. 7**, where $J(\vartheta)$, the function we need to minimise, has only a scalar parameter $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Optimizing a loss function through gradient descent.
</center>

We pick a random initialization point $\vartheta_0$ -- with associated loss $J(\vartheta_0)$. We can compute the derivative evaluated at that point $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. In this case, the slope of the derivative is positive. So we need to take a step in the direction of steepest descent. In this case, that is $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

The iterative repetition of this process is known as gradient descent. Gradient methods are the primary tools to train a neural network.

In order to compute the necessary gradients, we have to use back-propagation

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$ -->

## [Rede neural (treinamento II)](https://www.youtube.com/watch?v=WAn6lip5oWk&t=2188s)

Para o treinamento, agregamos todos os parâmetros treináveis - matrizes de peso e os vieses -- em uma coleção que chamamos $\mathbf{\Theta} = \lbrace\boldsymbol{W_h, b_h, W_y, b_y} \rbrace$. Isso nos permite escrever a função objetivo ou de perda como:

$$
J \left( \mathbf{\Theta} \right) = \mathcal{L} \left( \boldsymbol{\hat{Y}} \left( \mathbf{\Theta} \right), \boldsymbol c \right) \in \mathbb{R}^{+}
$$

Isso faz com que a perda dependa da saída da rede $\boldsymbol {\hat{Y}} \left( \mathbf{\Theta} \right)$, para que possamos transformar isso em um problema de otimização.

Uma ilustração simples de como isso funciona pode ser vista em **Fig. 7**, onde $J(\vartheta)$, a função que precisamos minimizar, tem apenas um parâmetro escalar $\vartheta$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/1-GD.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 7</b> Otimizando uma função de perda através do gradiente descendente.
</center>

Nós escolhemos um ponto de inicialização aleatório $\vartheta_0$ -- com uma perda associada $J(\vartheta_0)$. Podemos calcular a derivada avaliada naquele ponto $J'(\vartheta_0) = \frac{\text{d} J(\vartheta)}{\text{d} \vartheta} (\vartheta_0)$. Neste caso, a inclinação da derivada é positiva. Portanto, precisamos dar um passo na direção da descida mais íngreme. Neste caso, isso é $-\frac{\text{d} J(\vartheta)}{\text{d} \vartheta}(\vartheta_0)$.

A repetição iterativa desse processo é conhecida como gradiente descendente. Os métodos de gradiente são as principais ferramentas para treinar uma rede neural.

Para calcular os gradientes necessários, temos que usar retropropagação

$$ \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_y}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol{W_y}} \quad \quad \quad  \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{W_h}} = \frac{\partial \, J(\mathbf{\Theta})}{\partial \, \boldsymbol{\hat{y}}} \; \frac{\partial \, \boldsymbol{\hat{y}}}{\partial \, \boldsymbol h} \;\frac{\partial \, \boldsymbol h}{\partial \, \boldsymbol{W_h}} $$ 

<!-- ## Spiral classification - Jupyter notebook

The Jupyter notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). In order to run the notebook, make sure you have `the dl-minicourse` environment installed as specified in [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

An explanation of how to use `torch.device()` can be found in [last week's notes](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

Like before, we are going to be working with points in $\mathbb{R}^2$ with three different categorical labels -- in red, yellow and blue -- as can be seen in **Fig. 8**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Spiral classification data.
</center>

`nn.Sequential()` is a container, which passes modules to the constructor in the order that they are added; `nn.linear()` is miss-named as it applies an **affine** transformation to the incoming data: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. For more information, refer to the [PyTorch documentation](https://pytorch.org/docs/stable/nn.html).

Remember, an affine transformation is five things: rotation, reflection, translation, scaling and shearing.

As it can be seen in **Fig. 9**, when trying to separate the spiral data with linear decision boundaries - only using `nn.linear()` modules, without a non-linearity between them - the best we can achieve is an accuracy of $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Linear decision boundaries.
</center>

When we go from a linear model to one with two `nn.linear()` modules and a `nn.ReLU()` between them, the accuracy goes up to $95\%$. This is because the boundaries become non-linear and adapt much better to the spiral form of the data, as it can be seen in **Fig. 10**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Non-linear decision boundaries.
</center>

An example of a regression problem which can't be solved correctly with a linear regression, but is easily solved with the same neural network structure can be seen in [this notebook](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) and **Fig. 11**, which shows 10 different networks, where 5 have a `nn.ReLU()` link function and 5 have a `nn.Tanh()`. The former is a piecewise linear function, whereas the latter is a continuous and smooth regression.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 Neural networks, along with their variance and standard deviation.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center>

The yellow and green lines show the standard deviation and variance for the networks. Using these is useful for something similar to a "confidence interval" -- since the functions give a single prediction per output. Using ensemble variance prediction allows us to estimate the uncertainty with which the prediction is being made. The importance of this can be seen in **Fig. 12**, where we extend the decision functions outside the training interval and these tend towards $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Neural networks, with mean and standard deviation, outside training interval.<br>
Left: Five <code>ReLU</code> networks.  Right: Five <code>tanh</code> networks.
</center>

To train any Neural Network using PyTorch, you need 5 fundamental steps in the training loop:

1. `output = model(input)` is the model's forward pass, which takes the input and generates the output.
2. `J = loss(output, target <or> label)` takes the model's output and calculates the training loss with respect to the true target or label.
3. `model.zero_grad()` cleans up the gradient calculations, so that they are not accumulated for the next pass.
4. `J.backward()` does back-propagation and accumulation: It computes $\nabla_\texttt{x} J$ for every variable $\texttt{x}$ for which we have specified `requires_grad=True`. These are accumulated into the gradient of each variable: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` takes a step in gradient descent: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

When training a NN, it is very likely that you need these 5 steps in the order they were presented. -->

## Classificação espiral - *Jupyter notebook*

O *Jupyter notebook* pode ser encontrado [aqui](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/04-spiral_classification.ipynb). Para executar o notebook, certifique-se de ter o ambiente do mini curso `the dl-minicourse` instalado como especificado no [README.md](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/README.md).

Uma explicação de como usar `torch.device()` pode ser encontrada nas [notas da semana passada](https://atcold.github.io/pytorch-Deep-Learning-Minicourse/en/week01/01-3/).

Como antes, trabalharemos com pontos em $\mathbb{R}^2$ com três rótulos de categorias diferentes -- em vermelho, amarelo e azul -- como pode ser visto em **Fig. 8**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/2-data.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Fig. 8</b> Dados da classificação espiral.
</center>

`nn.Sequential()` é um contêiner, que passa os módulos para o construtor na ordem em que são adicionados; `nn.linear()` tem um nome incorreto, pois aplica uma transformação **afim** para os dados de entrada: $\boldsymbol y = \boldsymbol W \boldsymbol x + \boldsymbol b$. Para obter mais informações, consulte a [documentação PyTorch](https://pytorch.org/docs/stable/nn.html).

Lembre-se, uma transformação afim consiste em cinco coisas: rotação, reflexão, translação, dimensionamento e cisalhamento.

Como pode ser visto na **Fig. 9**, ao tentar separar os dados espirais com limites de decisão linear - apenas usando módulos `nn.linear()`, sem uma não linearidade entre eles - o melhor que podemos alcançar é uma precisão de $50\%$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/3-linear.png" style="zoom: 60%; background-color:#DCDCDC;" /><br>
<b>Fig. 9</b> Limites de decisão lineares.
</center>

Quando vamos de um modelo linear para um com dois módulos `nn.linear()` e um `nn.ReLU()` entre eles, a precisão vai até $95\%$. Isso ocorre porque os limites se tornam não lineares e se adaptam muito melhor à forma espiral dos dados, como pode ser visto em **Fig. 10**.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/4-non-linear.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
    <b>Fig. 10</b> Limites de decisão não lineares.
</center>

Um exemplo de problema de regressão que não pode ser resolvido corretamente com uma regressão linear, mas é facilmente resolvido com a mesma estrutura de rede neural pode ser visto [neste caderno](https://github.com/Atcold/pytorch-Deep-Learning-Minicourse/blob/master/05-regression.ipynb) e na **Fig. 11**, que mostra 10 redes diferentes, onde 5 têm `nn.ReLU()` como função conectora e 5 tem `nn.Tanh()` como conectora. A primeira é uma função linear por partes, enquanto a última é uma regressão contínua e suave.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/5-nn-reg.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 11</b>: 10 redes neurais, junto com sua variância e desvio padrão.<br>
Esquerda: Cinco redes <code>ReLU</code>. Direita: Cinco redes <code>tanh</code>.
</center>

As linhas amarelas e verdes mostram o desvio padrão e a variância das redes. Usar isso é útil para ter algo semelhante a um "intervalo de confiança" -- uma vez que as funções fornecem uma única previsão por saída. O uso da previsão da variância do conjunto nos permite estimar a incerteza com a qual a previsão está sendo feita. A importância disso pode ser vista na **Fig. 12**, onde estendemos as funções de decisão fora do intervalo de treinamento e estas tendem a $+\infty, -\infty$.

<center>
<img src="{{site.baseurl}}/images/week02/02-3/6-nn-confidence.png" style="zoom: 64%; background-color:#DCDCDC;" /><br>
<b>Fig. 12</b> Redes neurais, com média e desvio padrão, fora do intervalo de treinamento.<br>
Esquerda: Cinco redes <code>ReLU</code>. Direita: Cinco redes <code>tanh</code>.
</center>

Para treinar qualquer rede neural usando PyTorch, você precisa de 5 etapas fundamentais no loop de treinamento:

1. `output = model(input)` é o passo adiante do modelo, que recebe a entrada e gera a saída.
2. `J = loss(output, target <or> label)` pega a saída do modelo e calcula a perda do treinamento em relação ao verdadeiro objetivo ou rótulo.
3. `model.zero_grad()` limpa os cálculos de gradiente, de modo que eles não sejam acumulados para a próxima passagem.
4. `J.backward()` faz a retropropagação e a acumulação: Calcula $\nabla_\texttt{x} J$ para cada variável $\texttt{x}$ para a qual nós especificamos `requires_grad=True`. E são acumulados no gradiente de cada variável: $\texttt{x.grad} \gets \texttt{x.grad} +  \nabla_\texttt{x} J$.
5. `optimiser.step()` dá um passo no gradiente descendente: $\vartheta \gets \vartheta - \eta\, \nabla_\vartheta J$.

Ao treinar uma *NN*, é muito provável que você precise dessas 5 etapas na ordem em que foram apresentadas.
