---
lang: pt
lang-ref: ch.02-2
lecturer: Yann LeCun
title: Gradientes de computação para módulos de NN e truques práticos para retropropagação
authors: Micaela Flores, Sheetal Laad, Brina Seidel, Aishwarya Rajan
date: 3 Feb 2020
translation-date: 28 Fev 2021
translator: Lenin Cristi
---

<!-- ## [A concrete example of backpropagation and intro to basic neural network modules](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)

### Example

We next consider a concrete example of backpropagation assisted by a visual graph. The arbitrary function $G(w)$ is input into the cost function $C$, which can be represented as a graph. Through the manipulation of multiplying the Jacobian matrices, we can transform this graph into the graph that will compute the gradients going backwards. (Note that PyTorch and TensorFlow do this automatically for the user, i.e. the forward graph is automatically "reversed" to create the derivative graph that backpropagates the gradient.)

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Gradient diagram" style="zoom:40%;" /></center>

In this example, the green graph on the right represents the gradient graph. Following the graph from the topmost node, it follows that

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

In terms of dimensions, $\frac{\partial C(y,\bar{y})}{\partial w}$ is a row vector of size $1\times N$ where $N$ is the number of components of $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$  is a row vector of size $1\times M$, where $M$ is the dimension of the output; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ is a matrix of size $M\times N$, where $M$ is the number of outputs of $G$ and $N$ is the dimension of $w$.

Note that complications might arise when the architecture of the graph is not fixed, but is data-dependent. For example, we could choose neural net module depending on the length of input vector. Though this is possible, it becomes increasingly difficult to manage this variation when the number of loops exceeds a reasonable amount. -->

## [Um exemplo concreto de retropropagação e uma introdução aos módulos básicos da rede neural](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2989s)

### Exemplo

A seguir, consideramos um exemplo concreto de retropropagação assistida por um gráfico visual. A função arbitrária $G(w)$ é a entrada da função de custo $C$, que pode ser representado como um gráfico. Através da manipulação de multiplicação das matrizes Jacobianas, podemos transformar este gráfico no gráfico que irá computar os gradientes indo para trás. (Observe que o PyTorch e o TensorFlow fazem isso automaticamente para o usuário, isto é, o gráfico progressivo é automaticamente "revertido" para criar o gráfico da derivada que retropropaga o gradiente.)

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-1.png" alt="Diagrama de gradiente" style="zoom:40%;" /></center>

Neste exemplo, o gráfico verde à direita representa o gráfico do gradiente. Seguindo o gráfico do nó superior, segue-se que

$$
\frac{\partial C(y,\bar{y})}{\partial w}=1 \cdot \frac{\partial C(y,\bar{y})}{\partial\bar{y}}\cdot\frac{\partial G(x,w)}{\partial w}
$$

Em termos de dimensões, $\frac{\partial C(y,\bar{y})}{\partial w}$ é um vetor linha de tamanho $1\times N$ onde $N$ é o número de componentes de $w$; $\frac{\partial C(y,\bar{y})}{\partial \bar{y}}$ é um vetor linha de tamanho $1\times M$, onde $M$ é a dimensão da saída; $\frac{\partial \bar{y}}{\partial w}=\frac{\partial G(x,w)}{\partial w}$ é uma matriz de tamanho $M\times N$, onde $M$ é o número de saídas de $G$ e $N$ é a dimensão de $w$.

Observe que podem surgir complicações quando a arquitetura do gráfico não é fixada, mas depende dos dados. Por exemplo, poderíamos escolher o módulo de rede neural dependendo do comprimento do vetor de entrada. Embora isso seja possível, torna-se cada vez mais difícil gerenciar essa variação quando o número de loops excede uma quantidade razoável.

<!-- ### Basic neural net modules

There exist different types of pre-built modules besides the familiar Linear and ReLU modules. These are useful because they are uniquely optimized to perform their respective functions (as opposed to being built by a combination of other, elementary modules).

- Linear: $Y=W\cdot X$

  $$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
  $$

- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{otherwise}
      \end{cases}
  $$

- Duplicate: $Y_1=X$, $Y_2=X$

  - Akin to a "Y - splitter" where both outputs are equal to the input.

  - When backpropagating, the gradients get summed

  - Can be split into $n$ branches similarly

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$


- Add: $Y=X_1+X_2$

  - With two variables being summed, when one is perturbed, the output will be perturbed by the same quantity, i.e.

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$


- Max: $Y=\max(X_1,X_2)$

  -  Since this function can also be represented as

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
    $$

  - Therefore, by the chain rule,

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
    $$ -->

### Módulos básicos de rede neural

Existem diferentes tipos de módulos pré-construídos além dos familiares Linear e *ReLU* (Unidade Linear Retificada). Eles são úteis porque são otimizados exclusivamente para executar suas respectivas funções (em oposição a ser construído por uma combinação de outros módulos elementares).

- Linear: $Y=W\cdot X$

  $$
  \begin{aligned}
  \frac{dC}{dX} &= W^\top \cdot \frac{dC}{dY} \\
  \frac{dC}{dW} &= \frac{dC}{dY} \cdot X^\top
  \end{aligned}
  $$

- ReLU: $y=(x)^+$

  $$
  \frac{dC}{dX} =
      \begin{cases}
        0 & x<0\\
        \frac{dC}{dY} & \text{otherwise}
      \end{cases}
  $$

- Duplicado: $Y_1=X$, $Y_2=X$

  - Semelhante a um "divisor em Y" onde ambas as saídas são iguais à entrada.

  - Ao retropropagar, os gradientes são somados

  - Pode ser dividido em $n$ ramos da mesma forma

    $$
    \frac{dC}{dX}=\frac{dC}{dY_1}+\frac{dC}{dY_2}
    $$

- Soma: $Y=X_1+X_2$

  - Com duas variáveis sendo somadas, quando uma é perturbada, a saída será perturbada pela mesma quantidade, ou seja

    $$
    \frac{dC}{dX_1}=\frac{dC}{dY}\cdot1 \quad \text{and}\quad \frac{dC}{dX_2}=\frac{dC}{dY}\cdot1
    $$

- Máximo: $Y=\max(X_1,X_2)$

  - Uma vez que esta função também pode ser representada como

    $$
    Y=\max(X_1,X_2)=\begin{cases}
          X_1 & X_1 > X_2 \\
          X_2 & \text{else}
       \end{cases}
    \Rightarrow
    \frac{dY}{dX_1}=\begin{cases}
          1 & X_1 > X_2 \\
          0 & \text{else}
       \end{cases}
    $$

  - Portanto, pela regra da cadeia

    $$
    \frac{dC}{dX_1}=\begin{cases}
          \frac{dC}{dY}\cdot1 & X_1 > X_2 \\
          0 & \text{else}
      \end{cases}
    $$

<!-- ## [LogSoftMax *vs.* SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

*SoftMax*, which is also a PyTorch module, is a convenient way of transforming a group of numbers into a group of positive numbers between $0$ and $1$ that sum to one. These numbers can be interpreted as a probability distribution. As a result, it is commonly used in classification problems. $y_i$ in the equation below is a vector of probabilities for all the categories.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

However, the use of softmax leaves the network susceptible to vanishing gradients. Vanishing gradient is a problem, as it prevents weights downstream from being modified by the neural network, which may completely stop the neural network from further training. The logistic sigmoid function, which is the softmax function for one value, shows that when $s$ is large, $h(s)$ is $1$, and when s is small, $h(s)$ is $0$. Because the sigmoid function is flat at $h(s) = 0$ and $h(s) = 1$, the gradient is $0$, which results in a vanishing gradient.

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Sigmoid function to illustrate vanishing gradient" style="background-color:#DCDCDC;" /></center>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

Mathematicians came up with the idea of logsoftmax in order to solve for the issue of the vanishing gradient created by softmax. *LogSoftMax* is another basic module in PyTorch. As can be seen in the equation below, *LogSoftMax* is a combination of softmax and log.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

The equation below demonstrates another way to look at the same equation. The figure below shows the $\log(1 + \exp(s))$ part of the function. When $s$ is very small, the value is $0$, and when $s$ is very large, the value is $s$. As a result it doesn’t saturate, and the vanishing gradient problem is avoided.

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Plot of logarithmic part of the functions" /></center> -->

## [LogSoftMax *versus* SoftMax](https://www.youtube.com/watch?v=d9vdh3b787Y&t=3953s)

*SoftMax*, que também é um módulo PyTorch, é uma maneira conveniente de transformar um grupo de números em um grupo de números positivos entre $0$ e $1$ cuja soma dá um. Esses números podem ser interpretados como uma distribuição de probabilidade. Como resultado, é comumente usado em problemas de classificação. $y_i$ na equação abaixo é um vetor de probabilidades para todas as categorias.

$$
y_i = \frac{\exp(x_i)}{\sum_j \exp(x_j)}
$$

No entanto, o uso de softmax deixa a rede suscetível ao desaparecimento de gradientes. Desaparecimentos de gradientes são um problema, uma vez que impede que os pesos sejam modificados pela rede neural, o que por sua vez pode impedir completamente a rede neural de continuar treinando. A função sigmóide logística, que é a função softmax para um valor, mostra que quando $s$ é grande, $h(s)$ é $1$, e quando s é pequeno, $h(s)$ é $0$. Porque a função sigmóide é plana em $h(s) = 0$ e $h(s) = 1$, o gradiente é $0$, o que resulta em um desaparecimento do gradiente.

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-2.png" alt="Função sigmóide para ilustrar o desaparecimento do gradiente" style="background-color:#DCDCDC;" /></center>

$$
h(s) = \frac{1}{1 + \exp(-s)}
$$

Os matemáticos tiveram a ideia da logsoftmax a fim de resolver o problema do desaparecimento do gradiente criado pela softmax. *LogSoftMax* é outro módulo básico do PyTorch. Como pode ser visto na equação abaixo, *LogSoftMax* é uma combinação das funções softmax e logarítmica.

$$
\log(y_i )= \log\left(\frac{\exp(x_i)}{\Sigma_j \exp(x_j)}\right) = x_i - \log(\Sigma_j \exp(x_j))
$$

A equação abaixo demonstra outra maneira de olhar para a mesma equação. A figura abaixo mostra o $\log(1 + \exp(s))$ como parte da função. Quando $s$ é muito pequeno, o valor é $0$, e quando $s$ é muito grande, o valor é $s$. Como resultado, ela não satura, e o problema do desaparecimento do gradiente é evitado.

$$
\log\left(\frac{\exp(s)}{\exp(s) + 1}\right)= s - \log(1 + \exp(s))
$$

<center><img src="{{site.baseurl}}/images/week02/02-2/02-2-3.png" width='400px' alt="Gráfico da parte logarítmica das funções" /></center>

<!-- ## [Practical tricks for backpropagation](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)


### Use ReLU as the non-linear activation function

ReLU works best for networks with many layers, which has caused alternatives like the sigmoid function and hyperbolic tangent $\tanh(\cdot)$ function to fall out of favour. The reason ReLU works best is likely due to its single kink which makes it scale equivariant.


### Use cross-entropy loss as the objective function for classification problems

Log softmax, which we discussed earlier in the lecture, is a special case of cross-entropy loss. In PyTorch, be sure to provide the cross-entropy loss function with *log* softmax as input (as opposed to normal softmax).


### Use stochastic gradient descent on minibatches during training

As discussed previously, minibatches let you train more efficiently because there is redundancy in the data; you shouldn't need to make a prediction and calculate the loss on every single observation at every single step to estimate the gradient.


### Shuffle the order of the training examples when using stochastic gradient descent

Order matters. If the model sees only examples from a single class during each training step, then it will learn to predict that class without learning why it ought to be predicting that class. For example, if you were trying to classify digits from the MNIST dataset and the data was unshuffled, the bias parameters in the last layer would simply always predict zero, then adapt to always predict one, then two, *etc*. Ideally, you should have samples from every class in every minibatch.

However, there's ongoing debate over whether you need to change the order of the samples in every pass (epoch).


### Normalize the inputs to have zero mean and unit variance

Before training, it's useful to normalize each input feature so that it has a mean of zero and a standard deviation of one. When using RGB image data, it is common to take mean and standard deviation of each channel individually and normalize the image channel-wise. For example, take the mean $m_b$ and standard deviation $\sigma_b$ of all the blue values in the dataset, then normalize the blue values for each individual image as

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

where $\epsilon$ is an arbitrarily small number that we use to avoid division by zero. Repeat the same for green and red channels. This is necessary to get a meaningful signal out of images taken in different lighting; for example, day lit pictures have a lot of red while underwater pictures have almost none.


### Use a schedule to decrease the learning rate

The learning rate should fall as training goes on. In practice, most advanced models are trained by using algorithms like Adam which adapt the learning rate instead of simple SGD with a constant learning rate.


### Use L1 and/or L2 regularization for weight decay

You can add a cost for large weights to the cost function. For example, using L2 regularization, we would define the loss $L$ and update the weights $w$ as follows:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

To understand why this is called weight decay, note that we can rewrite the above formula to show that we multiply $w_i$ by a constant less than one during the update.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

L1 regularization (Lasso) is similar, except that we use $\sum_i \vert w_i\vert$ instead of $\Vert w \Vert^2$.

Essentially, regularization tries to tell the system to minimize the cost function with the shortest weight vector possible. With L1 regularization, weights that are not useful are shrunk to $0$. -->

## [Truques práticos para retropropagação](https://www.youtube.com/watch?v=d9vdh3b787Y&t=4891s)

### Use *ReLU* como função de ativação não linear

*ReLU* funciona melhor para redes com muitas camadas, o que tem causado alternativas como as funções sigmóide e tangente hiperbólica $\tanh(\cdot)$ cairem em desgraça. O motivo pelo qual *ReLU* funciona melhor é provavelmente devido à sua única torção, que a torna equivariante na escala.

### Use a perda de entropia cruzada *(cross-entropy loss)* como função objetivo para problemas de classificação

*Log softmax*, que discutimos anteriormente nesta aula, é um caso especial de perda de entropia cruzada. No PyTorch, certifique-se de fornecer a função de perda de entropia cruzada com *log* softmax como entrada (em vez da softmax normal).

### Use o gradiente descendente estocástico *(SGD)* em mini lotes durante o treinamento

Conforme discutimos anteriormente, mini lotes permitem que você treine com mais eficiência porque há redundância nos dados; você não deve precisar fazer uma previsão e calcular a perda em cada observação e em cada etapa para estimar o gradiente.

### Misture a ordem das amostras de treinamento ao usar o gradiente descendente estocástico

A ordem importa. Se o modelo vir apenas exemplos de uma única classe durante cada etapa de treinamento, ele aprenderá a prever aquela classe sem aprender por que deveria estar prevendo aquela classe. Por exemplo, se você estava tentando classificar dígitos do conjunto de dados MNIST e os dados não forem misturados, os parâmetros de tendência na última camada simplesmente sempre preverão zero, então se adaptarão para sempre prever um, então dois, *etc*. Idealmente, você deve ter amostras de todas as classes em cada mini lote.

No entanto, há atualmente um debate sobre se você precisa de fato alterar a ordem das amostras em cada passagem (epoch).

### Normalize as entradas para ter média zero e variância unitária

Antes do treinamento, é útil normalizar cada recurso de entrada para que tenha uma média de zero e um desvio padrão de um. Ao usar dados de imagem RGB, é comum tomar a média e o desvio padrão de cada canal individualmente e normalizar a imagem em termos de canal. Por exemplo, pegue a média $m_b$ e desvio padrão $\sigma_b$ de todos os valores de azul no conjunto de dados, em seguida, normalize os valores de azul para cada imagem individual como

$$
b_{[i,j]}^{'} = \frac{b_{[i,j]} - m_b}{\max(\sigma_b, \epsilon)}
$$

onde $\epsilon$ é um número arbitrariamente pequeno que usamos para evitar a divisão por zero. Repita o mesmo para os canais verde e vermelho. Isso é necessário para obter um sinal significativo de imagens tiradas em iluminação diferente; por exemplo, as fotos iluminadas pelo dia têm muito vermelho, enquanto as fotos subaquáticas quase nenhum.

### Programe para diminuir a taxa de aprendizagem

A taxa de aprendizagem deve cair conforme o treinamento avança. Na prática, a maioria dos modelos avançados são treinados usando algoritmos como o Adam, que adaptam a taxa de aprendizado em vez do SGD simples com uma taxa de aprendizado constante.

### Use regularização L1 e/ou L2 para a queda de peso

Você pode adicionar custo para grandes pesos à função de custo. Por exemplo, usando regularizção L2, nós definiríamos a perda $L$ e atualizaríamos os pesos $w$ do seguinte modo:

$$
L(S, w) = C(S, w) + \alpha \Vert w \Vert^2\\
\frac{\partial R}{\partial w_i} = 2w_i\\
w_i = w_i - \eta\frac{\partial L}{\partial w_i} = w_i - \eta \left( \frac{\partial C}{\partial w_i} + 2 \alpha w_i \right)
$$

Para entender por que isso é chamado de queda de peso, note que podemos reescrever a fórmula acima para mostrar que multiplicamos $w_i$ por uma constante menor que um durante a atualização.

$$
w_i = (1 - 2 \eta \alpha) w_i - \eta\frac{\partial C}{\partial w_i}
$$

A regularização L1 (Lasso) é semelhante, exceto que usamos $\sum_i \vert w_i\vert$ ao invés de $\Vert w \Vert^2$.

Essencialmente, a regularização tenta dizer ao sistema para minimizar a função de custo com o vetor de peso mais curto possível. Com a regularização L1, os pesos que não são úteis são reduzidos para $0$.

<!-- ### Weight initialisation

The weights need to be initialised at random, however, they shouldn't be too large or too small such that output is roughly of the same variance as that of input. There are various weight initialisation tricks built into PyTorch. One of the tricks that works well for deep models is Kaiming initialisation where the variance of the weights is inversely proportional to square root of number of inputs. -->

### Inicialização de peso

Os pesos precisam ser inicializados aleatoriamente, no entanto, eles não devem ser muito grandes ou muito pequenos, de modo que a saída tenha aproximadamente a mesma variância da entrada. Existem vários truques de inicialização de peso embutidos no PyTorch. Um dos truques que funcionam bem para modelos profundos é a inicialização Kaiming onde a variância dos pesos é inversamente proporcional à raiz quadrada do número de entradas.

<!-- ### Use dropout

Dropout is another form of regularization. It can be thought of as another layer of the neural net: it takes inputs, randomly sets $n/2$ of the inputs to zero, and returns the result as output. This forces the system to take information from all input units rather than becoming overly reliant on a small number of input units thus distributing the information across all of the units in a layer. This method was initially proposed by <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

For more tricks, see  <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Finally, note that backpropagation doesn't just work for stacked models; it can work for any directed acyclic graph (DAG) as long as there is a partial order on the modules. -->

### Use o *dropout*

*Dropout* é outra forma de regularização. Pode ser pensado como outra camada da rede neural: toma as entradas, randomicamente estabelece $n/2$ conjuntos de entradas para zero, e retorna o resultado como saída. Isso força o sistema a obter informações de todas as unidades de entrada, em vez de se tornar excessivamente dependente de um pequeno número delas, distribuindo assim, as informações por todas as unidades em uma camada. Este método foi inicialmente proposto por <a href="https://arxiv.org/abs/1207.0580">Hinton et al (2012)</a>.

Para mais truques, veja  <a href="http://yann.lecun.com/exdb/publis/pdf/lecun-98b.pdf">LeCun et al 1998</a>.

Por fim, observe que a retropropagação não funciona apenas para modelos empilhados; ela pode funcionar para qualquer gráfico acíclico direcionado (DAG) contanto que haja uma ordem parcial nos módulos.
