---
lang: pt
lang-ref: ch.02-1
lecturer: Yann LeCun
title: Introdução ao gradiente descendente e algoritmo de retropopagação
authors: Amartya Prasad, Dongning Fang, Yuxin Tang, Sahana Upadhya
date: 3 Feb 2020
translation-date: 28 Fev 2021
translator: Lenin Cristi
---

<!-- ## [Gradient Descent optimization algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)

### Parametrised models

$$
\bar{y} = G(x,w)
$$

Parametrised models are simply functions that depend on inputs and trainable parameters. There is no fundamental difference between the two, except that trainable parameters are shared across training samples whereas the input varies from sample to sample. In most deep learning frameworks, parameters are implicit, that is, they aren't passed when the function is called. They are 'saved inside the function', so to speak, at least in the object-oriented versions of models.

The parametrised model (function) takes in an input, has a parameter vector and produces an output. In supervised learning, this output goes into the cost function ($C(y,\bar{y}$)), which compares the true output (${y}$) with the model output ($\bar{y}$). The computation graph for this model is shown in Figure 1.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figure1" style="zoom: 33%;" /></center> |
| <center>Figure 1: Computation Graph representation for a Parametrised Model </center>|

Examples of parametrised functions -

- Linear Model - Weighted Sum of Components of the Input Vector :

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

- Nearest Neighbour - There is an input $\vect{x}$ and a weight matrix $\matr{W}$ with each row of the matrix indexed by $k$. The output is the value of $k$ that corresponds to the row of $\matr{W}$ that is closest to $\vect{x}$:

  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  Parameterized models could also involve complicated functions. -->

## [Algoritmo de otimização de gradiente descendente](https://www.youtube.com/watch?v=d9vdh3b787Y&t=29s)

### Modelos parametrizados

$$
\bar{y} = G(x,w)
$$

Os modelos parametrizados são simplesmente funções que dependem de entradas e parâmetros treináveis. Não há diferença fundamental entre os dois exceto que os parâmetros treináveis são compartilhados entre as amostras de treinamento enquanto que as entradas variam de amostra para amostra. Na maioria dos frameworks de aprendizado profundo, os parâmetros são implícitos, ou seja, eles não são passados quando a função é chamada. Eles são 'salvos dentro da função' por assim dizer, ao menos nas versões orientadas a objetos desses modelos.

O modelo parametrizado (função) recebe uma entrada, um vetor de parâmetros e produz uma saída. Na aprendizagem supervisionada, essa saída vai para a função de custo ($C(y,\bar{y}$)), que compara a saída verdadeira (${y}$) com a saída do modelo ($\bar{y}$). O gráfico da computação deste modelo é mostrado na Figura 1.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure1.jpg" alt="Figura 1" style="zoom: 33%;" /></center> |
| <center>Figura 1: Representação do gráfico de computação para um modelo parametrizado</center>|

Exemplos de funções parametrizadas -

- Linear - Soma Ponderada dos Componentes do Vetor de Entrada:

  $$
  \bar{y} = \sum_i w_i x_i, C(y,\bar{y}) = \Vert y - \bar{y}\Vert^2
  $$

- Vizinho mais próximo - há uma entrada $\vect{x}$ e uma matriz de peso $\matr{W}$ com cada linha da matriz indexada por $k$. A saída é o valor de $k$ que corresponde à linha de $\matr{W}$ que é mais próximo de $\vect{x}$:

  $$
  \bar{y} = \underset{k}{\arg\min} \Vert x - w_{k,.} \Vert^2
  $$

  Modelos parametrizados também podem envolver funções complicadas.

<!-- #### Block diagram notations for computation graphs

- Variables (tensor, scalar, continuous, discrete)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> is an observed input to the system
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> is a computed variable which is produced by a deterministic function

- Deterministic functions

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="deterministic_function" style="zoom:50%;" />

    - Takes in multiple inputs and can produce multiple outputs
    - It has an implicit parameter variable (${w}$)
    - The rounded side indicates the direction in which it is easy to compute. In the above diagram, it is easier to compute ${\bar{y}}$ from ${x}$ than the other way around

- Scalar-valued function

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="scalar-valued" style="zoom:50%;" />

    - Used to represent cost functions
    - Has an implicit scalar output
    - Takes multiple inputs and outputs a single value (usually the distance between the inputs) -->

#### Notações de diagrama de bloco para gráficos de computação

- Variáveis (tensor, escalar, contínua, discreta)
    - <img src="{{site.baseurl}}/images/week02/02-1/x.PNG" alt="x" style="zoom:50%;" /> é uma entrada observada para o sistema
    - <img src="{{site.baseurl}}/images/week02/02-1/y.PNG" alt="y" style="zoom:50%;" /> é uma variável computada que é produzida por uma função determinística

- Funções determinísticas

    <img src="{{site.baseurl}}/images/week02/02-1/deterministic_function.PNG" alt="função determinística" style="zoom:50%;" />

    - Aceita várias entradas e pode produzir várias saídas
    - Tem uma variável de parâmetro implícita (${w}$)
    - O lado arredondado indica a direção em que é fácil calcular. No diagrama acima, é mais fácil calcular ${\bar{y}}$ de ${x}$ do que o contrário

- Função com valor escalar

  <img src="{{site.baseurl}}/images/week02/02-1/scalar-valued.PNG" alt="com valor escalar" style="zoom:50%;" />

    - Usado para representar funções de custo
    - Tem uma saída escalar implícita
    - Recebe várias entradas e produz um único valor (normalmente a distância entre as entradas)

<!-- #### Loss functions

Loss function is a function that is minimized during training. There are two types of losses:

1) Per Sample Loss -

$$
 L(x,y,w) = C(y, G(x,w))
$$

2) Average Loss -

For any set of Samples

$$S = \lbrace(x[p],y[p]) \mid p \in \lbrace 0, \cdots, P-1 \rbrace \rbrace$$

Average Loss over the Set $S$ is given by:

$$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="Average_Loss" style="zoom:33%;" /></center> |
|   <center>Figure 2: Computation graph for model with Average Loss    </center>|

In the standard Supervised Learning paradigm, the loss (per sample) is simply the output of the cost function. Machine Learning is mostly about optimizing functions (usually minimizing them). It could also involve finding Nash Equilibria between two functions like with GANs. This is done using Gradient Based Methods, though not necessarily Gradient Descent. -->

#### Funções de perda

A função de perda é uma função que é minimizada durante o treinamento. Existem dois tipos de perdas:

1) Perda por Amostra -

$$
 L(x,y,w) = C(y, G(x,w))
$$

2) Perda Média -

Para qualquer conjunto de amostras

$$S = \lbrace(x[p],y[p]) \mid p \in \lbrace 0, \cdots, P-1 \rbrace \rbrace$$

Perda média ao longo do conjunto $S$ É dado por:

$$L(S,w) = \frac{1}{P} \sum_{(x,y)} L(x,y,w)$$

| <center><img src="{{site.baseurl}}/images/week02/02-1/Average_Loss.png" alt="perda Média" style="zoom:33%;" /></center> |
|   <center>Figura 2: Gráfico de computação para modelo com perda média    </center>|

No paradigma de Aprendizagem Supervisionada padrão, a perda (por amostra) é simplesmente a saída da função de custo. O aprendizado de máquina é principalmente sobre otimização de funções (geralmente as minimizando). Também pode envolver encontrar o Equilíbrio de Nash entre duas funções como em *GANs*. Isso é feito usando Métodos Baseados em Gradiente, embora não necessariamente o Gradiente Descendente.

<!-- ### Gradient descent

A **Gradient Based Method** is a method/algorithm that finds the minima of a function, assuming that one can easily compute the gradient of that function. It assumes that the function is continuous and differentiable almost everywhere (it need not be differentiable everywhere).

**Gradient Descent Intuition** - Imagine being in a mountain in the middle of a foggy night. Since you want to go down to the village and have only limited vision, you look around your immediate vicinity to find the direction of steepest descent and take a step in that direction.

**Different methods of Gradient Descent**

- Full (batch) gradient descent update rule :

  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$

- For SGD (Stochastic Gradient  Descent), the update rule becomes :

  - Pick a $p \in \lbrace 0, \cdots, P-1 \rbrace$, then update

    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$

Where ${w}$ represents the parameter to be optimized.

$\eta$ is a constant here but in more sophisticated algorithms, it could be a matrix.

If it is a positive semi-definite matrix, we'll still move downhill but not necessarily in the direction of steepest descent. In fact the direction of steepest descent may not always be the direction we want to move in.

If the function is not differentiable, i.e, it has a hole or is staircase like or flat, where the gradient doesn't give you any information, one has to resort to other methods - called 0-th Order Methods or Gradient-Free Methods. Deep Learning is all about Gradient Based Methods.

However, RL (Reinforcement Learning) involves **Gradient Estimation** without the explicit form for the gradient. An example is a robot learning to ride a bike where the robot falls every now and then. The objective function measures how long the bike stays up without falling. Unfortunately, there is no gradient for the objective function. The robot needs to try different things.

The RL cost function is not differentiable most of the time but the network that computes the output is gradient-based. This is the main difference between supervised learning and reinforcement learning. With the latter, the cost function $C$ is not differentiable. In fact it completely unknown. It just returns an output when inputs are fed to it, like a blackbox. This makes it highly inefficient and is one of the main drawbacks of RL - particularly when the parameter vector is high dimensional (which implies a huge solution space to search in, making it hard to find where to move).

A very popular technique in RL is Actor Critic Methods. A critic method basically consists of a second C module which is a known, trainable module. One is able to train the C module, which is differentiable, to approximate the cost function/reward function. The reward is a negative cost, more like a punishment. That’s a way of making the cost function differentiable, or at least approximating it by a differentiable function so that one can backpropagate. -->

### Gradiente descendente

Um **Método Baseado em Gradiente** é um método/algoritmo que encontra os mínimos de uma função, assumindo que se pode facilmente calcular o gradiente dessa função. Ele assume que a função é contínua e diferenciável em quase todos os intervalos (não precisa ser diferenciável em todos os intervalos).

**Abstração do Gradiente Descendente** - Imagine estar em uma montanha no meio de uma noite de nevoeiro. Já que você quer descer para a aldeia e tem apenas uma visão limitada, você olha ao redor de sua vizinhança imediata para encontrar a direção da descida mais íngreme e dá um passo nessa direção.

**Diferentes métodos de gradiente descendente**

- Regra completa de atualização (em lotes) do gradiente descendente :

  $$
  w \leftarrow w - \eta \frac{\partial L(S,w)}{\partial w}
  $$

- Para SGD (Gradiente Descendente Estocástico), a regra de atualização se torna :

  - Escolha um $p \in \lbrace 0, \cdots, P-1 \rbrace$, então atualize

    $$
    w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
    $$

Onde ${w}$ representa o parâmetro a ser otimizado.

$\eta$ é uma constante aqui, mas em algoritmos mais sofisticados, pode ser uma matriz.

Se for uma matriz semi-definida positiva, ainda vamos descer a colina, mas não necessariamente na direção da descida mais íngreme. De fato, a direção da descida mais íngreme nem sempre é a direção em que desejamos nos mover.

Se a função não for diferenciável, ou seja, tem um buraco ou é semelhante a uma escada ou plano, onde o gradiente não fornece nenhuma informação, é preciso recorrer a outros métodos - chamados Métodos de Ordem Zero ou Métodos Livres de Gradiente. Aprendizado profundo é sobre métodos baseados em gradiente.

Contudo, *RL* (Aprendizagem por Reforço) envolve **Estimativa de Gradiente** sem a forma explícita do gradiente. Um exemplo é um robô aprendendo a andar de bicicleta, onde o robô cai de vez em quando. A função objetivo mede quanto tempo a bicicleta permanece levantada sem cair. Infelizmente, não há gradiente para a função objetivo. O robô precisa tentar coisas diferentes.

A função de custo da *RL* não é diferenciável na maioria das vezes, mas a rede que calcula a saída é baseada em gradiente. Esta é a principal diferença entre aprendizagem supervisionada e aprendizagem por reforço. Na última, a função de custo $C$ não é diferenciável. Na verdade, é completamente desconhecida. Ela apenas retorna uma saída quando as entradas são a ela fornecidas, como uma caixa preta. Isso a torna altamente ineficiente e é uma das principais desvantagens da *RL* - particularmente quando o vetor de parâmetro é de dimesão alta (o que implica em um grande espaço de solução para pesquisar, tornando difícil encontrar para onde se mover).

Uma técnica muito popular em *RL* são *Actor Critic Methods* (Métodos de Ator/Crítico). Um método crítico consiste basicamente em um segundo módulo C, que é um módulo conhecido e treinável. É possível treinar o módulo C, que é diferenciável, para aproximar a função de custo/recompensa. A recompensa é um custo negativo, mais como uma punição. Essa é uma maneira de tornar a função de custo diferenciável, ou pelo menos aproximando-a por uma função diferenciável para que se possa retropropagar.

<!-- ## [Advantages of SGD and backpropagation for traditional neural nets](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)

### Advantages of Stochastic Gradient Descent (SGD)

In practice, we use stochastic gradient to compute the gradient of the objective function w.r.t the parameters. Instead of computing the full gradient of the objective function, which is the average of all samples, stochastic gradient just takes one sample, computes the loss, $L$, and the gradient of the loss w.r.t the parameters, and then takes one step in the negative gradient direction.

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

In the formula, $w$ is approached by $w$ minus the step-size, times the gradient of the per-sample loss function w.r.t the parameters for a given sample, ($x[p]$,$y[p]$).

If we do this on a single sample, we will get a very noisy trajectory as shown in Figure 3. Instead of the loss going directly downhill, it’s stochastic. Every sample will pull the loss towards a different direction. It’s just the average that pulls us to the minimum of the average. Although it looks inefficient, it’s much faster than full batch gradient descent at least in the context of machine learning when the samples have some redundancy.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figure2" style="zoom:80%;" /></center> |
| <center>Figure 3: Stochastic Gradient Descent trajectory for per sample update </center>|

In practice, we use batches instead of doing stochastic gradient descent on a single sample. We compute the average of the gradient over a batch of samples, not a single sample, and then take one step. The only reason for doing this is that we can make more efficient use of the existing hardware  (*i.e.* GPUs, multicore CPUs) if we use batches since it's easier to parallelize. Batching is the simplest way to parallelize.

### Traditional neural network

Traditional Neural Nets are basically interspersed layers of linear operations and point-wise non-linear operations. For linear operations, conceptually it is just a matrix-vector multiplication. We take the (input) vector multiplied by a matrix formed by the weights. The second type of operation is to take all the components of the weighted sums vector and pass it through some simple non-linearity (*i.e.* $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …).

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figure3" style="zoom:30%;" /></center> |
|             <center>Figure 4: Traditional Neural Network             </center>|

Figure 4 is an example of a 2-layer network, because what matters are the pairs (i.e linear+non-linear). Some people call it a 3-layer network because they count the variables. Note that if there are no non-linearities in the middle, we may as well have a single layer because the product of two linear functions is a linear function.

Figure 5 shows how the linear and non-linear functional blocks of the network stack:

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figure4" style="zoom:30%;" /></center> |
|  <center>Figure 5: Looking inside the linear and non-linear blocks   </center>|

In the graph, $s[i]$ is the weighted sum of unit ${i}$ which is computed as:

$$
s[i]=\sum_{j \in UP(i)}w[i,j]\cdot z[j]
$$

where $UP(i)$ denotes the predecessors of $i$ and $z[j]$ is the $j$th output from the previous layer.

The output $z[i]$ is computed as:

$$
z[i]=f(s[i])
$$

where $f$ is a non-linear function. -->

## [Vantagens do *SGD* e retropropagação para redes neurais tradicionais](https://www.youtube.com/watch?v=d9vdh3b787Y&t=1036s)

### Vantagens do Gradiente Descendente Estocástico *(SGD)*

Na prática, usamos gradiente estocástico para calcular o gradiente da função objetivo em respeito aos parametros. Em vez de calcular o gradiente total da função objetivo, que é a média de todas as amostras, o gradiente estocástico apenas pega uma amostra, calcula a perda, $L$, e o gradiente da perda com respeito aos paremetros, e então dá um passo na direção negativa do gradiente.

$$
w \leftarrow w - \eta \frac{\partial L(x[p], y[p],w)}{\partial w}
$$

Na fórmula, $w$ é aproximado por $w$ menos o tamanho do passo, vezes o gradiente da função de perda por amostra com respeito aos parametros para uma dada amostra, ($x[p]$,$y[p]$).

Se fizermos isso em uma única amostra, obteremos uma trajetória muito ruidosa, conforme mostrado na Figura 3. Em vez da perda ir diretamente para baixo, é estocástica. Cada amostra puxará a perda em uma direção diferente. É apenas a média que nos puxa para o mínimo da média. Embora pareça ineficiente, é muito mais rápido do que o gradiente descendente em lotes completo, pelo menos no contexto de aprendizado de máquina, quando as amostras têm alguma redundância.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure2.png" alt="Figura 2" style="zoom:80%;" /></center> |
| <center>Figura 3: Trajetória do gradiente descendente estocástico para atualização por amostra </center>|

Na prática, utilizamos lotes em vez de calcular o gradiente descendente estocástico em uma única amostra. Calculamos a média do gradiente em um lote de amostras, e não uma única amostra, e então damos um passo. A única razão para fazer isso é que podemos fazer um uso mais eficiente do hardware existente (*isto é,* GPUs, CPUs de multiplos núcleos) se usamos lotes, pois é mais fácil de paralelizar. Fazer uma tarefa em lotes é a maneira mais simples de paralelizar.

### Rede neural tradicional

Redes Neurais tradicionais são basicamente camadas intercaladas de operações lineares e operações não lineares pontuais. Para operações lineares, conceitualmente, é apenas uma multiplicação de matriz-vetor. Tomamos o vetor (entrada) multiplicado por uma matriz formada pelos pesos. O segundo tipo de operação é pegar todos os componentes do vetor de somas ponderadas e passá-los por alguma não linearidade simples (*isto é* $\texttt{ReLU}(\cdot)$, $\tanh(\cdot)$, …).

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure3.png" alt="Figura 3" style="zoom:30%;" /></center> |
|             <center>Figura 4: Rede Neural Tradicional             </center>|

A Figura 4 é um exemplo de uma rede de 2 camadas, porque o que importa são os pares (isto é linear + não linear). Algumas pessoas chamam isto de uma rede de 3 camadas porque contam as variáveis. Observe que se não houver não linearidades no meio, podemos ter uma única camada porque o produto de duas funções lineares é uma função linear.

A Figura 5 mostra os blocos funcionais lineares e não lineares da pilha de camadas da rede:

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure4.png" alt="Figura 4" style="zoom:30%;" /></center> |
|  <center>Figura 5: Olhando dentro dos blocos lineares e não lineares</center>|

No gráfico, $s[i]$ é a soma ponderada da unidade ${i}$ que é calculado como:

$$
s[i]=\sum_{j \in UP(i)}w[i,j]\cdot z[j]
$$

Onde $UP(i)$ denota os predecessores de $i$ e $z[j]$ é a $j$th saída da camada anterior.

A saída $z[i]$ é calculada como:

$$
z[i]=f(s[i])
$$

Onde $f$ é uma função não linear.

<!-- ### Backpropagation through a non-linear function

The first way to do backpropagation is to backpropagate through a non linear function. We take a particular non-linear function $h$ from the network and leave everything else in the blackbox.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figure5" style="zoom: 25%;" /></center> |
|    <center>Figure 6: Backpropagation through non-linear function     </center>|

We are going to use the chain rule to compute the gradients:

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

where $h'(s)$ is the derivative of $z$ w.r.t $s$ represented by $\frac{\mathrm{d}z}{\mathrm{d}s}$.
To make the connection between derivatives clear, we rewrite the formula above as:

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

Hence if we have a chain of those functions in the network, we can backpropagate by multiplying by the derivatives of all the ${h}$ functions one after the other all the way back to the bottom.

It’s more intuitive to think of it in terms of perturbations. Perturbing $s$ by $\mathrm{d}s$ will perturb $z$ by:

$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

This would in turn perturb $C$ by:

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

Once again, we end up with the same formula as the one shown above. -->

### Retropropagação através de uma função não linear

A primeira maneira de fazer retropropagação é retropropagá-la por meio de uma função não linear. Tomamos uma função não linear particular $h$ da rede e deixamos todo o resto na caixa preta.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure5.png" alt="Figura 5" style="zoom: 25%;" /></center> |
|    <center>Figura 6: Retropropagação por meio de função não linear     </center>|

Vamos usar a regra da cadeia para calcular os gradientes:

$$
g(h(s))' = g'(h(s))\cdot h'(s)
$$

Onde $h'(s)$ é a derivada de $z$ com respeito a $s$ representada por $\frac{\mathrm{d}z}{\mathrm{d}s}$.
Para tornar clara a conexão entre as derivadas, reescrevemos a fórmula acima como:

$$
\frac{\mathrm{d}C}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot \frac{\mathrm{d}z}{\mathrm{d}s} = \frac{\mathrm{d}C}{\mathrm{d}z}\cdot h'(s)
$$

Portanto, se temos uma cadeia dessas funções na rede, podemos retropropagar multiplicando pelas derivadas de todos as ${h}$ funções uma após a outra, de volta ao fundo.

É mais intuitivo pensar nisso em termos de perturbações. Pertubar $s$ por $\mathrm{d}s$ vai perturbar $z$ por:

$$\mathrm{d}z = \mathrm{d}s \cdot h'(s)$$

Isso, por sua vez, perturbaria $C$ por:

$$
\mathrm{d}C = \mathrm{d}z\cdot\frac{\mathrm{d}C}{\mathrm{d}z} = \mathrm{d}s\cdot h’(s)\cdot\frac{\mathrm{d}C}{\mathrm{d}z}
$$

Mais uma vez, terminamos com a mesma fórmula mostrada acima.

<!-- ### Backpropagation through a weighted sum

For a linear module, we do backpropagation through a weighted sum. Here we view the entire network as a blackbox except for 3 connections going from a ${z}$ variable to a bunch of $s$ variables.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figure6" style="zoom: 25%;" /></center> |
|        <center>Figure 7: Backpropagation through weighted sum        </center>|

This time the perturbation is a weighted sum. $Z$ influences several variables. Perturbing $z$ by $\mathrm{d}z$ will perturb $s[0]$, $s[1]$ and $s[2]$ by:

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

 This will perturb $C$ by

$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$

Hence $C$ is going to vary by the sum of the 3 variations:

$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$ -->

### Retropropagação por meio de uma soma ponderada

Para um módulo linear, fazemos a retropropagação por meio de uma soma ponderada. Aqui, vemos toda a rede como uma caixa preta, exceto por 3 conexões saindo de uma variável ${z}$ para um monte de variáveis $s$.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure6.png" alt="Figura 6" style="zoom: 25%;" /></center> |
|        <center>Figura 7: Retropropagação através da soma ponderada        </center>|

Desta vez, a perturbação é uma soma ponderada. $Z$ influencia várias variáveis. Perturbar $z$ por $\mathrm{d}z$ vai perturbar $s[0]$, $s[1]$ e $s[2]$ por:

$$
\mathrm{d}s[0]=w[0]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[1]=w[1]\cdot \mathrm{d}z
$$

$$
\mathrm{d}s[2]=w[2]\cdot\mathrm{d}z
$$

 Isso vai perturbar $C$ por

$$
\mathrm{d}C = \mathrm{d}s[0]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[0]}+\mathrm{d}s[1]\cdot \frac{\mathrm{d}C}{\mathrm{d}s[1]}+\mathrm{d}s[2]\cdot\frac{\mathrm{d}C}{\mathrm{d}s[2]}
$$

Conseqüentemente $C$ vai variar pela soma das 3 variações:

$$
\frac{\mathrm{d}C}{\mathrm{d}z} = \frac{\mathrm{d}C}{\mathrm{d}s[0]}\cdot w[0]+\frac{\mathrm{d}C}{\mathrm{d}s[1]}\cdot w[1]+\frac{\mathrm{d}C}{\mathrm{d}s[2]}\cdot w[2]
$$

<!-- ## [PyTorch implementation of neural network and a generalized backprop algorithm](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)

### Block diagram of a traditional neural net

- Linear blocks $s_{k+1}=w_kz_k$
- Non-linear blocks $z_k=h(s_k)$

  <center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figure 7" style="zoom: 33%;" /></center>

$w_k$: matrix $z_k$: vector $h$: application of scalar ${h}$ function to every component. This is a 3-layer neural net with pairs of linear and non-linear functions, though most modern neural nets do not have such clear linear and non-linear separations and are more complex.

### PyTorch implementation

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```

- We can implement neural nets with object oriented classes in PyTorch. First we define a class for the neural net and initialize linear layers in the constructor using predefined `nn.Linear` class. Linear layers have to be separate objects because each of them contains a parameter vector. The `nn.Linear` class also adds the bias vector implicitly. Then we define a forward function on how to compute outputs with $\text{torch.relu}$ function as the nonlinear activation. We don't have to initialize separate relu functions because they don't have parameters.

- We do not need to compute the gradient ourselves since PyTorch knows how to back propagate and calculate the gradients given the `forward` function. -->

## [Implementação em PyTorch de uma rede neural e um algoritmo de retropropagação generalizado](https://www.youtube.com/watch?v=d9vdh3b787Y&t=2288s)

### Diagrama de blocos de uma rede neural tradicional

- Blocos lineares $s_{k+1}=w_kz_k$
- Blocos não lineares $z_k=h(s_k)$

  <center><img src="{{site.baseurl}}/images/week02/02-1/Figure 7.png" alt="Figura 7" style="zoom: 33%;" /></center>

$w_k$: matriz $z_k$: vetor $h$: aplicação da função escalar ${h}$ para cada componente. Esta é uma rede neural de 3 camadas com pares de funções lineares e não lineares, embora a maioria das redes neurais modernas não tenham tais separações lineares e não lineares claras e sejam mais complexas.

### Implementação em PyTorch

```python
import torch
from torch import nn
image = torch.randn(3, 10, 20)
d0 = image.nelement()

class mynet(nn.Module):
    def __init__(self, d0, d1, d2, d3):
        super().__init__()
        self.m0 = nn.Linear(d0, d1)
        self.m1 = nn.Linear(d1, d2)
        self.m2 = nn.Linear(d2, d3)

    def forward(self,x):
        z0 = x.view(-1)  # flatten input tensor
        s1 = self.m0(z0)
        z1 = torch.relu(s1)
        s2 = self.m1(z1)
        z2 = torch.relu(s2)
        s3 = self.m2(z2)
        return s3
model = mynet(d0, 60, 40, 10)
out = model(image)
```

- Podemos implementar redes neurais com classes orientadas a objetos em PyTorch. Primeiro, definimos uma classe para a rede neural e inicializamos camadas lineares no construtor usando a classe predefinida `nn.Linear`. Camadas lineares devem ser objetos separados porque cada uma delas contém um vetor de parâmetro. A classe `nn.Linear` também adiciona o vetor de tendência implicitamente. Em seguida, definimos uma função para  calcular as saídas com a função $\text{torch.relu}$ como a ativação não linear. Não precisamos inicializar funções retificadoras *(ReLu)* separadas porque elas não têm parâmetros.

- Não precisamos calcular o gradiente nós mesmos, poisPyTorch sabe como retroceder e calcular os gradientes, dada a função `forward`.

<!-- ### Backprop through a functional module

We now present a more generalized form of backpropagation.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figure9" style="zoom:33%;" /></center> |
|    <center>Figure 8: Backpropagation through a functional module     </center>|

- Using chain rule for vector functions

  $$
   z_g : [d_g\times 1]
  $$

  $$
   z_f:[d_f\times 1]
  $$

  $$
  \frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
  $$

  $$
  [1\times d_f]= [1\times d_g]\times[d_g\times d_f]
  $$

  This is the basic formula for $\frac{\partial c}{\partial{z_f}}$ using the chain rule. Note that the gradient of a scalar function with respect to a vector is a vector of the same size as the vector with respect to which you differentiate. In order to make the notations consistent, it is a row vector instead of a column vector.

- Jacobian matrix

  $$
  \left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
  $$

  We need $\frac{\partial {z_g}}{\partial {z_f}}$ (Jacobian matrix entries) to compute the gradient of the cost function with respect to $z_f$ given gradient of the cost function with respect to $z_g$. Each entry $ij$ is equal to the partial derivative of the $i$th component of the output vector with respect to the $j$th component of the input vector.

  If we have a cascade of modules, we keep multiplying the Jacobian matrices of all the modules going down and we get the gradients w.r.t all the internal variables. -->

### Retropropagação através de um módulo funcional

Agora apresentamos uma forma mais generalizada de retropropagação.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure9.png" alt="Figura 9" style="zoom:33%;" /></center> |
|    <center>Figura 8: Retropropagação através de um módulo funcional     </center>|

- Usando a regra da cadeia para funções vetoriais

  $$
   z_g : [d_g\times 1]
  $$

  $$
   z_f:[d_f\times 1]
  $$

  $$
  \frac{\partial c}{\partial{z_f}}=\frac{\partial c}{\partial{z_g}}\frac{\partial {z_g}}{\partial{z_f}}
  $$

  $$
  [1\times d_f]= [1\times d_g]\times[d_g\times d_f]
  $$

  Esta é a fórmula básica para $\frac{\partial c}{\partial{z_f}}$ usando a regra da cadeia. Observe que o gradiente de uma função escalar em relação a um vetor é um vetor do mesmo tamanho que o vetor em relação ao qual você diferencia. Para tornar as notações consistentes, é um vetor linha em vez de um vetor coluna.

- Matriz Jacobiana

  $$
  \left(\frac{\partial{z_g}}{\partial {z_f}}\right)_{ij}=\frac{(\partial {z_g})_i}{(\partial {z_f})_j}
  $$

  Nós precisamos de $\frac{\partial {z_g}}{\partial {z_f}}$ (Entradas de matriz Jacobiana) para calcular o gradiente da função de custo em relação a $z_f$ dado o gradiente da função de custo em relação a $z_g$. Cada entrada $ij$ é igual à derivada parcial do $i$th componente do vetor de saída em relação ao $j$th componente do vetor de entrada.

  Se tivermos os módulos em cascata, continuamos multiplicando as matrizes Jacobianas de todos os módulos descendo e obtemos os gradientes com respeito a todas as variáveis internas.

<!-- ### Backprop through a multi-stage graph

Consider a stack of many modules in a neural network as shown in Figure 9.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figure10" style="zoom:33%;" /></center> |
|         <center>Figure 9: Backprop through multi-stage graph         </center>|

For the backprop algorithm, we need two sets of gradients - one with respect to the states (each module of the network) and one with respect to the weights (all the parameters in a particular module). So we have two Jacobian matrices associated with each module. We can again use chain rule for backprop.

- Using chain rule for vector functions

  $$
  \frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
  $$

  $$
  \frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
  $$

- Two Jacobian matrices for the module
    - One with respect to $z[k]$
    - One with respect to $w[k]$
 -->

### Retropropagação por meio de um gráfico de vários estágios

Considere uma pilha de vários módulos em uma rede neural, conforme mostrado na Figura 9.

| <center><img src="{{site.baseurl}}/images/week02/02-1/Figure10.png" alt="Figura 10" style="zoom:33%;" /></center> |
|         <center>Figura 9: Backprop por meio de gráfico de vários estágios         </center>|

Para o algoritmo de retropropagação, precisamos de dois conjuntos de gradientes - um em relação aos estados (cada módulo da rede) e um em relação aos pesos (todos os parâmetros em um módulo particular). Portanto, temos duas matrizes Jacobianas associadas a cada módulo. Podemos novamente usar a regra da cadeia para retropropagação.

- Usando a regra da cadeia para funções vetoriais

  $$
  \frac{\partial c}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {z_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {z_k}}
  $$

  $$
  \frac{\partial c}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial {z_{k+1}}}{\partial {w_k}}=\frac{\partial c}{\partial {z_{k+1}}}\frac{\partial f_k(z_k,w_k)}{\partial {w_k}}
  $$

- Duas matrizes Jacobianas para o módulo
    - Um em relação a $z[k]$
    - Um em relação a $w[k]$
