---
lang: pt
lang-ref: ch.01-1
lecturer: Yann LeCun
title: Motivação do Aprendizado Profundo, sua História e Inspiração
authors: Yunya Wang, SunJoo Park, Mark Estudillo, Justin Mae
date: 27 Jan 2020
translation-date: 16 Dec 2020
translator: Luís H. S. Ribeiro
---

<!-- 
-->
## [Plano do curso](https://www.youtube.com/watch?v=0bMe_vCZo30&t=217s)

<!-- 
- Basics of Supervised Learning, Neural Nets, Deep Learning
- Backpropagation and architectural components
- Convolutional neural network and its applications
- More Deep Learning Architectures
- Regularization Tricks / Optimization Tricks / Understanding how Deep Learning works
- Energy-based models
- Self-supervised learning and beyond
-->
- Conceitos básicos de Aprendizado Supervisionado, Redes Neurais, Aprendizado Profundo
- Retropropagação e componentes arquiteturais.
- Rede neural convolucional e suas aplicações.
- Mais Arquiteturas de Aprendizado Profundo
- Truques de regularização / Truques de otimização / Entendendo como o Aprendizado Profundo funciona
- Modelos baseados em energia.
- Aprendizado auto-supervisionado e além

<!-- Inspiration of Deep Learning and its history
-->
## Inspiração do Aprendizado Profundo e sua história.

<!-- On a conceptual level, deep learning is inspired by the brain but not all of the brain's details are relevant. For a comparison, aeroplanes were inspired by birds. The principle of flying is the same but the details are extremely different.
-->
Em um nível conceitual, o aprendizado profundo é inspirado pelo cérebro, mas de forma alguma pelos detalhes do cerébro que são relevantes. A título de comparação, aviões foram inspirados por pássaros. O princípios de voar é o mesmo, mas os detalhes são extremamente diferentes.

<!-- The history of deep learning goes back to a field which changed its name now to cybernetics. It started in the 1940s with McCulloch and Pitts. They came up with the idea that neurons are threshold units with on and off states. You could build a Boolean circuit by connecting neurons with each other and conduct logical inference with neurons. The brain is basically a logical inference machine because neurons are binary. Neurons compute a weighted sum of inputs and compare that sum to its threshold. It turns on if it's above the threshold and turns off if it's below, which is a simplified view of how neural networks work.
-->
A história do aprendizado profundo remonta à um campo que mudou seu nome para cibernética agora. Começou na década de 1940 com McCulloch e Pitts. Eles tiveram essa ideia de que neurônios são unidades com limites, e com os estados ligado e desligado. Você poderia construir um circuito Booleano conectando os neurônios entre si e conduzir inferência lógica com neurônios. O cérebro é basicamente uma máquina de inferência lógica pois neurônios são binários. Eles computam uma soma ponderada das entradas e à comparam com o limiar. Ele liga se a soma é maior que o limiar, e desliga é menor, sendo uma visão simplificada de como redes neurais funcionam.

<!-- In 1947, Donald Hebb had the idea that neurons in the brain learn by modifying the strength of the connections between neurons. This is called hyper learning, where if two neurons are fired together, then the connection linked between them increases; if they don't fire together, then the connection decreases.
-->
Em 1947, Donald Hebb teve a ideia de que as redes neurais no cérebro aprendem ao modificar a força de conexões entre neurônios. Isto é chamado de hiper aprendizado, onde, se dois neurônios são disparados ao mesmo tempo, então a conexão entre eles aumenta; se eles não disparam, então a conexão diminui. 

<!-- Later in 1948, cybernetics were proposed by Norbert Wiener, which is the idea that by having systems with sensors and actuators, you have a feedback loop and a self-regulatory system. The rules of the feedback mechanism of a car all come from this work.
-->
Mais tarde, em 1948, Norbert Wiener propôs a cibernética, que é a ideia de que ao ter sistemas com sensores e atuadores, se têm um ciclo de retroalimentação e um sistema autorregulador. As regras do mecanismo de retroalimentação de um carro vêm desse trabalho.

<!-- In 1957, Frank Rosenblatt proposed the Perceptron, which is a learning algorithm that modifies the weights of very simple neural nets.
-->
Em 1957, Frank Rosenblatt propôs o Perceptron, que é um algoritmo de aprendizado que modifica os pesos de redes neurais muito simples.

<!-- Overall, this idea of trying to build intellectual machines by simulating lots of neurons was born in 1940s, took off in 1950s, and completely died in late 1960s. The main reasons for the field dying off in 1960 are:
-->
Em geral, essa ideia de tentar construir máquinas intelectuais simulando muitos neurônios nasceu na década de 1940, decolou na década de 1950, e morreu por completo na década de 1960. As principais razões da morte do campo em 1960 são:

<!-- - The researchers used neurons that were binary. However, the way to get backpropagation to work is to use activation functions that are continuous. At that time, researchers didn't have the idea of using continuous neurons and they didn't think they can train with gradients because binary neurons are not differential.
- With continuous neurons, one would have to multiply the activation of a neuron by a weight to get a contribution to the weighted sum. However, before 1980, the multiplication of two numbers, especially floating-point numbers, were extremely slow. This resulted in another incentive to avoid using continuous neurons.
-->
- Os pesquisadores usaram neurônios que eram binários. Entretanto, a forma como a retropropagação funciona é usando funções de ativação que são contínuas. Naquela época, pesquisadores não tiveram a ideia de usar neurônios contínuos e não pensaram que eles poderiam treinar com gradientes já que os neurônios binários não são diferenciáveis.
- Com neurônios contínuos, seria necessário multiplicar a ativação de um neurônio por um peso para obter sua contribuição para a soma ponderada. Entretanto, antes de 1980, a multiplicação de dois números, especialmente números de ponto flutuantes, era extremamente lenta. Logo, resultou em outra razão para evitar o uso de neurônios contínuos.

<!-- Deep Learning took off again in 1985 with the emergence of backpropagation. In 1995, the field died again and the machine learning community abandoned the idea of neural nets. In early 2010, people start using neuron nets in speech recognition with huge performance improvement and later it became widely deployed in the commercial field. In 2013, computer vision started to switch to neuron nets. In 2016, the same transition occurred in natural language processing. Soon, similar revolutions will occur in robotics, control, and many other fields.
-->
O Aprendizado Profunda decolou novamente em 1985 com o surgimento da retropropagação. Em 1995, o campo morreu novamente e a comunidade de aprendizado de máquina abandonou a ideia de redes neurais. No início de 2010, as pessoas começaram a redes neurais em reconhecimento de fala com uma melhoria de performance enorme, após isto, sendo vastamente implantado no mercado. Em 2013, visão computacional começou a mudar para as redes neurais. Em 2016, a mesma transição ocorreu com processamento de linguagem natural. Em breve, revoluções similares ocorrerão em robótica, controle, e muitos outros campos.

<!-- 
-->
### Aprendizado Supervisionado

<!-- $90\%$ of deep learning applications use supervised learning. Supervised learning is a process by which, you collect a bunch of pairs of inputs and outputs, and the inputs are feed into a machine to learn the correct output. When the output is correct, you don't do anything. If the output is wrong, you tweak the parameter of the machine and correct the output toward the one you want. The trick here is how you figure out which direction and how much you tweak the parameter and this goes back to gradient calculation and backpropagation.
-->
$90\%$ das aplicações de aprendizado profundo utilizam aprendizado supervisionado. O aprendizado supervisionado é um processo no qual, você coleta vários pares de entradas e saídas, e as entradas são dadas como entrada para a máquina aprender a saída correta. Quando a saída está correta, nada é feito. Se a saída está errada, os parâmetros da máquina são ajustados, corrigindo a saída em direção a saída desejada. O truque aqui é como saber a direção e o quanto o parâmetro será ajustado, e isto leva ao cálculo do gradiente e à retropropagação.

<!-- Supervised learning stems from Perceptron and Adaline. The Adaline is based on the same architecture with weighted inputs; when it is above the threshold, it turns on and below the threshold, it turns off. The Perceptron is a 2-layer neuron net where the second layer is trainable and the first layer is fixed. Most of the time, the first layer is determined randomly and that's what they call associative layers.
-->
O Aprendizado Supervisionado deriva do Perceptron e Adaline. Adaline se baseia na mesma arquitetura com entradas ponderadas; quando está acima do limiar, liga, e quando está abaixo, desliga. O Perceptron é uma rede neural de duas camadas onde a segunda camada é treinável e a primeira é fixada. Na maior parte das vezes, a primeira camada é determinada randomicamente, isto é chamado de camadas associativas.

<!-- History of Pattern Recognition and introduction to Gradient Descent
-->
## [História do Reconhecimento de Padrões e introdução ao Gradiente de Descida](https://www.youtube.com/watch?v=0bMe_vCZo30&t=1461s)

<!-- The foregoing is the conceptual basis of pattern recognition before deep learning developed. The standard model of pattern recognition consists of feature extractor and trainable classifier. Input goes into the feature extractor, extracting relevant useful characteristics of inputs such as detecting an eye when the purpose is recognizing the face. Then, the vector of features is fed to the trainable classifier for computing weighted sum and comparing it with the threshold. Here, a trainable classifier could be a perceptron or single neural network. The problem is feature extractor should be engineered by hand. Which means, pattern recognition/computer vision focus on feature extractor considering how to design it for a particular problem, not much devoted to a trainable classifier.
-->
O que foi exposto é a base conceitual do reconhecimento de padrões antes do desenvolvimento do aprendizado profundo. O modelo padrão do reconhecimento de padrões consiste na extração de características e um classificador treinável. A entrada vai para o extrator de características, extraindo informações úteis das entradas, como, detectar a presença de um olho quando o propósito é identificar uma face. Então, o vetor de características é fornecido como entrada para um classificador treinável para computar a soma ponderada e compará-la como o limiar. Aqui, um classificador treinável poderia ser um perceptron ou uma única rede neural. O problema é que o extrator de características precisa ser construído a mão. Ou seja, reconhecimento de padrões/visão computacional se concentra na extração de características, considerando como construí-lo para um problema particular, não sendo muito dedicado ao classificador treinável.

<!-- After the emergence and development of deep learning, the 2-stage process changed to the sequences of modules. Each module has tunable parameters and nonlinearity. Then, stack them making multiple layers. This is why it is called “deep learning”. The reason why using nonlinearity rather than linearity is that two linear layers could be one linear layer since the composition of two linear is linear.
-->
Depois da aparição e desenvolvimento do aprendizado profundo, o processo de 2 etapas mudou para uma sequência de módulos. Cada módulo possui parâmetros ajustáveis e não linearidade. Então, são empilhados, criando múltiplas camadas. Essa é a razão que se chama aprendizado profundo”. A razão pelo uso de não linearidade é que duas camadas lineares equivalem à uma camada linear, já que a composição de duas camadas lineares, é também linear.

<!-- The simplest multi-layer architecture with tunable parameters and nonlinearity could be: input is represented as a vector such as an image or audio. This input is multiplied by the weight matrix which coefficient is a tunable parameter. Then, every component of the result vector is passed through a nonlinear function such as ReLU. Repeating this process, it becomes a basic neural network. The reason why it is called a neural network is that this architecture calculates the weighted sum of components of input by corresponding rows of a matrix.
-->
As arquiteturas mais simples de múltiplas camadas com parâmetros ajustáveis e não linearidades poderia ser: a entrada é representada como um vetor, como por exemplo uma imagem ou áudio. Essa entrada é multiplicada pela matriz de pesos, cujos coeficientes são parâmetros são ajustáveis. Então, toda componente do vetor resultante é passada através uma função não linear como a ReLU. Repetindo esse processo, a arquitetura se torna uma rede neural básica. A razão pela qual se chama rede neural é que essa arquitetura calcula a soma ponderada das componentes da entrada pelas linhas correspondentes da matriz.

<!-- Back to the point of supervised learning, we are comparing the resulting output with target output then optimize the objective function which is loss computing distance/penalty/divergence between the result and target. Then, average this cost function over the training set. This is the goal we want to minimize. In other words, we want to find the value of the parameters that minimize this average.
-->
De volta ao aprendizado supervisionado, estamos comparando a saída resultante com a saída alvo, então otimizamos a função objetivo, que é a distância/penalidade/divergência de computação da perda entre o resultado e o alvo. Então, calculamos a média dessa função de custo sobre o conjunto de treinamento. Esse é o objetivo que queremos minimizar. Em outras palavras, queremos encontrar os valores dos parâmetros que minimizam essa média.

<!-- The method of how to find it is computing gradient. For example, if we are lost in a smooth mountain at foggy night and want to go to the village in the valley. One way could be turning around and seeing which way the steepest way is to go down then take a small step down. The direction is (negative) gradient. With the assumption that the valley is convex, we could reach the valley.
-->
O método de como encontrar tais valores é calcular o gradiente. Por exemplo, se estamos perdidos em uma montanha suave em uma noite nebulosa, e queremos encontrar uma vila em um vale. Uma forma de alcançar tal objetivo é olhar ao redor e ver qual o caminho mais íngreme para descer, e então dar uma pequeno passo para baixo. Essa direção é o gradiente (negativo). Com essa suposição de que o vale é convexo, podemos alcançar o vale.

<!-- The more efficient way is called Stochastic Gradient Descent (SGD). Since we want to minimize average loss over the training set, we take one sample or small group of samples and calculate the error, then use gradient descent. Then, we take a new sample and get a new value for the error, then get the gradient which is a different direction normally. Two of the main reasons for using SGD are that it helps a model to converge fast empirically if the training set is very large and it enables better generalization, which means getting similar performance on various sets of data.
-->
A forma mais eficiente se chama Gradiente de Descida Estocástico (SGD). Já que queremos minimizar a perda média sobre o conjunto de treinamento, podemos pegar uma amostra ou um pequeno conjunto de amostras e calcular o erro, e então usar o gradiente de descida. De tal forma, pegamos uma nova amostra e obtemos um novo valor para o erro, e então obtemos o gradiente, que normalmente é uma direção diferente. As duas principais razões para usar o SGD é que ele ajuda o modelo a convergir mais rapidamente (empiricamente) se o conjunto de treinamento for imenso e permite melhor generalização, o que significa obter desempenho semelhante em vários conjuntos de dados.

<!-- Computing gradients by backpropagation
-->
### [Cálculo de gradientes por retropropagação](https://www.youtube.com/watch?v=0bMe_vCZo30&t=2336s)

<!-- Computing gradients by backpropagation is a practical application of the chain rule. The backpropagation equation for the input gradients is as follows:
-->
Calcular gradiente por retropropagação é uma aplicação prática da regra da cadeia. A equação da retropropagação para os gradientes das entradas é a seguinte:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{x}_{i - 1}} \\
\frac{\partial C}{\partial \boldsymbol{x}_{i - 1}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{x}_{i - 1}}
\end{aligned}
$$

<!-- The backpropagation equation for the weight gradients is as follows:
-->
A equação da retropropagação para os gradientes dos pesos é:

$$
\begin{aligned}
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial \boldsymbol{x}_i}{\partial \boldsymbol{w}_{i}} \\
\frac{\partial C}{\partial \boldsymbol{w}_{i}} &= \frac{\partial C}{\partial \boldsymbol{x}_i}\frac{\partial f_i(\boldsymbol{x}_{i - 1}, \boldsymbol{w}_i)}{\partial \boldsymbol{w}_{i}}
\end{aligned}
$$

<!-- Note that instead of scalar inputs, they will be vector inputs. More generally, multi-dimensional inputs. Backpropagation allows you to compute the derivative of the difference of the output you want and the output you get (which is the value of the objective function) with respect to any value inside the network. Finally, backpropagation is essential as it applies to multiple layers.
-->
É preciso observar que ao invés de entradas escalares, elas serão entradas vetoriais. De forma mais geral, entradas multidimensionais. A retropropagaçaõ permite calcular a derivada da diferença entre a saída que você quer e a saída obtida (que é o valor da função objetivo) com respeito a qualquer valor dentro da rede. Finalmente, a retropropagação é essencial, já que se aplica para múltiplas camadas.

<!-- It is important to consider how to interpret inputs. For example, an image of 256$$\times$$256 would require a 200,000 valued matrix. These would be huge matrices that the neural network layers will need to handle. It would be impractical to utilize such matrices. Therefore, it is important to make hypothesis of the structure of the matrix.
-->
É importante considerar como interpretar as entradas. Por exemplo, uma imagem RGB de 256$$\times$$256 iria requerer uma matriz de 200.000 valores. Essas seriam matrizes enormes que as camadas da rede neural precisarão lidar com. Seria imprático utilizar tais matrizes. Portanto, é importante fazer hipóteses sobre a estrutura da matriz.

<!-- Hierarchical representation of the Visual Cortex
-->
## Representação hierárquica do Córtex Visual

<!-- Experiments by Fukushima gave us an understanding of how our brain interprets the input to our eyes. In summary, it was discovered that neurons in front of our retina compress the input (known as contrast normalization) and the signal travels from our eyes to our brain. After this, the image gets processed in stages and certain neurons get activated for certain categories. Hence, the visual cortex does pattern recognition in a hierarchical manner.
-->
Os experimentos de Fukushima nos deram um entendimento sobre como nosso cérebro interpreta a entrada para os nossos olhos. Em resumo, foi descoberto que os neurônios na frente de nossa retina comprimem a entrada (conhecida como normalização de contraste) e o sinal viaja dos nossos olhos para o nosso cérebro. Depois disso, a imagem é processada em etapas e certos neurônios são ativados para certas categorias. Consequentemente, o córtex visual faz o reconhecimento de padrões de maneira hierárquica.

<!-- Experiments in which researchers poked electrodes in specific areas of the visual cortex, specifically the V1 area made researchers realize that certain neurons react to motifs that appear in a very small area in a visual field and similarly with neighbouring neurons and neighbouring areas in the visual field. Additionally, neurons that react to the same visual field, react to different types of edges in an organized manner (e.g. vertical or horizontal edges). It is also important to note that there's also the idea that the visual process is essentially a feed forward process. Hence, somehow fast recognition can be done without some recurrent connections.
-->
Experimentos nos quais os pesquisadores colocaram eletrodos em áreas específicas do córtex visual, especificamente a área V1, fizeram os pesquisadores perceberem que certos neurônios reagem a padrões que aparecem em uma área muito pequena em um campo visual e de forma semelhante com neurônios vizinhos e áreas vizinhas no campo visual. Além disso, os neurônios que reagem ao mesmo campo visual, reagem a diferentes tipos de bordas de maneira organizada (por exemplo, bordas verticais ou horizontais). Também é importante notar que também existe a ideia de que o processo visual é essencialmente um processo de alimentar para frente. Portanto, de alguma forma, o reconhecimento rápido pode ser feito sem algumas conexões recorrentes.
