---
lang-ref: ch.14-2
lecturer: Yann LeCun
title: 그래프를 이용한 에너지 기반 방법
authors: Yada Pruksachatkun, Ananya Harsh Jha, Joseph Morag, Dan Jefferys-White, and Brian Kelly
date: 4 May 2020
lang: ko
translation-date: 09 Sep 2020
translator: Yujin
---

<!-- ## Comparing Losses -->
## 손실 비교하기

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
Figure 1: Network Architecture
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/GT.png" style="background-color:#DCDCDC;" /><br>
그림 1: 네트워크 구조 
</center>

<!-- In the figure above, incorrect paths have -1. -->
위 그림에서, 오답 경로는 -1의 값을 갖는다. 

<!-- Professor LeCun starts with perceptron loss, which is used in the example of Graph Transformer Model in the figure above. The goal is to make energy of wrong answers large, and correct ones small. -->
르쿤 교수는 위 그림의 그래프 트랜스포머 모델<sup>Graph Transformer Model</sup>의 예에서 사용된 퍼셉트론 손실로 시작한다. 목표는 오답의 에너지를 크게 만들고, 정답의 에너지를 작게 만드는 것이다. 

<!-- In terms of implementation, you would represent the arcs in the visualization with a vector. Rather than a separate arc for each category, one vector contains both the categories and the score for each category. -->
구현 측면에서는, 그림 속의 호<sup>arcs</sup>를 벡터로 표시한다. 각각의 범주를 서로 다른 호를 통해 표현하기보다, 하나의 벡터가 범주와 각 범주에 대한 점수를 모두 포함한다. 

<!-- Q: How is the segmentor implemented in the model above? -->
질문: 위 모델에서 분할기<sup>segmentor</sup>는 어떻게 구현됩니까? 

<!-- A: The segment is handcrafted heuristics. The model uses a handcrafted segment although there is a way to make it trainable end-to-end. This handcrafted approach was superseded by the sliding window approach for character recognition. -->
대답: 분할은 손으로 만들어진 휴리스틱이다. 이 모델은 수작업으로 만들어진 분할을 사용하지만 한 쪽 끝에서 다른 쪽 끝까지<sup>end-to-end</sup> 훈련시킬 수 있는 방법이 있다. 이 수작업 방식은 문자 인식을 위한 슬라이딩 윈도우<sup>sliding window</sup> 방식으로 대체되었다. 


<!-- ## Overview of Losses -->
## 손실에 대한 개요

<!-- <center>
Table 1: Various Loss Equations
</center> -->
<center>
표 1: 다양한 손실 방정식 
</center>

| Loss Equation | Formula  | Margin |
| :---- | :----: | ---:|
| Energy Loss | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)$ | None |
| Perceptron | $\text{E}(\text{W}, \text{Y}^i, \text{X}^i)-\min\limits_{\text{Y}\in\mathcal{Y}}\text{E}(\text{W}, \text{Y}, \text{X}^i)$ | 0  |
| Hinge  | $\max\big(0, m + \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$  | $m$ |
| Log  | $\log\bigg(1+\exp\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | >0 |
| LVQ2  | $\min\bigg(M, \max\big(0, \text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)$ | 0 |
| MCE | $\bigg(1+\exp\Big(-\big(\text{E}(\text{W}, \text{Y}^i,\text{X}^i)-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\Big)\bigg)^{-1}$| >0 |
| Square-Square | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2-\bigg(\max\big(0, m - \text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)\bigg)^2$ | $m$ |
| Square-Exp | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i)^2 + \beta\exp\big(-\text{E}(\text{W}, \overline{\text{Y}}^i,\text{X}^i)\big)$ | >0 |
| NNL/MMI | $\text{E}(\text{W}, \text{Y}^i,\text{X}^i) + \frac{1}{\beta}\log\int_{y\in\mathcal{Y}}\exp\big(-\beta\text{E}(\text{W}, y,\text{X}^i)\big)$ | >0 |
| MEE |$1-\frac{\exp\big(-\beta E(W,Y^i,X^i)\big)}{\int_{y\in\mathcal{Y}}\exp\big(-\beta E(W,y,X^i)\big)}$ | >0 |


<!-- The perceptron loss seen in the table above does not have a margin, and thus the loss has a risk of collapsing. -->
위의 표에 있는 퍼셉트론 손실은 마진을 가지고 있지 않아서 손실이 무너질<sup>collapsing</sup> 위험이 있다. 

<!-- * Hinge loss is taking the energy of the most offending answer, and the correct answer, and computing their difference. Intuitively, with a margin m, the hinge will only have loss of 0 when the correct energy is lower than the most offending energy by _at least_ m.
* MCE loss is used in speech recognition, and looks similar to a sigmoid.
* NLL loss aims to make the energy of the correct answer small, and make the log component of the equation large. -->
* 힌지<sup>Hinge</sup> 손실은 오답의 정도가 가장 큰(가장 문제가 되는)<sup>offending</sup> 답과 정답을 가지고 그 둘 사이의 차이를 계산한다. 직관적으로 살펴보면, 마진 m을 사용하면 올바른 에너지가 가장 문제가 되는 에너지보다 _최소_ m 만큼 낮을 때에만 힌지의 손실이 0이 된다. 
* MCE 손실은 음성 인식에서 사용되고, 시그모이드<sup>sigmoid</sup>와 유사하게 생겼다. 
* NLL 손실은 정답의 에너지를 작게 만들고, 방징식 안의 로그 부분을 크게 만드는 것을 목표로 한다. 

<!-- Q: How may hinge be better than NLL loss? -->
질문: 어떻게 힌지 손실이 NLL 손실보다 나을 수 있습니까?

<!-- A: Hinge is better than NLL becuase NLL will try to push the difference between the correct answer and other answers to infinity, whereas hinge only wants to make it larger than some value (the margin m).  -->
대답: 힌지 손실이 NLL 손실보다 나은 이유는, NLL은 정답과 다른 답 사이의 차이를 무한대로 밀어붙이려 하는 반면, 힌지는 단지 어떤 값 (마진 m) 보다 그 차이를 크게 만들고자 하기 때문이다.  

<!-- ### DEFINITION: -->
### 정의:

<!-- A decoder inputs a sequence of vectors that indicate the scores or energy of individual sounds or images, and picks out the best possible output. -->
디코더는 각각의 소리 또는 이미지의 점수 또는 에너지를 나타내는 일련의 벡터를 입력하고 가능한한 최상의 출력을 선택한다. 

<!-- Q: What are some examples of problems that can use decoders? 
A: Language modelling, machine translation, and sequence tagging.  -->
질문: 디코더를 사용할 수 있는 문제의 예는 어떤 것들 입니까? 
대답: 언어 모델링, 기계 번역, 그리고 시퀀스 태깅<sup>sequence tagging</sup> 등이 있습니다. 

<!-- ## Forward algorithm in Graph Transformer Networks -->
## 그래프 트랜스포머 네트워크에서의 순방향<sup>forward</sup> 알고리즘

<!-- ### Graph Composition -->
### 그래프 구성

<!-- Graph composition allows us to combine two graphs. In this example we can see a language model lexicon being represented as a $trie$ (a graph) and a recognition graph which is produced by a neural network. -->
그래프 구성을 통해 두 개의 그래프를 결합 할 수 있다. 이 예에서 $trie$ (그래프)로 표현되는 언어 모델 어휘와 신경망으로 생성된 인식 그래프<sup>recognition graph</sup>를 확인할 수 있다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>Figure 2</b>: Graph Composition
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/graph_composition.png" height="50%" width="50%" /><br>
<b>그림 2</b>: 그래프 구성
</center>

<!-- The recognition graph specifies with different energy values (associated with each arc) how likely a character is at a particular step. -->
인식 그래프는 각 문자가 특정 단계에 있을 가능성을 각기 다른 에너지 값(각 호와 연관되어 있음)으로 지정한다. 

<!-- Now, for this example, the question we answer with a graph composition operation is, what is the best path in this recognition graph that also agrees with our lexicon? -->
이제 이 예시에서 그래프 구성을 통해 우리가 대답하고자 하는 문제는 이 인식 그래프에서 우리의 어휘와 일치하는 최상의 경로가 무엇인가에 대한 것이다. 

<!-- The common hop from step 1 to step 2 between the recognition graph and the grammar is the character $c$, associated with energy 0.4. Hence, our interpretation graph contains just 1 arc between step 1 and 2 corresponding to $c$. Similarly, possible characters between step 2 and 3 are $x$, $u$ and $a$ in the recognition graph. Branches following $c$ in the grammar graph contain $u$ and $a$. So, the graph composition operation picks out arcs $u$ and $a$ to be present in the interpretation graph. It also associates the arc it copies from the recognition graph with their energy values.  -->
인식 그래프와 문법 사이의 1단계에서 2단계로의 일반적인 점프는 에너지 0.4와 연관된 문자 $c$ 이다. 따라서 해석 그래프<sup>interpretation graph</sup>는 $c$에 대응하는 1단계에서 2단계 사이의 호를 한 개 가진다. 마찬가지로, 인식 그래프에서 단계 2에서 단계 3 사이의 가능한 문자는 $x$, $u$ 그리고 $a$ 이다. 문법 그래프에서 $c$ 에서 뻗어나온 가지는 $u$ 와 $a$ 를 갖는다. 따라서 그래프 구성 작업은 호 $u$ 와 $a$ 를 해석 그래프에 표시할 호로 선택한다. 또한 인식 그래프에서 복사한 호를 에너지 값과 연결한다. 

<!-- If the grammar also contained energy values associated with arcs, the graph composition would have added the energy values or combined them using some other operator. -->
호와 관련된 값이 문법에도 포함되어 있다면, 그래프 구성은 에너지 값을 추가하거나 다른 연산자를 사용하여 그 값들을 결합했을 것이다. 

<!-- In a similar fasion, graph composition also allows us to combine two knowledge bases that are represented by neural networks. In the example discused above, the grammar can essentially be represented as a neural network predicting the next character. The softmax output of the NN provides us with the transition probabilities to the next character from a given node. -->
비슷한 방식으로 그래프 구성을 통해 신경망으로 표현되는 두 개의 지식 베이스<sup>knowledge bases</sup>를 결합할 수도 있다. 위에서 논의된 예시에서, 문법은 본질적으로 다음 문자를 예측해 내는 신경망으로 표현될 수 있다. 신경망의 소프트맥스 출력은 주어진 노드에서 다음 문자로의 전환<sup>transition</sup> 확률을 제공한다. 

<!-- As a side note, if the language model shown in this example is a neural network, we can backpropagate through the entire structure. This becomes an example of a differentiable program where we backpropagate through a program containing loops, if-conditions, recursions etc. -->
참고로, 이 예에서 표현된 언어 모델이 신경망인 경우, 전체 구조를 통해 역전파<sup>backpropagate</sup>를 할 수 있다. 이는 루프, if-조건문, 재귀 등을 포함한 프로그램을 통해 역전파 하는 차별화 가능한 프로그램의 예시가 된다. 

<!-- ### A check reader from mid-90s -->
### 90년대 중반의 수표 판독기

<!-- The entire architecture of a check reader from the mid-90s is quite complex, but what we are primarily interested in, is the part starting from the character recogniser, which produces the recognition graph. -->
90 년대 중반의 수표 판독기가 가지는 전체 구조는 굉장히 복잡하지만, 우리가 주로 관심을 갖는 부분은 인식 그래프를 생성하는 문자 인식기에서 시작한다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>Figure 3</b>: Check reader
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png"/><br>
<b>그림 3</b>: 수표 판독기
</center>

<!-- This recognition graph undergoes two separate composition operations, one with the correct interpretation (or the ground truth) and second with the grammar which creates a graph of all possible interpretations. -->
이 인식 그래프는 두 개의 구별되는 구성 작업을 거치고, 하나는 정답 해석 (또는 실제 값 또는 데이터<sup>ground truth</sup>) 그리고 다른 하나는 모든 가능한 해석의 그래프를 만드는 문법을 사용한다.

<!-- The entire system is trained via the Negative Log-Likelihood loss function. The negative log-likelihood says that each path in the interpretation graph is a possible interpretation and sum of energies along that path is the energy of that interpretation. -->
전체 시스템은 음의 로그 우도 손실 함수<sup>Negative Log-Likelihood loss function</sup>를 통해 훈련된다. 음의 로그 우도는 해석 그래프의 각 경로가 가능한 해석이고, 그 경로를 따른 에너지의 합이 해당 해석의 에너지임을 나타낸다. 

<!-- Now, instead of using the Viterbi algorithm, we use the forward algorithm. The following sub-sections discuss the differences between the two approaches. -->
이제 Viterbi 알고리즘을 사용하는 대신, 순방향 알고리즘을 사용한다. 이어지는 하위 섹션에서는 이 두 접근 방식의 차이점에 대해 논의한다. 

<!-- #### Viterbi algorithm -->
#### Viterbi 알고리즘

<!-- Viterbi algorithm is a dynamic programming algorithm that is used to find the most likely path (or the path with the minimum energy) in a given graph. It minimises the energy with respect to a latent variable z, where z represents the path we are taking in the graph. -->
Viterbi 알고리즘은 동적 프로그래밍 알고리즘으로써 주어진 그래프에서 가장 가능성이 높은 경로 (혹은 최소의 에너지를 갖는 경로)를 찾는데 사용된다. 잠재 변수 z를 고려한 에너지를 최소화하고, 여기서 z는 그래프에서 우리가 취하는 경로를 나타낸다. 

$$F (x, y) = \min_{z} \; E(x, y, z)$$

<!-- #### The forward algorithm -->
#### 순방향<sup>forward</sup> 알고리즘

<!-- The forward algorithm, on the other hand, computes the log of sum of exponentials of the negative value of energies of all paths. This mouthful can be easily seen as a formula below: -->
반면에 순방향 알고리즘은 모든 경로에 대해 음수 에너지 값의 지수값을 구하고 그것을 총합한 것에 로그를 취한 값을 계산한다. 이 기나긴 표현은 간단하게 아래의 공식으로 표현될 수 있다. 

$$F_{\beta} (x, y) = -\frac{1}{\beta} \; \log \; \sum_{z \, \in \, \text{paths}} \; \exp \, (- \beta \; E(x, y, z))$$

<!-- This is marginalising over the latent variable z, which defines the paths in an interpretation graph. This approach computes this log sum exponential value over all possible paths to a particular node. This is like combning the cost of all possible paths in a soft-minimum way. -->
이것은 해석 그래프에서 경로를 결정하는 잠재 변수 z에 대해 마지널라이징<sup>marginalising</sup>한다. 이 접근 방식은 특정한 노드에 대해 가능한 모든 경로에 대해 Log-Sum-Exponential을 취하여 계산한다. 이는 마치 소프트-미니멈<sup>soft-minimum</sup> 방식으로 가능한 모든 경로의 비용을 합하는 것과 같다.  

<!-- The forward algorithm is cheap to implement and does not cost more than Viterbi algorithm. Also, we can backpropagate through the forward algorithm node in the graph. -->
순방향 알고리즘은 Viterbi 알고리즘보다 구현하는데 드는 수고가 적다. 또한, 순방향 알고리즘 노드를 통해 그래프를 역전파 할 수 있다. 

<!-- The working of the forward algorithm can be shown using the following example defined on an interpretation graph. -->
순방향 알고리즘의 작동은 다음 예시에서 정의된 해석<sup>interpretation</sup> 그래프 위에서 확인할 수 있다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>Figure 4</b>: Interpretation graph
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/interpretation_graph.png" height="50%" width="50%" /><br>
<b>그림 4</b>: 해석 그래프
</center>


<!-- The cost from the input node to the red shaded node is computed by marginalising over all possible paths reaching the red node. The arrows entering the red node define these possible paths in our example. -->
입력 노드에서 빨간색으로 표시된 노드까지의 비용은 빨간 노드에 도달 할 수 있는 모든 경로에 대한 마지널라이징<sup>marginaliising</sup>를 통해 계산된다. 빨간 노드로 들어가는 화살표는 이 예시 안에서 가능한 경로들을 나타낸다. 

<!-- For the red node, the value of energy at the node is given by: -->
빨간색 노드의 경우 이 노드에서의 에너지 값은 다음과 같다. 

$$-\frac{1}{\beta} \; \log \; [ \, \exp \, (- \, \beta (e_1 \, + \, e_3)) \; + \; \exp \, (- \, \beta (e_2 \, + \, e_4)) \, ]$$

<!-- #### Neural network analogy of forward algorithm -->
#### 순방향 알고리즘과 신경망 사이의 유사성 

<!-- The forward algorithm is a special case of the belief-propagation algorithm, when the underlying graph is a chain graph. This entire algorithm can be viewed as a feed-forward neural network where the function at each node is a log sum of exponentials and an addition term.  -->
순방향 알고리즘은 기본 그래프가 체인 그래프<sup>chain graph</sup>인 경우 신념 전파<sup>belief-propagation</sup> 알고리즘의 특수한 케이스이다. 이 전체 알고리즘은 각 노드의 함수가 Log-Sum-Exponential와 덧셈 항인 피드포워드<sup>feed-forward</sup> 신경망으로 볼 수 있다. 

<!-- For each node in the interpretation graph, we maintain a variable $\alpha$. -->
해석 그래프의 각 노드에 대해 $\alpha$ 변수를 유지한다. 

$$ \alpha_{i} = - \; \log \; \biggl[ \sum_{k \, \in \, \text{parent} \, (i)} \; \exp \, (- \, \beta \; (\alpha_k \, + \, e_{ki})) \biggl]$$

<!-- where $e_{ki}$ is the energy of the link from node $k$ to node $i$.  -->
여기서 $e_{ki}$ 는 노드 $k$에서 노드 $i$로의 연결 에너지이다. 

<!-- $\alpha_i$ forms the activation of a node $i$ in this neural network and $e_{ki}$ is the weight between nodes $k$ and node $i$. This formulation is algebraically equivalent to the weighted sum operations of a regular neural network in the log domain. -->
$\alpha_i$는 이 신경망에서 노드 $i$의 활성화<sup>activation</sup>을 형성하고 $e_{ki}$는 노드 $k$ 와 노드 $i$ 사이의 가중치이다. 이 공식은 로그 도메인에서 정규 신경망의 가중치 합 연산과 대수적으로<sup>algebraically</sup> 동일하다. 

<!-- We can backpropagate through the dynamic interpretation graph (since it changes from example to example) on which we apply the forward algorithm. We can compute the gradients of $F(x, y)$ computed at the last node of the graph w.r.t the $e_{ki}$ weights defining the edges of the interpretation graph. -->
순방향 알고리즘을 적용한 동적 해석 그래프를 통해 역전파 할 수 있다(왜냐하면 예시에서 예시로 변경되기 때문<sup>since it changes from example to example</sup>이다). 해석 그래프의 에지를 정의하는 $e_{ki}$ 가중치를 고려한 그래프의 마지막 노드에서 계산된 $F(x, y)$의 그래디언트를 얻을 수 있다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>Figure 5</b>: Check reader
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/check_reader.png" /><br>
<b>그림 5</b>: 수표 판독기
</center>

<!-- Returning back to the check reader example, we apply the forward algorithm on the two graph compositions and obtain the energy value at the last node using the log sum exponential forumla. The difference between these energy values is the negative log-likelihood loss. -->
수표 판독기의 예제로 돌아가서, 두 그래프 구성에 순방향 알고리즘을 적용하고, Log-Sum-Exponential 공식을 이용해서 마지막 노드의 에너지 값을 얻는다. 이 에너지 값들의 차이는 음의 로그 우도 손실이다. 

<!-- The value obtained from applying the forward algorithm on the graph composition between correct answer and recognition graph is the log sum exponential value of the correct answer. In contrast, log sum exponential value at the last node of the graph composition between recognition graph and grammar is the marginalised value over all possible valid interpretations. -->
정답과 인식 그래프 사이의 그래프 구성에 순방향 알고리즘을 적용해 얻은 값은 정답의 Log-Sum-Exponential 값이다. 반대로 인식 그래프와 문법 사이의 그래프 구성의 최종 노드에서의 Log-Sum-Exponential 값은 가능한 모든 유효한 해석에서 밀려난(마지널라이즈 된) 값이다.  

<!-- # Lagrangian formulation of Backpropagation -->
# 역전파의 라그랑지안 공식화<sup>Lagrangian formulation of Backpropagation</sup>
<!-- For an input $x$ and target output $y$, we can formulate a network as a collection of functions, $f_k$ and weights, $w_k$ such that successive steps in the network output $z_k$ with $z_{k+1} = f_k(z_k, w_k)$. In a supervised setting, the goal of the network is to minimize $C(z_n, y)$, the cost of the $n^\mathrm{th}$ output of the network, with respect to the ground truth. This is equivalent to the problem of minimizing $C(z_n, y)$ with respect to the constraints $z_{k+1} = f_k(z_k, w_k)$ and $z_0 = x$. -->
입력 $x$ 및 목표 출력 $y$의 경우, 네트워크의 연속 단계가 $z_k$ 와 $z_{k+1} = f_k(z_k, w_k)$ 를 출력하도록 네트워크를 함수 $f_k$ 와 가중치 $w_k$의 모음으로 공식화 할 수 있다. 지도 학습 환경에서, 네트워크의 목표는 실제 값과 관련된 네트워크의 출력 비용인 $C(z_n, y)$를 최소화 하는 것이다. 이는 제약 조건 $z_{k+1} = f_k(z_k, w_k)$ 와 $z_0 = x$ 아래에서 $C(z_n, y)$ 를 최소화 하는 문제와 동일하다. 


<!-- The Lagrangian can be written:
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
where the $ \lambda $ terms denote Lagrange multipliers (see [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx) for a refresher if Calc 3 was a while ago). -->
라그랑지안은 다음과 같이 쓸 수 있다. 
$$ \mathcal{L}(x, y, \lambda_i, z_i, w_i) = C(z_n, y) + \sum\limits_{k=0}^{n-1} \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) $$
$ \lambda $ 항은 라그랑지안 승수<sup>multiplier</sup>를 나타낸다(만약 미적분 3 을 접한지 오래됐다면, 다음을 참고할 수 있다. [Paul's online notes](http://tutorial.math.lamar.edu/Classes/CalcIII/LagrangeMultipliers.aspx).

<!-- To minimize $\mathcal{L}$, we need to set the partial derivatives of $\mathcal{L}$ with respect to each of its arguments to zero and solve. -->
$\mathcal{L}$ 를 최소화 하려면, 각 인수에 대해 $\mathcal{L}$의 편미분 값을 0으로 두고 풀어야 한다. 

<!-- - For $\lambda$, we simply recover the constraint: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- For $z_k$, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, which is just the standard backpropagation formula. -->
- $\lambda$ 의 경우 간단하게 제약 조건을 복구한다: $\frac{\partial{\mathcal{L}}}{\partial \lambda_{k+1}} = 0 \rightarrow z_{k+1} = f_k(z_k, w_k)$.
- $z_k$ 의 경우, $\frac{\partial \mathcal{L}}{\partial z_k} = 0 \rightarrow \lambda^T_k - \lambda^T_{k+1} \frac{\partial f_k(z_k, w)}{\partial z_k} \rightarrow \lambda_k = \frac{\partial f_k(z_k, w_k)^T}{\partial z_k}\lambda_{k+1}$, 이는 표준적인 역전파 공식이다. 

<!-- This approach originated with Lagrange and Hamilton in the context of Classical Mechanics, where the minimization is over the energy of the system and the $\lambda$ terms denote physical constraints of the system, such as two balls being forced to stay at a fixed distance from each other by virtue of being attached by a metal bar, for example. -->
이 접근 방식은 최소화가 시스템의 에너지에 대한 것이고 $\lambda$ 항은 물리적 제약을 나타내는 고전 역학<sup>Classical Mechanics</sup>의 맥락에서 라그랑지<sup>Lagrange</sup> 그리고 해밀톤<sup>Hamilton</sup>으로부터 시작됐다. 예를 들어, 두 개의 공이 금속 막대에 부착된 덕에 서로 고정 된 거리를 유지하도록 강제하는 것과 같다. 

<!-- In a situation where we need to minimize the cost $C$ at every time step, $k$, the Lagrangian becomes
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$. -->
매번 $k$ 단계에서 비용 $C$ 를 최소화 해야 하는 상황에서 라그랑지안은 다음과 같이 표현된다. 
$$ \mathcal{L} = \sum_k \left(C_k(z_k, y_k) + \lambda^T_{k+1}(z_{k+1} - f_k(z_k, w_k)) \right) $$.

<!-- # Neural Ordinary Differential Equation -->
# 뉴럴 상미분방정식<sup>Neural Ordinary Differential Equation</sup>
<!-- Using this formulation of backprop, we can now talk about a new class of models, Neural ODEs. These are basically recurrent networks where the state, $z$, at time $t$ is given by
$ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $, where $ W$ represents some set of fixed parameters. This can also be expressed as an ordinary differential equation (no partial derivatives): $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$. -->
역전파에 관한 이 공식을 사용해서 이제 새로운 모델인 뉴럴 상미분방정식<sup>Neural ODEs</sup>에 대해 이야기 할 수 있다. 이들은 기본적으로 $t$ 시점의 상태 $z$ 가 $ z_{t+\text{d}t} = z_t + f(z_t, W) dt  $ 로 주어지는 순환신경망이고, 여기에서 $ W$ 는 일부 고정 매개 변수 집합을 나타낸다. 이는 또한 상미분방정식(편미분 없음)으로 표현될 수 있다: $\frac{\text{d}z}{\text{d}t} = f(z_t, W)$.

<!-- Training such a network using the Lagrangian formulation is very straightforward. If we have a target, $y$, and want the state of the system to reach $y$ by time $T$, we simply establish the cost function as the distance between $z_T$ and $y$. Another goal of the network could be to find a stable state of the system, i.e. one that ceases to change after a certain point. Mathematically, this is equivalent to setting $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$. In general, finding a solution, $y$ to this equation is much easier than back propagation through time, because the network need not remember the gradient with respect to the whole sequence, and only has to minimize $f$ or $\lvert f \rvert^2$. For more information about training neural ODE's to reach fixed points, see [(Lecun88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf). -->
라그랑지안 공식을 사용해서 이러한 네트워크를 훈련시키는 것은 매우 간단하다. 목표 $y$가 있고, 시스템이 시점 $T$ 에서 $y$ 의 상태에 도달하기를 원한다면, 간단하게 비용 함수를 $z_T$ 와 $y$ 사이의 거리 함수로 설정한다. 이 네트워크의 또 다른 목표는 시스템의 안정적인 상태, 다른 말로 표현하자면, 특정 시점 이후 더 이상 변화가 일어나지 않는 상태를 찾는 것이다. 이것은 수학적으로 $\frac{\text{d}z}{\text{d}t} = f(y, W) = 0$ 와 같이 설정하는 것과 같다. 일반적으로 이 방정식에 대한 해답인 $y$ 를 찾는 것이 시간을 통한 역전파보다 훨씬 쉬운데, 왜냐하면 네트워크가 전체 시퀀스에 대한 그래디언트를 기억할 필요가 없고 $f$ 또는 $\lvert f \rvert^2$ 만 최소화 하면 되기 때문이다. 뉴럴 상미분방정식을 고정된 점에 도달시키기 위해 훈련하는 것에 관련해 더 자세한 장보는 [(르쿤88)](http://yann.lecun.com/exdb/publis/pdf/lecun-88.pdf) 을 참조하면 된다.  

<!-- # Variational Inference in terms of Energy -->
# 에너지 측면에서의 변이<sup>variational</sup> 추론

<!-- ## Introduction -->
## 소개
<!-- For an elementary energy function $E(x,y,z)$, if we wish to marginalize over a variable, z, to obtain a loss in terms of only $x$ and $y$,  $L(x,y)$, we must compute -->
기본 에너지 함수 $E(x,y,z)$ 의 경우, 변수 z 에 대해 마지널라이즈<sup>marginalize</sup>하여 $x$ 와 $y$, $L(x,y)$ 만으로 손실을 얻기 위해서는 다음을 계산해야만 한다. 

$$L(x,y) = -\frac{1}{\beta}\int_z \exp(-\beta E(x,y,z))$$

<!-- If we then multiply by $\frac{q(z)}{q(z)}$, we get
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$ -->
그 다음 $\frac{q(z)}{q(z)}$ 을 곱하면, 다음을 얻는다. 
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!-- If we assume that $q(z)$ is a probability distribution over $z$, we can interpret our rewritten loss function integral as an expected value, with respect to the distribution of $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$. -->
$q(z)$ 가 $z$ 에 대한 확률 분포라고 가정하면, 재작성된 손실 함수 적분을 $\frac{\exp({-\beta E(x,y,z)})}{q(z)}$ 의 분포와 관련해 평균(기댓값)<sup>expected value</sup>으로 해석할 수 있다. 

<!-- We use this interpretation, Jensen's Inequality, and sampling-based approximations, to indirectly optimize our loss function. -->
이 해석과, 옌센 부등식<sup>Jensen's Inequality</sup>, 그리고 샘플링 기반 근사<sup>approximations</sup>을 이용해서 손실 함수를 간접적으로 최적화 한다. 

<!-- ## Jensen's Inequality -->
## 옌센 부등식<sup>Jensen's Inequality</sup>

<!-- Jensen's Inequality is a geometrical observation that states: if we have a convex function, then the *expectation* of that function, over a range, is less than the average of the function evaluated at the beginning and end of the range. Geometrically illustrated this is very intuitive: -->
옌센 부등식은 다음과 같은 기하학적 관찰이다. 만일 볼록 함수가 있으면, 해당 함수의 치역<sup>range</sup> 위 *기댓값(평균)*은 치역의 처음과 끝에서 측정한 함수값의 평균보다 작다. 기하학적으로 표현되는 이 내용은 매우 직관적이다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>Figure 6:</b> Jensen's Inequality (taken from [Wikipedia](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center> -->
<center>
<img src="{{site.baseurl}}/images/week14/14-2/wikipedia_jensens_inequality.png" height="50%" width="50%" style="background-color:#DCDCDC;" /><br>
<b>그림 6:</b> 옌센 부등식 (출처 [위키피디아](https://en.wikipedia.org/wiki/Jensen%27s_inequality))
</center>

<!-- Likewise, if $F$ is convex, for a fixed probability distribution $q$, we can infer from  Jensen's Inequality that over the range $z$, -->
마찬가지로, $F$ 가 볼록하면, 고정된 확률 분포 $q$에 대해 옌센 부등식으로부터 $z$ 범위에 대해 다음과 같이 추론할 수 있다.  

$$F\Bigg(\int_z q(z)h(z)\Bigg) \leq \int_z q(z)F(h(z)) \tag{1}$$

<!-- Now, recall that our marginalized $L(x,y)$ after multiplication with $\frac{q(z)}{q(z)}$ is,  
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$ -->
이제 $\frac{q(z)}{q(z)}$ 을 곱하여 마지널라이즈<sup>marginalized</sup> 된 $L(x,y)$ 는 다음과 같다. 
$$L(x,y) = -\frac{1}{\beta}\int_z q(z) \frac{\exp({-\beta E(x,y,z)})}{q(z)}$$

<!-- If we make $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$, we know from Jensen's Inequality $(1)$ that -->
만약 $h(z) = -\frac{1}{\beta} \frac{\exp({-\beta E(x,y,z)})}{q(z)}$ 을 만들면, 옌센 부등식 $(1)$ 로부터 다음을 알게 된다. 

$$F\Bigg(\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z)F\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

<!-- Let's continue to work this, with a concrete convex loss function, $F(x) = -\log(x)$ -->
이제 명확하게 볼록 함수인 $F(x) = -\log(x)$ 를 가지고 이 작업을 계속해 보자.

$$-\log\Bigg(-\frac{1}{\beta}\int_z q(z)\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg) \leq \int_z q(z) * \frac{-1}{\beta}\log\Bigg(\frac{\exp({-\beta E(x,y,z)})}{q(z)}\Bigg)$$

$$\leq \int_z q(z)[E(x,y,z) + \frac{1}{\beta}\log(q(z))]$$

$$\leq \int_z q(z)E(x,y,z) + \frac{1}{\beta}\int_z q(z)\log(q(z))$$

<!-- Great! Now we have an upper bound to our loss function $L(x,y)$, composed of two terms we understand. The first term $\int_z q(z)E(x,y,z)$ is the *average* energy. And the second term $\frac{1}{\beta}\int_z\log(q(z))$ is just some factor ($-\frac{1}{\beta}$) times the *entropy* of the distribution $q$. -->
자, 이제 우리가 이해하는 두 항으로 구성된 손실 함수 $L(x,y)$ 의 상한을 알게됐다. 첫 번째 항 $\int_z q(z)E(x,y,z)$ 은 *평균* 에너지이다. 그리고 두 번째 항 $\frac{1}{\beta}\int_z\log(q(z))$ 은 어떤 요인 ($-\frac{1}{\beta}$) 곱하기 분포 $q$ 의 *엔트로피* 이다. 

<!-- ## What's the point? -->
## 그래서 요점이 무엇인가? 

<!-- We now have formulated an upper bound in such a way that we can avoid complicated integrations, and instead simply approximate these values by sampling from a surrogate distribution ($q(z)$), of our choice! -->
이제 복잡한 적분 대신에 우리가 선택한 대리 분포<sup>surrogate distribution</sup> ($q(z)$) 에서 샘플링하여 이 값들을 근사하는 방식으로 상한을 공식화 했다. 

<!-- To get the value of the first term of our upper bound function, we just sample from that distribution, and compute the average value of $L$ that we obtain from applying our sampled $z$'s. -->
상한 함수의 첫 번째 항 값을 구하기 위해서 해당 분포에서 샘플링하고 샘플링된 $z$ 를 적용해서 얻은 $L$ 의 평균을 계산한다. 

<!-- The second term (a factor of entropy) is just a property of the distribution family, and can likewise be approximated with random sampling of $q$. -->
두 번째 항 (엔트로피 인자<sup>factor</sup>)는 분포 모임<sup>distribution family</sup>의 속성일 뿐이고, 마찬가지로 $q$ 에서의 랜덤 샘플링을 근사할 수 있다. 

<!-- Finally, we can minimize $L$ with respect to its parameters (say, weights of a network $W$), by minimizing this function that bounds $L$ above. We conduct this minimization by updating our two variables: (1) the entropy of $q$, and (2) our model parameters $W$. -->
마지막으로, 위의 $L$을 제한하는 이 함수를 최소화 함으로써 매개 변수 (예를 들어, 네트워크 $W$ 의 가중치)를 고려한 $L$ 를 최소화 할 수 있다. 이 최소화는 다음의 두 변수를 업데이트함으로써 수행할 수 있다: (1) $q$ 의 엔트로피, 그리고 (2) 모델 매개변수 $W$.


<!-- ## Summary -->
## 요약
<!-- This is the "energy view" of variational inference. If you need to compute the log of a sum of exponentials, replace it with the average of your function plus an entropy term. This gives us an upper bound. We then minimze this upper bound, and in doing so minimize the function we actually care about. -->
이것이 변이 추론의 "에너지 관점"이다. Log-Sum-Exponential 을 계산해야 할 경우 함수의 평균에 엔트로피 항을 더한 값으로 대체하면 된다. 그 다음 이 상한을 최소화하고, 이렇게 함으로써 우리가 실제로 중요시하는 함수를 최소화 한다. 
