---
lang-ref: ch.13-2
title: 그래프 합성곱 신경망 II
lecturer: Xavier Bresson
authors: Neil Menghani, Tejaishwarya Gagadam, Joshua Meisel and Jatin Khilnani
date: 27 Apr 2020
lang: ko
translation-date: Sep 16 2020
translator: Seok Hoan (Kevin) Choi

---
<!-- 
## [Spectral Graph ConvNets (GCNs)](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=2670s)

In the previous section we discussed Graph Spectral Theory, one of the two ways to define convolution for graphs, which we can now use to define Spectral GCNs.
-->

## [스펙트럼 그래프 합성곱 신경망<sup>Spectral Graph ConvNets </sup>(GCNs)](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=2670s)

지난 섹션에서는, 그래프 합성곱 신경망을 정의하는 두 가지 방법 중 하나인 그래프 스펙트럼 이론에 대해 살펴봤었고, 이번 섹션에서는 그래프 스펙트럼 이론을 이용해 스펙트럼 GCNs를 정의할 것이다. 


<!--
### Vanilla Spectral GCN

We define a graph spectral convolutional layer such that given layer $h^l$, the activation of the next layer is:

$$
h^{l+1}=\eta(w^l*h^l),
$$
--> 

###  기본 스펙트럼 GCN <sup>Vanilla Spectral GCN</sup>

그래프 스펙트럼 합성곱 신경망의 정의는 다음과 같다: 주어진 레이어 $h^l$에 다음 레이어의 활성화 함수<sup>activation</sup>는

$$
h^{l+1}=\eta(w^l*h^l),
$$

<!--
where $\eta$ represents a nonlinear activation and $w^l$ is a spatial filter. The RHS of the equation is equivalent to $\eta(\hat{w}^l(\Delta)h^l)$ where $\hat{w}^l$ represents a spectral filter and $\Delta$ is the Laplacian. We can further decompose the RHS of the equation into $\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$, where $\boldsymbol{\phi}$ is the Fourier matrix and $\Lambda$ is the eigenvalues. This yields the final activation equation as below.
-->

$\eta$는 비선형 활성화 함수<sup>nonlinear activation</sup>를 뜻하고 $w^l$은 공간 필터<sup>spatial filter</sup>이다. 우측 수식은 $\eta(\hat{w}^l(\Delta)h^l)$와 같으며 $\hat{w}^l$는 스펙트럼 필터를 뜻하고 $\Delta$는 라플라시안<sup>Laplacian</sup>이다. 우측 공식은 $\eta(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l)$으로 좀 더 분해<sup>decompose</sup>할 수 있으며, $\boldsymbol{\phi}$는 푸리에 행렬<sup>Fourier matrix</sup>이고, $\Lambda$ 는 고유값<sup>eigenvalues</sup>이다. 이는 최종적으로 아래의 활성화 함수를 도출한다.

<!--
$$
h^{l+1}=\eta\Big(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l\Big)
$$

The objective is to learn the spectral filter $\hat{w}^l(\lambda)$ using backpropagation instead of hand crafting.
-->

$$
h^{l+1}=\eta\Big(\boldsymbol{\phi} \hat{w}^l(\Lambda)\boldsymbol{\phi^\top} h^l\Big)
$$

목표는 스펙트럼 필터 학습을 일일이 하는 것이 아닌 역전파<sup>backpropagation</sup>를 이용해 학습시키는 것이다.

<!--
This technique was the first spectral technique used for ConvNets, but it has a few limitations:
* No guarantee of spatial localization of filters
* Need to learn $O(n)$ parameters per layer ($\hat{w}(\lambda_1)$ to $\hat{w}(\lambda_n)$)
* Learning rate is $O(n^2$) because $\boldsymbol{\phi}$ is a dense matrix
-->
이 기법은 합성곱 신경망에 사용된 최초의 스펙트럼 기법이지만 몇몇가지의 제약점들이 존재한다:
* 필터의 공간 국소화<sup>spatial localization of filters</sup>가 보장되지 않음
* 각 레이어 별로 $O(n)$ 변수<sup>parameters</sup>를 학습시켜야함  ($\hat{w}(\lambda_1)$ 에서$\hat{w}(\lambda_n)$ 까지)
* $\boldsymbol{\phi}$가 조밀 행렬<sup>dense matrix</sup>이기에 학습 속도가 $O(n^2$) 

<!--
### SplineGCNs

SplineGCNs involve computing smooth spectral filters to get localized spatial filters. The connection between smoothness in frequency domain and localization in space is based on Parseval's Identity (also Heisenberg uncertainty principle): smaller derivative of spectral filter (smoother function) $\Leftrightarrow$ smaller variance of spatial filter (localization).
-->

### SplineGCNs

SplineGCNs는 국소 공간 필터<sup>localized spatial filters</sup>를 얻기 위해 매끄러운<sup>smooth</sup> 스팩트럼 필터를 이용한다. 주파수 영역<sup>frequency domain</sup>의 매끄러움과 공간의 국소화의 연결은 파르스발 항정식<sup> Parseval's Identity</sup>(하이젠베르크 불확정성 원리<sup>Heisenberg uncertainty principle</sup> 포함)에 기반을 두고있다: 작은 스펙트럼 필터의 미분<sup>derivative</sup> (더 매끄러운 함수일 수록) $\Leftrightarrow$  작은 공간 필터 (국소화)의 분산<sup>variance</sup>

<!--
How do we get a smooth spectral filter? We decompose the spectral filter to be a linear combination of $K$ smooth kernels $\boldsymbol{B}$ (splines) so that $\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$. The activation equation the is as the following.

$$
h^{l+1}=\eta\bigg(\boldsymbol{\phi} \Big(\text{diag}(\boldsymbol{B}w^l)\Big)\boldsymbol{\phi^\top} h^l\bigg)
$$

Now, we only have $O(1)$ parameters (constant $K$) per layer to be learned through backpropagation. However, the learning complexity is still $O(n^2)$.
-->

어떻게해야 매끄러운 스펙트럼 필터를 얻을 수 있을까? 이는 스펙트럼 필터를 $K$ 매끄러운 커널 $\boldsymbol{B}$   (스플라인<sup>splines</sup>)의 일차 결합<sup>linear combination</sup>으로 분해하여 다음과 같게 만든다 $\hat{w}^l(\Lambda)=diag(\boldsymbol{B}w^l)$. 활성화 공식은 다음과 같다:

$$
h^{l+1}=\eta\bigg(\boldsymbol{\phi} \Big(\text{diag}(\boldsymbol{B}w^l)\Big)\boldsymbol{\phi^\top} h^l\bigg)
$$

이제 역전파로 학습될 각 레이어 별로 $O(1)$의 매개변수를 갖지만 학습 복잡도가 아직 $O(n^2)$으로 남는다는 문제가 있다. 

<!--
### LapGCNs

How do we learn in linear time $O(n)$ (w.r.t. graph size $n$)? The $O(n^2)$  complexity is a direct result of using Laplacian eigenvectors. We need to avoid eigen-decomposition, which can be achieved by directly learning a function of the Laplacian. The spectral function will be a monomial of the Laplacian as shown here.

$$
w*h=\hat{w}(\Delta)h=\bigg(\sum^{K-1}_{k=0}w_k\Delta^k\bigg)h
$$
-->

### LapGCNs

어떻게 하면 (그래프 사이즈 $n$에 비례하여) 선형 시간 $O(n)$로 학습이 가능할까?  이는 $O(n^2)$ 복잡도는 라플라시안 고유벡터를 사용해 나온 직접적인 결과이기에 고유분해법이 아닌 라플라시안 함수의 직접적인 학습을 통해 해결 가능하다. 스펙트럼 함수는 다음과 같이 라플라시안의 단항<sup>monomial</sup>이다.

$$
w*h=\hat{w}(\Delta)h=\bigg(\sum^{K-1}_{k=0}w_k\Delta^k\bigg)h
$$

<!--
One nice feature is that filters are localized in exactly k-hop supports.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<b>Figure 1:</b> Demonstrates 1-hop and 2-hop neighbourhoods
</center>
-->

매력적인 특징 중 하나는 필터가 정확히 k-hop 근방 안에 위치한다는 것이다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure1.png" style="background-color:#DCDCDC;" /><br>
<b>Figure 1:</b>  1-hop과 2-hop 근방을 나타낸다.
</center>

<!-- 
We replace the expression $\Delta^kh$ with $X_k$, a recursive equation defined as,

$$
X_k=\Delta X_{k-1} \text{ and } X_0=h
$$

Complexity is now $O(E.K)=O(n)$ for sparse (real-world) graphs. We can reshape $X_k$ into $\bar{X}$ to form a linear operation. We now have the following activation equation.

$$
h^{l+1}=\eta\bigg(\sum^{K-1}_{k=0}w_kX_k\bigg)=\eta\Big((w^l)^\top \bar{X}\Big)
$$
-->

$\Delta^kh$를 다음과 같이 정의된 재귀함수<sup>recursive equation</sup> $X_k$로 표현한다:

$$
X_k=\Delta X_{k-1} \text{ and } X_0=h
$$

희소 그래프<sup>sparse graphs</sup>에서의 복잡도는 이제 $O(E.K)=O(n)$이고, 선형연산을 위해  $X_k$를 $\bar{X}$로 재배열<sup>reshape</sup>이 가능하여 다음과 같은 활성화 함수를 갖는다:

$$
h^{l+1}=\eta\bigg(\sum^{K-1}_{k=0}w_kX_k\bigg)=\eta\Big((w^l)^\top \bar{X}\Big)
$$

<!--
Note: Since no Laplacian eigen-decomposition is used, all operations are in the  spatial (not spectral) domain, so calling them Spectral GCNs may be misguided. Further, another drawback of LapGCNs is that convolutional layers involve sparse linear operations, which GPU's are not fully optimized for.
-->

주의: 사실 라플라시안 고유분해를 사용하지 않았고, 모든 연산법은 (스펙트럼이 아닌) 공간적 영역<sup>spatial domain</sup>에서 이뤄지기에, 스펙트럼 GCNs 이라고 부르는 것은 잘못된 표현법이다. 더 나아가, LapGCNs의 또 다른 단점은 합성곱 신경망이 희소 선형 연산<sup>sparse linear operations</sup>을 이용해, GPU에 최적화 되어있지 않다는 점이다.

<!--
We now have resolved the 3 limitations of Vanilla GCNs through localized filters (in $K$-hop support), $O(1)$ parameters per layer and $O(n)$ learning complexity. However, the limitation of LapGCNs is that monomial basis ($\Delta^0,\Delta^1,\ldots$) used is unstable for optimization because it is not orthogonal (changing one coefficient changes the function approximation).
-->

국소 필터, 각 레이어 별  $O(1)$의 매개변수, $O(n)$ 학습복잡도를 통해 일반적인 GCNs의 한계점들을 해결하였지만 LapGCNs의 사용된 단항식 기저<sup>monomial basis </sup>는 직교<sup>orthogonal</sup>가 아니기에 아직 최적화에 불안정하다는 단점이 존재한다  (하나의 계수<sup>coefficient</sup>를 바꿈으로 함수 근사<sup>function approximation</sup>를 바꾼다).

<!--
### ChebNets

To resolve the issue of unstable basis we can use any orthonormal basis, but it must have a recursive equation to ensure linear complexity. For ChebNets we use Chebyshev polynomials, and as in a LapGCN we represent the expression $T_k(\Delta)h$ (Chebyshev function applied to $h$) by $X_k$, a recursive equation defined as,

$$
X_k=2\tilde{\Delta} X_{k-1} - X_{k-2}, X_0=h, X_1=\tilde{\Delta}h  \text{ and } \tilde{\Delta} = 2\lambda_n^{-1}\Delta - \boldsymbol{I}
$$
-->

### ChebNets

불안정 기저 문제를 해결하기 위해서 직교 기저들을 사용 가능하지만 선형 복잡도를 위해서는 반드시 재귀함수가 필요하다는 조건이 있다. ChebNets의 경우 체비쇼프 다항식<sup> Chebyshev polynomials</sup>을 이용하며 LapGCN때 처럼 $T_k(\Delta)h$를 다음과 같이 정의되는 재귀함수 $X_k$로 표현한다:

$$
X_k=2\tilde{\Delta} X_{k-1} - X_{k-2}, X_0=h, X_1=\tilde{\Delta}h  \text{ and } \tilde{\Delta} = 2\lambda_n^{-1}\Delta - \boldsymbol{I}
$$

<!--
Now we have stability under coefficient perturbation.

ChebNets are GCNs that can be used for any arbitrary graph domain, but the limitation is that they are isotropic. Standard ConvNets produce *anisotropic* filters because Euclidean grids have direction, while Spectral GCNs compute *isotropic* filters since graphs have no notion of direction (up, down, left, right).
-->

이제 계수 섭동<sup>coefficient perturbation</sup>에서의 안정성을 확보하였다.

ChebNets는 어떠한 임의의 그래프 정의역에도 사용이 가능한 GCNs이지만, ChebNets은 등방성<sup>isotropic</sup>이라는 단점이 존재한다.  일반적인 합성곱 신경망은 유클리드 그리드<sup>Euclidean grids</sup>가 방향성을 가지기에 *이방성* <sup>anisotropic</sup> 필터를 생산해 내지만 스펙트럼 GCNs는 그래프가 방향(상하, 좌우)의 개념이 존재하지 않아 등방성 필터를 계산해 낸다. 

<!--
We can extend ChebNets to multiple graphs using a 2D spectral filter. This may be useful, for example, in recommender systems where we have movie graphs and user graphs. Multi-graph ChebNets have the activation equation as below.

$$
h^{l+1}=\eta(\hat{w}(\Delta_1,\Delta_2)*h^l)
$$
-->

이제 2D 스펙트럼 필터를 이용해 ChebNets을 다중 그래프에 적용이 가능하다. 이는, 한 예로, 영화 그래프와 관객 그래프를 이용한 추천 시스템에는 유용할 수 있다. 다중 그래프 ChebNets는 다음과 같은 활성화 함수를 갖는다:

$$
h^{l+1}=\eta(\hat{w}(\Delta_1,\Delta_2)*h^l)
$$

<!--
### CayleyNets

ChebNets are unstable to produce filters (localize) with frequency bands of interest (graph communities). In CayleyNets, we instead use as our orthonormal basis Cayley rationals.

$$
\hat{w}(\Delta)=w_0+2\Re\left\{\sum^{K-1}_{k=0}w_k\frac{(z\Delta-i)^k}{(z\Delta+i)^k}\right\}
$$
-->

### CayleyNets

ChebNets은 관심 주파대<sup>frequency bands of interest</sup> (그래프 군집<sup>graph communities</sup>)로 필터를 제공(국소화<sup>localize</sup>)하기에는 불안정하다. CayleyNets에서는 대신에 정규 직교 기저를 케일리 유리수<sup>Cayley rationals</sup>로 사용한다. 

$$
\hat{w}(\Delta)=w_0+2\Re\left\{\sum^{K-1}_{k=0}w_k\frac{(z\Delta-i)^k}{(z\Delta+i)^k}\right\}
$$

<!--
CayleyNets have the same properties as ChebNets (are isotropic), but they are localized in frequency (with spectral zoom) and provide a richer class of filters (for the same order $K$).
-->

CayleyNets은 ChebNets과 (둘 다 등방성이라는) 같은 성질들을 갖지만 , CayleyNets은 주파수<sup>frequency</sup>에 위치하며, 좀 더 높은 단계의 필터를 제공한다. 

<!--
## [Spatial Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=3964s)


### Template Matching

To understand Spatial Graph ConvNets, we go back to the Template Matching definition of ConvNets.
-->

## [공간 그래프 합성곱 신경망 Spatial Graph ConvNets](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=3964s)

### 템플릿 매칭

공간 그래프 합성망을 이해하기 위해서는, 합성곱 신경망의 템플릿 매칭의 정의를 되짚어야 한다. 

<!--
The main issue when we perform Template Matching for graphs is the lack of node ordering or positioning for the template. All we have are the indices of nodes, which isn't enough to match information between them. How do we design template matching to be invariant to node re-parametrisation? That is, if we have a graph and one of the nodes had an arbitrary index, say 6, this index could've been 122 as well. So it's essential to be able to perform template matching independent to the index of the node.
-->

그래프에 템플릿 매칭을 할 때 가장 큰 문제점은 템플릿에 꼭짓점의 순서나 위치가 명확하지 않다는 점이며, 가진거라곤 정보를 매칭하기에 부족한 꼭짓점의 인색<sup>indices</sup>뿐이다. 어떻게 구성해야 템플릿 매칭이 꼭짓점 재매개화<sup>reparametrisation</sup>에 불변할 수 있을까? 다시 말해, 만약 그래프의 꼭짓점 하나가 임의의 인색 6을 가지고 있다고 한다면, 이 인색은 122 또한 될 수 있다. 그러므로 꼭짓점들의 인색에 독립된 템플릿 매칭을 할 수 있어야한다.  

<!--
The simplest way to do this is by having only one template vector $w^l$, instead of having $w_{j1}$,$w_{j2}$, $w_{j3}$ or so on. So we match this vector $w^l$ with all other features on our graph. Most Graph Neural Networks today use this property.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure2.png" /><br>
<b>Figure 2:</b> Template Matching using a template vector
</center>
-->


가장 간단한 방법은 템플릿 벡터를 $w_{j1}$,$w_{j2}$, $w_{j3}$, 등등의 여러개 말고 $w^l$로 딱 하나만 갖는 것이다.  그래서 벡터 $w^l$를 그래프의 다른 특징<sup>features</sup>들과 매칭하는 것이며 오늘 날 그래프 신경망들은 이러한 성질을 이용한다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure2.png" /><br>
<b>Figure 2:</b> Template Matching using a template vector
</center>

<!--
Mathematically, for one feature we have,

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \langle w^l,h_{ij}^l \rangle \bigg)$$

where, $w^l$ is the template vector at layer $l$ of dimensions $d \times 1$ and $h_{ij}^l$ is the vector at node j with $d \times 1$ which will result in a scalr quantity $h_{i}^{l+1}$ at node $i$.
-->

수학적으로  하나의 특징에 대하여,

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \langle w^l,h_{ij}^l \rangle \bigg)$$

$w^l$ 는 레이어 $l$에서의 $d \times 1$ 차원을 가진 템플릿 벡터이다. $h_{ij}^l$는 꼭짓점 $j$의 $d \times 1$ 차원을 가진 벡터이며,  꼭짓점 $i$에서의 스칼라 량<sup>scalr quantity</sup> $h_{i}^{l+1}$를 갖게한다.

<!--
for more($d$) features,

$$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \boldsymbol{W}^l,h_{ij}^l\bigg)$$

where, $\boldsymbol{W}^l$ is of the dimensionality $d \times d$ and $h_{i}^{l+1}$ is $d \times 1$
-->

더 많은 ($d$)특징들에 대해서는,
 
 $$h_{i}^{l+1}=\eta\bigg(\sum_{j \in N_{i}} \boldsymbol{W}^l,h_{ij}^l\bigg)$$
 
$\boldsymbol{W}^l$는 $d \times d$ 차원수를 가지며, $h_{i}^{l+1}$의 차원수는 $d \times 1$이다.

<!--
for a vectoral representation,

$$h^{l+1}=\eta(\boldsymbol{A} h^l \boldsymbol{W}^l)$$

where, $\boldsymbol{A}$ is the adjacency matrix of dimensions $n \times n$, $h^l$ is the activation function at the layer $l$ with dimensions $n \times d$.

Based on this definition of Template Matching we can define two types of Spatial GSNs -- Isotropic GCNs and Anisotropic GCNs.
-->

벡터적 표현으로는,

$$h^{l+1}=\eta(\boldsymbol{A} h^l \boldsymbol{W}^l)$$

$\boldsymbol{A}$는 $n \times n$ 차원을 가진 인접행렬<sup>adjacency matrix</sup>이고, $h^l$은 레이어 $I$에 $n \times d$ 차원을 가진 활성화 함수이다. 

<!--
## Isotropic GCNs


### Vanilla Spatial GCNs

It has the same definition as before, but we add the Diagonal matrix in the equation, in such a way that we find the mean value of the neighbourhood.
-->

## 등방성 GCNs <sup>Isotropic GCNs</sup>


### 기본적인 공간 <sup>GCNs Vanilla Spatial GCNs</sup>

전에 사용된 정의와는 같지만, 이웃점들의 평균값<sup>mean value</sup>들을 찾는것 과 같은 방식으로 대각행렬<sup>Diagonal matrix</sup>을 공식에 추가하였다.

<!--
Matrix representation being,

$$h^{l+1} = \eta(\boldsymbol{D}^{-1}\boldsymbol{A}h^{l}\boldsymbol{W}^{l})$$

where, \boldsymbol{A} has the dimensions $n \times n$, $h^{l}$ has dimensions $n \times d$ and $W^{l}$ has $d \times d$, which results in a $n \times d$ $h^{l+1}$ matrix.
-->

행렬 표현으로는,

$$h^{l+1} = \eta(\boldsymbol{D}^{-1}\boldsymbol{A}h^{l}\boldsymbol{W}^{l})$$

$\boldsymbol{A}$ 는 $n \times n$ 차원을 가지고, $h^{l}$는 $n \times d$ 차원을, 그리고 $W^{l}$은 $d \times d$ 차원을 가지고 $n \times d$차원의 $h^{l+1}$를 가진다. 

<!--
And the vectorial representation being,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{A}_{ij}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

where, $h_{i}^{l+1}$ has the dimensions of $d \times 1$
-->

그리고 벡터적 표현으로는,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{A}_{ij}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

$h_{i}^{l+1}$는 $d \times 1$차원을 갖는다. 

<!--
The vectorial representation is responsible for handling the absence of node ordering, which is invariant of node re-parametrisation. That is, adding on the previous example, if the node has an in 6 and is changed to 122, this won't change anything in the computation of the activation function of the next layer $h^{l+1}$.

We can also deal with neighbourhood of different sizes. That is we can have a neighbourhood of 4 nodes or 10 nodes, it wouldn't change anything.
-->

벡터적 표현은 꼭짓점 재매개화에 불변<sup>invariant</sup>하며 꼭짓점 순서의 부재를 처리한다. 저번 예제에 추가로 설명을 더하자면, 만약 꼭짓점의 번호가 6에서 122로 바뀌어도 다음 레이어 $h^{l+1}$의 활성화 함수 계산에 전혀 지장이 없다는 것이다.

이로인해 이웃점들 끼리의 서로 다른 크기 문제들도 해결할 수 있으며, 다시 말해 이는 인근점들이 4개 든 10개든 계산이 달라지지 않는다는 것이다. 

<!--
We are given the local reception field by design, that is, with Graph Neural Networks we only have to consider the neighbours.

We have weight sharing, that is, we the same $\boldsymbol{W}^{l}$ matrix for all features no matter the position of the graph, which is a Convolution property.
-->

국부 수용영역<sup>local reception field</sup>은 디자인에 의해 주어지며, 즉 이는 그래프 신경망에서는 이웃점들만 고려하면 된다는 것이다. 

우린 가중치 공유<sup>weight sharing</sup>를 사용할 수 있고, 이는 합성곱의 성질인 모든 특징에 그래프의 위치에 상관없이 같은 $\boldsymbol{W}^{l}$행렬을 갖는다는 뜻이다. 


<!--
This formulation is also independent of the graph size, since all operations are done locally.

Since it is an isotropic model, the neighbours will have the same $\boldsymbol{W}^{l}$ matrix.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<b>Figure 3:</b> Isotropic model
</center>
-->

이 공식은 모든 작업이 로컬로 이루어지기 때문에 그래프 사이즈에도 독립되어 있다.

이는 등방성 모델이라 인근점들 또한 $\boldsymbol{W}^{l}$ 행렬을 갖는다. 

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure4.png" /><br>
<b>Figure 3:</b> Isotropic model
</center>


<!--
$$h_{i}^{l+1} = f_\text{GCN}(h_{i}^{l}, \{h_{j}^l: j \rightarrow i\})$$

So, the activation of the next layer $h_{i}^{l+1}$ is a function of the activation of the previous layer $h_{i}^{l}$ at node $i$ and the neighbourhood of $i$. When we change the function, we get an entire family of graphs.
-->

$$h_{i}^{l+1} = f_\text{GCN}(h_{i}^{l}, \{h_{j}^l: j \rightarrow i\})$$

그래서 다음 레이어 $h_{i}^{l+1}$ 의 활성화 함수는 꼭짓점 $i$와 $i$의 인근점들의 전 레이어 $h_{i}^{l}$의 활성화 함수이다.

<!--
### ChebNets and Vanilla Spatial GCNs

The above defined Vanilla Spatial GCN is a simplification of ChebNets. We can truncate the expansion of ChebNet by using the first two Chebyshev functions to end up with,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{\hat{d_{i}}}\sum_{j \in N_{i}}\hat{\boldsymbol{A}_{ij}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$
-->

### ChebNets와 기본 공간 GCNs

위와 같이 정의된 기본 공간 GCN은 ChebNets의 단순화된 버전이다. 처음 두 체비쇼프 함수를 이용해 ChebNets의 확장<sup>expansion</sup>을 줄일 수 있으며 다음과 같은 모습을 띄게 된다,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{\hat{d_{i}}}\sum_{j \in N_{i}}\hat{\boldsymbol{A}_{ij}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$

<!--
### GraphSage

If the Adjacency matrix $\boldsymbol{A}_{ij} = 1$ for the edges in Vanilla Spatial GCNs, we get,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$
-->

### GraphSAGE (SAmple aggreGatE)

만약 기본 공간 GCN에서의 간선<sup>edges</sup>들이 각 인접행렬 $\boldsymbol{A}_{ij} = 1$의 형태로 주어진다면, 아래와 같은 수식을 얻게된다,

$$h_{i}^{l+1} = \eta\bigg(\frac{1}{d_{i}}\sum_{j \in N_{i}}\boldsymbol{W}^{l}h_{j}^{l}\bigg)$$


<!--
For this equation, we give the central/core vertex $i$ and it's neighbourhood the same template weight $\boldsymbol{W}^{l}$. We can differentiate this by giving the central node $\boldsymbol{W}\_{1}^{l}$, and having a different template node $\boldsymbol{W}_{2}^{l}$ for the one-hot neighbourhood. This will improve the performance of the GNNs by a substantial amount. This model is still considered to be Isotropic in nature, since the neighbours have the same weight.
-->

이 공식에는 중심/핵심 정점<sup> central/core vertex</sup> $i$와 $i$의 인근점들에게 같은 템플릿 가중치 $\boldsymbol{W}^{l}$를 부여한다. 이는 중심 정점을$\boldsymbol{W}_{1}^{l}$로 하고,  원-핫<sup>one-hot</sup> 인근점에는 $\boldsymbol{W}_{2}^{l}$의 다른 템플릿 꼭짓점을 부여함으로 둘을 구분지을 수 있다. 위와 같은 작업은 GNN의 성능을 상당히 향상시키며 인근점들이 모두 같은 가중치를 가졌기에 이 모델은 사실상 등방성 모델로 간주된다.

<!--
$$h_{i}^{l+1} = \eta\bigg(\boldsymbol{W}_{1}^{l} h_{i}^{l} + \frac{1}{d_{i}} \sum_{j \in N_{i}} \boldsymbol{W}_{2}^{l} h_{j}^{l}\bigg)$$

where, $\boldsymbol{W}\_{1}^{l}$ and $\boldsymbol{W}\_{2}^{l}$ are of dimension $d \times d$; $h_{i}^{l}$ and $h_{j}^{l}$ are of the dimension $d \times 1$.
-->

$$h_{i}^{l+1} = \eta\bigg(\boldsymbol{W}_{1}^{l} h_{i}^{l} + \frac{1}{d_{i}} \sum_{j \in N_{i}} \boldsymbol{W}_{2}^{l} h_{j}^{l}\bigg)$$

$\boldsymbol{W}_{1}^{l}$ 과 $\boldsymbol{W}_{2}^{l}$는  $d \times d$ 차원을 갖는다; $h_{i}^{l}$과 $h_{j}^{l}$는 $d \times 1$ 차원을 갖는다. 

<!--
In this equation, we can find the summation or maximum of $\boldsymbol{W}\_{2}^{l} h_{j}^{l}$ or the Long-Short Term Memory of $h_{j}^{l}$, instead of the mean.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<b>Figure 4:</b> GraphSage
</center>
-->

이 방정식에서는, 평균값이 아닌 $\boldsymbol{W}_{2}^{l} h_{j}^{l}$의  합계<sup>summation</sup> 또는 최댓값<sup>maximum</sup>이나, $h_{j}^{l}$의 LSTM을 찾아 볼 수 있다. 

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure3.png" /><br>
<b>Figure 4:</b> GraphSAGE
</center>


<!--
### Graph Isomorphism Networks (GIN)

An architecture that can differentiate graphs that are not isomorphic. *Isomorphism* is the measure of equivalence between graphs. In the figure below, the two graphs are considered isomorphic to each other. Isomorphic graphs will be treated in a similar way and non-isomorphic graphs will be treated differently.
-->

### 그래프 동형 사상 네트워크<sup>Graph Isomorphism Networks (GIN)</sup>

동형<sup>isomorphic</sup>이 아닌 그래프를 구분할 수 있는 구조. *동형 사상* <sup>Isomorphism</sup>은 그래프간 닮음에 대한 척도이다. 아래의 그림에서 보여지는 것 처럼, 두 그래프는 서로 동형이다. 동형 그래프는 서로 비슷하게 취급되며, 비동형<sup>non-isomorphic</sup> 그래프들은 서로 다르게 취급된다. 

<!--
GIN is an isotropic GCN.

$$h_{i}^{l+1} = \texttt{ReLU}(\boldsymbol{W}_{2}^{l}\space \texttt{ReLU}(\texttt{BN}(\boldsymbol{W}_{1}^{l} \hat(h_{j}^{l+1})))$$

where, $\texttt{BN}$ stands for Batch Normalization.

$$h_{i}^{l+1} = (1 + \epsilon)h_{i}^{l} + \sum_{j \in N_{i}} h_{j}^{l}$$

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<b>Figure 5:</b> Examples of two isomorphic graphs
</center>
-->
GIN은 동형 GCN이다.

$$h_{i}^{l+1} = \texttt{ReLU}(\boldsymbol{W}_{2}^{l}\space \texttt{ReLU}(\texttt{BN}(\boldsymbol{W}_{1}^{l} \hat(h_{j}^{l+1})))$$

여기서 $\texttt{BN}$은 배치정규화<sup>Batch Normalization</sup>를 뜻한다. 

$$h_{i}^{l+1} = (1 + \epsilon)h_{i}^{l} + \sum_{j \in N_{i}} h_{j}^{l}$$

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure5.png" /><br>
<b>Figure 5:</b> 두 동형 사상 그래프의 예제
</center>


<!--
## [Anisotropic GCNs](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=5586s)

Standard CNNs have the ability to produce anisotropic filters — ones that favour certain directions. This is because the directional structure is based on up, down, left, and right. However, the GCNs described above have no notion of direction, and thus can only produce isotropic filters. Anisotropy can be introduced naturally, with edge features. For instance, molecules can have single, double, and triple bonds. Graphically, it is introduced weighting different neighbours differently.
-->

## [비등방성 GCNs <sup>Anisotropic GCNs</sup>](https://www.youtube.com/watch?v=Iiv9R6BjxHM&list=PLLHTzKZzVU9eaEyErdV26ikyolxOsz6mq&index=24&t=5586s)

방향성 구조는 상하좌우 방향에 기초를 두기 때문에 기본적인 CNN은 (특정 방향을 향하는) 비등방성 필터를 만들 수 있다. 하지만 위에서 언급했듯이, GCNs에는 방향의 개념이 없기에 등방성 필터만 만들 수 있다. 비등방성은 간단히 간선 특징으로 설명이 가능한데, 분자<sup>molecule</sup>가 단일<sup>single</sup>, 이중<sup>double</sup> 또는 삼중 결합<sup>triple bond</sup>이 될 수 있는 것을 예로 들 수 있다. 그래프에서는 이를 각 이웃점들의 가중치를 다르게 함으로 구현이 가능하다.

<!--
### MoNets

MoNets use the degree of the graph to learn the parameters of a Gaussian Mixture Model (GMM).

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<b>Figure 6:</b> MoNet
</center>
-->

### MoNets

MoNets은 그래프의 차수<sup>degree</sup>를 이용해 가우시안 혼합 모델<sup>Gaussian Mixture Model (GMM)</sup>의 매개변수를 학습한다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure6.png" /><br>
<b>Figure 6:</b> MoNet
</center>

<!--
### Graph Attention Networks (GAT)

GAT uses the attention mechanism to introduce anisotropy in the neighbourhood aggregation function.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<b>Figure 7:</b> GAT
</center>
-->

### 그래프 어텐션 네트워크 Graph Attention Networks (GAT)

GAT는 어텐션 메커니즘을 사용해 이웃 집계 함수<sup>neighbourhood aggregation function</sup>의 비등성을 소개한다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure7.png" /><br>
<b>Figure 7:</b> GAT
</center>

<!--
### Gated Graph ConvNets

These use a simple edge gating mechanism, which can be seen as a softer attention process as the sparse attention mechanism used in GATs.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<b>Figure 8:</b> Gated Graph ConvNet
</center>
-->

### Gated Graph ConvNets

Gated Graph ConvNets는 GAT에서 사용된 희소 어텐션 메커니즘<sup>sparse attention mechanis</sup> 처럼 소프트 어텐션 과정<sup>softer attention process</sup>으로 보여질 수 있는 간단한 간선 게이트 메커니즘<sup>simple edge gating mechanism</sup>을 이용한다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure8.png" /><br>
<b>Figure 8:</b> Gated Graph ConvNet
</center>

<!--
### Graph Transformers

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<b>Figure 9:</b> Graph Transformer
</center>

This is the graph version of the standard transformer, commonly used in NLP. If the graph is fully connected (every two nodes share an edge), we recover the definition of a standard transformer.
-->

### 그래프 트랜스포머 Graph Transformers

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure9.png" /><br>
<b>Figure 9:</b> Graph Transformer
</center>

그래프 트랜스포머는 NLP에서 널리 쓰이는 기본적인 트랜스포머의 그래프 버전이다. 만약 그래프가 완전히 연결<sup>fully connected</sup>되있다면 (모든 꼭지점이 서로 연결되있는 것), 기본 트랜스포머의 정의를 다시 사용할 수 있다.

<!--
Graphs obtain their structure from sparsity, so the fully connected graph has trivial structure and is essentially a set. Transformers then can be viewed as **Set** Neural Networks, and are in fact the best technique currently to analyse sets/bags of features.
-->

그래프는 희소성으로부터 구조를 얻기에 완전 연결 그래프는 잠여한<sup>trivial</sup> 구조를 가지고 본질적으로는 집합<sup>set</sup>이다. 트랜스포머는 *집합* 신경망으로 볼 수 있고, 실제로 특징들의 집합/묶음<sup>sets/bags</sup>을 분석하는데 최고의 기법이다. 

<!--
## Benchmarking GNNs

Benchmarks are an essential part of progress in any field. The recently released benchmark [Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/) has six medium-scale datasets that can be used for four fundamental graph problems - graph classification, graph regression, node classification and edge classification. Though these datasets are mediumly sized, they are enough to statiscally separate trends in various GNNs.
-->

## GNNs 벤치마킹<sup>benchmarking</sup>

벤치마킹은 어느 분야에서든 매우 중요한 과정이다. 최근 출시된 벤치마크 [Benchmarking Graph Neural Networks](https://arxiv.org/pdf/2003.00982.pdf/) 는 4개의 핵심 그래프 문제- 그래프 분류<sup>classification</sup>, 그래프 회귀<sup>regression</sup>, 꼭짓점 분류, 간선 분류 - 를 풀기 위한 6개의 중간 규모 데이터셋을 제공한다. 데이터들의 규모가 중간 정도이지만, 여러 GNN의 통계적으로 다른 트렌드들을 분석하기에는 충분하다. 

<!--
As an example of a **Graph Regression task**, we would want to predict the molecular solubility.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<b>Figure 10:</b> Graph Regression task - Quantum Chemistry
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>Figure 11:</b> Performance of various GCNs on the regression task
</center>
-->

**그래프 회귀 작업**의 한 예로, 분자의 용해도<sup>molecular solubility</sup>를 예측을 들 수 있다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure10.png" /><br>
<b>Figure 10:</b> 그래프 회귀 작업 - 양자화학
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure11.png" /><br>
<b>Figure 11:</b> 여러 GCN들의 회귀 작업 성과
</center>

<!--
We notice that in most cases anisotropic GCNs perform better compared to isotropic GCNs because we use directional properties.

For a **Graph Classification task**, a Computer Vision problem was chosen where we have super nodes of images and we want to classify the image.
--> 

비등방성 GCN은 방향성 특성을 사용하기에 대부분의 경우 비등방성 GCN이 등방성 GCN 보다 더 나은 결과를 가지는 것을 확인할 수 있다.

**그래프 분류 작업**의 경우, 컴퓨터 비전 문제는 사진의 슈퍼노드<sup>super nodes</sup>의 위치와 사진에 어떤 것을 분류하고 싶은지에 따라 선별된다.

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>Figure 12:</b> Graph Classification task
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>Figure 13:</b> Performance of various GCNs on Graph Classification task
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure12.png" /><br>
<b>Figure 12:</b> 그래프 분류 작업
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure13.png" /><br>
<b>Figure 13:</b> 여러 GCN들의 분류 작업 성과
</center>

<!--
For an **Edge Classification task**, we have considered the Combinatorial Optimization problem of the Travelling Salesman Problem (TSP) - where we want to know if a particular edge belongs to the optimal solution. If it belongs to the solution it falls in class 1, else class 0. Here we need explicit edge features, and the only model that does a good job of this is GatedGCN.
-->

**간선 분류 작업**의 경우, 외판원 문제<sup> Travelling Salesman Problem TSP</sup>의 조합 최적화<sup>Combinatorial Optimization</sup> 문제를 다룬다 - 특정 간선이 최적의 해답에 있는지 확인한다. 만약 간선이 해답에 위치한다면 class 1에, 나머지는 class 0이 된다. 명확한 간선 특징이 필요하며 이러한 작업을 잘 다루는 단 하나의 모델은 GatedGCN이다. 

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<b>Figure 14:</b> Edge Classification task.
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<b>Figure 15:</b> Performance of various GCNs on Edge Classification task
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure14.png" /><br>
<b>Figure 14:</b> 간선 분류 작업 
</center>

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure15.png" /><br>
<b>Figure 15:</b> 여러 GCN의 간선 분류 작업의 성과
</center>

<!--
We can use GCNs for self-supervised tasks as well, they are not limited to supervised learning models. According to Dr. Yann LeCun, almost all self-supervised learning tasks exploit some sort of graph structure. When we do a self-supervised learning task in text, where we take a sequence of words and we learn to predict missing words or new sentences. There is a graphs structure here, which is how many times a word appears some distance away from another word. Text would be a linear graph, and the neighbours chosen would be used to train a Transformer. In the case of contrastive training, where we have two samples that are similar, and two which are dissimilar - it is essentially a similarity graph, where two samples are linked when they are similar and if they are not linked they are considere dissimilar.
-->
GCN은 지도 학습 모델<sup>supervised</sup>에만 국한되지 않고 자가 지도 작업<sup>self-supervised</sup>에 또한 사용이 가능하다. 얀 르쿤 박사에 따르면, 거의 모든 자가 지도 학습 작업은 그래프 구조를 띄고있다고 한다. 단어 시퀀스<sup>sequence of words</sup>를 가지고 빠진 단어나 새로운 문장을 만드는 예측 모델을 만드는 텍스트에서의 자가 지도 학습 작업을 할 때에도 다른 단어와의 일정 거리에서 특정 단어의 빈도와 같은 그래프 구조가 존재한다. 텍스트는 선형 그래프이며 선택된 이웃들은 트랜스포머를 학습하는데 사용될 것이다. 대조학습<sup>contrastive training</sup>의 경우, 두 점은 비슷하다면 연결되고 같지 않다면 연결이 되지 않는 유사도 그래프<sup>similarity graph</sup>이다. 

<!--
## Conclusion

GCNs generalize CNNs to data on graphs. The convolution operator needed to be redesigned on graphs. Doing this for template matching gave rise to Spatial GCNs, and for spectral convolution lead to Spectral GCNs.

There is linear complexity for sparse graphs, and GPU implementation, although the latter is not yet optimized for sparse matrix multiplication. The applications are abound as shown below.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<b>Figure 16:</b> Applications
</center>
-->

## 결론 

GCN은 CNN을 그래프의 데이터로 일반화<sup>generalize</sup>하고,  합성곱 연산은 그래프에 맞춰 재정립되어야한다. 템플릿 매칭을 위한 이 방식은 공간 GCN을 소개하며, 스펙트럼 합성곱은 스펙트럼 GCN으로 이어진다.

희소 그래프는 복잡도도 선형이고 GPU에도 사용이 가능하지만, GPU에는 아직 희소 행렬 곱셈이 아직 최적화가 이루어지지 않았다. GCN는 아래처럼 다양한 방면에서 응용되어진다.

<center>
<img src="{{site.baseurl}}/images/week13/13-2/Figure16.png" /><br>
<b>Figure 16:</b> 응용
</center>
