---
lang-ref: ch.13-1
lang: ko
title: 그래프 합성곱 신경망 I
lecturer: Xavier Bresson
authors: Bilal Munawar, Alexander Bienstock, Can Cui, Shaoling Chen
date: 27 Apr 2020
translation-date: Aug 16 2020
translator: Seok Hoan (Kevin) Choi

---

<!--
## Traditional ConvNets

ConvNets are powerful architectures to solve high-dimensional learning problems.
-->

## 전통적인 합성곱 신경망<sup>Traditional ConvNets</sup>

합성곱 신경망은 고차원 학습 문제에 매우 효과적인 구조이다.  


<!--
### What is the Curse of Dimensionality?

Consider an image of 1024 x 1024 pixels. This image can be seen as a point in the space for 1,000,000 dimensions. Using 10 samples per dimension generates ${10}^{1,000,000}$ images, which is extremely high. ConvNets are extremely powerful to extract best representation of high-dimensional image data, such as the one given in the example.

- dim(image) = **1024 x 1024** = ${10}^{6}$
- For **N = 10** samples/dim -> **${10}^{1,000,000}$ points**
-->

### 차원의 저주란? 

1024 x 1024 픽셀을 가진 이미지는 1,000,000 차원 공간의 한 점으로 생각될 수 있다. 차원별로 10개의 샘플들을 사용한다면 ${10}^{1,000,000}$ 라는 엄청난 수의 이미지들을 생성한다. 합성곱 신경망은 다음 예제에서 보여지는 것과 같이 고차원 이미지 데이터 최적의 표현을 추출하는 데 매우 효과적이다. 

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Fig. 1</b>: ConvNets extract representation of high-dimensional image data.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/ConvNets.png" height="100%" width="100%"/><br>
<b>Fig. 1</b>: 합성곱 신경망은 고차원 이미지 데이터에서 표현을 추출한다.
</center>

<!--
### Main assumptions about ConvNets:

 **1. Data (images, videos, speech) is compositional.**

It is formed of patterns that are:
-->

### 합성곱 신경망의 주요 가정:

**1. 데이터(이미지, 비디오, 음성)는 구성적<sup>compositional</sup>이다.**

데이터는 다음과 같은 패턴들을 가진다:

<!--
* **Local**  A neuron in the neural network is only connected to the adjacent layers, but not to all layers in the network. We call this the local reception field assumption.
* **Stationary**  We have some patterns that are similar and are shared across our image domain. For example, the yellow bedsheet in the middle image of figure 2.
* **Hierarchical**  Low level features will be combined to form medium level features. Subsequently, these medium level features will combined to progressively form higher and higher level features. For example, a visual representation.
-->
* **집약적<sup>Local</sup>** 신경망에서의 뉴런은 신경망 전체의 계층이 아닌 오직 인접한 계층들하고만 연결되어있다. 이를 집약적 수용영역 가정<sup>local reception field assumption</sup>이라고 부른다. 
* **정상적<sup>Stationary</sup>** 비슷한 패턴들을 가지며 이미지 영역<sup>image domain</sup>에 걸쳐 공유한다. 예로 figure 2에서의 중간 이미지의 노란 침대 시트를 들 수 있다.
* **계층적<sup>Hierarchical</sup>** 저레벨 특징<sup>feature</sup>들은 모여서 중간레벨 특징을 이루고, 이 중간레벨 특징들이 계속해서 모여 더욱더 높은 레벨의 특징들을 이룬다. 예로 시각표현을 들 수 있다. 
<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Fig. 2</b>: Data is compositional.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Pattern.png" height="100%" width="100%"/><br>
<b>Fig. 2</b>: 데이터는 구성적이다.
</center>

<!--
**2. ConvNets leverage the compositionality structure.**

They extract compositional features and feed them to classifier, recommender, etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Fig. 3</b>: ConvNets leverage the compositionality structure.
</center>
-->

**2. 합성곱은 구성적 구조를 활용한다.**

합성곱은 합성적 특징들을 추출하여 분류기<sup>classifier</sup>나 추천기<sup>recommender</sup> 등에  피드<sup>feed</sup>한다. 

<center>
<img src="{{site.baseurl}}/images/week13/13-1/compositionality.png" height="75%" width="100%"/><br>
<b>Fig. 3</b>: 합성곱은 합성성 구조에 영향을 끼친다. 
</center>

<!--
## Graph Domain

### Data Domain

* Images, volumes, videos lie on 2D, 3D, 2D+1 Euclidean domains (grids). Each pixel is represented by a vector of red, green, and blue values.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Fig. 4</b>: Images have multiple dimensions.
</center>
-->
## 그래프 정의역 <sup>Domain</sup>

### 데이터 정의역

* 이미지, 부피, 비디오는 각각 2D, 3D, 2D + 1 유클리드 정의역<sup>Euclidean domains</sup>에 펼쳐져 있으며, 각 픽셀은 빨강, 초록, 파랑값의 벡터에 의해 표현된다. 
* 
<center>
<img src="{{site.baseurl}}/images/week13/13-1/Image.png" height="80%" width="80%"/><br>
<b>Fig. 4</b>: 이미지는 복수의 차원을 가진다. 
</center>

<!--
* Sentences, words, speech lie on 1D Euclidean domain. For example, each character can be represented by an integer.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>Fig. 5</b>: Sequences have single dimension.
  </center>
-->

* 문장, 단어, 음성은 1D 유클리드 정의역에 놓여있다. 예로, 각 글자는 하나의 정수로 표현되어진다. 

<center>
  <img src="{{site.baseurl}}/images/week13/13-1/Sequence.png" height="80%" width="80%"/><br>
  <b>Fig. 5</b>: 순차<sup>Sequences</sup>는 하나의 차원을 가진다.
  </center>

<!--
* These domains have strong regular spatial structures, which allows all ConvNets operations to be fast and mathematically well defined.

  <center>
  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>Fig. 6</b>: Speech data has 1D grid.
  </center>
-->

* 이러한 정의역들은 강력한 정칙 공간적 구조<sup>strong regular spatial structures</sup>들을 가짐으로 합성곱 연산작업을 빠르고 수학적으로 잘 정의되게 한다. 

  <img src="{{site.baseurl}}/images/week13/13-1/Speech.png" height="80%" width="80%"/><br>
  <b>Fig. 6</b>: 음성 데이터는 1차원의 그리드를 갖는다.
  </center>
  
<!--
### Graph Domain

#### Motivational Examples of graph domains

Let's consider a social network. The social network is best captured by a graph representation since pair-wise connection between two users do not form a grid. Nodes of the graph represents users, whereas the edges between two nodes represent connection between two nodes (users). Each user has a three-dimensional feature matrix containing such as messages, images, and videos.
-->

### 그래프 정의역

#### 그래프 정의역의 예제

소셜 네트워크로 예를 들어보자. 소셜 네트워크는 두 유저 상호 간의 연결이 그리드를 형성하지 않기에 그래프 표현으로는 최적의 대상이다. 그래프의 꼭짓점<sup>Nodes </sup>들은 각 유저를 나타내고, 연결된 간선<sup>edges </sup>들은 유저들 간의 연결을 나타낸다. 각 유저는 메세지, 이미지, 비디오 등을 포함한 3차원 변수 행렬<sup>feature matrix</sup>을 갖는다.


<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Fig. 7</b>: Social networks by graph representation.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/socialnetworks.png" height="70%" width="80%"/><br>
<b>Fig. 7</b>: 그래프로 표현된 소셜 네트워크
.
</center>

<!--
The connection between the structure and function of the brain to predict neural genetic diseases offers a motivational example to consider. As can be seen below, the brain is composed of several Region of Interest(s) (ROI). These ROIs is only locally connected to some surrounding regions of interests. Adjacency matrix represents the degree of strengths between different regions of interest.
-->

신경유전병<sup>neural genetic diseases</sup> 예측하기 위한 뇌의 구조와 역활 연결을 한 예로 들 수 있다. 아래 보기와 같이, 뇌는 여러 개의 관심 영역<sup>Region of Interest(s) (ROI)</sup>으로 이루어져 있는데, 이러한 관심 영역들은 자신과 인접한 관심 영역들하고만 국부적으로 연결되어있으며, 인집행렬<sup>Adjacency matrix</sup>은 각기 다른 관심 영역과의 연결 강도<sup>degree of strength</sup>를 나타낸다.

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Fig. 8</b>: Brain connectivity by graph representation.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/brainconnectivity.png" height="80%" width="80%"/><br>
<b>Fig. 8</b>: 두뇌 연결의 그래프적 표현
</center>

<!--
Quantum Chemistry also offers an interesting representation of graphical domain. Each atom is represented by a node in graph and is connected to other atoms through bonds using edges. Each of these molecules/atoms have different features, such as the associated charge, bond type etc.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/quantumchemistry.png" height="80%" width="80%"/><br>
<b>Fig. 9</b>: Quantum chemistry by graph representation.
</center>
-->

양자화학 또한 다른 흥미로운 그래프 정의역 표현을 보여준다. 각 원자는 그래프 내에서 꼭짓점으로 표현되며, 다른 원자들과 간선으로 연결된다. 각 분자와 원자들은 전하, 결합의 종류 등 서로 다른 변수들을 갖는다.

<!--
### Graph Definition and Characteristics

* Graph G is defined by:
    * **Vertices V**
    * **Edges E**
    * **Adjacency matrix A**


* Graph features:
    * **Node features: $h_{i}$, $h_{j}$** (atom type)
    * **Edge features: $e_{ij}$** (bond type)
    * **Graph features:** g (molecule energy)
-->

### 그래프 정의와 특징들

* 그래프 G는 다음과 같이 정의된다:
	* **꼭짓점 <sup>Vertices </sup>V**
	* **간선<sup>Edges </sup> E**
	* **인접행렬<sup>Adjacency matrix</sup> A**

* 그래프 변수:
	* **꼭짓점 변수:  $h_{i}$, $h_{j}$** (원자 종류)
	*  **간선 변수: $e_{ij}$** (결합 종류 bond type)
	*  **그래프 변수:** g (분자 에너지molecule energy)

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Fig. 10</b>: Graph.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/graph.png" height="50%" width="80%"/><br>
<b>Fig. 10</b>: 그래프
</center>

<!--
## Convolution of Traditional ConvNets

### Convolution

We abstractly define convolution as:

$$h^{\ell+l} = w^\ell * h^\ell,$$
where $h^{\ell+1}$ is $n_1\times n_2\times d$-dimensional, $w^\ell$ is $3\times 3\times d$-dimensional, and $h^\ell$ is $n_1\times n_2\times d$-dimensional.
-->

## 전통적 합성곱 신경망의 합성곱<sup>Convolution</sup>

### 합성곱

합성곱은 다음과 같이 추상적 정의된다:

$$h^{\ell+l} = w^\ell * h^\ell,$$
$h^{\ell+1}$는  $n_1\times n_2\times d$-차원을 갖고, $w^\ell$ 는 $3\times 3\times d$-차원을, 그리고 $h^\ell$ 는$n_1\times n_2\times d$-차원을 갖는다.

<!--
For example, $n_1$ and $n_2$ could be the number of pixels in the $x$ and $y$ directions of an image, respectively, and $d$ is the dimensionality of each pixel (e.g., 3 for a colored image).\\
So, $h^{\ell+1}$ is a feature at the $(\ell+1)$-th hidden layer obtained by applying the convolution $w^\ell$ to a feature at the $\ell$-th layer.\\
Usually the kernel is small to represent a local reception field -- $3\times 3$ in this case, or $5\times 5$, for example.\\
Note: we use padding to ensure the dimensions of $h^{\ell+1}$ are the same as those of $h^\ell$.\\
-->
예를 들어, $n_1$과 $n_2$가 이미지의 $x$와 $y$축 픽셀의 개수고,  $d$가 각 픽셀의 차원 수 라고 해보자  (예로 컬러사진은 3의 차원 수를 갖는다).
 
그렇다면, $h^{\ell+1}$은 $\ell$-번째 은닉망<sup></sup>에서의 변수에 합성곱을 적용함으로 얻어진 $(\ell+1)$번째 은닉망의 변수이다. 

<!--
For example, in this image, the kernel may be used to recognize lines.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Fig. 11</b>: Kernel can be used to recognize lines in images.
</center>
-->

밑에 이미지를 예로 들어, 커널은 이미지 속에 선들을 인식하는데 사용될 수 있다.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/linekernel.png" height="90%" width="80%"/><br>
<b>Fig. 11</b>: 커널은 이미지 속에 선들을 인식하는데 사용될 수 있다.
</center>

<!--
### How do we define convolution?

More exactly, convolution is defined as follows:

$$h_i^{\ell_1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$
-->

### 합성곱을 어떻게 정의하나? 

좀 더 깊게 설명하자면, 합성곱은 다음과 같이 정의된다: 


$$h_i^{\ell_1} = w^\ell * h_i^\ell$$

$$ = \sum_{j\in\Omega}\langle w_j^\ell, h_{i-j}^\ell\rangle$$

$$ = \sum_{j\in\mathcal{N}_i} \langle w_j^\ell, h_{ij}^\ell\rangle$$

$$=\sum_{j\in\mathcal{N}_i} \langle \Bigg[w_j^\ell\Bigg], \Bigg[h_{ij}\Bigg]\rangle$$

<!--
The above defines convolution as *template matching*.\\
We usually use $h_{i+j}$ instead of $h_{i-j}$, because the former is actually correlation, which is more like template matching.

However, it does not really matter if you use the first or second, because your kernel is just flipped, and this does not impact learning.
-->

위에서는 합성곱을 템플릿 매칭<sup>template matching</sup> (형판 대응)이라고 정의하고 있으며, $h_{i-j}$보단 $h_{i+j}$를 사용하는데, 그 이유는 후자가 바로 상관도<sup>correlation</sup>이기 때문에 템플릿 매칭에 좀 더 가깝기 때문이다. 

<!--
In the third line, we just write $h_{i+j}^\ell$ as $h_{ij}^\ell$.

The kernel is very small, so instead of summing over the whole image $\Omega$, as in the second line, we actually just sum over the neighborhood of cell $i$, $\mathcal{N}_i$, as denoted in the third line.

This makes it so that the complexity of convolution is $O(n)$, where $n$ is the number of pixels in the input image.
-->

세번째 줄에서는 $h_{i+j}^\ell$를  $h_{ij}^\ell$라고 간단히 표기한다. 

커널<sup>kernel</sup>은 매우 작다. 그래서 두 번째 줄처럼 전체 이미지 $\Omega$에 전부 다 합하는 것보다는 세 번째 줄에 보이는 바와 같이 셀 $i$의 인근 셀들 $\mathcal{N}_i$를 더할 것이다.  

위와 같은 작업은 합성곱의 복잡도<sup>complexity </sup>를 $O(n)$로 만드는게 가능하다. ($n$은 입력 이미지 픽셀의 수)

<!--
Convolution is exactly for each of the $n$ pixels, summing over inner products of vectors of dimension $d$ over $3\times 3$ grids.

The complexity is thus $n\cdot 3\cdot 3\cdot d$, which is $O(n)$; and moreover the computational can be done in parallel with GPUs at each of the $n$ pixels.
-->

합성곱은 각 $n$개의 픽셀의  $3\times 3$ 그리드에 걸친 $d$차원의 내적 합<sup>inner products</sup>과 같다. 

그래서 복잡도는 $n\cdot 3\cdot 3\cdot d$가 되고 ($O(n)$), GPU를 통해 각 $n$픽셀별로 병렬적<sup>parallel</sup> 계산이 가능하다. 

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Fig. 12</b>: Nodes are ordered in the same way.
</center>

If the graph you are convolving over is a grid, as in standard convolution over images in computer vision, then the nodes are ordered as in the above image.
Therefore, $j_3$ will always be in the top right corner of the pattern.
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/orderednodes.png" height="80%" width="80%"/><br>
<b>Fig. 12</b>: 점들은 모두 같은 방식으로 정렬된다.
</center>

컴퓨터 시각에서의 일반적인 이미지 합성곱처럼, 합성곱되어지는 그래프가 그리드라면, 각 점은 위의 이미지와 같은 방식으로 정렬된다. 그러므로 $j_3$은 항상 패턴의 우측 상단 코너에 위치한다. 

<!--
So for all nodes $i$ in the image below, such as $i$ and $i'$, the node ordering of the kernel is always the same.
For example, you always compare $j_3$ at the top right corner of the pattern with the top right corner of the image patch (what we convolve over for pixel $i$), as shown below.
Mathematically speaking:

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$
-->

그래서 아래 이미지에서의 모든 점 $i$에 대해, 커널의 점 배치순서는 항상 같다. 예를 들어,  아래와 같이 항상 패턴의 우측 상단 코너 $j_3$ 는 (픽셀 $i$에 합성곱이 적용되는) 이미지 패치의 우측 상단 코너와 비교해야 한다. 

수학적으로 표현하자면 다음과 같다: 
$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{ij_3}^\ell \Bigg]\rangle
$$

<!--
and

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

are always for the top right corner between the template and the image patches.
-->

와

$$
\langle\Bigg[w_{j_3}^\ell\Bigg], \Bigg[h_{i'j_3}^\ell \Bigg]\rangle
$$

는 항상 템플릿과 이미지 패치의 우측 상단 코너에 대한 것이다. 

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Fig. 13</b>: Image patches match the templates.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/templatesmatch.png" height="70%" width="80%"/><br>
<b>Fig. 13</b>: 템플릿에 맞춰지는 이미지 패치.
</center>

<!--
### Can we extend template matching for graphs?

We have a couple of issues:
1. First, in a graph, there is no ordering of the nodes.

So in the template shown below in the image, node $j_3$ has no specific position, but just an (arbitrary) index.
So, when we try to match against nodes $i$ and $i'$ in the graph below, we do not know if $j_3$ is matching against the same nodes in both convolutions.\\
This is because there is no notion of the *top right corner* of the graph.\\
-->

### 템플릿 매치를 그래프에도 적용할 수 있을까?

그렇기에는 여러 가지 문제점이 존재한다:

1. 첫째로, 그래프에는 점들의 순서라는 게 존재하지 않는다. 

아래 이미지에서 보이는 것과 같이, 점 $j_3$는 (임의적인) 색인<sup>index</sup>만 존재할 뿐, 특정된 장소에 위치하지 않는다. 그래서 점 $i$와 점 $i'$를 아래 그래프와 같이 매치하려 하여도 $j_3$가 두 합성곱에 같은 점과 비교하는지 확인 할 수 없는데, 이는 그래프에 *우측 상단 코너* 라는 개념이 존재하지 않기 때문이다. 
<!--
There is no notion of up, down, left right.\\
Thus, the template matchings actually have no meaning and we cannot use the definition of template matching directly, as above.
-->

상하좌우 방향의  개념이 존재하지 않기에 템플릿 매칭은 더는 의미가 없게 되고, 위 템플릿 매칭의 정의를 그대로 사용할 수 없다.

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Fig. 14</b>: No node ordering in a graph.
</center>
-->

<center>
<img src="{{site.baseurl}}/images/week13/13-1/nonodeordering.png" height="70%" width="80%"/><br>
<b>Fig. 14</b>: 그래프에서는 점들의 순서가 없다.
</center>

<!--
2. The second issue is that neighborhood sizes may be different.

So the template $w^\ell$ shown below has 4 nodes, but node $i$ has 7 nodes in its neighborhood.
How can we compare these two?
-->

2. 두 번째 문제점은 인접 크기<sup>neighborhood sizes</sup>가 다를 수 있다는 것이다. 

그래서 아래에 보이는 템플릿 $w^\ell$는 인접한 4개의 꼭짓점을 갖는데 점  $i$는 인근에 7개의 점을 가진다. 
이 둘을 어떻게 비교할 수 있을까?

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/diffneigh.png" height="70%" width="80%"/><br>
<b>Fig. 15</b>: Different neighborhood sizes in a graph.
</center>
-->

<!--
## Graph Convolution

We now use the **Convolution Theorem** to define convolution for graphs.

The **Convolution Theorem** states that the Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms:
-->

## 그래프 합성곱

이제 그래프의 합성곱 정의를 위해 **합성곱 이론**<sup>Convolution Theorem</sup>을 사용해보자.

<!--
$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

In general, the Fourier transform has $O(n^2)$ complexity, but if the domain is a grid, then the complexity can be reduced to $O(n\log n)$ with FFT.
-->

$$\mathcal{F}(w*h) = \mathcal{F}(w) \odot \mathcal{F}(h) \implies w * h = \mathcal{F}^{-1}(\mathcal{F}(w)\odot\mathcal{F}(h))$$

일반적으로 푸리에 변환<sup>Fourier transform</sup>은 $O(n^2)$의 복잡도를 갖지만, 정의역이 그리드라면, 복잡도는 고속 푸리에 변환<sup>FFT</sup>을 이용해 $O(n\log n)$로 줄일 수 있다. 

<!--
### Can we extend the Convolution theorem to graphs?

This raises two questions:
1. How to define Fourier transforms for graphs?
2. How to compute fast spectral convolutions in $O(n)$ time for compact kernels (as in template matching)?
-->

### 합성곱 이론을 그래프에도 적용이 가능할까?

이 방식은 두 가지의 의문점을 제기한다:
1. 푸리에 변환을 그래프에 적용하기 위해 어떻게 정의할 것인가?
2. 콤팩트<sup>compact</sup>한 커널들을 위해 고속 스펙트럼 합성곱<sup>fast spectral convolutions</sup>을 어떻게 $O(n)$시간으로 계산할 수 있는가 (템플릿 매칭처럼)?

<!--
$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

We are going to use these two design for graph neural networks:
Template matching will be for spacial graph ConvNets and the Convolution theorem will be used for the spectral ConvNets.
-->

$$w *_{\mathcal{G}} h \stackrel{?}{=} \mathcal{F}^{-1}_{\mathcal{G}}(\mathcal{F}_{\mathcal{G}}(w)\odot\mathcal{F}_{\mathcal{G}}(h))$$

그래프 신경망을 위해 다음 두 가지의 방법이 사용한다:
템플릿 매칭은 공간적 그래프 합성곱 신경망에, 그리고 합성곱 이론은 스펙트럼 합성곱 신경망에 사용될 것이다. 

<!--
## Spectral Graph ConvNets

How to perform spectral convolution?

### Step 1 : Graph Laplacian

This is the core operator in spectral graph theory.

Define
--> 
## 스펙트럼 그래프 합성곱 신경망

스펙트럼 합성곱은 어떻게 사용되어지나?

### 1단계: 그래프 라플라시안<sup>Laplacian</sup>

그래프 라플라시안은 스펙트럼 그래프 이론의 핵심 연산자<sup></sup>이다.

정의

<!--
$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$
-->

$$
\begin{aligned} \mathcal{G}=(V, E, A) & \rightarrow \underset{n \times n}{\Delta}=\mathrm{I}-D^{-1 / 2} A D^{-1 / 2} \\ & \quad \text { where } \underset{n \times n} D=\operatorname{diag}\left(\sum_{j \neq i} A_{i j}\right) \end{aligned}
$$

<!--
Note Matrix $A$ is the adjacency matrix, and the $\Delta$ is the Laplacian, which equals to the identity minus the adjacency matrix normalized by Matrix $D$. $D$ is a diagonal matrix, and each element on the diagonal is the degree of the node. This is called the normalized Laplacian, or Laplacian by default in this context.
-->

$A$는 인접행렬이고, $\Delta$는 (단위행렬<sup>identity  matrix</sup>에서 행렬$D$에 의해 정규화ehls<sup>normalized</sup> 인접행렬을 뺀 것과 같은) 라플라시안이다. $D$는 대각 행렬이고, 대각에 있는 각 원소는 꼭짓점의 차수<sup>degree of the node</sup>이며, 이를 정규화된 라플라시안이라고 부른다 (이하 문서에서는 편의상 라플라시안으로 표기).

<!--
The Laplacian is interpreted as the measurement of smoothness of graph, in other words, the difference between the local value $h_i$ and its neighborhood average value of $h_j$'s. $d_i$ on the formula below is the degree of node $i$, and $\mathcal{N}_{i}$ is the all the neighbors of node $i$.
-->

라플라시안은 그래프의 매끄러움<sup>smoothness</sup>의 정도로 해석이 가능하다. 다른 표현으로, 국소값<sup>local value</sup> $h_i$와 $h_i$'의 인접 평균값의 차이이다. 아래 수식에 $d_i$는 꼭짓점 $i$의 차수이며 $\mathcal{N}_{i}$는 꼭짓점 $i$의 이웃점들이다. 

<!--
$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

The formula above is to apply Laplacian to a function $h$ on the node $i$, which is the value of $h_i$ minus the mean value over its neighboring nodes $h_j$'s. Basically, if the signal is very smooth, the Laplacian value is small, and vice versa.
-->

$$
(\Delta h)_{i}=h_{i}-\frac{1}{d_{i}} \sum_{j \in \mathcal{N}_{i}} A_{i j} h_{j}
$$

위 공식은 꼭짓점 $i$의 함수 $h$에 라플라시안을 적용한 것으로, $h_i$값에서 $h_j$의 인근 꼭짓점들의 평균값을 뺀 것과 같다. 기본적으로, 만약 신호가 매우 매끄럽다면, 라플라시안 값이 작을 것이다. 이는 반대로도 마찬가지다. 

<!--
### Step 2 : Fourier Functions

The following is the eigen-decomposition of graph Laplacian,

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$
-->

### 2단계: 푸리에 함수

다음은 그래프 라플라시안의 고유값 분해<sup>eigen-decomposition</sup>이다,

$$
\underset{n \times n}{\Delta}=\Phi^{T} \Lambda \Phi
$$

<!--
The Laplacian is factorized into three matrices, 

$\Phi$ is defined below, it contains column vectors, or Lap eigenvectors $\phi_1$ to $\phi_n$, each of size $n \times 1$, and those are also called Fourier functions. And Fourier functions form an orthonormal basis.
-->

위 라플라시안은   3가지 행렬 $\Phi ^ T$, $\Lambda$, $\Phi$을 갖는다, 

$\Phi$는 아래와 같이 정의되며,  각 $n \times 1$ 크기를 가진 $\phi_1$부터  $\phi_n$까지의 라플라시안 고유 벡터인 열벡터<sup>column vector</sup>를 갖는다. 각 원소들은 푸리에 함수<sup>Fourier functions</sup>라고 하며, 푸리에 함수는 정규 직교 기저<sup>orthonormal basis</sup>를 형성한다. 

<!--
$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$
-->

$$
\begin{array}{l}\text { where } \underset{n \times n}{\Delta}\Phi=\left[\phi_{1}, \ldots, \phi_{n}\right]=\text { and } \Phi^{T} \Phi=\mathrm{I},\left\langle\phi_{k}, \phi_{k^{\prime}}\right\rangle=\delta_{k k^{\prime}} \\\end{array}
$$

<!--
$\Lambda$ is a diagonal matrix with Laplacian eigenvalues, and on the diagonal are $\lambda_1$ to $\lambda_n$. And from the normalized applications, these values are typically among the range from $0$ to $2$. Those are also known as the Spectrum of a graph. See the formula below.

$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$

-->

$\Lambda$는 $\lambda_1$부터 $\lambda_n$까지의 라플라시안 고윳값들을 가진 대각행렬이다. 정규화가 적용되었기에 고윳값들은 일반적으로 $0$ 부터 $2$ 사이며, 이는 그래프의 스펙트럼으로도 알려져있다. 아래 함수를 참조.

$$
\begin{array}{c}\text { where } \underset{n \times n}\Lambda=\operatorname{diag}\left(\lambda_{1}, \ldots, \lambda_{n}\right) \text { and } 0 \leq \lambda_{1} \leq \ldots \leq \lambda_{n}=\lambda_{\max } \leq 2\end{array}
$$

<!--
Below is an example of checking the eigenvalue decomposition. The Laplacian matrix $\Lambda$ is multiplied by an eigenvector $\phi_k$, the shape of the result is $n \times 1$, and the result is $\lambda_k \phi_k$.


$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$
-->

아래는 고유값 분해 확인의 예이다. 라플라시안 행렬 $\Lambda$는 고유 벡터 $\phi_k$와 곱해지며, $n \times 1$의 크기를 가진 결과 $\lambda_k \phi_k$를 갖는다. 

$$
\begin{array}{ll}\text { and } \underset{n \times 1}{\Delta \phi_{k}}=\lambda_{k} \phi_{k}, & k=1, \ldots, n \\ & \end{array}
$$

<!--
The image below is the visualization of eigenvectors of 1D Euclidean Laplacian.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Fig. 16</b>: Grid/Euclidean Domain: eigenvectors of 1D Euclidean Laplacian.
</center>
-->

아래 그림은 1차원 유클리드 라플라시안을 시각화하여 보여준다.

<center>
<img src="{{site.baseurl}}/images/week13/13-1/grid.png" height="90%" width="100%"/><br>
<b>Fig. 16</b>: 그리드/유클리드 정의역: 1차원 유클리드 라플라시안의 고유벡터
</center>

<!--
For graph domain, from the left to right, is the first, second, third, .. Fourier functions of a graph. For example, $\phi_1$ has oscillations of positive (red) and negative (blue) values, same for $\phi2$, $\phi3$. Those oscillations depend on the topology of a graph, which related to the geometry of graphs such as communities, hubs, etc, and it's helpful for graph clustering. See below.
-->

그래프 정의역으로는 왼쪽에서 오른쪽 순으로, 첫 번째, 두 번째, 세 번째, .. 그래프의 푸리에 함수들이다. 예를 들어 $\phi_1$은 $\phi_2$, $\phi_3$와 마찬가지로 양수(빨강)와 음수(파랑) 값의 진동을 갖는다. 이 진동은 그래프의 위상<sup>topology </sup>에 영향을 받으며, 이는 중심부, 군집과 같은 그래프의 기하학적 구조<sup>geometry</sup>에 연관되어있다. 이는 그래프 군집화<sup>clustering</sup>에 상당한 도움이 된다. 아래 참조.

<!--
<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Fig. 17</b>: Graph Domain: Fourier functions of a graph.
</center>
-->
<center>
<img src="{{site.baseurl}}/images/week13/13-1/graphdomain.png" height="90%" width="100%"/><br>
<b>Fig. 17</b>: 그래프 정의역: 그래프의 푸리에 함수.
</center>

<!--
### Step 3 : Fourier Transform

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$
-->

### 3단계: 푸리에 변환

$$
\begin{aligned} \underset{n \times 1} h &=\sum_{k=1}^{n} \underbrace{\left\langle\phi_{k}, h\right\rangle}_{\mathcal{F}(h)_{k}=\hat{h}_{k}=\phi_{k}^{T} h}\underset{n \times 1}{\phi_{k}} \\ &=\sum_{k=1}^{n} \hat{h}_{k} \phi_{k} \\ &=\underbrace{\Phi \hat{h}}_{
\mathcal{F}^{-1}(\hat{h})
} \end{aligned}
$$

<!--
**Fourier series: Decompose function $h$ with Fourier functions.**

Take the function $h$ and projected on each Fourier function $\phi_k$, resulting in the coefficient of Fourier series of $k$, a scaler, and then multiplied by the function $\phi_k$.
-->

**푸리에 급수: 함수 $h$를 푸리에 함수로 분해하라.**

함수 $h$에 각 푸리에 함수 $\phi_k$에 적용을 시키면, 스칼라인 $k$의 푸리에 급수의 계수<sup>coefficient of Fourier series</sup>를 갖고,  함수 $\phi_k$에 곱해진다. 

<!--
The Fourier transform is basically projecting a function $h$ on the Fourier functions, and the result are the coefficients of the Fourier series.

**Fourier Transform/ coefficients of Fourier Series**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$
-->

푸리에 변환은 단순히 함수 $h$를 푸리에 함수에 적용시킴으로 푸리에 급수의 계수를 찾는 것을 말한다. 

**푸리에 변환/ 푸리에 급수의 계수**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}(h)} &=\Phi^{T} h \\
&=\hat{h} \end{aligned}
$$

<!--
**Inverse Fourier Transform**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$
-->

**역푸리에<sup>Inverse Fourier Transform</sup> 변환**

$$
\begin{aligned} \underset{n \times 1}{\mathcal{F}^{-1}(\hat{h})} &=\Phi \hat{h} \\ &=\Phi \Phi^{T} h=h \quad \text { as } \mathcal{F}^{-1} \circ \mathcal{F}=\Phi \Phi^{T}=\mathrm{I} \end{aligned}
$$

<!--
Fourier transforms are linear operations, multiplying a matrix $\Phi^{T}$ with a vector $h$.
-->

푸리에 변환은 행렬 $\Phi^{T}$와 벡터 $h$를 곱하는 선형 연산<sup></sup>이다. 

<!--
### Step 4 : Convolution Theorem


Fourier transform of the convolution of two functions is the pointwise product of their Fourier transforms.
-->

### 4단계: 합성곱 이론 

두 함수 합성곱의 푸리에 변환은 두 함수 각각의 푸리에 변환끼리의 단순곱<sup>pointwise product</sup>이다.

<!--
$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$
-->

$$
\begin{aligned}
\underset{n \times 1} {w * h} &=\underbrace{\mathcal{F}^{-1}}_{\Phi}(\underbrace{\mathcal{F}(w)}_{\Phi^{T} w=\hat{w}} \odot \underbrace{\mathcal{F}(h)}_{\Phi^{T} h}) \\ &=\underset{n \times n}{\Phi}\left( \underset{n \times 1}{\hat{w}}\odot \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi\left(\underset{n \times n}{\hat{w}(\Lambda)} \underset{n \times 1}{\Phi^{T} h}\right) \\ &=\Phi \hat{w}(\Lambda) \Phi^{T} h \\ &=\hat{w}(\underbrace{\Phi \Lambda \Phi^{T}}_{\Delta}) h \\ &=\underset{n \times n}{\hat{w}(\Delta)} \underset{n \times1}h \\  &
\end{aligned}
$$

<!--
The example above is the convolution of $w$ and $h$, both of shape $n \times 1$, it equals the inverse of Fourier transform of pointwise product between Fourier transform of $w$ and of $h$. The formula above shows that it also equals to the matrix multiplication of $\hat{w}(\Delta)$ and $h$.
-->

위의 예제는 $w$와 $h$의 합성곱이며, 둘 다 $n \times 1$의 크기를 갖고, $w$와 $h$의 푸리에 변환끼리의 단순곱의 역푸리에 변환과 같다. 위 수식은 $\hat{w}(\Delta)$ 와$h$의 행렬곱과 같다는 걸 보여준다. 

<!--
The convolution of two functions on the graph $h$ and $w$ is to take the spectrum function of $w$ and apply it to Laplacian and multiply it by $h$, and this is the definition of spectrum convolution. However, the computation complexity is $\mathrm{O}\left(n^{2}\right)$, while $n$ is the number of nodes in the graph.
-->

그래프 $h$와 $w$의 두 함수 합성곱은 스펙트럼 함수 $w$를 가져다 라플라시안에 적용시켜 $h$와 곱해지며, 이는 스펙트럼 합성곱의 정의이다. 문제는 연산 복잡도가 그래프 $n$ 꼭짓점에 비래하는 $\mathrm{O}\left(n^{2}\right)$이라는 것이다. 

<!--
## Limitation

The spectral convolution against the graph domain is not shifting invariance, which means that if shifted, the shape of the function might also be changed, while in grid/euclidean domain does not.
-->

## 한계점

그래프 정의역에서의 스펙트럼 합성곱은 전이 불변<sup>invariance</sup>하지 않는다, 다시 말해 위치가 바뀌게 된다면, 그리드/유클리드 정의역이 바뀌지 않음에도 함수의 구조가 변하게 될 수도 있다는 것이다. 

<!--
## Recommended book

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)
-->

## 권장 도서

Spectral graph theory, Fan Chung, (harmonic analysis, graph theory, combinatorial problems, optimization)
