---
lang-ref: ch.12-2
title: 디코딩 언어 모델
lecturer: Mike Lewis
authors: Trevor Mitchell, Andrii Dobroshynskyi, Shreyas Chandrakaladharan, Ben Wolfson
date: 20 Apr 2020
lang: ko
translation-date: 21 July 2020
translator: Jieun
---


<!-- ## [Beam Search](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s) -->
## [빔 서치](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=2732s)

<!-- Beam search is another technique for decoding a language model and producing text. At every step, the algorithm keeps track of the $k$ most probable (best) partial translations (hypotheses). The score of each hypothesis is equal to its log probability.

The algorithm selects the best scoring hypothesis.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>Fig. 1</b>: Beam Decoding
</center>
 -->

빔 서치는 텍스트를 생성하고, 언어 모델을 디코딩하는 또 다른 테크닉이다. 모든 스텝마다, 알고리즘은 $k$개의 가장 가능성있는 (최선의) 부분 번역들(가설들<sup>hypotheses</sup>)을 꾸준히 추척<sup>track</sup>한다. 각 가설의 스코어는 그의 로그 확률<sup>log probability</sup>과 같다. 

알고리즘은 최고 스코어를 기록한 가설을 선택한다. 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Beam_Decoding.png" width="60%"/><br>
<b>그림1</b>: 빔 디코딩
</center>



<!-- How deep does the beam tree branch out ?

The beam tree continues until it reaches the end of sentence token. Upon outputting the end of sentence token, the hypothesis is finished.

Why (in NMT) do very large beam sizes often results in empty translations?

At training time, the algorithm often does not use a beam, because it is very expensive. Instead it uses auto-regressive factorization (given previous correct outputs, predict the $n+1$ first words). The model is not exposed to its own mistakes during training, so it is possible for “nonsense” to show up in the beam.

Summary: Continue beam search until all $k$ hypotheses produce end token or until the maximum decoding limit T is reached.
 -->

빔 트리는 가지를 얼마나 깊게 뻗을 수 있을까?

빔 트리는 문장 토큰의 끝에 도달할때까지 이어진다. 문장의 마지막 토큰을 내놓으면, 가설도 종료된다.

어째서 매우 크기가 큰 빔 사이즈들은 (NMT에서) 자주 빈 번역 결과를 낼까?

트레이닝을 할 때, 알고리즘은 빔이 비싸기 때문에 자주 사용하지 않는다. 대신에 자동 회귀 분해<sup>auto-regressive factorization</sup> (이전의 올바른 결과물들을 받아, $n+1$ 첫번째 단어들을 예측한다.)를 사용한다. 트레이닝 중에는 모델의 실수가 드러나지 않기에, 빔에서 "무의미한 말"을 내놓을 가능성이 있는 것이다. 

요약: 모든 $k$ 가설들이 마지막 토큰을 생산할 때까지 또는 최대 디코딩 한계 T에 도달할 때까지 빔 서치를 계속해라.



<!-- ### Sampling

We may not want the most likely sequence. Instead we can sample from the model distribution.

However, sampling from the model distribution poses its own problem. Once a "bad" choice is sampled, the model is in a state it never faced during training, increasing the likelihood of continued "bad" evaluation. The algorithm can therefore get stuck in horrible feedback loops.
 -->
 
### 샘플링

어쩌면 가장 가능성이 높은 순서를 원하지 않을 수도 있다. 대신, 모델의 분포로부터 샘플링을 할 수 있다. 

하지만, 모델의 분포로부터 샘플링을 하는 것은 이 방식 자체의 문제를 드러낸다. 한 번 "나쁜" 선택이 샘플링되었을 때, 모델은 트레이닝 동안 절대 마주친 적이 없는 상태에 있고, 연속적으로 "나쁜" 평가의 우도<sup>likelihood</sup>를 증가시킨다. 따라서 알고리즘은 끔찍한 피드백 루프에 갇힐 수 있다.

 

<!-- ### Top-K Sampling

A pure sampling technique where you truncate the distribution to the $k$ best and then renormalise and sample from the distribution.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>Fig. 2</b>: Top K Sampling
</center>
 -->
 
### 톱-K 샘플링

샘플링 기술 자체는 분포를 앞 뒤로 잘라서 최상의 $k$개를 뽑고, 다시 정규화를 하고 그 분포로부터 샘플링을 하는 것이다. 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/Top_K_Sampling.png" width="60%"/><br>
<b>그림2</b>: 톱-K 샘플링
</center>



<!-- #### Question: Why does Top-K sampling work so well?

This technique works well because it essentially tries to prevent falling off of the manifold of good language when we sample something bad by only using the head of the distribution and chopping off the tail.
 -->
 
#### 질문 : 왜 톱-K 샘플링은 잘 되는 것일까?

이 테크닉이 잘 되는 이유는 본질적으로 꼬리를 잘라낸 분포의 머리 부분만 사용하기에, 뭔가 안 좋은 것이 샘플링 되려고 할 때, 즉, 좋은 언어의 매니폴드<sup>manifold</sup>에서 떨어지는 일을 막으려 노력하기 때문이다.



<!-- ## Evaluating Text Generation

Evaluating the language model requires simply log likelihood of the held-out data. However, it is difficult to evaluate text. Commonly word overlap metrics with a reference (BLEU, ROUGE etc.) are used, but they have their own issues. -->

## 텍스트 생성 평가하기

언어 모델을 평가하는 건 간단하게 갖고 있는 데이터의 로그 우도<sup>log likelihood</sup>만 요구한다. 하지만 텍스트를 평가하는 일은 어렵다. 보편적인 단어 오버랩 메트릭들<sup>word overlap metrics</sup>은 레퍼런스(BLEU, ROUGE etc.)와 함께 쓰이지만, 각자가 가진 문제도 있어서다.



<!-- ## Sequence-To-Sequence Models -->

## 시퀀스-투-시퀀스 모델


<!-- ### Conditional Language Models

Conditional Language Models are not useful for generating random samples of English, but they are useful for generating a text given an input.

Examples:

- Given a French sentence, generate the English translation
- Given a document, generate a summary
- Given a dialogue, generate the next response
- Given a question, generate the answer -->

### 조건부 언어 모델<sup>Conditional Language Models</sup>

조건부 언어 모델들은 영어로부터 무작위한 샘플을 생성해내는데에는 유용하지가 못하다. 하지만 주어진 입력값에 대한 텍스트를 생성해내는데에는 유용하다. 

예시들:

- 불어 문장이 주어졌을 때, 번역된 영어 문장 생성하기
- 문서가 주어졌을 때, 요약본 생성하기
- 대화가 주어졌을 때, 다음번 응답을 생성하기
- 질문이 주어졌을 때, 답변을 생성하기



<!-- ### Sequence-To-Sequence Models

Generally, the input text is encoded. This resulting embedding is known as a "thought vector", which is then passed to the decoder to generate tokens word by word.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>Fig. 3</b>: Thought Vector
</center>
 -->
 
### 시퀀스-투-시퀀스 모델

일반적으로 텍스트는 인코딩되서 입력된다. 이 임베딩 결과는 "생각하는 벡터"로 알려져 있다, 이는 단어별 토큰들을 생성해내기 위해 디코더로 전해진다.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_Models.png" width="60%"/><br>
<b>그림3</b>: 생각하는 벡터
</center>

 

<!-- ### Sequence-To-Sequence Transformer

The sequence-to-sequence variation of transformers has 2 stacks:

1. Encoder Stack – Self-attention isn't masked so every token in the input can look at every other token in the input

2. Decoder Stack – Apart from using attention over itself, it also uses attention over the complete inputs

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>Fig. 4</b>: Sequence to Sequence Transformer
</center>

Every token in the output has direct connection to every previous token in the output, and also to every word in the input. The connections make the models very expressive and powerful. These transformers have made improvements in translation score over previous recurrent and convolutional models. -->

### 시퀀스-투-시퀀스 트랜스포머

시퀀스-투-시퀀스 변형 버전의 트랜스포머는 2개의 스택을 갖고 있다:

1. 인코더 스택 - 셀프-어텐션은 마스크를 하지 않기에, 입력값의 모든 토큰은 입력값의 다른 모든 토큰들을 볼 수 있다. 

2. 디코더 스택 - 그 자신에 대한 어텐션을 쓰는 것과는 별개로, 전체 입력값들에 대한 어텐션을 또 사용한다. 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/s2s_transformers.png" width="60%"/><br>
<b>그림4</b>: 시퀀스-투-시퀀스 트랜스포머
</center>

결과값에 있는 모든 토큰은, 거기에 있는 모든 이전 토큰들과 또 입력값의 모든 단어들과도 직접적으로 연결되어 있다. 이 연결들이 모델을 매우 강력하게 또 표현력있게 만든다. 트랜스포머들은 이전의 순환 모델과 합성곱 모델을 넘어, 번역 점수에서 향상을 이루어냈다. 



<!-- ## [Back-translation](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

When training these models, we typically rely on large amounts of labelled text. A good source of data is from European Parliament proceedings - the text is manually translated into different languages which we then can use as inputs and outputs of the model.
 -->

## [역-번역](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=3811s)

이 모델들을 트레이닝할 때, 우리는 보통 많은 양의 라벨링된 텍스트에 의존한다. 데이터의 좋은 소스는 유럽 의회의 절차<sup>European Parliament proceedings</sup>이다 - 텍스트는 서로 다른 언어들로 수동으로 번역되어, 모델의 입력값과 출력값으로 사용할 수 있다.



<!-- ### Issues

- Not all languages are represented in the European parliament, meaning that we will not get translation pair for all languages we might be interested in. How do we find text for training in a language we can't necessarily get the data for?
- Since models like transformers do much better with more data, how do we use monolingual text efficiently, i.e. no input / output pairs?

Assume we want to train a model to translate German into English. The idea of back-translation is to first train a reverse model of English to German

- Using some limited bi-text we can acquire same sentences in 2 different languages
- Once we have an English to German model, translate a lot of monolingual words from English to German.

Finally, train the German to English model using the German words that have been 'back-translated' in the previous step. We note that:

- It doesn't matter how good the reverse model is - we might have noisy German translations but end up translating to clean English.
- We need to learn to understand English well beyond the data of English / German pairs (already translated) - use large amounts of monolingual English -->

### 이슈들

- 모든 언어들이 유럽 의회에 나타나는 것이 아니다, 이는 우리가 관심있어하는 모든 언어들의 번역 페어<sup>translation pair</sup>를 얻지 못할 수도 있다는 것이다. 굳이 데이터를 얻으려고 (노력)할 필요없이, 어떻게 트레이닝을 위한 언어 텍스트를 찾을 수 있을까?

- 트랜스포머같은 모델들은 더 많은 데이터가 있을 때 더 좋은 성능을 내는데, 우리는 어떻게 단일 언어 텍스트(댜른말로, 입력값이나 출력값이 없는 페어들)를 효율적으로 사용할 수 있을까? 

우리가 독일어에서 영어로 번역하는 모델을 트레이닝시키고 싶다고 가정해보자. 역-번역<sup>back-translation</sup>의 아이디어는 영어에서 독일어로 가는 역 모델을 처음 트레이닝하는 점에 있다. 

- 어떤 제한된 이중 언어-텍스트를 사용함으로써 우리는 2개의 다른 언어로 된 같은 문장을 얻을 수 있다.
- 한 번 영어-독일어 모델을 얻으면, 많은 단일 언어 단어들을 영어에서 독일어로 번역할 수 있다. 

마지막으로, 이전 스텝에서 '역-번역'한 독일어를 사용해서 독일어에서 영어로 가는 모델을 트레이닝한다. 여기서 알아두어야 할 점은:

- 역 모델이 얼마냐 좋으냐와는 상관없다 - 엉망인 독일어 번역을 얻을수도 있지만, 결과적으로는 깨끗한 영어로 번역이 이루어진다. 
- 영어/독일어 페어(이미 번역되어 있는)의 데이터를 넘어, 우리는 영어를 잘 이해하는 걸 배울 필요가 있다 - 많은 양의 영어 단일 언어 데이터를 사용해라



<!-- ### Iterated Back-translation

- We can iterate the procedure of back-translation in order to generate even more bi-text data and reach much better performance - just keep training using monolingual data.
- Helps a lot when not a lot of parallel data
 -->
 
### 반복적인 역-번역

- 우리는 더 많은 이중 언어-텍스트 데이터를 생성하거나 더 좋은 성능에 도달하기 위해서 역-번역 절차를 반복할 수 있다 - 단일 언어 데이터를 사용해서 계속 트레이닝 해라. 
- 많은 양의 병행 데이터를 쓸 수 없을 경우 큰 도움이 된다. 



<!-- ## Massive multilingual MT

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>Fig. 5</b>: Multilingual MT
</center>

- Instead of trying to learn a translation from one language to another, try to build a neural net to learn multiple language translations.
- Model is learning some general language-independent information.

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>Fig. 6</b>: Multilingual NN Results
</center>

Great results especially if we want to train a model to translate to a language that does not have a lot of available data for us (low resource language).
 -->
 
## 대량의 다중 언어 기계 번역 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-language-mt.png" width="60%"/><br>
<b>그림5</b>: 다중 언어 기계 번역 
</center>

- 하나의 언어에서 다른 언어로의 번역을 배우려고 노력하는 대신, 다양한 언어 번역을 배우도록 신경망을 구축하는데에 힘쓴다. 
- 모델은 언어와는 독립되어 있는 일반적인 어떤 정보를 배운다. 

<center>
<img src="{{site.baseurl}}/images/week12/12-2/multi-mt-results.gif" width="60%"/><br>
<b>그림6</b>: 다중 언어 신경망 결과물
</center>

특히 쓸 수 있는 데이터가 많지 않은 언어를 번역하는 모델을 트레이닝 시키려고 할 때 끝내주는 결과를 낸다. (소스가 많지 않은 언어)



<!-- ## Unsupervised Learning for NLP

There are huge amounts of text without any labels and little of supervised data. How much can we learn about the language by just reading unlabelled text?
 -->
 
## 자연어 처리를 위한 비지도 학습

어떤 레이블<sup>labels</sup>도 없는 어마어마한 양의 텍스트가 있고, 적은 양의 지도 학습을 위한 데이터가 있다. 라벨링되지 않은 텍스트를 단순히 읽는 것만으로 우리는 언어에 대해서 얼마나 많은 것을 배울 수 있을까?



<!-- ### `word2vec` -->
### '워드투벡터'

<!-- Intuition - if words appear close together in the text, they are likely to be related, so we hope that by just looking at unlabelled English text, we can learn what they mean.
 -->
직관 - 텍스트에서 단어들이 근접해서 나타나면, 그들은 연결되어 있을 가능성이 높다, 그러므로 우리는 단순히 라벨링되지 않은 영어 텍스트를 읽는 것만으로 그들의 뜻을 배울 수 있기를 바란다. 
 
<!-- - Goal is to learn vector space representations for words (learn embeddings) -->
- 목표는 단어들에 대한 벡터 공간 표현을 배우는 것이다.

<!-- Pretraining task - mask some word and use neighbouring words to fill in the blanks. -->
사전학습 과제 - 몇몇 단어들을 마스크하고 (마스킹된) 공백을 채우기 위해 이웃하는 단어들을 사용해라.

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>Fig. 7</b>: word2vec masking visual
</center> -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-masking.gif" width="60%"/><br>
<b>그림7</b>: 워드투벡터 마스킹 보이기
</center>

<!-- For instance, here, the idea is that "horned" and "silver-haired" are more likely to appear in the context of "unicorn" than some other animal. -->
여기서, 한 예로, "horned"와 "silver-haired"의 아이디어는 다른 동물들에 비해, "unicorn"의 맥락에서 나올 가능성이 더 높다.

<!-- Take the words and apply a linear projection -->
단어들을 선택하고, 선형 투영<sup>linear projection</sup>을 적용하자.

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>Fig. 8</b>:  word2vec embeddings
</center>
 -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/word2vec-embeddings.png" width="60%"/><br>
<b>그림8</b>: 워드투벡터 임베딩
</center>
 
<!-- Want to know -->
알고자하는 것

<!-- $$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$ -->
$$
p(\texttt{unicorn} \mid \texttt{These silver-haired ??? were previously unknown})
$$

$$
p(x_n \mid x_{-n}) = \text{softmax}(\text{E}f(x_{-n})))
$$

<!-- Word embeddings hold some structure -->
워드 임베딩은 어떤 구조를 갖고 있다.

<!-- <center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>Fig. 9</b>: Embedding structure example
</center>
 -->
<center>
<img src="{{site.baseurl}}/images/week12/12-2/embeddings-structure.png" width="60%"/><br>
<b>그림9</b>: 임베딩 구조 예시
</center>


<!-- - The idea is if we take the embedding for "king" after training and add the embedding for "female" we will get an embedding very close to that of "queen"
- Shows some meaningful differences between vectors
 -->
- 아이디어는 만약 트레이닝 이후에 "왕"에 대한 임베딩을 취하고, 거기에 "여성"이라는 임베딩을 더한다면, 우리는 "여왕"에 매우 가까운 임베딩을 얻을 수 있다는 것이다.
- 이는 벡터들 사이의 의미있는 어떤 차이를 보여준다.



<!-- #### Question: Are the word representation dependent or independent of context?

Independent and have no idea how they relate to other words
 -->
#### 질문: 단어의 표현은 맥락에 독립적인가 그렇지 못한가?

독립적이며 다른 단어들과 어떻게 연결되어 있는지에 대해서 알 수 없다.



<!-- #### Question: What would be an example of a situation that this model would struggle in?

Interpretation of words depends strongly on context. So in the instance of ambiguous words - words that may have multiple meanings - the model will struggle since the embeddings vectors won't capture the context needed to correctly understand the word.
 -->
#### 질문: 이 모델이 어려움을 겪는 상황에 대한 예시가 있을까?

단어를 통역하는 일은 맥락에 크게 좌우된다. 그러므로 애매한 단어들에 대한 예시에서 - 단어는 여러가지 뜻을 가질 수 있으므로 - 임베딩 벡터들은 단어를 제대로 이해하기 위해 요구되는 맥락을 알 수 없으므로, 모델은 어려움을 겪을 것이다. 



<!-- ### GPT

To add context, we can train a conditional language model. Then given this language model, which predicts a word at every time step, replace each output of model with some other feature.

- Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review

This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks. -->

### GPT

맥락을 더하기 위해, 조건부 언어 모델을 트레이닝할 수 있다. 이 언어 모델이 주어지면, 각 타임스텝마다 단어를 예측하고, 모델의 각 출력값을 다른 어떤 특징으로 대체한다. 

<!-- - Pretraining - predict next word
- Fine-tuning - change to a specific task. Examples:
  - Predict whether noun or adjective
  - Given some text comprising an Amazon review, predict the sentiment score for the review
 -->
 
- 사전 트레이닝 - 다음 단어 예측
- 파인 튜닝 - 세부 과제로 바뀐다. 예시들:
  - 명사인지 형용사인지 예측
  - 아마존 리뷰들로 구성된 어떤 텍스트를 주고, 리뷰에 대한 감성 점수를 예측한다
 
<!-- This approach is good because we can reuse the model. We pretrain one large model and can fine tune to other tasks. -->
이 접근법은 좋은 건, 모델을 재사용할 수 있어서이다. 하나의 거대한 모델을 사전에 트레이닝하면, 다른 과제들을 위한 파인 튜닝이 가능하다.



<!-- ### ELMo

GPT only considers leftward context, which means the model can't depend on any future words - this limits what the model can do quite a lot.

Here the approach is to train _two_ language models

- One on the text left to right
- One on the text right to left
- Concatenate the output of the two models in order to get the word representation. Now can condition on both the rightward and leftward context.

This is still a "shallow" combination, and we want some more complex interaction between the left and right context.
 -->
 
### ELMo

GPT는 왼쪽에 있는 맥락만을 고려했는데, 이후에 등장할 단어들에 대해서 의존하지 않는다는 의미다 - 이는 모델이 할 수 있는 일들을 꽤 제한했다. 

여기 이 접근법은 두 개의 언어 모델들을 트레이닝하기 위한 것이다.

- 하나는 왼쪽에서 오른쪽으로 향한다.
- 하나는 오른쪽에서 왼쪽으로 향한다.
- 단어의 표현<sup>word representation</sup>을 얻기 위해, 두 모델의 결과물을 연결<sup>concatenate</sup>한다. 이제 우리는 우측으로부터의 맥락과 좌측으로부터의 맥락 모두에 의존한다. 

이는 여전히 "얕은" 조합이고, 왼쪽과 오른쪽의 맥락 사이에서 좀 더 복잡한 어떤 상호 작용이 있었으면 좋겠다.



<!-- ### BERT

BERT is similar to word2vec in the sense that we also have a fill-in-a-blank task. However, in word2vec we had linear projections, while in BERT there is a large transformer that is able to look at more context. To train, we mask 15% of the tokens and try to predict the blank.

Can scale up BERT (RoBERTa):

- Simplify BERT pre-training objective
- Scale up the batch size
- Train on large amounts of GPUs
- Train on even more text

Even larger improvements on top of BERT performance - on question answering task performance is superhuman now.
 -->
 
### BERT

버트<sup>BERT</sup>는 이전에 한 공백-채우기 측면에서는, 워드투벡터와 비슷하다. 그러나 워드투벡터에서는 선형 투영을 했지만, 버트에는 더 많은 맥락을 볼 수 있는 거대한 트랜스포머가 있다. 트레이닝을 위해, 우리는 토큰 중 15%는 마스크 처리 할 것이고, 이 빈 부분들을 예측하려고 할 것이다. 

확장가능한 버트, 로베르타<sup>RoBERTa</sup>:

- 사전-트레이닝 목표의 간략한 버트 
- 커진 배치 사이즈
- 많은 양의 GPUs에서 트레이닝
- 더 많은 텍스트를 트레이닝

최고의 버트 퍼포먼스 결과에서도 더 큰 향상을 보임 - 현재 질문-답변 과제 퍼포먼스에 있어서는 인간 수준을 넘어섰다.
 


<!-- ## [Pre-training for NLP](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

Let us take a quick look at different self-supervised pre training approaches that have been researched for NLP.

- XLNet:

  Instead of predicting all the masked tokens conditionally independently, XLNet predicts masked tokens auto-regressively in random order

- SpanBERT

   Mask spans (sequence of consecutive words) instead of tokens

- ELECTRA:

  Rather than masking words we substitute tokens with similar ones.  Then we solve a binary classification problem by trying to predict whether the tokens have been substituted or not.

- ALBERT:

  A Lite Bert: We modify BERT and make it lighter by tying the weights across layers. This reduces the parameters of the model and the computations involved. Interestingly, the authors of ALBERT did not have to compromise much on accuracy.

- XLM:

  Multilingual BERT: Instead of feeding such English text, we feed in text from multiple languages. As expected, it learned cross lingual connections better.

The key takeaways from the different models mentioned above are

- Lot of different pre-training objectives work well!

- Crucial to model deep, bidirectional interactions between words

- Large gains from scaling up pre-training, with no clear limits yet


Most of the models discussed above are engineered towards solving the text classification problem. However, in order to solve text generation problem, where we generate output sequentially much like the `seq2seq` model, we need a slightly different approach to pre training.
 -->
 
## [자연어처리를 위한 사전학습](https://www.youtube.com/watch?v=6D4EWKJgNn0&t=4963s)

자연어처리에서 연구되어온 다른 자가 지도<sup>self-supervised</sup> 사전 학습 접근법을 빠르게 보자.

- XLNet:

  독립적인 조건의 모든 마스크된 토큰들을 예측하는 대신, XLNet은 무작위 순서로 자동-회귀적으로<sup>auto-regressively</sup> 마스크된 토큰들을 예측한다.

- SpanBERT

   토큰 대신에 확장된 마스크(이어진 단어들의 시퀀스)를 사용

- 일렉트라<sup>ELECTRA</sup>:

  단어들을 마스킹하기보다, 토큰들을 비슷한 것으로 대체한다. 그리고 토큰들이 대체될 수 있는지 아닌지를 예측하려고 애쓰는, 이진 분류 문제를 푼다. 

- 알버트<sup>ALBERT</sup>:

  경량화된 버트: 우리는 레이어들을 교차하는 가중치들을 묶는 것으로, 버트를 수정하고 더 가볍게 만들었다. 이는 모델의 파라미터 관련한 계산들을 줄인다. 재미있게도, 알버트의 저자들은 정확도에 대해서 크게 타협할 필요가 없었다.
  
- XLM:
    
  다중 언어 버트: 영어 텍스트 대신, 여러 언어로부터 온 텍스트를 넣었다. 예측한대로, 교차적인 언어 연결을 더 낫게 학습했다.

키<sup>key</sup>는 위에서 언급된 서로 다른 모델로부터 가져온다

- 서로 다른 많은 사전학습 목표들이 잘 된다!

- 단어들끼리 양방향으로 깊은 상호 작용을 하게 하는 건 모델에게 굉장히 중요하다

- 스케일을 키운 사전 학습으로부터 많은 것을 얻는다. 아직 확실한 제약사항은 없다.

위에서 논의된 대부분의 모델들은 텍스트 분류 문제를 풀도록 설계되었다. 하지만, 텍스트 생성 문제를 풀기 위해서는, `시퀀스-투-시퀀스` 모델처럼 결과값을 연속적으로 생성해야하기에, 약간의 다른 접근법이 사전 학습에 필요하다.


 
<!-- #### Pre-training for Conditional Generation: BART and T5

BART: pre-training `seq2seq` models by de-noising text

In BART, for pretraining we take a sentence and corrupt it by masking tokens randomly. Instead of predicting the masking tokens (like in the BERT objective), we feed the entire corrupted sequence and try to predict the entire correct sequence.

This `seq2seq` pretraining approach give us flexibility in designing our corruption schemes. We can shuffle the sentences, remove phrases, introduce new phrases, etc.

BART was able to match RoBERTa on SQUAD and GLUE tasks. However, it was the new SOTA on summarization, dialogue and abstractive QA datasets. These results reinforce our motivation for BART, being better at text generation tasks than BERT/RoBERTa. -->

#### 조건부 생성을 위한 사전 학습: 바트<sup>BART</sup>와 T5

바트: 노이즈 제거 텍스트에 의한 사전 학습 `시퀀스-투-시퀀스` 모델

바트에서는, 사전학습을 위해 문장을 갖고 무작위로 토큰들을 마스킹해서 망가뜨린다. 마스킹된 토큰들을 예측하는 대신 (버트의 목표처럼), 망가진 전체 시퀀스를 넣고 올바른 전체 시퀀스를 예측하도록 노력한다. 

이 `시퀀스-투-시퀀스` 사전학습 접근법은 커럽션 스킴<sup>corruption schemes</sup>을 디자인하는 측면에서 유연함을 제공한다. 문장을 섞거나, 구절을 없애거나, 새로운 구절을 소개하는 등의 일들을 할 수 있다.

바트는 GLUE와 SQUAD 과제에서 로베르타<sup>RoBERTa</sup>를 상대할 수 있었다. 그러나, 그건 요약, 대화와 추상화된 QA 데이터셋에서 새로운 SOTA였다. 이 결과들은 텍스트 생성에서 (바트가) 버트/로베르타보다 더 나아지도록 하려는, 동기부여를 강화한다.



<!-- ### Some open questions in NLP

- How should we integrate world knowledge
- How do we model long documents?  (BERT-based models typically use 512 tokens)
- How do we best do multi-task learning?
- Can we fine-tune with less data?
- Are these models really understanding language?
 -->
 
### 자연어처리에서의 몇 가지 열린 질문들

- 세계 지식<sup>world knowledge</sup>을 어떻게 융합할 수 있을까
- 어떻게 긴 문서들을 모델링할 수 있을까? (버트-기반 모델들은 보편적으로 512개의 토큰을 사용한다)
- 어떻게 멀티태스크 학습을 가장 잘 수행할 수 있을까?
- 적은 데이터로 파인 튜닝을 하는게 가능할까?
- 이 모델들이 정말로 언어를 이해하고 있는 것일까?



<!-- ### Summary

- Training models on lots of data beats explicitly modelling linguistic structure.

From a bias variance perspective, Transformers are low bias (very expressive) models. Feeding these models lots of text is better than explicitly modelling linguistic structure (high bias). Architectures should be compressing sequences through bottlenecks

- Models can learn a lot about language by predicting words in unlabelled text. This turns out to be a great unsupervised learning objective. Fine tuning for specific tasks is then easy

- Bidirectional context is crucial
 -->
 
### 요약

- 모델을 많은 데이터로 트레이닝하는 것이, 명백한 언어학적 구조의 모델링을 이긴다. 

편향과 분산 관점에서, 트랜스포머는 편향이 낮은 (표현력이 좋은) 모델들이다. 많은 양의 텍스트를 이 모델들에 집어넣는 것이 명백한 언어학적 구조의 모델 (편향이 높음)보다 낫다. 
아키텍쳐는 병목지점을 통과하며 압축되는 시퀀스들이어야 한다. 

- 모델은 라벨링되지 않은 텍스트에서 단어들을 추측하는 것으로 언어에 대해 많은 것을 배울 수 있다. 이는 훌륭한 비지도 학습 목표로 밝혀진 바 있다. 세부적인 과제들에 대한 파인 튜닝은 더 쉬워진다. 

- 양방향 맥락이 결정적이다.



<!-- ### Additional Insights from questions after class:

What are some ways to quantify 'understanding language’? How do we know that these models are really understanding language?

"The trophy did not fit into the suitcase because it was too big”: Resolving the reference of ‘it’ in this sentence is tricky for machines. Humans are good at this task. There is a dataset consisting of such difficult examples and humans achieved 95% performance on that dataset. Computer programs were able to achieve only around 60% before the revolution brought about by Transformers. The modern Transformer models are able to achieve more than 90% on that dataset. This suggests that these models are not just memorizing / exploiting the data but learning concepts and objects through the statistical patterns in the data.

Moreover, BERT and RoBERTa achieve superhuman performance on SQUAD and Glue. The textual summaries generated by BART look very real to humans (high BLEU scores). These facts are evidence that the models do understand language in some way.
 -->

### 강의 후의 질문들로부터 얻을 수 있는 추가적인 인사이트:

'언어를 이해한다'는 것을 정량화 할 수 있는 방법들은 무엇인가? 어떻게 이 모델들이 정말로 언어를 이해했는지를 알 수 있을까?

"트로피는 너무 크기 때문에, 여행가방에는 맞지 않다."<sup>"The trophy did not fit into the suitcase because it was too big”</sup>: 기계들이 이 문장에서 '그것'<sup>it</sup>이 뭘 가리키는지를 알아내기란 어렵다. 인간들은 이 과제를 잘 해낸다. 이런 어려운 예시들로 구성된 데이터셋에서 인간은 95%의 성능을 달성했다. 컴퓨터 프로그램은 트랜스포머가 혁신을 가져다주기 전까지, 고작 60% 언저리 성능만을 달성했을 뿐이다. 최근의 트랜스포머 모델들은 저 데이터셋에서 90% 이상을 달성할 수 있다. 이는 이 모델들이 데이터를 단순히 암기/활용만 하는 것이 아니라, 데이터 내부의 통계학적인 패턴을 따라 개념과 목표들을 학습하고 있음을 시사한다. 

더군다나, 버트와 로베르타는 SQUAD와 Glue에서 인간을 뛰어넘는 성능을 달성했다. 바트로 생성한 요약본들은 사람들에게도 진짜(사람이 쓴 것)처럼 보인다. (높은 BLEU 점수) 이러한 사실들은 모델이 어떤 방식으로든 언어를 이해하고 있음을 나타내는 증거라고 볼 수 있다.

 

<!-- #### Grounded Language

Interestingly, the lecturer (Mike Lewis, Research Scientist, FAIR) is working on a concept called ‘Grounded Language’. The aim of that field of research is to build conversational agents that are able to chit-chat or negotiate. Chit-chatting and negotiating are abstract tasks with unclear objectives as compared to text classification or text summarization.
 -->
 
#### 기초 언어

흥미롭게도, 강의자 (Mike Lewis, Research Scientist, FAIR)는 '기초 언어'라고 불리우는 개념을 연구하고 있다. 이 연구 분야의 목적은 칫-챗<sup>chit-chat</sup>이나 협상 가능한, 대화가 가능한 에이전트를 만드는 것이다. 칫채팅<sup>chit-chatting</sup> 그리고 협상은 텍스트 분류나 텍스트 요약과 비교해서 (상대적으로) 불확실한 목표들과 함께해야 하는 추상 과제들이다.



<!-- #### Can we evaluate whether the model already has world knowledge?

‘World Knowledge’ is an abstract concept. We can test models, at the very basic level, for their world knowledge by asking them simple questions about the concepts we are interested in.  Models like BERT, RoBERTa and T5 have billions of parameters. Considering these models are trained on a huge corpus of informational text like Wikipedia, they would have memorized facts using their parameters and would be able to answer our questions. Additionally, we can also think of conducting the same knowledge test before and after fine-tuning a model on some task. This would give us a sense of how much information the model has ‘forgotten’.
 -->
 
#### 모델이 이미 세계 지식을 갖고 있는지 아닌지 측정할 수 있을까?

'세계 지식'은 추상적 개념이다. 우리가 관심있는 개념들에 대해 간단한 질문들을 모델에 하는 식으로, 매우 기본적인 수준에서만 그들의 세계 지식을 테스트할 수 있다. 버트나 로베르타, T5같은 모델들은 수십억개의 파라미터를 갖고 있다. 이런 모델들을 위키피디아같은 비격식적인 텍스트들의 거대한 언어 자료로 트레이닝하는 걸 생각해보면, 파라미터들을 사실을 암기하는데에 사용하고는 우리가 하는 질문들에 대해 답변 할 수 있을 것이다. 추가로, 모델을 어떤 과제를 위한 파인튜닝하기 전후로, 동일한 지식 테스트를 (모델들에) 수행하는 것도 생각해볼 수 있다. 이는 얼마나 많은 정보들을 모델이 '망각'해야하는지에 대한 느낌을 알려준다. 
