---
lang-ref: ch.08-1
lecturer: Yann LeCun
title: 에너지 기반 모델의 대조적 방법 
authors: Vishwaesh Rajiv, Wenjun Qu, Xulai Jiang, Shuya Zhao
date: 23 Mar 2020
lang: ko
translation-date: 19 Jul 2020
translator: Yujin
---


<!-- ## [Recap](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s) -->
## [복습하기](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=5s)

<!-- Dr. LeCun spent the first ~15 min giving a review of energy-based models. Please refer back to last week (Week 7 notes) for this information, especially the concept of contrastive learning methods. -->
르쿤 박사는 처음 15분 동안 에너지 기반 모델에 대한 복습을 진행했다. 이와 관련한 정보, 특히 대조 학습 방법에 대해서는 지난주 (7주차 노트)를 다시 참조하기 바란다. 

<!-- As we have learned from the last lecture, there are two main classes of learning methods:
1. Contrastive Methods that push down the energy of training data points, $F(x_i, y_i)$, while pushing up energy on everywhere else, $F(x_i, y’)$.
2. Architectural Methods that build energy function $F$ which has minimized/limited low energy regions by applying regularization. -->
지난주 강의에서 알아보았듯, 에너지 기반 모델을 훈련시키는 방법에는 크게 두 종류가 있다:
1. 다른 부분의 에너지 값을 올리면서, $F(x_i, y’)$, 훈련 데이터 포인트의 에너지를 낮추는 대조적 방법<sup>Contrastive Methods</sup>, $F(x_i, y_i)$
2. 정규화<sup>regularization</sup> 방식을 이용해 낮은 에너지 영역을 최소화/제한하는 에너지 함수 $F$ 를 만드는 구조적 방법<sup>Architectural Methods</sup> 

<!-- To distinguish the characteristics of different training methods, Dr. Yann LeCun has further summarized 7 strategies of training from the two classes mention before. One of which is methods that are similar to Maximum Likelihood method, which push down the energy of data points and push up everywhere else. -->
각기 다른 훈련 방법의 특징을 구별하기 위해, 얀 르쿤 박사는 이전에 언급한 두 종류의 방법에 대한 7가지 훈련 전략을 추가로 요약한다. 그 중 하나는 최대 우도 방법<sup>Maximum Likelihood method</sup>과 유사한 방법으로, 데이터 포인트의 에너지를 낮추고 다른 곳의 에너지를 모두 증가시키는 방법이다. 

<!-- Maximum Likelihood method probabilistically pushes down energies at training data points and pushes everywhere else for every other value of $y’\neq y_i$. Maximum Likelihood doesn't “care” about the absolute values of energies but only “cares” about the difference between energy. Because the probability distribution is always normalized to sum/integrate to 1, comparing the ratio between any two given data points is more useful than simply comparing absolute values. -->
최대 우도 방법은 훈련 데이터 포인트의 에너지 값들을 확률적으로 낮추고, $y’\neq y_i$ 인 다른 모든 데이터의 에너지 값들을 낮춘다. 최대 우도는 에너지의 절대값이 아닌 오직 에너지의 차이에만 "관심"을 둔다. 확률 분포의 합은 항상 1이 되도록 정규화되기 때문에, 주어진 두 개의 데이터 포인트 사이의 비율을 비교하는 것이 단순히 각각의 절대값을 비교하는 것 보다 유용하다. 


<!-- ## [Contrastive methods in self-supervised learning](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s) -->
## [자기 지도 학습<sup>self-supervised learning</sup>에서의 대조적 방법<sup>contrastive mothods</sup>](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=613s)

<!-- In contrastive methods, we push down on the energy of observed training data points ($x_i$, $y_i$), while pushing up on the energy of points outside of the training data manifold. -->
대조적 방법에서는, 관측된 훈련 데이터 포인트 ($x_i$, $y_i$) 의 에너지를 낮추고, 훈련 데이터 매니폴드<sup>manifold</sup> 외부에 존재하는 데이터 포인트들의 에너지를 높인다. 

<!-- In self-supervised learning, we use one part of the input to predict the other parts. We hope that our model can produce good features for computer vision that rival those from supervised tasks. -->
자기 지도 학습<sup>self-supervised learning</sup>에서는, 입력의 한 부분을 사용해서 다른 부분을 예측한다. 우리는 이러한 모델이 지도 학습<sup>supervised learning</sup>으로 훈련된 모델에 맞먹는 수준으로, 컴퓨터 비전<sup>computer vision</sup>에 유용한 특징들을 생성해 낼 수 있길 바란다. 

<!-- Researchers have found empirically that applying contrastive _embedding_ methods to self-supervised learning models can indeed have good performances which rival that of supervised models. We will explore some of these methods and their results below. -->
연구자들은 대조적 _임베딩_ 방법<sup>contrastive _embedding_ methods</sup>을 자기 지도 학습에 적용하는 것이 지도 학습 모델과 필적하는 좋은 성능을 내놓을 수 있음을 경험적으로 발견했다. 아래에서 이 방법의 일부와 그 결과에 대해 살펴본다. 


<!-- ### Contrastive embedding -->
### 대조적 임베딩<sup>Contrastive embedding</sup>

<!-- Consider a pair ($x$, $y$), such that $x$ is an image and $y$ is a transformation of $x$ that preserves its content (rotation, magnification, cropping, *etc.*). We call this a **positive** pair. -->
$x$ 가 이미지이고 $y$ 가 $x$ 의 내용(회전, 확대, 자르기, *등등.*)을 유지하는 변형<sup>transformation</sup>인 ($x$, $y$)쌍을 생각해보자. 우리는 이것을 **positive** 쌍<sup>양의 쌍</sup>이라고 부른다.

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>Fig. 1</b>: Positive Pair
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig1.png" width="50%"/><br>
<b>그림. 1</b>: Positive 쌍<sup>양의 쌍</sup>
</center>

<!-- Conceptually, contrastive embedding methods take a convolutional network, and feed $x$ and $y$ through this network to obtain two feature vectors: $h$ and $h'$. Because $x$ and $y$ have the same content (*i.e.* a positive pair), we want their feature vectors to be as similar as possible. As a result, we choose a similarity metric (such as cosine similarity) and a loss function that maximizes the similarity between $h$ and $h'$. By doing this, we lower the energy for images on the training data manifold. -->
개념적으로, 대조적 임베딩<sup>contrastive embedding</sup> 방법은 합성곱 신경망의 방식을 취하고 $x$ 와 $y$ 를 이 신경망에 입력하여 두 개의 특징 벡터<sup>feature vectors</sup> $h$ 와 $h'$ 를 얻는다. $x$ 와 $y$ 는 같은 내용 (*즉* positive 쌍)을 가지기 때문에, 우리는 이들의 특징 벡터가 가능한 한 비슷한 값을 가지길 바란다. 결과적으로, 우리는 $h$ 와 $h'$ 사이의 유사도를 최대화 하는 유사성 메트릭<sup>similarity metric</sup> (예를 들어 코사인 유사도<sup>cosine similarity</sup>) 과 손실 함수를 선택한다. 이렇게 함으로써, 우리는 훈련 데이터 매니폴드의 이미지가 갖는 에너지 값을 낮춘다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>Fig. 2</b>: Negative Pair
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig2.png" width="50%"/><br>
<b>그림. 2</b>: Negative 쌍<sup>음의 쌍</sup>
</center>

<!-- However, we also have to push up on the energy of points outside this manifold. So we also generate **negative** samples ($x_{\text{neg}}$, $y_{\text{neg}}$), images with different content (different class labels, for example). We feed these to our network above, obtain feature vectors $h$ and $h'$, and now try to minimize the similarity between them. -->
하지만, 이 매니폴드 바깥 포인트들의 에너지 또한 올려야한다. 따라서 **negative** 샘플, ($x_{\text{neg}}$, $y_{\text{neg}}$), 내용이 다른 이미지 (예를 들어, 다른 클래스 레이블)도 만들어낸다. 우리는 위의 네트워크에 이를 투입하고, 특징 벡터 $h$ 와 $h'$ 를 얻고, 이들 사이의 유사성을 최소화하고자 노력한다. 

<!-- This method allows us to push down on the energy of similar pairs while pushing up on the energy of dissimilar pairs. -->
이 방법은 유사한 쌍들의 에너지 값을 낮추고, 유사하지 않은 쌍들의 에너지 값을 높이도록 한다.

<!-- Recent results (on ImageNet) have shown that this method can produce features that are good for object recognition that can rival the features learned through supervised methods. -->
ImageNet에 대한 최근의 결과는 이 방법이 지도학습을 통해 얻어진 특징들과 필적할 만한 수준의 객체 인식<sup>object recognition</sup>에 적합한 특징들을 만들어 낼 수 있음을 보였다. 


<!-- ### Self-Supervised Results (MoCo, PIRL, SimCLR) -->
### 자기 지도 학습<sup>Self-Supervised</sup> 결과 (MoCo, PIRL, SimCLR)

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>Fig. 3</b>: PIRL and MoCo on ImageNet
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig3.png" height="75%" width="75%"/><br>
<b>그림. 3</b>: ImageNet에 대한 PIRL 과 MoCo 
</center>

<!-- As seen in the figure above, MoCo and PIRL achieve SOTA results (especially for lower-capacity models, with a small number of parameters). PIRL is starting to approach the top-1 linear accuracy of supervised baselines (~75%). -->
위의 그림에서 볼 수 있듯, MoCo 와 PIRL 은 (특히 적은 수의 매개 변수를 사용하는 저용량<sup>low-capacity</sup>모델에 대해) 가장 높은 성과<sup>SOTA, state of the art</sup>를 보였다. PIRL 은 지도학습 기준선 (~75%)의 top-1 선형 정확도에 접근하기 시작했다. 

<!-- We can understand PIRL more by looking at its objective function: NCE (Noise Contrastive Estimator) as follows. -->
다음과 같은 목적함수 NCE (Noise Contrastive Estimator)를 통해 PIRL을 더 잘 이해할 수 있다.

$$
h(v_I,v_{I^t})=\frac{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]}{\exp\big[\frac{1}{\tau}s(v_I,v_{I^t})\big]+\sum_{I'\in D_{N}}\exp\big[\frac{1}{\tau}s(v_{I^t},v_{I'})\big]}
$$

$$
L_{\text{NCE}}(I,I^t)=-\log\Big[h\Big(f(v_I),g(v_{I^t})\Big)\Big]-\sum_{I'\in D_N}\log\Big[1-h\Big(g(v_{I^t}),f(v_{I'})\Big)\Big]
$$

<!-- Here we define the similarity metric between two feature maps/vectors as the cosine similarity. -->
여기에서는 두 특징 맵<sup>maps</sup> 혹은 특징 벡터 사이의 유사성 메트릭을 코사인 유사도<sup>cosine similarity</sup>로 정의한다. 

<!-- What PIRL does differently is that it doesn't use the direct output of the convolutional feature extractor. It instead defines different _heads_ $f$ and $g$, which can be thought of as independent layers on top of the base convolutional feature extractor. -->
PIRL이 다르게 수행하는 부분은 합성곱 특징 추출기<sup>convolutional feature extractor</sup> 에서 바로 나온 직접 출력은 사용하지 않는다는 것이다. 대신에 다른 _heads_ $f$ 와 $g$ 를 정의하는데, 이는 기본 합성곱 특징 벡터 추출기 위의 독립적인 레이어<sup>independent layers</sup>로 생각할 수 있다. 

<!-- Putting everything together, PIRL's NCE objective function works as follows. In a mini-batch, we will have one positive (similar) pair and many negative (dissimilar) pairs. We then compute the similarity between the transformed image's feature vector ($I^t$) and the rest of the feature vectors in the minibatch (one positive, the rest negative). We then compute the score of a softmax-like function on the positive pair. Maximizing a softmax score means minimizing the rest of the scores, which is exactly what we want for an energy-based model. The final loss function, therefore, allows us to build a model that pushes the energy down on similar pairs while pushing it up on dissimilar pairs. -->
종합하자면, PIRL'의 NCE 목적 함수는 다음과 같이 동작한다. 미니 배치<sup>mini-batch</sup>에서, 하나의 positive (유사한) 쌍과, 다수의 negative (유사하지 않은) 쌍을 갖게 된다. 다음으로 변환된 이미지의 특징 벡터 ($I^t$) 와 미니 배치 안의 나머지 특징 벡터 (positive 한 개, 나머지 negative) 사이의 유사도를 계산한다. 다음 단계로 positive 쌍에서 소프트맥스 같은<sup>softmax-like</sup> 함수로 점수<sup>score</sup>를 계산한다. 소프트맥스 점수를 최대화 하는 것은 나머지 점수를 최소화 하는 것과 같고, 이것이 바로 우리가 에너지 기반 모델에서 원하는 것이다. 따라서 최종 손실 함수를 사용해서 유사한 쌍에서는 에너지를 낮추게 하고, 유사하지 않은 쌍에서는 에너지를 높이도록 하는 모델을 만들 수 있다. 

<!-- Dr. LeCun mentions that to make this work, it requires a large number of negative samples. In SGD, it can be difficult to consistently maintain a large number of these negative samples from mini-batches. Therefore, PIRL also uses a cached memory bank. -->
르쿤 박사는 이 작업을 완수하기 위해서는 많은 양의 negative 샘플이 필요하다고 언급한다. SGD에서는 미니배치에서 많은 수의 negative 샘플을 일관적으로 유지하는 것이 어려울 수 있다. 따라서 PIRL은 캐시 된 메모리 뱅크<sup>cached memory bank</sup>도 사용한다.

<!-- **Question**: Why do we use cosine similarity instead of L2 Norm?
Answer: With an L2 norm, it's very easy to make two vectors similar by making them "short" (close to centre) or make two vectors dissimilar by making them very "long" (away from the centre). This is because the L2 norm is just a sum of squared partial differences between the vectors. Thus, using cosine similarity forces the system to find a good solution without "cheating" by making vectors short or long. -->
**질문**: 왜 L2 정규화<sup>L2 Norm</sup> 대신에 코사인 유사도를 사용하는가? 
답: L2 정규화를 사용하면, 두 벡터를 "짧게" (중앙에 가깝게) 만들어서 둘을 유사하게 만들거나, 또는 두 벡터를 매우 "길게" (중앙에서 멀리 떨어지게) 만들어 유사하지 않도록 만들기 매우 쉽다. 이는 L2 정규화가 단순히 벡터 간의 편미분 제곱 합이기 때문이다. 따라서 코사인 유사도를 사용하는 것은 시스템이 벡터를 짧게 또는 길게 하는 "속임수" 없이 좋은 해결 방안을 찾도록 한다. 


### SimCLR

<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>Fig. 4</b>: SimCLR Results on ImageNet
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig5.png" height="75%" width="75%"/><br>
<b>그림. 4</b>: ImageNet에 대한 SimCLR 결과
</center>

<!-- SimCLR shows better results than previous methods. In fact, it reaches the performance of supervised methods on ImageNet, with top-1 linear accuracy on ImageNet. The technique uses a sophisticated data augmentation method to generate similar pairs, and they train for a massive amount of time (with very, very large batch sizes) on TPUs. Dr. LeCun believes that SimCLR, to a certain extend, shows the limit of contrastive methods. There are many, many regions in a high-dimensional space where you need to push up the energy to make sure it's actually higher than on the data manifold. As you increase the dimension of the representation, you need more and more negative samples to make sure the energy is higher in those places not on the manifold. -->
SimCLR은 이전 방법들보다 나은 결과를 보인다. 실제로, ImageNet에 대해 top-1 선형 정확도를 보이며, ImageNet에 대해 지도학습된 모델의 성과에 도달한다. 이 기법은 정교한 데이터 확대 기법<sup>data augmentation method</sup>를 이용하여 유사한 쌍을 생성하고, TPU에서 오랜 시간 동안 (굉장히 큰 배치 크기로) 학습한다. 르쿤 박사는 SimCLR이 어느 정도 대조 기법의 한계를 보여준다고 생각한다. 고차원<sup>hihg-dimensional</sup> 공간에는 데이터 매니폴드보다 확실히 에너지를 높이기 위해 에너지를 끌어 올려야 하는 굉장히 많은 영역이 있다. 표현<sup>representation</sup>의 차수를 늘림에 따라, 매니폴드가 아닌 영역의 에너지가 명확하게 높아지도록 더 많은 수의 negative 샘플이 필요하다. 


<!-- ## [Denoising autoencoder](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s) -->
## [디노이징 오토인코더<sup>Denoising autoencoder</sup>](https://www.youtube.com/watch?v=ZaVP2SY23nc&t=1384s)

<!-- In [week 7's practicum](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/), we discussed denoising autoencoder. The model tends to learn the representation of the data by reconstructing corrupted input to the original input. More specifically, we train the system to produce an energy function that grows quadratically as the corrupted data move away from the data manifold. -->
[7 주차 실습](https://atcold.github.io/pytorch-Deep-Learning/en/week07/07-3/) 에서는 디노이징 오토인코더에 대해 논의했다. 이 모델은 손상된 입력을 원래의 입력으로 재구성해 나가면서 데이터 표현<sup>data representation</sup>을 학습하는 경향을 보인다. 조금 더 구체적으로 말하자면, 손상된 데이터가 데이터 매니폴드에서 멀어짐에 따라 에너지 함수가 2차적으로<sup>quadratically</sup> 증가하도록 시스템을 훈련시킨다. 


<!-- <center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>Fig. 5</b>: Architecture of denoising autoencoder
</center> -->
<center>
<img src="{{site.baseurl}}/images/week08/08-1/fig6.png" height="75%" width="75%"/><br>
<b>그림. 5</b>: 디노이징 오토인코더의 구조
</center>


<!-- ### Issues -->
### 문제점<sup>Issues</sup>

<!-- However, there are several problems with denoising autoencoders. One problem is that in a high dimensional continuous space, there are uncountable ways to corrupt a piece of data. So there is no guarantee that we can shape the energy function by simply pushing up on lots of different locations. Another problem with the model is that it performs poorly when dealing with images due to the lack of latent variables. Since there are many ways to reconstruct the images, the system produces various predictions and doesn't learn particularly good features. Besides, corrupted points in the middle of the manifold could be reconstructed to both sides. This will create flat spots in the energy function and affect the overall performance. -->
그러나, 디노이징 오토인코더에는 몇 가지 문제점이 있다. 한 문제점은 고차원 연속 공간<sup>high dimensioanl continuous space</sup>에서 데이터 조각을 손상시키는 수 많은 방법들이 존재한다는 점이다. 이와 같은 이유로, 많은 위치에서 단순히 에너지를 높여 나가며 에너지 함수를 형성해 나갈 수 있다는 보장을 할 수 없다. 또한 이 모델은 잠재 변수를 갖지 않기 때문에 이미지 처리에 있어 성과가 낮은 것도 문제이다. 이미지를 재구성하는 데에는 다양한 방법이 있기 때문에, 시스템은 다양한 예측을 내놓고 특별히 좋은 특징을 학습하지는 않는다. 게다가, 매니폴드 중앙의 손상된 데이터 포인트들은 양쪽으로 재구성될 수 있다. 이는 에너지 함수에 편평한 지점을 만들고 전반적인 성능에 영향을 준다. 


<!-- ## Other Contrastive Methods -->
## 다른 대조 방법들<sup>Other contrastive Methods</sup>

<!-- There are other contrastive methods such as contrastive divergence, Ratio Matching, Noise Contrastive Estimation, and Minimum Probability Flow. We will briefly discuss the basic idea of contrastive divergence. -->
대조 발산<sup>contrastive divergence</sup>, Ratio Matching<sup>비율 매칭</sup>, Noise Contrastive Estimation<sup>노이즈 대조 추정</sup>, 그리고 Minimum Probability Flow<sup>최소 확률 흐름</sup> 과 같은 다른 대조 방법들이 존재한다. 대조 발산의 기본 개념에 대해 간단히 논의해 본다. 


<!-- ### Contrastive Divergence -->
### 대조 발산 

<!-- Contrastive divergence (CD) is another model that learns the representation by smartly corrupting the input sample. In a continuous space, we first pick a training sample $y$ and lower its energy. For that sample, we use some sort of gradient-based process to move down on the energy surface with noise. If the input space is discrete, we can instead perturb the training sample randomly to modify the energy. If the energy we get is lower, we keep it. Otherwise, we discard it with some probability. Keep doing so will eventually lower the energy of $y$. We can then update the parameter of our energy function by comparing $y$ and the contrasted sample $\bar y$ with some loss function. -->
대조 발산(CD, Contrastive Divergence)은 입력 샘플을 똑똑하게 손상시켜서 데이터 표현을 학습하는 또 다른 모델이다. 연속 공간에서, 먼저 훈련 샘플 $y$를 고르고 이것의 에너지를 낮춘다. 이 샘플에 대해서 우리는 일종의 그래디언트에 기반한 과정<sup>gradient-based process</sup>을 사용해서 노이즈가 있는 에너지 표면에서 아래로 이동한다. 만일 입력 공간이 이산적이라면, 에너지를 수정하기 위해 훈련 샘플을 무작위로 교란시킬 수 있다. 만일 얻어진 에너지 값이 낮으면 가지고 있는다. 에너지 값이 낮지 않다면, 어떤 확률값에 따라 그것을 버린다. 이러한 과정을 계속하면 결국 $y$의 에너지 값이 낮아진다. 이 다음, $y$와 이것의 대조 샘플 $\bar y$의 손실함수 값을 비교하여 매개 변수를 업데이트 할 수 있다.


<!-- ### Persistent Contrastive Divergence -->
### Persistent Contrastive Divergence<sup>지속적 대조 발산</sup>

<!-- One of the refinements of contrastive divergence is persistent contrastive divergence. The system uses a bunch of "particles" and remembers their positions. These particles are moved down on the energy surface just like what we did in the regular CD. Eventually, they will find low energy places in our energy surface and will cause them to be pushed up. However, the system does not scale well as the dimensionality increases. -->
대조 발산의 개선된 모델 중 하나는 persistent contrastive divergence이다. 이 시스템은 많은 "입자<sup>particles</sup>"를 사용하고 그 위치를 기억한다. 이 입자들은 기존의 대조 발산<sup>CD, Contrastive Divergence</sup>에서 그랬던 것 처럼 에너지 표면에서 아래로 이동한다. 결국, 이 입자들은 에너지 표면 상에서 낮은 에너지들의 위치를 파악하고 이들의 에너지를 높일 것이다. 그러나 이 시스템은 차원의 확장에 따른 스케일 조절이 잘 되지 않는다. 