---
lang-ref: ch.07-3
title: 오토인코더<sup>Autoencoders</sup> 입문
lecturer: 앨프레도 캔지아니
authors: Xinmeng Li, Atul Gandhi, Li Jiang, Xiao Li
date: 10 March 2020
lang: ko
translation-date: 02 Oct 2020
translator: Yujin
---


<!-- ## [Application of autoencoders](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s) -->
## [오토인코더 응용](https://www.youtube.com/watch?v=bggWQ14DD9M&t=55s)


<!-- ### Image generation -->
### 이미지 생성

<!-- Can you tell which face is fake in Fig. 1? In fact, both of them are produced by the StyleGan2 generator. Although the facial details are very realistic, the background looks weird (left: blurriness, right: misshapen objects). This is because the neural network is trained on faces samples. The background then has a much higher variability. Here the data manifold has roughly 50 dimensions, equal to the degrees of freedom of a face image. -->
그림. 1 에서 어떤 얼굴이 가짜인지 알 수 있을까? 사실 두 사진 모두 StyleGan2 생성기로부터 만들어진 이미지이다. 얼굴 자체의 세세한 부분은 매우 사실적이지만, 배경은 이상하게 보인다 (왼쪽: 흐릿함, 오른쪽: 기형의 물체). 이는 신경망이 얼굴 샘플에 대해서 훈련되기 때문이다. 배경은 훨씬 더 높은 변동성<sup>variability</sup>를 갖는다. 여기서 데이터 매니폴드<sup>manifold</sup>는 얼굴 이미지의 자유도<sup>degrees of freedom</sup>와 동일한 대략 50 차원을 갖는다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>Fig. 1</b>: Faces generated from StyleGan2
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/1_faces_gen.jpg" height="150px" /><br>
<b>그림. 1</b>: StyleGan2을 통해 생성된 얼굴들
</center>


<!-- ### Difference of Interpolation in Pixel Space and Latent Space -->
픽셀 공간<sup>Pixel Space</sup>와 잠재 공간<sup>Latent Space</sup> 사이의 보간<sup>Interpolation</sup> 차이 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>Fig. 2</b>: A dog and a bird
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/2_dog.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/2_bird.jpg" height="120px"/>
<br>
<b>그림. 2</b>: 개와 새
</center>

<!-- If we linearly interpolate between the dog and bird image (Fig. 2) in pixel space, we will get a fading overlay of two images in Fig. 3. From the top left to the bottom right, the weight of the dog image decreases and the weight of the bird image increases. -->
픽셀 공간에서 개와 새의 이미지 (그림. 2)를 선형으로 보간하면<sup>linearly interpolate</sup>, 그림. 3에서 볼 수 있듯 두 이미지의 페이딩 오버레이<sup>fading overlay</sup>가 나타난다. 왼쪽 상단에서 오른쪽 하단으로 갈수록, 개 이미지의 가중치가 감소하고 새 이미지의 가중치는 증가한다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>Fig. 3</b>: Results after interpolation
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/3_dog2bird.jpg" height="200px"/><br>
<b>그림. 3</b>: 보간의 결과
</center>

<!-- If we interpolate on two latent space representation and feed them to the decoder, we will get the transformation from dog to bird in Fig. 4. -->
만일 두 개의 잠재 공간 표현<sup>latent space representation</sup>을 보간하고 디코더<sup>decoder</sup>에 투입하면, 그림. 4에서 확인할 수 있듯, 개에서 새로의 변환<sup>transformation</sup>을 얻는다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>Fig. 4</b>: Results after feeding into decoder
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/4_model_d2b.jpg" height="200px"/><br>
<b>그림. 4</b>: 디코더에 투입한 결과
</center>

<!-- Obviously, latent space is better at capturing the structure of an image. -->
당연하게도, 잠재 공간이 이미지 구조를 파악하는데 더욱 좋다. 


<!-- ### Transformation Examples -->
### 변환 예시<sup>Transformation Examples</sup>


<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>Fig. 5</b>: Zoom
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/5_zoom1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/5_zoom2.jpg
" height="120px"/>
<br>
<b>그림. 5</b>: 확대<sup>Zoom</sup>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>Fig. 6</b>: Shift
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/6_shift1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/6_shift2.jpg
" height="120px"/>
<br>
<b>그림. 6</b>: 이동<sup>Shift</sup>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>Fig. 7</b>: Brightness
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/7_bright1.jpg
" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/7_bright2.jpg" height="120px"/>
<br>
<b>그림. 7</b>: 밝기<sup>Brightness</sup>
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>Fig. 8</b>: Rotation (Note that the rotation could be 3D)
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/8_rotation1.jpg" height="120px"/><img src="{{site.baseurl}}/images/week07/07-3/8_rotation2.jpg" height="120px"/>
<br>
<b>그림. 8</b>: 회전<sup>Rotation</sup> (회전은 3D 일 수 있음)
</center>


<!-- ### Image Super-resolution -->
### 이미지 초 고해상도<sup>Super-resolution</sup>

<!-- This model aims to upscale images and reconstruct the original faces. From left to right in Fig. 9, the first column is the 16x16 input image, the second one is what you would get from a standard bicubic interpolation, the third is the output generated by the neural net, and on the right is the ground truth. (https://github.com/david-gpu/srez) -->
이 모델은 이미지의 해상도를 높이고<sup>upscale images</sup>, 원래 얼굴을 재건하는 것을 목표로 한다. 그림.9 에서 왼쪽에서 오른쪽으로 첫 번째 열은 16x16 입력 이미지이고, 두 번째는 표준 bicubic 보간<sup>Standard bicubic interpolation</sup>을 통해 얻을 수 있는 이미지이고, 세 번째는 신경망에 의해 생성된 출력이며, 마지막 오른쪽은 실제<sup>ground truth</sup> 이미지이다. (https://github.com/david-gpu/srez)

<!-- <center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>Fig. 9</b>: Reconstructing original faces
</center> -->
<center><img src="{{site.baseurl}}/images/week07/07-3/9_reconstruct.jpg" height="120px"/>
<br>
<b>그림. 9</b>: 원래 얼굴 재건하기<sup>reconstructing original faces</sup>
</center>

<!-- From the output images, it is clear that there exist biases in the training data, which makes the reconstructed faces inaccurate. For example, the top left Asian man is made to look European in the output due to the imbalanced training images. The reconstructed face of the bottom left women looks weird due to the lack of images from that odd angle in the training data. -->
출력 이미지에서 학습 데이터에 편향<sup>bias</sup>이 있어서 재건된 얼굴이 부정확함을 분명하게 알 수 있다. 예를 들어서, 왼쪽 상단 아시안 남자는 불균형한 훈련 이미지 데이터로 인해 유럽인처럼 보이는 이미지로 출력되었다. 왼쪽 하단에서 여성의 재건된 얼굴 이미지의 경우, 훈련 데이터에서 다양한 각도에서 촬영된 이미지가 부족하여 이상하게 보인다. 


<!-- ### Image Inpainting -->
### 이미지 복원<sup>inpainting</sup>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>Fig. 10</b>: Putting grey patch on faces
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/10_facepatch.jpg" height="120px"/>
<br>
<b>그림. 10</b>: 얼굴에 회식 패치<sup>patch</sup> 넣기 
</center>

<!-- Putting a grey patch on the face like in Fig. 10 makes the image away from the training manifold. The face reconstruction in Fig. 11 is done by finding the closest sample image on the training manifold via Energy function minimization. -->
그림. 10과 같이 얼굴에 회색 패치를 넣으면 이미지가 훈련 매니폴드에서 멀어진다. 그림. 11의 얼굴 재건은 에너지 함수 최소화<sup>Energy function minimization</sup>를 통해 훈련 매니폴드에서 가장 가까운 샘플 이미지를 찾아 수행된다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>Fig. 11</b>: Reconstructed image of <b>Fig. 10</b>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/11_fixfacepatch.jpg" height="120px"/>
<br>
<b>그림. 11</b>: <b>그림. 10</b>에서 재건된 이미지
</center>


<!-- ### Caption to Image -->
### 이미지 설명(캡션)<sup>caption</sup>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>Fig. 12</b>: Caption to Image example
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/12_caption.jpg" height="50px"/><img src="{{site.baseurl}}/images/week07/07-3/12_capimage.jpg" height="150px"/>
<br>
<b>그림. 12</b>: 이미지 예시에 대한 설명
</center>

<!-- The translation from text description to image in Fig. 12 is achieved by extracting text features representations associated with important visual information and then decoding them to images. -->
그림 12의 텍스트 설명에서 이미지로의 번역은 중요한 시각적 정보와 관련된 텍스트의 특징 표현을 추출하고, 이를 이미지로 디코딩하여 이루어진다. 


<!-- ## [What are autoencoders?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s) -->
## [오토인코더는 무엇인가?](https://www.youtube.com/watch?v=bggWQ14DD9M&t=879s)

<!-- Autoencoders are artificial neural networks, trained in an unsupervised manner, that aim to first learn encoded representations of our data and then generate the input data (as closely as possible) from the learned encoded representations. Thus, the output of an autoencoder is its prediction for the input. -->
오토인코더는 비지도<sup>unsupervised</sup> 방식으로 훈련된 인공 신경망으로, 먼저 데이터에 인코딩 된 표현을 학습한 다음, 학습 된 인코딩 표현에서 입력 데이터를 (가능한한 가깝게) 생성하는 것을 목표로 한다. 따라서, 오토인코더의 출력은 입력에 대한 예측이다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>Fig. 13</b>: Architecture of a basic autoencoder<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/13_ae_structure.png" width="40%"/> <br>
<b>그림. 13</b>: 기본 오토인코더의 아키텍쳐<sup>architecture</sup><br>
</center>

<!-- Fig. 13 shows the architecture of a basic autoencoder. As before, we start from the bottom with the input $\boldsymbol{x}$ which is subjected to an encoder (affine transformation defined by $\boldsymbol{W_h}$, followed by squashing). This results in the intermediate hidden layer $\boldsymbol{h}$. This is subjected to the decoder(another affine transformation defined by $\boldsymbol{W_x}$ followed by another squashing). This produces the output $\boldsymbol{\hat{x}}$, which is our model's prediction/reconstruction of the input. As per our convention, we say that this is a 3 layer neural network. -->
그림 13은 기본 오토인코더의 아키텍쳐를 보여준다. 이전과 마찬가지로, 인코더 ($\boldsymbol{W_h}$로 정의되는 아핀 변환<sup>affine transformation</sup> 후 스쿼싱<sup>squashing</sup>)를 거치는 입력 $\boldsymbol{x}$으로 맨 아래서부터 시작한다. 이는 중간 은닉층<sup>hiddenn layer</sup> $\boldsymbol{h}$을 형성한다. 이는 디코더 (또 다른 $\boldsymbol{W_x}$ 로 정의되는 아핀 변환 다음에 또 다른 스쿼싱이 뒤따름)의 대상이 된다. 그러면 모델의 입력에 대한 예측/재건인 출력 $\boldsymbol{\hat{x}}$ 이 생성된다. 우리는 이를 관습<sup>convention</sup>에 따라 3층 신경망으로 부른다. 

<!-- We can represent the above network mathematically by using the following equations: -->
다음 방정식을 사용해서 위의 네트워크를 수학적으로 표현할 수 있다: 

$$
\boldsymbol{h} = f(\boldsymbol{W_h}\boldsymbol{x} + \boldsymbol{b_h}) \\
\boldsymbol{\hat{x}} = g(\boldsymbol{W_x}\boldsymbol{h} + \boldsymbol{b_x})
$$

<!-- We also specify the following dimensionalities: -->
또한 다음의 차원을 지정할 수 있다:

$$
\boldsymbol{x},\boldsymbol{\hat{x}} \in \mathbb{R}^n\\
\boldsymbol{h} \in \mathbb{R}^d\\
\boldsymbol{W_h} \in \mathbb{R}^{d \times n}\\
\boldsymbol{W_x} \in \mathbb{R}^{n \times d}\\
$$

<!-- <b>Note:</b> In order to represent PCA, we can have tight weights (or tied weights) defined by $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$ -->
<b>참고:</b> PCA를 나타내기 위해서, $\boldsymbol{W_x}\ \dot{=}\ \boldsymbol{W_h}^\top$ 로 정의된 타이트 가중치<sup>tight weights</sup> (또는 묶인<sup>tied</sup> 가중치)를 가질 수 있다. 


<!-- ## Why are we using autoencoders? -->
## 왜 오토인코더를 사용할까? 

<!-- At this point, you may wonder what the point of predicting the input is and what are the applications of autoencoders. -->
이 시점에서, 입력을 왜 예측할 필요가 있는지, 그리고 오토인코더를 어떻게 응용할 수 있는지 의문을 가질 수 있다. 

<!-- The primary applications of an autoencoder is for anomaly detection or image denoising. We know that an autoencoder's task is to be able to reconstruct data that lives on the manifold *i.e.* given a data manifold, we would want our autoencoder to be able to reconstruct only the input that exists in that manifold. Thus we constrain the model to reconstruct things that have been observed during training, and so any variation present in new inputs will be removed because the model would be insensitive to those kinds of perturbations. -->
오토인코더의 주요<sup>primary</sup> 응용 분야는 이상 감지<sup>anomaly detection</sup> 또는 이미지 노이즈 제거<sup>image denoising</sup>이다. 오토인코더의 작업이 매니폴드 *즉* 주어진 데이터 매니폴드에 있는 데이터를 재건하는 것임을 알고 있고, 오토인코더가 해당 매니폴드 안에 존재하는 입력만 재건할 수 있기를 원한다. 따라서 우리는 모델이 훈련 중에 관찰한 것들만을 재건할 수 있도록 제한하고, 따라서 새로운 입력에 존재하는 어떠한 변화<sup>variation</sup>도 제거되는데, 왜냐하면 이 모델은 이러한 미세한 변화<sup>perturbations</sup>에 영향을 받지 않을<sup>insensitive</sup> 것이기 때문이다. 

<!-- Another application of an autoencoder is as an image compressor. If we have an intermediate dimensionality $d$ lower than the input dimensionality $n$, then the encoder can be used as a compressor and the hidden representations (coded representations) would address all (or most) of the information in the specific input but take less space. -->
오토인코더의 또 다른 응용은 이미지 압축기<sup>compressor</sup>이다. 만일 입력 차원 $n$ 보다 낮은 중간 차원 $d$ 를 갖고 있다면, 인코더는 압축기로 사용될 수 있고, 은닉 표현<sup>hidden representation</sup> (코딩 된 표현)은 특정 입력의 모든 (또는 대부분) 정보를 전달하지만 적은 공간을 차지한다. 

<!-- ## Reconstruction loss -->
## 재건<sup>Reconstruction</sup> 손실

<!-- Let us now look at the reconstruction losses that we generally use. The overall loss for the dataset is given as the average per sample loss i.e. -->
이제 일반적으로 사용하는 재건 손실에 대해 살펴보자. 데이터셋의 전체적인 손실은 샘플 손실 당 평균으로 주어진다. 즉, 

$$
L = \frac{1}{m} \sum_{j=1}^m \ell(x^{(j)},\hat{x}^{(j)})
$$

<!-- When the input is categorical, we could use the Cross-Entropy loss to calculate the per sample loss which is given by -->
입력이 범주형<sup>categorical</sup>이면, 교차 엔트로피 손실<sup>Cross-Entropy loss</sup>를 사용해서 다음과 같은 샘플당 손실을 계산할 수 있다. 

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = -\sum_{i=1}^n [x_i \log(\hat{x}_i) + (1-x_i)\log(1-\hat{x}_i)]
$$

<!-- And when the input is real-valued, we may want to use the Mean Squared Error Loss given by -->
그리고 입력이 실수값<sup>real-valued</sup>, 다음과 같이 주어지는 평균 제곱 오차<sup>Mean Squared Error</sup> 손실을 사용할 수 있다. 

$$
\ell(\boldsymbol{x},\boldsymbol{\hat{x}}) = \frac{1}{2} \lVert \boldsymbol{x} - \boldsymbol{\hat{x}} \rVert^2
$$


<!-- ## Under-/over-complete hidden layer -->
## 완전하지 않은<sup>Under</sup>-/과잉-완전<sup>over-complete</sup> 은닉층<sup>hidden layer</sup>

<!-- When the dimensionality of the hidden layer $d$ is less than the dimensionality of the input $n$ then we say it is under complete hidden layer. And similarly, when $d>n$, we call it an over-complete hidden layer. Fig. 14 shows an under-complete hidden layer on the left and an over-complete hidden layer on the right. -->
은닉층의 $d$ 차원이 입력의 $n$ 차원 보다 작으면 완전<sup>complete</sup> 은닉층 아래에 있다고 말한다. 마찬가지로, $d>n$ 일 때, 과잉-완전<sup>over-complete</sup> 은닉층이라고 부른다. 그림. 14는 왼쪽에서 완전하지 않은<sup>under-complete</sup> 은닉층을 보여주고 과잉-완전 은닉층을 오른쪽에서 보여주고 있다. 


<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>Fig. 14</b>: An under-complete *vs.* an over-complete hidden layer<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/14_over_under_complete.png" width="60%"/> <br>
<b>그림. 14</b>: 완전하지 않은 *vs.* 과잉-완전 은닉층<br>
</center>

<!-- As discussed above, an under-complete hidden layer can be used for compression as we are encoding the information from input in fewer dimensions. On the other hand, in an over-complete layer, we use an encoding with higher dimensionality than the input. This makes optimization easier. -->
위에서 논의한 바와 같이, 완전하지 않은 은닉층은 입력 정보를 더 낮은 차원으로 인코딩하기 때문에 정보를 압축<sup>compression</sup>하는 데에 사용할 수 있다. 반면에, 과잉-완전 층에서는 입력보다 차원이 높은 인코딩을 사용한다. 이는 최적화를 더 용이하게 한다. 

<!-- Since we are trying to reconstruct the input, the model is prone to copying all the input features into the hidden layer and passing it as the output thus essentially behaving as an identity function. This needs to be avoided as this would imply that our model fails to learn anything. Hence, we need to apply some additional constraints by applying an information bottleneck. We do this by constraining the possible configurations that the hidden layer can take to only those configurations seen during training. This allows for a selective reconstruction (limited to a subset of the input space) and makes the model insensitive to everything not in the manifold. -->
입력을 재건하고자 하기 때문에, 이 모델은 모든 입력 특성을 은닉층에 복사하고 출력으로 전달해서 본직적으로 항등 함수<sup>identity function</sup> 으로 기능하는 경향이 있다. 이는 이 모델이 아무것도 학습하지 못했다는 것을 의미하기 때문에 이런 결과는 피해야한다. 따라서, 정보 병목 현상<sup>bottleneck</sup>을 적용해서 추가적인 제약을 해야 한다. 은닉층이 훈련 중에 관찰된 구성으로만 가능 구성을 제한해서 이를 수행한다. 이는 (입력 공간의 하위 집합으로 제한된) 선택적 재건<sup>selective reconstruction</sup> 을 허용하고 매니폴드에 없는 모든 것에는 둔감하게 만든다. 

<!-- It is to be noted that an under-complete layer cannot behave as an identity function simply because the hidden layer doesn't have enough dimensions to copy the input. Thus an under-complete hidden layer is less likely to overfit as compared to an over-complete hidden layer but it could still overfit. For example, given a powerful encoder and a decoder, the model could simply associate one number to each data point and learn the mapping. There are several methods to avoid overfitting such as regularization methods, architectural methods, etc. -->
완전하지 않은<sup>under-complete</sup> 층은 은닉층이 입력을 복사하기에 충분하지 않은 차원을 가지기 때문에 항등함수로 동작할 수 없다는 것을 유의해야 한다. 따라서 완전하지 않은 은닉층은 과잉-완전 은닉층에 비해서 과적합<sup>overfit</sup>할 가능성이 적지만, 여전히 과적합할 수는 있다. 예를 들어서, 강력한 인코더와 디코더가 주어졌을 때, 모델은 단순하게 하나의 숫자를 각각의 데이터 포인트에 연결하고 이 매핑<sup>mapping</sup>을 학습할 수 있다. 정규화 방법<sup>regularization methods</sup>, 아키텍처 방법<sup>architectural methods</sup> 등과 같은 과적합을 방지하는 몇 가지 방법이 있다. 


<!-- ## Denoising autoencoder -->
## 노이즈 제거<sup>Denoising</sup> 오토인코더

<!-- Fig.15 shows the manifold of the denoising autoencoder and the intuition of how it works. -->
그림.15는 노이즈 제거 오토인코더의 매니폴드와 이것이 어떻게 작동하는지 직관적으로 여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>Fig. 15</b>: Denoising autoencoder<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/15_denoising_ae.png" width="500px" /><br>
<b>그림. 15</b>: 노이즈 제거 오토인코더<br>
</center>

<!-- In this model, we assume we are injecting the same noisy distribution we are going to observe in reality, so that we can learn how to robustly recover from it.
By comparing the input and output, we can tell that the points that already on the manifold data did not move, and the points that far away from the manifold moved a lot. -->
이 모델에서는 현실에서 관찰되는 것과 동일한 잡음 분포<sup>noisy distribution</sup>을 주입한다고 가정해서, 이를 통해 견고하게 복구하는 법을 배울 수 있도록 한다. 
입력과 출력을 비교하면, 이미 매니폴드 데이터 위에 있는 포인트들은 움직이지 않았고, 매니폴드에서 멀리 떨어진 포인트들은 많이 움직인 것을 확인할 수 있다. 

<!-- Fig.16 gives the relationship between the input data and output data. -->
그림.16 은 입력 데이터와 출력 데이터 사이의 관계를 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>Fig. 16</b>: Input and output of denoising autoencoder<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/16_relation1.png" width="350px" />
<img src="{{site.baseurl}}/images/week07/07-3/16_relation2.png" width="330px" />
<br>
<b>그림. 16</b>: 노이즈 제거 오토인코더의 입력과 출력<br>
</center>

<!-- We can also use different colours to represent the distance of each input point moves, Fig.17 shows the diagram. -->
또한 다른 색상을 사용해서 각 입력 포인트의 이동 거리를 나타낼 수 있다. 그림. 17은 이 다이어그램<sup>diagram</sup>을 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>Fig. 17</b>: Measuring the traveling distance of the input data<br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/17_distance.png" width="500px" /><br>
<b>그림. 17</b>: 입력 데이터의 이동 거리 측정<br>
</center>

<!-- The lighter the colour, the longer the distance a point travelled. From the diagram, we can tell that the points at the corners travelled close to 1 unit, whereas the points within the 2 branches didn't move at all since they are attracted by the top and bottom branches during the training process. -->
색상이 밝을수록, 데이터 포인트의 이동거리가 길어진다. 다이어그램에서 구석에 있는 점은 1 단위에 가깝게 이동한 반면, 2개 지점<sup>branches</sup> 안의 데이터 포인트들은 훈련 과정 중에 위쪽 및 아래쪽 지점으로부터 끌어당겨<sup>attracted</sup>지므로 전혀 움직이지 않았음을 알 수 있다. 


<!-- ## Contractive autoencoder -->
## 수축형<sup>Contractive</sup> 오토인코더

<!-- Fig.18 shows the loss function of the contractive autoencoder and the manifold. -->
그림.18은 수축형 오토인코더의 손실 함수와 그 매니폴드를 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>Fig. 18</b>: Contractive autoencoder <br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/18_contractive_ae.png" width="500px" /><br>
<b>그림. 18</b>: 수축형 오토인코더 <br>
</center>

<!-- The loss function contains the reconstruction term plus squared norm of the gradient of the hidden representation with respect to the input. Therefore, the overall loss will minimize the variation of the hidden layer given variation of the input. The benefit would be to make the model sensitive to reconstruction directions while insensitive to any other possible directions. -->
손실 함수에는 재건<sup>reconstruction</sup> 항에 입력에 대한 은닉 표현 그래디언트<sup>gradient</sup>의 제곱 놈<sup>norm</sup>을 더한 것이 포함된다. 따라서, 전체 손실은 입력의 변화에 따른 은닉층의 변화를 최소화한다. 이것의 이점은 모델이 재건의 방향에 대해 민감하게 반응하도록 하는 반면, 이 외의 다른 방향으로는 둔감하게 만든다는 것이다. 

<!-- Fig.19 shows how these autoencoders work in general. -->
그림.19는 이러한 오토인코더가 일반적으로 어떻게 작동하는지 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>Fig. 19</b>: Basic autoencoder <br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/19_basic_ae.png" width="500px" /><br>
<b>그림. 19</b>: 기본 오토인코더 <br>
</center>

<!-- The training manifold is a single-dimensional object going in three dimensions. Where $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$, the goal for autoencoder is to stretch down the curly line in one direction, where $\boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$. As a result, a point from the input layer will be transformed to a point in the latent layer. Now we have the correspondence between points in the input space and the points on the latent space but do not have the correspondence between regions of the input space and regions of the latent space. Afterwards, we will utilize the decoder to transform a point from the latent layer to generate a meaningful output layer. -->
훈련 매니폴드는 3차원으로 진행하는 단일 차원<sup>single-dimensional</sup> 개체이다. $\boldsymbol{x}\in \boldsymbol{X}\subseteq\mathbb{R}^{n}$ 에서, 오토인코더의 목표는 구부러진 선을 \boldsymbol{z}\in \boldsymbol{Z}\subseteq\mathbb{R}^{d}$ 에서 한 방향으로 펼치는 것이다. 결과적으로, 입력 레이어의 데이터 포인트가 잠재 레이어의 데이터 포인트로 변환된다. 이제 우리는 입력 공간의 데이터 포인트와 잠재 공간의 데이터 포인트 사이의 대응성<sup>correspondence</sup>을 가지게 되었지만, 입력 공간과 잠재 공간의 영역 사이에는 대응성을 갖고 있지 않다. 다음으로, 디코더를 사용해서 잠재 레이어의 데이터 포인트를 변환해서 의미있는 출력 레이어를 생성한다. 


<!-- ## [Implement autoencoder - Notebook](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s) -->
## [오토인코더 구현 - 노트북](https://www.youtube.com/watch?v=bggWQ14DD9M&t=2491s)

<!-- The Jupyter Notebook can be found [here](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb). -->
이에 대한 주피터 노트북은 [여기](https://github.com/Atcold/pytorch-Deep-Learning/blob/master/10-autoencoder.ipynb)에서 확인할 수 있다.

<!-- In this notebook, we are going to implement a standard autoencoder and a denoising autoencoder and then compare the outputs. -->
이 노트북에서는, 표준 오토인코더와 노이즈 제거 오토인코더를 구현하고 출력을 비교해본다. 


<!-- ### Define autoencoder model architecture and reconstruction loss -->
### 오토인코더 모델 아키텍처 및 재건 손실 정의

<!-- Using $28 \times 28$ image, and a 30-dimensional hidden layer. The transformation routine would be going from $784\to30\to784$. By applying hyperbolic tangent function to encoder and decoder routine, we are able to limit the output range to $(-1, 1)$. Mean Squared Error (MSE) loss will be used as the loss function of this model. -->
$28 \times 28$ 이미지와 30-차원의 은닉층을 사용한다. 변환<sup>transformation</sup> 과정은 $784\to30\to784$ 순서로 진행된다. 쌍곡 탄젠트<sup>hyperbolic tangent</sup> 함수를 인코더와 디코더 과정에 적용해서 출력 범위를 $(-1, 1)$ 으로 제한할 수 있다. 평균 제곱 오차<sup>Mean Squared Error</sup> (MSE) 손실이 해당 모델의 손실 함수로 사용된다. 

```python=
class Autoencoder(nn.Module):
    def __init__(self):
        super().__init__()
        self.encoder = nn.Sequential(
            nn.Linear(n, d),
            nn.Tanh(),
        )
        self.decoder = nn.Sequential(
            nn.Linear(d, n),
            nn.Tanh(),
        )

    def forward(self, x):
        x = self.encoder(x)
        x = self.decoder(x)
        return x

model = Autoencoder().to(device)
criterion = nn.MSELoss()
```


<!-- ### Train standard autoencoder -->
### 표준<sup>Standard</sup> 오토인코더 훈련시키기 

<!-- To train a standard autoencoder using PyTorch, you need put the following 5 methods in the training loop: -->
PyTorch를 사용하여 표준 오토인코더를 훈련시키려면 훈련 루프<sup>loop</sup>에 다음의 5가지 방법을 넣어야 한다:


<!-- #### Going forward: -->
#### 순방향 진행<sup>Going forward</sup>:

<!-- 1) Sending the input image through the model by calling `output = model(img)` . <br>
2) Compute the loss using: `criterion(output, img.data)`. -->
1) `output = model(img)` 를 호출해서 모델을 통해 입력 이미지를 보낸다. <br>
2) `criterion(output, img.data)` 를 사용해서 손실을 계산한다. 


<!-- #### Going backward: -->
#### 역방향 진행<sup>Going backward</sup>:

<!-- 3) Clear the gradient to make sure we do not accumulate the value: `optimizer.zero_grad()`. <br>
4) Back propagation: `loss.backward()`<br>
5) Step backwards: `optimizer.step()` -->
3) `optimizer.zero_grad()` 값이 누적되지 않도록 그래디언트<sup>gradient</sup>를 지운다. <br>
4) 역전파<sup>Back propagation</sup>: `loss.backward()`<br>
5) 뒤로 이동<sup>Step backwards</sup>(역주. 매개변수 업데이트): `optimizer.step()`

<!-- Fig. 20 shows the output of the standard autoencoder. -->
그림. 20은 표준 오토인코더의 출력을 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>Fig. 20</b>: Output of standard autoencoder <br>
</center>
<br/> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/21_output_stae.png" width="500px" /><br>
<b>그림. 20</b>: 표준 오토인코더 출력 <br>
</center>
<br/>


<!-- ### Train denoising autoencoder -->
### 노이즈제거<sup>Denoising</sup> 오토인코더 훈련시키기 

<!-- For denoising autoencoder, you need to add the following steps:<br>
1) Calling `nn.Dropout()` to randomly turning off neurons. <br>
2) Create noise mask: `do(torch.ones(img.shape))`.<br>
3) Create bad images by multiply good images to the binary masks: `img_bad = (img * noise).to(device)`. -->
노이즈제거 오토인코더의 경우, 다음의 단계를 추가해야 한다:<br>
1) `nn.Dropout()` 를 호출해서 무작위로 뉴런을 끄기<sup>randomly turning off neurons</sup>.<br>
2) 노이즈 마스크<sup>mask</sup> 생성하기: `do(torch.ones(img.shape))`.<br>
3) 좋은 이미지<sup>good images</sup>를 바이너리<sup>binary</sup> 마스크에 곱해서 나쁜 이미지<sup>bad images</sup> 만들기: `img_bad = (img * noise).to(device)`.

<!-- Fig. 21 shows the output of the denoising autoencoder. -->
그림. 21은 노이즈제거 오토인코더의 출력을 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>Fig. 21</b>: Output of denoising autoencoder <br>
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/22_out_denoising_ae.png" width="500px" /><br>
<b>그림. 21</b>: 노이즈제거 오토인코더의 출력 <br>
</center>


<!-- ### Kernels comparison -->
### 커널 비교<sup>Kernels comparison</sup>

<!-- It is important to note that in spite of the fact that the dimension of the input layer is $28 \times 28 = 784$, a hidden layer with a dimension of 500 is still an over-complete layer because of the number of black pixels in the image.
Below are examples of kernels used in the trained under-complete standard autoencoder. Clearly, the pixels in the region where the number exists indicate the detection of some sort of pattern, while the pixels outside of this region are basically random. This indicates that the standard autoencoder does not care about the pixels outside of the region where the number is. -->
입력층의 차원이 $28 \times 28 = 784$ 임에도 불구하고, 이미지의 검은색 픽셀의 갯수 때문에 은닉층은 500 차원의 과잉-완전 층임을 알아둘 필요가 있다. 아래는 완전하지 않은<sup>under-complete</sup> 표준 오토인코더에 사용되는 커널의 예시이다. 명확히 확인할 수 있듯이, 숫자가 있는 영역의 픽셀은 일종의 패턴의 감지를 나타내는 반면, 이 영역 바깥의 픽셀은 기본적으로 무작위이다. 이는 표준 오토인코더가 숫자가 있는 영역 외부의 픽셀에 관해서는 신경쓰지 않음을 나타낸다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 22:</b> Standard AE kernels.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_kernels.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>그림 22:</b> 표준 AE 커널들.
</center>

<!-- On the other hand, when the same data is fed to a denoising autoencoder where a dropout mask is applied to each image before fitting the model, something different happens. Every kernel that learns a pattern sets the pixels outside of the region where the number exists to some constant value. Because a dropout mask is applied to the images, the model now cares about the pixels outside of the number’s region. -->
반면에, 모델을 적합<sup>fitting</sup>시키기 전에 드롭아웃 마스크를 각 이미지에 적용한 노이즈제거 오토인코더의 경우 다른 일이 발생한다. 패턴을 학습하는 모든 커널은 숫자가 존재하는 영역 외부의 픽셀을 일정한 값으로 설정한다. 드롭아웃 마스크가 이미지에 적용되자, 모델이 숫자 영역 외부의 픽셀까지 신경을 쓰게 된 것이다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>Figure 23:</b> Denoising AE kernels.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_kernels.png" style="zoom: 50%; background-color:#DCDCDC;" /><br>
<b>그림 23:</b> 노이즈제거 AE 커널들.
</center>

<!-- Compared to the state of the art, our autoencoder actually does better!! You can see the results below. -->
가장 최신의 모델보다<sup>Compared to the state of the art</sup>, 우리의 오토인코더가 실제로 더 작동한다!! 결과는 아래에서 확인할 수 있다. 


<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 24:</b> Input data (MNIST digits).
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/AE_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>그림 24:</b> 입력 데이터 (MNIST 숫자들).
</center>

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 25:</b> Denoising AE reconstructions.
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-3/denoiser_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>그림 25:</b> 노이즈제거 AE 재건<sup>reconstructions</sup>.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/telea_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 26:</b> Telea inpainting output.
</center>

<center>
<img src="{{site.baseurl}}/images/week07/07-3/navier-stokes_output.png" style="zoom: 40%; background-color:#DCDCDC;" /><br>
<b>Figure 27:</b> Navier-Stokes inpainting output.
</center>
