---
lang-ref: ch.07-2
lecturer: Yann LeCun
title: 세부 사항 및 예제가 포함된 SSL, EBM 
authors: Ravi Choudhary， B V Nithish Addepalli, Syed Rahman，Jiayi Du
date: 16 Mar 2020
lang: ko
translation-date: 12 Jul 2020
translator: Yujin
---


<!-- ## Self Supervised Learning-->
## 자기 지도 학습 <sup>Self Supervised Learning</sup>

<!-- Self Supervised Learning (SSL) encompasses both supervised and unsupervised learning.  The objective of the SSL pretext task is to learn a good representation of the input so that it can subsequently be used for supervised tasks. In SSL, the model is trained to predict one part of the data given other parts of the data. For example, BERT was trained using SSL techniques and the Denoising Auto-encoder has particularly shown state-of-the-art results in Natural Language Processing. -->
자기지도 학습은 지도학습과 비지도학습 모두를 포함한다. 자기지도 사전 텍스트 작업<sup>SSL pretext task</sup>의 목적은 입력 데이터를 다시 잘 표현해 내고 이것을 이어지는 지도학습에서 사용할 수 있도록 하는 것이다. 자기지도 학습 모델은 데이터의 일부를 바탕으로 그 나머지를 예측하도록 훈련된다. 예를 들어, BERT는 자기지도 학습 기술을 이용해 학습되었고, Denoising Auto-encoder는 특히 자연어 처리 부문에서 최신의 성과를 보이고 있다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>Fig. 1</b>: Self Supervised Learning
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/1_ssl.png"/><br>
<b>그림. 1</b>: 자기 지도 학습 <sup>Self Supervised Learning</sup>
</center>


<!-- Self Supervised Learning task can be defined as the following:
* Predict the future from the past.
* Predict the masked from the visible.
* Predict any occluded parts from all available parts. -->

자기지도 학습은 과제는 다음과 같은 작업으로 정의 할 수 있다:
* 과거로부터 미래를 예측하는 것.
* 보이는 것을 바탕으로 보이지 않는 것<sup>the masked</sup>을 예측하는 것.
* 가용할 수 있는 모든 부분을 바탕으로 가려진 부분을 예측하는 것.

<!-- For example, if a system is trained to predict the next frame when the camera is moved, the system will implicitly learn about the depth and parallax. This will force the system to learn that objects occluded from its vision do not disappear but continue to exist and the distinction between animate, inanimate objects, and the background. It can also end up learning about intuitive physics like gravity. -->
예를 들어, 카메라가 움직일 때 시스템이 다음 프레임을 예측하도록 학습되면, 이 시스템은 암묵적으로 깊이와 시간의 흐름에 대해 학습한다. 이는 시스템이 시야에서 사라진 물체가 사라지는 것이 아니라 지속적으로 존재한다는 것과 움직이는 물체와 움직이지 않는 물체 그리고 배경을 구분할 수 있도록 한다. 뿐만 아니라 중력과 같은 직관적인 물리학에 대해서도 학습하게 된다. 

<!-- State-of-the-art NLP systems (BERT) pre-train a giant neural network on an SSL task. You remove some of the words from a sentence and make the system predict the missing words. This has been very successful. Similar ideas were also tried out in computer vision realm. As shown in the image below, you can take an image and remove a portion of the image and train the model to predict the missing portion. -->

최신의 NLP 시스템 (BERT)은 거대한 신경망을 사전 학습<sup>pre-train</sup>시키는 데에 자기지도 학습을 이용한다. 문장에서 일부 단어를 제거한 다음에 사전 학습 대상이 되는 시스템이 이 누락된 단어를 예측하도록 한다. 이는 매우 성공적이었다. 비슷한 아이디어가 컴퓨터 비전 분야에서도 시도되었다. 아래의 이미지에서 확인할 수 있듯, 이미지를 촬영하고 그 이미지 일부분을 제거한 다음 모델이 이렇게 누락된 부분을 예측하도록 학습시킬 수 있다.

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>Fig. 2</b>: Corresponding results in computer vision
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/2_cv_eg.png"/><br>
<b>그림. 2</b>: 컴퓨터 비전 부문에서 활용된 예시 결과
</center>

<!-- Although the models can fill in the missing space they have not shared the same level of success as NLP systems. If you were to take the internal representations generated by these models, as input to a computer vision system, it is unable to beat a model that was pre-trained in a supervised manner on ImageNet. The difference here is that NLP is discrete whereas images are continous. The difference in success is because in the discrete domain we know how to represent uncertainty, we can use a big softmax over the possible outputs, in the continuous domain we do not. -->
컴퓨터 비전 부문에서 위와 같은 방식으로 학습된 모델이 누락 된 공간을 채울 수는 있었지만, NLP 시스템과 같은 수준의 성과를 이뤄내지는 못했다. 컴퓨터 비전 시스템에 대한 입력 값으로 이러한 모델에서 생성된 내부 표현을 사용한다면, 이 모델은 ImageNet에서 지도학습 방식으로 사전 학습된 모델을 이길 수 없다. 이 지점에서 NLP와 컴퓨터 비전 시스템 사이의 차이는 NLP는 이산적<sup>discrete</sup>인 반면, 이미지는 연속적<sup>continuous</sup>이라는 것이다. 이산 영역에서 우리는 불확실성을 표현하는 방법을 알고 있고, 가능한 출력에 대해 큰 소프트맥스<sup>softmax</sup>값을 사용할 수 있지만, 연속적 영역에서는 그렇게 할 수 없기 때문에 각 시스템의 성과에 차이가 있었다.

<!-- An intelligent system (AI agent) needs to be able to predict the results of its own action on the surroundings and itself to make intelligent decisions. Since the world is not completely deterministic and there is not enough compute power in a machine/human brain to account for every possibility, we need to teach AI systems to predict in the presence of uncertainty in high dimensional spaces. Energy-based models can be extremely useful for this. -->

지능형 시스템<sup>intelligent system</sup> (AI 에이전트)은 지능적인 결정을 내리기 위해 주변 환경 및 자신에 대한 자체적인 행동의 결과를 예측할 수 있어야 한다. 우리를 둘러싼 세계가 완전히 결정론적이지 않고, 기계와 인간의 두뇌에는 모든 가능성을 설명할 수 있을 만큼의 컴퓨팅 파워가 없기 때문에 우리는 AI 시스템에게 고차원 공간 속의 불확실성 아래에서도 예측을 해 낼 수 있도록 훈련시켜야 한다. 이를 위해 에너지 기반<sup>Energy-based</sup>모델이 굉장히 유용할 수 있다.

<!-- A neural network trained using Least Squares to predict the next frame of a video will result in blurry images because the model cannot exactly predict the future so it learns to average out all possibilities of the next frame from the training data to reduce the loss. -->

비디오의 다음 프레임을 예측하기 위해 최소 제곱<sup>Least Squares</sup>을 사용해 학습된 신경망은 흐릿한 이미지 결과물을 만들어내는데, 이는 모델이 미래를 정확하게 예측할 수 없어서 이에 따른 손실값을 줄이기 위해 훈련 데이터에서 다음 프레임의 모든 가능성을 평균내 버리기 때문이다.

<!-- 
### Latent variable energy-based models as a solution to make predictions for next frame: -->
### 다음 프레임 예측을 위한 잠재 변수 에너지 기반 모델:

<!-- Unlike linear regression, Latent variable energy-based models take what we know about the world as well as a latent variable which gives us information about what happened in reality. A combination of those two pieces of information can be used to make a prediction that will be close to what actually occurs. -->

선형 회귀 분석과 다르게, 잠재 변수 에너지 기반 모델은 우리가 세계에 대해 알고 있는 것 뿐만 아니라 실제에서 일어난 일들에 대한 정보를 제공하는 잠재 변수를 사용한다. 이 두 가지 정보의 조합은 실제로 발생하는 것들에 가까운 예측을 해 내는데 활용될 수 있다.

<!-- These models can be thought of as systems that rate compatibility between the input $x$ and actual output $y$ depending on the prediction using the latent variable that minimizes the energy of the system. You observe input $x$ and produce possible predictions $\bar{y}$  for different combinations of input $x$ and latent variables $z$ and choose the one that minimizes the energy, prediction error, of the system. -->

이러한 모델은 시스템 에너지를 최소화하는 잠재 변수를 이용한 예측을 바탕으로 입력 $x$ 와 실제 출력 $y$ 사이의 호환성을 평가하는 시스템으로 생각할 수 있다. 압력 $x$ 를 관찰하고 이 입력 $x$ 와 잠재 변수들 $z$ 과의 다양한 조합을 이용해 예측값 $\bar{y}$ 를 생성하여 시스템의 에너지, 예측 오류를 최소화 하는 것을 선택한다.  

<!-- Depending upon the latent variable we draw, we can end up with all the possible predictions. The latent variable could be thought of as a piece of important information about the output $y$ that is not present in the input $x$. -->
뽑아내는 잠재 변수에 따라 우리는 가능한 모든 예측값을 얻을 수 있다. 잠재 변수는 입력 $x$ 에 없는 출력 $y$ 와 관련된 중요한 정보로 간주할 수 있다. 

<!-- Scalar-valued energy function can take two versions:
1. Conditional $F(x, y)$ - measure the compatibility between $x$ and $y$
2. Unconditional $F(y)$ -  measure the compatibility between the components of $y$ -->

스칼라 값<sup>scalar-value</sup> 에너지 함수는 두 가지 버전을 가진다:
1. 조건부<sup>conditional</sup> $F(x, y)$ - $x$ 와 $y$ 사이의 호환성을 측정
2. 무조건부<sup>unconditional</sup> $F(y)$ - $y$ 의 구성 요소 사이의 호환성 측정

<!-- ## Training an Energy-Based Model: -->
## 에너지 기반 모델 학습시키기:

<!-- There are two classes of learning models to train an Energy-Based Model to parametrize $F(x, y)$.
1. **Contrastive methods:** Push down on $F(x[i], y[i])$, push up on other points $F(x[i], y')$
2. **Architectural Methods:** Build $Fㄴ(x, y)$ so that the volume of low energy regions is limited or minimized through regularization -->
$F(x, y)$ 를 매개변수화 하기 위한 에너지 기반 모델을 훈련시키는 두 개의 학습 모델 클래스가 있다.
1. **대조적<sup>Contrastive</sup> 방법:** $F(x[i], y[i])$ 을 밀어 내리고, 다른 점들 $F(x[i], y')$ 을 밀어 올리는 것
2. **구조적<sup>Architectural</sup> 방법:** 낮은 에너지 영역의 크기가 정규화를 통해 제한되거나 최소화되는 $F(x, y)$ 를 만들어내는 것 

<!-- There are seven strategies to shape the energy function. The contrastive methods differ in the way they pick the points to push up. While the architectural methods differ in the
the way they limit the information capacity of the code. -->
에너지 함수를 형성하는 일곱개의 전략이 있다. 대조적 방법은 밀어 올릴 점들을 골라내는 방식에서 차이가 발생한다. 반면 구조적 방법은 코드의 정보 용량을 제한하는 방식에서 차이가 있다. 

<!-- An example of the contrastive method is Maximum Likelihood learning. The energy can be interpreted as an unnormalized negative log density. Gibbs distribution gives us the likelihood of y given x. It can be formulated as follows: -->

대조적 방법의 예시는 최대 우도 학습<sup>Maximum Likelihood learning</sup>이다. 에너지는 표준화되지 않은 음의 로그 밀도 함수로 간주될 수 있다. 깁스 분포<sup>Gibbs distribution</sup> 는 x 가 주어진 상태에서 y 의 우도<sup>likelihood</sup> 를 제공한다. 이는 다음과 같은 식으로 표현될 수 있다: 

<!-- $$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$ -->
$$
P(Y \mid W) = \frac{e^{-\beta E(Y,W)}}{\int_{y}e^{-\beta E(y,W)}}
$$

<!-- Maximum likelihood tries to make the numerator big and the denominator small to maximize the likelihood. This is equivalent to minimizing $-\log(P(Y \mid W))$ which is given below -->
최대 우도는 분자를 크게하고, 분모를 작게해서 우도 값을 최대화 하고자 한다. 이는 아래에서 주어진 것과 같이 $-\log(P(Y \mid W))$ 을 최소화 하는 것과 같다. 

$$
L(Y, W) = E(Y,W) + \frac{1}{\beta}\log\int_{y}e^{-\beta E(y,W)}
$$

<!-- Gradient of the negative log likelihoood loss for one sample Y is as follows: -->
하나의 샘플 Y에 대한 음의 로드 우도 손실<sup>negative log likelihood loss</sup>의 경사값은 다음과 같다:

$$
\frac{\partial L(Y, W)}{\partial W} = \frac{\partial E(Y, W)}{\partial W} - \int_{y} P(y\mid W) \frac{\partial E(y,W)}{\partial W}
$$

<!-- In the above gradient, the first term of the gradient at the datapoint $Y$ and the second term of the gradient gives us the expected value of the gradient of the energy overall $Y$s. Hence, when we perform gradient descent the first term tries to reduce energy given to the datapoint $Y$ and the second term tries to increase the energy given to all other $Y$s. -->
위의 경사값에서, 데이터포인트 $Y$ 의 경사값에서의 첫 번째와 두 번째 항은 전체 $Y$s 에 대한 에너지 기댓값을 제공한다. 즉, 우리가 경사 하강법을 적용할 때 첫 번째 항은 주어진 데이터포인트 $Y$에 대해서 에너지를 줄이려고 하고, 두 번째 항은 다른 모든 $Y$s 를 바탕으로 에너지를 증가시키려고 한다. 

<!-- The gradient of the energy function is generally very complex and hence computing, estimating or approximating the integral is a very interesting case as it is intractable in most of the cases. -->
에너지 함수의 기울기는 대체로 매우 복잡하고, 따라서 이것의 적분을 계산하고, 추정하고, 근사하는 것은 대부분의 경우 다루기가 어려워서<sup>intractable</sup> 굉장히 흥미로운 케이스가 된다.  



<!-- ## Latent Variable Energy-Based Model -->
## 잠재 변수 에너지 기반 모델

<!-- 
The main advantage of Latent variable models is that they allow multiple predictions through the latent variable. As $z$ over a set, $y$ varies over the manifold of possible predictions. Some examples include:
1. K-means
2. Sparse modeling
3. [GLO](https://arxiv.org/abs/1707.05776) -->

잠재 변수 모델의 주요 장점은 잠재 변수를 이용한 다양한 예측이 가능하다는 것이다. $z$ 가 어떤 집합 안에서 변함에 따라, $y$ 는 가능한 예측값을 원소로 하는 매니폴드(다양체)<sup>manifold</sup> 에서 변화한다. 이에 대한 몇가지 예는 다음과 같다:
1. K-means
2. 희소 데이터 모델링<sup>Sparse modeling</sup>
3. [GLO](https://arxiv.org/abs/1707.05776)

<!-- These can be of two types:
1. Conditional models where $y$ depends on $x$
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2. Unconditional models that have scalar-valued energy function, F(y) that measures the compatibility between the components of y
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$ -->

이는 아래의 두 종류 중 하나이다:
1.  $y$ 가 $x$ 의 종속 변수인 조건부<sup>conditional</sup> 모델 
    1. $$F(x,y) = \text{min}_{z} E(x,y,z)$$
    2. $$F_\beta(x,y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(x,y,z)}$$
2.  y 사이의 호환성을 측정하는 스칼라 값의 에너지 함수 F(y), 무조건부<sup>unconditional</sup> 모델
    1. $$F(y) = \text{min}_{z} E(y,z)$$
    2. $$F_\beta(y) = -\frac{1}{\beta}\log\int_z e^{-\beta E(y,z)}$$

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>Fig. 3</b>: Latent Variable EBM
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/3_lv_ebm.png" width="50%"/><br>
<b>그림. 3</b>: 잠재 변수 EBM
</center>

<!-- ## Latent Variable EBM example: K-means -->
## 잠재 변수 EBM 예시: K-means

<!-- K-means is a simple clustering algorithm that can also be considered as an energy-based model where we are trying to model the distribution over $y$. The energy function is $E(y,z) = \Vert y-Wz \Vert^2$ where $z$ is a $1$-hot vector. -->
K-means는 간단한 클러스터링 알고리즘으로써 $y$ 의 분포르 모델링 하려 하는 에너지 기반 모델로도 간주될 수 있다. 에너지 함수는  $z$ 가 원-핫<sup>one-hot</sup> 벡터인 $E(y,z) = \Vert y-Wz \Vert^2$ 이다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>Fig. 4</b>: K-means example
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/4_kmeans.png" width="50%"/><br>
<b>그림. 4</b>: K-means 예시
</center>

<!-- Given a value of $y$ and $k$, we can do inference by figuring out which of the $k$ possible columns of $W$ minimizes the reconstruction error or energy function. To train the algorithm, we can adopt an approach where we can find $z$ to choose the column of $W$ closest to $y$ and then try to get even closer by taking a gradient step and repeat the process. However, coordinate gradient descent actually works better and faster. -->

 $y$ 와 $k$ 값이 주어지면, $W$ 의 어떤 $k$ 개 가능한 열<sup>columns</sup> 들이 재구성<sup>reconstruction</sup> 오류 혹은 에너지 함수를 최소화 하는지 파악하여 추론할 수 있다. 알고리즘 훈련을 위해서, $z$ 를 찾아서 $y$ 와 가장 가까운 $W$ 의 열을 선택하고 여기서 경사하강법<sup>GD</sup>을 수행하고 이 과정을 반복하여 목표하는 최솟값으로 더 가까이 접근하는 방식을 채택할 수 있다. 그러나, 좌표<sup>coordinate</sup> 경사 하강법은 실제로 더 빠르고 효과적으로 작동한다.

<!-- 
In the plot below we can see the data points along the pink spiral. The black blobs surrounding this line corresponds to quadratic wells around each of the prototypes of W. -->

아래의 그림에서 분홍색 나선 주변의 데이터 포인트를 관찰할 수 있다. 이 선을 둘러싼 검은 얼룩 자국은 W에 따른 각 프로토타입 모델 주변의 quadratic wells에 해당한다.  

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>Fig. 5</b>: Spiral plot
</center> -->
<center>
<img src="{{site.baseurl}}/images/week07/07-2/5_spiral.png" width="50%"/><br>
<b>그림. 5</b>: 나선형 그림
</center>

<!-- Once, we learn the energy function, we can begin to address questions like:
1. Given a point $y_1$, can we predict $y_2$?
2. Given $y$, can we find the closest point on the data manifold? -->

에너지 함수에 대해 알게되면, 다음과 같은 질문에 대해 답을 할 수 있게된다:
1. $y_1$ 의 점이 주어졌을 때, $y_2$ 를 예측해 낼 수 있는가?
2. $y$ 가 주어졌을 때, 이 데이터 매니폴드<sup>manifold</sup> 와 가장 가까운 점을 찾아낼 수 있는가? 

<!-- K-means belongs to architectural methods (as opposed to contrastive methods). Hence we do not push up the energy anywhere, all we do is push the energy down in certain regions. One disadvantage is that once the value of $k$ has been decided, there can only be $k$ points that have $0$ energy, and every other point will have higher energy that grows quadratically as we move away from them. -->

K-means 는  (대조적 방법과 반대인) 구조적 방법에 속한다. 따라서 우리는 에너지를 아무데나 밀어 올리지 않고, 특정 지역의 에너지를 낮춘다. 한 가지 단점은 $k$ 의 값이 결정되면, 에너지 값이 $0$ 인 데이터 포인트가 단 $k$ 로 한정된다는 것과, 다른 모든 포인트의 에너지 값은 그 데이터 포인트에서 멀어질수록 이차적으로<sup>quadratically</sup> 증가하는 높은 값을 갖는다는 점이다.  

<!-- ## Contrastive Methods -->
## 대조적 방법

<!-- According to Dr Yann LeCun, everyone will be using architectural methods at some point, but at this moment, it is contrastive methods that work for images. Consider the figure below which shows us some data points and contours of the energy surface. Ideally, we want the energy surface to have the lowest energy on the data manifold. Hence what we would like to do is lower the energy (i.e. the value of F(x,y))around the training example, but this alone may not be enough. Hence we also raise it for the $y$'s in the region that should have high energy but has low energy. -->

얀 르쿤 박사에 따르면 모든 사람이 언젠가는 구조적 방법을 사용할 것이지만, 현 시점에서는 이미지 데이터에 대해 잘 동작하는 것은 대조적 방법이다. 에너지 표면의 윤곽<sup>contours</sup>과 데이터 포인트들을 보여주는 아래 그림을 참고하자. 이상적으로, 우리는 에너지 표현이 데이터 매니폴드 위에서 최소의 에너지를 갖기를 바란다. 따라서 에너지 훈련 예제 주변의 에너지 값 (즉, F(x,y)의 값) 을 낮추려고 하지만 , 이것 만으로는 충분하지 않을 수 있다. 따라서 높은 에너지값을 가져야 하는데 낮은 에너지값을 가지고 있는 부분의 $y$ 값을 올린다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>Fig. 6</b>: Contrastive methods
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/6_contrastive_1.png" width="50%"/><br>
<b>그림. 6</b>: 대조적 방법
</center>

<!-- There are several ways to find these candidates $y$'s that we want to raise energy for. Some examples are:
1. Denoising Autoencoder
2. Contrastive Divergence
3. Monte Carlo
4. Markov Chain Monte Carlo
5. Hamiltonian Monte Carlo -->

우리가 에너지 값을 높이고자 하는 $y$ 후보들을 찾는 몇 가지 방법이 있다. 이 방법의 몇 가지 예시는 다음과 같다:
1. Denoising Autoencoder<sup>디노이징 오토인코더</sup>
2. Contrastive Divergence<sup>대조 발산</sup>
3. 몬테 카를로<sup>Monte Carlo</sup>
4. 마르코프 체인 몬테 카를로<sup>Markov Chain Monte Carlo</sup>
5. 해밀토니안 몬테 카를로<sup>Hamiltonian Monte Carlo</sup>

<!-- We will briefly discuss Denoising Autoencoders and Contrastive Divergence. -->
Denoising Autoencoders와 Constrasive Divergence에 대해 간단히 설명하겠다. 

<!-- ### Denoising Autoencoder (DAE) -->
### Denoising Autoencoder (DAE) 

<!-- One way of finding $y$'s to increase energy for it by randomly perturbing the training example as shown by the green arrows in the plot below. -->
$y$ 를 찾는 방법 중의 하나는 아래의 그림에서 녹색 화살표로 표시된 것과 같이 훈련 예제 무작위로 교란시켜 에너지를 높이는 것이다.  

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>Fig. 7</b>: Topographic map
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/7_contrastive_2.png" width="50%"/><br>
<b>그림. 7</b>: 지형도<sup>Topographic map</sup>
</center>
<!-- 
Once we have a corrupted data point, we can push the energy up here. If we do this sufficiently many times for all the data points, the energy sample will curl up around the training examples. The following plot illustrates how training is done. -->

데이터 포인트가 손상되면<sup>corrupted</sup>, 에너지를 여기로 올릴 수 있다. 이러한 작업을 모든 데이터 포인트에 대해서 충분히 많은 횟수로 실행하면, 에너지 샘플이 훈련 예제를 중심으로 모인다. 이어지는 그림은 이 훈련이 어떻게 이뤄지는지 보여준다. 

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>Fig. 8</b>: Training
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/8_training.png" width="50%"/><br>
<b>그림. 8</b>: 훈련 과정
</center>

<!-- Steps for training:
1. Take a point $y$ and corrupt it
2. Train the Encoder and Decoder to reconstruct the original data point from this corrupted data point -->

훈련 단계:
1. $y$ 점을 하나 잡고 이것을 손상시킴
2. 이렇게 손상된 데이터 포인트에서 원본 데이터를 재구성해 낼 수 있도록 인코더<sup>Encoder</sup>와 디코더<sup>Decoder</sup>를 훈련시킴
<!-- 
If the DAE is properly trained, the energy grows quadratically as we move away from the data manifold. -->
만일 DAE 이 올바르게 훈련 되면, 데이터 매니폴드에서 멀어짐에 따라 에너지 값이 2차적으로<sup>quadraticallly</sup> 증가한다.  
The following plot illustrates how we use the DAE.

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>Fig. 9</b>: How DAE is used
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/9_dae_use.png" width="50%"/><br>
<b>그림. 9</b>: DAE가 이용되는 방식
</center>


### BERT
<!-- 
BERT is trained similarly, except that the space is discrete as we are dealing with text. The corruption technique consists of masking some of the words and the reconstuction step consists of trying to predict these. Hence, this is also called a masked autoencoder. -->

BERT 는 텍스트를 이산적인 공간에서 처리하였다는 점을 제외하면 비슷한 방식으로 훈련되었다. 손상 기법<sup>the corruption technique</sup>은 일부 단어를 가리고<sup>masking</sup> 재구성 단계에서 이를 예측하는 방식으로 구성된다. 따라서 이는 masked autoencoder<sup>마스킹된 오코인코더</sup>라고도 부른다. 

<!-- ### Contrastive Divergence -->
### Contrastive Divergence


<!-- Contrastive Divergence presents us with a smarter way to find the $y$ point that we want to push up the energy for. We can give a random kick to our training point and then move down the energy function using gradient descent. At the end of the trajectory, we push up the energy for the point we land on. This is illustrated in the plot below using the green line. -->
Contrastive Divergence 는 우리가 에너지를 끌어올리고자 하는 $y$ 를 더 똑똑하게 찾는 방법을 제시한다. 훈련 지점에 임의의 킥<sup>kick</sup>을 주고 경사 하강법을 이용해 에너지 함수를 낮춘다. 궤도의 끝에서, 우리가 착지하는 지점의 에너지 값을 증가시킨다. 이 과정은 아래의 그림에서 녹색 선을 통해 표현된다.  

<!-- <center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>Fig. 10</b>: Contrastive Divergence
</center> -->

<center>
<img src="{{site.baseurl}}/images/week07/07-2/10_contrastive_div.png" width="50%"/><br>
<b>그림. 10</b>: Contrastive Divergence
</center>
